/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.EntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.occ.ocbase.common.util.CommonUtils;
import kd.occ.ocpos.business.inventory.AbstractTaxAlgorithm;

public class TaxAlgorithmForForm
extends AbstractTaxAlgorithm {
    protected static Log log = LogFactory.getLog(TaxAlgorithmForForm.class);
    protected IFormView view;
    protected IDataModel model;
    public static final BigDecimal MAX_BIGDECIMAL_VALUE = new BigDecimal("9999999999999.99");

    public void calByChange(PropertyChangedArgs e) {
        block4: {
            ChangeData[] valueSet;
            String fieldName;
            block3: {
                fieldName = e.getProperty().getName();
                valueSet = e.getChangeSet();
                if (!TaxAlgorithmForForm.isExistField(this.model, "entryentity", fieldName)) break block3;
                for (int i = 0; i < valueSet.length; ++i) {
                    int rowIndex = valueSet[i].getRowIndex();
                    this.model.beginInit();
                    boolean hasCal = this.calByEntryChange(fieldName, rowIndex);
                    this.model.endInit();
                    if (!hasCal) continue;
                    TaxAlgorithmForForm.updateViewRow(this.view, rowIndex, "entryentity");
                }
                break block4;
            }
            if (!TaxAlgorithmForForm.isExistField(this.model, fieldName)) break block4;
            for (int i = 0; i < valueSet.length; ++i) {
                this.model.beginInit();
                boolean hasCal = this.calByChange(fieldName);
                this.model.endInit();
                if (!hasCal) continue;
                int entrySize = this.getEntrySize();
                for (int j = 0; j < entrySize; ++j) {
                    TaxAlgorithmForForm.updateViewRow(this.view, j, "entryentity");
                }
            }
        }
    }

    public TaxAlgorithmForForm(IFormView view) {
        this.view = view;
        this.model = view.getModel();
        this.initPrecision();
    }

    @Override
    public void setValue(String key, Object value) {
        this.model.setValue(key, value);
    }

    @Override
    public void setValue(String key, Object value, int i) {
        if (value instanceof BigDecimal) {
            TaxAlgorithmForForm.showBigDecimalErrorTip(this.model, (BigDecimal)value, key);
        }
        DynamicObjectCollection entrys = this.model.getEntryEntity("entryentity");
        ((DynamicObject)entrys.get(i)).set(key, value);
    }

    @Override
    public Object getValue(String key) {
        return this.model.getValue(key);
    }

    @Override
    public Object getValue(String key, int i) {
        DynamicObjectCollection entrys = this.model.getEntryEntity("entryentity");
        return ((DynamicObject)entrys.get(i)).get(key);
    }

    @Override
    protected int getEntrySize() {
        DynamicObjectCollection billEntry = this.model.getEntryEntity("entryentity");
        return billEntry.size();
    }

    public static boolean isExistField(IDataModel bill, String fieldName) {
        boolean isExist = false;
        IDataEntityProperty dataEntiryProperty = bill.getDataEntityType().findProperty(fieldName);
        if (dataEntiryProperty != null) {
            isExist = true;
        }
        return isExist;
    }

    public static boolean isExistField(IDataModel bill, String entryName, String fieldName) {
        Map type = bill.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get(entryName);
        Map map = entityType.getFields();
        boolean isExist = false;
        for (Map.Entry field : map.entrySet()) {
            if (!fieldName.equals(field.getKey())) continue;
            isExist = true;
            break;
        }
        return isExist;
    }

    public static void updateViewRow(IFormView view, int index, String entryField) {
        IDataModel model = view.getModel();
        Map type = model.getDataEntityType().getAllEntities();
        EntityType entityType = (EntityType)type.get(entryField);
        Map map = entityType.getFields();
        for (Map.Entry field : map.entrySet()) {
            String key = (String)field.getKey();
            TaxAlgorithmForForm.updateViewCell(view, index, entryField, key);
        }
    }

    private static void updateViewCell(IFormView view, int index, String entryField, String key) {
        IDataModel model = view.getModel();
        if (TaxAlgorithmForForm.isExistField(model, entryField, key) && !CommonUtils.isNull((Object)view.getControl(key))) {
            view.updateView(key, index);
        }
    }

    public static void showBigDecimalErrorTip(IDataModel model, BigDecimal qtyAll, String key) {
        String langName = RequestContext.get().getLang().name();
        IDataEntityProperty property = model.getProperty(key);
        String displayName = (String)property.getDisplayName().get((Object)langName);
        if (qtyAll.compareTo(MAX_BIGDECIMAL_VALUE) > 0) {
            throw new KDBizException(displayName + "\u8d85\u8fc7\u7cfb\u7edf\u9884\u5236\u6700\u5927\u503c[9999999999999]\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u76f8\u5173\u6570\u636e\uff01");
        }
    }
}

