/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;

public class VisualiZationHelper {
    public static void updataSaleOrderValue(String entityName, List<Object> subEntryIds, String key, Object value) {
        if (StringUtils.equals((CharSequence)key, (CharSequence)"signstatus") && StringUtils.equals((CharSequence)entityName, (CharSequence)"ocpos_saleorder_return")) {
            return;
        }
        QFilter qFilter = new QFilter("goodsentryentity.salesorderdelivery.id", "in", subEntryIds);
        DynamicObject[] saleOrders = BusinessDataServiceHelper.load((String)entityName, (String)("salestatus,orderstatus,salesorderdelivery," + key + "," + "goodsentryentity" + "," + "entrysrcbillno"), (QFilter[])qFilter.toArray());
        HashSet<String> srcBillNoList = new HashSet<String>(0);
        for (DynamicObject saleOrder : saleOrders) {
            DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            if (goodsEntryEntity == null) {
                return;
            }
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
                for (DynamicObject delivery : salesOrderDelivery) {
                    if (!subEntryIds.contains(delivery.getPkValue())) continue;
                    delivery.set(key, value);
                    String entrySrcBillNo = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"entrysrcbillno");
                    if (!StringUtils.isNotBlank((CharSequence)entrySrcBillNo)) continue;
                    srcBillNoList.add(entrySrcBillNo);
                }
            }
        }
        if (StringUtils.equals((CharSequence)key, (CharSequence)"deliverystatus")) {
            VisualiZationHelper.updateSaleOrderChange(entityName, srcBillNoList, value);
        }
        if ("deliverystatus".equals(key)) {
            VisualiZationHelper.checkSaleOrderDelivery(saleOrders, value);
        }
        SaveServiceHelper.update((DynamicObject[])saleOrders);
    }

    private static void updateSaleOrderChange(String entryName, Set<String> saleOrderNos, Object value) {
        String srcSaleOption = "";
        if (StringUtils.equals((CharSequence)entryName, (CharSequence)"ocpos_saleorder")) {
            srcSaleOption = "1";
        } else if (StringUtils.equals((CharSequence)entryName, (CharSequence)"ocpos_saleorder_return")) {
            srcSaleOption = "0";
        }
        QFilter qFilter = new QFilter("billno", "in", saleOrderNos);
        DynamicObject[] changeSaleOrders = BusinessDataServiceHelper.load((String)"ocpos_salechange", (String)"saleoption,salesorderdelivery,deliverystatus,goodsentryentity", (QFilter[])qFilter.toArray());
        if (changeSaleOrders.length != 0) {
            for (DynamicObject changeSaleOrder : changeSaleOrders) {
                DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)changeSaleOrder, (String)"goodsentryentity");
                if (goodsEntryEntity == null) {
                    return;
                }
                for (DynamicObject goodsEntry : goodsEntryEntity) {
                    String saleOption = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"saleoption");
                    if (!StringUtils.equals((CharSequence)saleOption, (CharSequence)srcSaleOption)) continue;
                    DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
                    for (DynamicObject delivery : salesOrderDelivery) {
                        delivery.set("deliverystatus", value);
                    }
                }
            }
        }
        SaveServiceHelper.update((DynamicObject[])changeSaleOrders);
    }

    private static void checkSaleOrderDelivery(DynamicObject[] saleOrders, Object value) {
        for (DynamicObject saleOrder : saleOrders) {
            boolean isEqual = true;
            DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            if (goodsEntryEntity == null) {
                return;
            }
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goodsEntry, (String)"salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)salesOrderDelivery)) {
                    return;
                }
                for (DynamicObject delivery : salesOrderDelivery) {
                    Long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)delivery, (String)"deliverystatus"));
                    if (ObjectUtils.nullSafeEquals((Object)DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)value)), (Object)pkValue)) continue;
                    isEqual = false;
                }
            }
            if (isEqual && DeliveryStatus.SALE_SIGNED.equals(DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)value)))) {
                saleOrder.set("orderstatus", (Object)"D");
                continue;
            }
            if (!isEqual || !DeliveryStatus.RETURN_HAVE_PICK.equals(DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)value)))) continue;
            String saleStatus = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"salestatus");
            if (StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S")) {
                saleOrder.set("orderstatus", (Object)"D");
                continue;
            }
            saleOrder.set("orderstatus", (Object)"G");
        }
    }

    public static void updataRetailOrderStatus(List<Object> subEntryIds, String key, Object value) {
        DynamicObject[] retailOrders;
        QFilter qFilter = new QFilter("entryentity.ribilldelivery.srcdeliveryentryid", "in", subEntryIds);
        for (DynamicObject retailOrder : retailOrders = BusinessDataServiceHelper.load((String)"ocococ_retailbill", (String)VisualiZationHelper.getRetailOrderFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)retailOrder, (String)"entryentity");
            if (goodsEntryEntity == null) {
                return;
            }
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goodsEntry, (String)"ribilldelivery");
                if (salesOrderDelivery == null) {
                    return;
                }
                for (DynamicObject delivery : salesOrderDelivery) {
                    if (!subEntryIds.contains(DynamicObjectUtils.get((DynamicObject)delivery, (String)"srcdeliveryentryid"))) continue;
                    delivery.set(key, value);
                }
            }
        }
        if ("deliverystatus".equals(key)) {
            VisualiZationHelper.checkRetailOrderDelivery(retailOrders, value);
        }
        SaveServiceHelper.update((DynamicObject[])retailOrders);
    }

    private static void checkRetailOrderDelivery(DynamicObject[] retailOrders, Object value) {
        for (DynamicObject retailOrder : retailOrders) {
            boolean isEqual = true;
            DynamicObjectCollection goodsEntryEntity = retailOrder.getDynamicObjectCollection("entryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goodsEntry, (String)"ribilldelivery");
                if (CollectionUtils.isEmpty((Collection)salesOrderDelivery)) {
                    return;
                }
                for (DynamicObject delivery : salesOrderDelivery) {
                    DynamicObject deliveryDyo = DynamicObjectUtils.getDynamicObject((DynamicObject)delivery, (String)"deliverystatus");
                    Long pkValue = DynamicObjectUtils.getPkValue((DynamicObject)deliveryDyo);
                    if (((DynamicObject)value).getPkValue().equals(pkValue)) continue;
                    isEqual = false;
                }
            }
            if (!isEqual || !DeliveryStatus.SALE_OUTBOUND.equals(DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)value)))) continue;
            retailOrder.set("orderstatus", (Object)"D");
        }
    }

    public static void updataDeliveryOrderStatus(List<Object> subEntryIds, DynamicObject deliveryStatus) {
        DynamicObject[] deliveryOrders;
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", subEntryIds);
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)VisualiZationHelper.getFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)deliveryOrder, (String)"entryentity");
            if (entryEntity == null) {
                return;
            }
            deliveryOrder.set("deliveryallstatus", (Object)deliveryStatus);
            for (DynamicObject entry : entryEntity) {
                if (!subEntryIds.contains(DynamicObjectUtils.get((DynamicObject)entry, (String)"corebillentryid"))) continue;
                entry.set("deliverystatus", (Object)deliveryStatus);
            }
        }
        SaveServiceHelper.update((DynamicObject[])deliveryOrders);
    }

    public static void updataSignStatus(List<Object> subEntryIds, String signStatus) {
        DynamicObject[] deliveryOrders;
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", subEntryIds);
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)VisualiZationHelper.getFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)deliveryOrder, (String)"entryentity");
            if (entryEntity == null) {
                return;
            }
            deliveryOrder.set("signallstatus", (Object)signStatus);
            for (DynamicObject entry : entryEntity) {
                entry.set("signstatus", (Object)signStatus);
            }
            DynamicObjectCollection logisticsInfo = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)deliveryOrder, (String)"logisticsinfo");
            if (logisticsInfo == null) {
                return;
            }
            for (DynamicObject entry : logisticsInfo) {
                entry.set("lsc_signstatus", (Object)signStatus);
                if (!signStatus.equals("D")) continue;
                entry.set("receivingdate", (Object)TimeServiceHelper.now());
            }
        }
        SaveServiceHelper.update((DynamicObject[])deliveryOrders);
    }

    public static void updataReturnDataToDeliveryOrder(List<Object> subEntryIds, DynamicObject returnData) {
        DynamicObject[] deliveryOrders;
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", subEntryIds);
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)VisualiZationHelper.getFileds(), (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection logiSticsInfoEntity = deliveryOrder.getDynamicObjectCollection("logisticsinfo");
            logiSticsInfoEntity.clear();
            DynamicObject logiSticsInfo = new DynamicObject(logiSticsInfoEntity.getDynamicObjectType());
            logiSticsInfo.set("arrivaldate", (Object)DynamicObjectUtils.getDate((DynamicObject)returnData, (String)"arrivaldate"));
            logiSticsInfo.set("logisticcomp", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)returnData, (String)"logisticscompany"));
            logiSticsInfo.set("logisticsbill", DynamicObjectUtils.get((DynamicObject)returnData, (String)"logisticsbill"));
            logiSticsInfo.set("driver", DynamicObjectUtils.get((DynamicObject)returnData, (String)"driver"));
            logiSticsInfo.set("drivertel", DynamicObjectUtils.get((DynamicObject)returnData, (String)"drivertel"));
            logiSticsInfo.set("carno", DynamicObjectUtils.get((DynamicObject)returnData, (String)"carno"));
            logiSticsInfo.set("lsc_signstatus", (Object)"B");
            logiSticsInfo.set("infodescription", DynamicObjectUtils.get((DynamicObject)returnData, (String)"infodescription"));
            logiSticsInfoEntity.add((Object)logiSticsInfo);
        }
        SaveServiceHelper.save((DynamicObject[])deliveryOrders);
    }

    public static boolean checkOrderDelivery(ListSelectedRowCollection selectedRowCollection, String entityName, String deliveryStatusId) {
        DynamicObject[] saleOrders;
        boolean isAllow = false;
        List saleOrderSubEntryIds = selectedRowCollection.stream().map(ListSelectedRow::getSubEntryPrimaryKeyValue).distinct().collect(Collectors.toList());
        QFilter qFilter = new QFilter("goodsentryentity.salesorderdelivery.id", "in", saleOrderSubEntryIds);
        for (DynamicObject saleOrder : saleOrders = BusinessDataServiceHelper.load((String)entityName, (String)"salesorderdelivery,deliverystatus,goodsentryentity", (QFilter[])qFilter.toArray())) {
            DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                DynamicObjectCollection salesOrderDelivery = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goodsEntry, (String)"salesorderdelivery");
                for (DynamicObject delivery : salesOrderDelivery) {
                    DynamicObject deliveryStatus;
                    if (!saleOrderSubEntryIds.contains(delivery.getPkValue()) || !(deliveryStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)delivery, (String)"deliverystatus")).getPkValue().toString().equals(deliveryStatusId)) continue;
                    isAllow = true;
                }
            }
        }
        return isAllow;
    }

    private static String getFileds() {
        return String.join((CharSequence)",", "logisticsinfo", "arrivaldate", "logisticcomp", "logisticsbill", "driver", "drivertel", "carno", "lsc_signstatus", "infodescription", "deliveryallstatus", "signallstatus", "entryentity", "deliverystatus", "receivingdate", "signstatus", "corebillentryid");
    }

    private static String getRetailOrderFileds() {
        return String.join((CharSequence)",", "entryentity", "ribilldelivery", "deliverystatus", "signstatus", "srcdeliveryentryid", "orderstatus");
    }

    public static List<Object> getAllSubEntryIdFormSingle(String entityNumber, List<Object> subEntryIds) {
        ArrayList<Object> allSubEntryIds = new ArrayList<Object>();
        QFilter qFilter = new QFilter("entryentity.corebillentryid", "in", subEntryIds);
        DynamicObject[] deliveryOrders = BusinessDataServiceHelper.load((String)"ocococ_deliveryorder", (String)VisualiZationHelper.getFileds(), (QFilter[])qFilter.toArray());
        if (deliveryOrders == null || deliveryOrders.length == 0) {
            return allSubEntryIds;
        }
        for (DynamicObject deliveryOrder : deliveryOrders) {
            DynamicObjectCollection entryEntity = deliveryOrder.getDynamicObjectCollection("entryentity");
            for (DynamicObject entryEntityRow : entryEntity) {
                allSubEntryIds.add(entryEntityRow.get("corebillentryid"));
            }
        }
        if (StringUtils.equals((CharSequence)entityNumber, (CharSequence)"ocpos_saleorder")) {
            QFilter qFilter1 = new QFilter("goodsentryentity.salesorderdelivery.id", "in", allSubEntryIds);
            qFilter1.and("goodsentryentity.mustretqty", "=", (Object)BigDecimal.ZERO);
            DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)entityNumber, (String)"goodsentryentity.salesorderdelivery", (QFilter[])qFilter1.toArray());
            if (!CollectionUtils.isEmpty((Collection)dynamicObjectCollection)) {
                List removeEntryIds = dynamicObjectCollection.stream().map(s -> s.get("goodsentryentity.salesorderdelivery")).collect(Collectors.toList());
                allSubEntryIds.removeAll(removeEntryIds);
            }
        }
        return allSubEntryIds;
    }

    public static void updateSaleOrderStatusAndChange(DynamicObject deliveryStatus, List<Object> saleOrderSubEntryIds, String entityName) {
        QFilter fFilter = new QFilter("goodsentryentity.salesorderdelivery.id", "in", saleOrderSubEntryIds);
        Object[] saleOrderArray = null;
        if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ocpos_saleorder")) {
            saleOrderArray = BusinessDataServiceHelper.load((String)entityName, (String)"orderstatus,sourcebillid,goodsentryentity,srcbiztype,saleoption,salesorderdelivery,deliverystatus", (QFilter[])fFilter.toArray());
        } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ocpos_saleorder_return")) {
            saleOrderArray = BusinessDataServiceHelper.load((String)entityName, (String)"orderstatus,sourcebillid,goodsentryentity,srcbillbiztype,saleoption,salesorderdelivery,deliverystatus", (QFilter[])fFilter.toArray());
        }
        if (!ArrayUtils.isEmpty((Object[])saleOrderArray)) {
            for (Object saleOrder : saleOrderArray) {
                DynamicObjectCollection salesOrderDelivery;
                DynamicObjectCollection goodEntry;
                DynamicObject changeSaleOrder;
                String orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus((DynamicObject)saleOrder);
                saleOrder.set("orderstatus", (Object)orderStatus);
                String srcBizType = "";
                if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ocpos_saleorder")) {
                    srcBizType = saleOrder.getString("srcbiztype");
                } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ocpos_saleorder_return")) {
                    srcBizType = saleOrder.getString("srcbillbiztype");
                }
                if (!StringUtils.equals((CharSequence)srcBizType, (CharSequence)"H") || (changeSaleOrder = BusinessDataServiceHelper.loadSingle((String)"ocpos_salechange", (String)"orderstatus,goodsentryentity,salesorderdelivery,saleoption,deliverystatus", (QFilter[])(fFilter = new QFilter("id", "=", saleOrder.get("sourcebillid"))).toArray())) == null) continue;
                if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ocpos_saleorder")) {
                    changeSaleOrder.set("orderstatus", (Object)orderStatus);
                    goodEntry = changeSaleOrder.getDynamicObjectCollection("goodsentryentity");
                    if (!CollectionUtils.isEmpty((Collection)goodEntry)) {
                        for (DynamicObject goodEntity : goodEntry) {
                            if (!StringUtils.equals((CharSequence)goodEntity.getString("saleoption"), (CharSequence)"1")) continue;
                            salesOrderDelivery = goodEntity.getDynamicObjectCollection("salesorderdelivery");
                            for (DynamicObject salesOrderDeliveryEntity : salesOrderDelivery) {
                                salesOrderDeliveryEntity.set("deliverystatus", (Object)deliveryStatus);
                            }
                        }
                    }
                } else if (StringUtils.equals((CharSequence)entityName, (CharSequence)"ocpos_saleorder_return") && !CollectionUtils.isEmpty((Collection)(goodEntry = changeSaleOrder.getDynamicObjectCollection("goodsentryentity")))) {
                    for (DynamicObject goodEntity : goodEntry) {
                        if (!StringUtils.equals((CharSequence)goodEntity.getString("saleoption"), (CharSequence)"0")) continue;
                        salesOrderDelivery = goodEntity.getDynamicObjectCollection("salesorderdelivery");
                        for (DynamicObject salesOrderDeliveryEntity : salesOrderDelivery) {
                            salesOrderDeliveryEntity.set("deliverystatus", (Object)deliveryStatus);
                        }
                    }
                }
                SaveServiceHelper.update((DynamicObject)changeSaleOrder);
            }
            SaveServiceHelper.update((DynamicObject[])saleOrderArray);
        }
    }
}

