/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory.query;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ItemClassUtil;

public class QueryDistributionRulesHelper {
    private static final String KEY_PARENT = "parent";
    private static final String KEY_LEVEL = "level";
    private static final String KEY_SELECT_FIELDS = "id, country, level, parent";

    public static List<JSONObject> matchDistributionRules(List<JSONObject> rulesParams) {
        if (CollectionUtils.isEmpty(rulesParams)) {
            return new ArrayList<JSONObject>(0);
        }
        if ((rulesParams = rulesParams.stream().filter(rulesParam -> rulesParam.getLongValue("saleOrgId") > 0L && rulesParam.getLongValue("itemId") > 0L && rulesParam.getLongValue("adminDivisionId") > 0L).collect(Collectors.toList())).size() == 0) {
            return new ArrayList<JSONObject>(0);
        }
        Set<Long> adminDivisionIds = rulesParams.stream().map(x -> x.getLongValue("adminDivisionId")).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", adminDivisionIds);
        DynamicObjectCollection adminDivisions = QueryServiceHelper.query((String)"bd_admindivision", (String)KEY_SELECT_FIELDS, (QFilter[])filter.toArray());
        if (!CollectionUtils.isEmpty((Collection)adminDivisions)) {
            adminDivisionIds.removeAll(adminDivisions.stream().map(DynamicObjectUtils::getPkValue).collect(Collectors.toSet()));
            ArrayList<DynamicObject> streets = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> county = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> city = new ArrayList<DynamicObject>();
            ArrayList<DynamicObject> provinces = new ArrayList<DynamicObject>();
            for (DynamicObject adminDivision : adminDivisions) {
                int level = DynamicObjectUtils.getInt((DynamicObject)adminDivision, (String)KEY_LEVEL);
                if (level == 4) {
                    streets.add(adminDivision);
                    continue;
                }
                if (level == 3) {
                    county.add(adminDivision);
                    continue;
                }
                if (level == 2) {
                    city.add(adminDivision);
                    continue;
                }
                if (level != 1) continue;
                provinces.add(adminDivision);
            }
            QueryDistributionRulesHelper.setAdminDivisionInfoByStreet(streets, rulesParams);
            QueryDistributionRulesHelper.setAdminDivisionInfoByCounty(county, rulesParams);
            QueryDistributionRulesHelper.setAdminDivisionInfoByCity(city, rulesParams);
            QueryDistributionRulesHelper.setAdminDivisionInfoByProvince(provinces, rulesParams);
        }
        QueryDistributionRulesHelper.setAdminDivisionInfoByCountry(adminDivisionIds, rulesParams);
        QueryDistributionRulesHelper.setSaleOrgAndItemRuleParam(rulesParams);
        QueryDistributionRulesHelper.setItemClassRuleParams(rulesParams);
        DataSet distributionRulesDataSet = QueryDistributionRulesHelper.getDistributionRulesParamData(rulesParams);
        return QueryDistributionRulesHelper.buildRulesResult(distributionRulesDataSet);
    }

    private static void setAdminDivisionInfoByStreet(List<DynamicObject> streets, List<JSONObject> rulesParams) {
        if (CollectionUtils.isEmpty(streets)) {
            return;
        }
        Set countyIds = streets.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)KEY_PARENT)).collect(Collectors.toSet());
        QFilter qfilter = new QFilter("id", "in", countyIds);
        DynamicObjectCollection counties = QueryServiceHelper.query((String)"bd_admindivision", (String)KEY_SELECT_FIELDS, (QFilter[])qfilter.toArray());
        Set cityIds = counties.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)KEY_PARENT)).collect(Collectors.toSet());
        qfilter = new QFilter("id", "in", cityIds);
        DynamicObjectCollection cities = QueryServiceHelper.query((String)"bd_admindivision", (String)KEY_SELECT_FIELDS, (QFilter[])qfilter.toArray());
        ArrayList<JSONObject> parentRulesParams = new ArrayList<JSONObject>(rulesParams.size());
        for (JSONObject rulesParam : rulesParams) {
            long adminDivisionId = rulesParam.getLongValue("adminDivisionId");
            for (DynamicObject street : streets) {
                if (adminDivisionId != DynamicObjectUtils.getPkValue((DynamicObject)street)) continue;
                for (DynamicObject county : counties) {
                    long cityId = DynamicObjectUtils.getLong((DynamicObject)county, (String)KEY_PARENT);
                    for (DynamicObject city : cities) {
                        if (cityId != DynamicObjectUtils.getPkValue((DynamicObject)city)) continue;
                        long countryId = DynamicObjectUtils.getLong((DynamicObject)county, (String)"country");
                        rulesParam.put("countryId", (Object)countryId);
                        long provinceId = DynamicObjectUtils.getLong((DynamicObject)city, (String)KEY_PARENT);
                        rulesParam.put("provinceId", (Object)provinceId);
                        rulesParam.put("cityId", (Object)cityId);
                        rulesParam.put("countyId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)county));
                        rulesParam.put("sortSeq", (Object)1);
                        parentRulesParams.addAll(QueryDistributionRulesHelper.buildParentRulesParamByCounty(rulesParam, countryId, provinceId, cityId));
                    }
                }
            }
        }
        rulesParams.addAll(parentRulesParams);
    }

    private static void setAdminDivisionInfoByCounty(List<DynamicObject> counties, List<JSONObject> rulesParams) {
        if (CollectionUtils.isEmpty(counties)) {
            return;
        }
        Set cityIds = counties.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)KEY_PARENT)).collect(Collectors.toSet());
        QFilter filter = new QFilter("id", "in", cityIds);
        DynamicObjectCollection cities = QueryServiceHelper.query((String)"bd_admindivision", (String)KEY_SELECT_FIELDS, (QFilter[])filter.toArray());
        ArrayList<JSONObject> parentRulesParams = new ArrayList<JSONObject>(rulesParams.size());
        for (JSONObject rulesParam : rulesParams) {
            long adminDivisionId = rulesParam.getLongValue("adminDivisionId");
            for (DynamicObject county : counties) {
                if (adminDivisionId != DynamicObjectUtils.getPkValue((DynamicObject)county)) continue;
                long cityId = DynamicObjectUtils.getLong((DynamicObject)county, (String)KEY_PARENT);
                for (DynamicObject city : cities) {
                    if (cityId != DynamicObjectUtils.getPkValue((DynamicObject)city)) continue;
                    long countryId = DynamicObjectUtils.getLong((DynamicObject)county, (String)"country");
                    rulesParam.put("countryId", (Object)countryId);
                    long provinceId = DynamicObjectUtils.getLong((DynamicObject)city, (String)KEY_PARENT);
                    rulesParam.put("provinceId", (Object)provinceId);
                    rulesParam.put("cityId", (Object)cityId);
                    rulesParam.put("countyId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)county));
                    rulesParam.put("sortSeq", (Object)1);
                    parentRulesParams.addAll(QueryDistributionRulesHelper.buildParentRulesParamByCounty(rulesParam, countryId, provinceId, cityId));
                }
            }
        }
        rulesParams.addAll(parentRulesParams);
    }

    private static void setAdminDivisionInfoByCity(List<DynamicObject> cities, List<JSONObject> rulesParams) {
        if (CollectionUtils.isEmpty(cities)) {
            return;
        }
        ArrayList<JSONObject> parentRulesParams = new ArrayList<JSONObject>(rulesParams.size());
        for (JSONObject rulesParam : rulesParams) {
            long adminDivisionId = rulesParam.getLongValue("adminDivisionId");
            for (DynamicObject city : cities) {
                if (adminDivisionId != DynamicObjectUtils.getPkValue((DynamicObject)city)) continue;
                long countryId = DynamicObjectUtils.getLong((DynamicObject)city, (String)"country");
                rulesParam.put("countryId", (Object)countryId);
                long provinceId = DynamicObjectUtils.getLong((DynamicObject)city, (String)KEY_PARENT);
                rulesParam.put("provinceId", (Object)provinceId);
                rulesParam.put("cityId", (Object)adminDivisionId);
                rulesParam.put("countyId", (Object)0);
                rulesParam.put("sortSeq", (Object)2);
                parentRulesParams.addAll(QueryDistributionRulesHelper.buildParentRulesParamByCity(rulesParam, countryId, provinceId));
            }
        }
        rulesParams.addAll(parentRulesParams);
    }

    private static void setAdminDivisionInfoByProvince(List<DynamicObject> provinces, List<JSONObject> rulesParams) {
        if (CollectionUtils.isEmpty(provinces)) {
            return;
        }
        ArrayList<JSONObject> parentRulesParams = new ArrayList<JSONObject>(rulesParams.size());
        for (JSONObject rulesParam : rulesParams) {
            long adminDivisionId = rulesParam.getLongValue("adminDivisionId");
            for (DynamicObject province : provinces) {
                if (adminDivisionId != DynamicObjectUtils.getPkValue((DynamicObject)province)) continue;
                long countryId = DynamicObjectUtils.getLong((DynamicObject)province, (String)"country");
                rulesParam.put("countryId", (Object)countryId);
                rulesParam.put("provinceId", (Object)adminDivisionId);
                rulesParam.put("cityId", (Object)0);
                rulesParam.put("countyId", (Object)0);
                rulesParam.put("sortSeq", (Object)3);
                parentRulesParams.addAll(QueryDistributionRulesHelper.buildParentRulesParamByProvince(rulesParam, countryId));
            }
        }
        rulesParams.addAll(parentRulesParams);
    }

    private static void setAdminDivisionInfoByCountry(Set<Long> adminDivisionIds, List<JSONObject> rulesParams) {
        if (CollectionUtils.isEmpty(adminDivisionIds)) {
            return;
        }
        for (JSONObject rulesParam : rulesParams) {
            long adminDivisionId = rulesParam.getLongValue("adminDivisionId");
            if (!adminDivisionIds.contains(adminDivisionId)) continue;
            rulesParam.put("countryId", (Object)adminDivisionId);
            rulesParam.put("provinceId", (Object)0);
            rulesParam.put("cityId", (Object)0);
            rulesParam.put("countyId", (Object)0);
            rulesParam.put("sortSeq", (Object)4);
        }
    }

    private static void setSaleOrgAndItemRuleParam(List<JSONObject> rulesParams) {
        ArrayList<JSONObject> saleOrgAndItemRuleParams = new ArrayList<JSONObject>(rulesParams.size());
        for (JSONObject rulesParam : rulesParams) {
            rulesParam.put("itemClassId", (Object)0);
            rulesParam.put("rulesSeq", (Object)1);
            JSONObject saleOrgAndItemRuleParam = new JSONObject();
            saleOrgAndItemRuleParam.put("saleOrgId", rulesParam.get((Object)"saleOrgId"));
            saleOrgAndItemRuleParam.put("saleChannelId", (Object)0);
            saleOrgAndItemRuleParam.put("itemId", rulesParam.get((Object)"itemId"));
            saleOrgAndItemRuleParam.put("itemClassId", (Object)0);
            saleOrgAndItemRuleParam.put("adminDivisionId", rulesParam.get((Object)"adminDivisionId"));
            saleOrgAndItemRuleParam.put("countryId", rulesParam.get((Object)"countryId"));
            saleOrgAndItemRuleParam.put("provinceId", rulesParam.get((Object)"provinceId"));
            saleOrgAndItemRuleParam.put("cityId", rulesParam.get((Object)"cityId"));
            saleOrgAndItemRuleParam.put("countyId", rulesParam.get((Object)"countyId"));
            saleOrgAndItemRuleParam.put("sortSeq", rulesParam.get((Object)"sortSeq"));
            saleOrgAndItemRuleParam.put("rulesSeq", (Object)2);
            saleOrgAndItemRuleParams.add(saleOrgAndItemRuleParam);
        }
        rulesParams.addAll(saleOrgAndItemRuleParams);
    }

    private static void setItemClassRuleParams(List<JSONObject> rulesParams) {
        if (CollectionUtils.isEmpty(rulesParams)) {
            return;
        }
        ArrayList<JSONObject> itemClassRuleParams = new ArrayList<JSONObject>(rulesParams.size());
        Set itemIds = rulesParams.stream().map(x -> x.getLongValue("itemId")).collect(Collectors.toSet());
        Map itemIdclassListMap = ItemClassUtil.queryClassListMap(itemIds);
        for (JSONObject rulesParam : rulesParams) {
            long itemId = rulesParam.getLongValue("itemId");
            List itemClassIds = (List)itemIdclassListMap.get(itemId);
            if (itemClassIds == null) continue;
            for (Object itemClassId : itemClassIds) {
                JSONObject itemClassRuleParam = new JSONObject();
                itemClassRuleParam.put("saleOrgId", rulesParam.get((Object)"saleOrgId"));
                itemClassRuleParam.put("saleChannelId", rulesParam.get((Object)"saleChannelId"));
                itemClassRuleParam.put("itemId", (Object)itemId);
                itemClassRuleParam.put("itemClassId", itemClassId);
                itemClassRuleParam.put("adminDivisionId", rulesParam.get((Object)"adminDivisionId"));
                itemClassRuleParam.put("countryId", rulesParam.get((Object)"countryId"));
                itemClassRuleParam.put("provinceId", rulesParam.get((Object)"provinceId"));
                itemClassRuleParam.put("cityId", rulesParam.get((Object)"cityId"));
                itemClassRuleParam.put("countyId", rulesParam.get((Object)"countyId"));
                itemClassRuleParam.put("sortSeq", rulesParam.get((Object)"sortSeq"));
                String ruleSeq = rulesParam.getString("rulesSeq");
                if (StringUtils.equals((CharSequence)ruleSeq, (CharSequence)"1")) {
                    itemClassRuleParam.put("rulesSeq", (Object)3);
                } else if (StringUtils.equals((CharSequence)ruleSeq, (CharSequence)"2")) {
                    itemClassRuleParam.put("rulesSeq", (Object)4);
                }
                itemClassRuleParams.add(itemClassRuleParam);
            }
        }
        rulesParams.addAll(itemClassRuleParams);
    }

    private static List<JSONObject> buildParentRulesParamByCounty(JSONObject rulesParam, long countryId, long provinceId, long cityId) {
        ArrayList<JSONObject> parentRulesParams = new ArrayList<JSONObject>(3);
        JSONObject parentRulesParam = new JSONObject();
        parentRulesParam.put("saleChannelId", rulesParam.get((Object)"saleChannelId"));
        parentRulesParam.put("saleOrgId", rulesParam.get((Object)"saleOrgId"));
        parentRulesParam.put("itemId", rulesParam.get((Object)"itemId"));
        parentRulesParam.put("adminDivisionId", rulesParam.get((Object)"adminDivisionId"));
        parentRulesParam.put("countryId", (Object)countryId);
        parentRulesParam.put("provinceId", (Object)provinceId);
        parentRulesParam.put("cityId", (Object)cityId);
        parentRulesParam.put("countyId", (Object)0);
        parentRulesParam.put("sortSeq", (Object)2);
        parentRulesParams.add(parentRulesParam);
        parentRulesParams.addAll(QueryDistributionRulesHelper.buildParentRulesParamByCity(rulesParam, countryId, provinceId));
        return parentRulesParams;
    }

    private static List<JSONObject> buildParentRulesParamByCity(JSONObject rulesParam, long countryId, long provinceId) {
        ArrayList<JSONObject> parentRulesParams = new ArrayList<JSONObject>(3);
        JSONObject parentRulesParam = new JSONObject();
        parentRulesParam.put("saleChannelId", rulesParam.get((Object)"saleChannelId"));
        parentRulesParam.put("saleOrgId", rulesParam.get((Object)"saleOrgId"));
        parentRulesParam.put("itemId", rulesParam.get((Object)"itemId"));
        parentRulesParam.put("adminDivisionId", rulesParam.get((Object)"adminDivisionId"));
        parentRulesParam.put("countryId", (Object)countryId);
        parentRulesParam.put("provinceId", (Object)provinceId);
        parentRulesParam.put("cityId", (Object)0);
        parentRulesParam.put("countyId", (Object)0);
        parentRulesParam.put("sortSeq", (Object)3);
        parentRulesParams.add(parentRulesParam);
        parentRulesParams.addAll(QueryDistributionRulesHelper.buildParentRulesParamByProvince(rulesParam, countryId));
        return parentRulesParams;
    }

    private static List<JSONObject> buildParentRulesParamByProvince(JSONObject rulesParam, long countryId) {
        ArrayList<JSONObject> parentRulesParams = new ArrayList<JSONObject>(3);
        JSONObject parentRulesParam = new JSONObject();
        parentRulesParam.put("saleChannelId", rulesParam.get((Object)"saleChannelId"));
        parentRulesParam.put("saleOrgId", rulesParam.get((Object)"saleOrgId"));
        parentRulesParam.put("itemId", rulesParam.get((Object)"itemId"));
        parentRulesParam.put("adminDivisionId", rulesParam.get((Object)"adminDivisionId"));
        parentRulesParam.put("countryId", (Object)countryId);
        parentRulesParam.put("provinceId", (Object)0);
        parentRulesParam.put("cityId", (Object)0);
        parentRulesParam.put("countyId", (Object)0);
        parentRulesParam.put("sortSeq", (Object)4);
        parentRulesParams.add(parentRulesParam);
        return parentRulesParams;
    }

    public static List<Object> getAllItemClasses(DynamicObject item) {
        long itemIds = DynamicObjectUtils.getPkValue((DynamicObject)item);
        return ItemClassUtil.queryClassList((Object)itemIds);
    }

    private static DataSet getDistributionRulesParamData(List<JSONObject> rulesParams) {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("sortSeq", (DataType)DataType.IntegerType));
        fields.add(new Field("rulesSeq", (DataType)DataType.IntegerType));
        fields.add(new Field("saleChannelId", (DataType)DataType.LongType));
        fields.add(new Field("saleOrgId", (DataType)DataType.LongType));
        fields.add(new Field("itemId", (DataType)DataType.LongType));
        fields.add(new Field("itemClassId", (DataType)DataType.LongType));
        fields.add(new Field("adminDivisionId", (DataType)DataType.LongType));
        fields.add(new Field("countryId", (DataType)DataType.LongType));
        fields.add(new Field("provinceId", (DataType)DataType.LongType));
        fields.add(new Field("cityId", (DataType)DataType.LongType));
        fields.add(new Field("countyId", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        DataSetBuilder builder = Algo.create((String)"RulesParamData").createDataSetBuilder(rowMeta);
        int size = rulesParams.size();
        HashSet<Long> itemIds = new HashSet<Long>(size);
        HashSet<Long> saleChannelIds = new HashSet<Long>(size);
        HashSet<Long> saleOrgIds = new HashSet<Long>(size);
        HashSet<Long> countryIds = new HashSet<Long>(size);
        HashSet<Long> provinceIds = new HashSet<Long>(size);
        HashSet<Long> cityIds = new HashSet<Long>(size);
        HashSet<Long> countyIds = new HashSet<Long>(size);
        HashSet<Long> itemClassIds = new HashSet<Long>(size);
        for (JSONObject rulesParam : rulesParams) {
            long itemId = rulesParam.getLongValue("itemId");
            itemIds.add(itemId);
            long saleOrgId = rulesParam.getLongValue("saleOrgId");
            saleOrgIds.add(saleOrgId);
            long saleChannelId = rulesParam.getLongValue("saleChannelId");
            if (saleChannelId > 0L) {
                saleChannelIds.add(saleChannelId);
            }
            long countryId = rulesParam.getLongValue("countryId");
            countryIds.add(countryId);
            long provinceId = rulesParam.getLongValue("provinceId");
            provinceIds.add(provinceId);
            long cityId = rulesParam.getLongValue("cityId");
            cityIds.add(cityId);
            long countyId = rulesParam.getLongValue("countyId");
            countyIds.add(countyId);
            long itemClassId = rulesParam.getLongValue("itemClassId");
            itemClassIds.add(itemClassId);
            builder.append(new Object[]{rulesParam.get((Object)"sortSeq"), rulesParam.get((Object)"rulesSeq"), saleChannelId, saleOrgId, itemId, itemClassId, rulesParam.get((Object)"adminDivisionId"), countryId, provinceId, cityId, countyId});
        }
        DataSet rulesParamData = builder.build();
        String selectedFields = String.join((CharSequence)",", "salebranch", "saleorg", "goods", "country", "province", "city", "county", "itemclass", "mode", "branch", "stock", "inventoryorg", "erpstock", "priority");
        QFilter filter = F7Utils.getEnableFilter();
        saleChannelIds.add(0L);
        filter.and("salebranch", "in", saleChannelIds);
        filter.and("saleorg", "in", saleOrgIds);
        itemIds.add(0L);
        filter.and("goods", "in", itemIds);
        itemClassIds.add(0L);
        filter.and("itemclass", "in", itemClassIds);
        filter.and("country", "in", countryIds);
        filter.and("province", "in", provinceIds);
        filter.and("city", "in", cityIds);
        filter.and("county", "in", countyIds);
        DataSet distributionRulesData = QueryServiceHelper.queryDataSet((String)QueryDistributionRulesHelper.class.getName(), (String)"ocdbd_distributionrules", (String)selectedFields, (QFilter[])filter.toArray(), (String)"");
        DataSet itemData = rulesParamData.rightJoin(distributionRulesData.filter("itemclass = 0 AND goods>0")).on("saleChannelId", "salebranch").on("saleOrgId", "saleorg").on("itemId", "goods").on("itemClassId", "itemclass").on("countryId", "country").on("provinceId", "province").on("cityId", "city").on("countyId", "county").select(rulesParamData.getRowMeta().getFieldNames(), new String[]{"mode", "branch", "stock", "inventoryorg", "erpstock", "priority"}).finish().filter("rulesSeq IN (1,2)");
        DataSet itemClassData = rulesParamData.rightJoin(distributionRulesData.filter("itemclass > 0 AND goods=0")).on("saleChannelId", "salebranch").on("saleOrgId", "saleorg").on("itemClassId", "itemclass").on("countryId", "country").on("provinceId", "province").on("cityId", "city").on("countyId", "county").select(rulesParamData.getRowMeta().getFieldNames(), new String[]{"mode", "branch", "stock", "inventoryorg", "erpstock", "priority"}).finish().filter("rulesSeq IN (3,4)");
        DataSet noItemClassData = rulesParamData.rightJoin(distributionRulesData.filter("itemclass = 0 AND goods=0")).on("saleChannelId", "salebranch").on("saleOrgId", "saleorg").on("itemClassId", "itemclass").on("countryId", "country").on("provinceId", "province").on("cityId", "city").on("countyId", "county").select(rulesParamData.getRowMeta().getFieldNames(), new String[]{"mode", "branch", "stock", "inventoryorg", "erpstock", "priority"}).finish();
        return itemData.union(itemClassData).union(noItemClassData).orderBy(new String[]{"rulesSeq", "sortSeq", "saleChannelId", "itemId", "saleOrgId", "itemClassId", "adminDivisionId", "priority"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<JSONObject> buildRulesResult(DataSet distributionRulesData) {
        ArrayList<JSONObject> rulesResults = new ArrayList<JSONObject>();
        try {
            HashSet<String> keySet = new HashSet<String>(20);
            while (distributionRulesData.hasNext()) {
                Row row = distributionRulesData.next();
                String key = QueryDistributionRulesHelper.getGroupFields(row);
                if (keySet.contains(key)) continue;
                keySet.add(key);
                JSONObject rulesResult = new JSONObject();
                rulesResult.put("saleChannelId", (Object)row.getLong("saleChannelId"));
                rulesResult.put("saleOrgId", (Object)row.getLong("saleOrgId"));
                rulesResult.put("itemId", (Object)row.getLong("itemId"));
                rulesResult.put("adminDivisionId", (Object)row.getLong("adminDivisionId"));
                rulesResult.put("distributionModeId", (Object)row.getLong("mode"));
                rulesResult.put("deliveryChannelId", (Object)row.getLong("branch"));
                rulesResult.put("channelwarehouseid", (Object)row.getLong("stock"));
                rulesResult.put("stockOrgId", (Object)row.getLong("inventoryorg"));
                rulesResult.put("warehouseId", (Object)row.getLong("erpstock"));
                rulesResult.put("priority", (Object)row.getInteger("priority"));
                rulesResults.add(rulesResult);
            }
        }
        finally {
            distributionRulesData.close();
        }
        return rulesResults;
    }

    private static String getGroupFields(Row row) {
        ArrayList<Number> fields = new ArrayList<Number>(14);
        fields.add(row.getInteger("sortSeq"));
        fields.add(row.getLong("saleOrgId"));
        fields.add(row.getLong("itemId"));
        fields.add(row.getLong("itemClassId"));
        fields.add(row.getLong("countryId"));
        fields.add(row.getLong("provinceId"));
        fields.add(row.getLong("cityId"));
        fields.add(row.getLong("countyId"));
        fields.add(row.getLong("mode"));
        fields.add(row.getLong("branch"));
        fields.add(row.getLong("stock"));
        fields.add(row.getLong("inventoryorg"));
        fields.add(row.getLong("erpstock"));
        fields.add(row.getLong("priority"));
        return StringUtils.join((Object[])fields.toArray(), (char)'_');
    }
}

