/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.inventory.query;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.UnitConvertHelper;
import kd.occ.ocpos.business.inventory.query.QueryDistributionRulesHelper;
import kd.occ.ocpos.common.util.CommonUtil;

public class QueryInventoryHelper {
    private static final Log LOG = LogFactory.getLog(QueryInventoryHelper.class, (String)"ocpos");

    public static List<JSONObject> matchDistributionWarehouse(List<JSONObject> params) {
        if (CollectionUtils.isEmpty(params)) {
            return params;
        }
        ArrayList<JSONObject> nonStockOrgInvParams = new ArrayList<JSONObject>();
        ArrayList<JSONObject> stockOrgInvParams = new ArrayList<JSONObject>();
        for (JSONObject param : params) {
            long stockOrgId = param.getLongValue("stockOrgId");
            long wareHouseId = param.getLongValue("warehouseId");
            if (stockOrgId > 0L && wareHouseId > 0L) {
                stockOrgInvParams.add(param);
                continue;
            }
            nonStockOrgInvParams.add(param);
        }
        ArrayList<JSONObject> matchResults = new ArrayList<JSONObject>();
        if (!CollectionUtils.isEmpty(nonStockOrgInvParams)) {
            matchResults.addAll(QueryInventoryHelper.buildNonStockOrgMatchResults(nonStockOrgInvParams));
        }
        if (!CollectionUtils.isEmpty(stockOrgInvParams)) {
            matchResults.addAll(QueryInventoryHelper.buildStockOrgMatchResults(stockOrgInvParams));
        }
        DataSet availableInvDataSet = QueryInventoryHelper.queryScmAvailableInventory(matchResults);
        return QueryInventoryHelper.getLastInvResult(matchResults, availableInvDataSet);
    }

    private static List<JSONObject> buildNonStockOrgMatchResults(List<JSONObject> nonStockOrgInvParams) {
        ArrayList<JSONObject> invResults = new ArrayList<JSONObject>(nonStockOrgInvParams.size());
        if (nonStockOrgInvParams.size() > 0) {
            ArrayList<JSONObject> rulesParams = new ArrayList<JSONObject>(nonStockOrgInvParams.size());
            for (JSONObject nonStockOrgInvParam : nonStockOrgInvParams) {
                JSONObject rulesParam = new JSONObject();
                rulesParam.put("saleChannelId", nonStockOrgInvParam.get((Object)"saleChannelID"));
                rulesParam.put("itemId", nonStockOrgInvParam.get((Object)"itemId"));
                rulesParam.put("saleOrgId", nonStockOrgInvParam.get((Object)"saleOrgId"));
                rulesParam.put("adminDivisionId", nonStockOrgInvParam.get((Object)"adminDivisionId"));
                rulesParams.add(rulesParam);
            }
            List<JSONObject> rulesResults = QueryDistributionRulesHelper.matchDistributionRules(rulesParams);
            for (JSONObject invParam : nonStockOrgInvParams) {
                JSONObject invDetailItem;
                JSONObject invResult = new JSONObject();
                invResult.put("saleorgid", invParam.get((Object)"saleOrgId"));
                invResult.put("salechannelid", invParam.get((Object)"saleChannelID"));
                invResult.put("admindivisionid", invParam.get((Object)"adminDivisionId"));
                invResult.put("itemid", invParam.get((Object)"itemId"));
                invResult.put("materialid", invParam.get((Object)"materialId"));
                invResult.put("auxptyid", invParam.get((Object)"auxPtyID"));
                invResult.put("baseunitid", invParam.get((Object)"baseUnitID"));
                invResult.put("baseunitqty", invParam.get((Object)"baseUnitQty"));
                invResult.put("unitid", invParam.get((Object)"unitId"));
                invResult.put("unitqty", invParam.get((Object)"unitQty"));
                invResult.put("distributionmodeid", invParam.get((Object)"distributionModeId"));
                invResult.put("customerKey", invParam.get((Object)"customerKey"));
                JSONArray invDetailInfo = new JSONArray();
                if (!CollectionUtils.isEmpty(rulesResults)) {
                    int sortSeq = 1;
                    for (JSONObject rulesResult : rulesResults) {
                        if (rulesResult.getLongValue("saleOrgId") != invResult.getLongValue("saleorgid") || rulesResult.getLongValue("saleChannelId") != invResult.getLongValue("salechannelid") && rulesResult.getLongValue("saleChannelId") != 0L || rulesResult.getLongValue("adminDivisionId") != invResult.getLongValue("admindivisionid") || rulesResult.getLongValue("itemId") != invResult.getLongValue("itemid") || rulesResult.getLongValue("stockOrgId") <= 0L || rulesResult.getLongValue("warehouseId") <= 0L) continue;
                        invDetailItem = new JSONObject();
                        invDetailItem.put("distributionmodeid", rulesResult.get((Object)"distributionModeId"));
                        invDetailItem.put("deliverychannelid", rulesResult.get((Object)"deliveryChannelId"));
                        invDetailItem.put("channelwarehouseid", rulesResult.get((Object)"channelwarehouseid"));
                        invDetailItem.put("stockorgid", rulesResult.get((Object)"stockOrgId"));
                        invDetailItem.put("warehouseid", rulesResult.get((Object)"warehouseId"));
                        invDetailItem.put("sortseq", (Object)sortSeq);
                        invDetailItem.put("invtypeid", invParam.get((Object)"invtypeid"));
                        invDetailInfo.add((Object)invDetailItem);
                        ++sortSeq;
                    }
                }
                if (CollectionUtils.isEmpty((Collection)invDetailInfo)) {
                    invResult.put("invstatus", (Object)"3");
                    invDetailItem = new JSONObject();
                    invDetailItem.put("distributionmodeid", invParam.get((Object)"distributionModeId"));
                    invDetailItem.put("stockorgid", invParam.get((Object)"stockOrgId"));
                    invDetailItem.put("warehouseid", invParam.get((Object)"warehouseId"));
                    invDetailItem.put("sortseq", (Object)1);
                    invDetailItem.put("invtypeid", invParam.get((Object)"invtypeid"));
                    invDetailInfo.add((Object)invDetailItem);
                }
                invResult.put("invdetailinfolist", (Object)invDetailInfo);
                invResults.add(invResult);
            }
        }
        return invResults;
    }

    private static List<JSONObject> buildStockOrgMatchResults(List<JSONObject> stockOrgInvParams) {
        ArrayList<JSONObject> invResults = new ArrayList<JSONObject>(stockOrgInvParams.size());
        for (JSONObject invParam : stockOrgInvParams) {
            JSONObject invResult = new JSONObject();
            invResult.put("saleorgid", invParam.get((Object)"saleOrgId"));
            invResult.put("salechannelid", invParam.get((Object)"saleChannelID"));
            invResult.put("admindivisionid", invParam.get((Object)"adminDivisionId"));
            invResult.put("itemid", invParam.get((Object)"itemId"));
            invResult.put("materialid", invParam.get((Object)"materialId"));
            invResult.put("auxptyid", invParam.get((Object)"auxPtyID"));
            invResult.put("baseunitid", invParam.get((Object)"baseUnitID"));
            invResult.put("baseunitqty", invParam.get((Object)"baseUnitQty"));
            invResult.put("unitid", invParam.get((Object)"unitId"));
            invResult.put("unitqty", invParam.get((Object)"unitQty"));
            invResult.put("customerKey", invParam.get((Object)"customerKey"));
            JSONArray invDetailInfo = new JSONArray();
            JSONObject invDetailItem = new JSONObject();
            invDetailItem.put("distributionmodeid", invParam.get((Object)"distributionModeId"));
            invDetailItem.put("stockorgid", invParam.get((Object)"stockOrgId"));
            invDetailItem.put("warehouseid", invParam.get((Object)"warehouseId"));
            invDetailItem.put("sortseq", (Object)1);
            invDetailItem.put("invtypeid", invParam.get((Object)"invtypeid"));
            invDetailInfo.add((Object)invDetailItem);
            invResult.put("invdetailinfolist", (Object)invDetailInfo);
            invResults.add(invResult);
        }
        return invResults;
    }

    private static DataSet queryScmAvailableInventory(List<JSONObject> matchResults) {
        int size = matchResults.size();
        HashSet<Long> materialIds = new HashSet<Long>(size);
        HashSet<Long> auxPtyIds = new HashSet<Long>(size);
        HashSet<Long> baseUnitIds = new HashSet<Long>(size);
        HashSet<Long> stockOrgIds = new HashSet<Long>(size);
        HashSet<Long> wareHouseIds = new HashSet<Long>(size);
        HashSet<Long> invTypeIds = new HashSet<Long>(size);
        for (JSONObject matchResult : matchResults) {
            materialIds.add(matchResult.getLongValue("materialid"));
            auxPtyIds.add(matchResult.getLongValue("auxptyid"));
            baseUnitIds.add(matchResult.getLongValue("baseunitid"));
            JSONArray invDetailInfo = matchResult.getJSONArray("invdetailinfolist");
            if (CollectionUtils.isEmpty((Collection)invDetailInfo)) continue;
            for (Object item : invDetailInfo) {
                JSONObject invDetailItem = (JSONObject)item;
                stockOrgIds.add(invDetailItem.getLongValue("stockorgid"));
                wareHouseIds.add(invDetailItem.getLongValue("warehouseid"));
                long invTypeId = invDetailItem.getLongValue("invtypeid");
                if (invTypeId <= 0L) continue;
                invTypeIds.add(invTypeId);
            }
        }
        return QueryInventoryHelper.queryScmAvailableInventory(stockOrgIds, wareHouseIds, materialIds, auxPtyIds, baseUnitIds, invTypeIds);
    }

    private static DataSet queryScmAvailableInventory(Set<Long> stockOrgIds, Set<Long> wareHouseIds, Set<Long> materialIds, Set<Long> auxPtyIds, Set<Long> baseUnitIds, Set<Long> invTypeIds) {
        LinkedHashMap paramItems = new LinkedHashMap(6);
        LinkedHashMap<String, Set<Long>> stockOrgs = new LinkedHashMap<String, Set<Long>>(1);
        stockOrgs.put("id", stockOrgIds);
        paramItems.put("org", stockOrgs);
        LinkedHashMap<String, Set<Long>> wareHouses = new LinkedHashMap<String, Set<Long>>(1);
        wareHouses.put("id", wareHouseIds);
        paramItems.put("warehouse", wareHouses);
        LinkedHashMap<String, Set<Long>> materials = new LinkedHashMap<String, Set<Long>>(1);
        materials.put("id", materialIds);
        paramItems.put("material", materials);
        if (!CollectionUtils.isEmpty(auxPtyIds)) {
            LinkedHashMap<String, Set<Long>> auxPtyMap = new LinkedHashMap<String, Set<Long>>(1);
            auxPtyMap.put("id", auxPtyIds);
            paramItems.put("auxpty", auxPtyMap);
        }
        if (!CollectionUtils.isEmpty(baseUnitIds)) {
            LinkedHashMap<String, Set<Long>> baseUnits = new LinkedHashMap<String, Set<Long>>(1);
            baseUnits.put("id", baseUnitIds);
            paramItems.put("baseunit", baseUnits);
        }
        if (!CollectionUtils.isEmpty(invTypeIds)) {
            LinkedHashMap<String, Set<Long>> invTypes = new LinkedHashMap<String, Set<Long>>(1);
            invTypes.put("id", invTypeIds);
            paramItems.put("invtype", invTypes);
        }
        HashMap params = new HashMap(1);
        params.put("data", paramItems);
        LOG.info("\u4f9b\u5e94\u94fe\u5e93\u5b58\u4f20\u53c2\uff1a" + JSONObject.toJSONString(params));
        List invAccQueryData = (List)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvAccQueryService", (String)"invAccQueryExtForInner", (Object[])new Object[]{params});
        LOG.info("\u4f9b\u5e94\u94fe\u5e93\u5b58\u56de\u53c2\uff1a" + JSONObject.toJSONString((Object)invAccQueryData));
        return QueryInventoryHelper.getSumMatchAvailableInvDataSet(invAccQueryData);
    }

    private static DataSet getSumMatchAvailableInvDataSet(List<Map<String, Object>> invData) {
        if (CollectionUtils.isEmpty(invData)) {
            return null;
        }
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("org", (DataType)DataType.LongType));
        fields.add(new Field("warehouse", (DataType)DataType.LongType));
        fields.add(new Field("material", (DataType)DataType.LongType));
        fields.add(new Field("auxpty", (DataType)DataType.LongType));
        fields.add(new Field("baseunit", (DataType)DataType.LongType));
        fields.add(new Field("avbbaseqty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("invtype", (DataType)DataType.LongType));
        fields.add(new Field("invtypename", (DataType)DataType.StringType));
        fields.add(new Field("baseqty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("reservoeqty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("keepertype", (DataType)DataType.StringType));
        fields.add(new Field("keeper", (DataType)DataType.LongType));
        fields.add(new Field("ownertype", (DataType)DataType.StringType));
        fields.add(new Field("owner", (DataType)DataType.LongType));
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        DataSetBuilder builder = Algo.create((String)"invAccQueryData").createDataSetBuilder(rowMeta);
        Object[] invTypeIds = invData.stream().map(x -> x.get("invtype")).toArray();
        QFilter filter = new QFilter("id", "in", (Object)invTypeIds);
        DynamicObjectCollection invTypes = QueryServiceHelper.query((String)"bd_invtype", (String)String.join((CharSequence)",", "id", "name"), (QFilter[])filter.toArray());
        Map<Long, List<DynamicObject>> invTypeData = invTypes.stream().collect(Collectors.groupingBy(x -> x.getLong("id")));
        Map<String, List<Map>> invAccQueryData = invData.stream().collect(Collectors.groupingBy(QueryInventoryHelper::getGroupFields));
        BigDecimal sumBaseQty = BigDecimal.ZERO;
        BigDecimal sumAvbBaseQty = BigDecimal.ZERO;
        BigDecimal sumReserveBaseQty = BigDecimal.ZERO;
        for (Map.Entry<String, List<Map>> entry : invAccQueryData.entrySet()) {
            List<Map> value = entry.getValue();
            Map data = value.get(0);
            for (Map item : value) {
                if (CommonUtil.formatObjectToDecimal(item.get("baseqty")).compareTo(BigDecimal.ZERO) > 0) {
                    sumBaseQty = sumBaseQty.add(CommonUtil.formatObjectToDecimal(item.get("baseqty")));
                }
                if (CommonUtil.formatObjectToDecimal(item.get("avbbaseqty")).compareTo(BigDecimal.ZERO) > 0) {
                    sumAvbBaseQty = sumAvbBaseQty.add(CommonUtil.formatObjectToDecimal(item.get("avbbaseqty")));
                }
                if (CommonUtil.formatObjectToDecimal(item.get("reservoeqty")).compareTo(BigDecimal.ZERO) <= 0) continue;
                sumReserveBaseQty = sumReserveBaseQty.add(CommonUtil.formatObjectToDecimal(item.get("reservoeqty")));
            }
            long invTypeId = CommonUtil.formatObejctToLong(data.get("invtype"));
            String invTypeName = "";
            if (invTypeId > 0L) {
                invTypeName = invTypeData.get(invTypeId).get(0).getString("name");
            }
            builder.append(new Object[]{data.get("org"), data.get("warehouse"), data.get("material"), data.get("auxpty"), data.get("baseunit"), sumAvbBaseQty, invTypeId, invTypeName, sumBaseQty, sumReserveBaseQty, data.get("keepertype"), data.get("keeper"), data.get("ownertype"), data.get("owner")});
        }
        return builder.build();
    }

    private static List<JSONObject> getLastInvResult(List<JSONObject> matchResults, DataSet avaInvData) {
        ArrayList<JSONObject> matchInvResults = new ArrayList<JSONObject>(matchResults.size());
        DataSet matchAvailableInvData = QueryInventoryHelper.getMatchAvailableInvData(matchResults, avaInvData);
        matchInvResults.addAll(QueryInventoryHelper.getMatchResults(matchAvailableInvData).values());
        return matchInvResults;
    }

    private static DataSet getMatchAvailableInvData(List<JSONObject> matchResults, DataSet avaInvData) {
        ArrayList<Field> fields = new ArrayList<Field>(32);
        fields.add(new Field("groupseq", (DataType)DataType.IntegerType));
        fields.add(new Field("saleorgid", (DataType)DataType.LongType));
        fields.add(new Field("salechannelid", (DataType)DataType.LongType));
        fields.add(new Field("admindivisionid", (DataType)DataType.LongType));
        fields.add(new Field("itemid", (DataType)DataType.LongType));
        fields.add(new Field("materialid", (DataType)DataType.LongType));
        fields.add(new Field("auxptyid", (DataType)DataType.LongType));
        fields.add(new Field("baseunitid", (DataType)DataType.LongType));
        fields.add(new Field("baseunitqty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("unitid", (DataType)DataType.LongType));
        fields.add(new Field("unitqty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("distributionmodeid", (DataType)DataType.LongType));
        fields.add(new Field("deliverychannelid", (DataType)DataType.LongType));
        fields.add(new Field("channelwarehouseid", (DataType)DataType.LongType));
        fields.add(new Field("stockorgid", (DataType)DataType.LongType));
        fields.add(new Field("warehouseid", (DataType)DataType.LongType));
        fields.add(new Field("sortseq", (DataType)DataType.IntegerType));
        fields.add(new Field("invtypeid", (DataType)DataType.LongType));
        fields.add(new Field("customerKey", (DataType)DataType.StringType));
        fields.add(new Field("invstatus", (DataType)DataType.StringType));
        RowMeta rowMeta = new RowMeta(fields.toArray(new Field[0]));
        DataSetBuilder builder = Algo.create((String)"matchResultData").createDataSetBuilder(rowMeta);
        int seq = 1;
        for (JSONObject matchResult : matchResults) {
            for (Object item : matchResult.getJSONArray("invdetailinfolist")) {
                JSONObject invDetailInfo = (JSONObject)item;
                builder.append(new Object[]{seq, matchResult.get((Object)"saleorgid"), matchResult.get((Object)"salechannelid"), CommonUtil.formatObejctToLong((Object)matchResult.get((Object)"admindivisionid")), matchResult.get((Object)"itemid"), matchResult.get((Object)"materialid"), matchResult.get((Object)"auxptyid"), matchResult.get((Object)"baseunitid"), matchResult.get((Object)"baseunitqty"), matchResult.get((Object)"unitid"), matchResult.get((Object)"unitqty"), invDetailInfo.get((Object)"distributionmodeid"), invDetailInfo.get((Object)"deliverychannelid"), invDetailInfo.get((Object)"channelwarehouseid"), invDetailInfo.get((Object)"stockorgid"), invDetailInfo.get((Object)"warehouseid"), invDetailInfo.get((Object)"sortseq"), invDetailInfo.get((Object)"invtypeid"), matchResult.get((Object)"customerKey"), matchResult.get((Object)"invstatus")});
            }
            ++seq;
        }
        DataSet data = builder.build();
        if (avaInvData != null) {
            DataSet invTypeResultData = data.filter("invtypeid > 0").leftJoin(avaInvData).on("stockorgid", "org").on("warehouseid", "warehouse").on("materialid", "material").on("auxptyid", "auxpty").on("baseunitid", "baseunit").on("invtypeid", "invtype").select(data.getRowMeta().getFieldNames(), new String[]{"invtype", "avbbaseqty", "keepertype", "keeper", "ownertype", "owner"}).finish();
            DataSet noInvTypeResultData = data.filter("invtypeid = 0").leftJoin(avaInvData).on("stockorgid", "org").on("warehouseid", "warehouse").on("materialid", "material").on("auxptyid", "auxpty").on("baseunitid", "baseunit").select(data.getRowMeta().getFieldNames(), new String[]{"invtype", "avbbaseqty", "keepertype", "keeper", "ownertype", "owner"}).finish();
            return invTypeResultData.union(noInvTypeResultData).orderBy(new String[]{"groupseq", "sortseq"});
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Integer, JSONObject> getMatchResults(DataSet matchAvailableInvData) {
        HashMap<Integer, JSONObject> matchResults = new HashMap<Integer, JSONObject>(20);
        try {
            JSONObject matchResult;
            HashSet<Integer> seqSet = new HashSet<Integer>(0);
            HashMap<Integer, Row> matchAvailableRows = new HashMap<Integer, Row>(20);
            HashMap<String, BigDecimal> sumAvbBaseQtyMap = new HashMap<String, BigDecimal>(20);
            while (matchAvailableInvData.hasNext()) {
                String key;
                Row matchAvailableRow = matchAvailableInvData.next();
                int seq = matchAvailableRow.getInteger("groupseq");
                if (seqSet.contains(seq)) continue;
                if (matchAvailableInvData.getRowMeta().getFields().length == 20 || matchAvailableRow.get("avbbaseqty") == null || matchAvailableRow.getBigDecimal("avbbaseqty").compareTo(BigDecimal.ZERO) <= 0) {
                    if (matchAvailableRows.containsKey(seq)) continue;
                    matchAvailableRows.put(seq, matchAvailableRow);
                    continue;
                }
                matchAvailableRows.remove(seq);
                BigDecimal baseQty = matchAvailableRow.getBigDecimal("baseunitqty");
                long invTypeId = matchAvailableRow.getLong("invtypeid");
                if (invTypeId == 0L) {
                    invTypeId = matchAvailableRow.getLong("invtype");
                }
                if (!sumAvbBaseQtyMap.containsKey(key = QueryInventoryHelper.getGroupFields(matchAvailableRow, invTypeId))) {
                    sumAvbBaseQtyMap.put(key, matchAvailableRow.getBigDecimal("avbbaseqty"));
                }
                BigDecimal avbBaseQty = (BigDecimal)sumAvbBaseQtyMap.get(key);
                if (!matchResults.containsKey(seq)) {
                    matchResult = new JSONObject();
                    QueryInventoryHelper.setMatchResultVO(matchResult, matchAvailableRow);
                    matchResults.put(seq, matchResult);
                } else {
                    matchResult = (JSONObject)matchResults.get(seq);
                    avbBaseQty = (BigDecimal)sumAvbBaseQtyMap.get(key);
                    BigDecimal sumAvbBaseQty = matchResult.containsKey((Object)"sumAvbBaseQty") ? matchResult.getBigDecimal("sumAvbBaseQty") : BigDecimal.ZERO;
                    baseQty = baseQty.subtract(sumAvbBaseQty);
                }
                if (BigDecimal.ZERO.compareTo(avbBaseQty) >= 0) continue;
                boolean isEnough = QueryInventoryHelper.setMatchInvDetailInfo(matchResult, matchAvailableRow, baseQty, avbBaseQty);
                if (isEnough) {
                    seqSet.add(seq);
                    sumAvbBaseQtyMap.put(key, ((BigDecimal)sumAvbBaseQtyMap.get(key)).subtract(baseQty));
                    continue;
                }
                sumAvbBaseQtyMap.put(key, ((BigDecimal)sumAvbBaseQtyMap.get(key)).subtract(avbBaseQty));
            }
            for (Map.Entry entry : matchAvailableRows.entrySet()) {
                matchResult = new JSONObject();
                QueryInventoryHelper.setMatchResultVO(matchResult, (Row)entry.getValue());
                matchResults.put(((Row)entry.getValue()).getInteger("groupseq"), matchResult);
            }
        }
        finally {
            matchAvailableInvData.close();
        }
        return matchResults;
    }

    private static boolean setMatchInvDetailInfo(JSONObject matchResult, Row matchAvailableRow, BigDecimal baseQty, BigDecimal avbBaseQty) {
        String invStatus;
        JSONArray invDetailInfo = new JSONArray();
        JSONObject invDetailItem = new JSONObject();
        invDetailItem.put("distributionmodeid", (Object)matchAvailableRow.getLong("distributionmodeid"));
        invDetailItem.put("deliverychannelid", (Object)matchAvailableRow.getLong("deliverychannelid"));
        invDetailItem.put("channelwarehouseid", (Object)matchAvailableRow.getLong("channelwarehouseid"));
        invDetailItem.put("stockorgid", (Object)matchAvailableRow.getLong("stockorgid"));
        invDetailItem.put("warehouseid", (Object)matchAvailableRow.getLong("warehouseid"));
        invDetailItem.put("sortseq", (Object)matchAvailableRow.getLong("sortseq"));
        invDetailItem.put("invtypeid", (Object)matchAvailableRow.getLong("invtype"));
        invDetailItem.put("keepertype", (Object)matchAvailableRow.getString("keepertype"));
        invDetailItem.put("keeperid", (Object)matchAvailableRow.getLong("keeper"));
        invDetailItem.put("ownertype", (Object)matchAvailableRow.getString("ownertype"));
        invDetailItem.put("ownerid", (Object)matchAvailableRow.getLong("owner"));
        boolean isEnough = false;
        if (baseQty.compareTo(avbBaseQty) <= 0) {
            isEnough = true;
            invStatus = "1";
            invDetailItem.put("availablebaseqty", (Object)baseQty);
            invDetailItem.put("availableqty", (Object)matchAvailableRow.getBigDecimal("unitqty"));
        } else {
            invStatus = "2";
            invDetailItem.put("availablebaseqty", (Object)avbBaseQty);
            BigDecimal availableQty = UnitConvertHelper.calculateDestQty((BigDecimal)avbBaseQty, (Long)matchAvailableRow.getLong("materialid"), (Long)matchAvailableRow.getLong("baseunitid"), (Long)matchAvailableRow.getLong("unitid"));
            invDetailItem.put("availableqty", (Object)availableQty);
        }
        BigDecimal billSumAvbBaseQty = BigDecimal.ZERO;
        if (matchResult.containsKey((Object)"sumAvbBaseQty")) {
            billSumAvbBaseQty = new BigDecimal(matchResult.get((Object)"sumAvbBaseQty").toString());
        }
        matchResult.put("sumAvbBaseQty", (Object)billSumAvbBaseQty.add(invDetailItem.getBigDecimal("availablebaseqty")));
        invDetailInfo.add((Object)invDetailItem);
        matchResult.put("invstatus", (Object)invStatus);
        matchResult.put("invdetailinfolist", (Object)invDetailInfo);
        return isEnough;
    }

    private static void setMatchResultVO(JSONObject matchResult, Row matchAvailableRow) {
        matchResult.put("saleorgid", (Object)matchAvailableRow.getLong("saleorgid"));
        matchResult.put("salechannelid", (Object)matchAvailableRow.getLong("salechannelid"));
        matchResult.put("admindivisionid", (Object)matchAvailableRow.getLong("admindivisionid"));
        matchResult.put("itemid", (Object)matchAvailableRow.getLong("itemid"));
        matchResult.put("auxptyid", (Object)matchAvailableRow.getLong("auxptyid"));
        matchResult.put("baseunitid", (Object)matchAvailableRow.getLong("baseunitid"));
        matchResult.put("baseunitqty", (Object)matchAvailableRow.getBigDecimal("baseunitqty"));
        matchResult.put("unitid", (Object)matchAvailableRow.getLong("unitid"));
        matchResult.put("unitqty", (Object)matchAvailableRow.getBigDecimal("unitqty"));
        matchResult.put("customerKey", (Object)matchAvailableRow.getString("customerKey"));
        matchResult.put("invstatus", (Object)matchAvailableRow.getString("invstatus"));
    }

    private static String getGroupFields(Row matchAvailableRow, long billInvTypeId) {
        ArrayList<Long> fields = new ArrayList<Long>(6);
        fields.add(matchAvailableRow.getLong("materialid"));
        fields.add(matchAvailableRow.getLong("auxptyid"));
        fields.add(matchAvailableRow.getLong("baseunitid"));
        fields.add(matchAvailableRow.getLong("stockorgid"));
        fields.add(matchAvailableRow.getLong("warehouseid"));
        fields.add(billInvTypeId);
        return StringUtils.join((Object[])fields.toArray(), (char)'_');
    }

    private static String getGroupFields(Map<String, Object> map) {
        ArrayList<Object> fields = new ArrayList<Object>(6);
        fields.add(map.get("material"));
        fields.add(map.get("auxpty"));
        fields.add(map.get("baseunit"));
        fields.add(map.get("org"));
        fields.add(map.get("warehouse"));
        fields.add(map.get("invtype"));
        return StringUtils.join((Object[])fields.toArray(), (char)'_');
    }
}

