/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.PosItemUtil;

public class ItemHelper {
    public static void fillItemEntity(ListSelectedRowCollection returnDatas, DynamicObjectCollection itemEntitys, String formid) {
        List<Object> id = returnDatas.stream().map(ListSelectedRow::getPrimaryKeyValue).collect(Collectors.toList());
        switch (formid) {
            case "ocdbd_iteminfo": {
                ItemHelper.addItemInfo(itemEntitys, id, formid);
                break;
            }
            case "mdr_item_class": {
                ItemHelper.addItemClass(itemEntitys, id, formid);
                break;
            }
            case "mdr_item_brand": {
                ItemHelper.addItemBrand(itemEntitys, id, formid);
                break;
            }
            case "ocdbd_item_label": {
                ItemHelper.addItemLabel(itemEntitys, id, formid);
                break;
            }
        }
    }

    public static void addItemLabel(DynamicObjectCollection itemEntitys, List<Object> id, String formid) {
        DynamicObject[] labelInfo;
        for (DynamicObject label : labelInfo = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject itemEntity = new DynamicObject(itemEntitys.getDynamicObjectType());
            itemEntity.set("itemlabelid", (Object)label);
            itemEntity.set("type", (Object)"4");
            itemEntity.set("typecopy", (Object)"4");
            itemEntitys.add((Object)itemEntity);
        }
    }

    public static void addItemBrand(DynamicObjectCollection itemEntitys, List<Object> id, String formid) {
        DynamicObject[] brandInfo;
        for (DynamicObject brand : brandInfo = BusinessDataServiceHelper.load((String)"mdr_item_brand", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject item = new DynamicObject(itemEntitys.getDynamicObjectType());
            item.set("brandid", (Object)brand);
            item.set("type", (Object)"3");
            item.set("typecopy", (Object)"3");
            itemEntitys.add((Object)item);
        }
    }

    public static void addItemClass(DynamicObjectCollection itemEntitys, List<Object> id, String formid) {
        DynamicObject[] classInfo;
        for (DynamicObject itemclass : classInfo = BusinessDataServiceHelper.load((String)"mdr_item_class", (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", id)})) {
            DynamicObject itemEntity = new DynamicObject(itemEntitys.getDynamicObjectType());
            itemEntity.set("itemclassid", (Object)itemclass);
            itemEntity.set("type", (Object)"2");
            itemEntity.set("typecopy", (Object)"2");
            itemEntitys.add((Object)itemEntity);
        }
    }

    public static void addItemInfo(DynamicObjectCollection itemEntitys, List<Object> itemId, String formid) {
        DynamicObject[] items;
        for (DynamicObject item : items = ItemHelper.getItemEntity(itemId)) {
            DynamicObject itemInfo = new DynamicObject(itemEntitys.getDynamicObjectType());
            itemInfo.set("type", (Object)"1");
            itemInfo.set("itemid", (Object)item);
            itemInfo.set("brandid", (Object)item.getDynamicObject("itembrands"));
            itemInfo.set("barcodeid", (Object)ItemHelper.getBarCodeInfo(item));
            itemInfo.set("itemlabelid", (Object)ItemHelper.getItemLabel(item));
            itemInfo.set("itemclassid", (Object)PosItemUtil.queryItemClass((DynamicObject)item));
            itemEntitys.add((Object)itemInfo);
        }
    }

    private static DynamicObject[] getItemEntity(List<Object> itemId) {
        return BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)ItemHelper.getItemInfoFeilds(), (QFilter[])new QFilter[]{new QFilter("id", "in", itemId)});
    }

    private static DynamicObject getBarCodeInfo(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_barcode", (String)"id", (QFilter[])new QFilter[]{new QFilter("item.id", "=", item.getPkValue())});
    }

    private static DynamicObject getItemLabel(DynamicObject item) {
        return BusinessDataServiceHelper.loadSingle((String)"ocdbd_item_label", (String)"id", (QFilter[])new QFilter[]{new QFilter("entryentity.item.id", "=", item.getPkValue())});
    }

    public static String getItemInfoFeilds() {
        return String.join((CharSequence)",", "itemclassentity.goodsclasssid", "itemclassentity.classstandardid", "itemclassentity", "itembrands", "retailunit");
    }
}

