/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.coderule.api.CodeRuleInfo;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class OlsGiftRecBillHelper {
    private static Log logger = LogFactory.getLog(OlsGiftRecBillHelper.class);
    private static final Long DELIVERSTATUS_NODELIVER = 1026065142993238016L;

    public static JSONObject createGiftRecBill(Map<String, Object> giftParams) {
        boolean isExceedTotalQty;
        JSONObject result = new JSONObject();
        Long storeId = (Long)giftParams.get("storeid");
        Long orgId = (Long)giftParams.get("orgid");
        Long memberId = (Long)giftParams.get("memberid");
        Long activityName = (Long)giftParams.get("activityname");
        String telephone = (String)giftParams.get("telephone");
        if (storeId == null || orgId == null || memberId == null || StringUtils.isEmpty((CharSequence)telephone) || activityName == null) {
            result.put("code", (Object)200);
            result.put("success", (Object)Boolean.FALSE);
            result.put("message", (Object)"\u5fc5\u4f20\u7684\u5165\u53c2\u6709\u7a7a\u503c");
            return result;
        }
        long operator = 0L;
        long guiderId = (Long)giftParams.get("guiderId");
        operator = guiderId > 0L ? guiderId : SystemParamUtil.getOnlineStoreDefaultSaler((long)orgId, (long)storeId);
        QFilter userFilter = new QFilter("id", "=", (Object)operator);
        DynamicObject channelUserInfo = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"sysuser", (QFilter[])new QFilter[]{userFilter});
        long sysUser = DynamicObjectUtil.getLong((DynamicObject)channelUserInfo, (String)"sysuser");
        Date nowTime = new Date();
        ArrayList<DynamicObject> tempArrays = new ArrayList<DynamicObject>();
        DynamicObject newDynObj = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_giftrecbill");
        DynamicObjectCollection giftrecentry = newDynObj.getDynamicObjectCollection("giftrecentry");
        CodeRuleInfo codeRuleInfo = CodeRuleServiceHelper.getCodeRule((String)newDynObj.getDataEntityType().getName(), (DynamicObject)newDynObj, null);
        newDynObj.set("billno", (Object)CodeRuleServiceHelper.getNumber((CodeRuleInfo)codeRuleInfo, (DynamicObject)newDynObj));
        newDynObj.set("billstatus", (Object)"C");
        newDynObj.set("storeid", (Object)storeId);
        newDynObj.set("bizdate", (Object)nowTime);
        newDynObj.set("orgid", (Object)orgId);
        newDynObj.set("memberid", (Object)memberId);
        newDynObj.set("telephone", (Object)telephone);
        newDynObj.set("receivestatus", (Object)"1");
        newDynObj.set("creator", (Object)sysUser);
        newDynObj.set("creator_id", (Object)sysUser);
        newDynObj.set("createtime", (Object)nowTime);
        newDynObj.set("modifier", (Object)sysUser);
        newDynObj.set("modifier_id", (Object)sysUser);
        newDynObj.set("modifytime", (Object)nowTime);
        newDynObj.set("auditor", (Object)sysUser);
        newDynObj.set("auditor_id", (Object)sysUser);
        newDynObj.set("auditdate", (Object)nowTime);
        List giftsList = (List)giftParams.get("giftsList");
        long giftTypeId = OlsGiftRecBillHelper.getGiftTypeIdByActivityId(activityName);
        for (Map giftMap : giftsList) {
            DynamicObject giftInfo = new DynamicObject(giftrecentry.getDynamicObjectType());
            Long giftId = (Long)giftMap.get("item");
            DynamicObject material = BusinessDataServiceHelper.loadSingle((String)"ocdbd_iteminfo", (String)"material", (QFilter[])new QFilter("id", "=", (Object)giftId).toArray());
            DynamicObject materielid = DynamicObjectUtil.getDynamicObject((DynamicObject)material, (String)"material");
            giftInfo.set("itemid", (Object)giftId);
            giftInfo.set("materielid", (Object)materielid);
            giftInfo.set("activityname", (Object)activityName);
            giftInfo.set("gifttype", (Object)giftTypeId);
            giftInfo.set("itemclassid", giftMap.get("itemclass"));
            giftInfo.set("receivenum", giftMap.get("receivenum"));
            giftInfo.set("unit", giftMap.get("unit"));
            giftInfo.set("receivetime", (Object)nowTime);
            giftInfo.set("guiderid", giftMap.get("guider"));
            giftInfo.set("guidephone", giftMap.get("guidephone"));
            DynamicObject giftSet = QueryServiceHelper.queryOne((String)"ocdbd_giftset", (String)"goodsentry.stocktypeid, goodsentry.warehouseid", (QFilter[])OlsGiftRecBillHelper.getGiftSetFilter(storeId, activityName, giftId).toArray());
            if (giftSet != null) {
                QFilter qFilter;
                long stockTypeId = DynamicObjectUtil.getLong((DynamicObject)giftSet, (String)"goodsentry.stocktypeid");
                giftInfo.set("stocktypeid", (Object)stockTypeId);
                long warehouse = DynamicObjectUtil.getLong((DynamicObject)giftSet, (String)"goodsentry.warehouseid");
                if (warehouse != 0L) {
                    giftInfo.set("warehouseid", (Object)warehouse);
                    qFilter = new QFilter("warehouse", "=", (Object)warehouse);
                    qFilter.and("startstatus", "=", (Object)"B");
                    DynamicObject warehouseSetup = QueryServiceHelper.queryOne((String)"im_warehousesetup", (String)"org", (QFilter[])qFilter.toArray());
                    if (warehouseSetup != null) {
                        giftInfo.set("stockoryid", (Object)DynamicObjectUtil.getLong((DynamicObject)warehouseSetup, (String)"org"));
                    }
                } else {
                    long erpWarehouseId;
                    qFilter = new QFilter("ownerchannelid", "=", (Object)storeId);
                    qFilter.and("isdelivery", "=", (Object)"1");
                    DynamicObject erpWarehouse = QueryServiceHelper.queryOne((String)"ococic_warehouse", (String)"erpwarehouseid", (QFilter[])qFilter.toArray());
                    if (erpWarehouse != null && (erpWarehouseId = DynamicObjectUtil.getLong((DynamicObject)erpWarehouse, (String)"erpwarehouseid")) != 0L) {
                        giftInfo.set("warehouseid", (Object)erpWarehouseId);
                        qFilter = new QFilter("warehouse", "=", (Object)erpWarehouseId);
                        qFilter.and("startstatus", "=", (Object)"B");
                        DynamicObject warehouseSetup = QueryServiceHelper.queryOne((String)"im_warehousesetup", (String)"org", (QFilter[])qFilter.toArray());
                        if (warehouseSetup != null) {
                            giftInfo.set("stockoryid", (Object)DynamicObjectUtil.getLong((DynamicObject)warehouseSetup, (String)"org"));
                        }
                    }
                }
            }
            giftInfo.set("deliverstatusid", (Object)DELIVERSTATUS_NODELIVER);
            giftrecentry.add((Object)giftInfo);
        }
        newDynObj.set("giftrecentry", (Object)giftrecentry);
        tempArrays.add(newDynObj);
        long itemId = (Long)((Map)giftsList.get(0)).get("item");
        Map<Long, BigDecimal> queryAllGiftsNum = OlsGiftRecBillHelper.queryAllGiftsNum(storeId, activityName, itemId, 0L);
        BigDecimal allGiftsNum = queryAllGiftsNum.get(itemId);
        BigDecimal singleQty = (BigDecimal)giftParams.get("singleQty");
        boolean bl = isExceedTotalQty = allGiftsNum.compareTo(singleQty) >= 0;
        if (isExceedTotalQty) {
            result.put("code", (Object)"102");
            result.put("success", (Object)Boolean.FALSE);
            result.put("message", (Object)"\u9886\u53d6\u6570\u91cf\u8d85\u51fa\u9650\u5236\uff01");
            return result;
        }
        Object[] resultMap = SaveServiceHelper.save((DynamicObject[])tempArrays.toArray(new DynamicObject[tempArrays.size()]));
        if (resultMap != null && resultMap.length > 0) {
            result.put("code", (Object)"100");
            result.put("success", (Object)Boolean.TRUE);
            result.put("message", (Object)"\u751f\u6210\u9886\u53d6\u5355\u6210\u529f");
            result.put("data", (Object)resultMap);
        } else {
            result.put("code", (Object)"101");
            result.put("success", (Object)Boolean.FALSE);
            result.put("message", (Object)"\u751f\u6210\u9886\u53d6\u5355\u5931\u8d25");
            result.put("data", (Object)resultMap);
        }
        return result;
    }

    public static Map<Long, BigDecimal> queryAllGiftsNum(Long storeId, Long activityId, Long itemId, long memberId) {
        HashMap<Long, BigDecimal> result = new HashMap<Long, BigDecimal>();
        BigDecimal giftNum = BigDecimal.ZERO;
        if (storeId == null || activityId == null || itemId == null) {
            return result;
        }
        giftNum = OlsGiftRecBillHelper.queryGiftsNum(storeId, activityId, itemId, memberId);
        result.put(itemId, giftNum);
        return result;
    }

    public static BigDecimal queryGiftsNum(Long storeId, Long activityId, Long itemId, long memberId) {
        BigDecimal giftNum = BigDecimal.ZERO;
        if (storeId == null || activityId == null || itemId == null) {
            return giftNum;
        }
        QFilter qFilter = new QFilter("storeid", "=", (Object)storeId);
        if (memberId > 0L) {
            qFilter.and("memberid", "=", (Object)memberId);
        }
        qFilter.and("giftrecentry.activityname", "=", (Object)activityId);
        qFilter.and("giftrecentry.itemid", "=", (Object)itemId);
        qFilter.and("billstatus", "=", (Object)"C");
        qFilter.and("receivestatus", "=", (Object)"1");
        DynamicObjectCollection giftsInfo = QueryServiceHelper.query((String)"ocpos_giftrecbill", (String)"giftrecentry.receivenum", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)giftsInfo)) {
            for (DynamicObject giftInfo : giftsInfo) {
                BigDecimal receiveNum = DynamicObjectUtil.getBigDecimal((DynamicObject)giftInfo, (String)"giftrecentry.receivenum");
                giftNum = giftNum.add(receiveNum);
            }
        }
        return giftNum;
    }

    public static boolean saveRecGiftsNum(Long storeId, Long activityId, Long itemId) {
        DynamicObject[] giftSets = BusinessDataServiceHelper.load((String)"ocdbd_giftset", (String)"goodsentry, goodsentry.goodsid, goodsentry.receivedqty", (QFilter[])OlsGiftRecBillHelper.getGiftSetFilter(storeId, activityId, itemId).toArray());
        BigDecimal giftNum = OlsGiftRecBillHelper.queryGiftsNum(storeId, activityId, itemId, 0L);
        for (DynamicObject giftSet : giftSets) {
            DynamicObjectCollection goodsentry = giftSet.getDynamicObjectCollection("goodsentry");
            for (DynamicObject goods : goodsentry) {
                long goodsid = goods.getLong("goodsid.id");
                if (itemId != goodsid) continue;
                goods.set("receivedqty", (Object)giftNum);
            }
        }
        try {
            SaveServiceHelper.update((DynamicObject[])giftSets);
        }
        catch (Throwable e) {
            logger.error("\u793c\u54c1\u9886\u53d6\u6570\u91cf\u53cd\u5199\u5931\u8d25:");
            logger.error(ExceptionUtils.getStackTrace((Throwable)e));
            throw e;
        }
        return true;
    }

    public static QFilter getGiftSetFilter(Long storeId, Long activityId, Long itemId) {
        QFilter qFilter1 = new QFilter("id", "=", (Object)activityId);
        qFilter1.and("goodsentry.goodsid", "=", (Object)itemId);
        qFilter1.and("branchid", "=", (Object)storeId);
        qFilter1.and("storesetting", "=", (Object)"1");
        qFilter1.and("activestatus", "=", (Object)"B");
        qFilter1.and("status", "=", (Object)"C");
        QFilter qFilter2 = new QFilter("storesetting", "=", (Object)"2");
        qFilter2.and("controlmethod", "=", (Object)"0");
        qFilter2.and("id", "=", (Object)activityId);
        qFilter2.and("goodsentry.goodsid", "=", (Object)itemId);
        qFilter2.and("activestatus", "=", (Object)"B");
        qFilter2.and("status", "=", (Object)"C");
        QFilter qFilter3 = new QFilter("storesetting", "=", (Object)"2");
        qFilter3.and("controlmethod", "=", (Object)"1");
        qFilter3.and("branchentry.branch", "in", (Object)storeId);
        qFilter3.and("goodsentry.goodsid", "in", (Object)itemId);
        qFilter3.and("id", "=", (Object)activityId);
        qFilter3.and("activestatus", "=", (Object)"B");
        qFilter3.and("status", "=", (Object)"C");
        QFilter qFilter4 = qFilter1.or(qFilter2).or(qFilter3);
        return qFilter4;
    }

    private static long getGiftTypeIdByActivityId(long activityId) {
        QFilter filter = new QFilter("id", "=", (Object)activityId);
        String selectFields = "id,gifttype";
        DynamicObject giftSetInfo = QueryServiceHelper.queryOne((String)"ocdbd_giftset", (String)selectFields, (QFilter[])filter.toArray());
        return DynamicObjectUtil.getLong((DynamicObject)giftSetInfo, (String)"gifttype");
    }

    public static int queryVipRecNum(long activityId, long memberId) {
        int vipHasRecNum = 0;
        if (activityId == 0L || memberId == 0L) {
            return vipHasRecNum;
        }
        long giftTypeId = OlsGiftRecBillHelper.getGiftTypeIdByActivityId(activityId);
        QFilter qFilter = new QFilter("memberid", "=", (Object)memberId);
        qFilter.and("giftrecentry.gifttype", "=", (Object)giftTypeId);
        qFilter.and("receivestatus", "=", (Object)"1");
        qFilter.and("billstatus", "=", (Object)"C");
        DynamicObjectCollection giftsInfo = QueryServiceHelper.query((String)"ocpos_giftrecbill", (String)"giftrecentry.receivenum", (QFilter[])qFilter.toArray());
        if (!CollectionUtils.isEmpty((Collection)giftsInfo)) {
            vipHasRecNum = giftsInfo.size();
        }
        return vipHasRecNum;
    }
}

