/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.F7Utils;

public class OlsPersonalizedHelper {
    public static List<Map<String, Object>> getHomeMallData(Long classStanderedId, Long BranchId) {
        List<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        long[] ids = OlsPersonalizedHelper.getAllpubstrategy(classStanderedId, BranchId);
        Long billId = OlsPersonalizedHelper.preciseSelectBill(ids);
        if (billId == null) {
            return result;
        }
        DynamicObject olsPersonalized = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_olspersonalized");
        result = OlsPersonalizedHelper.encapsulateData(olsPersonalized);
        return result;
    }

    private static List<Map<String, Object>> encapsulateData(DynamicObject olsPersonalized) {
        DynamicObjectCollection firstEntryEntity = olsPersonalized.getDynamicObjectCollection("firstentryentity");
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (DynamicObject firstEntryRow : firstEntryEntity) {
            HashMap<String, Object> firstMap = new HashMap<String, Object>();
            if (!firstEntryRow.getBoolean("isshow")) continue;
            firstMap.put("firstitemclassid", firstEntryRow.get("firstitemclassid"));
            firstMap.put("sort", firstEntryRow.get("sort"));
            ArrayList secondEntry = new ArrayList();
            String uid = firstEntryRow.getString("uid");
            DynamicObjectCollection secondEntryEntity = olsPersonalized.getDynamicObjectCollection("secondentryentity");
            for (DynamicObject secondEntryRow : secondEntryEntity) {
                if (!StringUtils.equals((CharSequence)uid, (CharSequence)secondEntryRow.getString("parententryuid")) || secondEntryRow.get("seconditemclassid") == null && !secondEntryRow.getBoolean("isitembrand") && !secondEntryRow.getBoolean("isitemlable")) continue;
                HashMap<String, Object> secondMap = new HashMap<String, Object>();
                secondMap.put("titlename", secondEntryRow.get("titlename"));
                secondMap.put("seconditemclassid", secondEntryRow.get("seconditemclassid"));
                secondMap.put("isitembrand", secondEntryRow.get("isitembrand"));
                secondMap.put("isitemlable", secondEntryRow.get("isitemlable"));
                secondMap.put("subsort", secondEntryRow.get("subsort"));
                DynamicObjectCollection thirdEntryEntity = secondEntryRow.getDynamicObjectCollection("thirdentryentity");
                ArrayList thirdEntry = new ArrayList();
                for (DynamicObject thirdEntryRow : thirdEntryEntity) {
                    if (thirdEntryRow.get("thirditemclassid") == null && thirdEntryRow.get("itembrandid") == null && thirdEntryRow.get("itemlableid") == null) continue;
                    HashMap<String, Object> thirdMap = new HashMap<String, Object>();
                    thirdMap.put("thirditemclassid", thirdEntryRow.get("thirditemclassid"));
                    thirdMap.put("itembrandid", thirdEntryRow.get("itembrandid"));
                    thirdMap.put("itemlableid", thirdEntryRow.get("itemlableid"));
                    thirdMap.put("picture", thirdEntryRow.get("picture"));
                    thirdMap.put("thirdsort", thirdEntryRow.get("thirdsort"));
                    thirdEntry.add(thirdMap);
                }
                secondMap.put("thirdentryentity", thirdEntry);
                secondEntry.add(secondMap);
            }
            firstMap.put("secondentryentity", secondEntry);
            result.add(firstMap);
        }
        return result;
    }

    private static Long preciseSelectBill(long[] ids) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and("isdefault", "=", (Object)Boolean.TRUE);
        DynamicObjectCollection defaultBills = QueryServiceHelper.query((String)"ocpos_olspersonalized", (String)"id", (QFilter[])qFilter.toArray());
        if (defaultBills.isEmpty()) {
            return null;
        }
        long defaultBillId = ((DynamicObject)defaultBills.get(0)).getLong("id");
        if (ArrayUtils.isEmpty((long[])ids) || ArrayUtils.contains((long[])ids, (long)defaultBillId)) {
            return defaultBillId;
        }
        return ids[0];
    }

    private static long[] getAllpubstrategy(Long classStanderedId, Long BranchId) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)"C");
        qFilter.and("classstanderedid", "=", (Object)classStanderedId);
        qFilter.and("branchid.fbasedataid", "=", (Object)BranchId);
        DynamicObjectCollection billsDataSet = QueryServiceHelper.query((String)"ocpos_olspersonalized", (String)"id", (QFilter[])qFilter.toArray());
        return billsDataSet.stream().mapToLong(s -> s.getLong("id")).toArray();
    }

    public static List<DynamicObject> getThirdLevelItemClassIds(List<Long> firstLevelItemClassIds) {
        QFilter fFilter = F7Utils.getCommonStatusFilter();
        fFilter.and("id", "in", firstLevelItemClassIds);
        DynamicObjectCollection firstLevelItemClass = QueryServiceHelper.query((String)"mdr_item_class", (String)"id", (QFilter[])fFilter.toArray());
        firstLevelItemClassIds = firstLevelItemClass.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        QFilter qFilter = F7Utils.getCommonStatusFilter();
        qFilter.and("parent", "in", firstLevelItemClassIds);
        DynamicObjectCollection secondLevelItemClass = QueryServiceHelper.query((String)"mdr_item_class", (String)"id", (QFilter[])qFilter.toArray());
        List secondLevelItemClassIds = secondLevelItemClass.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("parent", "in", secondLevelItemClassIds);
        DynamicObjectCollection thirdLevelItemClass = QueryServiceHelper.query((String)"mdr_item_class", (String)"id", (QFilter[])filter.toArray());
        MainEntityType type = EntityMetadataCache.getDataEntityType((String)"mdr_item_class");
        DynamicObject[] thirdLevelItemClassArray = BusinessDataServiceHelper.load((Object[])thirdLevelItemClass.stream().map(s -> s.getLong("id")).toArray(), (DynamicObjectType)type);
        return new ArrayList<DynamicObject>(Arrays.asList(thirdLevelItemClassArray));
    }
}

