/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;

public class OlstoreCartProcessor {
    public DynamicObjectCollection getOlstoreCartList(long userId, long customerId, int isOnlinePurchase, int page, int pageSize) {
        QFilter filter = new QFilter("userid", "=", (Object)userId);
        filter.and("customerid", "=", (Object)customerId);
        filter.and("isonlinepurchase", "=", (Object)String.valueOf(isOnlinePurchase));
        int fromIndex = page <= 1 ? 0 : (page - 1) * pageSize;
        DynamicObject[] cartIdArr = BusinessDataServiceHelper.load((String)"ocpos_olscart", (String)"id", (QFilter[])filter.toArray(), (String)" id desc ", (int)fromIndex, (int)pageSize);
        if (cartIdArr == null || cartIdArr.length == 0) {
            return new DynamicObjectCollection();
        }
        ArrayList cartIds = new ArrayList(0);
        cartIds.addAll(Arrays.stream(cartIdArr).map(x -> x.getLong("id")).collect(Collectors.toList()));
        filter = new QFilter("id", "in", cartIds);
        String cartSelectField = "id,userid,customerid,itemid,itemid.name,itemid.number,itemid.thumbnail,isonlinepurchase,qty,auxptyid,unitid,barcodeid";
        return QueryServiceHelper.query((String)"ocpos_olscart", (String)cartSelectField, (QFilter[])filter.toArray());
    }

    public void updateCartQtyById(long cartId, BigDecimal qty) {
        QFilter filter = new QFilter("id", "=", (Object)cartId);
        DynamicObject cartInfo = BusinessDataServiceHelper.loadSingle((String)"ocpos_olscart", (String)"id,qty,createtime", (QFilter[])filter.toArray());
        if (cartInfo != null) {
            cartInfo.set("qty", (Object)qty);
            cartInfo.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cartInfo});
        }
    }

    public void deleteCartById(List<Object> cartId) {
        if (cartId != null && cartId.size() > 0) {
            QFilter filter = new QFilter("id", "in", cartId.stream().map(s -> Long.parseLong(s.toString())).collect(Collectors.toList()));
            DeleteServiceHelper.delete((String)"ocpos_olscart", (QFilter[])filter.toArray());
        }
    }

    public DynamicObjectCollection getOlstoreCartList(List<Object> cartIds) {
        List cartIdList = cartIds.stream().map(s -> Long.parseLong(s.toString())).collect(Collectors.toList());
        QFilter filter = new QFilter("id", "in", cartIdList);
        String cartSelectField = "id,userid,customerid,itemid,itemid.name,itemid.number,barcodeid.id,itemid.thumbnail,unitid.id,auxptyid.id,qty,isonlinepurchase";
        return QueryServiceHelper.query((String)"ocpos_olscart", (String)"id,userid,customerid,itemid,itemid.name,itemid.number,barcodeid.id,itemid.thumbnail,unitid.id,auxptyid.id,qty,isonlinepurchase", (QFilter[])filter.toArray());
    }

    public void addCart(long customerId, long memberId, long itemId, long unitid, long auxptyId, long barcodeId, BigDecimal qty, int isOnlinePurchase) {
        DynamicObject cart = this.searchCart(customerId, memberId, itemId, auxptyId, isOnlinePurchase);
        if (cart != null) {
            cart.set("qty", (Object)cart.getBigDecimal("qty").add(qty));
            cart.set("createtime", (Object)new Date());
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cart});
            return;
        }
        cart = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_olscart");
        cart.set("userid", (Object)memberId);
        cart.set("customerid", (Object)customerId);
        cart.set("itemid", (Object)itemId);
        cart.set("unitid", (Object)unitid);
        cart.set("auxptyid", (Object)auxptyId);
        cart.set("barcodeid", (Object)barcodeId);
        cart.set("qty", (Object)qty);
        cart.set("isonlinepurchase", (Object)isOnlinePurchase);
        cart.set("createtime", (Object)new Date());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{cart});
    }

    public DynamicObject searchCart(long customerId, long memberId, long itemId, long auxptyId, int isOnlinePurchase) {
        QFilter filter = new QFilter("userid", "=", (Object)memberId);
        filter.and(new QFilter("customerid", "=", (Object)customerId));
        filter.and(new QFilter("itemid", "=", (Object)itemId));
        filter.and(new QFilter("auxptyid", "=", (Object)auxptyId));
        filter.and(new QFilter("isonlinepurchase", "=", (Object)String.valueOf(isOnlinePurchase)));
        DynamicObject[] cardArray = BusinessDataServiceHelper.load((String)"ocpos_olscart", (String)"id,qty,createtime", (QFilter[])filter.toArray());
        if (cardArray != null && cardArray.length > 0) {
            return cardArray[0];
        }
        return null;
    }
}

