/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.ControlModeEnum;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.UserUtil;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.common.enums.OlstorePriceWayEnum;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.StringUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class OlstoreConfigProcessor {
    protected static Log logger = LogFactory.getLog(OlstoreConfigProcessor.class);

    public DynamicObject getOlstoreConfig() {
        if (!QueryServiceHelper.exists((String)"ocpos_olstoreconfig", (Object)1L)) {
            MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocpos_olstoreconfig");
            DynamicObject data = new DynamicObject((DynamicObjectType)entityType);
            data.set("id", (Object)1L);
            data.set("number", (Object)"ols001");
            data.set("name", (Object)"\u7ebf\u4e0a\u95e8\u5e97");
            data.set("template", (Object)"1");
            data.set("creatorid", UserUtil.getUserID());
            data.set("createtime", (Object)new Date());
            data.set("status", (Object)"A");
            data.set("distancestore", (Object)5.0);
            data.set("autocanceldate", (Object)30);
            DynamicObject[] saveData = new DynamicObject[]{data};
            SaveServiceHelper.save((DynamicObject[])saveData);
        }
        return BusinessDataServiceHelper.loadSingle((Object)1L, (String)"ocpos_olstoreconfig");
    }

    public void saveAuditInfo(String entityId, List<Object> ids) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityId);
        String tableName = entityType.getAlias();
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE ");
        sql.append(tableName);
        sql.append(" SET FAPPROVERID = ");
        sql.append(UserUtil.getUserID());
        sql.append(" ,FAPPROVEDATE = ' ");
        sql.append(DateUtil.getDateTimeFormat((Date)TimeServiceHelper.now()));
        sql.append(" ' WHERE FID IN ( ");
        sql.append(StringUtils.join((Object[])ids.toArray(), (String)","));
        sql.append(")");
        DB.update((DBRoute)new DBRoute(entityType.getDBRouteKey()), (String)sql.toString());
    }

    public String checkWindowSingle(Object id, List<String> customerIds, Date startTime, Date endTime) {
        DynamicObjectCollection data;
        QFilter filter = new QFilter("customerid.fbasedataid.id", "in", customerIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
        filter.and("starttime", "<", (Object)endTime);
        filter.and("endtime", ">", (Object)startTime);
        if (id != null) {
            filter.and("id", "!=", (Object)Long.parseLong(id.toString()));
        }
        if ((data = QueryServiceHelper.query((String)"ocpos_olstorewindow", (String)"customerid.fbasedataid.name", (QFilter[])filter.toArray())) != null && data.size() > 0) {
            List customerNames = data.stream().map(r -> r.getString("customerid.fbasedataid.name")).collect(Collectors.toList());
            return StringUtil.joinList((String)",", customerNames);
        }
        return "";
    }

    public List<String> getItemClassByItemId(long itemid) {
        QFilter filter = new QFilter("id", "=", (Object)itemid);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id,itemclassentity.goodsclasssid.id", (QFilter[])filter.toArray());
        if (data != null) {
            return data.stream().map(r -> r.getLong("itemclassentity.goodsclasssid.id") + "").collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    public List<String> checkScrollImageCustomerDuplicate(List<String> customerids) {
        QFilter filter = new QFilter("customerid.fbasedataid.id", "in", customerids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocpos_olsscrollimage", (String)"id,customerid.fbasedataid.id,customerid.fbasedataid.name", (QFilter[])filter.toArray());
        if (data != null) {
            return data.stream().map(r -> r.getString("customerid.fbasedataid.name") + "").collect(Collectors.toList());
        }
        return null;
    }

    public DynamicObject getDefaultOlsCustomer() {
        QFilter filter = new QFilter("sysuser.id", "=", UserUtil.getUserID());
        filter.and(new QFilter("owner.isonlinestore", "=", (Object)"1"));
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocdbd_channeluser", (String)"sysuser.id,owner.id,owner.saleorg.id,isdefault", (QFilter[])filter.toArray(), (String)"isdefault desc ");
        if (data != null && data.size() > 0) {
            return (DynamicObject)data.get(0);
        }
        return null;
    }

    public List<Object> getOlsDefalutSearchId(String filterValues, String entityId) {
        DynamicObjectCollection userList;
        DynamicObjectCollection customerList;
        DynamicObjectCollection orgList;
        QFilter filter = null;
        String filterValue = filterValues.split("#")[1];
        List orgids = null;
        List customerids = null;
        List userids = null;
        if (filterValues.contains("orgid") && (orgList = QueryServiceHelper.query((String)"bos_org", (String)"id", (QFilter[])(filter = QFilter.ftlike((String)filterValue, (String[])new String[]{"name,number"})).toArray())) != null && orgList.size() > 0) {
            orgids = orgList.stream().map(r -> r.get("id")).collect(Collectors.toList());
        }
        if (filterValues.contains("customerid") && (customerList = QueryServiceHelper.query((String)"ocdbd_channel", (String)"id", (QFilter[])(filter = QFilter.ftlike((String)filterValue, (String[])new String[]{"name,number"})).toArray())) != null && customerList.size() > 0) {
            customerids = customerList.stream().map(r -> r.get("id")).collect(Collectors.toList());
        }
        if (filterValues.contains("creatorid.name") && (userList = QueryServiceHelper.query((String)"bos_usergroup_user", (String)"id", (QFilter[])(filter = QFilter.ftlike((String)filterValue, (String[])new String[]{"name"})).toArray())) != null && userList.size() > 0) {
            userids = userList.stream().map(r -> r.get("id")).collect(Collectors.toList());
        }
        filter = null;
        if (orgids != null) {
            filter = new QFilter("orgid.fbasedataid.id", "in", orgids);
        }
        if (customerids != null) {
            QFilter qFilter = filter = filter == null ? new QFilter("customerid.fbasedataid.id", "in", customerids) : filter.or("customerid.fbasedataid.id", "in", customerids);
        }
        if (filterValues.contains("creatorid.name")) {
            QFilter qFilter = filter = filter == null ? new QFilter("creatorid", "in", userids) : filter.or("creatorid", "in", userids);
        }
        if (filter == null) {
            return new ArrayList<Object>(){
                {
                    this.add("0");
                }
            };
        }
        DynamicObjectCollection data = QueryServiceHelper.query((String)entityId, (String)"id", (QFilter[])filter.toArray());
        if (data != null && data.size() > 0) {
            return data.stream().map(r -> r.get("id")).collect(Collectors.toList());
        }
        return new ArrayList<Object>(){
            {
                this.add("0");
            }
        };
    }

    public List<Long> getOlsCustomerBizGroup(List<Long> customerIds) {
        QFilter filter = new QFilter("id", "in", customerIds);
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocdbd_channel", (String)"id,saleorg.id", (QFilter[])filter.toArray());
        if (data != null && data.size() > 0) {
            return data.stream().map(r -> r.getLong("saleorg.id")).collect(Collectors.toList());
        }
        return null;
    }

    protected QFilter buildBaseFilter(String operatingSelect) {
        Date currentTime = TimeServiceHelper.now();
        QFilter filter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("starttime", "<", (Object)currentTime);
        filter.and("endtime", ">", (Object)currentTime);
        if (StringUtil.isNotNull((String)operatingSelect)) {
            filter.and("operatingselect", "=", (Object)operatingSelect);
        }
        return filter;
    }

    public DynamicObject[] getOlsScrollImage(long customerId) {
        QFilter qfilter = this.buildBaseFilter(null);
        qfilter.and("treeentryentity.branch.Id", "=", (Object)customerId);
        qfilter.and("treeentryentity.isapply", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObject[] olsScrollImageList = this.getOlsScrollImageList(qfilter);
        if (olsScrollImageList == null || olsScrollImageList.length == 0) {
            QFilter filter = this.buildBaseFilter(null);
            filter.and("controlmode", "=", (Object)ControlModeEnum.ALLSTORE.getValue());
            olsScrollImageList = this.getOlsScrollImageList(filter);
        }
        return olsScrollImageList;
    }

    protected DynamicObject[] getOlsScrollImageList(QFilter filter) {
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)"ocpos_olslideshow").getAllFields().keySet();
        return BusinessDataServiceHelper.load((String)"ocpos_olslideshow", (String)String.join((CharSequence)",", selectorSet), (QFilter[])filter.toArray());
    }

    public Map<String, List<JSONObject>> getOlsWindowList(long customerId, int startPage, int pageSize) {
        QFilter filter = new QFilter("customerid.fbasedataid.id", "=", (Object)customerId);
        filter.and("status", "=", (Object)"C");
        filter.and("starttime", "<", (Object)new Date());
        filter.and("endtime", ">", (Object)new Date());
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocpos_olstorewindow", (String)"entryentity.id,entryentity.windowname,entryentity.index,entryentity.subentryentity.itemid.id,entryentity.subentryentity.itemclassid.id", (QFilter[])filter.toArray(), (String)" entryentity.index asc ");
        Map dataMap = data.stream().collect(Collectors.groupingBy(r -> r.getString("entryentity.index"), Collectors.toList()));
        LinkedHashMap<String, List<JSONObject>> resultMap = new LinkedHashMap<String, List<JSONObject>>(dataMap.size());
        for (Map.Entry entry : dataMap.entrySet()) {
            List subentry = entry.getValue();
            DynamicObject object = (DynamicObject)subentry.get(0);
            List<String> itemids = subentry.stream().filter(r -> r.getLong("entryentity.subentryentity.itemid.id") > 0L).map(r -> r.getString("entryentity.subentryentity.itemid.id")).collect(Collectors.toList());
            List<String> itemClassids = subentry.stream().filter(r -> r.getLong("entryentity.subentryentity.itemclassid.id") > 0L).map(r -> r.getString("entryentity.subentryentity.itemclassid.id")).collect(Collectors.toList());
            List<JSONObject> returnData = OlstoreItemHelper.queryItemListByItemIds(itemids, itemClassids, customerId, startPage, pageSize);
            resultMap.put(object.getString("entryentity.id") + "_" + object.getString("entryentity.windowname"), returnData);
        }
        return resultMap;
    }

    public JSONObject getItemRecomList(long customerId, String operatingSelect) {
        DynamicObject[] itemRecoms = this.getItemRecom(customerId, operatingSelect);
        JSONArray itemRecomList = new JSONArray();
        if (itemRecoms != null && itemRecoms.length > 0) {
            JSONObject result = new JSONObject();
            DynamicObject itemRecom = itemRecoms[0];
            result.put("operatingsubject", (Object)itemRecom.getString("operatingsubject"));
            DynamicObjectCollection entryentity = itemRecom.getDynamicObjectCollection("entryentity");
            HashSet<String> brandIdList = new HashSet<String>();
            HashSet<String> itemClassIdList = new HashSet<String>();
            HashSet<String> itemLabelIdList = new HashSet<String>();
            HashSet<String> itemIdList = new HashSet<String>();
            String appendStr = OlstoreUtil.buildItemParamAppendStr();
            for (DynamicObject entry : entryentity) {
                if (entry.getDynamicObject("itemid") != null) {
                    itemIdList.add(entry.getString("itemid.id"));
                }
                if (entry.getDynamicObject("brandid") != null) {
                    brandIdList.add(entry.getString("brandid.id"));
                }
                if (entry.getDynamicObject("itemclassid") != null) {
                    itemClassIdList.add(entry.getString("itemclassid.id"));
                }
                if (entry.getString("itemlabelid") == null) continue;
                itemLabelIdList.add(entry.getString("itemlabelid.id"));
            }
            if (itemClassIdList.size() > 0 || brandIdList.size() > 0 || itemLabelIdList.size() > 0) {
                String[] itemClassList = (String[])Arrays.copyOf(itemClassIdList.toArray(), itemClassIdList.size(), String[].class);
                JSONArray items = OlstoreItemHelper.getItemList(String.valueOf(customerId), null, itemClassList, "", String.valueOf(0), String.valueOf(100), appendStr, new ArrayList<String>(brandIdList), new ArrayList<String>(itemLabelIdList), null, null);
                if (items != null && items.size() > 0) {
                    for (int i = 0; i < items.size(); ++i) {
                        JSONObject jsonObject = items.getJSONObject(i);
                        itemRecomList.add((Object)jsonObject);
                    }
                }
            }
            if (itemIdList.size() > 0) {
                JSONArray items;
                String[] itemIds = (String[])Arrays.copyOf(itemIdList.toArray(), itemIdList.size(), String[].class);
                JSONObject returnData = OlstoreItemHelper.queryItemListByItemIds(String.valueOf(customerId), itemIds, appendStr);
                if ("0000".equals(returnData.get((Object)"code").toString()) && (items = returnData.getJSONArray("data")) != null && items.size() > 0) {
                    for (int i = 0; i < items.size(); ++i) {
                        JSONObject jsonObject = items.getJSONObject(i);
                        itemRecomList.add((Object)jsonObject);
                    }
                }
            }
            itemRecomList = this.updatePriceBySys(customerId, itemRecomList);
            result.put("itemRecomList", (Object)itemRecomList);
            return result;
        }
        return null;
    }

    private JSONArray updatePriceBySys(long customerId, JSONArray itemRecomList) {
        if (itemRecomList != null && itemRecomList.size() > 0) {
            for (int i = 0; i < itemRecomList.size(); ++i) {
                JSONObject jsonObject = itemRecomList.getJSONObject(i);
                String priceWay = this.getOnlineTakePriceWay(customerId);
                if (OlstorePriceWayEnum.ONLINEPRICE.getValue().equals(priceWay)) {
                    jsonObject.put("minmemberprice", (Object)jsonObject.getBigDecimal("minonlineprice"));
                    jsonObject.put("maxmemberprice", (Object)jsonObject.getBigDecimal("maxonlineprice"));
                    jsonObject.put("memberprice", (Object)jsonObject.getBigDecimal("onlineprice"));
                    continue;
                }
                if (!OlstorePriceWayEnum.RETAILPRICE.getValue().equals(priceWay)) continue;
                jsonObject.put("minmemberprice", (Object)jsonObject.getBigDecimal("minretailprice"));
                jsonObject.put("maxmemberprice", (Object)jsonObject.getBigDecimal("maxretailprice"));
                jsonObject.put("memberprice", (Object)jsonObject.getBigDecimal("retailprice"));
            }
        }
        return itemRecomList;
    }

    private String getOnlineTakePriceWay(long branchId) {
        long orgId = OlstoreInventoryHelper.getSaleOrgIdByChannelId(branchId);
        return SystemParamUtil.getOnlineTakePriceWay((long)orgId, (long)branchId);
    }

    public DynamicObject[] getItemRecom(long customerId, String operatingSelect) {
        QFilter qfilter = this.buildBaseFilter(operatingSelect);
        qfilter.and("treeentryentity.branch.Id", "=", (Object)customerId);
        qfilter.and("treeentryentity.isapply", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        DynamicObject[] olsScrollImageList = this.getItemRecomList(qfilter);
        if (olsScrollImageList == null || olsScrollImageList.length == 0) {
            QFilter filter = this.buildBaseFilter(operatingSelect);
            filter.and("controlmode", "=", (Object)ControlModeEnum.ALLSTORE.getValue());
            olsScrollImageList = this.getItemRecomList(filter);
        }
        return olsScrollImageList;
    }

    protected DynamicObject[] getItemRecomList(QFilter filter) {
        Set selectorSet = EntityMetadataCache.getDataEntityType((String)"ocpos_itemrecom").getAllFields().keySet();
        return BusinessDataServiceHelper.load((String)"ocpos_itemrecom", (String)String.join((CharSequence)",", selectorSet), (QFilter[])filter.toArray());
    }

    private List<JSONObject> getSpuItemList(JSONObject item, List<String> itemIds, long customerId) {
        String itemId = item.getString("itemid");
        String spuId = item.getString("spuid");
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject itemDetail = OlstoreItemHelper.getItemDetail(String.valueOf(customerId), spuId, itemId, appendStr);
        logger.info("\u9996\u9875\u6a71\u7a97spu\u5546\u54c1\uff1a" + itemDetail);
        if ("0000".equals(itemDetail.get((Object)"code").toString())) {
            List<JSONObject> list = JSONObject.parseArray((String)itemDetail.getJSONArray("data").toJSONString(), JSONObject.class);
            list = list.stream().filter(p -> itemIds.contains(p.getString("itemid"))).collect(Collectors.toList());
            for (JSONObject jsonObject : list) {
                jsonObject.put("minmemberprice", (Object)jsonObject.getBigDecimal("memberprice"));
            }
            return list;
        }
        return null;
    }

    private String[] getItemItemIds(List<String> itemids, List<String> itemClassids, long customerId, String source) {
        String[] itemIds;
        QFilter filter = new QFilter("customerid.fbasedataid.id", "=", (Object)customerId);
        filter.and("status", "=", (Object)"C");
        filter.and("starttime", "<", (Object)new Date());
        filter.and("endtime", ">", (Object)new Date());
        int itemSize = 20;
        if ("index".equals(source) && itemids.size() > 6) {
            itemids = itemids.subList(0, 6);
        }
        if ("index".equals(source) && itemClassids.size() > 6) {
            itemClassids = itemClassids.subList(0, 6);
        }
        if (itemClassids != null && itemClassids.size() > 0) {
            filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            if (itemids != null && itemids.size() > 0) {
                QFilter itemfilter = new QFilter("id", "in", itemids.stream().map(Long::parseLong).collect(Collectors.toList()));
                itemfilter.or(new QFilter("itemclassentity.goodsclasssid", "in", itemClassids.stream().map(Long::parseLong).collect(Collectors.toList())));
                filter.and(itemfilter);
            } else {
                filter.and(new QFilter("itemclassentity.goodsclasssid", "in", itemClassids.stream().map(Long::parseLong).collect(Collectors.toList())));
            }
            DynamicObjectCollection itemData = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id", (QFilter[])filter.toArray(), (String)" id desc ");
            if (!"index".equals(source)) {
                itemSize = 200;
            }
            itemSize = itemData.size() > itemSize ? itemSize : itemData.size();
            itemIds = new String[itemSize];
            for (int i = 0; i < itemSize; ++i) {
                itemIds[i] = ((DynamicObject)itemData.get(i)).getString("id");
            }
        } else {
            itemIds = new String[itemids.size()];
            for (int i = 0; i < itemids.size(); ++i) {
                itemIds[i] = itemids.get(i);
            }
        }
        return itemIds;
    }

    public Date getOlsWindowEndTime(String windowId) {
        if (StringUtil.isNotNull((String)windowId)) {
            QFilter filter = new QFilter("entryentity.id", "=", (Object)Long.parseLong(windowId));
            DynamicObject data = QueryServiceHelper.queryOne((String)"ocpos_olstorewindow", (String)"endtime", (QFilter[])filter.toArray());
            return data.getDate("endtime");
        }
        return null;
    }
}

