/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocbase.common.enums.InvStatusEnum;
import kd.occ.ocbase.common.util.CalendarUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.olstore.ExecuteContext;
import kd.occ.ocpos.business.olstore.OlstoreInventoryProcessor;
import kd.occ.ocpos.business.saleorder.SaleOrderDBHelper;
import kd.occ.ocpos.common.olstore.NegativeSellResult;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.vo.OlStoreInventoryVO;

public class OlstoreInventoryHelper {
    private static final OlstoreInventoryProcessor processer = new OlstoreInventoryProcessor();
    private static Log logger = LogFactory.getLog(OlstoreInventoryHelper.class);

    public static DynamicObject getMaterialInventoryInfo(long materialId) {
        QFilter qFilter = new QFilter("masterid", "=", (Object)materialId);
        return BusinessDataServiceHelper.loadSingle((String)"bd_materialinventoryinfo", (String)"enableserial", (QFilter[])qFilter.toArray());
    }

    public static boolean getEnableSerial(long materialId) {
        DynamicObject materialInventoryInfo = OlstoreInventoryHelper.getMaterialInventoryInfo(materialId);
        if (materialInventoryInfo != null) {
            return materialInventoryInfo.getBoolean("enableserial");
        }
        return false;
    }

    public static List<JSONObject> buildInventoryParam(JSONObject itemInfo, long saleOrgId, long branchId, long erpStockOrgid, long erpWarehouseId, long invtypeId, BigDecimal qty) {
        JSONObject inventoryParam = new JSONObject();
        inventoryParam.put("saleOrgId", (Object)saleOrgId);
        inventoryParam.put("saleChannelID", (Object)branchId);
        inventoryParam.put("itemId", (Object)itemInfo.getLong("itemid"));
        inventoryParam.put("materialId", (Object)itemInfo.getLong("materielid"));
        inventoryParam.put("auxPtyID", (Object)itemInfo.getLong("auxptyid"));
        inventoryParam.put("unitId", (Object)itemInfo.getLong("unitid"));
        inventoryParam.put("unitQty", (Object)qty);
        inventoryParam.put("baseUnitID", (Object)itemInfo.getLong("baseunitid"));
        inventoryParam.put("baseUnitQty", (Object)qty);
        inventoryParam.put("invtypeid", (Object)invtypeId);
        inventoryParam.put("stockOrgId", (Object)erpStockOrgid);
        inventoryParam.put("warehouseId", (Object)erpWarehouseId);
        inventoryParam.put("customerKey", (Object)0);
        return Collections.singletonList(inventoryParam);
    }

    public static JSONObject getDivisionIdByLatLng(String latitude, String longitude) {
        return processer.getDivisionIdByLatLng(latitude, longitude);
    }

    public static Map<String, Object> getDeliveryParams(JSONObject itemInfo, long saleOrgId, long branchId, long curDistrictId, BigDecimal qty, Date deliveryDate, long invtypeId) {
        logger.info("\u83b7\u53d6\u914d\u9001\u53c2\u6570,itemInfo:" + itemInfo + ",branchId:" + branchId + ",curDistrictId:" + curDistrictId + ",qty:" + qty);
        QFilter filter = new QFilter("id", "=", (Object)branchId);
        HashMap<String, Object> params = new HashMap<String, Object>(16);
        params.put("index", 0);
        params.put("saleOrgId", saleOrgId);
        params.put("saleChannelID", branchId);
        params.put("itemId", itemInfo.getLong("itemid"));
        params.put("adminDivisionId", curDistrictId);
        params.put("materialId", itemInfo.getLong("materielid"));
        params.put("baseUnitID", itemInfo.getLong("baseunitid"));
        params.put("baseUnitQty", qty);
        params.put("unitId", itemInfo.getLong("unitid"));
        params.put("unitQty", qty);
        params.put("deliveryDate", deliveryDate);
        params.put("auxPtyID", itemInfo.getLong("auxptyid"));
        params.put("bizdate", new Date());
        params.put("invtypeid", invtypeId);
        return params;
    }

    public static DynamicObject getIdsFromOcocicWareHouse(long customerId) {
        QFilter filter = new QFilter("ownerchannelid", "=", (Object)customerId);
        filter.and("status", "=", (Object)"C");
        filter.and("enable", "=", (Object)"1");
        filter.and("isdelivery", "=", (Object)"1");
        DynamicObject result = BusinessDataServiceHelper.loadSingle((String)"ococic_warehouse", (String)"erpstockorgid.id, erpwarehouseid.id", (QFilter[])new QFilter[]{filter});
        return result;
    }

    public static List<JSONObject> searchDistributionWarehouse(List<JSONObject> jsonObjList) {
        return processer.searchDistributionWarehouse(jsonObjList);
    }

    public static Long queryInventory(JSONObject jsonObject, Long customerId, Long districtId) {
        ArrayList<JSONObject> params = new ArrayList<JSONObject>();
        JSONObject param = new JSONObject();
        param.put("itemId", jsonObject.get((Object)"itemid"));
        param.put("auxPtyID", (Object)jsonObject.getLong("auxptyid"));
        param.put("materialId", (Object)jsonObject.getLong("materielid"));
        param.put("unitId", (Object)jsonObject.getLong("unitid"));
        param.put("unitQty", (Object)1);
        param.put("baseUnitID", (Object)jsonObject.getLong("baseunitid"));
        param.put("baseUnitQty", (Object)1);
        param.put("customerKey", (Object)0);
        param.put("saleChannelID", (Object)customerId);
        param.put("adminDivisionId", (Object)districtId);
        params.add(param);
        List<JSONObject> jsonObjects = processer.searchDistributionWarehouse(params);
        if (jsonObjects != null && jsonObjects.size() > 0) {
            JSONObject result = jsonObjects.get(0);
            return "1".equals(result.getString("invstatus")) ? Long.valueOf(Long.parseLong(result.getString("sumAvbBaseQty"))) : null;
        }
        return null;
    }

    public static NegativeSellResult queryNegativeSellInventory(long storeId, long itemId, long districtId, Date deliverytime, long materielId, long baseunitId, long unitId, BigDecimal baseUnitQty, BigDecimal unitQty) {
        long saleOrgId = OlstoreInventoryHelper.getSaleOrgIdByChannelId(storeId);
        NegativeSellResult result = new NegativeSellResult();
        List<JSONObject> resultJsonList = OlstoreInventoryHelper.getDistributionRules(storeId, itemId, districtId);
        if (CollectionUtils.isEmpty(resultJsonList)) {
            result.setStatus(Boolean.FALSE);
            result.setErrorMessage(ResManager.loadKDString((String)"\u5546\u54c1\u4e3a\u914d\u9001\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002", (String)"OlstoreInventoryHelper_0", (String)"occ-ocpos-business", (Object[])new Object[0]));
            return result;
        }
        List<JSONObject> resultJsons = OlstoreInventoryHelper.getNegativeSellInventory(resultJsonList, saleOrgId, storeId, itemId, materielId, baseunitId, unitId, deliverytime, baseUnitQty, unitQty);
        if (!CollectionUtils.isEmpty(resultJsons)) {
            Boolean status = Boolean.FALSE;
            for (JSONObject resultJson : resultJsons) {
                if (!"1".equals(resultJson.getString("status"))) continue;
                status = Boolean.TRUE;
            }
            result.setStatus(status);
            result.setDatas(resultJsons);
        }
        return result;
    }

    public static List<JSONObject> getDistributionRules(long storeId, long itemId, long districtId) {
        long saleOrgId = OlstoreInventoryHelper.getSaleOrgIdByChannelId(storeId);
        ArrayList<JSONObject> jsonObjList = new ArrayList<JSONObject>(4);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("saleOrgId", (Object)saleOrgId);
        jsonObject.put("saleChannelId", (Object)storeId);
        jsonObject.put("itemId", (Object)itemId);
        jsonObject.put("adminDivisionId", (Object)districtId);
        jsonObjList.add(jsonObject);
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"MatchDistributionRulesService", (String)"matchDistributionRules", (Object[])new Object[]{jsonObjList});
    }

    public static List<JSONObject> getNegativeSellInventory(List<JSONObject> resultJsonList, long saleOrgId, long storeId, long itemId, long materielId, long baseunitId, long unitId, Date deliverytime, BigDecimal baseUnitQty, BigDecimal unitQty) {
        if (CollectionUtils.isEmpty(resultJsonList)) {
            return new ArrayList<JSONObject>(0);
        }
        ArrayList<JSONObject> jsonObjList = new ArrayList<JSONObject>(13);
        for (JSONObject resultJson : resultJsonList) {
            long stockOrgId = resultJson.getLong("stockOrgId");
            long warehouseId = resultJson.getLong("warehouseId");
            long distributionModeId = resultJson.getLong("distributionModeId");
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("saleOrgId", (Object)saleOrgId);
            jsonObject.put("saleChannelID", (Object)storeId);
            jsonObject.put("itemId", (Object)itemId);
            jsonObject.put("materialId", (Object)materielId);
            jsonObject.put("baseUnitID", (Object)baseunitId);
            jsonObject.put("baseUnitQty", (Object)baseUnitQty);
            jsonObject.put("unitId", (Object)unitId);
            jsonObject.put("unitQty", (Object)unitQty);
            jsonObject.put("distributionModeId", (Object)distributionModeId);
            jsonObject.put("deliveryDate", (Object)deliverytime);
            jsonObject.put("stockOrgId", (Object)stockOrgId);
            jsonObject.put("stockId", (Object)warehouseId);
            jsonObject.put("invtypeid", (Object)688884005529250816L);
            jsonObject.put("bizdate", (Object)new Date());
            jsonObjList.add(jsonObject);
        }
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"OverSalePolicyService", (String)"matchOverSalePolicy", (Object[])new Object[]{jsonObjList});
    }

    public static long getSaleOrgIdByChannelId(long storeId) {
        long saleOrgId = 0L;
        DynamicObject channelInfo = BusinessDataServiceHelper.loadSingle((Object)storeId, (String)"ocdbd_channel");
        if (channelInfo != null) {
            saleOrgId = (Long)channelInfo.getDynamicObject("saleorg").getPkValue();
        }
        return saleOrgId;
    }

    public static Boolean queryImmediateInvInBranch(long saleOrgId, long branchId, long itemId, long materialId, long unitId, BigDecimal unitQty, long baseUnitId, BigDecimal baseUnitQty, long auxPtyId, String itemName) {
        Boolean hasImmediateInvInBranch = Boolean.FALSE;
        QFilter filter = new QFilter("ownerchannelid", "=", (Object)branchId);
        filter.and("warehousetype", "=", (Object)"2");
        filter.and("isdelivery", "=", (Object)"1");
        DynamicObject channelStockDyn = BusinessDataServiceHelper.loadSingle((String)"ococic_warehouse", (String)"erpstockorgid_id,erpwarehouseid_id", (QFilter[])filter.toArray());
        if (!ObjectUtils.isEmpty((Object)channelStockDyn)) {
            ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(1);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("stockOrgId", (Object)channelStockDyn.getLong("erpstockorgid_id"));
            jsonObject.put("warehouseId", (Object)channelStockDyn.getLong("erpwarehouseid_id"));
            jsonObject.put("saleOrgId", (Object)saleOrgId);
            jsonObject.put("saleChannelID", (Object)branchId);
            jsonObject.put("itemid", (Object)itemId);
            jsonObject.put("materialId", (Object)materialId);
            jsonObject.put("unitId", (Object)unitId);
            jsonObject.put("unitQty", (Object)unitQty);
            jsonObject.put("baseUnitID", (Object)baseUnitId);
            jsonObject.put("baseUnitQty", (Object)baseUnitQty);
            jsonObject.put("auxPtyID", (Object)auxPtyId);
            jsonObject.put("customerKey", (Object)itemName);
            jsonObjectList.add(jsonObject);
            List immediateInventoryList = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"matchDistributionWarehouse", (Object[])new Object[]{jsonObjectList});
            if (!CollectionUtils.isEmpty((Collection)immediateInventoryList) && InvStatusEnum.MATCH.getName().equals(((JSONObject)immediateInventoryList.get(0)).get((Object)"invstatus"))) {
                hasImmediateInvInBranch = Boolean.TRUE;
            }
        }
        return hasImmediateInvInBranch;
    }

    public static void reserveRemove(long billId) {
        processer.reserveRemove(billId);
    }

    public static List<JSONObject> reserve(DynamicObject dynamicObject) {
        return processer.reserve(dynamicObject);
    }

    public static Map<String, Object> executeInventoryStrategy(List<OlStoreInventoryVO> inventoryVoList) {
        ExecuteContext context = new ExecuteContext(inventoryVoList.get(0).getOperation());
        return context.execute(inventoryVoList);
    }

    public static Boolean queryImmediateInvInWarehouse(Long saleOrgId, Long branchId, Long itemId, Long materialId, Long unitId, BigDecimal unitQty, Long baseUnitId, BigDecimal baseUnitQty, Long auxPtyId, String itemName, List<JSONObject> stockJsonObjectList) {
        Boolean hasImmediateInvInWarehouse = Boolean.FALSE;
        ArrayList<JSONObject> jsonObjectList = new ArrayList<JSONObject>(stockJsonObjectList.size());
        for (JSONObject stockJsonObject : stockJsonObjectList) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("saleOrgId", (Object)saleOrgId);
            jsonObject.put("saleChannelID", (Object)branchId);
            jsonObject.put("itemid", (Object)itemId);
            jsonObject.put("materialId", (Object)materialId);
            jsonObject.put("unitId", (Object)unitId);
            jsonObject.put("unitQty", (Object)unitQty);
            jsonObject.put("baseUnitID", (Object)baseUnitId);
            jsonObject.put("baseUnitQty", (Object)baseUnitQty);
            jsonObject.put("auxPtyID", (Object)auxPtyId);
            jsonObject.put("customerKey", (Object)itemName);
            jsonObject.put("stockOrgId", (Object)stockJsonObject.getLong("stockOrgId"));
            jsonObject.put("warehouseId", (Object)stockJsonObject.getLong("warehouseId"));
            jsonObject.put("distributionModeId", (Object)stockJsonObject.getLong("distributionModeId"));
            jsonObjectList.add(jsonObject);
        }
        List immediateInventoryList = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"matchDistributionWarehouse", (Object[])new Object[]{jsonObjectList});
        for (JSONObject jsonObject : immediateInventoryList) {
            if (!"1".equals(jsonObject.get((Object)"invstatus"))) continue;
            hasImmediateInvInWarehouse = Boolean.TRUE;
            break;
        }
        return hasImmediateInvInWarehouse;
    }

    public static Map<String, Object> queryConfirmOrderInventory(Map<String, Object> orderParam, Map<String, Object> resultMap, long districtId) {
        long storeId = (Long)orderParam.get("salebranchid");
        boolean isHasInventory = true;
        List itemList = (List)orderParam.get("itemList");
        if (!CollectionUtils.isEmpty((Collection)itemList)) {
            boolean isSuccess;
            for (int i = 0; i < itemList.size(); ++i) {
                Map itemMap = (Map)itemList.get(i);
                long itemId = CommonUtil.formatObejctToLong(itemMap.get("goodsid"));
                long materielId = CommonUtil.formatObejctToLong(itemMap.get("materielid"));
                long baseunitId = CommonUtil.formatObejctToLong(itemMap.get("baseunit"));
                long unitId = CommonUtil.formatObejctToLong(itemMap.get("unit"));
                long auxptyId = CommonUtil.formatObejctToLong(itemMap.get("auxattrid"));
                Date deliverytime = (Date)itemMap.get("deliverdeliverytime");
                BigDecimal unitQty = (BigDecimal)itemMap.get("qty");
                BigDecimal baseUnitQty = (BigDecimal)itemMap.get("qty");
                NegativeSellResult negativeSellInventory = OlstoreInventoryHelper.queryNegativeSellInventory(storeId, itemId, districtId, deliverytime, materielId, baseunitId, unitId, baseUnitQty, unitQty);
                Boolean status = negativeSellInventory.getStatus();
                if (!status.booleanValue()) {
                    List<JSONObject> distributionRules = OlstoreInventoryHelper.getDistributionRules(storeId, itemId, districtId);
                    long saleOrgId = OlstoreInventoryHelper.getSaleOrgIdByChannelId(storeId);
                    Boolean isImmediateInvInBranch = OlstoreInventoryHelper.queryImmediateInvInWarehouse(saleOrgId, storeId, itemId, materielId, unitId, new BigDecimal("1"), baseunitId, new BigDecimal("1"), auxptyId, "distribution", distributionRules);
                    if (!isImmediateInvInBranch.booleanValue()) {
                        isHasInventory = false;
                        return new HashMap<String, Object>(0);
                    }
                    itemMap.put("isnegativesell", "0");
                    continue;
                }
                JSONObject negativeSellInfo = (JSONObject)negativeSellInventory.getDatas().get(0);
                long policyid = negativeSellInfo.getLong("id");
                long policyentryid = negativeSellInfo.getLong("entryid");
                itemMap.put("oversalepolicyid", policyid);
                itemMap.put("oversalepolicyentryid", policyentryid);
                itemMap.put("isnegativesell", "1");
            }
            if (isHasInventory && (isSuccess = ((Boolean)(resultMap = SaleOrderDBHelper.addSaleOrder(orderParam)).get("success")).booleanValue())) {
                boolean isEnableReserve;
                DynamicObject reservedBillInfo;
                DynamicObject branchDyn;
                long saleOrgId;
                QFilter filter;
                DynamicObject[] customerParamDynArr;
                boolean isHasOverInventory = false;
                boolean isHasReservedInventory = false;
                long billId = (Long)resultMap.get("billId");
                String billNo = (String)resultMap.get("billNo");
                DynamicObject billInfo = (DynamicObject)resultMap.get("billOrder");
                DynamicObjectCollection goodsEntry = billInfo.getDynamicObjectCollection("goodsentryentity");
                ArrayList<JSONObject> jsonObjList = new ArrayList<JSONObject>(15);
                for (DynamicObject goods : goodsEntry) {
                    if (goods.getBoolean("isnegativesell")) {
                        isHasOverInventory = true;
                        JSONObject jsonObject = new JSONObject();
                        jsonObject.put("billentityid", (Object)"ocpos_saleorder");
                        jsonObject.put("billid", (Object)billId);
                        jsonObject.put("billentryid", (Object)Long.valueOf(String.valueOf(goods.getPkValue())));
                        jsonObject.put("billno", (Object)billNo);
                        jsonObject.put("policyid", (Object)goods.getLong("oversalepolicyid"));
                        jsonObject.put("policyentryid", (Object)goods.getLong("oversalepolicyentryid"));
                        jsonObject.put("itemid", (Object)Long.valueOf(String.valueOf(goods.getDynamicObject("goodsid").getPkValue())));
                        long materielId = DynamicObjectUtils.getPkValue((DynamicObject)goods.getDynamicObject("materielid"));
                        jsonObject.put("materialid", (Object)materielId);
                        jsonObject.put("auxptyid", (Object)goods.getLong("auxptyid"));
                        jsonObject.put("qty", (Object)goods.getBigDecimal("saleqty"));
                        jsonObject.put("unitid", (Object)Long.valueOf(String.valueOf(goods.getDynamicObject("unit").getPkValue())));
                        jsonObject.put("baseqty", (Object)goods.getBigDecimal("baseunitqty"));
                        jsonObject.put("baseunitid", (Object)Long.valueOf(String.valueOf(goods.getDynamicObject("baseunit").getPkValue())));
                        jsonObject.put("actualqty", (Object)goods.getBigDecimal("saleqty"));
                        jsonObject.put("actualbaseqty", (Object)goods.getBigDecimal("baseunitqty"));
                        jsonObject.put("customerKey", (Object)goods.getInt("seq"));
                        jsonObjList.add(jsonObject);
                        continue;
                    }
                    isHasReservedInventory = true;
                }
                if (isHasOverInventory) {
                    DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"OverSalePolicyService", (String)"occupancyOverSalePolicy", (Object[])new Object[]{jsonObjList});
                }
                if (isHasReservedInventory && (customerParamDynArr = BusinessDataServiceHelper.load((String)"ocdbd_customer_params", (String)"isinvreserve", (QFilter[])(filter = new QFilter("saleorgid", "=", (Object)(saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)(branchDyn = DynamicObjectUtils.getDynamicObject((DynamicObject)(reservedBillInfo = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder_reserved")), (String)"salebranchid")), (String)"saleorg")))).toArray())).length >= 1 && (isEnableReserve = customerParamDynArr[0].getBoolean("isinvreserve"))) {
                    DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"reserve", (Object[])new Object[]{reservedBillInfo});
                }
            }
        }
        return resultMap;
    }

    public static String parseMessageFromMultiInvMap(Map<String, Object> itemAuxInvMap) {
        Map allItemInvMap = (Map)itemAuxInvMap.remove("allItem");
        boolean hasImmediateInvInBranchAllItem = (Boolean)allItemInvMap.get("hasImmediateInvInBranch");
        if (hasImmediateInvInBranchAllItem) {
            return "";
        }
        boolean hasDefaultAddressAllItem = (Boolean)allItemInvMap.get("hasDefaultAddress");
        Set<String> itemAuxSet = itemAuxInvMap.keySet();
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = itemAuxSet.iterator();
        while (iterator.hasNext()) {
            Map booleanMap = (Map)itemAuxInvMap.get(iterator.next());
            String itemName = (String)booleanMap.get("itemName");
            boolean hasImmediateInvInBranch = (Boolean)booleanMap.get("hasImmediateInvInBranch");
            if (hasImmediateInvInBranch || hasDefaultAddressAllItem) continue;
            sb.append(itemName).append("\u6ca1\u6709\u5e93\u5b58\uff0c\u6ca1\u6709\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u3002");
        }
        if (sb.toString().length() > 0) {
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        Iterator<String> iterator1 = itemAuxSet.iterator();
        while (iterator1.hasNext()) {
            Map booleanMap = (Map)itemAuxInvMap.get(iterator1.next());
            String itemName = (String)booleanMap.get("itemName");
            boolean hasShareInvRule = (Boolean)booleanMap.get("hasShareInvRule");
            if (!hasDefaultAddressAllItem || hasShareInvRule) continue;
            sb.append(itemName).append("\u6ca1\u6709\u5e93\u5b58\uff0c\u6ca1\u6709\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002");
        }
        if (sb.toString().length() > 0) {
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        Iterator<String> iterator2 = itemAuxSet.iterator();
        while (iterator2.hasNext()) {
            Map booleanMap = (Map)itemAuxInvMap.get(iterator2.next());
            String itemName = (String)booleanMap.get("itemName");
            boolean hasOverSaleInv = (Boolean)booleanMap.get("hasOverSaleInv");
            boolean hasImmediateInvInWarehouse = (Boolean)booleanMap.get("hasImmediateInvInWarehouse");
            if (!hasDefaultAddressAllItem || hasOverSaleInv || hasImmediateInvInWarehouse) continue;
            sb.append(itemName).append("\u6ca1\u6709\u5e93\u5b58\uff0c\u53d1\u8d27\u4ed3\u5e93\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u3002");
        }
        if (sb.toString().length() > 0) {
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        Iterator<String> iterator3 = itemAuxSet.iterator();
        while (iterator3.hasNext()) {
            Map booleanMap = (Map)itemAuxInvMap.get(iterator3.next());
            String itemName = (String)booleanMap.get("itemName");
            boolean hasOverSaleInv = (Boolean)booleanMap.get("hasOverSaleInv");
            if (!hasDefaultAddressAllItem || !hasOverSaleInv) continue;
            sb.append(itemName).append("\u6ca1\u6709\u5e93\u5b58\uff0c\u662f\u5426\u9884\u8ba2\uff1f");
        }
        if (sb.toString().length() > 0) {
            return sb.toString().substring(0, sb.toString().length() - 1);
        }
        Iterator<String> iterator4 = itemAuxSet.iterator();
        while (iterator3.hasNext()) {
            Map booleanMap = (Map)itemAuxInvMap.get(iterator4.next());
            String itemName = (String)booleanMap.get("itemName");
            boolean hasOverSaleInv = (Boolean)booleanMap.get("hasOverSaleInv");
            boolean hasImmediateInvInWarehouse = (Boolean)booleanMap.get("hasImmediateInvInWarehouse");
            if (!hasDefaultAddressAllItem || hasOverSaleInv || !hasImmediateInvInWarehouse) continue;
            sb.append("useImmediateInvInWarehouse");
            break;
        }
        if (sb.toString().length() > 0) {
            return sb.toString();
        }
        return "";
    }

    public static String parseMessageFromSingleInvMap(Map<String, Object> invMap) {
        if (((Boolean)invMap.get("hasImmediateInvInBranch")).booleanValue()) {
            return "";
        }
        if (!((Boolean)invMap.get("hasImmediateInvInBranch")).booleanValue() && !((Boolean)invMap.get("hasDefaultAddress")).booleanValue()) {
            return "\u6ca1\u6709\u5e93\u5b58\uff0c\u6ca1\u6709\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u3002";
        }
        if (!((Boolean)invMap.get("hasImmediateInvInBranch")).booleanValue() && ((Boolean)invMap.get("hasDefaultAddress")).booleanValue() && !((Boolean)invMap.get("hasShareInvRule")).booleanValue()) {
            return "\u6ca1\u6709\u5e93\u5b58\uff0c\u6ca1\u6709\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002";
        }
        if (!((Boolean)invMap.get("hasImmediateInvInBranch")).booleanValue() && ((Boolean)invMap.get("hasDefaultAddress")).booleanValue() && ((Boolean)invMap.get("hasOverSaleInv")).booleanValue()) {
            return "\u6ca1\u6709\u5e93\u5b58\uff0c\u662f\u5426\u9884\u8ba2\uff1f";
        }
        if (!((Boolean)invMap.get("hasImmediateInvInBranch")).booleanValue() && ((Boolean)invMap.get("hasDefaultAddress")).booleanValue() && !((Boolean)invMap.get("hasOverSaleInv")).booleanValue()) {
            if (!((Boolean)invMap.get("hasImmediateInvInWarehouse")).booleanValue()) {
                return "\u6ca1\u6709\u5e93\u5b58\uff0c\u53d1\u8d27\u4ed3\u5e93\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u3002";
            }
            return null;
        }
        return null;
    }

    public static String parseMessageInItemDetail(Map<String, Object> itemAuxInvMap) {
        HashMap itemInvMap;
        HashMap allItemInvMap = (HashMap)itemAuxInvMap.remove("allItem");
        Collection<Object> values = itemAuxInvMap.values();
        for (Object value : values) {
            itemInvMap = (HashMap)value;
            if (!((Boolean)itemInvMap.get("hasImmediateInvInBranch")).booleanValue()) continue;
            return "";
        }
        if (!((Boolean)allItemInvMap.get("hasDefaultAddress")).booleanValue()) {
            return "\u6ca1\u6709\u5e93\u5b58\uff0c\u6ca1\u6709\u9ed8\u8ba4\u6536\u8d27\u5730\u5740\u3002";
        }
        if (!((Boolean)allItemInvMap.get("hasShareInvRule")).booleanValue()) {
            return "\u6ca1\u6709\u5e93\u5b58\uff0c\u6ca1\u6709\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002";
        }
        for (Object value : values) {
            itemInvMap = (HashMap)value;
            if (!((Boolean)itemInvMap.get("hasOverSaleInv")).booleanValue()) continue;
            return "";
        }
        for (Object value : values) {
            itemInvMap = (HashMap)value;
            if (!((Boolean)itemInvMap.get("hasImmediateInvInWarehouse")).booleanValue()) continue;
            return "";
        }
        return "\u6ca1\u6709\u5e93\u5b58\uff0c\u53d1\u8d27\u4ed3\u5e93\u6ca1\u6709\u5373\u65f6\u5e93\u5b58\u3002";
    }

    public static List<OlStoreInventoryVO> createSelfPickupParam(String operation, long customerId, long memberId, JSONArray itemJsonArray) {
        ArrayList<OlStoreInventoryVO> inventoryVOList = new ArrayList<OlStoreInventoryVO>(itemJsonArray.size());
        Date nextDayTime = CalendarUtil.getNextDayTime();
        BigDecimal qty = new BigDecimal(1);
        for (Object obj : itemJsonArray) {
            JSONObject itemJson = (JSONObject)obj;
            OlStoreInventoryVO inventoryVO = new OlStoreInventoryVO();
            inventoryVO.setOperation(operation);
            inventoryVO.setBranchId(Long.valueOf(customerId));
            inventoryVO.setMemberId(Long.valueOf(memberId));
            inventoryVO.setItemId(itemJson.getLong("itemid"));
            inventoryVO.setMaterialId(itemJson.getLong("materielid"));
            inventoryVO.setUnitId(itemJson.getLong("unitid"));
            inventoryVO.setUnitQty(qty);
            inventoryVO.setBaseUnitId(itemJson.getLong("baseunitid"));
            inventoryVO.setBaseUnitQty(qty);
            inventoryVO.setAuxPtyId(itemJson.getLong("auxptyid"));
            inventoryVO.setDeliveryTime(nextDayTime);
            inventoryVO.setItemName(itemJson.getString("itemname"));
            inventoryVOList.add(inventoryVO);
        }
        return inventoryVOList;
    }

    public static List<OlStoreInventoryVO> createInventoryVoByDyn(String op_createorder, long customerId, long memberId, List<DynamicObject> selectEntrys) {
        ArrayList<OlStoreInventoryVO> inventoryVOList = new ArrayList<OlStoreInventoryVO>(selectEntrys.size());
        Date nextDayTime = CalendarUtil.getNextDayTime();
        for (DynamicObject rowEntry : selectEntrys) {
            if (rowEntry.getBoolean("ispresent") || rowEntry.getBoolean("isitemgift")) continue;
            OlStoreInventoryVO inventoryVO = new OlStoreInventoryVO();
            inventoryVO.setOperation("createorder");
            inventoryVO.setBranchId(Long.valueOf(customerId));
            inventoryVO.setMemberId(Long.valueOf(memberId));
            inventoryVO.setItemId(Long.valueOf(rowEntry.getLong("itemid")));
            inventoryVO.setMaterialId(Long.valueOf(rowEntry.getLong("materielid")));
            inventoryVO.setUnitId(Long.valueOf(rowEntry.getLong("unitid")));
            inventoryVO.setUnitQty(rowEntry.getBigDecimal("qty"));
            inventoryVO.setBaseUnitId(Long.valueOf(rowEntry.getLong("unitid")));
            inventoryVO.setBaseUnitQty(rowEntry.getBigDecimal("qty"));
            inventoryVO.setAuxPtyId(Long.valueOf(rowEntry.getLong("auxptyid")));
            inventoryVO.setDeliveryTime(nextDayTime);
            inventoryVO.setItemName(rowEntry.getString("itemname"));
            inventoryVOList.add(inventoryVO);
        }
        return inventoryVOList;
    }

    public static boolean deliveryInventoryCheckInItemDetail(Long customerId, Date deliverytime, long districtId, JSONArray products) {
        boolean hasInventory = true;
        for (Object itemObject : products) {
            JSONObject itemJson = (JSONObject)itemObject;
            Long itemId = itemJson.getLong("itemid");
            Long materialId = itemJson.getLong("materielid");
            Long baseUnitId = itemJson.getLong("baseunitid");
            Long unitId = itemJson.getLong("unitid");
            Long auxPtyId = itemJson.getLong("auxptyid");
            NegativeSellResult result = OlstoreInventoryHelper.queryNegativeSellInventory(customerId, itemId, districtId, deliverytime, materialId, baseUnitId, unitId, new BigDecimal("1"), new BigDecimal("1"));
            Boolean hasOverSaleInv = result.getStatus();
            if (hasOverSaleInv.booleanValue()) {
                hasInventory = true;
                break;
            }
            List<JSONObject> distributionRules = OlstoreInventoryHelper.getDistributionRules(customerId, itemId, districtId);
            long saleOrgId = OlstoreInventoryHelper.getSaleOrgIdByChannelId(customerId);
            Boolean hasImmediateInvInWarehouse = OlstoreInventoryHelper.queryImmediateInvInWarehouse(saleOrgId, customerId, itemId, materialId, unitId, new BigDecimal("1"), baseUnitId, new BigDecimal("1"), auxPtyId, "distribution", distributionRules);
            if (hasImmediateInvInWarehouse.booleanValue()) {
                hasInventory = true;
                break;
            }
            hasInventory = false;
        }
        return hasInventory;
    }
}

