/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.occ.ocdbd.business.miniprogram.MiniProgramHelper;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;

public class OlstoreInventoryProcessor {
    private static Log logger = LogFactory.getLog(OlstoreInventoryProcessor.class);

    public List<JSONObject> searchDistributionWarehouse(List<JSONObject> jsonObjList) {
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"matchDistributionWarehouse", (Object[])new Object[]{jsonObjList});
    }

    public JSONObject getDivisionIdByLatLng(String latitude, String longitude) {
        JSONObject divisionResult;
        JSONObject result = new JSONObject();
        result.put("address", (Object)"\u5317\u4eac\u5e02\u4e1c\u57ce\u533a");
        result.put("districtId", (Object)125);
        if (StringUtils.isNotBlank((CharSequence)latitude) && StringUtils.isNotBlank((CharSequence)longitude)) {
            divisionResult = MiniProgramHelper.getDivisionIdByLatLng((String)longitude, (String)latitude);
        } else {
            DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
            long storeId = olstoreCogInfo.getLong("storeid.id");
            DynamicObject storeInfo = BusinessDataServiceHelper.loadSingle((Object)storeId, (String)"ocdbd_channel");
            BigDecimal lg = storeInfo.getBigDecimal("longitude");
            BigDecimal la = storeInfo.getBigDecimal("latitude");
            logger.info("\u83b7\u53d6\u7ebf\u4e0a\u95e8\u5e97\u914d\u7f6e\u4fe1\u606f\u91cc\u7684\u9ed8\u8ba4\u95e8\u5e97\u7ecf\u7eac\u5ea6\uff1a" + lg + "," + la);
            if (lg == null || la == null) {
                return result;
            }
            divisionResult = MiniProgramHelper.getDivisionIdByLatLng((String)String.valueOf(lg), (String)String.valueOf(la));
        }
        if (divisionResult.getInteger("status") == 0) {
            String district;
            String city;
            String province;
            JSONObject adInfo = divisionResult.getJSONObject("result").getJSONObject("ad_info");
            String nation = adInfo.getString("nation");
            DynamicObject adminDivisionInfo = OlstoreStoreInfoHelper.getDivisionIdByAddress(nation, province = adInfo.getString("province"), city = adInfo.getString("city"), district = adInfo.getString("district"));
            if (adminDivisionInfo != null) {
                logger.info("\u6839\u636e\u7ecf\u7eac\u5ea6\u67e5\u8be2\u533a\u57dfdistrictId\uff1a" + adminDivisionInfo.getPkValue());
                StringBuilder sb = new StringBuilder();
                sb.append(province).append(city).append(district);
                result.put("address", (Object)sb.toString());
                result.put("districtId", adminDivisionInfo.getPkValue());
            }
            return result;
        }
        return result;
    }

    public void reserveRemove(long billId) {
        DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"reserveRemove", (Object[])new Object[]{billId});
    }

    public List<JSONObject> reserve(DynamicObject dynamicObject) {
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"reserve", (Object[])new Object[]{dynamicObject});
    }
}

