/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocbase.common.util.ORMUtil;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.ItemClassNodeUtil;
import kd.occ.ocpos.business.olstore.OlstoreItemProcessor;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class OlstoreItemHelper {
    private static final OlstoreItemProcessor processer = new OlstoreItemProcessor();
    protected static final Log logger = LogFactory.getLog(OlstoreItemHelper.class);

    public static DynamicObjectCollection getItemClass() {
        return processer.getItemClass();
    }

    public static DynamicObjectCollection getClassstandardApply() {
        return processer.getClassstandardApply();
    }

    public static JSONObject getItemDetail(String customerId, String spuId, String itemId, String appendFieldStr) {
        return processer.getItemDetail(customerId, spuId, itemId, appendFieldStr);
    }

    public static JSONObject queryItemListByItemIds(String customerId, String[] itemIds, String appendFieldStr) {
        return processer.queryItemListByItemIds(customerId, itemIds, appendFieldStr);
    }

    public static List<JSONObject> queryItemListByItemIds(List<String> itemids, List<String> itemClassids, Long customerId, int startPage, int pageSize) {
        return processer.queryItemListByItemIds(itemids, itemClassids, customerId, startPage, pageSize);
    }

    public static JSONArray getItemList(String customerId, String itemName, String[] itemclassId, String orderBy, String startPage, String pageSize, String type, List<String> brandIds, List<String> LableIds, String minPrice, String maxPrice) {
        return processer.getContentItemList(Long.parseLong(customerId), itemName, itemclassId, orderBy, startPage, pageSize, type, brandIds, LableIds, minPrice, maxPrice);
    }

    public static BigDecimal getItemPriceByPublish(long customerId, long itemId, long spuId) {
        JSONArray dataList;
        BigDecimal price = BigDecimal.ZERO;
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("itemid.baseunit", "baseunitid");
        map.put("barcodeid.unit", "unitid");
        map.put("barcodeid.auxpty", "auxptyid");
        map.put("barcodeid.materiel", "materielid");
        map.put("itemid.retailunit", "retailunit");
        map.put("itemid.shorttitle", "shorttitle");
        map.put("barcodeid.id", "barcodeid");
        String appendFieldStr = SerializationUtils.toJsonString(map);
        JSONObject itemJson = processer.getItemDetail(customerId + "", spuId + "", itemId + "", appendFieldStr);
        if (itemJson != null && itemJson.get((Object)"msg").equals("success") && !(dataList = itemJson.getJSONArray("data")).isEmpty()) {
            price = dataList.getJSONObject(0).getBigDecimal("memberprice");
        }
        return price;
    }

    public static DynamicObject getSpuMapName(long itemId, long auxptyId) {
        return processer.getSpuMapName(itemId, auxptyId);
    }

    public static List<DynamicObject> queryItemBrand(long branchId, long itemClassId) {
        List<Long> itemList = OlstoreItemHelper.queryItemByBranchId(branchId);
        if (itemClassId != 0L) {
            List<Long> index = OlstoreItemHelper.queryItemByItemClassId(itemClassId);
            itemList.retainAll(index);
        }
        HashSet<Long> brandSet = new HashSet<Long>();
        ArrayList<DynamicObject> result = new ArrayList<DynamicObject>();
        for (long itemId : itemList) {
            DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)itemId, (String)"ocdbd_iteminfo", (String)"itembrands");
            long brandId = DynamicObjectUtil.getPkValue((DynamicObject)item, (String)"itembrands");
            if (brandId == 0L) continue;
            brandSet.add(brandId);
        }
        for (Long id : brandSet) {
            DynamicObject brand = BusinessDataServiceHelper.loadSingle((Object)id, (String)"mdr_item_brand");
            if (brand == null) continue;
            result.add(brand);
        }
        return result;
    }

    public static List<DynamicObject> queryItemLable(long branchId, long itemClassId, long itemBrandId) {
        List<Long> indexList;
        List<Long> itemList = OlstoreItemHelper.queryItemByBranchId(branchId);
        if (itemClassId != 0L) {
            indexList = OlstoreItemHelper.queryItemByItemClassId(itemClassId);
            itemList.retainAll(indexList);
        }
        if (itemBrandId != 0L) {
            indexList = OlstoreItemHelper.queryItemByItemBrandId(itemBrandId);
            itemList.retainAll(indexList);
        }
        QFilter qFilter = new QFilter("entryentity.item", "in", itemList);
        DataSet itemLableDataSet = QueryServiceHelper.queryDataSet((String)OlstoreItemHelper.class.getName(), (String)"ocdbd_item_label", (String)"id", (QFilter[])qFilter.toArray(), null);
        DynamicObjectCollection itemLableDyoCollection = ORM.create().toPlainDynamicObjectCollection(itemLableDataSet);
        DynamicObject[] itemLables = BusinessDataServiceHelper.load((Object[])itemLableDyoCollection.stream().filter(s -> s.getLong("id") != 0L).map(s -> s.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocdbd_item_label"));
        return new ArrayList<DynamicObject>(Arrays.asList(itemLables));
    }

    public static List<DynamicObject> queryItemLableByItemList(List<Long> itemList) {
        QFilter qFilter = new QFilter("entryentity.item", "in", itemList);
        DataSet itemLableDataSet = QueryServiceHelper.queryDataSet((String)OlstoreItemHelper.class.getName(), (String)"ocdbd_item_label", (String)"id", (QFilter[])qFilter.toArray(), null);
        DynamicObjectCollection itemLableDyoCollection = ORM.create().toPlainDynamicObjectCollection(itemLableDataSet);
        DynamicObject[] itemLables = BusinessDataServiceHelper.load((Object[])itemLableDyoCollection.stream().filter(s -> s.getLong("id") != 0L).map(s -> s.getLong("id")).toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocdbd_item_label"));
        return new ArrayList<DynamicObject>(Arrays.asList(itemLables));
    }

    private static List<Long> queryItemByItemBrandId(long itemBrandId) {
        QFilter qFilter = new QFilter("itembrands", "=", (Object)itemBrandId);
        DynamicObjectCollection items = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id", (QFilter[])qFilter.toArray());
        return items.stream().map(s -> s.getLong("id")).collect(Collectors.toList());
    }

    private static List<Long> queryItemByBranchId(long branchId) {
        ArrayList<Long> result = new ArrayList<Long>();
        QFilter filter = new QFilter("channelid", "=", (Object)branchId);
        filter.and("retailprice", "!=", (Object)BigDecimal.ZERO);
        DynamicObject channel = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)"ocdbd_channel");
        filter.and("currencyid", "=", (Object)channel.getDynamicObject("currency").getLong("id"));
        filter.and("enable", "=", (Object)"1");
        filter.and("itemid.status", "=", (Object)"C");
        filter.and("itemid.enable", "=", (Object)"1");
        filter.and("barcodeid.status", "=", (Object)"C");
        String selectFields = ORMUtil.appendFieldsToStr((String[])new String[]{"itemid", "barcodeid"});
        DynamicObjectCollection data = QueryServiceHelper.query((String)"ocdbd_itemsalecontent", (String)selectFields, (QFilter[])filter.toArray());
        if (data == null || data.isEmpty()) {
            return result;
        }
        for (DynamicObject item : data) {
            long itemId = DynamicObjectUtils.getLong((DynamicObject)item, (String)"itemid");
            result.add(itemId);
        }
        return result;
    }

    private static List<Long> queryItemByItemClassId(long itemClassId) {
        Set objs = ItemClassUtil.queryAllItemsByClasses(Collections.singleton(itemClassId));
        if (objs != null && !objs.isEmpty()) {
            HashSet<Long> items = new HashSet<Long>(objs.size());
            for (Object item : objs) {
                items.add(Long.parseLong(item.toString()));
            }
            return new ArrayList<Long>(items);
        }
        return new ArrayList<Long>();
    }

    private static List<Long> queryItemByItemLable(long branchId, long itemLableId) {
        List<Long> itemList = OlstoreItemHelper.queryItemByBranchId(branchId);
        Set objs = PosItemUtil.queryItemsIdsByItemLabel(Collections.singleton(itemLableId));
        if (objs != null && !objs.isEmpty()) {
            ArrayList<Long> items = new ArrayList<Long>(objs.size());
            for (Object item : objs) {
                items.add(Long.parseLong(item.toString()));
            }
            itemList.retainAll(items);
            return itemList;
        }
        return new ArrayList<Long>();
    }

    private static List<JSONObject> queryInventory() {
        List inventoryDetailInfoList = null;
        Object jsonParams = null;
        List inventoryAvaliableList = (List)DispatchServiceHelper.invokeBizService((String)"drp", (String)"ocic", (String)"SharedInventoryService", (String)"matchDistributionWarehouse", (Object[])new Object[]{null});
        String tip = OlstoreItemHelper.checkInventory(inventoryAvaliableList);
        if (StringUtils.isNotEmpty((String)tip)) {
            return null;
        }
        for (Map.Entry inventorySet : ((JSONObject)inventoryAvaliableList.get(0)).entrySet()) {
            if (!"invdetailinfolist".equals(inventorySet.getKey())) continue;
            inventoryDetailInfoList = (List)inventorySet.getValue();
            break;
        }
        return inventoryDetailInfoList;
    }

    private static String checkInventory(List<? extends JSONObject> inventoryAvaliableList) {
        String tip = null;
        if (inventoryAvaliableList == null || inventoryAvaliableList.isEmpty() || StringUtils.isNotEmpty((String)inventoryAvaliableList.get(0).getString("invstatus")) && "2".equals(inventoryAvaliableList.get(0).getString("invstatus"))) {
            tip = "\u8be5\u5546\u54c1\u95e8\u5e97\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u9009\u62e9\u9884\u8ba2\u6216\u8005\u8d1f\u5356\u653f\u7b56\u3001\u6216\u67e5\u8be2\u4e2d\u5fc3\u4ed3\u662f\u5426\u6709\u5e93\u5b58";
        } else if (StringUtils.isNotEmpty((String)inventoryAvaliableList.get(0).getString("invstatus")) && "3".equals(inventoryAvaliableList.get(0).getString("invstatus"))) {
            tip = "\u8be5\u5546\u54c1\u4e3a\u914d\u9001\uff0c\u666e\u901a\u5546\u54c1\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219";
        }
        return tip;
    }

    public static JSONObject queryItemDetailByBarcode(String customerId, String barcode, String appendFieldStr) {
        return processer.queryItemDetailByBarcode(customerId, barcode, appendFieldStr);
    }

    public static List<Long> getItemIdByItemBrand(DynamicObjectCollection entryDynColl) {
        List itemBrandIds = entryDynColl.stream().filter(item -> item.getLong("brand_id") > 0L && (item.getInt("type") == 3 || item.getInt("type") == 5)).map(item -> item.getLong("brand_id")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(itemBrandIds)) {
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("itembrands", "in", itemBrandIds));
            DynamicObjectCollection itemDynColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id", (QFilter[])filter.toArray(), (String)" id desc ");
            List<Long> itemIds = itemDynColl.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            return itemIds;
        }
        return null;
    }

    public static List<Long> getItemIdByItemClass(DynamicObjectCollection entryDynColl) {
        Set itemClassIds = entryDynColl.stream().filter(item -> item.getLong("goodsclassify_id") > 0L && (item.getInt("type") == 2 || item.getInt("type") == 5)).map(item -> item.get("goodsclassify_id")).collect(Collectors.toSet());
        logger.info("\u8ba2\u5355\u786e\u8ba4\u793c\u5238\u5546\u54c1\u5206\u7c7bid\uff1a" + itemClassIds);
        if (!CollectionUtils.isEmpty(itemClassIds)) {
            Set itemClass = ItemClassNodeUtil.queryChildItemClass(itemClassIds);
            itemClass.addAll(itemClassIds);
            logger.info("\u8ba2\u5355\u786e\u8ba4\u793c\u5238Child\u5546\u54c1\u5206\u7c7bid\uff1a" + itemClassIds);
            List collect = itemClass.stream().map(r -> Long.valueOf(String.valueOf(r))).collect(Collectors.toList());
            QFilter filter = new QFilter("enable", "=", (Object)"1");
            filter.and(new QFilter("status", "=", (Object)"C"));
            filter.and(new QFilter("itemclassentity.goodsclasssid", "in", collect));
            DynamicObjectCollection itemDynColl = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id", (QFilter[])filter.toArray(), (String)" id desc ");
            List<Long> itemIds = itemDynColl.stream().map(item -> item.getLong("id")).collect(Collectors.toList());
            logger.info("\u8ba2\u5355\u786e\u8ba4\u793c\u5238\u5546\u54c1id\uff1a" + itemClassIds);
            return itemIds;
        }
        return null;
    }

    public static List<Long> getItemIdByItemLabel(DynamicObjectCollection entryDynColl) {
        List itemLabelIds = entryDynColl.stream().filter(item -> item.getLong("itemlabel_id") > 0L && (item.getInt("type") == 4 || item.getInt("type") == 5)).map(item -> item.getLong("itemlabel_id")).collect(Collectors.toList());
        Set<Long> itemsIdsByItemLabel = processer.queryItemsIdsByItemLabel(new HashSet<Long>(itemLabelIds));
        return new ArrayList<Long>(itemsIdsByItemLabel);
    }

    public static List<Long> getItemId(DynamicObjectCollection entryDynColl) {
        return entryDynColl.stream().filter(item -> item.getLong("goods_id") > 0L && "1".equals(item.getString("type"))).map(item -> item.getLong("goods_id")).collect(Collectors.toList());
    }

    public static boolean isOlstoreSale(Long customerId, Long barcode, Long itemId) {
        return processer.isOlstoreSale(customerId, barcode, itemId);
    }

    public static List<JSONObject> getTicketItemList(DynamicObject ticketType, long customerId, String keyword, int page, int pageSize) {
        return processer.getTicketItemList(ticketType, customerId, keyword, page, pageSize);
    }

    public static HashSet<Long> getItemListByTicketType(DynamicObject ticketType) {
        return processer.getItemListByTicketType(ticketType);
    }
}

