/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.earlywarn.kit.StringUtil;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.orm.util.StringUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.Enable;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ORMUtil;
import kd.occ.ocbase.common.util.pos.ItemClassNodeUtil;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.common.enums.OlstorePriceWayEnum;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import org.apache.commons.lang3.math.NumberUtils;

public class OlstoreItemProcessor {
    protected static final Log logger = LogFactory.getLog(OlstoreItemProcessor.class);
    public static final String OLSTORE_SALE = "b";

    public DynamicObjectCollection getItemClass() {
        DynamicObjectCollection classstandardApply = this.getClassstandardApply();
        DynamicObject dynamicObject = (DynamicObject)classstandardApply.get(0);
        if (dynamicObject == null) {
            return null;
        }
        Object classstandardid = dynamicObject.get("classstandardid.id");
        QFilter qfilter = new QFilter("standard", "=", classstandardid);
        return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"bd", (String)"gmc", (String)"ItemClassService", (String)"query", (Object[])new Object[]{"", new QFilter[]{qfilter}});
    }

    public DynamicObjectCollection getClassstandardApply() {
        QFilter qfilter = new QFilter("applyplatform", "=", (Object)Character.valueOf('2'));
        return (DynamicObjectCollection)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ClassstandardApplyService", (String)"query", (Object[])new Object[]{"", new QFilter[]{qfilter}});
    }

    private List<JSONObject> getJsonObjectsByPrice(String minPrice, String maxPrice, JSONArray result) {
        ArrayList<JSONObject> newlist = new ArrayList<JSONObject>();
        for (int i = 0; i < result.size(); ++i) {
            BigDecimal qFilterMaxPrice;
            BigDecimal qFilterMinPrice;
            JSONObject jsonObject = result.getJSONObject(i);
            BigDecimal minMemberPrice = jsonObject.getBigDecimal("minmemberprice");
            if (NumberUtils.isNumber((String)minPrice) && minMemberPrice.compareTo(qFilterMinPrice = new BigDecimal(minPrice)) < 0 || NumberUtils.isNumber((String)maxPrice) && (qFilterMaxPrice = new BigDecimal(maxPrice)).compareTo(minMemberPrice) < 0) continue;
            newlist.add(jsonObject);
        }
        return newlist;
    }

    private List<JSONObject> getJsonObjectsByLableId(List<String> lableIds, JSONArray jsonList) {
        List list = JSONObject.parseArray((String)jsonList.toJSONString(), JSONObject.class);
        ArrayList<JSONObject> newlist = new ArrayList<JSONObject>();
        ArrayList<Long> itemIds = new ArrayList<Long>(16);
        for (JSONObject jsonObject : list) {
            long itemId = Long.parseLong(jsonObject.getString("itemid"));
            itemIds.add(itemId);
        }
        long[] lables = lableIds.stream().filter(s -> !StringUtils.isEmpty((Object)s)).mapToLong(Long::parseLong).toArray();
        QFilter qFilter = new QFilter("id", "in", (Object)lables);
        qFilter.and("enable", "=", (Object)Enable.ENABLE);
        DynamicObjectCollection query = QueryServiceHelper.query((String)"ocdbd_item_label", (String)"entryentity.item", (QFilter[])qFilter.toArray());
        List itemIdsByLable = query.stream().map(m -> m.getLong("entryentity.item")).distinct().collect(Collectors.toList());
        itemIds.retainAll(itemIdsByLable);
        for (JSONObject jsonObject : list) {
            if (!itemIds.contains(Long.parseLong(jsonObject.getString("itemid")))) continue;
            newlist.add(jsonObject);
        }
        return newlist;
    }

    private List<JSONObject> getJsonObjectsByBrandId(List<String> brandIds, JSONArray jsonList) {
        List list = JSONObject.parseArray((String)jsonList.toJSONString(), JSONObject.class);
        ArrayList<JSONObject> newlist = new ArrayList<JSONObject>();
        ArrayList<Long> itemIds = new ArrayList<Long>(16);
        for (Object jsonObject : list) {
            long itemId = Long.parseLong(jsonObject.getString("itemid"));
            itemIds.add(itemId);
        }
        ArrayList<Long> longList = new ArrayList<Long>(brandIds.size());
        for (String brandId : brandIds) {
            longList.add(Long.parseLong(brandId));
        }
        ArrayList<String> filterItemList = new ArrayList<String>();
        QFilter qFilter = new QFilter("id", "in", itemIds);
        DynamicObject[] items = BusinessDataServiceHelper.load((String)"ocdbd_iteminfo", (String)"itembrands", (QFilter[])qFilter.toArray());
        for (DynamicObject item : items) {
            if (!longList.contains(DynamicObjectUtil.getPkValue((DynamicObject)item, (String)"itembrands"))) continue;
            filterItemList.add(item.getPkValue().toString());
        }
        for (JSONObject jsonObject : list) {
            if (!filterItemList.contains(jsonObject.getString("itemid"))) continue;
            newlist.add(jsonObject);
        }
        return newlist;
    }

    public JSONObject getItemDetail(String customerId, String spuId, String itemId, String appendFieldStr) {
        JSONObject item = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ItemSaleContentService", (String)"queryItemDetail", (Object[])new Object[]{"ocdbd_itemsalecontent", customerId, spuId, itemId, appendFieldStr});
        return this.updatePriceBySys(item, customerId);
    }

    public JSONObject queryItemListByItemIds(String customerId, String[] itemIds, String appendFieldStr) {
        JSONObject item = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ItemSaleContentService", (String)"queryItemListByItemIds", (Object[])new Object[]{"ocdbd_itemsalecontent", customerId, itemIds, appendFieldStr});
        return this.updatePriceBySys(item, customerId);
    }

    public List<JSONObject> queryItemListByItemIds(List<String> itemIds, List<String> itemClassids, Long customerId, int startPage, int pageSize) {
        QFilter infilter;
        logger.info("\u9996\u9875\u5546\u54c1\u5217\u8868\u53c2\u6570\uff1a\u5546\u54c1id:" + itemIds + ",\u5206\u7c7b\uff1a " + itemClassids + ",customerId\uff1a " + customerId);
        QFilter filter = F7Utils.getEnableStatus();
        String orderByStr = "id desc";
        filter.and("channelid", "=", (Object)customerId);
        filter.and("enable", "=", (Object)"1");
        filter.and("salescope", "like", (Object)"%b%");
        String selectFields = this.getItemListSelectFields();
        if (CollectionUtils.isEmpty(itemIds) && CollectionUtils.isEmpty(itemClassids)) {
            return null;
        }
        if (itemIds != null && itemIds.size() > 0) {
            List itemIdCollect = itemIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            infilter = new QFilter("itemid", "in", itemIdCollect);
            if (itemClassids != null && itemClassids.size() > 0) {
                List collect = itemClassids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
                Set itemClass = ItemClassNodeUtil.queryChildItemClass(new HashSet(collect));
                List allCollect = new ArrayList(itemClass).stream().map(s -> (Long)s).collect(Collectors.toList());
                allCollect.addAll(collect);
                infilter.or("goodsclasssid", "in", allCollect);
            }
            filter.and(infilter);
        } else if (itemClassids != null && itemClassids.size() > 0) {
            List collect = itemClassids.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList());
            Set itemClass = ItemClassNodeUtil.queryChildItemClass(new HashSet(collect));
            List allCollect = new ArrayList(itemClass).stream().map(s -> (Long)s).collect(Collectors.toList());
            allCollect.addAll(collect);
            infilter = new QFilter("goodsclasssid", "in", allCollect);
            filter.and(infilter);
        }
        DynamicObject[] data = BusinessDataServiceHelper.load((String)"ocdbd_itemsalecontent", (String)selectFields, (QFilter[])filter.toArray(), (String)orderByStr, (int)startPage, (int)pageSize);
        List<JSONObject> itemList = this.queryContentItemList(data, customerId);
        return itemList;
    }

    public JSONArray getContentItemList(Long customerId, String itemName, String[] itemclassId, String orderBy, String startPage, String pageSize, String type, List<String> brandIds, List<String> LableIds, String minPrice, String maxPrice) {
        DynamicObject[] data;
        logger.info("\u5546\u54c1\u5217\u8868\u53c2\u6570\uff1a\u5546\u54c1\u540d\u79f0:" + itemName + ",\u5206\u7c7b\uff1a " + Arrays.toString(itemclassId) + ",orderBy\uff1a " + orderBy + ",\u54c1\u724c \uff1a" + brandIds + ",\u6807\u7b7e\uff1a " + LableIds + ",minPrice\uff1a " + minPrice + ",maxPrice\uff1a " + maxPrice);
        String orderByStr = "id desc";
        String priceWay = this.getOnlineTakePriceWay(customerId);
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("channelid", "=", (Object)customerId);
        filter.and("salescope", "like", (Object)"%b%");
        if (!kd.bos.util.StringUtils.isEmpty((String)itemName)) {
            filter.and("name", "like", (Object)("%" + itemName + "%"));
        }
        if (itemclassId != null && itemclassId.length > 0) {
            Set itemClass = ItemClassNodeUtil.queryChildItemClass(new HashSet<String>(Arrays.asList(itemclassId)));
            List collect = new ArrayList(itemClass).stream().map(s -> String.valueOf(s)).collect(Collectors.toList());
            collect.addAll(Arrays.asList(itemclassId));
            filter.and("goodsclasssid", "in", collect.stream().map(s -> Long.parseLong(s)).collect(Collectors.toList()));
        }
        if (brandIds != null && !brandIds.isEmpty()) {
            filter.and("itembrands", "in", brandIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList()));
        }
        if (LableIds != null && !LableIds.isEmpty()) {
            Set<Long> itemsIdsByItemLabel = this.queryItemsIdsByItemLabel(new HashSet<Long>(LableIds.stream().map(s -> Long.parseLong(s.trim())).collect(Collectors.toList())));
            filter.and("itemid", "in", itemsIdsByItemLabel);
        }
        String priceName = OlstorePriceWayEnum.ONLINEPRICE.getValue().equals(priceWay) ? "onlineprice" : (OlstorePriceWayEnum.RETAILPRICE.getValue().equals(priceWay) ? "retailprice" : "memberprice");
        if (!StringUtils.isEmpty((Object)minPrice)) {
            filter.and(priceName, ">=", (Object)new BigDecimal(minPrice));
        }
        if (!StringUtils.isEmpty((Object)maxPrice)) {
            filter.and(priceName, "<=", (Object)new BigDecimal(maxPrice));
        }
        if (!StringUtils.isEmpty((Object)orderBy)) {
            orderByStr = priceName + " " + orderBy;
        }
        String selectFields = "initview".equals(type) ? this.getItemBrandsSelectFields() : this.getContentItemListSelectFields();
        long start = System.currentTimeMillis();
        if (StringUtil.isNotBlank((CharSequence)startPage) && StringUtil.isNotBlank((CharSequence)pageSize)) {
            int fromIndex = Integer.parseInt(startPage) <= 1 ? 0 : (Integer.parseInt(startPage) - 1) * Integer.parseInt(pageSize);
            data = BusinessDataServiceHelper.load((String)"ocdbd_itemsalecontent", (String)selectFields, (QFilter[])filter.toArray(), (String)orderByStr, (int)fromIndex, (int)Integer.parseInt(pageSize));
        } else {
            data = BusinessDataServiceHelper.load((String)"ocdbd_itemsalecontent", (String)selectFields, (QFilter[])filter.toArray());
        }
        logger.info("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u8017\u65f6\u7edf\u8ba1  this.getContentItemList consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        if (data != null && data.length > 0) {
            List<JSONObject> itemList = this.queryContentItemListByItemIds(data, priceWay, type);
            return JSONArray.parseArray((String)JSON.toJSONString(itemList));
        }
        return new JSONArray();
    }

    public Set<Long> queryItemsIdsByItemLabel(Set<Long> labelId) {
        if (labelId != null && !labelId.isEmpty()) {
            DynamicObject[] collection;
            HashSet<Long> itemIds = new HashSet<Long>();
            QFilter qfilter = new QFilter("id", "in", labelId);
            for (DynamicObject itemLabel : collection = BusinessDataServiceHelper.load((String)"ocdbd_item_label", (String)"id,entryentity,entryentity.item", (QFilter[])qfilter.toArray())) {
                DynamicObjectCollection entryEntities = itemLabel.getDynamicObjectCollection("entryentity");
                if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                    return itemIds;
                }
                for (DynamicObject entryEntity : entryEntities) {
                    itemIds.add(entryEntity.getLong("item.id"));
                }
            }
            return itemIds;
        }
        return new HashSet<Long>(0);
    }

    public String getContentItemListSelectFields() {
        String selectFields = ORMUtil.appendFieldsToStr((String[])new String[]{"memberprice", "retailprice", "onlineprice", "sellingprice", "barcodeid", "itemid.id", "name", "itembrands.id", "itembrands.name"});
        return selectFields;
    }

    private String getItemListSelectFields() {
        String selectFields = ORMUtil.appendFieldsToStr((String[])new String[]{"memberprice", "retailprice", "onlineprice", "sellingprice", "barcodeid", "itemid.id", "itemid.name"});
        return selectFields;
    }

    public String getItemBrandsSelectFields() {
        String selectFields = ORMUtil.appendFieldsToStr((String[])new String[]{"itembrands.id", "itembrands.name", "goodsclasssid.id", "goodsclasssid.name"});
        return selectFields;
    }

    public List<JSONObject> queryContentItemList(DynamicObject[] data, Long customerId) {
        String priceWay = this.getOnlineTakePriceWay(customerId);
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(20);
        Long start = System.currentTimeMillis();
        Map<Long, String> itemThumbnailMap = this.getItemThumbnailMap(data);
        logger.info("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u8017\u65f6\u7edf\u8ba1  this.getItemThumbnailMap consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        for (DynamicObject object : data) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("itemid", (Object)object.getString("itemid.id"));
            jsonObject.put("memberprice", (Object)object.getString("memberprice"));
            if (OlstorePriceWayEnum.ONLINEPRICE.getValue().equals(priceWay)) {
                jsonObject.put("memberprice", (Object)object.getString("onlineprice"));
            } else if (OlstorePriceWayEnum.RETAILPRICE.getValue().equals(priceWay)) {
                jsonObject.put("memberprice", (Object)object.getString("retailprice"));
            }
            jsonObject.put("itemname", (Object)object.getString("itemid.name"));
            jsonObject.put("thumbnail", (Object)itemThumbnailMap.get(object.getLong("itemid.id")));
            jsonObject.put("barcodeid", (Object)object.getString("barcodeid.id"));
            list.add(jsonObject);
        }
        return list;
    }

    private Map<Long, String> getItemThumbnailMap(DynamicObject[] data) {
        List itemIds = Arrays.asList(data).stream().map(r -> r.getLong("itemid.id")).collect(Collectors.toList());
        QFilter contentFilter = new QFilter("id", "in", itemIds);
        HashMap<Long, String> map = new HashMap<Long, String>(20);
        DynamicObjectCollection items = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)"id,thumbnail", (QFilter[])contentFilter.toArray());
        for (DynamicObject item : items) {
            map.put(item.getLong("id"), item.getString("thumbnail"));
        }
        return map;
    }

    public List<JSONObject> queryContentItemListByItemIds(DynamicObjectCollection data, String priceWay) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        for (DynamicObject object : data) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("itemid", (Object)object.getString("itemid.id"));
            jsonObject.put("memberprice", (Object)object.getString("memberprice"));
            if (OlstorePriceWayEnum.ONLINEPRICE.getValue().equals(priceWay)) {
                jsonObject.put("memberprice", (Object)object.getString("onlineprice"));
            } else if (OlstorePriceWayEnum.RETAILPRICE.getValue().equals(priceWay)) {
                jsonObject.put("memberprice", (Object)object.getString("retailprice"));
            }
            jsonObject.put("itemname", (Object)object.getString("itemid.name"));
            jsonObject.put("thumbnail", (Object)object.getString("itemid.thumbnail"));
            jsonObject.put("barcodeid", (Object)object.getString("barcodeid"));
            list.add(jsonObject);
        }
        return list;
    }

    public String getOnlineTakePriceWay(long branchId) {
        long orgId = OlstoreInventoryHelper.getSaleOrgIdByChannelId(branchId);
        return SystemParamUtil.getOnlineTakePriceWay((long)orgId, (long)branchId);
    }

    private JSONObject updatePriceBySys(JSONObject item, String customerId) {
        if (item.getString("msg").equals("success")) {
            JSONArray data = item.getJSONArray("data");
            for (int i = 0; i < data.size(); ++i) {
                JSONObject jsonObject = data.getJSONObject(i);
                String priceWay = this.getOnlineTakePriceWay(Long.parseLong(customerId));
                if (OlstorePriceWayEnum.ONLINEPRICE.getValue().equals(priceWay)) {
                    jsonObject.put("minmemberprice", (Object)jsonObject.getBigDecimal("minonlineprice"));
                    jsonObject.put("maxmemberprice", (Object)jsonObject.getBigDecimal("maxonlineprice"));
                    jsonObject.put("memberprice", (Object)jsonObject.getBigDecimal("onlineprice"));
                    continue;
                }
                if (!OlstorePriceWayEnum.RETAILPRICE.getValue().equals(priceWay)) continue;
                jsonObject.put("minmemberprice", (Object)jsonObject.getBigDecimal("minretailprice"));
                jsonObject.put("maxmemberprice", (Object)jsonObject.getBigDecimal("maxretailprice"));
                jsonObject.put("memberprice", (Object)jsonObject.getBigDecimal("retailprice"));
            }
        }
        return item;
    }

    public DynamicObject getSpuMapName(long itemId, long auxptyId) {
        QFilter filter = new QFilter("entryentity_specmap.itemid", "=", (Object)itemId);
        filter.and("entryentity_specmap.auxptyid", "=", (Object)auxptyId);
        return QueryServiceHelper.queryOne((String)"ocdbd_spu", (String)"entryentity_specmap.spumapname", (QFilter[])filter.toArray());
    }

    public JSONObject queryItemDetailByBarcode(String customerId, String barcode, String appendFieldStr) {
        JSONObject item = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"ItemSaleContentService", (String)"queryItemDetailByBarcode", (Object[])new Object[]{"ocdbd_itemsalecontent", customerId, "0", barcode, appendFieldStr});
        return this.updatePriceBySys(item, customerId);
    }

    public boolean isOlstoreSale(Long customerId, Long barcode, Long itemId) {
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("channelid", "=", (Object)customerId);
        filter.and("itemid", "=", (Object)itemId);
        filter.and("barcodeid", "=", (Object)barcode);
        DynamicObject query = QueryServiceHelper.queryOne((String)"ocdbd_itemsalecontent", (String)"salescope", (QFilter[])filter.toArray());
        return query != null && query.getString("salescope").contains(OLSTORE_SALE);
    }

    public List<JSONObject> getTicketItemList(DynamicObject ticketType, long customerId, String keyword, int page, int pageSize) {
        String selectFields;
        DynamicObject[] data;
        HashSet<Long> itemListByTicketType;
        boolean isAllGoods;
        String orderByStr = "id desc";
        QFilter filter = F7Utils.getEnableStatus();
        filter.and("channelid", "=", (Object)customerId);
        filter.and("salescope", "like", (Object)"%b%");
        if (!kd.bos.util.StringUtils.isEmpty((String)keyword)) {
            filter.and("name", "like", (Object)("%" + keyword + "%"));
        }
        if (!(isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isallgoods")) && (itemListByTicketType = this.getItemListByTicketType(ticketType)) != null && itemListByTicketType.size() > 0) {
            filter.and("itemid", "in", itemListByTicketType);
        }
        if ((data = BusinessDataServiceHelper.load((String)"ocdbd_itemsalecontent", (String)(selectFields = this.getItemListSelectFields()), (QFilter[])filter.toArray(), (String)orderByStr, (int)page, (int)pageSize)) != null && data.length > 0) {
            return this.queryContentItemList(data, customerId);
        }
        return null;
    }

    public List<JSONObject> queryContentItemListByItemIds(DynamicObject[] data, String priceWay, String type) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>(20);
        if ("initview".equals(type)) {
            for (DynamicObject object : data) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("itembrands.id", (Object)object.getString("itembrands.id"));
                jsonObject.put("itembrands.name", (Object)object.getString("itembrands.name"));
                jsonObject.put("goodsclasssid.id", (Object)object.getString("goodsclasssid.id"));
                jsonObject.put("goodsclasssid.name", (Object)object.getString("goodsclasssid.name"));
                list.add(jsonObject);
            }
        } else {
            Long start = System.currentTimeMillis();
            Map<Long, String> itemThumbnailMap = this.getItemThumbnailMap(data);
            logger.info("\u5546\u54c1\u5217\u8868\u67e5\u8be2\u8017\u65f6\u7edf\u8ba1  this.getItemThumbnailMap consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            for (DynamicObject object : data) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("itemid", (Object)object.getString("itemid.id"));
                jsonObject.put("memberprice", (Object)object.getString("memberprice"));
                if (OlstorePriceWayEnum.ONLINEPRICE.getValue().equals(priceWay)) {
                    jsonObject.put("memberprice", (Object)object.getString("onlineprice"));
                } else if (OlstorePriceWayEnum.RETAILPRICE.getValue().equals(priceWay)) {
                    jsonObject.put("memberprice", (Object)object.getString("retailprice"));
                }
                jsonObject.put("itemname", (Object)object.getString("itemid.name"));
                jsonObject.put("thumbnail", (Object)itemThumbnailMap.get(object.getLong("itemid.id")));
                jsonObject.put("barcodeid", (Object)object.getString("barcodeid.id"));
                jsonObject.put("itembrands.id", (Object)object.getString("itembrands.id"));
                jsonObject.put("itembrands.name", (Object)object.getString("itembrands.name"));
                list.add(jsonObject);
            }
        }
        return list;
    }

    public HashSet<Long> getItemListByTicketType(DynamicObject ticketType) {
        DynamicObjectCollection goodsList = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)ticketType, (String)"tictgoodsentry");
        HashSet<Long> goodsIdList = new HashSet<Long>();
        if (!CollectionUtils.isEmpty((Collection)goodsList)) {
            List<Long> itemId = OlstoreItemHelper.getItemId(goodsList);
            List<Long> itemIdByItemClass = OlstoreItemHelper.getItemIdByItemClass(goodsList);
            List<Long> itemIdByItemBrand = OlstoreItemHelper.getItemIdByItemBrand(goodsList);
            List<Long> itemIdByItemLabel = OlstoreItemHelper.getItemIdByItemLabel(goodsList);
            if (itemId != null && itemId.size() > 0) {
                goodsIdList.addAll(itemId);
            }
            if (itemIdByItemClass != null && itemIdByItemClass.size() > 0) {
                goodsIdList.addAll(itemIdByItemClass);
            }
            if (itemIdByItemBrand != null && itemIdByItemBrand.size() > 0) {
                goodsIdList.addAll(itemIdByItemBrand);
            }
            if (itemIdByItemLabel != null && itemIdByItemLabel.size() > 0) {
                goodsIdList.addAll(itemIdByItemLabel);
            }
        }
        return goodsIdList;
    }
}

