/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.business.helper.UserHelper;
import kd.occ.ocbase.common.pojo.dto.member.rule.PointRewardDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.AddAddressDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.DeleteAddressByIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.GetChannelConsultantDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryAddressByIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryAddressListDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryDefaultAddressDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryUserByIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryWechatOpenIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.QueryWechatUserByIdDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.UpdateAddressDTO;
import kd.occ.ocbase.common.pojo.dto.member.user.UpdateUserByIdDTO;
import kd.occ.ocbase.common.pojo.vo.member.user.AssistantDataVO;
import kd.occ.ocdbd.common.mempoint.PointSavingVO;
import kd.occ.ocpos.common.util.promotion.DateFormatUtils;

public class OlstoreMemberProcessor {
    private static Log logger = LogFactory.getLog(OlstoreMemberProcessor.class);

    public long queryAddressTypeList() {
        JSONObject jsonObject = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryAddressTypeList", (Object[])new Object[0]);
        if (!ObjectUtils.isEmpty((Object)jsonObject) && jsonObject.getInteger("code") == 0 && !ObjectUtils.isEmpty((Object)jsonObject.get((Object)"data"))) {
            List dataArr = JSON.parseArray((String)jsonObject.getJSONArray("data").toJSONString(), AssistantDataVO.class);
            AssistantDataVO assistantDataVO = dataArr.stream().filter(p -> p.getName().equals("\u6536\u8d27\u5730\u5740")).findFirst().orElse(null);
            if (assistantDataVO != null) {
                return assistantDataVO.getId();
            }
            return 0L;
        }
        return 0L;
    }

    public JSONObject getChannelConsultant(Long channelId) {
        GetChannelConsultantDTO dto = new GetChannelConsultantDTO();
        dto.setChannelId(channelId);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"getChannelConsultant", (Object[])new Object[]{dto});
    }

    public JSONObject getDeliveryAddressList(long memberId) {
        QueryAddressListDTO dto = new QueryAddressListDTO();
        dto.setUserId(Long.valueOf(memberId));
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryAddressList", (Object[])new Object[]{dto});
    }

    public JSONObject getDeliveryAddressById(long addressId) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"MemberService", (String)"queryrAddressByAddrId", (Object[])new Object[]{addressId});
    }

    public JSONObject getDeliveryAddressByIdDTO(QueryAddressByIdDTO dto) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryAddressById", (Object[])new Object[]{dto});
    }

    public JSONObject queryDefaultAddressByUserId(long addressId) {
        QueryDefaultAddressDTO dto = new QueryDefaultAddressDTO();
        dto.setUserId(Long.valueOf(addressId));
        dto.setQueryAll(false);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryDefaultAddressByUserId", (Object[])new Object[]{dto});
    }

    public JSONObject updateUserById(long memberId, long channelId, long developerId) {
        UpdateUserByIdDTO dto = new UpdateUserByIdDTO();
        dto.setUserId(Long.valueOf(memberId));
        dto.setChannelId(Long.valueOf(channelId));
        dto.setDeveloperId(Long.valueOf(developerId));
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"updateUserById", (Object[])new Object[]{dto});
    }

    public JSONObject updateDeliveryAddress(UpdateAddressDTO dto) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"updateAddress", (Object[])new Object[]{dto});
    }

    public JSONObject insertDeliveryAddress(AddAddressDTO dto) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"addAddress", (Object[])new Object[]{dto});
    }

    public JSONObject deleteDeliveryAddressById(Long userId, Long addressId) {
        DeleteAddressByIdDTO dto = new DeleteAddressByIdDTO();
        dto.setUserId(userId);
        dto.setAddressId(addressId);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"deleteAddressById", (Object[])new Object[]{dto});
    }

    public BigDecimal getMemberPoint(String phoneNumber) {
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocorvc", (String)"AccountBalanceService", (String)"queryPointSavingByMember", (Object[])new Object[]{Collections.singletonList(new String[]{phoneNumber})});
        if (result == null || result.getInteger("code") != 0) {
            return BigDecimal.ZERO;
        }
        JSONArray dataArray = result.getJSONArray("data");
        if (dataArray != null && dataArray.size() > 0) {
            return dataArray.getJSONObject(0).getBigDecimal("availableBalance");
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getAccountBalance(String phoneNumber) {
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocorvc", (String)"AccountBalanceService", (String)"queryAmountSavingByMember", (Object[])new Object[]{Collections.singletonList(new String[]{phoneNumber})});
        if (result == null || result.getInteger("code") != 0) {
            return BigDecimal.ZERO;
        }
        JSONArray dataArray = result.getJSONArray("data");
        if (dataArray != null && dataArray.size() > 0) {
            return dataArray.getJSONObject(0).getBigDecimal("availableBalance");
        }
        return BigDecimal.ZERO;
    }

    public JSONObject getMemberCardInfo(long memberId) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"AccountService", (String)"queryAccountByMember", (Object[])new Object[]{Collections.singletonList(new Object[]{memberId})});
    }

    public JSONObject updateMemberInfo(UpdateUserByIdDTO dto) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"updateUserById", (Object[])new Object[]{dto});
    }

    public JSONObject getMemberInfoById(long memberId) {
        QueryUserByIdDTO dto = new QueryUserByIdDTO();
        dto.setUserId(Long.valueOf(memberId));
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"UserService", (String)"queryUserById", (Object[])new Object[]{dto});
    }

    public JSONObject getCouponList(JSONObject dataJson) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"queryTicketInfoList", (Object[])new Object[]{dataJson});
    }

    public BigDecimal getMemberPoint(String memberId, Long pointTypeId) {
        BigDecimal memberPoint = BigDecimal.ZERO;
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberId", (Object)memberId);
        if (pointTypeId != null && pointTypeId > 0L) {
            ArrayList<Long> pointTypeIdList = new ArrayList<Long>();
            pointTypeIdList.add(pointTypeId);
            jsonObject.put("pointTypeIdList", pointTypeIdList);
        }
        logger.info("getMemberPoint \u83b7\u53d6\u4f1a\u5458\u79ef\u5206 \u53c2\u6570\uff1a" + jsonObject);
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"queryPointSavingByMemberId", (Object[])new Object[]{jsonObject});
        logger.info("getMemberPoint \u83b7\u53d6\u4f1a\u5458\u79ef\u5206 \u8fd4\u56de\u503c result\uff1a" + result);
        if (result != null) {
            if ("0".equals(result.getString("code"))) {
                List pointDetailVOList = JSON.parseArray((String)result.getJSONArray("data").toJSONString(), PointSavingVO.class);
                for (PointSavingVO vo : pointDetailVOList) {
                    memberPoint = memberPoint.add(BigDecimal.valueOf(vo.getAvailableQty()));
                }
            } else {
                logger.info("\u4f1a\u5458id" + memberId + " \u83b7\u53d6\u4e0d\u5230\u4f1a\u5458\u79ef\u5206\u539f\u56e0\uff1a" + result.getString("message"));
            }
        }
        logger.info("getMemberPoint \u83b7\u53d6\u4f1a\u5458\u79ef\u5206 \u8fd4\u56de\u503c memberPoint\uff1a" + memberPoint);
        return memberPoint;
    }

    public Long queryPointTypeId() {
        DynamicObjectCollection pointTypeList = QueryServiceHelper.query((String)"ocdbd_mpointtype", (String)"id,name", (QFilter[])new QFilter[0]);
        DynamicObject dynamicObject = pointTypeList.stream().filter(a -> a.getString("name").equals("\u7ebf\u4e0a\u95e8\u5e97\u79ef\u5206\u7c7b\u578b")).findFirst().orElse(null);
        if (dynamicObject != null) {
            return dynamicObject.getLong("id");
        }
        return null;
    }

    public String queryPointBizTypeNameById(long id) {
        QFilter filter = new QFilter("id", "=", (Object)id);
        DynamicObject pointBizType = QueryServiceHelper.queryOne((String)"ocdbd_mpointbiztype", (String)"id,name", (QFilter[])filter.toArray());
        if (pointBizType != null) {
            return pointBizType.getString("name");
        }
        return null;
    }

    public JSONObject queryPointList(long memberId, int pageIndex, int pageSize, Long pointTypeId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("memberId", (Object)memberId);
        jsonObject.put("pageIndex", (Object)(pageIndex - 1));
        jsonObject.put("pageSize", (Object)pageSize);
        if (pointTypeId != null && pointTypeId > 0L) {
            ArrayList<Long> pointTypeIdList = new ArrayList<Long>();
            pointTypeIdList.add(pointTypeId);
            jsonObject.put("pointTypeIdList", pointTypeIdList);
        }
        jsonObject.put("pointStatusList", null);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"queryPointDetailByMemberId", (Object[])new Object[]{jsonObject});
    }

    public BigDecimal getRightsRuleService(String memberId, String pointTypeId) {
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> pointTypeIdList = new ArrayList<String>();
        pointTypeIdList.add(pointTypeId);
        jsonObject.put("memberId", (Object)memberId);
        jsonObject.put("pointTypeIdList", pointTypeIdList);
        JSONObject result = (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"queryPointSavingByMemberId", (Object[])new Object[]{jsonObject});
        if (result == null || result.getInteger("code") != 0) {
            return BigDecimal.ZERO;
        }
        JSONArray dataArray = result.getJSONArray("data");
        if (dataArray != null && dataArray.size() > 0) {
            return dataArray.getJSONObject(0).getBigDecimal("availableBalance");
        }
        return BigDecimal.ZERO;
    }

    public JSONObject pointReward(long orgId, long channelId, long memberId, BigDecimal realTotalAmount, String srcNo) {
        PointRewardDTO dto = new PointRewardDTO();
        dto.setUseOrgId(Long.valueOf(orgId));
        dto.setChannelId(Long.valueOf(channelId));
        dto.setBizTypeNum("SysPointBizType-009");
        dto.setBizTime(DateFormatUtils.formatDate((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
        dto.setValue(realTotalAmount);
        dto.setVipId(Long.valueOf(memberId));
        dto.setSrcNO(srcNo);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdbd", (String)"RightsRuleService", (String)"pointReward", (Object[])new Object[]{dto});
    }

    public JSONObject queryWechatUserById(String appId, long memberId) {
        QueryWechatOpenIdDTO dto = new QueryWechatOpenIdDTO();
        dto.setUserId(Long.valueOf(memberId));
        dto.setAppId(appId);
        return UserHelper.queryWechatOpenId((QueryWechatOpenIdDTO)dto);
    }

    public JSONObject queryWechatUserInfo(String appId, long memberId) {
        QueryWechatUserByIdDTO dto = new QueryWechatUserByIdDTO();
        dto.setUserId(Long.valueOf(memberId));
        dto.setAppId(appId);
        return UserHelper.queryWechatUserById((QueryWechatUserByIdDTO)dto);
    }
}

