/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.promotion.OlstorePromotionHelper;
import kd.occ.ocpos.common.entity.request.CxPromotionRequestEntity;
import kd.occ.ocpos.common.entity.request.CxPromotionResultEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.util.CommonUtil;

public class OlstorePromotionTransferHelper {
    private static Log logger = LogFactory.getLog(OlstorePromotionTransferHelper.class);

    public static String queryPromotion(DynamicObjectCollection itemList, int index, long customerId, long memberID, boolean isShowActName) {
        StringBuilder sb = new StringBuilder();
        boolean isGift = false;
        CxPromotionRequestEntity requestEntity = OlstorePromotionTransferHelper.buildPromotionParam(itemList, index, customerId, memberID);
        logger.info("OlstorePromotionTransferHelper queryPromotion \u83b7\u53d6index:" + index + "\u5546\u54c1\u540d\u79f0\uff1a" + ((DynamicObject)itemList.get(index)).getString("itemname") + "\u7684\u4fc3\u9500\u4fe1\u606f\u53c2\u6570:" + JSON.toJSONString((Object)requestEntity));
        List<CxPromotionResultEntity> cxPromotionResultEntities = OlstorePromotionHelper.matchPromotion(requestEntity);
        logger.info("OlstorePromotionTransferHelper queryPromotion \u83b7\u53d6index:" + index + "\u5546\u54c1\u540d\u79f0\uff1a" + ((DynamicObject)itemList.get(index)).getString("itemname") + "\u7684\u4fc3\u9500\u4fe1\u606f\u7ed3\u679c:" + JSON.toJSONString(cxPromotionResultEntities));
        for (int i = 0; i < cxPromotionResultEntities.size(); ++i) {
            CxPromotionResultEntity entity = cxPromotionResultEntities.get(i);
            if (!isGift && PromotionEnum.onlineGiftPromotion().contains(entity.getTypeName())) {
                isGift = true;
            } else if (isGift && PromotionEnum.onlineGiftPromotion().contains(entity.getTypeName())) break;
            List itemIdList = entity.getItemList();
            if (itemIdList.contains(((DynamicObject)itemList.get(index)).getString("itemid"))) {
                if (isShowActName) {
                    sb.append(entity.getActName());
                    sb.append('\uff1a');
                    sb.append(entity.getName());
                    sb.append('\n');
                } else {
                    sb.append(entity.getName());
                    sb.append('\n');
                }
            }
            isGift = true;
        }
        return sb.toString();
    }

    public static CxPromotionRequestEntity buildPromotionParam(DynamicObjectCollection itemList, int index, long customerId, long memberID) {
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo(customerId);
        String dbId = storeInfo.getString("saleorg");
        String storeId = String.valueOf(customerId);
        String memberId = String.valueOf(memberID);
        String billDate = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
        DynamicObject member = BusinessDataServiceHelper.loadSingle((Object)memberId, (String)"ocdbd_user");
        String memberlevelid = member.getDynamicObject("viplevelid") != null ? member.getDynamicObject("viplevelid").getString("id") : "";
        CxPromotionRequestEntity cxRequestEntity = new CxPromotionRequestEntity(dbId, storeId, memberId, memberlevelid, billDate, true);
        OlstorePromotionTransferHelper.buildMaterialEntry(itemList, index, cxRequestEntity);
        return cxRequestEntity;
    }

    private static void buildMaterialEntry(DynamicObjectCollection itemList, int index, CxPromotionRequestEntity cxRequestEntity) {
        ArrayList<MaterialEntryEntity> materialEntryEntityList = new ArrayList<MaterialEntryEntity>(16);
        for (int i = 0; i < itemList.size(); ++i) {
            DynamicObject item = (DynamicObject)itemList.get(i);
            String unitId = item.getString("unitid");
            String auxattrId = item.getString("auxptyid");
            BigDecimal qty = item.getBigDecimal("qty");
            BigDecimal memberPrice = item.getBigDecimal("memberprice");
            DynamicObject itemObject = BusinessDataServiceHelper.loadSingle((Object)item.getString("itemid"), (String)"ocdbd_iteminfo");
            if (itemObject == null) {
                return;
            }
            DynamicObject goodsBrand = DynamicObjectUtils.getDynamicObject((DynamicObject)itemObject, (String)"itembrands");
            String brandId = DynamicObjectUtils.getString((DynamicObject)goodsBrand, (String)"id");
            List classIds = ItemClassUtil.queryClassList((Object)itemObject.getString("id"));
            MaterialEntryEntity entryEntity = new MaterialEntryEntity(0, itemObject.getString("id"), itemObject.getString("name"), unitId, auxattrId, memberPrice, qty, brandId, classIds.stream().map(CommonUtil::formatStringToEmpty).collect(Collectors.toList()), null, null, false);
            materialEntryEntityList.add(entryEntity);
            if (i != index) continue;
            cxRequestEntity.setMatchMaterial(entryEntity);
        }
        cxRequestEntity.setMaterialEntries(materialEntryEntityList);
        cxRequestEntity.setMaterialEntries(materialEntryEntityList);
    }
}

