/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocpos.business.olstore.OlstoreConfigHelper;
import kd.occ.ocpos.common.util.DistanceUitl;

public class OlstoreStoreInfoProcessor {
    private static Log logger = LogFactory.getLog(OlstoreStoreInfoProcessor.class);
    private static final String ADMINDIVISION = "bd_admindivision";
    public static final String COLS = "id,name,area,address,phone,logo,longitude,beginstoreworktime,endstoreworktime, latitude,saleorg";

    public List<Map<String, Object>> getStoreList(BigDecimal latitude, BigDecimal longitude, int page, int pageSize) {
        Map<String, Object> storeMsg;
        int fromIndex = page <= 1 ? 0 : (page - 1) * pageSize;
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("isonlinestore", "=", (Object)"1");
        DynamicObject[] storeIdArr = BusinessDataServiceHelper.load((String)"ocdbd_channel", (String)"id", (QFilter[])filter.toArray(), (String)"isdefaultstore desc", (int)fromIndex, (int)pageSize);
        if (storeIdArr == null || storeIdArr.length == 0) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList storeIds = new ArrayList(0);
        storeIds.addAll(Arrays.stream(storeIdArr).map(x -> x.getLong("id")).collect(Collectors.toList()));
        filter = new QFilter("id", "in", storeIds);
        DynamicObjectCollection storeList = QueryServiceHelper.query((String)"ocdbd_channel", (String)COLS, (QFilter[])filter.toArray(), (String)" isdefaultstore desc");
        ArrayList<Map<String, Object>> storeInfoList = new ArrayList<Map<String, Object>>();
        if (latitude != null && longitude != null) {
            DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
            BigDecimal distancestore = olstoreCogInfo.getBigDecimal("distancestore");
            double nearStoreDistance = distancestore.multiply(new BigDecimal("1000")).doubleValue();
            for (DynamicObject storeInfo : storeList) {
                double distance = DistanceUitl.GetDistance((BigDecimal)storeInfo.getBigDecimal("latitude"), (BigDecimal)storeInfo.getBigDecimal("longitude"), (BigDecimal)latitude, (BigDecimal)longitude);
                if (!(distance <= nearStoreDistance)) continue;
                BigDecimal distanceBig = new BigDecimal(Double.toString(distance));
                BigDecimal distanceDiv = distanceBig.divide(new BigDecimal(Double.toString(1000.0)), 1, RoundingMode.HALF_UP);
                storeMsg = this.bulidMap(storeInfo);
                storeMsg.put("distance", distanceDiv);
                storeInfoList.add(storeMsg);
            }
        }
        if (CollectionUtils.isEmpty(storeInfoList)) {
            storeMsg = this.bulidMap(this.getDefaultStore());
            storeInfoList.add(storeMsg);
        } else {
            Collections.sort(storeInfoList, (o1, o2) -> {
                BigDecimal distance2;
                BigDecimal distance1 = (BigDecimal)o1.get("distance");
                if (distance1.compareTo(distance2 = (BigDecimal)o2.get("distance")) > 0) {
                    return 1;
                }
                if (distance1.compareTo(distance2) < 0) {
                    return -1;
                }
                return 0;
            });
        }
        return storeInfoList;
    }

    protected Map<String, Object> bulidMap(DynamicObject storeInfo) {
        HashMap<String, Object> storeMsg = new HashMap<String, Object>();
        storeMsg.put("id", storeInfo.getLong("id"));
        storeMsg.put("logo", storeInfo.getString("logo"));
        storeMsg.put("name", storeInfo.get("name"));
        storeMsg.put("address", storeInfo.get("address"));
        storeMsg.put("longitude", storeInfo.getString("longitude"));
        storeMsg.put("latitude", storeInfo.getString("latitude"));
        return storeMsg;
    }

    public DynamicObject getDefaultStore() {
        DynamicObject olstoreCogInfo = OlstoreConfigHelper.getOlstoreConfig();
        long storeId = DynamicObjectUtils.getDynamicObjectLPkValue((DynamicObject)olstoreCogInfo, (String)"storeid");
        return BusinessDataServiceHelper.loadSingle((Object)storeId, (String)"ocdbd_channel", (String)COLS);
    }

    public DynamicObject getNearestStore(BigDecimal localLongitude, BigDecimal localLatitude) {
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and("isonlinestore", "=", (Object)"1");
        DynamicObjectCollection entrys = QueryServiceHelper.query((String)"ocdbd_channel", (String)COLS, (QFilter[])filter.toArray());
        Collections.sort(entrys, (o1, o2) -> {
            double distance2;
            double distance1 = DistanceUitl.GetDistance((BigDecimal)o1.getBigDecimal("latitude"), (BigDecimal)o1.getBigDecimal("longitude"), (BigDecimal)localLatitude, (BigDecimal)localLongitude);
            if (distance1 > (distance2 = DistanceUitl.GetDistance((BigDecimal)o2.getBigDecimal("latitude"), (BigDecimal)o2.getBigDecimal("longitude"), (BigDecimal)localLatitude, (BigDecimal)localLongitude))) {
                return 1;
            }
            if (distance1 < distance2) {
                return -1;
            }
            return 0;
        });
        return (DynamicObject)entrys.get(0);
    }

    public DynamicObject getStoreInfo(long storeid) {
        QFilter filter = new QFilter("id", "=", (Object)storeid);
        return QueryServiceHelper.queryOne((String)"ocdbd_channel", (String)COLS, (QFilter[])filter.toArray());
    }

    public DynamicObject getDivisionIdByAddress(String nation, String province, String city, String district) {
        DynamicObject adminDivision = this.getDivisionIdByAddress(nation, province, city, district, true);
        if (adminDivision == null) {
            adminDivision = this.getDivisionIdByAddress(nation, province, city, district, false);
        }
        return adminDivision;
    }

    public long getNewListrictId(long districtId) {
        logger.info("\u6839\u636e\u533a\u57dfid\u67e5\u8be2\u6700\u65b0\u533a\u57dfid, districtId:" + districtId);
        QFilter filters = new QFilter("id", "=", (Object)districtId);
        DynamicObject adminDivision = ORM.create().queryOne(ADMINDIVISION, filters.toArray());
        if (!adminDivision.getString("enable").equals(EnableStatusEnum.ENABLE.getValue()) || !adminDivision.getString("status").equals(StatusEnum.AUDIT.getValue())) {
            logger.info("\u6839\u636e\u533a\u57dfid\u67e5\u8be2\u6700\u65b0\u533a\u57dfid\uff0c fullName:" + adminDivision.getString("fullName"));
            QFilter filter = new QFilter("fullname", "=", (Object)adminDivision.getString("fullName"));
            filter.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
            filter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
            DynamicObject division = ORM.create().queryOne(ADMINDIVISION, filter.toArray());
            if (division != null) {
                return division.getLong("id");
            }
        }
        return districtId;
    }

    public DynamicObject getDivisionIdByAddress(String nation, String province, String city, String district, boolean isFull) {
        String provinceName = this.getProvinceName(province, isFull);
        String cityName = this.getCityName(city, isFull);
        String districtName = this.getDistrictName(district, isFull);
        StringBuilder nameBuffer = new StringBuilder();
        if (StringUtil.isNotNull((String)provinceName)) {
            nameBuffer.append(provinceName).append('_');
        }
        if (StringUtil.isNotNull((String)cityName)) {
            nameBuffer.append(cityName).append('_');
        }
        if (StringUtil.isNotNull((String)districtName)) {
            nameBuffer.append(districtName).append('_');
        }
        String fullName = "";
        if (nameBuffer.length() > 1) {
            fullName = nameBuffer.toString().substring(0, nameBuffer.length() - 1);
        }
        QFilter filters = new QFilter("fullname", "=", (Object)fullName);
        filters.and(new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue()));
        filters.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        logger.info(String.format("\u5fae\u4fe1\u5730\u56fe\u67e5\u8be2\u65b0\u653f\u533a\u5212\u7684fulname:%s", fullName));
        DynamicObject adminDivision = ORM.create().queryOne(ADMINDIVISION, filters.toArray());
        long id = adminDivision == null ? 0L : DynamicObjectUtils.getPkValue((DynamicObject)adminDivision);
        logger.info(String.format("\u5fae\u4fe1\u5730\u56fe\u67e5\u8be2\u65b0\u653f\u533a\u5212\u7684ID:%s", id));
        return adminDivision;
    }

    private String getProvinceName(String nationName, boolean isFull) {
        return this.getAdminDivisionName(nationName, (isFull ? "(\\S)" : "") + "([\u7701]|[\u7279][\u522b][\u884c][\u653f][\u533a]|[\u81ea][\u6cbb][\u533a]|[\u5e02])", isFull);
    }

    private String getCityName(String cityName, boolean isFull) {
        return this.getAdminDivisionName(cityName, (isFull ? "(\\S)" : "") + "([\u81ea\u6cbb\u5dde]|[\u533a]|[\u5e02])", isFull);
    }

    private String getDistrictName(String districtName, boolean isFull) {
        return this.getAdminDivisionName(districtName, (isFull ? "(\\S)" : "") + "([\u53bf]|[\u533a]|[\u5e02]|[\u6d77][\u57df]|[\u65d7])", isFull);
    }

    private String getAdminDivisionName(String name, String regex, boolean isFull) {
        Matcher m = Pattern.compile(regex).matcher(name);
        String divisionName = "";
        if (m.find()) {
            divisionName = m.group();
        }
        return isFull ? name : (StringUtil.isNotNull((String)name) ? name.replace(divisionName, "") : "");
    }
}

