/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.ItemClassNodeUtil;
import kd.occ.ocpos.business.olstore.OlstoreTicketProcessor;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class OlstoreTicketHelper {
    protected static Log logger = LogFactory.getLog(OlstoreTicketHelper.class);
    private static final OlstoreTicketProcessor processer = new OlstoreTicketProcessor();

    public static JSONObject queryTicketInfoList(JSONObject jsonObject) {
        return processer.queryTicketInfoList(jsonObject);
    }

    public static JSONObject queryTicketInfoDetail(JSONObject jsonObject) {
        return processer.queryTicketInfoDetail(jsonObject);
    }

    public static JSONObject ticketInfoGift(JSONObject jsonObject) {
        return processer.ticketInfoGift(jsonObject);
    }

    public static JSONObject ticketInfoPay(JSONObject jsonObject) {
        return processer.ticketInfoPay(jsonObject);
    }

    public static JSONObject ticketInfoRefund(JSONObject jsonObject) {
        return processer.ticketInfoRefund(jsonObject);
    }

    public static JSONObject distributeAndPublish(JSONObject jsonObject) {
        return processer.distributeAndPublish(jsonObject);
    }

    public static DynamicObject[] queryFromOnlineInvitation(JSONObject jsonObject) {
        return processer.queryFromOnlineInvitation(jsonObject);
    }

    public static DynamicObject[] queryTicketOrderList(JSONObject jsonObject) {
        return processer.queryTicketOrderList(jsonObject);
    }

    public static Map<Object, DynamicObject> getTicketInfoByBranchId(long branchId, String ticketStatus, long memberId) {
        return processer.getTicketInfoByBranchId(branchId, ticketStatus, memberId);
    }

    public static DynamicObject queryTicketOrderDetail(long id) {
        return processer.queryTicketOrderDetail(id);
    }

    public static JSONObject recycleTicketOrder(JSONObject jsonObject) {
        return processer.recycleTicketOrder(jsonObject);
    }

    public static boolean isHaveCancelTicket(DynamicObjectCollection ticketInfoList) {
        for (DynamicObject ticketInfo : ticketInfoList) {
            String ticketStatus = ticketInfo.getString("ticketid.ticketstatus");
            if (!TicketStatusEnum.CHECKED.getName().equals(ticketStatus)) continue;
            return true;
        }
        return false;
    }

    public static boolean isHaveRecoveryTicket(DynamicObjectCollection ticketInfoList) {
        for (DynamicObject ticketInfo : ticketInfoList) {
            String ticketStatus = ticketInfo.getString("ticketid.ticketstatus");
            if (!TicketStatusEnum.RECOVERY.getName().equals(ticketStatus)) continue;
            return true;
        }
        return false;
    }

    public static JSONObject buildTicketInfo(HashMap hashMap) {
        return processer.buildTicketInfo(hashMap);
    }

    public static JSONObject publish(JSONObject jsonObject) {
        return processer.publish(jsonObject);
    }

    public static JSONObject queryReceiveTicketList(long vipID, long branchId, int pageIndex, int pageSize) {
        return processer.queryReceiveTicketList(vipID, branchId, pageIndex, pageSize);
    }

    public static JSONObject queryReceiveTicketDetail(long schemeID, long vipID) {
        return processer.queryReceiveTicketDetail(schemeID, vipID);
    }

    public static JSONObject receiveTicket(long vipID, long schemeID, long branchId) {
        return processer.receiveTicket(vipID, schemeID, branchId);
    }

    public static JSONObject queryGiftListForTicket(long ticketId, long branchid, int pageIndex, int pageSize) {
        return processer.queryGiftListForTicket(ticketId, branchid, pageIndex, pageSize);
    }

    public static JSONObject activateByPosSaleOrder(long saleOrderId) {
        return processer.activateByPosSaleOrder(saleOrderId);
    }

    public static Boolean isHasOutstandingTicket(long schemeId, long vipID) {
        return processer.isHasOutstandingTicket(schemeId, vipID);
    }

    public static long getTicketInfoIdByschemeId(long schemeId, long vipID) {
        return processer.getTicketInfoIdByschemeId(schemeId, vipID);
    }

    public static JSONObject afterTicketPaySuccess(JSONObject paramJson, DynamicObjectCollection ticketTypes) {
        return processer.afterTicketPaySuccess(paramJson, ticketTypes);
    }

    public static List<Long> getMemberTicketInfo(QFilter filters, List<DynamicObject> lstGoods, long branchId, long memberId, String numberFilter) {
        ArrayList<Long> lstTickets = new ArrayList<Long>(0);
        DynamicObjectCollection ticketColl = QueryServiceHelper.query((String)"ocdbd_ticketinfo", (String)"id,tickettypeid.isallgoods as isallgoods,tickettypeid.controlmethod as controlmethod,publishbranchid,tickettypeid.treeentryentity.isapply as isapply,tickettypeid.treeentryentity.branch as branch,tickettypeid.tictgoodsentry.type as type,tickettypeid.tictgoodsentry.goods as goods,tickettypeid.tictgoodsentry.itemlabel as itemlabel,tickettypeid.tictgoodsentry.goodsclassify as goodsclassify,tickettypeid.tictgoodsentry.brand as brand,tickettypeid.tictgoodsentry.saleattr as saleattr,vipid", (QFilter[])filters.toArray());
        logger.info("\u8ba2\u5355\u786e\u8ba4\u793c\u5238\u8fc7\u6ee4 \u5206\u7c7bid\uff1a" + ticketColl.size());
        if (ticketColl == null || ticketColl.size() == 0) {
            return lstTickets;
        }
        List lstGoodsClassifyId = ticketColl.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"type"), (CharSequence)"2") || StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"type"), (CharSequence)"5") && DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsclassify") > 0L).map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsclassify")).distinct().collect(Collectors.toList());
        logger.info("\u8ba2\u5355\u786e\u8ba4\u5546\u54c1\u8fc7\u6ee4 \u5206\u7c7bid\uff1a" + lstGoodsClassifyId.toString());
        Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet(lstGoodsClassifyId));
        logger.info("\u8ba2\u5355\u786e\u8ba4\u5546\u54c1\u8fc7\u6ee4 \u5b50\u5206\u7c7bid\uff1a" + lstGoodsClassifyId.toString());
        block12: for (DynamicObject ticket : ticketColl) {
            boolean applyStore;
            long vipId;
            if (StringUtils.isNotEmpty((CharSequence)numberFilter) && (vipId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"vipid")) != 0L && vipId != memberId) continue;
            long ticketId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"id");
            boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticket, (String)"isallgoods");
            String ctrlMethod = DynamicObjectUtil.getString((DynamicObject)ticket, (String)"controlmethod");
            long applyBranchId = DynamicObjectUtil.getLong((DynamicObject)ticket, (String)"branch");
            boolean isApply = DynamicObjectUtil.getBoolean((DynamicObject)ticket, (String)"isapply");
            long publishBranchId = DynamicObjectUtil.getLong((DynamicObject)ticket, (String)"publishbranchid");
            boolean applyAll = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"0");
            boolean applyPublishStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"1") && publishBranchId == branchId;
            boolean bl = applyStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"2") && applyBranchId == branchId && isApply;
            if (!applyAll && !applyPublishStore && !applyStore) continue;
            if (isAllGoods) {
                if (lstTickets.contains(ticketId)) continue;
                lstTickets.add(ticketId);
                continue;
            }
            String goodsType = DynamicObjectUtils.getString((DynamicObject)ticket, (String)"type");
            long itemLabelId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"itemlabel");
            long goodsClassifyId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"goodsclassify");
            long brandId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"brand");
            ArrayList<Long> saleAttrIds = new ArrayList<Long>(0);
            ArrayList<Long> invTypeIds = new ArrayList<Long>(0);
            switch (goodsType) {
                case "1": {
                    long goodsId = DynamicObjectUtils.getLong((DynamicObject)ticket, (String)"goods");
                    if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == goodsId)) break;
                    continue block12;
                }
                case "2": {
                    if (OlstoreTicketHelper.isMatchGoodsClass(classIds, lstGoods)) break;
                    logger.info("\u8ba2\u5355\u786e\u8ba4\u5546\u54c1\u8fc7\u6ee4 \u5b50\u5206\u7c7bid\uff1a" + classIds);
                    continue block12;
                }
                case "3": {
                    if (!lstGoods.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId)) break;
                    continue block12;
                }
                case "5": {
                    boolean isMatchClass = OlstoreTicketHelper.isMatchGoodsClass(classIds, lstGoods);
                    boolean isMatchBrand = lstGoods.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"brand") == brandId);
                    if (isMatchClass && isMatchBrand) break;
                    continue block12;
                }
                default: {
                    continue block12;
                }
            }
            if (!OlstoreTicketHelper.isMatchSaleAttrOrInvType(saleAttrIds, invTypeIds, lstGoods)) continue;
            lstTickets.add(ticketId);
        }
        return lstTickets;
    }

    public static boolean isMatchSaleAttrOrInvType(List<Long> saleAttrIds, List<Long> invTypeIds, List<DynamicObject> lstGoods) {
        int cnt = 0;
        if (saleAttrIds != null && saleAttrIds.size() > 0) {
            for (Long saleAttrId : saleAttrIds) {
                if (!lstGoods.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"saleattr") == saleAttrId)) continue;
                ++cnt;
            }
            if (cnt == 0) {
                return false;
            }
        }
        cnt = 0;
        if (invTypeIds != null && invTypeIds.size() > 0) {
            for (Long invTypeId : invTypeIds) {
                if (!lstGoods.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"channelstocktypeid") == invTypeId)) continue;
                ++cnt;
            }
            return cnt <= 0;
        }
        return true;
    }

    public static boolean isMatchGoodsClass(Set<Object> classIds, List<DynamicObject> lstGoods) {
        int cnt = 0;
        if (classIds == null || classIds.size() == 0) {
            return false;
        }
        for (DynamicObject doGoods : lstGoods) {
            Long doGoodsClass = DynamicObjectUtils.getLong((DynamicObject)doGoods, (String)"goodsclass");
            logger.info("\u8ba2\u5355\u786e\u8ba4\u5546\u54c1\u8fc7\u6ee4 \u5206\u7c7bdoGoodsClass\uff1a" + doGoodsClass + ", classIds:" + classIds);
            if (doGoodsClass == null || !classIds.contains(doGoodsClass)) continue;
            ++cnt;
        }
        logger.info("\u8ba2\u5355\u786e\u8ba4\u5546\u54c1\u8fc7\u6ee4 \u5206\u7c7bcnt\uff1a" + cnt);
        return cnt != 0;
    }

    public static Long getInventoryTypeByTicket(long ticketId) {
        DynamicObject ticket = BusinessDataServiceHelper.loadSingle((Object)ticketId, (String)"ocdbd_ticketinfo");
        return ticket.getLong("tickettypeid.assigninvtype.id");
    }
}

