/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocbase.common.enums.ticket.DistributeScheme;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocpos.business.olstore.OlstoreStoreInfoHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OlstoreUtil;

public class OlstoreTicketProcessor {
    private static Log logger = LogFactory.getLog(OlstoreTicketProcessor.class);
    private static final String KEY_ISONLINESTORE = "isonlinestore";

    public JSONObject queryTicketInfoList(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"queryTicketInfoList", (Object[])new Object[]{jsonObject});
    }

    public JSONObject queryTicketInfoDetail(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"queryTicketInfoDetail", (Object[])new Object[]{jsonObject});
    }

    public JSONObject ticketInfoGift(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"ticketInfoGift", (Object[])new Object[]{jsonObject});
    }

    public JSONObject ticketInfoPay(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"ticketInfoPay", (Object[])new Object[]{jsonObject});
    }

    public JSONObject ticketInfoRefund(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"ticketInfoRefund", (Object[])new Object[]{jsonObject});
    }

    public List<JSONObject> getOlinvitationByStoreId(long storeId) {
        return (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdpm", (String)"OlinvitationService", (String)"getOlinvitationByStoreId", (Object[])new Object[]{storeId});
    }

    public JSONObject getOlinvitationById(long olinvitationId) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocdpm", (String)"OlinvitationService", (String)"getOlinvitationById", (Object[])new Object[]{olinvitationId});
    }

    public JSONObject distributeAndPublish(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"distributeAndPublish", (Object[])new Object[]{jsonObject});
    }

    public JSONObject buildTicketInfo(HashMap hashMap) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"buildTicketInfo", (Object[])new Object[]{hashMap});
    }

    public JSONObject publish(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketPublishService", (String)"publish", (Object[])new Object[]{jsonObject});
    }

    public DynamicObject[] queryFromOnlineInvitation(JSONObject jsonObject) {
        return (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketTypeService", (String)"queryFromOnlineInvitation", (Object[])new Object[]{jsonObject});
    }

    public DynamicObject[] queryTicketOrderList(JSONObject jsonObject) {
        return (DynamicObject[])DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketPublishService", (String)"queryList", (Object[])new Object[]{jsonObject});
    }

    public DynamicObject queryTicketOrderDetail(long id) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("id", (Object)id);
        return (DynamicObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketPublishService", (String)"queryDetail", (Object[])new Object[]{jsonObject});
    }

    public JSONObject recycleTicketOrder(JSONObject jsonObject) {
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketRecycleService", (String)"recycle", (Object[])new Object[]{jsonObject});
    }

    public JSONObject queryReceiveTicketList(long vipID, long branchId, int pageIndex, int pageSize) {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("vipid", (Object)vipID);
        jsonParam.put("branchId", (Object)branchId);
        jsonParam.put("schemecategory", (Object)DistributeScheme.ONLINE_ACTIVITY.getName());
        jsonParam.put("orderby", (Object)"audittime desc");
        jsonParam.put("pageindex", (Object)(pageIndex - 1));
        jsonParam.put("pagesize", (Object)pageSize);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketDistributeService", (String)"queryListFromOnLineStore", (Object[])new Object[]{jsonParam});
    }

    public JSONObject queryReceiveTicketDetail(long schemeID, long vipID) {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("vipid", (Object)vipID);
        jsonParam.put("id", (Object)schemeID);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketDistributeService", (String)"queryDetailFromOnLineStore", (Object[])new Object[]{jsonParam});
    }

    public JSONObject receiveTicket(long vipID, long schemeID, long branchId) {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("vipid", (Object)vipID);
        jsonParam.put("ticketdistributeid", (Object)schemeID);
        jsonParam.put("branchId", (Object)branchId);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketDistributeService", (String)"distribute", (Object[])new Object[]{jsonParam});
    }

    public JSONObject queryGiftListForTicket(long ticketId, long branchid, int pageIndex, int pageSize) {
        JSONObject jsonParam = new JSONObject();
        jsonParam.put("id", (Object)ticketId);
        jsonParam.put("branchid", (Object)branchid);
        jsonParam.put("pageindex", (Object)pageIndex);
        jsonParam.put("pagesize", (Object)pageSize);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"queryGiftListForTicket", (Object[])new Object[]{jsonParam});
    }

    public JSONObject activateByPosSaleOrder(long saleOrderId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("possaleorderid", (Object)saleOrderId);
        return (JSONObject)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"activateByPosSaleOrder", (Object[])new Object[]{jsonObject});
    }

    public Map<Object, DynamicObject> getTicketInfoByBranchId(long branchId, String ticketStatus, long memberId) {
        List<Long> ticketTypeIds = this.getTicketTypeIdByBranchId(branchId);
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_ticketinfo");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        QFilter qFilter = new QFilter("status", "=", (Object)"C");
        qFilter.and("enable", "=", (Object)"1");
        qFilter.and("ticketstatus", "=", (Object)ticketStatus);
        qFilter.and("vipid", "=", (Object)memberId);
        qFilter.and("cancelstatus", "=", (Object)"A");
        qFilter.and("tickettypeid.id", "in", ticketTypeIds);
        return BusinessDataServiceHelper.loadFromCache((String)"ocdbd_ticketinfo", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])qFilter.toArray());
    }

    private List<Long> getTicketTypeIdByBranchId(long branchId) {
        ArrayList<Long> ticketTypeIds = new ArrayList<Long>();
        this.getTicketTypeByAllBranchId(ticketTypeIds);
        this.getTicketTypeByAssignBranchId(ticketTypeIds, branchId);
        return ticketTypeIds.stream().distinct().collect(Collectors.toList());
    }

    private void getTicketTypeByAllBranchId(List<Long> ticketTypeIds) {
        QFilter filter = new QFilter("controlmethod", "=", (Object)"0");
        filter.and(KEY_ISONLINESTORE, "=", (Object)"1");
        DynamicObject[] ticketTypeEntity = BusinessDataServiceHelper.load((String)"ocdbd_ticketstype", (String)"id", (QFilter[])filter.toArray());
        Arrays.stream(ticketTypeEntity).forEach(x -> ticketTypeIds.add(x.getLong("id")));
    }

    private void getTicketTypeByPublishBranchId(List<Long> ticketTypeIds, long branchId) {
        QFilter filter = new QFilter("controlmethod", "=", (Object)"1");
        filter.and(KEY_ISONLINESTORE, "=", (Object)"1");
        DynamicObjectCollection ticketTypeEntity = QueryServiceHelper.query((String)"ocdbd_ticketstype", (String)"id", (QFilter[])filter.toArray(), (String)"");
        ticketTypeEntity.stream().forEach(x -> ticketTypeIds.add(x.getLong("id")));
    }

    private void getTicketTypeByAssignBranchId(List<Long> ticketTypeIds, long branchId) {
        QFilter filter = new QFilter("controlmethod", "=", (Object)"2");
        filter.and(KEY_ISONLINESTORE, "=", (Object)"1");
        String selectFields = String.join((CharSequence)",", "id", "treeentryentity.branch as branch", "treeentryentity.isapply as isapply");
        DynamicObjectCollection ticketTypeEntry = QueryServiceHelper.query((String)"ocdbd_ticketstype", (String)selectFields, (QFilter[])filter.toArray(), (String)"");
        Set ticketTypeIdSet = ticketTypeEntry.stream().filter(s -> branchId == DynamicObjectUtil.getLong((DynamicObject)s, (String)"branch") && DynamicObjectUtil.getBoolean((DynamicObject)s, (String)"isapply")).map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"id")).collect(Collectors.toSet());
        if (ticketTypeIdSet != null && ticketTypeIdSet.size() > 0) {
            ticketTypeIds.addAll(ticketTypeIdSet);
        }
    }

    public Boolean isHasOutstandingTicket(long schemeId, long vipID) {
        QFilter filter = new QFilter("ticketsdistributeid", "=", (Object)schemeId);
        filter.and("ticketstatus", "=", (Object)"P");
        filter.and("vipid", "=", (Object)vipID);
        return QueryServiceHelper.exists((String)"ocdbd_ticketinfo", (QFilter[])filter.toArray());
    }

    public long getTicketInfoIdByschemeId(long schemeId, long vipID) {
        QFilter filter = new QFilter("ticketsdistributeid", "=", (Object)schemeId);
        filter.and("ticketstatus", "=", (Object)"P");
        filter.and("vipid", "=", (Object)vipID);
        DynamicObject ticketInfo = QueryServiceHelper.queryOne((String)"ocdbd_ticketinfo", (String)"id,ticketsdistributeid", (QFilter[])filter.toArray());
        return DynamicObjectUtil.getLong((DynamicObject)ticketInfo, (String)"id");
    }

    public JSONObject afterTicketPaySuccess(JSONObject paramJson, DynamicObjectCollection ticketTypes) {
        logger.info("\u8ba4\u7b79\u9080\u7ea6\u652f\u4ed8 afterTicketPaySuccess paramJson :" + JSON.toJSONString((Object)paramJson));
        String outTradeNo = paramJson.getString("outTradeNo");
        String tradeNo = paramJson.getString("tradeNo");
        String totalrealamount = paramJson.getString("totalrealamount");
        Long payWayId = paramJson.getLong("payWay");
        Long storeId = paramJson.getLong("customerId");
        JSONObject result = new JSONObject();
        HashMap hashMap = this.buildTicketInfoParam(storeId, paramJson, ticketTypes);
        logger.info("\u5236\u5238OlstoreTicketHelper.buildTicketInfo\u53c2\u6570\uff1a" + hashMap);
        long start = System.currentTimeMillis();
        JSONObject jsonObject = OlstoreTicketHelper.buildTicketInfo(hashMap);
        logger.info("\u8ba4\u7b79\u9080\u7ea6\u4e0b\u5355\u8017\u65f6\u7edf\u8ba1  \u5236\u5238 OlstoreTicketHelper.buildTicketInfo consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        logger.info("\u5236\u5238OlstoreTicketHelper.buildTicketInfo ticketInfos\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)jsonObject));
        if (jsonObject.getBoolean("success").booleanValue()) {
            JSONArray ticketInfos = jsonObject.getJSONArray("data");
            JSONObject publicParam = this.buildPublicParam(paramJson, storeId, ticketInfos, totalrealamount);
            logger.info("\u521b\u5efa\u793c\u5238\u53d1\u552e\u5355OlstoreTicketHelper.buildPublicParam\u53c2\u6570\uff1a" + publicParam);
            start = System.currentTimeMillis();
            JSONObject ticketResult = OlstoreTicketHelper.publish(publicParam);
            logger.info("\u8ba4\u7b79\u9080\u7ea6\u4e0b\u5355\u8017\u65f6\u7edf\u8ba1  \u521b\u5efa\u53d1\u8d27\u5355 OlstoreTicketHelper.publish consumes " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            logger.info("\u521b\u5efa\u793c\u5238\u53d1\u552e\u5355OlstoreTicketHelper.publish\u7ed3\u679c\uff1a" + JSONObject.toJSONString((Object)ticketResult));
            if (ticketResult.get((Object)"code").toString().equals("success")) {
                String billId = ticketResult.getJSONArray("data").getJSONObject(0).getString("publishBillID");
                result.put("billId", (Object)billId);
                result.put("ticketInfoId", (Object)ticketInfos.getJSONObject(0).getString("id"));
            } else {
                logger.info("\u521b\u5efa\u793c\u5238\u53d1\u552e\u5355\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + ticketResult.getString("message"));
            }
        } else {
            logger.info("\u5236\u5238OlstoreTicketHelper.buildTicketInfo\u7ed3\u679c\u662f\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + jsonObject.get((Object)"message"));
        }
        return result;
    }

    private List<JSONObject> buildPaySuccessParam(String totalrealamount, String outTradeNo, String TradeNo, long storeId, DynamicObject payWay) {
        logger.info("\u751f\u6210\u8ba4\u7b79\u9080\u7ea6\u652f\u4ed8\u6d41\u6c34\u53c2\u6570, storeId\uff1a" + storeId);
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        if (StringUtil.isNotNull((String)outTradeNo)) {
            DynamicObject payWayType = BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
            JSONObject params = new JSONObject();
            params.put("amount", (Object)totalrealamount);
            params.put("payWay", (Object)payWay);
            params.put("orderNo", (Object)outTradeNo);
            params.put("payWayType", (Object)payWayType);
            params.put("bankExchangeNo", (Object)TradeNo);
            params.put("salebranchid", (Object)storeId);
            result.add(params);
        }
        return result;
    }

    private JSONObject buildPublicParam(JSONObject paramJson, long customerId, JSONArray ticketInfos, String totalrealamount) {
        ArrayList<JSONObject> ticketInfoList;
        Long olinvitationId = paramJson.getLong("olinvitationId");
        String suMemberId = paramJson.getString("suMemberId");
        long memberId = paramJson.getLong("memberId");
        String guideId = paramJson.getString("guideId");
        JSONObject object = new JSONObject();
        logger.info("buildPublicParam\u4ee3\u8ba4\u7b79suMemberId\uff1a" + suMemberId + ",guideId:" + guideId);
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{suMemberId})) {
            memberId = Long.parseLong(suMemberId);
            object.put("billtypeid", (Object)"1150528958178174976");
        } else {
            object.put("billtypeid", (Object)"1150524802763761664");
        }
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo(customerId);
        String orgId = storeInfo.getString("saleorg");
        logger.info("buildPublicParam olinvitationId:" + olinvitationId);
        object.put("org", (Object)orgId);
        object.put("localcurrencyid", (Object)1);
        object.put("settlecurrencyid", (Object)1);
        object.put("settleorgid", (Object)orgId);
        object.put("branchid", (Object)customerId);
        object.put("olinvitateid", (Object)olinvitationId);
        long sysUserId = OlstoreUtil.getOperatorSysUserByCustomerId((long)Long.parseLong(orgId), (long)customerId);
        object.put("salesmanid", (Object)guideId);
        object.put("creator", (Object)(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)guideId) ? Long.parseLong(guideId) : sysUserId));
        if (!CollectionUtils.isEmpty((Collection)ticketInfos)) {
            ticketInfoList = new ArrayList(ticketInfos.size());
            BigDecimal realsaleamount = new BigDecimal(totalrealamount).divide(new BigDecimal(ticketInfos.size()));
            for (int i = 0; i < ticketInfos.size(); ++i) {
                JSONObject ticketInfo = new JSONObject();
                ticketInfo.put("ticketid", (Object)ticketInfos.getJSONObject(i).getString("id"));
                ticketInfo.put("vipid", (Object)memberId);
                ticketInfo.put("realsaleamount", (Object)realsaleamount);
                ticketInfo.put("tickettypeid", (Object)ticketInfos.getJSONObject(i).getString("ticketTypeID"));
                ticketInfoList.add(ticketInfo);
            }
        } else {
            ticketInfoList = new ArrayList<JSONObject>();
        }
        object.put("ticketInfoList", ticketInfoList);
        ArrayList<JSONObject> payinfolist = new ArrayList<JSONObject>();
        JSONObject pay = new JSONObject();
        pay.put("payamount", (Object)new BigDecimal(totalrealamount));
        payinfolist.add(pay);
        object.put("payinfolist", payinfolist);
        return object;
    }

    private HashMap buildTicketInfoParam(long customerId, JSONObject paramJson, DynamicObjectCollection ticketTypes) {
        HashMap resultMap = new HashMap();
        Long olinvitationId = paramJson.getLong("olinvitationId");
        String suMemberId = paramJson.getString("suMemberId");
        long memberId = paramJson.getLong("memberId");
        logger.info("buildTicketInfoParam\u4ee3\u8ba4\u7b79suMemberId\uff1a" + suMemberId);
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{suMemberId})) {
            memberId = Long.parseLong(suMemberId);
        }
        DynamicObject storeInfo = OlstoreStoreInfoHelper.getStoreInfo(customerId);
        String orgId = storeInfo.getString("saleorg");
        for (DynamicObject ticketType : ticketTypes) {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("tickettypeid", ticketType.getLong("id"));
            hashMap.put("qty", ticketType.getInt("qty"));
            hashMap.put("ticketstatus", TicketStatusEnum.NO_MAKE.getName());
            hashMap.put("realsaleamount", ticketType.getBigDecimal("amount"));
            hashMap.put("vipid", memberId);
            hashMap.put("bizorgid", orgId);
            hashMap.put("comment", "\u7ebf\u4e0a\u95e8\u5e97-\u8ba4\u7b79\u9080\u7ea6");
            hashMap.put("olinvitateid", olinvitationId);
            resultMap.put("ticketinfo_" + ticketType.getString("id"), hashMap);
        }
        return resultMap;
    }
}

