/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.pojo.vo.member.user.AddressVO;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.olstore.AbstractOlStoreOperate;
import kd.occ.ocpos.business.olstore.IOlStoreOperate;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.business.olstore.OlstoreItemHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.common.olstore.NegativeSellResult;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.vo.OlStoreInventoryVO;

public class SelfPickUpCreateOrder
extends AbstractOlStoreOperate
implements IOlStoreOperate {
    @Override
    public Map<String, Object> execute(List<OlStoreInventoryVO> inventoryVoList) {
        HashMap<String, Object> itemAuxInvMap = new HashMap<String, Object>(inventoryVoList.size() + 1);
        long memberId = inventoryVoList.get(0).getMemberId();
        long branchId = inventoryVoList.get(0).getBranchId();
        DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)"ocdbd_channel", (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
        this.queryImmediateInvInBranch(itemAuxInvMap, inventoryVoList, saleOrgId, branchId);
        Map allItemInvMap = (Map)itemAuxInvMap.get("allItem");
        if (((Boolean)allItemInvMap.get("hasImmediateInvInBranch")).booleanValue()) {
            return itemAuxInvMap;
        }
        AddressVO defaultAddress = this.queryDefaultAddress(itemAuxInvMap, memberId);
        if (defaultAddress == null) {
            return itemAuxInvMap;
        }
        long districtId = defaultAddress.getDistrictId();
        this.queryStockByAddress(itemAuxInvMap, saleOrgId, branchId, inventoryVoList, districtId);
        if (!((Boolean)allItemInvMap.get("hasShareInvRule")).booleanValue()) {
            return itemAuxInvMap;
        }
        this.queryOverSaleInv(itemAuxInvMap, inventoryVoList, districtId);
        this.queryImmediateInvInWarehouse(itemAuxInvMap, saleOrgId, branchId, districtId, inventoryVoList);
        return itemAuxInvMap;
    }

    private void queryStockByAddress(HashMap<String, Object> itemAuxInvMap, long saleOrgId, long branchId, List<OlStoreInventoryVO> inventoryVoList, long districtId) {
        boolean hasShareInvRuleAllItem = true;
        for (OlStoreInventoryVO inventoryVO : inventoryVoList) {
            long itemId = inventoryVO.getItemId();
            long auxPtyId = inventoryVO.getAuxPtyId();
            List<JSONObject> jsonObjects = super.queryStockByAddress(saleOrgId, branchId, inventoryVO.getItemId(), districtId);
            HashMap invMap = (HashMap)itemAuxInvMap.get(itemId + "_" + auxPtyId);
            boolean hasShareInvRule = !CollectionUtils.isEmpty(jsonObjects);
            invMap.put("hasShareInvRule", hasShareInvRule);
            hasShareInvRuleAllItem = hasShareInvRuleAllItem && hasShareInvRule;
        }
        Map allItemInvMap = (Map)itemAuxInvMap.get("allItem");
        allItemInvMap.put("hasShareInvRule", hasShareInvRuleAllItem);
    }

    private void queryImmediateInvInWarehouse(HashMap<String, Object> itemAuxInvMap, long saleOrgId, long branchId, long districtId, List<OlStoreInventoryVO> inventoryVoList) {
        boolean hasImmediateInvInWarehouseAllItem = true;
        if (!CollectionUtils.isEmpty(inventoryVoList)) {
            for (OlStoreInventoryVO inventoryVO : inventoryVoList) {
                long itemId = inventoryVO.getItemId();
                long materialId = inventoryVO.getMaterialId();
                long unitId = inventoryVO.getUnitId();
                BigDecimal unitQty = inventoryVO.getUnitQty();
                long baseUnitId = inventoryVO.getBaseUnitId();
                BigDecimal baseUnitQty = inventoryVO.getBaseUnitQty();
                String itemName = inventoryVO.getItemName();
                long auxPtyId = inventoryVO.getAuxPtyId();
                List<JSONObject> stockJsonObjectList = super.queryStockByAddress(saleOrgId, branchId, itemId, districtId);
                boolean hasImmediateInvInWarehouse = super.queryImmediateInvInWarehouse(saleOrgId, branchId, itemId, materialId, unitId, unitQty, baseUnitId, baseUnitQty, auxPtyId, itemName, stockJsonObjectList);
                Map booleanMap = (Map)itemAuxInvMap.get(itemId + "_" + auxPtyId);
                booleanMap.put("hasImmediateInvInWarehouse", hasImmediateInvInWarehouse);
                hasImmediateInvInWarehouseAllItem = hasImmediateInvInWarehouseAllItem && hasImmediateInvInWarehouse;
            }
            Map allItemInvMap = (Map)itemAuxInvMap.get("allItem");
            allItemInvMap.put("hasImmediateInvInWarehouse", hasImmediateInvInWarehouseAllItem);
        }
    }

    private void queryOverSaleInv(HashMap<String, Object> itemAuxInvMap, List<OlStoreInventoryVO> inventoryVoList, long districtId) {
        boolean hasOverSaleInvAllItem = true;
        for (OlStoreInventoryVO inventoryVO : inventoryVoList) {
            long branchId = inventoryVO.getBranchId();
            long itemId = inventoryVO.getItemId();
            long materielId = inventoryVO.getMaterialId();
            long unitId = inventoryVO.getUnitId();
            BigDecimal unitQty = inventoryVO.getUnitQty();
            long baseUnitId = inventoryVO.getBaseUnitId();
            BigDecimal baseUnitQty = inventoryVO.getBaseUnitQty();
            long auxPtyId = inventoryVO.getAuxPtyId();
            Date deliveryTime = inventoryVO.getDeliveryTime();
            NegativeSellResult negativeSellResult = OlstoreInventoryHelper.queryNegativeSellInventory(branchId, itemId, districtId, deliveryTime, materielId, baseUnitId, unitId, baseUnitQty, unitQty);
            Map booleanMap = (Map)itemAuxInvMap.get(itemId + "_" + auxPtyId);
            booleanMap.put("hasOverSaleInv", negativeSellResult.getStatus());
            hasOverSaleInvAllItem = hasOverSaleInvAllItem && negativeSellResult.getStatus() != false;
        }
        Map allItemInvMap = (Map)itemAuxInvMap.get("allItem");
        allItemInvMap.put("hasOverSaleInv", hasOverSaleInvAllItem);
    }

    private AddressVO queryDefaultAddress(HashMap<String, Object> itemAuxInvMap, long memberId) {
        JSONObject jsonRes = OlstoreMemberHelper.queryDefaultAddressByUserId(memberId);
        if (((Boolean)jsonRes.get((Object)"success")).booleanValue()) {
            Map allItemInvMap = (Map)itemAuxInvMap.get("allItem");
            allItemInvMap.put("hasDefaultAddress", Boolean.TRUE);
            List addressList = (List)jsonRes.get((Object)"data");
            return (AddressVO)addressList.get(0);
        }
        Map allItemInvMap = (Map)itemAuxInvMap.get("allItem");
        allItemInvMap.put("hasDefaultAddress", Boolean.FALSE);
        return null;
    }

    private void queryImmediateInvInBranch(HashMap<String, Object> itemAuxInvMap, List<OlStoreInventoryVO> inventoryVoList, long saleOrgId, long branchId) {
        boolean hasImmediateInvInBranchAllItem = true;
        if (!CollectionUtils.isEmpty(inventoryVoList)) {
            for (OlStoreInventoryVO inventoryVO : inventoryVoList) {
                HashMap<String, Object> invMap = new HashMap<String, Object>(16);
                boolean hasImmediateInvInBranch = super.queryImmediateInvInBranch(saleOrgId, branchId, inventoryVO.getItemId(), inventoryVO.getMaterialId(), inventoryVO.getUnitId(), inventoryVO.getUnitQty(), inventoryVO.getBaseUnitId(), inventoryVO.getBaseUnitQty(), inventoryVO.getAuxPtyId(), inventoryVO.getItemName());
                invMap.put("itemName", inventoryVO.getItemName());
                invMap.put("hasImmediateInvInBranch", hasImmediateInvInBranch);
                itemAuxInvMap.put(inventoryVO.getItemId() + "_" + inventoryVO.getAuxPtyId(), invMap);
                hasImmediateInvInBranchAllItem = hasImmediateInvInBranchAllItem && hasImmediateInvInBranch;
            }
            HashMap<String, Boolean> allItemInvMap = new HashMap<String, Boolean>(16);
            allItemInvMap.put("hasImmediateInvInBranch", hasImmediateInvInBranchAllItem);
            itemAuxInvMap.put("allItem", allItemInvMap);
        }
    }

    private JSONObject getItemInfo(String itemId, String auxptyId, long customerId) {
        String appendStr = OlstoreUtil.buildItemParamAppendStr();
        JSONObject returnData = OlstoreItemHelper.getItemDetail(String.valueOf(customerId), "0", itemId, appendStr);
        if (returnData.get((Object)"code").toString() == "0000" && returnData.getJSONArray("data").size() > 0) {
            JSONArray products = returnData.getJSONArray("data");
            if (products.size() == 1) {
                return products.getJSONObject(0);
            }
            if (products.size() > 1) {
                List list = JSONObject.parseArray((String)products.toJSONString(), JSONObject.class);
                JSONObject itemInfo = list.stream().filter(p -> p.getString("itemid").equals(itemId) && p.getString("auxptyid").equals(auxptyId)).findFirst().orElse(null);
                return itemInfo;
            }
        }
        return null;
    }
}

