/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.olstore;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.pojo.vo.member.user.AddressVO;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.olstore.AbstractOlStoreOperate;
import kd.occ.ocpos.business.olstore.IOlStoreOperate;
import kd.occ.ocpos.business.olstore.OlstoreInventoryHelper;
import kd.occ.ocpos.common.olstore.NegativeSellResult;
import kd.occ.ocpos.common.vo.OlStoreInventoryVO;

public class SelfPickUpSelectProperty
extends AbstractOlStoreOperate
implements IOlStoreOperate {
    @Override
    public Map<String, Object> execute(List<OlStoreInventoryVO> inventoryVoList) {
        HashMap<String, Object> resMap = new HashMap<String, Object>(16);
        OlStoreInventoryVO inventoryVO = inventoryVoList.get(0);
        long branchId = inventoryVO.getBranchId();
        long itemId = inventoryVO.getItemId();
        long materielId = inventoryVO.getMaterialId();
        long unitId = inventoryVO.getUnitId();
        BigDecimal unitQty = inventoryVO.getUnitQty();
        long baseUnitId = inventoryVO.getBaseUnitId();
        BigDecimal baseUnitQty = inventoryVO.getBaseUnitQty();
        long auxPtyId = inventoryVO.getAuxPtyId();
        String itemName = inventoryVO.getItemName();
        long memberId = inventoryVO.getMemberId();
        Date deliveryTime = inventoryVO.getDeliveryTime();
        DynamicObject branchDyn = BusinessDataServiceHelper.loadSingle((Object)branchId, (String)"ocdbd_channel", (String)"saleorg");
        long saleOrgId = DynamicObjectUtils.getPkValue((DynamicObject)branchDyn, (String)"saleorg");
        boolean hasImmediateInvInBranch = this.queryImmediateInvInBranch(saleOrgId, branchId, itemId, materielId, unitId, unitQty, unitId, baseUnitQty, auxPtyId, itemName);
        if (hasImmediateInvInBranch) {
            resMap.put("hasImmediateInvInBranch", Boolean.TRUE);
            return resMap;
        }
        AddressVO defaultAddress = this.queryDefaultAddress(memberId);
        if (defaultAddress == null) {
            resMap.put("hasImmediateInvInBranch", Boolean.FALSE);
            resMap.put("hasDefaultAddress", Boolean.FALSE);
            return resMap;
        }
        long districtId = defaultAddress.getDistrictId();
        List<JSONObject> stockJsonObjectList = this.queryStockByAddress(saleOrgId, branchId, itemId, districtId);
        if (CollectionUtils.isEmpty(stockJsonObjectList)) {
            resMap.put("hasImmediateInvInBranch", Boolean.FALSE);
            resMap.put("hasDefaultAddress", Boolean.TRUE);
            resMap.put("hasShareInvRule", Boolean.FALSE);
            return resMap;
        }
        NegativeSellResult negativeSellResult = OlstoreInventoryHelper.queryNegativeSellInventory(branchId, itemId, districtId, deliveryTime, materielId, baseUnitId, unitId, baseUnitQty, unitQty);
        boolean hasOverSaleInv = negativeSellResult.getStatus();
        if (hasOverSaleInv) {
            resMap.put("hasImmediateInvInBranch", Boolean.FALSE);
            resMap.put("hasDefaultAddress", Boolean.TRUE);
            resMap.put("hasShareInvRule", Boolean.TRUE);
            resMap.put("hasOverSaleInv", Boolean.TRUE);
            return resMap;
        }
        boolean hasImmediateInvInWarehouse = this.queryImmediateInvInWarehouse(saleOrgId, branchId, itemId, materielId, unitId, unitQty, unitId, baseUnitQty, auxPtyId, itemName, stockJsonObjectList);
        resMap.put("hasImmediateInvInBranch", Boolean.FALSE);
        resMap.put("hasDefaultAddress", Boolean.TRUE);
        resMap.put("hasShareInvRule", Boolean.TRUE);
        resMap.put("hasOverSaleInv", Boolean.FALSE);
        resMap.put("hasImmediateInvInWarehouse", hasImmediateInvInWarehouse);
        return resMap;
    }
}

