/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.enums.TimeScopeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocbase.common.util.MultiBaseDataUtil;
import kd.occ.ocpos.business.promotion.MaterialConditionHelper;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.common.entity.MaterialEntity;
import kd.occ.ocpos.common.entity.MemberEntity;
import kd.occ.ocpos.common.entity.PlanEntity;
import kd.occ.ocpos.common.entity.StoreEntity;
import kd.occ.ocpos.common.entity.TimeScopeEntity;
import kd.occ.ocpos.common.entity.UnMatchPlansEntity;
import kd.occ.ocpos.common.entity.request.CxRequestEntity;
import kd.occ.ocpos.common.entity.request.CxResultEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleGiftResultEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleGroupResultEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleResultEntity;
import kd.occ.ocpos.common.entity.request.ResMaterialEntryEntity;
import kd.occ.ocpos.common.entity.request.ResMultiPromotionEntity;
import kd.occ.ocpos.common.entity.request.ResPromotionDetailEntity;
import kd.occ.ocpos.common.entity.request.ResPromotionEntity;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.promotion.ApplyMaterialScopeEnum;
import kd.occ.ocpos.common.enums.promotion.ApplyMemberScopeEnum;
import kd.occ.ocpos.common.enums.promotion.MaterialTypeEnum;
import kd.occ.ocpos.common.enums.promotion.MemberFilterTypeEnum;
import kd.occ.ocpos.common.enums.promotion.SchemeTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.promotion.LoggerInfo;

public class BuildParamHelper {
    public static ApplyMemberScopeEnum buildApplyMember(int applyMember) {
        switch (applyMember) {
            case 2: {
                return ApplyMemberScopeEnum.NonMember;
            }
            case 3: {
                return ApplyMemberScopeEnum.SpecificMember;
            }
            case 4: {
                return ApplyMemberScopeEnum.BirthdayMember;
            }
        }
        return ApplyMemberScopeEnum.AllMember;
    }

    public static UnMatchPlansEntity buildUnMatch(PlanEntity plan, String msg) {
        return new UnMatchPlansEntity(plan.getId(), plan.getName(), plan.getTypeName(), plan.getTypeId(), plan.getBillNo(), msg);
    }

    public static ApplyMaterialScopeEnum buildMaterialSelect(Integer materialSelect) {
        switch (materialSelect) {
            case 2: {
                return ApplyMaterialScopeEnum.SpecificMaterial;
            }
        }
        return ApplyMaterialScopeEnum.AllMaterial;
    }

    public static MaterialTypeEnum buildMaterialType(Integer materialType) {
        switch (materialType) {
            case 1: {
                return MaterialTypeEnum.Material;
            }
            case 2: {
                return MaterialTypeEnum.MaterialCategory;
            }
            case 3: {
                return MaterialTypeEnum.MaterialBrand;
            }
            case 4: {
                return MaterialTypeEnum.MaterialLabel;
            }
        }
        return MaterialTypeEnum.MaterialUnit;
    }

    public static List<PlanEntity> buildPlanEntity(DynamicObject[] promotionList) {
        ArrayList<PlanEntity> planList = new ArrayList<PlanEntity>(0);
        for (DynamicObject promotion : promotionList) {
            DynamicObject promotionRule = BuildParamHelper.selectPromoteRule(promotion.getString("id"));
            if (promotionRule == null) continue;
            DynamicObject promotionType = promotion.getDynamicObject("promotetypeid");
            PlanEntity plan = new PlanEntity();
            plan.setDbid(promotion.getDynamicObject("org").getString("id"));
            plan.setId(promotion.getString("id"));
            plan.setName(promotion.getString("promotetheme"));
            plan.setActname(promotion.getDynamicObject("promotionsid").getString("name"));
            if (promotionType != null) {
                plan.setTypeId(promotionType.getString("id"));
                plan.setTypeName(promotionType.getString("number"));
                plan.setPriority(promotionType.getString("prioritylever"));
            }
            plan.setBillNo(promotion.getString("billno"));
            plan.setStartdate(promotion.getString("startdate"));
            plan.setEnddate(promotion.getString("enddate"));
            plan.setApplyMaterialScope(BuildParamHelper.buildMaterialSelect(promotion.getInt("itemselected")));
            plan.setApplyShopType(promotion.getString("controlmethod"));
            plan.setApplyMemberType(BuildParamHelper.buildApplyMember(promotion.getInt("membergroup")));
            plan.setApplyDateType(promotion.getInt("suitabledate"));
            plan.setMatchChangePrice(promotion.getBoolean("ismanualpromote"));
            plan.setApplyTimeRange(promotion.getInt("timerange"));
            plan.setEffectiveTime(promotion.getLong("effecttime"));
            plan.setExpirationTime(promotion.getLong("invalidtime"));
            plan.setMaterialEntityList(BuildParamHelper.buildMaterialEntityList(promotion));
            plan.setBindMaterialMap(BuildParamHelper.buildBindMaterialMap(promotion));
            plan.setExceptMaterialEntityList(BuildParamHelper.buildExceptMaterialEntityList(promotion));
            plan.setStoreEntityList(BuildParamHelper.buildStoreEntityList(promotion));
            plan.setMemberEntityList(BuildParamHelper.buildMemberEntityList(promotion));
            plan.setTimeScopeList(BuildParamHelper.buildTimeScopeEntityList(promotion));
            plan.setItemRange(Math.max(promotionRule.getInt("itemgroup"), 0));
            if (PromotionEnum.amountPromotion().contains(plan.getTypeName())) {
                plan.setPromotionWay(1);
            } else if (PromotionEnum.qtyPromotion().contains(plan.getTypeName())) {
                plan.setPromotionWay(2);
            } else if (PromotionEnum.bindPromotion().contains(plan.getTypeName())) {
                plan.setPromotionWay(3);
            } else {
                plan.setPromotionWay(0);
            }
            planList.add(plan);
        }
        return planList;
    }

    public static List<MaterialEntity> buildMaterialEntityList(DynamicObject promotion) {
        ArrayList<MaterialEntity> materialEntityList = new ArrayList<MaterialEntity>();
        DynamicObjectCollection materialEntities = promotion.getDynamicObjectCollection("itemlistentry");
        DynamicObject[] promotionRuleList = BuildParamHelper.selectPromoteRuleList(promotion.getString("id"));
        int i = 0;
        DynamicObject promotionType = promotion.getDynamicObject("promotetypeid");
        ArrayList<String> promotionMaterialIdList = new ArrayList<String>();
        if (PromotionEnum.bindPromotion().contains(promotionType.getString("number"))) {
            for (DynamicObject promotionRule : promotionRuleList) {
                MaterialEntity materialEntity;
                DynamicObject itemBrand;
                DynamicObject itemClass;
                DynamicObject good;
                DynamicObjectCollection promoteRuleItemList;
                if (promotionRule.getInt("itemgroup") == 3) {
                    promoteRuleItemList = promotionRule.getDynamicObjectCollection("giftitementry");
                    for (DynamicObject promoteRuleItem : promoteRuleItemList) {
                        good = promoteRuleItem.getDynamicObject("gitemid");
                        itemClass = promoteRuleItem.getDynamicObject("gitemclassid");
                        itemBrand = promoteRuleItem.getDynamicObject("gbrandid");
                        materialEntity = new MaterialEntity();
                        materialEntity.setId(i);
                        materialEntity.setPlanId(promotion.getString("id"));
                        materialEntity.setType(BuildParamHelper.buildMaterialType(promoteRuleItem.getInt("gtype")));
                        materialEntity.setObjectId(good != null ? good.getString("id") : null);
                        materialEntity.setMaterialClassId(itemClass != null ? itemClass.getString("id") : null);
                        materialEntity.setMaterialBrandId(itemBrand != null ? itemBrand.getString("id") : null);
                        materialEntity.setMaterialName(good != null ? good.getString("name") : null);
                        materialEntityList.add(materialEntity);
                        ++i;
                    }
                    continue;
                }
                promoteRuleItemList = promotionRule.getDynamicObjectCollection("itementry");
                for (DynamicObject promoteRuleItem : promoteRuleItemList) {
                    good = promoteRuleItem.getDynamicObject("itemid");
                    itemClass = promoteRuleItem.getDynamicObject("itemclassid");
                    itemBrand = promoteRuleItem.getDynamicObject("brandid");
                    materialEntity = new MaterialEntity();
                    materialEntity.setId(i);
                    materialEntity.setPlanId(promotion.getString("id"));
                    materialEntity.setType(BuildParamHelper.buildMaterialType(promoteRuleItem.getInt("type")));
                    materialEntity.setObjectId(good != null ? good.getString("id") : null);
                    materialEntity.setMaterialClassId(itemClass != null ? itemClass.getString("id") : null);
                    materialEntity.setMaterialBrandId(itemBrand != null ? itemBrand.getString("id") : null);
                    materialEntity.setMaterialName(good != null ? good.getString("name") : null);
                    materialEntity.setMaterialField(good != null ? good.getString("modelnum") : null);
                    materialEntityList.add(materialEntity);
                    ++i;
                }
            }
        } else if (PromotionEnum.singleNumPromotion().contains(promotionType.getString("number"))) {
            for (DynamicObject promotionRule : promotionRuleList) {
                DynamicObjectCollection promoteRuleItemList = promotionRule.getDynamicObjectCollection("itementry");
                for (DynamicObject promoteRuleItem : promoteRuleItemList) {
                    DynamicObject good = promoteRuleItem.getDynamicObject("itemid");
                    DynamicObject itemClass = promoteRuleItem.getDynamicObject("itemclassid");
                    DynamicObject itemBrand = promoteRuleItem.getDynamicObject("brandid");
                    MaterialEntity materialEntity = new MaterialEntity();
                    materialEntity.setId(i);
                    materialEntity.setPlanId(promotion.getString("id"));
                    materialEntity.setType(BuildParamHelper.buildMaterialType(promoteRuleItem.getInt("type")));
                    materialEntity.setObjectId(good != null ? good.getString("id") : null);
                    materialEntity.setMaterialClassId(itemClass != null ? itemClass.getString("id") : null);
                    materialEntity.setMaterialBrandId(itemBrand != null ? itemBrand.getString("id") : null);
                    materialEntity.setMaterialName(good != null ? good.getString("name") : null);
                    materialEntity.setQty(promoteRuleItem.getInt("qty"));
                    if (DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)promoteRuleItem, (String)"saleattr").size() > 0) {
                        materialEntity.setSaleAttr(MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)promoteRuleItem, (String)"saleattr")));
                    }
                    if (DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)promoteRuleItem, (String)"invtype").size() > 0) {
                        materialEntity.setInventoryType(MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)promoteRuleItem, (String)"invtype")));
                    }
                    if (StringUtils.isNotEmpty((CharSequence)materialEntity.getObjectId()) && promotionMaterialIdList.contains(materialEntity.getObjectId())) continue;
                    promotionMaterialIdList.add(materialEntity.getObjectId());
                    materialEntityList.add(materialEntity);
                    ++i;
                }
            }
        } else {
            for (DynamicObject material : materialEntities) {
                DynamicObject good = material.getDynamicObject("itemid");
                DynamicObject itemClass = material.getDynamicObject("itemclassid");
                DynamicObject itemBrand = material.getDynamicObject("brandid");
                DynamicObject itemLabel = material.getDynamicObject("itemlabelid");
                DynamicObject barcode = material.getDynamicObject("barcodeid");
                DynamicObject unit = material.getDynamicObject("unitid");
                MaterialEntity materialEntity = new MaterialEntity();
                materialEntity.setId(i);
                materialEntity.setPlanId(promotion.getString("id"));
                materialEntity.setType(BuildParamHelper.buildMaterialType(material.getInt("type")));
                materialEntity.setObjectId(good != null ? good.getString("id") : null);
                materialEntity.setMaterialUnitId(unit != null ? unit.getString("id") : null);
                materialEntity.setMaterialName(good != null ? good.getString("name") : null);
                materialEntity.setMaterialClassId(itemClass != null ? itemClass.getString("id") : null);
                materialEntity.setMaterialBrandId(itemBrand != null ? itemBrand.getString("id") : null);
                materialEntity.setMaterialLabelId(itemLabel != null ? itemLabel.getString("id") : null);
                materialEntity.setMaterialBarcodeId(barcode != null ? barcode.getString("id") : null);
                materialEntity.setExcept(material.getBoolean("isdropout"));
                materialEntity.setAuxId(StringUtils.isEmpty((CharSequence)material.getString("assistattid")) ? "0" : material.getString("assistattid"));
                materialEntity.setQty(material.getInt("qty"));
                materialEntity.setPrice(material.getBigDecimal("itemprice"));
                materialEntity.setPromotionPrice(material.getBigDecimal("promoteprice"));
                materialEntity.setPromotionAmount(material.getBigDecimal("quotaamount"));
                materialEntity.setMaterialField(good != null ? good.getString("modelnum") : null);
                materialEntity.setDiscount(material.getBigDecimal("discount"));
                if (DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)material, (String)"saleattr").size() > 0) {
                    materialEntity.setSaleAttr(MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)material, (String)"saleattr")));
                }
                if (DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)material, (String)"invtype").size() > 0) {
                    materialEntity.setInventoryType(MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)material, (String)"invtype")));
                }
                materialEntityList.add(materialEntity);
                ++i;
            }
        }
        return materialEntityList;
    }

    public static List<MaterialEntity> buildExceptMaterialEntityList(DynamicObject promotion) {
        ArrayList<MaterialEntity> exceptMaterialEntityList = new ArrayList<MaterialEntity>();
        DynamicObjectCollection exceptItemList = promotion.getDynamicObjectCollection("exitemlistentry");
        int i = 0;
        for (DynamicObject exceptItem : exceptItemList) {
            DynamicObject good = exceptItem.getDynamicObject("exitemid");
            DynamicObject itemClass = exceptItem.getDynamicObject("exitemclassid");
            DynamicObject itemBrand = exceptItem.getDynamicObject("exbrandid");
            DynamicObject itemLabel = exceptItem.getDynamicObject("exitemlabelid");
            DynamicObject barcode = exceptItem.getDynamicObject("exbarcodeid");
            DynamicObject unit = exceptItem.getDynamicObject("exunitid");
            DynamicObjectCollection exinvTypeList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)exceptItem, (String)"exinvtype");
            DynamicObjectCollection exsaleAttrList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)exceptItem, (String)"exsaleattr");
            MaterialEntity materialEntity = new MaterialEntity();
            materialEntity.setId(i);
            materialEntity.setPlanId(promotion.getString("id"));
            materialEntity.setType(BuildParamHelper.buildMaterialType(exceptItem.getInt("extype")));
            materialEntity.setObjectId(good != null ? good.getString("id") : null);
            materialEntity.setMaterialUnitId(unit != null ? unit.getString("id") : null);
            materialEntity.setMaterialName(good != null ? good.getString("name") : null);
            materialEntity.setMaterialClassId(itemClass != null ? itemClass.getString("id") : null);
            materialEntity.setMaterialBrandId(itemBrand != null ? itemBrand.getString("id") : null);
            materialEntity.setMaterialLabelId(itemLabel != null ? itemLabel.getString("id") : null);
            materialEntity.setMaterialBarcodeId(barcode != null ? barcode.getString("id") : null);
            materialEntity.setInventoryType(MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)exinvTypeList));
            materialEntity.setSaleAttr(MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)exsaleAttrList));
            exceptMaterialEntityList.add(materialEntity);
            ++i;
        }
        return exceptMaterialEntityList;
    }

    public static Map<String, List<MaterialEntity>> buildBindMaterialMap(DynamicObject promotion) {
        HashMap<String, List<MaterialEntity>> materialEntityMap = new HashMap<String, List<MaterialEntity>>();
        int i = 0;
        DynamicObject promotionType = promotion.getDynamicObject("promotetypeid");
        if (PromotionEnum.bindPromotion().contains(promotionType.getString("number"))) {
            DynamicObject[] promotionRuleList;
            for (DynamicObject promotionRule : promotionRuleList = BuildParamHelper.selectPromoteRuleList(promotion.getString("id"))) {
                MaterialEntity materialEntity;
                DynamicObject itemBrand;
                DynamicObject itemClass;
                DynamicObject good;
                DynamicObjectCollection promoteRuleItemList;
                ArrayList<MaterialEntity> materialEntityList = new ArrayList<MaterialEntity>();
                if (promotionRule.getInt("itemgroup") == 3) {
                    promoteRuleItemList = promotionRule.getDynamicObjectCollection("giftitementry");
                    for (DynamicObject promoteRuleItem : promoteRuleItemList) {
                        good = promoteRuleItem.getDynamicObject("gitemid");
                        itemClass = promoteRuleItem.getDynamicObject("gitemclassid");
                        itemBrand = promoteRuleItem.getDynamicObject("gbrandid");
                        materialEntity = new MaterialEntity();
                        materialEntity.setId(i);
                        materialEntity.setPlanId(promotion.getString("id"));
                        materialEntity.setType(BuildParamHelper.buildMaterialType(promoteRuleItem.getInt("gtype")));
                        materialEntity.setObjectId(good != null ? good.getString("id") : null);
                        materialEntity.setMaterialClassId(itemClass != null ? itemClass.getString("id") : null);
                        materialEntity.setMaterialBrandId(itemBrand != null ? itemBrand.getString("id") : null);
                        materialEntity.setMaterialName(good != null ? good.getString("name") : null);
                        materialEntityList.add(materialEntity);
                        ++i;
                    }
                } else {
                    promoteRuleItemList = promotionRule.getDynamicObjectCollection("itementry");
                    for (DynamicObject promoteRuleItem : promoteRuleItemList) {
                        good = promoteRuleItem.getDynamicObject("itemid");
                        itemClass = promoteRuleItem.getDynamicObject("itemclassid");
                        itemBrand = promoteRuleItem.getDynamicObject("brandid");
                        materialEntity = new MaterialEntity();
                        materialEntity.setId(i);
                        materialEntity.setPlanId(promotion.getString("id"));
                        materialEntity.setType(BuildParamHelper.buildMaterialType(promoteRuleItem.getInt("type")));
                        materialEntity.setObjectId(good != null ? good.getString("id") : null);
                        materialEntity.setMaterialClassId(itemClass != null ? itemClass.getString("id") : null);
                        materialEntity.setMaterialBrandId(itemBrand != null ? itemBrand.getString("id") : null);
                        materialEntity.setMaterialName(good != null ? good.getString("name") : null);
                        materialEntity.setMaterialField(good != null ? good.getString("modelnum") : null);
                        materialEntityList.add(materialEntity);
                        ++i;
                    }
                }
                materialEntityMap.put(promotionRule.getString("id"), materialEntityList);
            }
        }
        return materialEntityMap;
    }

    public static List<StoreEntity> buildStoreEntityList(DynamicObject promotion) {
        ArrayList<StoreEntity> storeEntityList = new ArrayList<StoreEntity>();
        DynamicObjectCollection storeEntities = promotion.getDynamicObjectCollection("branchreeentryentity");
        for (DynamicObject store : storeEntities) {
            StoreEntity storeEntity = new StoreEntity();
            DynamicObject org = store.getDynamicObject("applyorgid");
            DynamicObject branch = store.getDynamicObject("branchid");
            storeEntity.setId(store.getString("id"));
            storeEntity.setOrgId(org != null ? org.getString("id") : null);
            storeEntity.setPlanId(promotion.getString("id"));
            storeEntity.setStoreId(branch != null ? branch.getString("id") : null);
            storeEntity.setExecuted(store.getBoolean("isexecute"));
            storeEntityList.add(storeEntity);
        }
        return storeEntityList;
    }

    public static List<MemberEntity> buildMemberEntityList(DynamicObject promotion) {
        ArrayList<MemberEntity> memberEntityList = new ArrayList<MemberEntity>();
        DynamicObjectCollection memberEntities = promotion.getDynamicObjectCollection("memberentryentity");
        for (DynamicObject member : memberEntities) {
            MemberEntity memberEntity = new MemberEntity();
            DynamicObject type = member.getDynamicObject("typeid");
            memberEntity.setType(BuildParamHelper.buildMemberScope(promotion, type, member, memberEntity));
            memberEntity.setPlanId(promotion.getString("id"));
            memberEntityList.add(memberEntity);
        }
        return memberEntityList;
    }

    public static List<TimeScopeEntity> buildTimeScopeEntityList(DynamicObject promotion) {
        ArrayList<TimeScopeEntity> timeScopeEntityList = new ArrayList<TimeScopeEntity>();
        DynamicObjectCollection dateEntityEntry = promotion.getDynamicObjectCollection("dateentryentity");
        for (DynamicObject dateEntity : dateEntityEntry) {
            TimeScopeEntity timeScopeEntity = new TimeScopeEntity();
            timeScopeEntity.setPlanId(promotion.getString("id"));
            timeScopeEntity.setDateText(dateEntity.getString("datetext"));
            timeScopeEntity.setTimeScopeEnum(BuildParamHelper.buildTimeScopeEnum(dateEntity.getString("datetype")));
            timeScopeEntityList.add(timeScopeEntity);
        }
        return timeScopeEntityList;
    }

    public static TimeScopeEnum buildTimeScopeEnum(String dataType) {
        switch (dataType) {
            case "1": {
                return TimeScopeEnum.ONLY_WEEK;
            }
            case "2": {
                return TimeScopeEnum.WEEK;
            }
            case "3": {
                return TimeScopeEnum.TIME_ZONE;
            }
            case "4": {
                return TimeScopeEnum.MONTH_DAY;
            }
        }
        return null;
    }

    public static MemberFilterTypeEnum buildMemberScope(DynamicObject promotion, DynamicObject type, DynamicObject member, MemberEntity memberEntity) {
        if (type != null) {
            String typeId;
            switch (typeId = type.getString("id")) {
                case "ocdbd_user": {
                    memberEntity.setMember(member.getDynamicObject("memberid"));
                    memberEntity.setMemberId(member.getDynamicObject("memberid").getString("id"));
                    return MemberFilterTypeEnum.Member;
                }
                case "ocdbd_vip_level": {
                    memberEntity.setMemberLevel(member.getDynamicObject("typeid"));
                    memberEntity.setMemberId(member.getString("vipleverid_id"));
                    return MemberFilterTypeEnum.MemberLevel;
                }
                case "ocdbd_member_label": {
                    memberEntity.setMemberLabel(member.getDynamicObject("typeid"));
                    memberEntity.setMemberId(member.getString("memberlabelid_id"));
                    return MemberFilterTypeEnum.MemberLabel;
                }
            }
            LoggerInfo.info((String)"\u6d3b\u52a8\u9002\u7528\u4f1a\u5458\u7c7b\u578b\u9519\u8bef", (String[])new String[]{promotion.getString("promotetheme")});
        }
        return null;
    }

    public static List<ResMultiPromotionEntity> buildPromotionResult(List<PlanEntity> plans) {
        ArrayList<ResMultiPromotionEntity> resPromotionList = new ArrayList<ResMultiPromotionEntity>(0);
        if (plans.size() == 0) {
            return resPromotionList;
        }
        for (PlanEntity plan : plans) {
            SchemeTypeEnum schemeTypeEnum = SchemeTypeEnum.SchemeSingle;
            ResMultiPromotionEntity promotionEntity = new ResMultiPromotionEntity();
            BigDecimal totalDiscountAmount = BuildParamHelper.buildTotalDiscountAmount(plan.getMaterialEntityList());
            List<ResMaterialEntryEntity> resMaterialEntryEntityList = BuildParamHelper.buildResMaterialEntryList(plan.getMaterialEntityList());
            if (PromotionEnum.wholePromotion().contains(plan.getTypeName())) {
                schemeTypeEnum = SchemeTypeEnum.SchemeWhole;
            }
            ResPromotionDetailEntity promotionDetailEntity = new ResPromotionDetailEntity(totalDiscountAmount, resMaterialEntryEntityList, null, null);
            ResPromotionEntity resPromotionEntity = new ResPromotionEntity(plan.getId(), plan.getName(), plan.getTypeName(), plan.getTypeId(), plan.getBillNo(), plan.getStartdate(), plan.getEnddate(), plan.getPromoteRuleId(), schemeTypeEnum, promotionDetailEntity);
            promotionEntity.setCombine(true);
            promotionEntity.setResPromotion(resPromotionEntity);
            promotionEntity.setPromotions(Collections.singletonList(resPromotionEntity));
            resPromotionList.add(promotionEntity);
        }
        return resPromotionList;
    }

    public static BigDecimal buildTotalDiscountAmount(List<MaterialEntity> materialEntityList) {
        BigDecimal totalDiscountAmount = BigDecimal.ZERO;
        for (MaterialEntity materialEntity : materialEntityList) {
            totalDiscountAmount = totalDiscountAmount.add(materialEntity.getPromotionPrice() != null ? materialEntity.getPromotionPrice() : BigDecimal.ZERO);
        }
        return totalDiscountAmount;
    }

    public static List<ResMaterialEntryEntity> buildResMaterialEntryList(List<MaterialEntity> materialEntityList) {
        ArrayList<ResMaterialEntryEntity> resMaterialEntryEntityList = new ArrayList<ResMaterialEntryEntity>(0);
        for (MaterialEntity materialEntity : materialEntityList) {
            ResMaterialEntryEntity resMaterialEntryEntity = new ResMaterialEntryEntity(materialEntity.getId(), materialEntity.getObjectId(), new BigDecimal(materialEntity.getQty()), materialEntity.getPromotionAmount(), materialEntity.getPromotionPrice(), materialEntity.getDiscount(), BigDecimal.ZERO, BigDecimal.ZERO);
            resMaterialEntryEntityList.add(resMaterialEntryEntity);
        }
        return resMaterialEntryEntityList;
    }

    public static void buildSaleOrderPromotion(ResPromotionEntity resPromotionEntity, DynamicObjectCollection saleOrderPromotionList, Map<String, Integer> promotionIdMap) {
        String resPromotionId = resPromotionEntity.getId();
        DynamicObject ocdpmPromote = BusinessDataServiceHelper.loadSingle((Object)resPromotionId, (String)"ocdpm_promote");
        if (ocdpmPromote == null) {
            return;
        }
        if (!promotionIdMap.containsKey(resPromotionId)) {
            DynamicObject promotionRule = BuildParamHelper.selectPromoteRule(resPromotionId);
            DynamicObject saleOrderPromotion = saleOrderPromotionList.addNew();
            DynamicObject promotionType = ocdpmPromote.getDynamicObject("promotetypeid");
            DynamicObject promotionAction = ocdpmPromote.getDynamicObject("promotionsid");
            saleOrderPromotion.set("promotiongoodseq", (Object)BuildParamHelper.buildFilterGoodSeq(resPromotionEntity.getResPromotionDetail().getMaterialEntries()));
            saleOrderPromotion.set("promotionid", (Object)resPromotionId);
            saleOrderPromotion.set("promotiontype", (Object)promotionType);
            saleOrderPromotion.set("promotionaction", (Object)promotionAction);
            saleOrderPromotion.set("priority", promotionType != null ? Integer.valueOf(promotionType.getInt("prioritylever")) : null);
            saleOrderPromotion.set("promotionname", (Object)ocdpmPromote.getString("billname"));
            saleOrderPromotion.set("promotionnum", (Object)ocdpmPromote.getString("billno"));
            saleOrderPromotion.set("promotiontheme", (Object)ocdpmPromote.getString("promotetheme"));
            saleOrderPromotion.set("effectiondate", (Object)ocdpmPromote.getDate("startdate"));
            saleOrderPromotion.set("invaliddate", (Object)ocdpmPromote.getDate("enddate"));
            saleOrderPromotion.set("applymember", (Object)ocdpmPromote.getString("membergroup"));
            if (StringUtils.isNotEmpty((CharSequence)resPromotionEntity.getPromoteRuleId())) {
                saleOrderPromotion.set("promoteruleid", (Object)resPromotionEntity.getPromoteRuleId());
            } else {
                saleOrderPromotion.set("promoteruleid", promotionRule != null ? promotionRule.getString("id") : null);
            }
        } else {
            DynamicObject saleOrderPromotion = (DynamicObject)saleOrderPromotionList.get(promotionIdMap.get(resPromotionId).intValue());
            if (StringUtils.isNotEmpty((CharSequence)resPromotionEntity.getPromoteRuleId())) {
                saleOrderPromotion.set("promoteruleid", (Object)resPromotionEntity.getPromoteRuleId());
            }
            saleOrderPromotion.set("promotiongoodseq", (Object)BuildParamHelper.buildFilterGoodSeq(resPromotionEntity.getResPromotionDetail().getMaterialEntries()));
        }
    }

    public static String buildGoodSeq(String promotionGoodSeq, List<ResMaterialEntryEntity> materialList) {
        String[] goodSeqArray = promotionGoodSeq.split(",");
        ArrayList<String> goodSeqList = new ArrayList<String>();
        Collections.addAll(goodSeqList, goodSeqArray);
        for (ResMaterialEntryEntity resMaterial : materialList) {
            if (goodSeqList.contains(String.valueOf(resMaterial.getEntryId() + 1))) continue;
            goodSeqList.add(String.valueOf(resMaterial.getEntryId() + 1));
        }
        Collections.sort(goodSeqList);
        return goodSeqList.size() > 0 ? String.join((CharSequence)",", goodSeqList) : null;
    }

    public static String buildFilterGoodSeq(List<ResMaterialEntryEntity> resMaterialEntryEntityList) {
        StringBuilder goodSeq = new StringBuilder();
        List resMaterialList = resMaterialEntryEntityList.stream().sorted(Comparator.comparing(ResMaterialEntryEntity::getEntryId)).collect(Collectors.toList());
        for (ResMaterialEntryEntity resMaterial : resMaterialList) {
            goodSeq.append(resMaterial.getEntryId() + 1).append(',');
        }
        return goodSeq.length() > 0 ? goodSeq.deleteCharAt(goodSeq.length() - 1).toString() : "";
    }

    public static List<Integer> buildAfterDeletePromotion(DynamicObjectCollection saleOrderGoodList, DynamicObjectCollection saleOrderPromotionList, int[] deleteIndexs) {
        ArrayList<Integer> reMatchIndex = new ArrayList<Integer>();
        for (int deleteIndex : deleteIndexs) {
            String index = String.valueOf(deleteIndex + 1);
            ArrayList<DynamicObject> clearList = new ArrayList<DynamicObject>();
            for (DynamicObject saleOrderPromotion : saleOrderPromotionList) {
                DynamicObject promotionType = saleOrderPromotion.getDynamicObject("promotiontype");
                String[] goodSeqs = saleOrderPromotion.getString("promotiongoodseq").split(",");
                ArrayList<String> goodSeqList = new ArrayList<String>();
                Collections.addAll(goodSeqList, goodSeqs);
                Iterator iterator = goodSeqList.iterator();
                while (iterator.hasNext()) {
                    String goodSeq = (String)iterator.next();
                    if (goodSeq.equals(index)) {
                        iterator.remove();
                        continue;
                    }
                    if (!BuildParamHelper.filterWholeAmount(promotionType.getString("number"), saleOrderPromotion.getString("promotionid"), saleOrderGoodList)) {
                        iterator.remove();
                        continue;
                    }
                    if (!BuildParamHelper.filterWholeNum(promotionType.getString("number"), saleOrderPromotion.getString("promotionid"), saleOrderGoodList)) {
                        iterator.remove();
                        continue;
                    }
                    if (PromotionEnum.bindPromotion().contains(promotionType.getString("number")) && !BuildParamHelper.filterByBindNum(saleOrderPromotion.getString("promotionid"), saleOrderGoodList)) {
                        iterator.remove();
                        continue;
                    }
                    if (reMatchIndex.contains(Integer.parseInt(goodSeq))) continue;
                    reMatchIndex.add(Integer.parseInt(goodSeq));
                }
                if (goodSeqList.size() == 0) {
                    clearList.add(saleOrderPromotion);
                    continue;
                }
                for (int i = 0; i < goodSeqList.size(); ++i) {
                    int seq = CommonUtil.formatObjectToInt(goodSeqList.get(i));
                    if (seq < deleteIndex + 1) continue;
                    goodSeqList.set(i, String.valueOf(seq - 1));
                }
                saleOrderPromotion.set("promotiongoodseq", (Object)String.join((CharSequence)",", goodSeqList));
            }
            saleOrderPromotionList.removeAll(clearList);
            BuildParamHelper.clearGiftEntry(saleOrderGoodList, clearList);
        }
        return reMatchIndex;
    }

    private static void clearGiftEntry(DynamicObjectCollection docGoodsEntry, List<DynamicObject> clearList) {
        for (DynamicObject doPromoteEntry : clearList) {
            int promoteSeq = DynamicObjectUtils.getInt((DynamicObject)doPromoteEntry, (String)"seq");
            DynamicObject doPromoteType = DynamicObjectUtils.getDynamicObject((DynamicObject)doPromoteEntry, (String)"promotiontype");
            String promoteType = DynamicObjectUtils.getString((DynamicObject)doPromoteType, (String)"number");
            if (!StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-031") && !StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-006")) continue;
            docGoodsEntry.removeIf(x -> x.getInt("promoteseq") == promoteSeq);
        }
    }

    public static DynamicObject selectPromoteRule(String promotionId) {
        if (StringUtils.isNotBlank((CharSequence)promotionId)) {
            QFilter filter = new QFilter("promotebillid", "=", (Object)Long.parseLong(promotionId));
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdpm_promote_rule");
            Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
            return BusinessDataServiceHelper.loadSingle((String)"ocdpm_promote_rule", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
        }
        return null;
    }

    public static DynamicObject[] selectPromoteRuleList(String promotionId) {
        if (StringUtils.isNotBlank((CharSequence)promotionId)) {
            QFilter filter = new QFilter("promotebillid", "=", (Object)Long.parseLong(promotionId));
            MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdpm_promote_rule");
            Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
            return BusinessDataServiceHelper.load((String)"ocdpm_promote_rule", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
        }
        return null;
    }

    public static BigDecimal buildWholeAmount(int itemRange, MaterialEntryEntity matchMaterial, List<MaterialEntryEntity> materialEntries) {
        BigDecimal wholeAmount = BigDecimal.ZERO;
        for (MaterialEntryEntity materialEntryEntity : materialEntries) {
            BigDecimal retailPrice = materialEntryEntity.getRetailPrice();
            BigDecimal saleQty = materialEntryEntity.getQty();
            if ((itemRange != 1 || !matchMaterial.getMaterialId().equals(materialEntryEntity.getMaterialId())) && itemRange != 2) continue;
            wholeAmount = wholeAmount.add(retailPrice.multiply(saleQty));
        }
        return wholeAmount;
    }

    public static int buildWholeNum(int itemRange, MaterialEntryEntity matchMaterial, List<MaterialEntryEntity> materialEntries) {
        int wholeNum = 0;
        for (MaterialEntryEntity materialEntryEntity : materialEntries) {
            BigDecimal saleQty = materialEntryEntity.getQty();
            if ((itemRange != 1 || !matchMaterial.getMaterialId().equals(materialEntryEntity.getMaterialId())) && itemRange != 2) continue;
            wholeNum += saleQty.intValue();
        }
        return wholeNum;
    }

    public static List<MaterialEntity> buildAllMaterial(List<MaterialEntryEntity> reqMaterialList) {
        ArrayList<MaterialEntity> materialEntityList = new ArrayList<MaterialEntity>(0);
        for (MaterialEntryEntity reqMaterialEntity : reqMaterialList) {
            materialEntityList.add(new MaterialEntity(reqMaterialEntity.getEntryId(), reqMaterialEntity.getMaterialId(), reqMaterialEntity.getQty().intValue(), BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO));
        }
        return materialEntityList;
    }

    public static boolean filterWholeAmount(String typeName, String planId, DynamicObjectCollection saleOrderGoodList) {
        if (PromotionEnum.wholePromotion().contains(typeName)) {
            DynamicObject promotionRule = BuildParamHelper.selectPromoteRule(planId);
            if (promotionRule == null) {
                return false;
            }
            BigDecimal wholeAmount = BigDecimal.ZERO;
            for (DynamicObject saleOrderGood : saleOrderGoodList) {
                BigDecimal retailPrice = saleOrderGood.getBigDecimal("retailprice");
                BigDecimal saleQty = saleOrderGood.getBigDecimal("saleqty");
                if (retailPrice.compareTo(BigDecimal.ZERO) <= 0 || saleQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                wholeAmount = wholeAmount.add(retailPrice.multiply(saleQty));
            }
            if (wholeAmount.compareTo(promotionRule.getBigDecimal("targetamount")) < 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean filterWholeNum(String typeName, String planId, DynamicObjectCollection saleOrderGoodList) {
        if (PromotionEnum.wholePromotion().contains(typeName)) {
            DynamicObject promotionRule = BuildParamHelper.selectPromoteRule(planId);
            if (promotionRule == null) {
                return false;
            }
            int wholeNum = 0;
            for (DynamicObject saleOrderGood : saleOrderGoodList) {
                int saleQty = saleOrderGood.getInt("saleqty");
                if (saleQty <= 0) continue;
                wholeNum += saleQty;
            }
            if (wholeNum < promotionRule.getInt("targetqty")) {
                return true;
            }
            if (wholeNum < promotionRule.getInt("bindpickqty")) {
                return false;
            }
        }
        return true;
    }

    private static boolean filterByBindNum(String promotionId, DynamicObjectCollection saleOrderGoodList) {
        boolean isFilter = false;
        DynamicObject promotion = BusinessDataServiceHelper.loadSingle((Object)promotionId, (String)"ocdpm_promote");
        Map<String, List<MaterialEntity>> materialEntityMap = BuildParamHelper.buildBindMaterialMap(promotion);
        DynamicObject[] promoteRuleList = BuildParamHelper.selectPromoteRuleList(promotion.getString("id"));
        int bindPikcQty = 0;
        int totalBindNum = 0;
        ArrayList<String> materialIdList = new ArrayList<String>();
        for (DynamicObject promoteRule : promoteRuleList) {
            List<MaterialEntity> materialEntityList = materialEntityMap.get(promoteRule.getString("id"));
            bindPikcQty = promoteRule.getInt("bindpickqty");
            int bindQty = 0;
            int pickQty = promoteRule.getInt("pickqty");
            for (MaterialEntity materialEntity : materialEntityList) {
                for (DynamicObject saleOrderGood : saleOrderGoodList) {
                    int saleQty = saleOrderGood.getInt("saleqty");
                    String materialId = DynamicObjectUtils.getString((DynamicObject)saleOrderGood.getDynamicObject("goodsid"), (String)"id");
                    if (MaterialTypeEnum.Material.getCode() != materialEntity.getType().getCode() || !StringUtils.equals((CharSequence)materialEntity.getObjectId(), (CharSequence)materialId) || materialIdList.contains(materialId)) continue;
                    if (promoteRule.getInt("itemgroup") == 3 && !materialIdList.contains(materialId)) {
                        ++bindQty;
                        materialIdList.add(materialId);
                        continue;
                    }
                    if (promoteRule.getInt("itemgroup") == 2 && !materialIdList.contains(materialId)) {
                        bindQty = saleQty;
                        totalBindNum += bindQty;
                        materialIdList.add(materialId);
                        continue;
                    }
                    if (promoteRule.getInt("itemgroup") != 1 || materialIdList.contains(materialId) || (bindQty = saleQty) < bindPikcQty) continue;
                    totalBindNum += bindQty;
                    materialIdList.add(materialId);
                }
            }
            if (promoteRule.getInt("itemgroup") != 3 || bindQty < pickQty) continue;
            totalBindNum += bindQty;
        }
        if (totalBindNum >= bindPikcQty) {
            isFilter = true;
        }
        return isFilter;
    }

    public static List<PromoteRuleResultEntity> buildPromoteRule(PlanEntity plan, String promotionId) {
        ArrayList<PromoteRuleResultEntity> promoteRuleList = new ArrayList<PromoteRuleResultEntity>(10);
        DynamicObject[] promoteRuleArrays = BuildParamHelper.selectPromoteRuleList(promotionId);
        if (promoteRuleArrays == null) {
            return promoteRuleList;
        }
        for (int i = 0; i < promoteRuleArrays.length; ++i) {
            DynamicObject promoteRule = promoteRuleArrays[i];
            PromoteRuleResultEntity promoteRuleResult = new PromoteRuleResultEntity();
            BuildParamHelper.buildOnlinePromotionName(plan, promoteRule, promoteRuleResult, i);
            BuildParamHelper.buildOnlineGroupGift(promoteRule, promoteRuleResult);
            promoteRuleResult.setPromoteRuleId(promoteRule.getString("id"));
            promoteRuleResult.setTargetQty(Integer.valueOf(promoteRule.getInt("targetqty")));
            promoteRuleResult.setDiscount(promoteRule.getString("discount"));
            promoteRuleResult.setBindPickQty(Integer.valueOf(promoteRule.getInt("bindpickqty")));
            promoteRuleResult.setItemGroup(promoteRule.getString("itemgroup"));
            promoteRuleResult.setSendPointQty(Integer.valueOf(promoteRule.getInt("pointsumqty")));
            promoteRuleResult.setSendTicketQty(Integer.valueOf(promoteRule.getInt("ticketsumqty")));
            promoteRuleResult.setSumGiveQty(Integer.valueOf(promoteRule.getInt("sumgiveqty")));
            if (promoteRule.getBigDecimal("bindreduceamount") != null) {
                promoteRuleResult.setBindReduceAmount(promoteRule.getBigDecimal("bindreduceamount").stripTrailingZeros());
            }
            if (promoteRule.getBigDecimal("targetamount") != null) {
                promoteRuleResult.setTargetAmount(promoteRule.getBigDecimal("targetamount").stripTrailingZeros());
            }
            if (promoteRule.getBigDecimal("reductionamount") != null) {
                promoteRuleResult.setReductionAmount(promoteRule.getBigDecimal("reductionamount").stripTrailingZeros());
            }
            promoteRuleList.add(promoteRuleResult);
        }
        return promoteRuleList;
    }

    public static void buildOnlinePromotionName(PlanEntity plan, DynamicObject promoteRule, PromoteRuleResultEntity promoteRuleResult, int index) {
        Integer targetQty = promoteRule.getInt("targetqty");
        Integer sumPointQty = promoteRule.getInt("pointsumqty");
        Integer sumTicketQty = promoteRule.getInt("ticketsumqty");
        Integer sumGiveQty = promoteRule.getInt("sumgiveqty");
        String targetAmount = null;
        if (promoteRule.getBigDecimal("targetamount") != null) {
            targetAmount = promoteRule.getBigDecimal("targetamount").setScale(2).stripTrailingZeros().toPlainString();
        }
        switch (plan.getTypeName()) {
            case "PM-023": {
                if (index == 0) {
                    plan.setName(String.format("\u6ee1%s\u91d1\u989d\u9001%s\u79ef\u5206", targetAmount, sumPointQty));
                }
                promoteRuleResult.setPromoteRuleName(String.format("\u6ee1%s\u91d1\u989d\u9001%s\u79ef\u5206", targetAmount, sumPointQty));
                break;
            }
            case "PM-039": {
                if (index == 0) {
                    plan.setName(String.format("\u6ee1%s\u4ef6\u6570\u9001%s\u79ef\u5206", targetQty, sumPointQty));
                }
                promoteRuleResult.setPromoteRuleName(String.format("\u6ee1%s\u4ef6\u6570\u9001%s\u79ef\u5206", targetQty, sumPointQty));
                break;
            }
            case "PM-037": {
                if (index == 0) {
                    plan.setName(String.format("\u6ee1%s\u4ef6\u6570\u9001%s\u793c\u5238", targetQty, sumTicketQty));
                }
                promoteRuleResult.setPromoteRuleName(String.format("\u6ee1%s\u4ef6\u6570\u9001%s\u5f20\u793c\u5238", targetQty, sumTicketQty));
                break;
            }
            case "PM-025": {
                if (index == 0) {
                    plan.setName(String.format("\u6ee1%s\u91d1\u989d\u9001%s\u793c\u5238", targetAmount, sumTicketQty));
                }
                promoteRuleResult.setPromoteRuleName(String.format("\u6ee1%s\u91d1\u989d\u9001%s\u5f20\u793c\u5238", targetAmount, sumTicketQty));
                break;
            }
            case "PM-006": {
                if (index == 0) {
                    plan.setName(String.format("\u6ee1%s\u4ef6\u6570\u9001%s\u8d60\u54c1", targetQty, sumGiveQty));
                }
                promoteRuleResult.setPromoteRuleName(String.format("\u6ee1%s\u4ef6\u6570\u9001%s\u4e2a\u8d60\u54c1", targetQty, sumGiveQty));
                break;
            }
            case "PM-020": {
                if (index == 0) {
                    plan.setName(String.format("\u6ee1%s\u91d1\u989d\u9001%s\u8d60\u54c1", targetAmount, sumGiveQty));
                }
                promoteRuleResult.setPromoteRuleName(String.format("\u6ee1%s\u91d1\u989d\u9001%s\u4e2a\u8d60\u54c1", targetAmount, sumGiveQty));
            }
        }
    }

    public static void buildOnlineGroupGift(DynamicObject promoteRule, PromoteRuleResultEntity promoteRuleResult) {
        DynamicObjectCollection groupEntryList = promoteRule.getDynamicObjectCollection("groupentry");
        ArrayList<PromoteRuleGroupResultEntity> groupEntityList = new ArrayList<PromoteRuleGroupResultEntity>();
        for (DynamicObject groupEntry : groupEntryList) {
            PromoteRuleGroupResultEntity groupEntity = new PromoteRuleGroupResultEntity();
            groupEntity.setGroupNo(groupEntry.getString("ggroupno"));
            groupEntity.setTotalGiftNum(Integer.valueOf(groupEntry.getInt("gsumitemqty")));
            groupEntity.setPickQty(Integer.valueOf(groupEntry.getInt("gpickqty")));
            DynamicObjectCollection subGiftItemList = groupEntry.getDynamicObjectCollection("subgiftitementry");
            ArrayList<PromoteRuleGiftResultEntity> giftEntityList = new ArrayList<PromoteRuleGiftResultEntity>(16);
            for (DynamicObject subGiftItem : subGiftItemList) {
                PromoteRuleGiftResultEntity giftEntity = new PromoteRuleGiftResultEntity();
                DynamicObject gift = subGiftItem.getDynamicObject("subgitemid");
                DynamicObject giftBrand = subGiftItem.getDynamicObject("subgbrandid");
                DynamicObject giftClass = subGiftItem.getDynamicObject("subgitemclassid");
                giftEntity.setGiftId(DynamicObjectUtils.getString((DynamicObject)gift, (String)"id"));
                giftEntity.setGiftName(DynamicObjectUtils.getString((DynamicObject)gift, (String)"name"));
                giftEntity.setGiftBrand(DynamicObjectUtils.getString((DynamicObject)giftBrand, (String)"name"));
                giftEntity.setGiftClass(DynamicObjectUtils.getString((DynamicObject)giftClass, (String)"name"));
                giftEntity.setGiftNum(Integer.valueOf(subGiftItem.getInt("subitemqty")));
                giftEntity.setBarCode(DynamicObjectUtils.getLong((DynamicObject)subGiftItem.getDynamicObject("subgbarcodeid"), (String)"id"));
                giftEntity.setUnit(DynamicObjectUtils.getLong((DynamicObject)gift, (String)"saleunit_id"));
                giftEntity.setInventoryType(DynamicObjectUtils.getLong((DynamicObject)subGiftItem.getDynamicObject("subgdeliverystocktype"), (String)"id"));
                if (subGiftItem.getBigDecimal("subgpromoteprice") != null) {
                    giftEntity.setGiftPrice(subGiftItem.getBigDecimal("subgpromoteprice").stripTrailingZeros());
                }
                giftEntityList.add(giftEntity);
            }
            groupEntity.setGiftList(giftEntityList);
            groupEntityList.add(groupEntity);
        }
        promoteRuleResult.setGroupList(groupEntityList);
    }

    public static void matchItemPromotion(IFormView view, DynamicObjectCollection entry, int index) {
        try {
            ArrayList memberLabelIdList = new ArrayList();
            String memberlevelid = null;
            DynamicObject bizOrg = (DynamicObject)view.getModel().getValue("bizorgid");
            String bizOrgId = DynamicObjectUtils.getString((DynamicObject)bizOrg, (String)"id");
            DynamicObject branch = (DynamicObject)view.getModel().getValue("salebranchid");
            String branchId = DynamicObjectUtils.getString((DynamicObject)branch, (String)"id");
            DynamicObject member = (DynamicObject)view.getModel().getValue("member");
            String memberId = DynamicObjectUtils.getString((DynamicObject)member, (String)"id");
            if (member != null && member.getDynamicObject("viplevelid") != null) {
                memberlevelid = member.getDynamicObject("viplevelid").getString("id");
            }
            String billDate = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
            CxRequestEntity req = new CxRequestEntity(bizOrgId, branchId, memberId, memberLabelIdList, memberlevelid, billDate, null, null);
            BuildParamHelper.buildMaterialEntry(view.getModel(), entry, req, index);
            if (req.getMaterialEntries() == null) {
                return;
            }
            CxResultEntity result = SaleorderPromotionHelper.matchPromotion(req);
            if (result.getResMultiPromotion().size() > 0) {
                SaleorderPromotionHelper.setPromotionInfo(view, result.getResMultiPromotion());
            }
            if (result.getUnMatchPlan().size() > 0) {
                SaleorderPromotionHelper.clearUnMatchPromotion(view, result.getUnMatchPlan());
            }
        }
        catch (KDBizException e) {
            e.printStackTrace();
        }
    }

    private static void buildMaterialEntry(IDataModel model, DynamicObjectCollection entry, CxRequestEntity req, int rowIndex) {
        ArrayList<MaterialEntryEntity> materialEntryEntityList = new ArrayList<MaterialEntryEntity>();
        for (int index = 0; index < entry.size(); ++index) {
            DynamicObject goods;
            DynamicObject entryItem = (DynamicObject)entry.get(index);
            boolean isPresent = entryItem.getBoolean("ispresent");
            if (isPresent || (goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"goodsid")) == null) continue;
            DynamicObject unit = (DynamicObject)model.getValue("unit", index);
            String unitId = DynamicObjectUtils.getString((DynamicObject)unit, (String)"id");
            DynamicObject auxattr = (DynamicObject)model.getValue("auxattrid", index);
            String auxattrid = DynamicObjectUtils.getString((DynamicObject)auxattr, (String)"id");
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)model.getValue("basebilltype")));
            BigDecimal retailPrice = billTypeId == BillTypeEnum.GUIDE.getId() || billTypeId == BillTypeEnum.GROUP.getId() ? entryItem.getBigDecimal("discountprice") : entryItem.getBigDecimal("retailprice");
            BigDecimal saleQty = entryItem.getBigDecimal("saleqty");
            List classIds = ItemClassUtil.queryClassList((Object)goods.getPkValue());
            DynamicObject goodsBrand = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"brand");
            String brand = goodsBrand != null ? goodsBrand.getString("id") : "";
            BigDecimal stdDiscountAmount = entryItem.getBigDecimal("stddiscountamount");
            BigDecimal notinComeDisAmount = entryItem.getBigDecimal("notincomedisamount");
            boolean isChangePrice = stdDiscountAmount.compareTo(BigDecimal.ZERO) > 0 || notinComeDisAmount.compareTo(BigDecimal.ZERO) > 0;
            DynamicObject goodSaleAttr = DynamicObjectUtils.getDynamicObject((DynamicObject)entryItem, (String)"saleattr");
            Long saleAttr = goodSaleAttr != null ? goodSaleAttr.getLong("id") : 0L;
            Long inventoryType = null;
            if (DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery").size() > 0) {
                DynamicObject deliveryEntry = (DynamicObject)DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery").get(0);
                DynamicObject goodInventoryType = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntry, (String)"deliverystocktype");
                inventoryType = goodInventoryType != null ? goodInventoryType.getLong("id") : 0L;
            }
            MaterialEntryEntity entryEntity = new MaterialEntryEntity(index, goods.getString("id"), goods.getString("name"), unitId, auxattrid, retailPrice, saleQty, brand, classIds.stream().map(CommonUtil::formatStringToEmpty).collect(Collectors.toList()), saleAttr, inventoryType, isChangePrice);
            materialEntryEntityList.add(entryEntity);
            if (index != rowIndex - 1) continue;
            req.setMatchMaterial(entryEntity);
        }
        req.setMaterialEntries(materialEntryEntityList);
    }

    public static int buildMaterialQty(PlanEntity plan, MaterialEntryEntity matchMaterial) {
        List materialEntityList = plan.getMaterialEntityList();
        int wholeQty = 0;
        for (MaterialEntity material : materialEntityList) {
            switch (material.getType()) {
                case Material: {
                    if (!MaterialConditionHelper.materialEqual(material, matchMaterial)) break;
                    wholeQty += material.getQty();
                    break;
                }
                case MaterialBrand: {
                    if (!MaterialConditionHelper.materialBrandEqual(material, matchMaterial)) break;
                    wholeQty += material.getQty();
                    break;
                }
                case MaterialCategory: {
                    if (!MaterialConditionHelper.materialClassEqual(material, matchMaterial)) break;
                    wholeQty += material.getQty();
                    break;
                }
                case MaterialUnit: {
                    if (!MaterialConditionHelper.materialUnitEqual(material, matchMaterial)) break;
                    wholeQty += material.getQty();
                }
            }
        }
        return wholeQty;
    }
}

