/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocpos.common.entity.MaterialEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.util.promotion.CommonUtils;

public class MaterialConditionHelper {
    public static MaterialEntity matchDetailMaterial(MaterialEntity material, MaterialEntryEntity reqMaterial) {
        switch (material.getType()) {
            case Material: {
                if (MaterialConditionHelper.materialEqual(material, reqMaterial)) break;
                return null;
            }
            case MaterialBrand: {
                if (MaterialConditionHelper.materialBrandEqual(material, reqMaterial)) break;
                return null;
            }
            case MaterialCategory: {
                if (MaterialConditionHelper.materialClassEqual(material, reqMaterial)) break;
                return null;
            }
            case MaterialUnit: {
                if (MaterialConditionHelper.materialUnitEqual(material, reqMaterial)) break;
                return null;
            }
        }
        return material;
    }

    public static boolean materialEqual(MaterialEntity material, MaterialEntryEntity reqMaterial) {
        return material.getObjectId().equals(reqMaterial.getMaterialId()) && MaterialConditionHelper.saleAttrAndInventoryEqual(material, reqMaterial);
    }

    public static boolean materialBrandEqual(MaterialEntity material, MaterialEntryEntity reqMaterial) {
        return reqMaterial.getBrandId().equals(material.getMaterialBrandId()) && MaterialConditionHelper.saleAttrAndInventoryEqual(material, reqMaterial);
    }

    public static boolean materialClassEqual(MaterialEntity material, MaterialEntryEntity reqMaterial) {
        return CommonUtils.isContain((List)reqMaterial.getCategories(), (String)material.getMaterialClassId()) && MaterialConditionHelper.saleAttrAndInventoryEqual(material, reqMaterial);
    }

    public static boolean materialUnitEqual(MaterialEntity material, MaterialEntryEntity reqMaterial) {
        if (StringUtils.isNotEmpty((CharSequence)material.getMaterialBrandId()) && !reqMaterial.getBrandId().equals(material.getMaterialBrandId())) {
            return false;
        }
        if (StringUtils.isNotEmpty((CharSequence)material.getMaterialClassId()) && !CommonUtils.isContain((List)reqMaterial.getCategories(), (String)material.getMaterialClassId())) {
            return false;
        }
        return MaterialConditionHelper.saleAttrAndInventoryEqual(material, reqMaterial);
    }

    public static boolean saleAttrAndInventoryEqual(MaterialEntity material, MaterialEntryEntity reqMaterial) {
        if (material.getSaleAttr().size() > 0 && !material.getSaleAttr().contains(reqMaterial.getSaleAttr())) {
            return false;
        }
        return material.getInventoryType().size() <= 0 || !material.getInventoryType().contains(reqMaterial.getInventoryType());
    }
}

