/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.business.promotion.MaterialConditionHelper;
import kd.occ.ocpos.business.promotion.PromotionFilterHelper;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.common.entity.MaterialEntity;
import kd.occ.ocpos.common.entity.PlanEntity;
import kd.occ.ocpos.common.entity.request.CxPromotionRequestEntity;
import kd.occ.ocpos.common.entity.request.CxPromotionResultEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.entity.request.PromoteRuleResultEntity;
import kd.occ.ocpos.common.enums.promotion.ApplyMaterialScopeEnum;
import kd.occ.ocpos.common.result.PlanResult;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.promotion.CommonUtils;

public class OlstorePromotionHelper {
    private static final Log logger = LogFactory.getLog(OlstorePromotionHelper.class);

    public static List<CxPromotionResultEntity> matchPromotion(CxPromotionRequestEntity requestEntity) {
        ArrayList<CxPromotionResultEntity> resultList = new ArrayList<CxPromotionResultEntity>();
        List<PlanEntity> allPromotion = OlstorePromotionHelper.queryAllPromotion();
        for (PlanEntity plan : allPromotion) {
            CxPromotionResultEntity result;
            PlanResult planResult;
            if (!PromotionEnum.onlinePromotion().contains(plan.getTypeName()) || !(planResult = PromotionFilterHelper.matchPlanParam(plan, requestEntity.getBillDate(), requestEntity.getStoreId(), requestEntity.getMemberId(), requestEntity.getMemberLevelId(), null, null)).isResult() || (result = OlstorePromotionHelper.judgeMaterial(requestEntity, plan)) == null) continue;
            resultList.add(result);
        }
        return resultList;
    }

    private static List<PlanEntity> queryAllPromotion() {
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("promotestatus", "=", (Object)"B"));
        filter.and(new QFilter("isonlinestoreprom", "=", (Object)Boolean.TRUE));
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdpm_promote");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        DynamicObject[] promotionList = BusinessDataServiceHelper.load((String)"ocdpm_promote", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
        if (promotionList.length == 0) {
            System.out.print("\u672a\u5339\u914d\u5230\u4fc3\u9500\u65b9\u6848");
            return new ArrayList<PlanEntity>();
        }
        return BuildParamHelper.buildPlanEntity(promotionList);
    }

    private static CxPromotionResultEntity judgeMaterial(CxPromotionRequestEntity requestEntity, PlanEntity plan) {
        CxPromotionResultEntity result = null;
        ApplyMaterialScopeEnum applyMaterialScope = plan.getApplyMaterialScope();
        List materialEntityList = plan.getMaterialEntityList();
        MaterialEntryEntity reqMaterial = requestEntity.getMatchMaterial();
        List materialEntryEntityList = requestEntity.getMaterialEntries();
        ArrayList<MaterialEntryEntity> filterMaterialList = new ArrayList<MaterialEntryEntity>();
        List<PromoteRuleResultEntity> promoteRuleList = BuildParamHelper.buildPromoteRule(plan, plan.getId());
        List materialIdList = materialEntryEntityList.stream().map(MaterialEntryEntity::getMaterialId).collect(Collectors.toList());
        if (ApplyMaterialScopeEnum.AllMaterial == applyMaterialScope) {
            result = requestEntity.getMatch().booleanValue() ? OlstorePromotionHelper.filterReqMaterialByWhole(plan, materialEntryEntityList, reqMaterial) : new CxPromotionResultEntity(plan, promoteRuleList, materialIdList);
        } else if (requestEntity.getMatch().booleanValue()) {
            for (MaterialEntryEntity materialEntryEntity : materialEntryEntityList) {
                for (MaterialEntity material : materialEntityList) {
                    MaterialEntity matchMaterial = OlstorePromotionHelper.matchDetailMaterial(material, materialEntryEntity);
                    switch (applyMaterialScope) {
                        case SpecificMaterial: {
                            if (matchMaterial == null) break;
                            filterMaterialList.add(materialEntryEntity);
                        }
                    }
                }
            }
            result = OlstorePromotionHelper.filterReqMaterialByWhole(plan, filterMaterialList, reqMaterial);
        } else {
            for (MaterialEntity material : materialEntityList) {
                MaterialEntity matchMaterial = OlstorePromotionHelper.matchDetailMaterial(material, reqMaterial);
                switch (applyMaterialScope) {
                    case SpecificMaterial: {
                        if (matchMaterial == null) break;
                        result = new CxPromotionResultEntity(plan, promoteRuleList, materialIdList);
                    }
                }
            }
        }
        return result;
    }

    private static CxPromotionResultEntity filterReqMaterialByWhole(PlanEntity plan, List<MaterialEntryEntity> filterMaterialList, MaterialEntryEntity reqMaterial) {
        CxPromotionResultEntity result = null;
        ArrayList<PromoteRuleResultEntity> promoteRuleList = new ArrayList<PromoteRuleResultEntity>();
        List materialIdList = filterMaterialList.stream().map(MaterialEntryEntity::getMaterialId).collect(Collectors.toList());
        boolean enough = false;
        if (plan.getPromotionWay() == 1) {
            enough = OlstorePromotionHelper.filterWholeAmount(plan, reqMaterial, filterMaterialList, promoteRuleList);
        } else if (plan.getPromotionWay() == 2) {
            enough = OlstorePromotionHelper.filterWholeNum(plan, reqMaterial, filterMaterialList, promoteRuleList);
        }
        if (enough) {
            plan.setMaterialEntityList(BuildParamHelper.buildAllMaterial(filterMaterialList));
            if (promoteRuleList.size() > 0 && promoteRuleList.get(0) != null) {
                plan.setName(((PromoteRuleResultEntity)promoteRuleList.get(0)).getPromoteRuleName());
            }
            result = new CxPromotionResultEntity(plan, promoteRuleList, materialIdList);
        }
        return result;
    }

    private static boolean filterWholeAmount(PlanEntity plan, MaterialEntryEntity matchMaterial, List<MaterialEntryEntity> materialEntryEntityList, List<PromoteRuleResultEntity> promoteRuleList) {
        boolean enoughAmount = false;
        DynamicObject[] promotionRuleList = BuildParamHelper.selectPromoteRuleList(plan.getId());
        if (promotionRuleList.length == 0) {
            return enoughAmount;
        }
        BigDecimal wholeAmount = BuildParamHelper.buildWholeAmount(plan.getItemRange(), matchMaterial, materialEntryEntityList);
        PromoteRuleResultEntity promoteRuleResultEntity = null;
        for (int index = 0; index < promotionRuleList.length; ++index) {
            DynamicObject promotionRule = promotionRuleList[index];
            if (promotionRule.getInt("targetamount") <= 0 || wholeAmount.compareTo(promotionRule.getBigDecimal("targetamount")) < 0) continue;
            promoteRuleResultEntity = OlstorePromotionHelper.buildCurrentPromoteRule(promotionRule, plan, index);
            enoughAmount = true;
        }
        promoteRuleList.add(promoteRuleResultEntity);
        return enoughAmount;
    }

    private static boolean filterWholeNum(PlanEntity plan, MaterialEntryEntity matchMaterial, List<MaterialEntryEntity> materialEntryEntityList, List<PromoteRuleResultEntity> promoteRuleList) {
        boolean enoughNum = false;
        DynamicObject[] promotionRuleList = BuildParamHelper.selectPromoteRuleList(plan.getId());
        if (promotionRuleList.length == 0) {
            return enoughNum;
        }
        int wholeNum = BuildParamHelper.buildWholeNum(plan.getItemRange(), matchMaterial, materialEntryEntityList);
        PromoteRuleResultEntity promoteRuleResultEntity = null;
        for (int index = 0; index < promotionRuleList.length; ++index) {
            DynamicObject promotionRule = promotionRuleList[index];
            int targetQty = promotionRule.getInt("targetqty");
            int bindPickQty = promotionRule.getInt("bindpickqty");
            if (targetQty > 0 && wholeNum >= targetQty) {
                promoteRuleResultEntity = OlstorePromotionHelper.buildCurrentPromoteRule(promotionRule, plan, index);
                enoughNum = true;
            }
            if (bindPickQty <= 0 || wholeNum < bindPickQty) continue;
            promoteRuleResultEntity = OlstorePromotionHelper.buildCurrentPromoteRule(promotionRule, plan, index);
            enoughNum = true;
        }
        promoteRuleList.add(promoteRuleResultEntity);
        return enoughNum;
    }

    private static MaterialEntity matchDetailMaterial(MaterialEntity material, MaterialEntryEntity matchMaterial) {
        switch (material.getType()) {
            case Material: {
                if (!MaterialConditionHelper.materialEqual(material, matchMaterial)) break;
                return material;
            }
            case MaterialBrand: {
                if (!MaterialConditionHelper.materialBrandEqual(material, matchMaterial)) break;
                return material;
            }
            case MaterialCategory: {
                if (!MaterialConditionHelper.materialClassEqual(material, matchMaterial)) break;
                return material;
            }
            case MaterialUnit: {
                if (!MaterialConditionHelper.materialUnitEqual(material, matchMaterial)) break;
                return material;
            }
        }
        return null;
    }

    public static boolean materialEqual(MaterialEntity material, String materialId, String auxId, String unitId) {
        if (!material.getObjectId().equals(materialId)) {
            return false;
        }
        boolean isUnitId = CommonUtils.isEqualObjId((String)unitId, (String)material.getMaterialUnitId());
        if (CommonUtils.isEmpty((String)unitId) || StringUtils.isEmpty((CharSequence)material.getMaterialUnitId())) {
            isUnitId = true;
        }
        boolean isAuxId = CommonUtils.isEqualObjId((String)auxId, (String)material.getAuxId());
        if (CommonUtils.isEmpty((String)auxId) || StringUtils.isEmpty((CharSequence)material.getAuxId())) {
            isAuxId = true;
        }
        return isUnitId && isAuxId;
    }

    private static PromoteRuleResultEntity buildCurrentPromoteRule(DynamicObject promotionRule, PlanEntity plan, int index) {
        PromoteRuleResultEntity promoteRuleResultEntity = new PromoteRuleResultEntity();
        BuildParamHelper.buildOnlinePromotionName(plan, promotionRule, promoteRuleResultEntity, index);
        BuildParamHelper.buildOnlineGroupGift(promotionRule, promoteRuleResultEntity);
        promoteRuleResultEntity.setPromoteRuleId(promotionRule.getString("id"));
        promoteRuleResultEntity.setTargetQty(Integer.valueOf(promotionRule.getInt("targetqty")));
        promoteRuleResultEntity.setDiscount(promotionRule.getString("discount"));
        promoteRuleResultEntity.setBindPickQty(Integer.valueOf(promotionRule.getInt("bindpickqty")));
        promoteRuleResultEntity.setItemGroup(promotionRule.getString("itemgroup"));
        promoteRuleResultEntity.setSendPointQty(Integer.valueOf(promotionRule.getInt("pointsumqty")));
        promoteRuleResultEntity.setSendTicketQty(Integer.valueOf(promotionRule.getInt("ticketsumqty")));
        promoteRuleResultEntity.setSumGiveQty(Integer.valueOf(promotionRule.getInt("sumgiveqty")));
        if (promotionRule.getBigDecimal("bindreduceamount") != null) {
            promoteRuleResultEntity.setBindReduceAmount(promotionRule.getBigDecimal("bindreduceamount").stripTrailingZeros());
        }
        if (promotionRule.getBigDecimal("targetamount") != null) {
            promoteRuleResultEntity.setTargetAmount(promotionRule.getBigDecimal("targetamount").stripTrailingZeros());
        }
        if (promotionRule.getBigDecimal("reductionamount") != null) {
            promoteRuleResultEntity.setReductionAmount(promotionRule.getBigDecimal("reductionamount").stripTrailingZeros());
        }
        return promoteRuleResultEntity;
    }

    public static void fillOlstorePromotion(DynamicObject saleOrder) {
        DynamicObjectCollection promotionList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"promotionentity");
        if (CollectionUtils.isEmpty((Collection)promotionList)) {
            return;
        }
        for (DynamicObject promotion : promotionList) {
            promotion.set("execute", (Object)Boolean.TRUE);
        }
        SaleorderPromotionHelper.executePromotionCalcRule(saleOrder);
    }

    public static void executeOlstorePromotion(DynamicObject saleOrder) {
        ArrayList<DynamicObject> lstSendTicket = new ArrayList<DynamicObject>((Collection<DynamicObject>)saleOrder.getDynamicObjectCollection("ticketsendentity"));
        ArrayList<DynamicObject> lstSendPoint = new ArrayList<DynamicObject>((Collection<DynamicObject>)saleOrder.getDynamicObjectCollection("sendintegralentity"));
        OlstorePromotionHelper.doSendHandle(saleOrder, lstSendPoint, lstSendTicket);
        OlstorePromotionHelper.doPromotionTicketAndPointSend(saleOrder, lstSendTicket, lstSendPoint, true);
    }

    public static void cancelOlstorePromotion(DynamicObject returnOrder) {
        ArrayList<DynamicObject> lstSendTicket = new ArrayList<DynamicObject>();
        ArrayList<DynamicObject> lstSendPoint = new ArrayList<DynamicObject>();
        OlstorePromotionHelper.doSendHandle(returnOrder, lstSendPoint, lstSendTicket);
        OlstorePromotionHelper.doPromotionTicketAndPointSend(returnOrder, lstSendTicket, lstSendPoint, false);
    }

    private static void doSendHandle(DynamicObject saleOrder, List<DynamicObject> lstPromotionPoint, List<DynamicObject> lstPromotionTicket) {
        List<DynamicObject> ticketSendEntity;
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        Map<String, List<DynamicObject>> lstMap = OlstorePromotionHelper.getPromoteSendList(docGoodsEntry);
        List<DynamicObject> sendIntegralEntity = lstMap.get("sendintegralentity");
        if (!CollectionUtils.isEmpty(sendIntegralEntity)) {
            lstPromotionPoint.addAll(sendIntegralEntity);
        }
        if (!CollectionUtils.isEmpty(ticketSendEntity = lstMap.get("ticketsendentity"))) {
            lstPromotionTicket.addAll(ticketSendEntity);
        }
    }

    private static Map<String, List<DynamicObject>> getPromoteSendList(DynamicObjectCollection docGoodsEntry) {
        HashMap<String, List<DynamicObject>> mapData = new HashMap<String, List<DynamicObject>>(0);
        ArrayList lstPointData = new ArrayList(0);
        ArrayList lstTicketData = new ArrayList(0);
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            DynamicObjectCollection docPromotionEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
            if (CollectionUtils.isEmpty((Collection)docPromotionEntry)) continue;
            ArrayList<DynamicObject> lstPromoteData = new ArrayList<DynamicObject>((Collection<DynamicObject>)docPromotionEntry);
            Map<String, List<DynamicObject>> mapDataPromote = OlstorePromotionHelper.getPromoteTicketOrPointList(lstPromoteData);
            lstPointData.addAll(mapDataPromote.get("sendintegralentity"));
            lstTicketData.addAll(mapDataPromote.get("ticketsendentity"));
        }
        mapData.put("sendintegralentity", lstPointData);
        mapData.put("ticketsendentity", lstTicketData);
        return mapData;
    }

    private static Map<String, List<DynamicObject>> getPromoteTicketOrPointList(List<DynamicObject> docPromotionEntry) {
        HashMap<String, List<DynamicObject>> mapData = new HashMap<String, List<DynamicObject>>(0);
        ArrayList<DynamicObject> lstPromotionTicket = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> lstPromotionPoint = new ArrayList<DynamicObject>(0);
        for (DynamicObject doPromotionEntry : docPromotionEntry) {
            String promoteType;
            DynamicObject doPromoteType = DynamicObjectUtils.getDynamicObject((DynamicObject)doPromotionEntry, (String)"promotiontypeid");
            if (ObjectUtils.isEmpty((Object)doPromoteType)) continue;
            switch (promoteType = DynamicObjectUtils.getString((DynamicObject)doPromoteType, (String)"number")) {
                case "PM-023": 
                case "PM-034": 
                case "PM-039": {
                    if (lstPromotionPoint.contains(doPromotionEntry)) break;
                    lstPromotionPoint.add(doPromotionEntry);
                    break;
                }
                case "PM-025": 
                case "PM-035": 
                case "PM-037": {
                    if (lstPromotionTicket.contains(doPromotionEntry)) break;
                    lstPromotionTicket.add(doPromotionEntry);
                    break;
                }
            }
        }
        mapData.put("sendintegralentity", lstPromotionPoint);
        mapData.put("ticketsendentity", lstPromotionTicket);
        return mapData;
    }

    public static void doPromotionTicketAndPointSend(DynamicObject saleOrder, List<DynamicObject> lstPromotionTicket, List<DynamicObject> lstPromotionPoint, boolean saleOption) {
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder);
        String billNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long channelId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        long memberId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"member");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
        long modifierId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"modifier");
        DynamicObjectCollection goodsEntryList = saleOrder.getDynamicObjectCollection("goodsentryentity");
        String sourceBillNo = ((DynamicObject)goodsEntryList.get(0)).getString("entrysrcbillno");
        if (lstPromotionTicket.size() > 0) {
            HashMap tickets = new HashMap(0);
            int index = 0;
            if (saleOption) {
                for (DynamicObject doPromotionTicket : lstPromotionTicket) {
                    ++index;
                    HashMap<String, Object> ticketInfo = new HashMap<String, Object>(0);
                    ticketInfo.put("tickettypeid", DynamicObjectUtils.getPkValue((DynamicObject)doPromotionTicket, (String)"coupontype"));
                    ticketInfo.put("bizorgid", orgId);
                    ticketInfo.put("qty", DynamicObjectUtils.getInt((DynamicObject)doPromotionTicket, (String)"promotsaleqty"));
                    ticketInfo.put("vipid", memberId);
                    ticketInfo.put("realsaleamount", BigDecimal.ZERO);
                    ticketInfo.put("gifterid", modifierId);
                    ticketInfo.put("giftorgid", orgId);
                    ticketInfo.put("giftbranchid", channelId);
                    ticketInfo.put("giftbillid", billId);
                    ticketInfo.put("giftbillno", billNo);
                    ticketInfo.put("ticketstatus", TicketStatusEnum.SEND.getName());
                    ticketInfo.put("comment", "\u96f6\u552e\u5f00\u5355\u4fc3\u9500\u8d60\u9001\u793c\u5238");
                    tickets.put("tickets" + index, ticketInfo);
                }
                OlstorePromotionHelper.doService("occ", "ocgcm", "TicketInfoService", "gift", tickets);
            } else {
                DynamicObject[] ticketFlowList;
                ArrayList<String> ticketNoList = new ArrayList<String>(16);
                for (DynamicObject ticketFlow : ticketFlowList = BusinessDataServiceHelper.load((String)"ocgcm_ticketactionflow", (String)"id,ticketid", (QFilter[])new QFilter[]{new QFilter("billno", "=", (Object)sourceBillNo)})) {
                    DynamicObject ticketInfos = ticketFlow.getDynamicObject("ticketid");
                    ticketNoList.add(ticketInfos.getString("number"));
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("billsource", (Object)"ocgcm_ticketsreturn");
                jsonObject.put("numbers", (Object)ticketNoList.toArray());
                jsonObject.put("sourcebillid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder));
                jsonObject.put("sourcebillno", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno"));
                jsonObject.put("branchid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid"));
                jsonObject.put("orgid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid"));
                jsonObject.put("operatorid", (Object)CommonUtil.formatObejctToLong((Object)RequestContext.get().getUserId()));
                OlstorePromotionHelper.doService("occ", "ocgcm", "TicketInfoService", "ticketInfoRefund", jsonObject);
                OlstorePromotionHelper.updateSendTicketStatus(saleOrder);
            }
        }
        if (lstPromotionPoint.size() > 0) {
            for (DynamicObject doPromotionPoint : lstPromotionPoint) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("requestUuid", (Object)UUID.randomUUID().toString());
                jsonObject.put("memberId", (Object)memberId);
                jsonObject.put("transactionTime", (Object)DateUtil.getDateFormat((Date)TimeServiceHelper.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                jsonObject.put("pointBizTypeId", (Object)1052237644077201408L);
                HashMap<Long, Integer> pointMap = new HashMap<Long, Integer>(2);
                pointMap.put(DynamicObjectUtils.getPkValue((DynamicObject)doPromotionPoint, (String)"pointtype"), DynamicObjectUtils.getInt((DynamicObject)doPromotionPoint, (String)"promotsaleqty"));
                jsonObject.put("pointMap", pointMap);
                jsonObject.put("orgId", (Object)orgId);
                jsonObject.put("channelId", (Object)channelId);
                jsonObject.put("srcBillId", (Object)billId);
                jsonObject.put("srcNo", (Object)billNo);
                jsonObject.put("srcBillEntityId", (Object)saleOrder.getDynamicObjectType().getName());
                jsonObject.put("transCurrencyId", (Object)currencyId);
                if (saleOption) {
                    jsonObject.put("comment", (Object)"\u96f6\u552e\u5f00\u5355\u4fc3\u9500\u8d60\u9001\u79ef\u5206");
                    OlstorePromotionHelper.doService("occ", "ocric", "PointRightsService", "increaseAvailablePoint", jsonObject);
                    continue;
                }
                jsonObject.put("comment", (Object)"\u96f6\u552e\u9000\u8d27\u9000\u56de\u8d60\u9001\u79ef\u5206");
                OlstorePromotionHelper.doService("occ", "ocric", "PointRightsService", "decreaseAvailablePoint", jsonObject);
            }
        }
    }

    @Deprecated
    public static boolean doService(String cloudId, String appId, String serviceName, String functionName, Object objParam) {
        boolean result = false;
        try {
            JSONObject jObj = (JSONObject)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serviceName, (String)functionName, (Object[])new Object[]{objParam});
            if (jObj == null) {
                logger.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u8fd4\u56de\u7ed3\u679c\uff1anull");
            } else if (StringUtils.equals((CharSequence)"ocgcm", (CharSequence)appId)) {
                if (StringUtils.equals((CharSequence)jObj.getString("success"), (CharSequence)"true")) {
                    result = true;
                } else {
                    String message = jObj.getString("message");
                    logger.info("\u793c\u5238\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + message);
                    result = false;
                }
            } else if (StringUtils.equals((CharSequence)"ocric", (CharSequence)appId)) {
                if (StringUtils.equals((CharSequence)jObj.getString("code"), (CharSequence)"0")) {
                    result = true;
                } else {
                    String message = jObj.getString("message");
                    logger.info("\u79ef\u5206\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + message);
                    result = false;
                }
            }
        }
        catch (Exception ex) {
            logger.info("\u63a5\u53e3\u8c03\u7528\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + ex.getMessage());
            result = false;
        }
        return result;
    }

    public static void updateSendTicketStatus(DynamicObject saleReturn) {
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)saleReturn, (String)"sourcebillid");
        if (sourceBillId > 0L) {
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_saleorder");
            QFilter qFilter = new QFilter("giftbillno", "=", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno"));
            DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType("ocdbd_ticketinfo");
            DynamicObjectCollection docTicket = QueryServiceHelper.query((String)"ocdbd_ticketinfo", (String)"id", (QFilter[])qFilter.toArray());
            if (docTicket == null || docTicket.size() == 0) {
                return;
            }
            ArrayList<Object> lstIds = new ArrayList<Object>(0);
            for (DynamicObject dynamicObject : docTicket) {
                Object o = DynamicObjectUtils.get((DynamicObject)dynamicObject, (String)"id");
                lstIds.add(o);
            }
            if (lstIds.size() > 0) {
                DynamicObject[] tickets = BusinessDataServiceHelper.load((Object[])lstIds.toArray(), (DynamicObjectType)type);
                if (tickets == null || tickets.length == 0) {
                    return;
                }
                for (DynamicObject ticket : tickets) {
                    ticket.set("ticketstatus", (Object)TicketStatusEnum.NO_MAKE.getName());
                    ticket.set("vipid", null);
                }
                SaveServiceHelper.update((DynamicObject[])tickets);
            }
        }
    }
}

