/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import java.math.BigDecimal;
import java.util.Comparator;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.common.entity.MaterialEntity;
import kd.occ.ocpos.common.entity.PlanEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.entity.request.ResMultiPromotionEntity;
import kd.occ.ocpos.common.util.promotion.BigDecimalUtil;
import kd.occ.ocpos.common.util.promotion.CommonUtils;

public class PromotionCalcHelper {
    public static List<ResMultiPromotionEntity> calcDiscount(List<PlanEntity> plans) {
        List<ResMultiPromotionEntity> resPromotionList = BuildParamHelper.buildPromotionResult(plans);
        PromotionCalcHelper.sortDiscount(resPromotionList);
        return resPromotionList;
    }

    public static void sortDiscount(List<ResMultiPromotionEntity> resPromotion) {
        CommonUtils.sortList((Comparator)new Comparator<ResMultiPromotionEntity>(){

            @Override
            public int compare(ResMultiPromotionEntity o1, ResMultiPromotionEntity o2) {
                return (int)BigDecimalUtil.subtract((BigDecimal)o1.getResPromotion().getResPromotionDetail().getDisAmount(), (BigDecimal)o2.getResPromotion().getResPromotionDetail().getDisAmount()).doubleValue();
            }
        }, resPromotion);
    }

    public static boolean filterWholeAmount(PlanEntity plan, MaterialEntryEntity matchMaterial, List<MaterialEntryEntity> materialEntryEntityList) {
        DynamicObject[] promotionRuleList = BuildParamHelper.selectPromoteRuleList(plan.getId());
        if (promotionRuleList.length == 0) {
            return false;
        }
        BigDecimal wholeAmount = BuildParamHelper.buildWholeAmount(plan.getItemRange(), matchMaterial, materialEntryEntityList);
        for (DynamicObject promotionRule : promotionRuleList) {
            BigDecimal promoteTargetAmount = promotionRule.getBigDecimal("targetamount");
            Boolean isControlQty = promotionRule.getBoolean("isqtycontrol");
            int minQty = promotionRule.getInt("minqty");
            if (promoteTargetAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
            if (promotionRule.getBoolean("iscontrolqty")) {
                int materialQty = BuildParamHelper.buildMaterialQty(plan, matchMaterial);
                int wholeNum = BuildParamHelper.buildWholeNum(plan.getItemRange(), matchMaterial, materialEntryEntityList);
                if (materialQty > 0) {
                    boolean isComparePrice = PromotionCalcHelper.comparePromotionPrice(matchMaterial, materialQty, promoteTargetAmount);
                    if (wholeNum < materialQty || !isComparePrice) continue;
                    plan.setPromoteRuleId(DynamicObjectUtils.getString((DynamicObject)promotionRule, (String)"id"));
                    return true;
                }
                plan.setPromoteRuleId(DynamicObjectUtils.getString((DynamicObject)promotionRule, (String)"id"));
                return true;
            }
            if (isControlQty.booleanValue()) {
                if (wholeAmount.compareTo(promoteTargetAmount) < 0 || BuildParamHelper.buildWholeNum(plan.getItemRange(), matchMaterial, materialEntryEntityList) < minQty) continue;
                return true;
            }
            if (wholeAmount.compareTo(promoteTargetAmount) < 0) continue;
            plan.setPromoteRuleId(DynamicObjectUtils.getString((DynamicObject)promotionRule, (String)"id"));
            return true;
        }
        return false;
    }

    public static boolean filterWholeNum(PlanEntity plan, MaterialEntryEntity matchMaterial, List<MaterialEntryEntity> materialEntryEntityList) {
        DynamicObject[] promotionRuleList = BuildParamHelper.selectPromoteRuleList(plan.getId());
        if (promotionRuleList.length == 0) {
            return false;
        }
        int wholeNum = BuildParamHelper.buildWholeNum(plan.getItemRange(), matchMaterial, materialEntryEntityList);
        for (DynamicObject promotionRule : promotionRuleList) {
            int materialQty;
            boolean isControlQty;
            if (promotionRule.getInt("targetqty") > 0 && wholeNum >= promotionRule.getInt("targetqty")) {
                plan.setPromoteRuleId(DynamicObjectUtils.getString((DynamicObject)promotionRule, (String)"id"));
                return true;
            }
            if (promotionRule.getInt("bindpickqty") > 0 && wholeNum >= promotionRule.getInt("bindpickqty")) {
                plan.setPromoteRuleId(DynamicObjectUtils.getString((DynamicObject)promotionRule, (String)"id"));
                return true;
            }
            DynamicObjectCollection subEntryList = promotionRule.getDynamicObjectCollection("subentryentity");
            if (subEntryList.size() > 0) {
                for (DynamicObject subEntry : subEntryList) {
                    if (wholeNum < subEntry.getInt("ladtargetqty")) continue;
                    plan.setPromoteRuleId(DynamicObjectUtils.getString((DynamicObject)promotionRule, (String)"id"));
                    return true;
                }
            }
            if ((isControlQty = DynamicObjectUtils.getBoolean((DynamicObject)promotionRule, (String)"iscontrolqty")) && (materialQty = BuildParamHelper.buildMaterialQty(plan, matchMaterial)) >= 0 && wholeNum >= materialQty) {
                plan.setPromoteRuleId(DynamicObjectUtils.getString((DynamicObject)promotionRule, (String)"id"));
                return true;
            }
            if (!PromotionEnum.pointPromotion().contains(plan.getTypeName())) continue;
            List materialEntityList = plan.getMaterialEntityList();
            for (MaterialEntity materialEntity : materialEntityList) {
                if (!StringUtils.equals((CharSequence)String.valueOf(materialEntity.getObjectId()), (CharSequence)matchMaterial.getMaterialId()) || matchMaterial.getQty().compareTo(new BigDecimal(materialEntity.getQty())) < 0) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean comparePromotionPrice(MaterialEntryEntity matchMaterial, int materialQty, BigDecimal promoteTargetAmount) {
        BigDecimal promotionPrice = promoteTargetAmount.divide(new BigDecimal(materialQty), 2);
        return promotionPrice.compareTo(matchMaterial.getRetailPrice()) <= 0;
    }
}

