/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocpos.common.entity.MemberEntity;
import kd.occ.ocpos.common.entity.PlanEntity;
import kd.occ.ocpos.common.entity.StoreEntity;
import kd.occ.ocpos.common.entity.TimeScopeEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.enums.promotion.ApplyMaterialScopeEnum;
import kd.occ.ocpos.common.result.PlanResult;
import kd.occ.ocpos.common.util.promotion.CommonUtils;
import kd.occ.ocpos.common.util.promotion.DateFormatUtils;
import kd.occ.ocpos.common.util.promotion.LoggerInfo;

public class PromotionFilterHelper {
    public static PlanResult matchPlanParam(PlanEntity plan, String billDate, String storeId, String memberId, String memberLeveId, List<String> memberLabelId, List<MaterialEntryEntity> materialList) {
        if (!PromotionFilterHelper.filterByBillDate(billDate, plan.getStartdate(), plan.getEnddate())) {
            CommonUtils.addNoHitLog((String)plan.getName(), (String)plan.getBillNo(), (String)"\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4");
            return new PlanResult(false, "\u5f00\u59cb\u7ed3\u675f\u65f6\u95f4");
        }
        if (!PromotionFilterHelper.filterByMaterial(plan)) {
            CommonUtils.addNoHitLog((String)plan.getName(), (String)plan.getBillNo(), (String)"\u5546\u54c1\u6e05\u5355");
            return new PlanResult(false, "\u5546\u54c1\u6e05\u5355");
        }
        if (!PromotionFilterHelper.filterPlanByShop(storeId, plan)) {
            CommonUtils.addNoHitLog((String)plan.getName(), (String)plan.getBillNo(), (String)"\u9002\u7528\u95e8\u5e97");
            return new PlanResult(false, "\u9002\u7528\u95e8\u5e97");
        }
        if (!PromotionFilterHelper.filterByMember(memberId, memberLeveId, memberLabelId, plan)) {
            CommonUtils.addNoHitLog((String)plan.getName(), (String)plan.getBillNo(), (String)"\u9002\u7528\u4f1a\u5458");
            return new PlanResult(false, "\u9002\u7528\u4f1a\u5458");
        }
        if (!PromotionFilterHelper.filterPlanByApplyDate(billDate, plan)) {
            CommonUtils.addNoHitLog((String)plan.getName(), (String)plan.getBillNo(), (String)"\u9002\u7528\u65e5\u671f");
            return new PlanResult(false, "\u9002\u7528\u65e5\u671f");
        }
        if (materialList != null && !PromotionFilterHelper.filterPlanByIsChangePrice(plan, materialList)) {
            CommonUtils.addNoHitLog((String)plan.getName(), (String)plan.getBillNo(), (String)"\u624b\u5de5\u6539\u4ef7");
            return new PlanResult(false, "\u624b\u5de5\u6539\u4ef7");
        }
        return new PlanResult(true, "");
    }

    public static boolean filterByMaterial(PlanEntity plan) {
        List materialEntityList = plan.getMaterialEntityList();
        if (plan.getApplyMaterialScope() != ApplyMaterialScopeEnum.AllMaterial && materialEntityList.isEmpty()) {
            LoggerInfo.info((String)"\u9002\u7528\u5546\u54c1\u8303\u56f4\u975e\u5168\u90e8\uff0c\u5546\u54c1\u6e05\u5355\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
            return false;
        }
        return true;
    }

    public static boolean filterByBillDate(String billDate, String startDate, String endDate) {
        if (StringUtils.isEmpty((CharSequence)startDate) || StringUtils.isEmpty((CharSequence)endDate)) {
            return false;
        }
        Date startTime = DateFormatUtils.formatStringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)startDate);
        Date endTime = DateFormatUtils.formatStringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)endDate);
        Date billTime = DateFormatUtils.formatStringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)billDate);
        return !startTime.after(billTime) && !PromotionFilterHelper.getEndOfDay(endTime).before(billTime);
    }

    private static boolean filterPlanByShop(String storeId, PlanEntity plan) {
        switch (plan.getApplyShopType()) {
            case "A": {
                return true;
            }
            case "B": {
                for (StoreEntity stroe : plan.getStoreEntityList()) {
                    if (!storeId.equals(stroe.getStoreId()) || !stroe.isExecuted()) continue;
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    public static boolean filterByMember(String memberId, String memberLevelId, List<String> memberLabelId, PlanEntity plan) {
        String memberScopeEnum;
        switch (memberScopeEnum = plan.getApplyMemberType().getCode()) {
            case "1": {
                if (StringUtils.isEmpty((CharSequence)memberId)) break;
                return true;
            }
            case "2": {
                if (!StringUtils.isEmpty((CharSequence)memberId)) break;
                return true;
            }
            case "3": {
                if (!PromotionFilterHelper.specificMember(memberId, memberLevelId, memberLabelId, plan)) break;
                return true;
            }
            default: {
                LoggerInfo.info((String)"\u6d3b\u52a8\u9002\u7528\u4f1a\u5458\u7c7b\u578b\u9519\u8bef", (String[])new String[]{plan.getId() + plan.getName()});
            }
        }
        return false;
    }

    public static boolean specificMember(String memberId, String memberLevelId, List<String> memberLabelIdList, PlanEntity plan) {
        block4: for (MemberEntity member : plan.getMemberEntityList()) {
            switch (member.getType()) {
                case Member: {
                    if (!CommonUtils.isEqualObjId((String)memberId, (String)member.getMemberId())) continue block4;
                    return true;
                }
                case MemberLevel: {
                    if (!CommonUtils.isEqualObjId((String)memberLevelId, (String)member.getMemberId())) continue block4;
                    return true;
                }
            }
            LoggerInfo.info((String)"\u6d3b\u52a8\u9002\u7528\u4f1a\u5458\u7c7b\u578b\u9519\u8bef", (String[])new String[]{plan.getId() + plan.getName()});
        }
        return false;
    }

    public static boolean filterPlanByApplyDate(String billDate, PlanEntity plan) {
        Date date = DateFormatUtils.formatStringToDate((String)"yyyy-MM-dd HH:mm:ss", (String)billDate);
        int applyDateType = plan.getApplyDateType();
        int applyTimeRange = plan.getApplyTimeRange();
        if (applyDateType == 1) {
            if (applyTimeRange == 1) {
                return true;
            }
            if (applyTimeRange == 2) {
                return PromotionFilterHelper.checkTimeRange(date, plan);
            }
        } else {
            List scopeList = plan.getTimeScopeList();
            for (TimeScopeEntity timeScopeEntity : scopeList) {
                if (StringUtils.isEmpty((CharSequence)timeScopeEntity.getDateText()) || timeScopeEntity.getTimeScopeEnum() == null) {
                    LoggerInfo.info((String)"\u9002\u7528\u65f6\u6bb5\u9519\u8bef", (String[])new String[]{plan.getId() + plan.getName()});
                }
                String dateText = timeScopeEntity.getDateText();
                switch (timeScopeEntity.getTimeScopeEnum().getCode()) {
                    case "1": {
                        String onlyWeek;
                        Calendar cld = Calendar.getInstance();
                        cld.setTime(date);
                        String string = onlyWeek = cld.get(4) % 2 == 0 ? "\u4ec5\u53cc\u5468" : "\u4ec5\u5355\u5468";
                        return applyTimeRange == 2 ? StringUtils.equals((CharSequence)onlyWeek, (CharSequence)dateText) && PromotionFilterHelper.checkTimeRange(date, plan) : StringUtils.equals((CharSequence)onlyWeek, (CharSequence)dateText);
                    }
                    case "2": {
                        String week = DateFormatUtils.getWeekOfDate((Date)date);
                        return applyTimeRange == 2 ? dateText.contains(week) && PromotionFilterHelper.checkTimeRange(date, plan) : dateText.contains(week);
                    }
                    case "3": {
                        boolean dateRange;
                        Date dayDate = DateFormatUtils.formatStringToDate((String)"yyyy-MM-dd", (String)billDate);
                        String startDateString = dateText.substring(dateText.indexOf(58) + 2, dateText.indexOf(45));
                        String endDateString = dateText.substring(dateText.indexOf(45) + 1);
                        Date startDate = DateFormatUtils.formatStringToDate((String)"yyyyMMdd", (String)startDateString);
                        Date endDate = DateFormatUtils.formatStringToDate((String)"yyyyMMdd", (String)endDateString);
                        boolean bl = dateRange = !startDate.after(dayDate) && !endDate.before(dayDate);
                        return applyTimeRange == 2 ? dateRange && PromotionFilterHelper.checkTimeRange(date, plan) : dateRange;
                    }
                    case "4": {
                        boolean checkRange;
                        String startDayString = dateText.substring(dateText.indexOf(26376) + 1, dateText.indexOf(26085));
                        String endDayString = dateText.substring(dateText.indexOf(33267) + 1, dateText.lastIndexOf(26085));
                        int billDay = Integer.parseInt(billDate.substring(8, 10));
                        boolean bl = checkRange = billDay >= Integer.parseInt(startDayString) && billDay <= Integer.parseInt(endDayString);
                        return applyTimeRange == 2 ? checkRange && PromotionFilterHelper.checkTimeRange(date, plan) : checkRange;
                    }
                }
                LoggerInfo.info((String)"\u6d3b\u52a8\u65f6\u95f4\u7c7b\u578b\u9519\u8bef", (String[])new String[]{plan.getId() + plan.getName()});
            }
        }
        return false;
    }

    public static boolean filterPlanByIsChangePrice(PlanEntity plan, List<MaterialEntryEntity> materialEntityList) {
        for (MaterialEntryEntity materialEntryEntity : materialEntityList) {
            if (!materialEntryEntity.isChangePrice() || plan.isMatchChangePrice()) continue;
            return false;
        }
        return true;
    }

    public static boolean checkTimeRange(Date date, PlanEntity plan) {
        SimpleDateFormat hhMmSs = new SimpleDateFormat("HH:mm:ss");
        String effectiveTime = DateFormatUtils.getGapTime((long)plan.getEffectiveTime());
        String expirationTime = DateFormatUtils.getGapTime((long)plan.getExpirationTime());
        if (StringUtils.isEmpty((CharSequence)effectiveTime) || StringUtils.isEmpty((CharSequence)expirationTime)) {
            return false;
        }
        Date effective = DateFormatUtils.formatStringToDate((String)"HH:mm:ss", (String)effectiveTime);
        Date expiration = DateFormatUtils.formatStringToDate((String)"HH:mm:ss", (String)expirationTime);
        Date nowTime = DateFormatUtils.formatStringToDate((String)"HH:mm:ss", (String)hhMmSs.format(date));
        return nowTime.after(effective) && nowTime.before(expiration);
    }

    public static Date getEndOfDay(Date date) {
        Calendar calendarEnd = Calendar.getInstance();
        calendarEnd.setTime(date);
        calendarEnd.set(11, 23);
        calendarEnd.set(12, 59);
        calendarEnd.set(13, 59);
        calendarEnd.set(14, 0);
        return calendarEnd.getTime();
    }
}

