/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.ItemClassNodeUtil;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.business.promotion.PromotionCalcHelper;
import kd.occ.ocpos.business.promotion.PromotionFilterHelper;
import kd.occ.ocpos.business.promotion.SimplePromotionHelper;
import kd.occ.ocpos.business.promotion.WholePromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.common.entity.PlanEntity;
import kd.occ.ocpos.common.entity.StopWatchEntity;
import kd.occ.ocpos.common.entity.UnMatchPlansEntity;
import kd.occ.ocpos.common.entity.request.CxRequestEntity;
import kd.occ.ocpos.common.entity.request.CxResultEntity;
import kd.occ.ocpos.common.entity.request.LadRequestEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.entity.request.ResMultiPromotionEntity;
import kd.occ.ocpos.common.entity.request.ResPromotionEntity;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.result.AllPlanResult;
import kd.occ.ocpos.common.result.FilterPlanResult;
import kd.occ.ocpos.common.result.PlanResult;
import kd.occ.ocpos.common.util.CloneUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import kd.occ.ocpos.common.util.promotion.CommonUtils;
import kd.occ.ocpos.common.util.promotion.LoggerInfo;

public class SaleorderPromotionHelper {
    private static final Log logger = LogFactory.getLog(SaleorderPromotionHelper.class);

    public static CxResultEntity matchPromotion(CxRequestEntity originReq) {
        SaleorderPromotionHelper.check(originReq);
        CxRequestEntity req = (CxRequestEntity)CloneUtil.deepClone((Object)originReq);
        StopWatchEntity sw = StopWatchEntity.startStopWatch((String)"\u4fc3\u9500\u8017\u65f6");
        FilterPlanResult filterPlanResult = SaleorderPromotionHelper.calcValidPlans(req, sw);
        List plans = filterPlanResult.getPlanEntityList();
        List unMatched = filterPlanResult.getUnMatchPlansList();
        sw.addPoint("\u8fc7\u6ee4\u5e76\u8ba1\u7b97\u4f18\u60e0\u6761\u4ef6", sw);
        if (plans.size() > 0) {
            StringBuilder planStr = new StringBuilder("\u547d\u4e2d\u7684\u4fc3\u9500\u65b9\u6848\uff1a");
            for (Object planEntity : plans) {
                planStr.append(String.format(" %s: %s", planEntity.getBillNo(), planEntity.getName()));
            }
            logger.info(planStr.toString());
            StringBuilder unPlanStr = new StringBuilder("\u672a\u547d\u4e2d\u7684\u4fc3\u9500\u65b9\u6848\uff1a");
            for (UnMatchPlansEntity unMatchPlansEntity : unMatched) {
                unPlanStr.append(String.format(" %s :%s :%s", unMatchPlansEntity.getBillNo(), unMatchPlansEntity.getName(), unMatchPlansEntity.getErrMsg()));
            }
            logger.info(unPlanStr.toString());
        } else if (unMatched.size() > 0) {
            StringBuilder unPlanStr = new StringBuilder("\u672a\u547d\u4e2d\u7684\u4fc3\u9500\u65b9\u6848\uff1a");
            for (UnMatchPlansEntity unMatchPlansEntity : unMatched) {
                unPlanStr.append(String.format(" %s :%s :%s", unMatchPlansEntity.getBillNo(), unMatchPlansEntity.getName(), unMatchPlansEntity.getErrMsg()));
            }
            logger.info(unPlanStr.toString());
        } else {
            logger.info("\u6ca1\u6709\u547d\u4e2d\u4efb\u4f55\u4fc3\u9500\u65b9\u6848");
        }
        List<ResMultiPromotionEntity> materialsEntryDiscount = PromotionCalcHelper.calcDiscount(plans);
        sw.addPoint("\u8ba1\u7b97\u4f18\u60e0\u7ed3\u679c", sw);
        LoggerInfo.info((String)sw.print(sw), (String[])new String[0]);
        return new CxResultEntity(materialsEntryDiscount, unMatched);
    }

    public static FilterPlanResult calcValidPlans(CxRequestEntity req, StopWatchEntity sw) {
        List<PlanEntity> origPlans = SaleorderPromotionHelper.getAllPlan(req, sw);
        return SaleorderPromotionHelper.filterPlan(origPlans, req);
    }

    public static List<PlanEntity> getAllPlan(CxRequestEntity req, StopWatchEntity sw) {
        if (sw != null) {
            sw.addPoint("\u5f00\u59cb\u67e5\u8be2\u7f13\u5b58", sw);
        }
        QFilter filter = new QFilter("billstatus", "=", (Object)"C");
        filter.and(new QFilter("promotestatus", "=", (Object)"B"));
        filter.and(new QFilter("isofflinestoreprom", "=", (Object)Boolean.TRUE));
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdpm_promote");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        DynamicObject[] promotionList = BusinessDataServiceHelper.load((String)"ocdpm_promote", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray());
        if (promotionList.length == 0) {
            System.out.print("\u672a\u5339\u914d\u5230\u4fc3\u9500\u65b9\u6848");
            return null;
        }
        List<PlanEntity> planList = BuildParamHelper.buildPlanEntity(promotionList);
        AllPlanResult allPlan = new AllPlanResult(planList, null);
        List plans = allPlan.getPlanEntityList();
        if (sw != null) {
            sw.addPoint("\u5b8c\u6210\u67e5\u8be2\u7f13\u5b58", sw);
        }
        return plans;
    }

    public static FilterPlanResult filterPlan(List<PlanEntity> planList, CxRequestEntity req) {
        ArrayList<PlanEntity> results = new ArrayList<PlanEntity>();
        ArrayList<UnMatchPlansEntity> unMatchResults = new ArrayList<UnMatchPlansEntity>();
        if (planList == null || planList.size() == 0) {
            LoggerInfo.info((String)"\u672a\u5339\u914d\u5230\u4fc3\u9500\u65b9\u6848", (String[])new String[0]);
            return new FilterPlanResult(results, unMatchResults);
        }
        for (PlanEntity plan : planList) {
            PlanResult planResult = PromotionFilterHelper.matchPlanParam(plan, req.getBillDate(), req.getStoreId(), req.getMemberId(), req.getMemberLevelId(), req.getMemberLabelId(), req.getMaterialEntries());
            String msg = planResult.getMsg();
            if (planResult.isResult()) {
                UnMatchPlansEntity unMatchPlanResult = PromotionEnum.wholePromotion().contains(plan.getTypeName()) ? WholePromotionHelper.matchWholePlan(req, plan) : SimplePromotionHelper.matchSimplePlan(req, plan);
                if (unMatchPlanResult == null) {
                    results.add(plan);
                    continue;
                }
                unMatchResults.add(unMatchPlanResult);
                continue;
            }
            msg = msg + "\u4e0d\u6ee1\u8db3";
            unMatchResults.add(BuildParamHelper.buildUnMatch(plan, msg));
        }
        return new FilterPlanResult(results, unMatchResults);
    }

    public static void setPromotionInfo(IFormView view, List<ResMultiPromotionEntity> resMultiPromotionEntityList) {
        for (ResMultiPromotionEntity resMultiPromotionEntity : resMultiPromotionEntityList) {
            List promotionEntityList = resMultiPromotionEntity.getPromotions();
            DynamicObjectCollection saleorderPromotionList = view.getModel().getDataEntity(true).getDynamicObjectCollection("promotionentity");
            HashMap<String, Integer> promotionIdMap = new HashMap<String, Integer>();
            for (int i = 0; i < saleorderPromotionList.size(); ++i) {
                DynamicObject promotion = (DynamicObject)saleorderPromotionList.get(i);
                String promotionId = promotion.getString("promotionid");
                if (promotionIdMap.containsKey(promotionId)) continue;
                promotionIdMap.put(promotionId, i);
            }
            for (ResPromotionEntity resPromotionEntity : promotionEntityList) {
                BuildParamHelper.buildSaleOrderPromotion(resPromotionEntity, saleorderPromotionList, promotionIdMap);
            }
        }
        view.updateView("promotionentity");
    }

    public static void afterDeleteRowReMatchPromoteRule(IFormView view, int[] deleteIndexs) {
        if (!StringUtils.equals((CharSequence)"ocpos_saleorder", (CharSequence)view.getEntityId())) {
            return;
        }
        DynamicObject currentBill = view.getModel().getDataEntity(true);
        DynamicObjectCollection saleOrderGoodList = currentBill.getDynamicObjectCollection("goodsentryentity");
        DynamicObjectCollection saleOrderPromotionList = currentBill.getDynamicObjectCollection("promotionentity");
        if (saleOrderGoodList.size() == 0) {
            saleOrderPromotionList.clear();
            view.updateView("promotionentity");
            return;
        }
        List<Integer> reMatchIndex = BuildParamHelper.buildAfterDeletePromotion(saleOrderGoodList, saleOrderPromotionList, deleteIndexs);
        if (reMatchIndex.size() > 0) {
            for (Integer index : reMatchIndex) {
                BuildParamHelper.matchItemPromotion(view, saleOrderGoodList, index);
            }
        }
        view.updateView("promotionentity");
    }

    public static void clearUnMatchPromotion(IFormView view, List<UnMatchPlansEntity> unMatchPlan) {
        DynamicObject currentBill = view.getModel().getDataEntity(true);
        DynamicObjectCollection saleOrderPromotionList = currentBill.getDynamicObjectCollection("promotionentity");
        if (saleOrderPromotionList.size() > 0) {
            for (UnMatchPlansEntity unMatchPlansEntity : unMatchPlan) {
                Iterator iterator = saleOrderPromotionList.iterator();
                while (iterator.hasNext()) {
                    DynamicObject saleOrderPromotion = (DynamicObject)iterator.next();
                    String[] goodSeq = saleOrderPromotion.getString("promotiongoodseq").split(",");
                    ArrayList goodSeqList = new ArrayList();
                    Collections.addAll(goodSeqList, goodSeq);
                    if (!unMatchPlansEntity.getId().equals(saleOrderPromotion.getString("promotionid"))) continue;
                    iterator.remove();
                }
            }
        }
        view.updateView("promotionentity");
    }

    public static void check(CxRequestEntity req) {
        if (req.getMaterialEntries().size() == 0) {
            LoggerInfo.info((String)"\u5546\u54c1\u5206\u5f55\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        }
        if (CommonUtils.isEmpty((String)req.getBillDate())) {
            LoggerInfo.info((String)"\u5355\u636e\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        }
        if (req.isMember() && CommonUtils.isEmpty((String)req.getMemberId())) {
            LoggerInfo.info((String)"\u4f1a\u5458id\u4e0d\u80fd\u4e3a\u7a7a", (String[])new String[0]);
        }
        List materialList = req.getMaterialEntries();
        HashMap entryIdMap = new HashMap(0);
        for (MaterialEntryEntity m : materialList) {
            if (entryIdMap.containsKey(m.getEntryId())) {
                LoggerInfo.info((String)String.format("\u5546\u54c1\u5206\u5f55id\u91cd\u590d\uff0c\u91cd\u590d\u7684entryId=%d", m.getEntryId()), (String[])new String[0]);
            }
            entryIdMap.put(m.getEntryId(), null);
        }
    }

    public static DynamicObject matchLadPromotion(LadRequestEntity req, BigDecimal sumQty, BigDecimal sumGoodsAmount) {
        DynamicObject matchPromotionRule = null;
        DynamicObject promotion = req.getPromotion();
        DynamicObject[] promotionRuleList = BuildParamHelper.selectPromoteRuleList(promotion.getString("id"));
        if (promotionRuleList == null || promotionRuleList.length == 0) {
            return null;
        }
        for (DynamicObject promotionRule : promotionRuleList) {
            Boolean isControlQty = promotionRule.getBoolean("isqtycontrol");
            BigDecimal minQty = promotionRule.getBigDecimal("minqty");
            if (isControlQty.booleanValue()) {
                if (!PromotionEnum.amountPromotion().contains(req.getPromotionType().getPromoteType()) || sumGoodsAmount.compareTo(promotionRule.getBigDecimal("targetamount")) < 0 || sumQty.compareTo(minQty) < 0) continue;
                matchPromotionRule = promotionRule;
                continue;
            }
            if (PromotionEnum.amountPromotion().contains(req.getPromotionType().getPromoteType()) && sumGoodsAmount.compareTo(promotionRule.getBigDecimal("targetamount")) >= 0) {
                matchPromotionRule = promotionRule;
            }
            if (!PromotionEnum.qtyPromotion().contains(req.getPromotionType().getPromoteType()) || sumQty.compareTo(promotionRule.getBigDecimal("targetqty")) < 0) continue;
            matchPromotionRule = promotionRule;
        }
        return matchPromotionRule;
    }

    public static DynamicObject getPromoteRule(DynamicObject doPromote, String promoteType, DynamicObject doPromoteRule, DynamicObject doGoodsEntry, DynamicObjectCollection docGoodsEntry, String[] goodsSeqArray, Map<String, BigDecimal> mapQtyAmount) {
        LadRequestEntity ladRequestEntity = new LadRequestEntity();
        ladRequestEntity.setPromotion(doPromote);
        ladRequestEntity.setPromotionType(PromotionEnum.getPromotionEnum((String)promoteType));
        String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
        boolean isControlQty = DynamicObjectUtils.getBoolean((DynamicObject)doPromoteRule, (String)"iscontrolqty");
        BigDecimal sumQty = BigDecimal.ZERO;
        BigDecimal sumGoodsAmount = BigDecimal.ZERO;
        if (mapQtyAmount.size() == 0) {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                List<DynamicObject> lstGoodsEntry = SaleorderPromotionHelper.getSameGoodsList(doGoodsEntry, goodsSeqArray, docGoodsEntry);
                if (!CollectionUtils.isEmpty(lstGoodsEntry)) {
                    DynamicObject itemEntry;
                    BigDecimal qty;
                    for (DynamicObject x : lstGoodsEntry) {
                        sumQty = sumQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)x, (String)"saleqty"));
                        sumGoodsAmount = sumGoodsAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)x, (String)"balamount"));
                    }
                    if (isControlQty && (qty = DynamicObjectUtils.getBigDecimal((DynamicObject)(itemEntry = SaleorderPromotionHelper.matchMaterial(doPromoteRule, doGoodsEntry)), (String)"qty")).compareTo(BigDecimal.ZERO) > 0) {
                        sumGoodsAmount = sumGoodsAmount.divide(sumQty, 2, RoundingMode.HALF_UP).multiply(qty);
                    }
                }
            } else {
                sumQty = SaleorderPromotionHelper.getSumQty(goodsSeqArray, docGoodsEntry);
                sumGoodsAmount = SaleorderPromotionHelper.getGoodsAmount(goodsSeqArray, docGoodsEntry);
            }
            mapQtyAmount.put("saleqty", sumQty);
            mapQtyAmount.put("amount", sumGoodsAmount);
        } else {
            sumQty = mapQtyAmount.getOrDefault("saleqty", BigDecimal.ZERO);
            sumGoodsAmount = mapQtyAmount.getOrDefault("amount", BigDecimal.ZERO);
        }
        return SaleorderPromotionHelper.matchLadPromotion(ladRequestEntity, sumQty, sumGoodsAmount);
    }

    private static DynamicObject matchMaterial(DynamicObject doPromoteRule, DynamicObject doGoodsEntry) {
        Object itemClassId = null;
        DynamicObjectCollection docItemEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doPromoteRule, (String)"itementry");
        long goodId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid");
        long brandId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand");
        long goodsClassId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsclass");
        block12: for (DynamicObject doItemEntry : docItemEntry) {
            String matchType = DynamicObjectUtils.getString((DynamicObject)doItemEntry, (String)"type");
            long goodsBrandId = DynamicObjectUtils.getPkValue((DynamicObject)doItemEntry, (String)"brandid");
            DynamicObject itemClass = DynamicObjectUtils.getDynamicObject((DynamicObject)doItemEntry, (String)"itemclassid");
            if (itemClass != null) {
                itemClassId = itemClass.getPkValue();
            }
            Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet<Long>(Collections.singleton(goodsClassId)));
            switch (matchType) {
                case "1": {
                    long itemId = DynamicObjectUtils.getPkValue((DynamicObject)doItemEntry, (String)"itemid");
                    if (goodId == itemId) break;
                    continue block12;
                }
                case "2": {
                    if (classIds.contains(itemClassId)) break;
                    continue block12;
                }
                case "3": {
                    if (brandId == goodsBrandId) break;
                    continue block12;
                }
                case "5": {
                    if ((goodsBrandId <= 0L || brandId == goodsBrandId) && (CommonUtil.formatObejctToLong((Object)itemClassId) <= 0L || classIds.contains(itemClassId))) break;
                    continue block12;
                }
                default: {
                    continue block12;
                }
            }
            return doItemEntry;
        }
        return null;
    }

    public static void executePromotionCalcRule(DynamicObject saleOrder) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        if (billTypeId == BillTypeEnum.CHANGE.getId() || billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            DynamicObjectCollection docPromote;
            String saleOption = DynamicObjectUtil.getString((DynamicObject)doGoodsEntry, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || CollectionUtils.isEmpty((Collection)(docPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote")))) continue;
            docPromote.removeIf(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"promotegoodsid") == 0L);
            if (doGoodsEntry.getBigDecimal("promotiondiscount").compareTo(BigDecimal.ZERO) == 0) continue;
            Map<String, BigDecimal> result = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "promotiondiscount", BigDecimal.ZERO, false);
            SaleAmountHelper.setData(result, doGoodsEntry);
        }
        DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"promotionentity");
        if (CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
            return;
        }
        List lstPromoteEntry = docPromoteEntry.stream().filter(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"execute")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(lstPromoteEntry)) {
            lstPromoteEntry.sort(Comparator.comparingInt(o -> DynamicObjectUtils.getInt((DynamicObject)o, (String)"priority")));
            String promDiscMLWay = SystemParamUtil.getPromDiscMLWay((long)orgId, (long)branchId);
            for (DynamicObject doPromoteEntry : lstPromoteEntry) {
                String promoteGoodSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
                long promotionId = DynamicObjectUtils.getLong((DynamicObject)doPromoteEntry, (String)"promotionid");
                long promoteRuleId = DynamicObjectUtils.getLong((DynamicObject)doPromoteEntry, (String)"promoteruleid");
                DynamicObject doPromoteType = DynamicObjectUtils.getDynamicObject((DynamicObject)doPromoteEntry, (String)"promotiontype");
                if (ObjectUtils.isEmpty((Object)doPromoteType)) continue;
                String promoteType = DynamicObjectUtils.getString((DynamicObject)doPromoteType, (String)"number");
                if (StringUtils.isEmpty((CharSequence)promoteGoodSeq) || StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-031") || StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-006")) continue;
                DynamicObject doPromote = BusinessDataServiceHelper.loadSingle((Object)promotionId, (String)"ocdpm_promote");
                DynamicObject doPromoteRule = null;
                if (promoteRuleId > 0L) {
                    doPromoteRule = BusinessDataServiceHelper.loadSingle((Object)promoteRuleId, (String)"ocdpm_promote_rule");
                }
                String[] goodsSeqArray = promoteGoodSeq.split(",");
                SaleorderPromotionHelper.doPromotionItem(promoteType, doPromote, doPromoteEntry, doPromoteRule, docGoodsEntry, goodsSeqArray, promDiscMLWay);
            }
        }
    }

    public static void doPromotionItem(String promoteType, DynamicObject doPromote, DynamicObject doPromoteEntry, DynamicObject doPromoteRule, DynamicObjectCollection docGoodsEntry, String[] goodsSeqArray, String promDiscMLWay) {
        HashMap<String, BigDecimal> mapGoodsEntry = new HashMap<String, BigDecimal>(0);
        HashMap<String, BigDecimal> mapQtyAmount = new HashMap<String, BigDecimal>(0);
        block24: for (String goodsSeq : goodsSeqArray) {
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)goodsSeq, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)doGoodsEntry)) continue;
            if (!PromotionEnum.noLadPromotion().contains(promoteType)) {
                doPromoteRule = SaleorderPromotionHelper.getPromoteRule(doPromote, promoteType, doPromoteRule, doGoodsEntry, docGoodsEntry, goodsSeqArray, mapQtyAmount);
            }
            switch (promoteType) {
                case "PM-002": 
                case "PM-038": {
                    SaleorderPromotionHelper.doPointAmt(promoteType, doPromote, doGoodsEntry, doPromoteEntry, doPromoteRule);
                    continue block24;
                }
                case "PM-026": 
                case "PM-036": {
                    SaleorderPromotionHelper.doPointDisc(promoteType, doPromote, doGoodsEntry, doPromoteEntry, doPromoteRule);
                    continue block24;
                }
                case "PM-004": 
                case "PM-005": {
                    SaleorderPromotionHelper.doBindReduceAmount(promoteType, doGoodsEntry, doPromoteEntry, docGoodsEntry, doPromoteRule, mapGoodsEntry);
                    continue block24;
                }
                case "PM-034": 
                case "PM-023": 
                case "PM-039": {
                    SaleorderPromotionHelper.doPiecesGift(promoteType, doGoodsEntry, docGoodsEntry, doPromoteEntry, doPromoteRule);
                    continue block24;
                }
                case "PM-035": 
                case "PM-025": 
                case "PM-037": {
                    SaleorderPromotionHelper.doAmtTicket(promoteType, doGoodsEntry, docGoodsEntry, doPromoteEntry, doPromoteRule);
                    continue block24;
                }
                case "PM-028": 
                case "PM-029": {
                    SaleorderPromotionHelper.doFullAmtOrDisc(promoteType, doGoodsEntry, doPromoteEntry, docGoodsEntry, doPromoteRule, mapGoodsEntry, promDiscMLWay);
                    continue block24;
                }
            }
        }
    }

    public static void doFullAmtOrDisc(String promoteType, DynamicObject doGoodsEntry, DynamicObject doPromoteEntry, DynamicObjectCollection docGoodsEntry, DynamicObject doPromoteRule, Map<String, BigDecimal> mapGoodsEntry, String promDiscMLWay) {
        BigDecimal lineReductionAmount;
        String promoteGoodSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
        BigDecimal receivableAmount = BigDecimal.ZERO;
        String[] goodsSeqArray = promoteGoodSeq.split(",");
        if (mapGoodsEntry.size() == 0) {
            if (goodsSeqArray.length > 0) {
                for (String seqI : goodsSeqArray) {
                    DynamicObject doGoods = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seqI, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doGoods)) continue;
                    receivableAmount = receivableAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoods, (String)"balamount"));
                }
            }
            mapGoodsEntry.put("amount", receivableAmount);
        } else {
            receivableAmount = mapGoodsEntry.getOrDefault("amount", BigDecimal.ZERO);
        }
        BigDecimal reductionDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"discount");
        BigDecimal reductionAmount = reductionDiscount.compareTo(BigDecimal.ZERO) > 0 ? receivableAmount.subtract(receivableAmount.multiply(reductionDiscount).divide(new BigDecimal(10), 4)) : DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"reductionamount");
        if (reductionAmount.compareTo(BigDecimal.ZERO) <= 0) {
            logger.info("\u6574\u5355\u6ee1\u51cf\u91d1\u989d/\u6574\u5355\u4e70\u6ee1\u6253\u6298,\u65b9\u6cd5\u540d\uff1adoFullAmtOrDisc,\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u4fc3\u9500\u89c4\u5219\u7684\u6ee1\u51cf\u91d1\u989d\u6216\u6ee1\u51cf\u6298\u6263\u3002");
            return;
        }
        String goodsSeq = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq");
        if (StringUtils.isEmpty((CharSequence)promoteGoodSeq)) {
            return;
        }
        BigDecimal promotionDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"promotiondiscount");
        BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
        String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
        if (StringUtils.equals((CharSequence)goodsSeq, (CharSequence)goodsSeqArray[goodsSeqArray.length - 1])) {
            if (goodsSeqArray.length > 1) {
                BigDecimal adBalAmount = BigDecimal.ZERO;
                for (int i = 0; i < goodsSeqArray.length - 1; ++i) {
                    String seqI = goodsSeqArray[i];
                    DynamicObject doGoods = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seqI, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doGoods)) continue;
                    adBalAmount = adBalAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoods, (String)"balamount"));
                }
                BigDecimal billAmount = receivableAmount.subtract(reductionAmount);
                lineReductionAmount = balAmount.subtract(billAmount.subtract(adBalAmount));
            } else {
                lineReductionAmount = reductionAmount;
            }
        } else {
            lineReductionAmount = balAmount.multiply(reductionAmount).divide(receivableAmount, 2, 4);
            if (StringUtils.equals((CharSequence)promDiscMLWay, (CharSequence)"C")) {
                lineReductionAmount = lineReductionAmount.setScale(0, 1);
            }
        }
        if (lineReductionAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Map<String, BigDecimal> amountResult = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "promotiondiscount", promotionDiscount.add(lineReductionAmount), false);
        SaleAmountHelper.setData(amountResult, doGoodsEntry);
        BigDecimal balPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
        BigDecimal rate = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountrate");
        SaleorderPromotionHelper.createPromoteRow(promoteType, doGoodsEntry, doPromoteEntry, balPrice, rate, itemGroup, promoteGoodSeq);
    }

    public static void doBindReduceAmount(String promoteType, DynamicObject doGoodsEntry, DynamicObject doPromoteEntry, DynamicObjectCollection docGoodsEntry, DynamicObject doPromoteRule, Map<String, BigDecimal> mapGoodsEntry) {
        BigDecimal bindReduceAmount;
        BigDecimal balPrice;
        String exeGoodsSeq = "";
        BigDecimal goodsAmount = BigDecimal.ZERO;
        String promoteGoodSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
        String goodsSeq = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq");
        if (StringUtils.isEmpty((CharSequence)promoteGoodSeq) || StringUtils.isEmpty((CharSequence)goodsSeq)) {
            return;
        }
        Object[] goodsSeqArray = promoteGoodSeq.split(",");
        BigDecimal bindPickQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"bindpickqty");
        BigDecimal pickQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"bindpickqty");
        String condition = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"condition");
        String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
        BigDecimal sumQty = BigDecimal.ZERO;
        if (mapGoodsEntry.size() == 0) {
            if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                List<DynamicObject> lstGoodsEntry = SaleorderPromotionHelper.getSameGoodsList(doGoodsEntry, (String[])goodsSeqArray, docGoodsEntry);
                if (CollectionUtils.isEmpty(lstGoodsEntry)) {
                    return;
                }
                Object[] lstGoodsSeq = new ArrayList(0);
                BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
                if (saleQty.compareTo(bindPickQty) >= 0) {
                    sumQty = saleQty;
                    lstGoodsSeq.add(goodsSeq);
                    goodsAmount = goodsAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount"));
                } else {
                    for (DynamicObject dynamicObject : lstGoodsEntry) {
                        sumQty = sumQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)dynamicObject, (String)"saleqty"));
                    }
                    for (DynamicObject dynamicObject : lstGoodsEntry) {
                        String seq = DynamicObjectUtils.getString((DynamicObject)dynamicObject, (String)"seq");
                        lstGoodsSeq.add(seq);
                        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)dynamicObject, (String)"saleqty");
                        if (pickQty.compareTo(qty) >= 0) {
                            goodsAmount = goodsAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)dynamicObject, (String)"balamount"));
                            pickQty = pickQty.subtract(qty);
                            continue;
                        }
                        balPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)dynamicObject, (String)"discountprice");
                        goodsAmount = goodsAmount.add(balPrice.multiply(pickQty));
                        break;
                    }
                }
                goodsSeqArray = lstGoodsSeq.toArray(new String[0]);
                exeGoodsSeq = StringUtils.join((Object[])goodsSeqArray, (char)',');
            } else {
                ArrayList<String> lstSeq = new ArrayList<String>(0);
                if (goodsSeqArray.length > 0) {
                    sumQty = SaleorderPromotionHelper.getSumQty((String[])goodsSeqArray, docGoodsEntry);
                    for (String string : goodsSeqArray) {
                        DynamicObject doGoods = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seqI, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
                        if (doGoods == null) continue;
                        if (!lstSeq.contains(string)) {
                            lstSeq.add(string);
                        }
                        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoods, (String)"saleqty");
                        if (pickQty.compareTo(BigDecimal.ZERO) <= 0) break;
                        if (saleQty.compareTo(pickQty) >= 0) {
                            goodsAmount = goodsAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoods, (String)"discountprice").multiply(pickQty));
                            pickQty = BigDecimal.ZERO;
                            continue;
                        }
                        goodsAmount = goodsAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoods, (String)"discountprice").multiply(saleQty));
                        pickQty = pickQty.subtract(saleQty);
                    }
                }
                exeGoodsSeq = StringUtils.join((Object[])lstSeq.toArray(), (char)',');
                mapGoodsEntry.put("saleqty", sumQty);
                mapGoodsEntry.put("amount", goodsAmount);
            }
        } else {
            sumQty = mapGoodsEntry.getOrDefault("saleqty", BigDecimal.ZERO);
            goodsAmount = mapGoodsEntry.getOrDefault("amount", BigDecimal.ZERO);
        }
        boolean isAd = false;
        BigDecimal drCount = BigDecimal.ZERO;
        if (sumQty.compareTo(BigDecimal.ZERO) > 0 && bindPickQty.compareTo(BigDecimal.ZERO) > 0) {
            drCount = sumQty.divideAndRemainder(bindPickQty)[0];
        }
        if (StringUtils.equals((CharSequence)"1", (CharSequence)condition) && drCount.compareTo(BigDecimal.ONE) > 0) {
            isAd = true;
        }
        if (StringUtils.equals((CharSequence)promoteType, (CharSequence)PromotionEnum.BINDPRICE.getPromoteType())) {
            BigDecimal bindTotalAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"bindtotalamount");
            if (bindTotalAmount.compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("\u6346\u7ed1\u7acb\u51cf\u3001\u6346\u7ed1\u603b\u91d1\u989d,\u65b9\u6cd5\u540d\uff1adoBindReduceAmount,\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u4fc3\u9500\u89c4\u5219\u7684\u6346\u7ed1\u7ec4\u5408\u603b\u91d1\u989d\u3002");
                return;
            }
            if (isAd) {
                goodsAmount = goodsAmount.multiply(drCount);
                bindTotalAmount = drCount.multiply(bindTotalAmount);
            }
            bindReduceAmount = goodsAmount.subtract(bindTotalAmount);
        } else {
            bindReduceAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"bindreduceamount");
            if (bindReduceAmount.compareTo(BigDecimal.ZERO) <= 0) {
                logger.error("\u6346\u7ed1\u7acb\u51cf\u3001\u6346\u7ed1\u603b\u91d1\u989d,\u65b9\u6cd5\u540d\uff1adoBindReduceAmount,\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u4fc3\u9500\u89c4\u5219\u7684\u6346\u7ed1\u7ec4\u5408\u7acb\u51cf\u91d1\u989d\u3002");
                return;
            }
            if (isAd) {
                bindReduceAmount = drCount.multiply(bindReduceAmount);
            }
        }
        BigDecimal adReductionAmount = SaleorderPromotionHelper.getAdReducetionAmount((String[])goodsSeqArray, goodsSeq, goodsAmount, bindReduceAmount, docGoodsEntry);
        BigDecimal bigDecimal = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
        BigDecimal lineReductionAmount = StringUtils.equals((CharSequence)goodsSeq, (CharSequence)goodsSeqArray[goodsSeqArray.length - 1]) ? bindReduceAmount.subtract(adReductionAmount) : bigDecimal.divide(goodsAmount, 2, 4).multiply(bindReduceAmount);
        if (lineReductionAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        Map<String, BigDecimal> amountResult = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "promotiondiscount", lineReductionAmount, false);
        SaleAmountHelper.setData(amountResult, doGoodsEntry);
        balPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
        BigDecimal promoteRate = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountrate");
        SaleorderPromotionHelper.createPromoteRow(promoteType, doGoodsEntry, doPromoteEntry, balPrice, promoteRate, itemGroup, exeGoodsSeq);
    }

    public static void doPointAmt(String promoteType, DynamicObject doPromote, DynamicObject doGoodsEntry, DynamicObject doPromoteEntry, DynamicObject doPromoteRule) {
        DynamicObjectCollection docItemEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doPromote, (String)"itemlistentry");
        if (CollectionUtils.isEmpty((Collection)docItemEntry)) {
            return;
        }
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid");
        BigDecimal balPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
        DynamicObject doItemEntry = docItemEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"itemid") == goodsId).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)doItemEntry)) {
            return;
        }
        String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
        String promoteGoodSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
        BigDecimal discoPrice = !PromotionEnum.noLadPromotion().contains(promoteType) ? DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"targetamount") : DynamicObjectUtils.getBigDecimal((DynamicObject)doItemEntry, (String)"promoteprice");
        BigDecimal newBalAmount = discoPrice.multiply(saleQty);
        BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
        BigDecimal promotionDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"promotiondiscount");
        Map<String, BigDecimal> amountResult = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "promotiondiscount", promotionDiscount.add(balAmount.subtract(newBalAmount)), false);
        SaleAmountHelper.setData(amountResult, doGoodsEntry);
        SaleorderPromotionHelper.createPromoteRow(promoteType, doGoodsEntry, doPromoteEntry, balPrice, BigDecimal.ZERO, itemGroup, promoteGoodSeq);
    }

    public static void doPointDisc(String promoteType, DynamicObject doPromote, DynamicObject doGoodsEntry, DynamicObject doPromoteEntry, DynamicObject doPromoteRule) {
        BigDecimal disc = BigDecimal.ZERO;
        String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
        BigDecimal balPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
        BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
        String promoteGoodsSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
        BigDecimal promotionDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"promotiondiscount");
        if (!PromotionEnum.noLadPromotion().contains(promoteType)) {
            disc = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"discount");
        } else {
            String itemSelected;
            switch (itemSelected = DynamicObjectUtils.getString((DynamicObject)doPromote, (String)"itemselected")) {
                case "1": {
                    disc = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromote, (String)"allitemdisco");
                    break;
                }
                case "2": {
                    long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid");
                    DynamicObjectCollection docItemEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doPromote, (String)"itemlistentry");
                    if (CollectionUtils.isEmpty((Collection)docItemEntry)) {
                        return;
                    }
                    DynamicObject doItemEntry = docItemEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"itemid") == goodsId).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doItemEntry)) {
                        return;
                    }
                    disc = DynamicObjectUtils.getBigDecimal((DynamicObject)doItemEntry, (String)"discount");
                    break;
                }
            }
        }
        BigDecimal discoPrice = balPrice.multiply(disc.divide(new BigDecimal(10), 4));
        BigDecimal newBalAmount = discoPrice.multiply(saleQty);
        Map<String, BigDecimal> amountResult = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "promotiondiscount", promotionDiscount.add(balAmount.subtract(newBalAmount)), false);
        SaleAmountHelper.setData(amountResult, doGoodsEntry);
        SaleorderPromotionHelper.createPromoteRow(promoteType, doGoodsEntry, doPromoteEntry, balPrice, disc, itemGroup, promoteGoodsSeq);
    }

    public static void doAmtTicket(String promoteType, DynamicObject doGoodsEntry, DynamicObjectCollection docGoodsEntry, DynamicObject doPromoteEntry, DynamicObject doPromoteRule) {
        if (ObjectUtils.isEmpty((Object)doPromoteRule)) {
            logger.info("\u6307\u5b9a\u5546\u54c1\u4e70\u6ee1\u91d1\u989d\u8d60\u793c\u5238,\u65b9\u6cd5\u540d\uff1adoAmtTicket,\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u4fc3\u9500\u89c4\u5219");
            return;
        }
        DynamicObjectCollection docFullTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doPromoteRule, (String)"fullticketentity");
        if (CollectionUtils.isEmpty((Collection)docFullTicketEntry)) {
            return;
        }
        DynamicObject doTicketType = null;
        String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
        String promoteGoodSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
        String exeGoodsSeq = SaleorderPromotionHelper.getExeGoodsSeq(itemGroup, doGoodsEntry, doPromoteRule, docGoodsEntry, promoteGoodSeq);
        DynamicObjectType dtTicketType = (DynamicObjectType)ORM.create().getDataEntityType("ocdbd_ticketstype");
        Object[] pkValues = docFullTicketEntry.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype")).toArray();
        DynamicObject[] ticketTypeArray = BusinessDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)dtTicketType);
        for (DynamicObject doFullTicketEntry : docFullTicketEntry) {
            long ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doFullTicketEntry, (String)"ticketstype");
            if (ticketTypeArray != null && ticketTypeArray.length > 0) {
                doTicketType = Arrays.stream(ticketTypeArray).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == ticketTypeId).findFirst().orElse(null);
            }
            if (doTicketType == null) {
                doTicketType = DynamicObjectUtils.getDynamicObject((DynamicObject)doFullTicketEntry, (String)"ticketstype");
            }
            BigDecimal ticketQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doFullTicketEntry, (String)"intnumber");
            SaleorderPromotionHelper.createPromoteRow(promoteType, doGoodsEntry, doPromoteEntry, null, doTicketType, null, ticketQty, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, itemGroup, exeGoodsSeq, 0);
        }
    }

    public static void doPiecesGift(String promoteType, DynamicObject doGoodsEntry, DynamicObjectCollection docGoodsEntry, DynamicObject doPromoteEntry, DynamicObject doPromoteRule) {
        if (ObjectUtils.isEmpty((Object)doPromoteRule)) {
            logger.info("\u6307\u5b9a\u5546\u54c1\u4e70\u6ee1\u91d1\u989d\u8d60\u79ef\u5206,\u65b9\u6cd5\u540d\uff1adoPiecesGift,\u539f\u56e0\uff1a\u672a\u83b7\u53d6\u5230\u4fc3\u9500\u89c4\u5219.");
            return;
        }
        DynamicObjectCollection docPointEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doPromoteRule, (String)"pointentity");
        if (CollectionUtils.isEmpty((Collection)docPointEntry)) {
            return;
        }
        DynamicObject doPointType = null;
        String itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
        String promoteGoodSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
        String exeGoodsSeq = SaleorderPromotionHelper.getExeGoodsSeq(itemGroup, doGoodsEntry, doPromoteRule, docGoodsEntry, promoteGoodSeq);
        Object[] pkValues = docPointEntry.stream().map(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtypeid")).toArray();
        DynamicObjectType dtPointType = (DynamicObjectType)ORM.create().getDataEntityType("ocdbd_mpointtype");
        DynamicObject[] pointTypeArray = BusinessDataServiceHelper.load((Object[])pkValues, (DynamicObjectType)dtPointType);
        for (DynamicObject doPointEntry : docPointEntry) {
            long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPointEntry, (String)"pointtypeid");
            if (pointTypeArray != null && pointTypeArray.length > 0) {
                doPointType = Arrays.stream(pointTypeArray).filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == pointTypeId).findFirst().orElse(null);
            }
            if (doPointType == null) {
                doPointType = DynamicObjectUtils.getDynamicObject((DynamicObject)doPointEntry, (String)"pointtypeid");
            }
            BigDecimal pointQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doPointEntry, (String)"pointqty");
            SaleorderPromotionHelper.createPromoteRow(promoteType, doGoodsEntry, doPromoteEntry, doPointType, null, null, pointQty, BigDecimal.ZERO, BigDecimal.ZERO, BigDecimal.ZERO, itemGroup, exeGoodsSeq, 0);
        }
    }

    public static void createPromoteRow(String promoteType, DynamicObject doGoodsEntry, DynamicObject doPromoteEntry, DynamicObject doPointType, DynamicObject doTicketType, DynamicObject doGoods, BigDecimal qty, BigDecimal salePrice, BigDecimal giftPrice, BigDecimal giftValue, String itemGroup, String exeGoodsSeq, int seq) {
        DynamicObjectCollection docSaleOrderPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
        if (docSaleOrderPromote == null) {
            return;
        }
        DynamicObject doSaleOrderPromote = docSaleOrderPromote.addNew();
        doSaleOrderPromote.set("promotionactid", (Object)DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotionid"));
        doSaleOrderPromote.set("promotionactnum", (Object)DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotionnum"));
        doSaleOrderPromote.set("promotionactname", (Object)DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotionname"));
        doSaleOrderPromote.set("promotiontypeid", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)doPromoteEntry, (String)"promotiontype"));
        doSaleOrderPromote.set("exegoodsseq", (Object)exeGoodsSeq);
        doSaleOrderPromote.set("promotegoodsseq", (Object)seq);
        doSaleOrderPromote.set("promotsaleqty", (Object)qty);
        switch (promoteType) {
            case "PM-034": {
                doSaleOrderPromote.set("pointtype", (Object)doPointType);
                doSaleOrderPromote.set("exepromotetype", (Object)"4");
                BigDecimal integralPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)doPointType, (String)"price");
                doSaleOrderPromote.set("promoteintegralvalue", (Object)qty.multiply(integralPrice));
                break;
            }
            case "PM-023": 
            case "PM-039": {
                doSaleOrderPromote.set("pointtype", (Object)doPointType);
                BigDecimal integralPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)doPointType, (String)"price");
                doSaleOrderPromote.set("promoteintegralvalue", (Object)qty.multiply(integralPrice));
                if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"1");
                    break;
                }
                if (StringUtils.equals((CharSequence)"2", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"2");
                    break;
                }
                if (!StringUtils.equals((CharSequence)"3", (CharSequence)itemGroup)) break;
                doSaleOrderPromote.set("exepromotetype", (Object)"3");
                break;
            }
            case "PM-035": {
                doSaleOrderPromote.set("coupontype", (Object)doTicketType);
                doSaleOrderPromote.set("exepromotetype", (Object)"4");
                BigDecimal ticketValue = DynamicObjectUtils.getBigDecimal((DynamicObject)doTicketType, (String)"ticketvalue");
                doSaleOrderPromote.set("promoteticketvalue", (Object)ticketValue.multiply(qty));
                break;
            }
            case "PM-025": 
            case "PM-037": {
                doSaleOrderPromote.set("coupontype", (Object)doTicketType);
                BigDecimal ticketValue = DynamicObjectUtils.getBigDecimal((DynamicObject)doTicketType, (String)"ticketvalue");
                doSaleOrderPromote.set("promoteticketvalue", (Object)ticketValue.multiply(qty));
                if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"1");
                    break;
                }
                if (StringUtils.equals((CharSequence)"2", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"2");
                    break;
                }
                if (!StringUtils.equals((CharSequence)"3", (CharSequence)itemGroup)) break;
                doSaleOrderPromote.set("exepromotetype", (Object)"3");
                break;
            }
            case "PM-031": 
            case "PM-006": 
            case "PM-020": {
                doSaleOrderPromote.set("promotegoodsid", (Object)doGoods);
                doSaleOrderPromote.set("saleprice", (Object)salePrice);
                doSaleOrderPromote.set("promotegiftprice", (Object)giftPrice);
                doSaleOrderPromote.set("promotegiftvalue", (Object)giftValue);
                if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"1");
                } else if (StringUtils.equals((CharSequence)"2", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"2");
                } else if (StringUtils.equals((CharSequence)"3", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"3");
                }
                if (!StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-031")) break;
                doSaleOrderPromote.set("exepromotetype", (Object)"4");
                break;
            }
        }
    }

    public static void createPromoteRow(String promoteType, DynamicObject doGoodsEntry, DynamicObject doPromoteEntry, BigDecimal balPrice, BigDecimal promoteRate, String itemGroup, String exeGoodsSeq) {
        DynamicObjectCollection docSaleOrderPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
        if (docSaleOrderPromote == null) {
            return;
        }
        DynamicObject doSaleOrderPromote = docSaleOrderPromote.addNew();
        doSaleOrderPromote.set("promotionactid", (Object)DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotionid"));
        doSaleOrderPromote.set("promotionactnum", (Object)DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotionnum"));
        doSaleOrderPromote.set("promotionactname", (Object)DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotionname"));
        doSaleOrderPromote.set("promotiontypeid", (Object)DynamicObjectUtils.getDynamicObject((DynamicObject)doPromoteEntry, (String)"promotiontype"));
        doSaleOrderPromote.set("saleprice", (Object)balPrice);
        doSaleOrderPromote.set("exegoodsseq", (Object)exeGoodsSeq);
        switch (promoteType) {
            case "PM-002": 
            case "PM-038": 
            case "PM-026": {
                doSaleOrderPromote.set("promotionprice", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice"));
                doSaleOrderPromote.set("promotionrate", (Object)promoteRate);
                if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"1");
                    break;
                }
                if (StringUtils.equals((CharSequence)"2", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"2");
                    break;
                }
                if (!StringUtils.equals((CharSequence)"3", (CharSequence)itemGroup)) break;
                doSaleOrderPromote.set("exepromotetype", (Object)"3");
                break;
            }
            case "PM-028": 
            case "PM-029": {
                doSaleOrderPromote.set("promotionrate", (Object)promoteRate);
                doSaleOrderPromote.set("promotionprice", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice"));
                doSaleOrderPromote.set("exepromotetype", (Object)"4");
                break;
            }
            case "PM-005": 
            case "PM-004": {
                doSaleOrderPromote.set("promotionrate", (Object)promoteRate);
                doSaleOrderPromote.set("promotionprice", (Object)DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice"));
                if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"1");
                    break;
                }
                if (StringUtils.equals((CharSequence)"2", (CharSequence)itemGroup)) {
                    doSaleOrderPromote.set("exepromotetype", (Object)"2");
                    break;
                }
                if (!StringUtils.equals((CharSequence)"3", (CharSequence)itemGroup)) break;
                doSaleOrderPromote.set("exepromotetype", (Object)"3");
                break;
            }
        }
    }

    public static BigDecimal getSumQty(String[] goodsSeqArray, DynamicObjectCollection docGoodsEntry) {
        BigDecimal sumQty = BigDecimal.ZERO;
        for (String seqI : goodsSeqArray) {
            DynamicObject doGoods = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seqI, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)doGoods)) continue;
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoods, (String)"saleqty");
            sumQty = sumQty.add(qty);
        }
        return sumQty;
    }

    public static BigDecimal getAdReducetionAmount(String[] goodsSeqArray, String goodsSeq, BigDecimal goodsAmount, BigDecimal bindReduceAmount, DynamicObjectCollection docGoodsEntry) {
        BigDecimal adReductionAmount = BigDecimal.ZERO;
        for (String seqI : goodsSeqArray) {
            if (StringUtils.equals((CharSequence)seqI, (CharSequence)goodsSeq)) break;
            DynamicObject doGoods = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seqI, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)doGoods)) continue;
            BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoods, (String)"balamount");
            BigDecimal lineReductionAmount = balAmount.divide(goodsAmount, 2, 4).multiply(bindReduceAmount);
            adReductionAmount = adReductionAmount.add(lineReductionAmount);
        }
        return adReductionAmount;
    }

    public static List<DynamicObject> getSameGoodsList(DynamicObject doGoodsEntry, String[] goodsSeqArray, DynamicObjectCollection docGoodsEntry) {
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid");
        List lstGoodsSeq = Arrays.stream(goodsSeqArray).collect(Collectors.toList());
        return docGoodsEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid") == goodsId && lstGoodsSeq.contains(DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"))).collect(Collectors.toList());
    }

    public static BigDecimal getGoodsAmount(String[] goodsSeqArray, DynamicObjectCollection docGoodsEntry) {
        BigDecimal goodsAmount = BigDecimal.ZERO;
        for (String seq : goodsSeqArray) {
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (ObjectUtils.isEmpty((Object)doGoodsEntry)) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            goodsAmount = goodsAmount.add(balAmount);
        }
        return goodsAmount;
    }

    public static String getExeGoodsSeq(String itemGroup, DynamicObject doGoodsEntry, DynamicObject doPromoteRule, DynamicObjectCollection docGoodsEntry, String promoteGoodSeq) {
        String goodsSeq = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq");
        BigDecimal targetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"targetqty");
        BigDecimal targetAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteRule, (String)"targetamount");
        Object[] goodsSeqArray = promoteGoodSeq.split(",");
        if (StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
            List<DynamicObject> lstGoodsEntry = SaleorderPromotionHelper.getSameGoodsList(doGoodsEntry, (String[])goodsSeqArray, docGoodsEntry);
            if (CollectionUtils.isEmpty(lstGoodsEntry)) {
                return "";
            }
            ArrayList<String> lstGoodsSeq = new ArrayList<String>(0);
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
            BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            if (saleQty.compareTo(targetQty) >= 0 && targetQty.compareTo(BigDecimal.ZERO) > 0 || balAmount.compareTo(targetAmount) >= 0 && targetAmount.compareTo(BigDecimal.ZERO) > 0) {
                lstGoodsSeq.add(goodsSeq);
            } else {
                for (DynamicObject goodsItem : lstGoodsEntry) {
                    String seq = DynamicObjectUtils.getString((DynamicObject)goodsItem, (String)"seq");
                    lstGoodsSeq.add(seq);
                }
            }
            goodsSeqArray = lstGoodsSeq.toArray(new String[0]);
            return StringUtils.join((Object[])goodsSeqArray, (char)',');
        }
        ArrayList<String> lstSeq = new ArrayList<String>(0);
        if (goodsSeqArray.length > 0) {
            for (String string : goodsSeqArray) {
                DynamicObject doGoods = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)seqI, (CharSequence)x.getString("seq"))).findFirst().orElse(null);
                if (ObjectUtils.isEmpty((Object)doGoods) || lstSeq.contains(string)) continue;
                lstSeq.add(string);
            }
        }
        return StringUtils.join((Object[])lstSeq.toArray(), (char)',');
    }

    public static boolean checkTicketSexclusive(DynamicObject saleOrder, DynamicObjectCollection ticketPayList, DynamicObjectCollection useTicketList, long ticketTypeId, long promoteId, StringBuilder msg) {
        QFilter filter = new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue());
        filter.and("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        filter.and("startdate", "<=", (Object)TimeServiceHelper.now());
        filter.and("enddate", ">=", (Object)TimeServiceHelper.now());
        DynamicObject[] ticketsExclusives = BusinessDataServiceHelper.load((String)"ocdbd_ticketsexclusive", (String)"id,number,name,ruletype,ticketstypegroup,promotetypegroup,ticketsruleentry.ticketstype,promoteentry.promoteid,promoteentry.promotenumber,promoteentry.promotename,subpromoteentry.subpromoteid,subpromoteentry.subpromotenumber,subpromoteentry.subpromotename", (QFilter[])filter.toArray());
        DynamicObjectCollection useTicketEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"useticketentity");
        DynamicObjectCollection promoteEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"promotionentity");
        for (DynamicObject ticketsExclusive : ticketsExclusives) {
            String message;
            String number = DynamicObjectUtils.getString((DynamicObject)ticketsExclusive, (String)"number");
            String name = DynamicObjectUtils.getString((DynamicObject)ticketsExclusive, (String)"name");
            String ruleType = DynamicObjectUtils.getString((DynamicObject)ticketsExclusive, (String)"ruletype");
            String ticketsTypeGroup = DynamicObjectUtils.getString((DynamicObject)ticketsExclusive, (String)"ticketstypegroup");
            String promoteTypeGroup = DynamicObjectUtils.getString((DynamicObject)ticketsExclusive, (String)"promotetypegroup");
            DynamicObjectCollection ticketsRuleEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)ticketsExclusive, (String)"ticketsruleentry");
            DynamicObjectCollection promoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)ticketsExclusive, (String)"promoteentry");
            if (StringUtils.equals((CharSequence)"A", (CharSequence)ruleType)) {
                message = "\u6240\u9009\u793c\u5238\u6ee1\u8db3\u793c\u5238\u4e92\u65a5\u89c4\u5219\uff1a" + name + "(" + number + ")";
                if (SaleorderPromotionHelper.ticketExclusive(ticketsTypeGroup, ticketsRuleEntry, ticketTypeId, ticketPayList, useTicketList, useTicketEntity)) continue;
                msg.append(message);
                return false;
            }
            if (StringUtils.equals((CharSequence)"B", (CharSequence)ruleType)) {
                message = "\u6240\u9009\u4fc3\u9500\u6ee1\u8db3\u4fc3\u9500\u4e92\u65a5\u89c4\u5219\uff1a" + name + "(" + number + ")";
                if (SaleorderPromotionHelper.promoteExclusive(promoteTypeGroup, promoteEntry, promoteId, promoteEntity)) continue;
                msg.append(message);
                return false;
            }
            message = "";
            if (ticketTypeId > 0L) {
                message = "\u6240\u9009\u793c\u5238";
            } else if (promoteId > 0L) {
                message = "\u6240\u9009\u4fc3\u9500";
            }
            message = message + "\u6ee1\u8db3\u793c\u5238\u4fc3\u9500\u4e92\u65a5\u89c4\u5219\uff1a" + name + "(" + number + ")";
            if (SaleorderPromotionHelper.ticketPromoteExclusive(ticketsTypeGroup, promoteTypeGroup, ticketTypeId, promoteId, ticketsRuleEntry, promoteEntry, promoteEntity, useTicketEntity, ticketPayList, useTicketList)) continue;
            msg.append(message);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean ticketPromoteExclusive(String ticketsTypeGroup, String promoteTypeGroup, long ticketTypeId, long promoteId, DynamicObjectCollection ticketsRuleEntry, DynamicObjectCollection promoteEntry, DynamicObjectCollection promoteEntity, DynamicObjectCollection useTicketEntity, DynamicObjectCollection ticketPayList, DynamicObjectCollection useTicketList) {
        if (StringUtils.equals((CharSequence)ticketsTypeGroup, (CharSequence)"1")) {
            if (CollectionUtils.isEmpty((Collection)ticketsRuleEntry)) {
                if (ticketTypeId > 0L) {
                    if (!StringUtils.equals((CharSequence)promoteTypeGroup, (CharSequence)"1")) return SaleorderPromotionHelper.matchPromote(false, promoteEntity, promoteEntry, promoteId);
                    if (!CollectionUtils.isEmpty((Collection)promoteEntry)) return SaleorderPromotionHelper.matchPromote(true, promoteEntity, promoteEntry, promoteId);
                    if (promoteEntity.stream().anyMatch(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"execute"))) {
                        return false;
                    }
                }
                if (promoteId <= 0L) return true;
                if (StringUtils.equals((CharSequence)promoteTypeGroup, (CharSequence)"1")) {
                    if (CollectionUtils.isEmpty((Collection)promoteEntry) && !CollectionUtils.isEmpty((Collection)useTicketEntity)) {
                        return false;
                    }
                    if (!promoteEntry.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promoteId) || CollectionUtils.isEmpty((Collection)useTicketEntity)) return true;
                    return false;
                }
                if (!promoteEntry.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promoteId) || CollectionUtils.isEmpty((Collection)useTicketEntity)) return true;
                return false;
            }
            if (ticketTypeId > 0L && ticketsRuleEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId)) {
                if (!StringUtils.equals((CharSequence)promoteTypeGroup, (CharSequence)"1")) return SaleorderPromotionHelper.matchPromote(false, promoteEntity, promoteEntry, promoteId);
                if (!CollectionUtils.isEmpty((Collection)promoteEntry)) return SaleorderPromotionHelper.matchPromote(true, promoteEntity, promoteEntry, promoteId);
                return false;
            }
            if (promoteId <= 0L) return true;
            if (StringUtils.equals((CharSequence)promoteTypeGroup, (CharSequence)"1")) {
                if (!CollectionUtils.isEmpty((Collection)promoteEntry) && !promoteEntry.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promoteId)) return true;
                return SaleorderPromotionHelper.existTicketType(true, ticketsRuleEntry, ticketPayList, useTicketList, useTicketEntity, ticketTypeId);
            }
            if (!promoteEntry.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promoteId)) return true;
            return SaleorderPromotionHelper.existTicketType(false, ticketsRuleEntry, ticketPayList, useTicketList, useTicketEntity, ticketTypeId);
        }
        if (CollectionUtils.isEmpty((Collection)ticketsRuleEntry) || CollectionUtils.isEmpty((Collection)promoteEntity)) return true;
        for (DynamicObject ticketRule : ticketsRuleEntry) {
            DynamicObjectCollection docSubPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)ticketRule, (String)"subpromoteentry");
            if (CollectionUtils.isEmpty((Collection)docSubPromoteEntry)) continue;
            long ruleTicketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)ticketRule, (String)"ticketstype");
            if (ticketTypeId > 0L && ticketTypeId == ruleTicketTypeId) {
                for (DynamicObject promote : promoteEntity) {
                    boolean execute = DynamicObjectUtils.getBoolean((DynamicObject)promote, (String)"execute");
                    if (!execute) continue;
                    long promotionId = DynamicObjectUtils.getLong((DynamicObject)promote, (String)"promotionid");
                    if (!docSubPromoteEntry.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"subpromoteid") == promotionId)) continue;
                    return false;
                }
            }
            if (promoteId <= 0L || !docSubPromoteEntry.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"subpromoteid") == promoteId) || CollectionUtils.isEmpty((Collection)useTicketEntity) || !useTicketEntity.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"uttickettype") == ruleTicketTypeId)) continue;
            return false;
        }
        return true;
    }

    private static boolean promoteExclusive(String promoteTypeGroup, DynamicObjectCollection promoteEntry, long promoteId, DynamicObjectCollection promoteEntity) {
        if (promoteId == 0L) {
            return true;
        }
        if (StringUtils.equals((CharSequence)promoteTypeGroup, (CharSequence)"1")) {
            if (CollectionUtils.isEmpty((Collection)promoteEntry)) {
                if (!CollectionUtils.isEmpty((Collection)promoteEntity) && promoteEntity.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionid") != promoteId && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"execute"))) {
                    return false;
                }
            } else if (!CollectionUtils.isEmpty((Collection)promoteEntity) && promoteEntity.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionid") != promoteId && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"execute")) && promoteEntry.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promoteId)) {
                return SaleorderPromotionHelper.matchPromote(true, promoteEntity, promoteEntry, promoteId);
            }
        } else if (promoteEntry.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promoteId)) {
            return SaleorderPromotionHelper.matchPromote(false, promoteEntity, promoteEntry, promoteId);
        }
        return true;
    }

    private static boolean ticketExclusive(String ticketsTypeGroup, DynamicObjectCollection ticketsRuleEntry, long ticketTypeId, DynamicObjectCollection ticketPayList, DynamicObjectCollection useTicketList, DynamicObjectCollection useTicketEntity) {
        if (ticketTypeId == 0L) {
            return true;
        }
        if (StringUtils.equals((CharSequence)ticketsTypeGroup, (CharSequence)"1")) {
            if (CollectionUtils.isEmpty((Collection)ticketsRuleEntry)) {
                if (!CollectionUtils.isEmpty((Collection)ticketPayList) && ticketPayList.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"tickettypeid") != ticketTypeId).count() > 0L) {
                    return false;
                }
                if (!CollectionUtils.isEmpty((Collection)useTicketList) && useTicketList.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"uttickettype") != ticketTypeId).count() > 0L) {
                    return false;
                }
                if (!CollectionUtils.isEmpty((Collection)useTicketEntity) && useTicketEntity.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"uttickettype") != ticketTypeId).count() > 0L) {
                    return false;
                }
            } else if (ticketsRuleEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId)) {
                return SaleorderPromotionHelper.existTicketType(true, ticketsRuleEntry, ticketPayList, useTicketList, useTicketEntity, ticketTypeId);
            }
        } else if (ticketsRuleEntry.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId)) {
            return SaleorderPromotionHelper.existTicketType(false, ticketsRuleEntry, ticketPayList, useTicketList, useTicketEntity, ticketTypeId);
        }
        return true;
    }

    private static boolean matchPromote(boolean isExcept, DynamicObjectCollection promoteEntity, DynamicObjectCollection promoteEntry, long promoteId) {
        if (!CollectionUtils.isEmpty((Collection)promoteEntity)) {
            for (DynamicObject promote : promoteEntity) {
                long promotionId;
                boolean execute = DynamicObjectUtils.getBoolean((DynamicObject)promote, (String)"execute");
                if (!execute || promoteId == (promotionId = DynamicObjectUtils.getLong((DynamicObject)promote, (String)"promotionid")) || !(!isExcept ? promoteEntry.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promotionId) : promoteEntry.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promoteid") == promotionId))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean existTicketType(boolean isExcept, DynamicObjectCollection ticketsRuleEntry, DynamicObjectCollection ticketPayList, DynamicObjectCollection useTicketList, DynamicObjectCollection useTicketEntity, long useTicketTypeId) {
        long ticketTypeId;
        if (!CollectionUtils.isEmpty((Collection)ticketPayList)) {
            for (DynamicObject ticketPay : ticketPayList) {
                ticketTypeId = DynamicObjectUtils.getLong((DynamicObject)ticketPay, (String)"tickettypeid");
                if (useTicketTypeId == ticketTypeId || !(!isExcept ? ticketsRuleEntry.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId) : ticketsRuleEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId))) continue;
                return false;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)useTicketList)) {
            for (DynamicObject useTicket : useTicketList) {
                ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)useTicket, (String)"uttickettype");
                if (useTicketTypeId == ticketTypeId || !(!isExcept ? ticketsRuleEntry.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId) : ticketsRuleEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId))) continue;
                return false;
            }
        }
        if (!CollectionUtils.isEmpty((Collection)useTicketEntity)) {
            for (DynamicObject useTicket : useTicketEntity) {
                ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)useTicket, (String)"uttickettype");
                if (useTicketTypeId == ticketTypeId || !(!isExcept ? ticketsRuleEntry.stream().anyMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId) : ticketsRuleEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"ticketstype") == ticketTypeId))) continue;
                return false;
            }
        }
        return true;
    }
}

