/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.business.promotion.MaterialConditionHelper;
import kd.occ.ocpos.business.promotion.PromotionCalcHelper;
import kd.occ.ocpos.common.entity.MaterialEntity;
import kd.occ.ocpos.common.entity.PlanEntity;
import kd.occ.ocpos.common.entity.UnMatchPlansEntity;
import kd.occ.ocpos.common.entity.request.CxRequestEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.enums.promotion.ApplyMaterialScopeEnum;

public class SimplePromotionHelper {
    public static UnMatchPlansEntity matchSimplePlan(CxRequestEntity req, PlanEntity plan) {
        UnMatchPlansEntity unMatchPlansEntity;
        StringBuilder matchInfo = new StringBuilder();
        MaterialEntryEntity reqMaterialEntryEntity = req.getMatchMaterial();
        List<Object> reqMaterialList = new ArrayList();
        if (plan.getItemRange() == 0) {
            reqMaterialList = Collections.singletonList(reqMaterialEntryEntity);
        } else {
            reqMaterialList.addAll(req.getMaterialEntries());
        }
        List materialEntityList = plan.getMaterialEntityList();
        ArrayList<MaterialEntity> materialList = new ArrayList<MaterialEntity>();
        ArrayList<MaterialEntryEntity> filterMaterialList = new ArrayList<MaterialEntryEntity>();
        if (ApplyMaterialScopeEnum.AllMaterial == plan.getApplyMaterialScope()) {
            unMatchPlansEntity = SimplePromotionHelper.filterReqMaterialByWhole(plan, reqMaterialList);
        } else {
            for (MaterialEntryEntity materialEntryEntity : reqMaterialList) {
                for (MaterialEntity material : materialEntityList) {
                    MaterialEntity matchMaterial = MaterialConditionHelper.matchDetailMaterial(material, materialEntryEntity);
                    switch (plan.getApplyMaterialScope()) {
                        case SpecificMaterial: {
                            if (matchMaterial != null && !filterMaterialList.contains(materialEntryEntity)) {
                                filterMaterialList.add(materialEntryEntity);
                                materialList.add(material);
                                break;
                            }
                            matchInfo.append(material.getMaterialName()).append("\u5546\u54c1\u4e0d\u5339\u914d").append(',');
                        }
                    }
                }
            }
            if (materialList.size() > 0) {
                unMatchPlansEntity = SimplePromotionHelper.filterReqMaterialByWhole(plan, filterMaterialList);
            } else {
                return BuildParamHelper.buildUnMatch(plan, matchInfo.length() > 0 ? matchInfo.deleteCharAt(matchInfo.length() - 1).toString() : "");
            }
        }
        return unMatchPlansEntity;
    }

    private static UnMatchPlansEntity filterReqMaterialByWhole(PlanEntity plan, List<MaterialEntryEntity> filterMaterialList) {
        UnMatchPlansEntity unMatchPlansEntity = null;
        ArrayList<MaterialEntryEntity> matchMaterialList = new ArrayList<MaterialEntryEntity>();
        for (MaterialEntryEntity matchMaterial : filterMaterialList) {
            boolean enoughNum;
            if (plan.getPromotionWay() == 1) {
                boolean enoughAmount = PromotionCalcHelper.filterWholeAmount(plan, matchMaterial, filterMaterialList);
                if (!enoughAmount) continue;
                matchMaterialList.add(matchMaterial);
                continue;
            }
            if (plan.getPromotionWay() != 2 || !(enoughNum = PromotionCalcHelper.filterWholeNum(plan, matchMaterial, filterMaterialList))) continue;
            matchMaterialList.add(matchMaterial);
        }
        if (matchMaterialList.size() == 0) {
            if (plan.getPromotionWay() == 1) {
                unMatchPlansEntity = BuildParamHelper.buildUnMatch(plan, "\u6307\u5b9a\u5546\u54c1\u91d1\u989d\u4e0d\u8db3\u6ee1\u51cf\u91d1\u989d");
            } else if (plan.getPromotionWay() == 2) {
                unMatchPlansEntity = BuildParamHelper.buildUnMatch(plan, "\u6307\u5b9a\u5546\u54c1\u4ef6\u6570\u4e0d\u8db3\u6ee1\u51cf\u4ef6\u6570");
            }
        } else {
            plan.setMaterialEntityList(BuildParamHelper.buildAllMaterial(matchMaterialList));
        }
        return unMatchPlansEntity;
    }
}

