/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.promotion;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.occ.ocpos.business.promotion.BuildParamHelper;
import kd.occ.ocpos.business.promotion.MaterialConditionHelper;
import kd.occ.ocpos.business.promotion.PromotionCalcHelper;
import kd.occ.ocpos.common.entity.MaterialEntity;
import kd.occ.ocpos.common.entity.PlanEntity;
import kd.occ.ocpos.common.entity.UnMatchPlansEntity;
import kd.occ.ocpos.common.entity.request.CxRequestEntity;
import kd.occ.ocpos.common.entity.request.LadBindQtyEntity;
import kd.occ.ocpos.common.entity.request.MaterialEntryEntity;
import kd.occ.ocpos.common.enums.promotion.MaterialTypeEnum;
import kd.occ.ocpos.common.util.promotion.CommonUtils;

public class WholePromotionHelper {
    public static UnMatchPlansEntity matchWholePlan(CxRequestEntity req, PlanEntity plan) {
        UnMatchPlansEntity unMatchPlansEntity = null;
        StringBuilder matchInfo = new StringBuilder();
        List reqMaterialList = req.getMaterialEntries();
        ArrayList<MaterialEntryEntity> filterMaterialList = new ArrayList<MaterialEntryEntity>();
        List exceptMaterialEntityList = plan.getExceptMaterialEntityList();
        List materialEntityList = plan.getMaterialEntityList();
        for (MaterialEntryEntity entry : reqMaterialList) {
            boolean isExcept = false;
            for (MaterialEntity exceptMaterial : exceptMaterialEntityList) {
                if (!WholePromotionHelper.exceptMaterialCompare(exceptMaterial, entry, exceptMaterial.getType())) continue;
                isExcept = true;
            }
            boolean isExist = false;
            if (materialEntityList.size() > 0) {
                for (MaterialEntity materialEntity : materialEntityList) {
                    switch (materialEntity.getType()) {
                        case Material: {
                            if (!MaterialConditionHelper.materialEqual(materialEntity, entry)) break;
                            isExist = true;
                            break;
                        }
                        case MaterialCategory: {
                            if (!MaterialConditionHelper.materialClassEqual(materialEntity, entry)) break;
                            isExist = true;
                            break;
                        }
                        case MaterialBrand: {
                            if (!MaterialConditionHelper.materialBrandEqual(materialEntity, entry)) break;
                            isExist = true;
                            break;
                        }
                        case MaterialUnit: {
                            if (!MaterialConditionHelper.materialUnitEqual(materialEntity, entry)) break;
                            isExist = true;
                        }
                    }
                }
            } else {
                isExist = true;
            }
            if (isExcept || !isExist) continue;
            filterMaterialList.add(entry);
        }
        unMatchPlansEntity = filterMaterialList.size() > 0 ? WholePromotionHelper.filterReqMaterialByWhole(plan, filterMaterialList) : BuildParamHelper.buildUnMatch(plan, matchInfo.length() > 0 ? matchInfo.deleteCharAt(matchInfo.length() - 1).toString() : "");
        return unMatchPlansEntity;
    }

    private static UnMatchPlansEntity filterReqMaterialByWhole(PlanEntity plan, List<MaterialEntryEntity> filterMaterialList) {
        UnMatchPlansEntity unMatchPlansEntity = null;
        boolean enoughAmount = false;
        boolean enoughNum = false;
        boolean enoughBind = false;
        ArrayList<MaterialEntryEntity> matchMaterialList = new ArrayList<MaterialEntryEntity>();
        for (MaterialEntryEntity matchMaterial : filterMaterialList) {
            if (plan.getPromotionWay() == 1) {
                enoughAmount = PromotionCalcHelper.filterWholeAmount(plan, matchMaterial, filterMaterialList);
            } else if (plan.getPromotionWay() == 2) {
                enoughNum = PromotionCalcHelper.filterWholeNum(plan, matchMaterial, filterMaterialList);
            } else if (plan.getPromotionWay() == 3) {
                enoughBind = WholePromotionHelper.filterByBindNum(plan, matchMaterial, filterMaterialList);
            }
            if (!enoughAmount && !enoughNum && !enoughBind) continue;
            matchMaterialList.add(matchMaterial);
        }
        if (matchMaterialList.size() == 0) {
            if (plan.getPromotionWay() == 1) {
                unMatchPlansEntity = BuildParamHelper.buildUnMatch(plan, "\u6574\u5355\u5546\u54c1\u91d1\u989d\u4e0d\u8db3\u6ee1\u51cf\u91d1\u989d");
            } else if (plan.getPromotionWay() == 2) {
                unMatchPlansEntity = BuildParamHelper.buildUnMatch(plan, "\u6574\u5355\u5546\u54c1\u4ef6\u6570\u4e0d\u8db3\u6ee1\u51cf\u4ef6\u6570");
            } else if (plan.getPromotionWay() == 3) {
                unMatchPlansEntity = BuildParamHelper.buildUnMatch(plan, "\u6574\u5355\u5546\u54c1\u6346\u7ed1\u4ef6\u6570\u4e0d\u8db3");
            }
        } else {
            plan.setMaterialEntityList(BuildParamHelper.buildAllMaterial(matchMaterialList));
        }
        return unMatchPlansEntity;
    }

    private static boolean filterByBindNum(PlanEntity plan, MaterialEntryEntity matchMaterial, List<MaterialEntryEntity> reqMaterialList) {
        boolean isFilter = false;
        Map materialEntityMap = plan.getBindMaterialMap();
        DynamicObject[] promoteRuleList = BuildParamHelper.selectPromoteRuleList(plan.getId());
        LadBindQtyEntity bindQtyEntity = new LadBindQtyEntity();
        bindQtyEntity.setTotalBindNum(Integer.valueOf(0));
        int bindPikcQty = 0;
        ArrayList<String> materialIdList = new ArrayList<String>();
        for (DynamicObject promoteRule : promoteRuleList) {
            List materialEntityList = (List)materialEntityMap.get(promoteRule.getString("id"));
            bindPikcQty = promoteRule.getInt("bindpickqty");
            bindQtyEntity.setBindQty(Integer.valueOf(0));
            int pickQty = promoteRule.getInt("pickqty");
            for (MaterialEntity materialEntity : materialEntityList) {
                for (MaterialEntryEntity materialEntryEntity : reqMaterialList) {
                    if (!StringUtils.equals((CharSequence)matchMaterial.getMaterialId(), (CharSequence)materialEntryEntity.getMaterialId())) continue;
                    if (MaterialTypeEnum.Material.getCode() == materialEntity.getType().getCode()) {
                        if (!StringUtils.equals((CharSequence)materialEntity.getObjectId(), (CharSequence)materialEntryEntity.getMaterialId()) || materialIdList.contains(materialEntryEntity.getMaterialId())) continue;
                        WholePromotionHelper.checkItemGrop(promoteRule, materialEntryEntity, bindQtyEntity, bindPikcQty, materialIdList);
                        continue;
                    }
                    if (MaterialTypeEnum.MaterialBrand.getCode() == materialEntity.getType().getCode()) {
                        if (!materialEntryEntity.getBrandId().equals(materialEntity.getMaterialBrandId())) continue;
                        WholePromotionHelper.checkItemGrop(promoteRule, materialEntryEntity, bindQtyEntity, bindPikcQty, materialIdList);
                        continue;
                    }
                    if (MaterialTypeEnum.MaterialCategory.getCode() != materialEntity.getType().getCode() || !CommonUtils.isContain((List)materialEntryEntity.getCategories(), (String)materialEntity.getMaterialClassId())) continue;
                    WholePromotionHelper.checkItemGrop(promoteRule, materialEntryEntity, bindQtyEntity, bindPikcQty, materialIdList);
                }
            }
            if (promoteRule.getInt("itemgroup") != 3 || bindQtyEntity.getBindQty() < pickQty) continue;
            bindQtyEntity.setTotalBindNum(Integer.valueOf(bindQtyEntity.getTotalBindNum() + bindQtyEntity.getBindQty()));
        }
        if (bindQtyEntity.getTotalBindNum() >= bindPikcQty) {
            isFilter = true;
        }
        return isFilter;
    }

    private static void checkItemGrop(DynamicObject promoteRule, MaterialEntryEntity materialEntryEntity, LadBindQtyEntity bindQtyEntity, int bindPikcQty, List<String> materialIdList) {
        if (promoteRule.getInt("itemgroup") == 3 && !materialIdList.contains(materialEntryEntity.getMaterialId())) {
            bindQtyEntity.setBindQty(Integer.valueOf(bindQtyEntity.getBindQty() + 1));
            materialIdList.add(materialEntryEntity.getMaterialId());
        } else if (promoteRule.getInt("itemgroup") == 2 && !materialIdList.contains(materialEntryEntity.getMaterialId())) {
            bindQtyEntity.setBindQty(Integer.valueOf(materialEntryEntity.getQty().intValue()));
            bindQtyEntity.setTotalBindNum(Integer.valueOf(bindQtyEntity.getTotalBindNum() + bindQtyEntity.getBindQty()));
            materialIdList.add(materialEntryEntity.getMaterialId());
        } else if (promoteRule.getInt("itemgroup") == 1 && !materialIdList.contains(materialEntryEntity.getMaterialId())) {
            bindQtyEntity.setBindQty(Integer.valueOf(materialEntryEntity.getQty().intValue()));
            if (bindQtyEntity.getBindQty() >= bindPikcQty) {
                bindQtyEntity.setTotalBindNum(Integer.valueOf(bindQtyEntity.getTotalBindNum() + bindQtyEntity.getBindQty()));
                materialIdList.add(materialEntryEntity.getMaterialId());
            }
        }
    }

    public static boolean exceptMaterialCompare(MaterialEntity material, MaterialEntryEntity reqMaterial, MaterialTypeEnum type) {
        boolean exceptSaleAttrAndInventory = WholePromotionHelper.exceptSaleAttrAndInventoryEqual(material, reqMaterial);
        switch (type) {
            case Material: {
                if (!material.getObjectId().equals(reqMaterial.getMaterialId()) || !exceptSaleAttrAndInventory) break;
                return true;
            }
            case MaterialCategory: {
                if (!CommonUtils.isContain((List)reqMaterial.getCategories(), (String)material.getMaterialClassId()) || !exceptSaleAttrAndInventory) break;
                return true;
            }
            case MaterialBrand: {
                if (!reqMaterial.getBrandId().equals(material.getMaterialBrandId()) || !exceptSaleAttrAndInventory) break;
                return true;
            }
            case MaterialUnit: {
                if (StringUtils.isNotEmpty((CharSequence)material.getMaterialBrandId()) && StringUtils.isNotEmpty((CharSequence)material.getMaterialClassId())) {
                    if (!reqMaterial.getBrandId().equals(material.getMaterialBrandId()) || !CommonUtils.isContain((List)reqMaterial.getCategories(), (String)material.getMaterialClassId()) || !exceptSaleAttrAndInventory) break;
                    return true;
                }
                if (StringUtils.isNotEmpty((CharSequence)material.getMaterialBrandId()) && reqMaterial.getBrandId().equals(material.getMaterialBrandId()) && exceptSaleAttrAndInventory) {
                    return true;
                }
                if (!StringUtils.isNotEmpty((CharSequence)material.getMaterialClassId()) || !CommonUtils.isContain((List)reqMaterial.getCategories(), (String)material.getMaterialClassId()) || !exceptSaleAttrAndInventory) break;
                return true;
            }
            default: {
                return false;
            }
        }
        return false;
    }

    public static boolean exceptSaleAttrAndInventoryEqual(MaterialEntity material, MaterialEntryEntity reqMaterial) {
        if (material.getSaleAttr().size() == 0 && material.getInventoryType().size() == 0) {
            return true;
        }
        if (material.getSaleAttr().size() > 0 && material.getInventoryType().size() > 0) {
            if (material.getSaleAttr().contains(reqMaterial.getSaleAttr()) && material.getInventoryType().contains(reqMaterial.getInventoryType())) {
                return true;
            }
        } else {
            if (material.getSaleAttr().size() > 0 && material.getSaleAttr().contains(reqMaterial.getSaleAttr())) {
                return true;
            }
            if (material.getInventoryType().size() > 0 && material.getInventoryType().contains(reqMaterial.getInventoryType())) {
                return true;
            }
        }
        return false;
    }
}

