/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.push;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.botp.runtime.SourceRowReport;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.interaction.InteractionContext;
import kd.bos.entity.operate.result.OperateErrorInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.helper.BotpFlowingHelper;
import kd.occ.ocpos.business.inventory.PosStoreSerialCvtHelper;

public class AutoPushHelper {
    private static final Log log = LogFactory.getLog(AutoPushHelper.class);

    public static OperationResult autoPushBill(Object pkValue, String sourceEntityNumber, String targetEntityNumber, String opNumber) {
        ConvertOperationResult convertResult;
        ArrayList<ListSelectedRow> list = new ArrayList<ListSelectedRow>();
        ListSelectedRow listSelectedRow = new ListSelectedRow(pkValue);
        list.add(listSelectedRow);
        PushArgs pushArgs = new PushArgs(sourceEntityNumber, targetEntityNumber, list);
        Set<Object> targetBillIds = new HashSet();
        if (targetEntityNumber.equals("im_saloutbill")) {
            convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
            if (convertResult.isSuccess()) {
                MainEntityType mainEntityType = EntityMetadataCache.getDataEntityType((String)pushArgs.getTargetEntityNumber());
                List targetDos = convertResult.loadTargetDataObjects(BusinessDataServiceHelper::loadRefence, mainEntityType);
                for (DynamicObject targetDo : targetDos) {
                    SaveServiceHelper.saveOperate((String)"im_saloutbill", (DynamicObject[])new DynamicObject[]{targetDo}, (OperateOption)OperateOption.create());
                    targetBillIds.add(targetDo.getPkValue());
                }
            }
        } else {
            convertResult = ConvertServiceHelper.pushAndSave((PushArgs)pushArgs);
            targetBillIds = convertResult.getTargetBillIds();
        }
        BotpFlowingHelper.insertBotpFlowing((ConvertOperationResult)convertResult, (Object)pkValue, targetBillIds);
        if (!convertResult.isSuccess()) {
            OperationResult opResult = new OperationResult();
            opResult.setBillCount(1);
            opResult.setShowMessage(false);
            StringBuilder sbMsg = new StringBuilder();
            ArrayList<OperateErrorInfo> lstErrorInfo = new ArrayList<OperateErrorInfo>(0);
            OperateErrorInfo errorInfo = new OperateErrorInfo();
            sbMsg.append(convertResult.getMessage());
            List billReports = convertResult.getBillReports();
            if (!CollectionUtils.isEmpty((Collection)billReports)) {
                for (SourceBillReport report : billReports) {
                    List sourceRowReport = report.getLinkEntityRowReports();
                    if (CollectionUtils.isEmpty((Collection)sourceRowReport)) continue;
                    for (SourceRowReport rowReport : sourceRowReport) {
                        rowReport.getFailMessages().forEach(sbMsg::append);
                    }
                }
            }
            if (sbMsg.length() > 0) {
                errorInfo.setMessage(sbMsg.toString());
            } else {
                errorInfo.setMessage("\u65e0\u9519\u8bef\u63d0\u793a");
            }
            lstErrorInfo.add(errorInfo);
            opResult.setSuccess(false);
            opResult.setAllErrorInfo(lstErrorInfo);
            return opResult;
        }
        OperationResult operationResult = null;
        if (targetBillIds != null && targetBillIds.size() != 0) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", String.valueOf(true));
            DynamicObject[] targetBills = BusinessDataServiceHelper.load((Object[])targetBillIds.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)targetEntityNumber));
            switch (opNumber) {
                case "submit": {
                    operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityNumber, (DynamicObject[])targetBills, (OperateOption)option);
                    if (operationResult.isSuccess()) break;
                    StringBuilder errorMessage = new StringBuilder();
                    errorMessage.append(operationResult.getMessage());
                    errorMessage.append(ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo()));
                    if (operationResult.getInteractionContext() != null) {
                        errorMessage.append(operationResult.getInteractionContext().getSimpleMessage());
                    }
                    BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)errorMessage.toString());
                    return operationResult;
                }
                case "audit": {
                    log.info("\u5ba1\u6838\u4fdd\u5b58\u5e8f\u5217\u53f71:" + StringUtils.join((Object[])targetBillIds.toArray(), (String)","));
                    PosStoreSerialCvtHelper.storeSnCvtBill(sourceEntityNumber, targetEntityNumber, targetBillIds);
                    operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityNumber, (DynamicObject[])targetBills, (OperateOption)option);
                    if (!operationResult.isSuccess()) {
                        StringBuilder errorMessage = new StringBuilder();
                        errorMessage.append(operationResult.getMessage());
                        errorMessage.append(ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo()));
                        if (operationResult.getInteractionContext() != null) {
                            errorMessage.append(operationResult.getInteractionContext().getSimpleMessage());
                        }
                        BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)errorMessage.toString());
                        return operationResult;
                    }
                    operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)targetEntityNumber, (DynamicObject[])targetBills, (OperateOption)option);
                    if (!operationResult.isSuccess()) {
                        StringBuilder errorMessage = new StringBuilder();
                        errorMessage.append(operationResult.getMessage());
                        errorMessage.append(ObjectUtils.nullSafeToString((Object)operationResult.getAllErrorOrValidateInfo()));
                        if (operationResult.getInteractionContext() != null) {
                            errorMessage.append(operationResult.getInteractionContext().getSimpleMessage());
                        }
                        BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)errorMessage.toString());
                        return operationResult;
                    }
                    InteractionContext interactionCtx = operationResult.getInteractionContext();
                    if (interactionCtx == null) break;
                    ArrayList<OperateErrorInfo> lstErrorInfo = new ArrayList<OperateErrorInfo>(0);
                    OperateErrorInfo errorInfo = new OperateErrorInfo();
                    errorInfo.setMessage(interactionCtx.getSimpleMessage().replace("</br>", ""));
                    lstErrorInfo.add(errorInfo);
                    operationResult.setSuccess(false);
                    operationResult.setAllErrorInfo(lstErrorInfo);
                    break;
                }
            }
        }
        BotpFlowingHelper.updateTargetBillStatus(targetBillIds, (String)targetEntityNumber, (String)"");
        return operationResult;
    }
}

