/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.common.enums.SaleStatusEnum;

public class AbnormalCompensationHelper {
    private static final Log log = LogFactory.getLog(AbnormalCompensationHelper.class);

    public static void doTask() {
        try {
            AbnormalCompensationHelper.submitSaleOrder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AbnormalCompensationHelper.submitDeliveryOrder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AbnormalCompensationHelper.auditDeliveryOrder();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            AbnormalCompensationHelper.pushDeliveryOrder();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void submitSaleOrder() {
        HashSet<Object> ids = new HashSet<Object>(0);
        QFilter qFilter = new QFilter("salestatus", "=", (Object)SaleStatusEnum.STATUS_S.getValue());
        qFilter.and("billstatus", "=", (Object)EnumBillStatus.B);
        qFilter.and("finentity", "!=", (Object)0L);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.setTime(TimeServiceHelper.now());
        beforeTime.add(12, -10);
        Date tenMinutesBefore = beforeTime.getTime();
        qFilter.and("createtime", ">", (Object)DateUtil.getBeforeDay((Date)TimeServiceHelper.now()));
        qFilter.and("createtime", "<=", (Object)tenMinutesBefore);
        DataSet abnormalSaleOrder = QueryServiceHelper.queryDataSet((String)AbnormalCompensationHelper.class.getName(), (String)"ocpos_saleorder", (String)"id", (QFilter[])qFilter.toArray(), null);
        while (abnormalSaleOrder.hasNext()) {
            Row row = abnormalSaleOrder.next();
            ids.add(row.get("id"));
        }
        DynamicObject[] targetBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocpos_saleorder"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        for (DynamicObject targetBill : targetBills) {
            try {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ocpos_saleorder", (DynamicObject[])new DynamicObject[]{targetBill}, (OperateOption)option);
                if (operationResult.isSuccess()) continue;
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u5ba1\u6838\u5931\u8d25" + operationResult.getAllErrorOrValidateInfo());
            }
            catch (Exception exception) {
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u5ba1\u6838\u62a5\u9519" + AbnormalCompensationHelper.getStackMsg(exception));
            }
        }
    }

    private static void submitDeliveryOrder() {
        HashSet<Object> ids = new HashSet<Object>(0);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)EnumBillStatus.A);
        QFilter filter = new QFilter("billtype", "=", (Object)1047118809342782464L);
        filter.or("billtype", "=", (Object)1047119905381539840L);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.setTime(TimeServiceHelper.now());
        beforeTime.add(12, -10);
        Date tenMinutesBefore = beforeTime.getTime();
        qFilter.and("createtime", ">", (Object)DateUtil.getBeforeDay((Date)TimeServiceHelper.now()));
        qFilter.and("createtime", "<=", (Object)tenMinutesBefore);
        qFilter.and(filter);
        DataSet abnormalDeliveryOrder = QueryServiceHelper.queryDataSet((String)AbnormalCompensationHelper.class.getName(), (String)"ocococ_deliveryorder", (String)"id", (QFilter[])qFilter.toArray(), null);
        while (abnormalDeliveryOrder.hasNext()) {
            Row row = abnormalDeliveryOrder.next();
            ids.add(row.get("id"));
        }
        DynamicObject[] targetBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocococ_deliveryorder"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        for (DynamicObject targetBill : targetBills) {
            try {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"submit", (String)"ocococ_deliveryorder", (DynamicObject[])new DynamicObject[]{targetBill}, (OperateOption)option);
                if (operationResult.isSuccess()) continue;
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u63d0\u4ea4\u5931\u8d25" + operationResult.getAllErrorOrValidateInfo());
            }
            catch (Exception exception) {
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u63d0\u4ea4\u62a5\u9519" + AbnormalCompensationHelper.getStackMsg(exception));
            }
        }
    }

    private static void auditDeliveryOrder() {
        HashSet<Object> ids = new HashSet<Object>(0);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)EnumBillStatus.B);
        QFilter filter = new QFilter("billtype", "=", (Object)1047118809342782464L);
        filter.or("billtype", "=", (Object)1047119905381539840L);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.setTime(TimeServiceHelper.now());
        beforeTime.add(12, -10);
        Date tenMinutesBefore = beforeTime.getTime();
        qFilter.and("createtime", ">", (Object)DateUtil.getBeforeDay((Date)TimeServiceHelper.now()));
        qFilter.and("createtime", "<=", (Object)tenMinutesBefore);
        qFilter.and(filter);
        DataSet abnormalDeliveryOrder = QueryServiceHelper.queryDataSet((String)AbnormalCompensationHelper.class.getName(), (String)"ocococ_deliveryorder", (String)"id", (QFilter[])qFilter.toArray(), null);
        while (abnormalDeliveryOrder.hasNext()) {
            Row row = abnormalDeliveryOrder.next();
            ids.add(row.get("id"));
        }
        DynamicObject[] targetBills = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)"ocococ_deliveryorder"));
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", String.valueOf(true));
        for (DynamicObject targetBill : targetBills) {
            try {
                OperationResult operationResult = OperationServiceHelper.executeOperate((String)"audit", (String)"ocococ_deliveryorder", (DynamicObject[])new DynamicObject[]{targetBill}, (OperateOption)option);
                if (operationResult.isSuccess()) continue;
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u63d0\u4ea4\u5ba1\u6838" + operationResult.getAllErrorOrValidateInfo());
            }
            catch (Exception exception) {
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u5ba1\u6838\u62a5\u9519" + AbnormalCompensationHelper.getStackMsg(exception));
            }
        }
    }

    private static void pushDeliveryOrder() {
        HashSet<Object> ids = new HashSet<Object>(0);
        QFilter qFilter = new QFilter("billstatus", "=", (Object)EnumBillStatus.C);
        qFilter.and("entryentity.invqty", "=", (Object)0L);
        QFilter filter = new QFilter("billtype", "=", (Object)1047118809342782464L);
        filter.or("billtype", "=", (Object)1047119905381539840L);
        Calendar beforeTime = Calendar.getInstance();
        beforeTime.setTime(TimeServiceHelper.now());
        beforeTime.add(12, -10);
        Date tenMinutesBefore = beforeTime.getTime();
        qFilter.and("createtime", "<=", (Object)tenMinutesBefore);
        qFilter.and("createtime", ">", (Object)DateUtil.getBeforeDay((Date)TimeServiceHelper.now()));
        qFilter.and(filter);
        DataSet abnormalDeliveryOrder = QueryServiceHelper.queryDataSet((String)AbnormalCompensationHelper.class.getName(), (String)"ocococ_deliveryorder", (String)"id", (QFilter[])qFilter.toArray(), null);
        while (abnormalDeliveryOrder.hasNext()) {
            Row row = abnormalDeliveryOrder.next();
            ids.add(row.get("id"));
        }
        for (Object e : ids) {
            boolean flag = BFTrackerServiceHelper.isPush((String)"ocococ_deliveryorder", (Long)Long.parseLong(ObjectUtils.nullSafeToString(e)));
            if (flag) continue;
            qFilter = new QFilter("id", "=", e);
            DynamicObject targetBill = QueryServiceHelper.queryOne((String)"ocococ_deliveryorder", (String)"billno", (QFilter[])qFilter.toArray());
            try {
                OperationResult operationResult = AutoPushHelper.autoPushBill(e, "ocococ_deliveryorder", "im_saloutbill", "audit");
                if (operationResult.isSuccess()) continue;
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u4e0b\u63a8\u6267\u884c\u5931\u8d25" + operationResult.getAllErrorOrValidateInfo());
            }
            catch (Exception exception) {
                if (targetBill == null) continue;
                log.info("\u8ba2\u5355\u53f7\uff1a" + targetBill.get("billno") + " \u4e0b\u63a8\u62a5\u9519" + AbnormalCompensationHelper.getStackMsg(exception));
            }
        }
    }

    private static String getStackMsg(Throwable e) {
        StackTraceElement[] stackArray;
        StringBuilder sb = new StringBuilder();
        for (StackTraceElement element : stackArray = e.getStackTrace()) {
            sb.append(element.toString()).append("\n");
        }
        return sb.toString();
    }
}

