/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.pos.ItemClassNodeUtil;
import kd.occ.ocdbd.common.util.StringUtil;
import kd.occ.ocpos.common.util.CommonUtil;

public class ElectWarrantyHelper {
    private static final Log LOG = LogFactory.getLog(ElectWarrantyHelper.class, (String)"ocpos");

    public static void addNewElectWarranty(DynamicObject saleOrder) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
                DynamicObjectCollection goodsEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
                DynamicObject[] electWarrantyModes = ElectWarrantyHelper.getElectWarrantyModes(branchId, new ArrayList<DynamicObject>((Collection<DynamicObject>)goodsEntities));
                ElectWarrantyHelper.matchElectWarrantyModes(saleOrder, branchId, goodsEntities, electWarrantyModes);
            }
            catch (Exception ex) {
                handle.markRollback();
                LOG.error("\u7535\u5b50\u4fdd\u4fee\u5355\u751f\u6210\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + StringUtil.getErrorMsg((Exception)ex));
            }
        }
    }

    public static DynamicObject[] getElectWarrantyModes(long branchId, List<DynamicObject> goodsEntities) {
        int size = goodsEntities.size();
        HashSet<Long> goodsIds = new HashSet<Long>(size);
        goodsEntities.forEach(x -> {
            long goodsId;
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"isbook");
            if (!isBook && (goodsId = DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"goodsid")) > 0L) {
                goodsIds.add(goodsId);
            }
        });
        return ElectWarrantyHelper.getElectWarrantyModes(branchId, goodsIds);
    }

    public static void updateElectWarranty(List<Long> entryIds) {
        DynamicObject[] entryEntities;
        Throwable throwable;
        TXHandle handle;
        block19: {
            block20: {
                block21: {
                    handle = TX.requiresNew();
                    throwable = null;
                    ORM orm = ORM.create();
                    DynamicObjectType entityType = (DynamicObjectType)orm.getDataEntityType("ocpos_saleorder.goodsentryentity");
                    entryEntities = BusinessDataServiceHelper.load((Object[])entryIds.toArray(), (DynamicObjectType)entityType);
                    if (entryEntities != null && entryEntities.length > 0) break block19;
                    if (handle == null) break block20;
                    if (throwable == null) break block21;
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    break block20;
                }
                handle.close();
            }
            return;
        }
        try {
            try {
                ArrayList<Object[]> params = new ArrayList<Object[]>();
                for (DynamicObject entryEntity : entryEntities) {
                    DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
                    if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
                    ArrayList<Object> values = new ArrayList<Object>(16);
                    String closeStatus = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"rowclosestatus");
                    values.add(closeStatus);
                    long deliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)deliveryEntities.get(0)), (String)"deliverystatus");
                    values.add(deliveryStatusId);
                    long entryId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity);
                    values.add(entryId);
                    params.add(values.toArray());
                }
                if (!CollectionUtils.isEmpty(params)) {
                    String updateSql = "update t_ocpos_electwarranty set fclosestatus = ?, fdeliverystatus = ? where fbillentryid = ?";
                    DB.executeBatch((DBRoute)new DBRoute("drp"), (String)updateSql, params);
                }
            }
            catch (Exception ex) {
                handle.markRollback();
                LOG.error("\u7535\u5b50\u4fdd\u4fee\u5355\u751f\u6210\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + StringUtil.getErrorMsg((Exception)ex));
            }
        }
        catch (Throwable throwable3) {
            throwable = throwable3;
            throw throwable3;
        }
        catch (Throwable throwable4) {
            throw throwable4;
        }
        finally {
            if (handle != null) {
                if (throwable != null) {
                    try {
                        handle.close();
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                } else {
                    handle.close();
                }
            }
        }
    }

    public static DynamicObject[] getElectWarrantyModes(long branchId, Set<Long> goodsIds) {
        QFilter branchFilter0 = new QFilter("controlmethod", "=", (Object)"0");
        QFilter branchFilter1 = new QFilter("treeentryentity.branch.id", "=", (Object)branchId);
        branchFilter1.and("treeentryentity.isapply", "=", (Object)Boolean.TRUE);
        QFilter goodsFilter0 = new QFilter("isallgoods", "=", (Object)Boolean.TRUE);
        QFilter goodsFilter1 = new QFilter("goodsentry.goodsid.id", "in", goodsIds);
        QFilter goodsFilter2 = new QFilter("goodsentry.type", "=", (Object)"2");
        QFilter filter = F7Utils.getCommonStatusFilter();
        filter.and(branchFilter0.or(branchFilter1));
        filter.and(goodsFilter0.or(goodsFilter1).or(goodsFilter2));
        return BusinessDataServiceHelper.load((String)"ocdbd_electwarranty_model", (String)ElectWarrantyHelper.getSelectFields(), (QFilter[])filter.toArray());
    }

    private static String getSelectFields() {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)"ocdbd_electwarranty_model");
        Object[] selectFields = entityType.getAllFields().values().stream().map(IMetadata::getName).toArray();
        return StringUtils.join((Object[])selectFields, (char)',');
    }

    private static void matchElectWarrantyModes(DynamicObject dataEntity, long branchId, DynamicObjectCollection entryEntities, DynamicObject[] electWarrantyModes) {
        ArrayList<DynamicObject> electWarranties = new ArrayList<DynamicObject>();
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObject electWarranty = ElectWarrantyHelper.buildElectWarranty(dataEntity, branchId, entryEntity, electWarrantyModes);
            if (electWarranty == null) continue;
            electWarranties.add(electWarranty);
        }
        if (!CollectionUtils.isEmpty(electWarranties)) {
            SaveServiceHelper.save((DynamicObject[])electWarranties.toArray(new DynamicObject[0]));
        }
    }

    public static DynamicObject buildElectWarranty(DynamicObject dataEntity, long branchId, DynamicObject entryEntity, DynamicObject[] electWarrantyModes) {
        DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
        if (CollectionUtils.isEmpty((Collection)deliveryEntities)) {
            return null;
        }
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
        if (isBook) {
            return null;
        }
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
        long classId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsclass");
        HashSet<Object> classIds = new HashSet(1);
        if (classId != 0L) {
            classIds = ItemClassNodeUtil.queryAllItemClasses(new HashSet<Long>(Collections.singleton(classId)));
        }
        DynamicObject deliveryEntity = (DynamicObject)deliveryEntities.get(0);
        for (DynamicObject electWarrantyMode : electWarrantyModes) {
            String ctrlMode = DynamicObjectUtils.getString((DynamicObject)electWarrantyMode, (String)"controlmethod");
            DynamicObjectCollection branchEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)electWarrantyMode, (String)"treeentryentity");
            boolean isAllGoods = DynamicObjectUtils.getBoolean((DynamicObject)electWarrantyMode, (String)"isallgoods");
            DynamicObjectCollection goodsEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)electWarrantyMode, (String)"goodsentry");
            if (ElectWarrantyHelper.matchSpecificBranch(branchEntities, branchId) && ElectWarrantyHelper.matchSpecificGoods(goodsEntities, goodsId)) {
                return ElectWarrantyHelper.buildElectWarranty(dataEntity, entryEntity, deliveryEntity, electWarrantyMode);
            }
            if (ElectWarrantyHelper.matchSpecificBranch(branchEntities, branchId) && ElectWarrantyHelper.matchSpecificGoodsClass(goodsEntities, classIds)) {
                return ElectWarrantyHelper.buildElectWarranty(dataEntity, entryEntity, deliveryEntity, electWarrantyMode);
            }
            if (ElectWarrantyHelper.matchSpecificBranch(branchEntities, branchId) && isAllGoods) {
                return ElectWarrantyHelper.buildElectWarranty(dataEntity, entryEntity, deliveryEntity, electWarrantyMode);
            }
            if (StringUtils.equals((CharSequence)ctrlMode, (CharSequence)"0") && ElectWarrantyHelper.matchSpecificGoods(goodsEntities, goodsId)) {
                return ElectWarrantyHelper.buildElectWarranty(dataEntity, entryEntity, deliveryEntity, electWarrantyMode);
            }
            if (StringUtils.equals((CharSequence)ctrlMode, (CharSequence)"0") && ElectWarrantyHelper.matchSpecificGoodsClass(goodsEntities, classIds)) {
                return ElectWarrantyHelper.buildElectWarranty(dataEntity, entryEntity, deliveryEntity, electWarrantyMode);
            }
            if (!StringUtils.equals((CharSequence)ctrlMode, (CharSequence)"0") || !isAllGoods) continue;
            return ElectWarrantyHelper.buildElectWarranty(dataEntity, entryEntity, deliveryEntity, electWarrantyMode);
        }
        return null;
    }

    private static boolean matchSpecificBranch(DynamicObjectCollection branchEntities, long branchId) {
        if (CollectionUtils.isEmpty((Collection)branchEntities)) {
            return false;
        }
        return branchEntities.stream().anyMatch(p -> DynamicObjectUtils.getPkValue((DynamicObject)p, (String)"branch") == branchId && DynamicObjectUtils.getBoolean((DynamicObject)p, (String)"isapply"));
    }

    private static boolean matchSpecificGoods(DynamicObjectCollection goodsEntities, long goodsId) {
        if (CollectionUtils.isEmpty((Collection)goodsEntities)) {
            return false;
        }
        return goodsEntities.stream().anyMatch(q -> DynamicObjectUtils.getPkValue((DynamicObject)q, (String)"goodsid") == goodsId);
    }

    private static boolean matchSpecificGoodsClass(DynamicObjectCollection goodsEntities, Set<Object> classIds) {
        if (CollectionUtils.isEmpty((Collection)goodsEntities)) {
            return false;
        }
        return goodsEntities.stream().anyMatch(q -> classIds.contains(DynamicObjectUtils.getPkValue((DynamicObject)q, (String)"goodsclassifyid")) && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)q, (String)"type"), (CharSequence)"2"));
    }

    private static DynamicObject buildElectWarranty(DynamicObject dataEntity, DynamicObject entryEntity, DynamicObject deliveryEntity, DynamicObject electWarrantyMode) {
        DynamicObject electWarranty = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_electwarranty");
        DynamicObject user = ElectWarrantyHelper.getUser();
        ElectWarrantyHelper.fullBaseInfo(user, electWarranty);
        ElectWarrantyHelper.fullMainInfo(dataEntity, entryEntity, deliveryEntity, electWarrantyMode, electWarranty);
        ElectWarrantyHelper.fullOtherInfo(electWarrantyMode, electWarranty);
        return electWarranty;
    }

    private static void fullMainInfo(DynamicObject dataEntity, DynamicObject entryEntity, DynamicObject deliveryEntity, DynamicObject electWarrantyMode, DynamicObject electWarranty) {
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
        electWarranty.set("billno", (Object)billNo);
        String warrantyPeriod = DynamicObjectUtils.getString((DynamicObject)electWarrantyMode, (String)"warrantyperiod");
        electWarranty.set("warrantyperiod", (Object)warrantyPeriod);
        Date effectTime = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        electWarranty.set("effecttime", (Object)effectTime);
        Date predictTime = DateUtil.monthAdd((Date)effectTime, (int)CommonUtil.formatStringToInt((String)warrantyPeriod));
        electWarranty.set("predicttime", (Object)predictTime);
        String closeStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"closestatus");
        electWarranty.set("closestatus", (Object)closeStatus);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
        electWarranty.set("salebranchid", (Object)branch);
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        electWarranty.set("member", (Object)member);
        DynamicObject currency = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"currencyid");
        electWarranty.set("currencyid", (Object)currency);
        String content = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billcomment");
        electWarranty.set("content", (Object)content);
        electWarranty.set("usingzones", (Object)"\u4e2d\u56fd\u5927\u9646");
        long billEntryId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity);
        electWarranty.set("billentryid", (Object)billEntryId);
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodsid");
        electWarranty.set("goodsid", (Object)goods);
        DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materielid");
        electWarranty.set("materielid", (Object)material);
        BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"balamount");
        electWarranty.set("balamount", (Object)balAmount);
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
        electWarranty.set("saleqty", (Object)saleQty);
        DynamicObject unit = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"unit");
        electWarranty.set("unit", (Object)unit);
        DynamicObject saler = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"goodssaler");
        electWarranty.set("saler", (Object)saler);
        DynamicObject dept = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"saledepartment");
        electWarranty.set("saledepartment", (Object)dept);
        String phone = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"deliverphonenumber");
        electWarranty.set("customerphone", (Object)phone);
        String consignee = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"consignee");
        electWarranty.set("customername", (Object)consignee);
        String address = DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"fulladdress");
        electWarranty.set("fulladdress", (Object)address);
        DynamicObject status = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliverystatus");
        electWarranty.set("deliverystatus", (Object)status);
        DynamicObject invType = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliverystocktype");
        electWarranty.set("invtype", (Object)invType);
    }

    private static void fullBaseInfo(DynamicObject user, DynamicObject electWarranty) {
        electWarranty.set("creator", (Object)user);
        electWarranty.set("createtime", (Object)TimeServiceHelper.now());
        electWarranty.set("modifier", (Object)user);
        electWarranty.set("modifytime", (Object)TimeServiceHelper.now());
        electWarranty.set("auditor", (Object)user);
        electWarranty.set("auditdate", (Object)TimeServiceHelper.now());
        electWarranty.set("billstatus", (Object)StatusEnum.AUDIT.getValue());
    }

    private static void fullOtherInfo(DynamicObject electWarrantyMode, DynamicObject electWarranty) {
        DynamicObjectCollection schemeEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)electWarrantyMode, (String)"electscheme");
        if (CollectionUtils.isEmpty((Collection)schemeEntities)) {
            return;
        }
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)electWarranty, (String)"entryentity");
        for (DynamicObject schemeEntity : schemeEntities) {
            DynamicObject entryEntity = entryEntities.addNew();
            String scheme = DynamicObjectUtils.getString((DynamicObject)schemeEntity, (String)"scheme");
            entryEntity.set("scheme", (Object)scheme);
            DynamicObjectCollection contentEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)schemeEntity, (String)"electcontent");
            if (CollectionUtils.isEmpty((Collection)contentEntities)) continue;
            DynamicObjectCollection subEntryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"subentryentity");
            for (DynamicObject contentEntity : contentEntities) {
                DynamicObject subEntryEntity = subEntryEntities.addNew();
                String title = DynamicObjectUtils.getString((DynamicObject)contentEntity, (String)"electtitle");
                subEntryEntity.set("electtitle", (Object)title);
                String content = DynamicObjectUtils.getString((DynamicObject)contentEntity, (String)"schemecontent");
                subEntryEntity.set("schemecontent", (Object)content);
            }
        }
    }

    private static DynamicObject getUser() {
        try {
            long userId = UserServiceHelper.getCurrentUserId();
            return BusinessDataServiceHelper.loadSingle((Object)userId, (String)"bos_user");
        }
        catch (Exception ex) {
            return null;
        }
    }
}

