/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.util.CommonUtil;

public class ReserveServiceHelper {
    public static final String ACTION_SRC_RELEASE = "srcRelease";
    private static final Log LOG = LogFactory.getLog(ReserveServiceHelper.class);

    public static Map<String, Object> release(DynamicObject dataEntity) {
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        boolean isRedRush = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.REDRUSH.getValue());
        boolean isReturn = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.SALERETURN.getValue());
        boolean isChange = StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CHANGE.getValue());
        if (!(isRedRush || isReturn || isChange)) {
            return null;
        }
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return null;
        }
        HashSet<Long> originalEntryIds = new HashSet<Long>(entryEntities.size());
        ArrayList<Long> srcDeliveryIds = new ArrayList<Long>();
        ArrayList<Long> invIds = new ArrayList<Long>();
        DataSetBuilder builder = ReserveServiceHelper.buildSrcReserveDataSet();
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities;
            long srcBillId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"entrysrcbillid");
            if (srcBillId <= 0L || isChange && !StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption"), (CharSequence)"0") || CollectionUtils.isEmpty((Collection)(deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery")))) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                long srcDeliveryId = DynamicObjectUtils.getLong((DynamicObject)deliveryEntity, (String)"srcdeliveryentryid");
                boolean isSrcReserve = DynamicObjectUtils.getBoolean((DynamicObject)deliveryEntity, (String)"deliveryisreserve");
                long originalEntryId = DynamicObjectUtils.getLong((DynamicObject)deliveryEntity, (String)"originalentryid");
                if (srcDeliveryId <= 0L || !isSrcReserve || originalEntryId <= 0L) continue;
                long invId = DynamicObjectUtils.getLong((DynamicObject)deliveryEntity, (String)"invid");
                BigDecimal baseQty = DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliverybaseunitqty");
                BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliversaleqty");
                BigDecimal auxQty = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliveryauxunit") == null ? BigDecimal.ZERO : DynamicObjectUtils.getBigDecimal((DynamicObject)deliveryEntity, (String)"deliveryauxunitqty");
                builder.append(new Object[]{originalEntryId, srcDeliveryId, invId, baseQty.negate(), qty.negate(), auxQty.negate()});
                originalEntryIds.add(originalEntryId);
                srcDeliveryIds.add(srcDeliveryId);
                invIds.add(invId);
            }
        }
        if (!CollectionUtils.isEmpty(srcDeliveryIds)) {
            Map<Object, Object> result;
            try (TXHandle handle = TX.requiresNew();){
                try {
                    DataSet build = builder.build();
                    DataSet copy = build.copy();
                    result = ReserveServiceHelper.reserveRelease(build, originalEntryIds, invIds);
                    boolean isSuccess = CommonUtil.formatObjectToBoolean((Object)result.get("releaseResult"));
                    if (isSuccess) {
                        ReserveServiceHelper.updateSrcData(srcDeliveryIds, copy);
                    }
                }
                catch (Exception ex) {
                    handle.markRollback();
                    result = new HashMap<String, Boolean>(2);
                    result.put("releaseResult", Boolean.FALSE);
                    result.put("errorMsg", String.format("\u6e90\u5355\u9884\u7559\u91ca\u653e\u5931\u8d25, \u539f\u56e0\uff1a%s\u3002", ex.getMessage()));
                }
            }
            return result;
        }
        return null;
    }

    private static void updateSrcData(List<Long> deliveryIds, DataSet reserveData) {
        QFilter filter = new QFilter("goodsentryentity.salesorderdelivery.id", "in", deliveryIds);
        Object[] deliverySelectFields = ReserveServiceHelper.getDeliverySelectFields();
        String selectFields = StringUtils.join((Object[])deliverySelectFields, (char)',');
        DataSet deliveryData = QueryServiceHelper.queryDataSet((String)"delivery", (String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray(), null);
        String[] fields = ReserveServiceHelper.getSelectFields();
        DataSet data = deliveryData.fullJoin(reserveData).on("goodsentryentity.salesorderdelivery.id", "srcdeliveryentryid").select((String[])deliverySelectFields, fields).finish();
        if (!data.isEmpty()) {
            ArrayList<Object[]> params = new ArrayList<Object[]>(16);
            while (data.hasNext()) {
                Row item = data.next();
                long detailId = item.getLong("goodsentryentity.salesorderdelivery.id");
                BigDecimal qty = item.getBigDecimal("goodsentryentity.salesorderdelivery.deliveryreserveqty").abs();
                BigDecimal baseQty = item.getBigDecimal("goodsentryentity.salesorderdelivery.deliveryreservebaseqty").abs();
                BigDecimal releaseQty = item.getBigDecimal("deliversaleqty");
                BigDecimal releaseBaseQty = item.getBigDecimal("deliverybaseunitqty");
                ArrayList<Comparable<Boolean>> value = new ArrayList<Comparable<Boolean>>(4);
                if (qty.compareTo(releaseQty) <= 0) {
                    value.add(Boolean.FALSE);
                    value.add(BigDecimal.ZERO);
                    value.add(BigDecimal.ZERO);
                } else {
                    value.add(Boolean.TRUE);
                    value.add(qty.subtract(releaseQty));
                    value.add(baseQty.subtract(releaseBaseQty));
                }
                value.add(Long.valueOf(detailId));
                params.add(value.toArray());
            }
            if (!CollectionUtils.isEmpty(params)) {
                try (TXHandle handle = TX.requiresNew();){
                    try {
                        String updateSql = "update t_ocpos_saleorderdr set fisreserve = ?, freserveqty = ?, freservebaseqty = ? where FDetailId = ?";
                        DB.executeBatch((DBRoute)new DBRoute("drp"), (String)updateSql, params);
                    }
                    catch (Exception ex) {
                        handle.markRollback();
                        throw ex;
                    }
                }
            }
        }
    }

    private static Map<String, Object> reserveRelease(DataSet reserveData, Set<Long> originalEntryIds, List<Long> invIds) {
        HashMap<String, Object> result = new HashMap<String, Object>(2);
        List<Map<String, Object>> params = ReserveServiceHelper.buildReleaseParams(reserveData, originalEntryIds, invIds);
        if (CollectionUtils.isEmpty(params)) {
            result.put("releaseResult", Boolean.FALSE);
            result.put("errorMsg", "\u6e90\u5355\u9884\u7559\u91ca\u653e\u5931\u8d25, \u539f\u56e0\uff1a\u53c2\u6570\u5f02\u5e38\u3002");
            return result;
        }
        LOG.info("\u6e90\u5355\u9884\u7559\u91ca\u653e\u4f20\u53c2\uff1a" + JSONObject.toJSONString(params));
        DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveReleaseBatch", (Object[])new Object[]{params});
        result.put("releaseResult", Boolean.TRUE);
        result.put("errorMsg", "");
        return result;
    }

    private static List<Map<String, Object>> buildReleaseParams(DataSet reserveData, Set<Long> originalEntryIds, List<Long> invIds) {
        DataSet reserveRecord = ReserveServiceHelper.getReserveRecord(originalEntryIds, invIds);
        DataSet data = reserveRecord.fullJoin(reserveData).on("billentry_id", "originalentryid").on("bal_id", "invid").select(new String[]{"id"}, ReserveServiceHelper.getSelectFields()).finish();
        if (data.isEmpty()) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(16);
        while (data.hasNext()) {
            Row item = data.next();
            HashMap<String, Object> param = new HashMap<String, Object>(5);
            param.put("reserve_record", item.getLong("id"));
            param.put("base_qty", item.getBigDecimal("deliverybaseunitqty"));
            param.put("qty", item.getBigDecimal("deliversaleqty"));
            param.put("qty2nd", item.getBigDecimal("deliveryauxunitqty"));
            param.put("release_type", "remove");
            params.add(param);
        }
        return params;
    }

    private static DataSet getReserveRecord(Set<Long> originalEntryIds, List<Long> invIds) {
        QFilter filter = new QFilter("billentry_id", "in", originalEntryIds);
        filter.and("bal_id", "in", invIds);
        filter.and("qty", ">", (Object)BigDecimal.ZERO);
        filter.and("base_qty", ">", (Object)BigDecimal.ZERO);
        return QueryServiceHelper.queryDataSet((String)"Record", (String)"msmod_reserve_record", (String)"id, billentry_id, bal_id", (QFilter[])filter.toArray(), null);
    }

    private static DataSetBuilder buildSrcReserveDataSet() {
        ArrayList<Field> fields = new ArrayList<Field>();
        fields.add(new Field("originalentryid", (DataType)DataType.LongType));
        fields.add(new Field("srcdeliveryentryid", (DataType)DataType.LongType));
        fields.add(new Field("invid", (DataType)DataType.LongType));
        fields.add(new Field("deliverybaseunitqty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("deliversaleqty", (DataType)DataType.BigDecimalType));
        fields.add(new Field("deliveryauxunitqty", (DataType)DataType.BigDecimalType));
        RowMeta meta = new RowMeta(fields.toArray(new Field[0]));
        return Algo.create((String)"Reserve").createDataSetBuilder(meta);
    }

    private static String[] getSelectFields() {
        return new String[]{"deliverybaseunitqty", "deliversaleqty", "deliveryauxunitqty"};
    }

    private static String[] getDeliverySelectFields() {
        ArrayList<String> selectFields = new ArrayList<String>();
        selectFields.add("goodsentryentity.salesorderdelivery.id");
        selectFields.add("goodsentryentity.salesorderdelivery.deliveryisreserve");
        selectFields.add("goodsentryentity.salesorderdelivery.deliveryreserveqty");
        selectFields.add("goodsentryentity.salesorderdelivery.deliveryreservebaseqty");
        selectFields.add("goodsentryentity.salesorderdelivery.invid");
        return selectFields.toArray(new String[0]);
    }
}

