/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.EnumBillStatus;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.constants.PriceFetchParam;
import kd.occ.ocbase.common.constants.PriceFetchResult;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.ORMUtil;
import kd.occ.ocbase.common.util.PriceServiceUtil;
import kd.occ.ocpos.business.saleorder.SaleConvertAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderBalancePolicyHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderBookPolicyHelper;
import kd.occ.ocpos.business.saleorder.SaleReturnAmountHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.CloseStatusEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleAmountHelper {
    private static final Log LOG = LogFactory.getLog(SaleAmountHelper.class);

    public static void updateCvtAmountFieldsByQty(DynamicObject dataEntity, long billTypeId, DynamicObject entryEntity) {
        if (billTypeId != BillTypeEnum.CVTSALE.getId()) {
            return;
        }
        long srcBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        if (srcBillId != 0L && !isNotConfirm) {
            Map<String, BigDecimal> result = SaleAmountHelper.getData(dataEntity, billTypeId, entryEntity, srcBillId);
            SaleAmountHelper.setData(result, entryEntity);
        } else {
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
            Map<String, BigDecimal> resultMap = SaleOrderAmountHelper.getRecalculateLineAmountMap(entryEntity, "saleqty", saleQty, true);
            SaleAmountHelper.setData(resultMap, entryEntity);
            if (StringUtils.endsWith((CharSequence)dataEntity.getDataEntityType().getName(), (CharSequence)"ocpos_saleorder")) {
                SaleOrderAmountHelper.recalculateShareAmount(dataEntity);
            }
        }
    }

    public static void updateSaleAmountFields(DynamicObject dataEntity, DynamicObject entryEntity, String fieldKey, BigDecimal value) {
        boolean isConfirm;
        Object billType = DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"basebilltype");
        long billTypeId = 0L;
        if (billType instanceof DynamicObject) {
            billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)billType));
        } else if (billType instanceof Long) {
            billTypeId = CommonUtil.formatObejctToLong((Object)billType);
        } else if (billType instanceof String) {
            billTypeId = CommonUtil.formatStringToLong((String)((String)billType));
        }
        boolean isClearShareAmt = true;
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            String changeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            if (!StringUtils.equals((CharSequence)changeType, (CharSequence)"2")) {
                isClearShareAmt = false;
            }
        } else if (billTypeId == BillTypeEnum.CVTSALE.getId() && !(isConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm"))) {
            isClearShareAmt = false;
        }
        Map<String, BigDecimal> resultMap = SaleOrderAmountHelper.getRecalculateLineAmountMap(entryEntity, fieldKey, value, isClearShareAmt);
        SaleAmountHelper.setData(resultMap, entryEntity);
        if (StringUtils.endsWith((CharSequence)dataEntity.getDataEntityType().getName(), (CharSequence)"ocpos_saleorder")) {
            SaleOrderAmountHelper.recalculateShareAmount(dataEntity);
        }
    }

    public static void updateReturnAmountFieldsByQty(DynamicObject dataEntity, long billTypeId, DynamicObject entryEntity) {
        long srcBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        if (srcBillId != 0L) {
            Map<String, BigDecimal> result = SaleAmountHelper.getData(dataEntity, billTypeId, entryEntity, srcBillId);
            SaleAmountHelper.setData(result, entryEntity);
        } else {
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
            SaleAmountHelper.updateReturnAmountFields(dataEntity, entryEntity, billTypeId, "saleqty", saleQty);
        }
    }

    public static void updateReturnAmountFields(DynamicObject dataEntity, DynamicObject entryEntity, long billTypeId, String key, BigDecimal value) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        Map<String, BigDecimal> result = SaleReturnAmountHelper.getLineAmountMap(entryEntity, orgId, branchId, key, value);
        SaleAmountHelper.setData(result, entryEntity);
    }

    public static void setData(Map<String, BigDecimal> result, DynamicObject entryEntity) {
        if (!CollectionUtils.isEmpty(result)) {
            DynamicObjectType entryType = entryEntity.getDynamicObjectType();
            for (Map.Entry<String, BigDecimal> entry : result.entrySet()) {
                String key = entry.getKey();
                if (!entryType.getProperties().containsKey((Object)key)) continue;
                entryEntity.set(key, (Object)entry.getValue());
            }
        }
    }

    private static Map<String, BigDecimal> getData(DynamicObject dataEntity, long billTypeId, DynamicObject entryEntity, long srcBillId) {
        DynamicObject srcDataEntity = BusinessDataServiceHelper.loadSingle((Object)srcBillId, (String)"ocpos_saleorder");
        if (srcDataEntity != null) {
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
            long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
            long srcEntryId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"srcbillentryid");
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
            boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)dataEntity, (DynamicObject)entryEntity);
            if (isChangeReturnOrReturn) {
                return SaleReturnAmountHelper.getLineAmountMapBySaleQty(srcDataEntity, srcEntryId, orgId, branchId, saleQty);
            }
            if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
                return SaleConvertAmountHelper.getLineAmountMapBySaleQty(srcDataEntity, srcEntryId, saleQty);
            }
            return null;
        }
        return null;
    }

    public static String checkBalAmount(DynamicObject itemEntry, String fieldKey, BigDecimal fieldValue) {
        String tip = "";
        BigDecimal amount = itemEntry.getBigDecimal("amount");
        BigDecimal notincomedisamount = itemEntry.getBigDecimal("notincomedisamount");
        BigDecimal stddiscountamount = itemEntry.getBigDecimal("stddiscountamount");
        BigDecimal ticketshareamount = itemEntry.getBigDecimal("ticketshareamount");
        switch (fieldKey) {
            case "notincomedisamount": {
                notincomedisamount = fieldValue;
                break;
            }
            case "stddiscountamount": {
                stddiscountamount = fieldValue;
                break;
            }
            case "ticketshareamount": {
                ticketshareamount = fieldValue;
                break;
            }
        }
        boolean isReturnRow = SaleAmountHelper.isReturnRowData(itemEntry);
        BigDecimal balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount);
        if (!isReturnRow && balamount.compareTo(BigDecimal.ZERO) < 0) {
            NumberFormat currency = NumberFormat.getCurrencyInstance();
            tip = String.format("\u8f93\u5165\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7 %s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", currency.format(balamount.add(fieldValue)));
        }
        return tip;
    }

    public static String depositChanged(IFormView view, DynamicObject dataEntity, DynamicObject entryItem, String fieldKey, BigDecimal fieldValue) {
        BigDecimal manualdiscount;
        String tip = "";
        boolean isBook = entryItem.getBoolean("isbook");
        if (!isBook) {
            return tip;
        }
        BigDecimal deposit = fieldValue;
        BigDecimal balamount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        BigDecimal mustBalamount = balamount.subtract(manualdiscount = entryItem.getBigDecimal("manualdiscount"));
        if (mustBalamount.compareTo(BigDecimal.ZERO) == 0) {
            return tip;
        }
        BigDecimal depositScale = deposit.multiply(BigDecimal.valueOf(100L)).divide(mustBalamount, 2, RoundingMode.HALF_UP);
        if (deposit.compareTo(mustBalamount) > 0) {
            NumberFormat currency = NumberFormat.getCurrencyInstance();
            tip = String.format("\u8ba2\u91d1\u4e0d\u80fd\u8d85\u8fc7 %s (\u5b9e\u4ef7\u91d1\u989d-\u624b\u5de5\u4f18\u60e0\u989d)\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", currency.format(mustBalamount));
            return tip;
        }
        tip = SaleOrderBookPolicyHelper.depositScaleAboutFieldChanged(view, dataEntity, entryItem, fieldKey, mustBalamount, depositScale);
        return tip;
    }

    public static String depositScaleChanged(IFormView view, DynamicObject dataEntity, DynamicObject entryItem, String fieldKey, BigDecimal fieldValue) {
        String saleOption;
        BigDecimal manualdiscount;
        String tip = "";
        boolean isBook = entryItem.getBoolean("isbook");
        if (!isBook) {
            return tip;
        }
        BigDecimal depositScale = fieldValue;
        BigDecimal balamount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        BigDecimal mustBalamount = balamount.subtract(manualdiscount = entryItem.getBigDecimal("manualdiscount"));
        BigDecimal deposit = mustBalamount.multiply(depositScale).divide(BigDecimal.valueOf(100L), 2, RoundingMode.HALF_UP);
        if (deposit.compareTo(mustBalamount) > 0 && !StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"saleoption")), (CharSequence)"0")) {
            tip = "\u8ba2\u91d1\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7100\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002";
            return tip;
        }
        tip = SaleOrderBookPolicyHelper.depositScaleAboutFieldChanged(view, dataEntity, entryItem, fieldKey, mustBalamount, depositScale);
        return tip;
    }

    public static String finalPaymentChanged(IFormView view, DynamicObject dataEntity, DynamicObject entryItem, String fieldKey, BigDecimal fieldValue) {
        String tip = "";
        boolean isBook = entryItem.getBoolean("isbook");
        if (isBook) {
            return tip;
        }
        BigDecimal finalpayment = fieldValue;
        BigDecimal receivedfinalpayment = entryItem.getBigDecimal("receivedfinalpayment");
        BigDecimal norecefinalamount = finalpayment.subtract(receivedfinalpayment);
        BigDecimal balamount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        BigDecimal manualdiscount = entryItem.getBigDecimal("manualdiscount");
        BigDecimal deposit = entryItem.getBigDecimal("deposit");
        BigDecimal linereceivableamount = balamount.subtract(manualdiscount).subtract(deposit).subtract(norecefinalamount);
        BigDecimal finalpaymentScale = BigDecimal.ZERO;
        BigDecimal mustBalamount = balamount.subtract(manualdiscount);
        boolean isReturnRow = SaleAmountHelper.isReturnRowData(dataEntity);
        if (!isReturnRow && linereceivableamount.compareTo(BigDecimal.ZERO) < 0 || isReturnRow && linereceivableamount.compareTo(BigDecimal.ZERO) > 0) {
            NumberFormat currency = NumberFormat.getCurrencyInstance();
            tip = String.format("\u8f93\u5165\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7 %s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", currency.format(linereceivableamount.add(norecefinalamount)));
            return tip;
        }
        BigDecimal oneHundred = new BigDecimal(100);
        if (mustBalamount.compareTo(BigDecimal.ZERO) != 0) {
            finalpaymentScale = finalpayment.multiply(oneHundred).divide(mustBalamount, 2, RoundingMode.HALF_UP);
        } else if (finalpayment.compareTo(BigDecimal.ZERO) != 0) {
            finalpaymentScale = oneHundred;
        }
        if (fieldValue.abs().compareTo(mustBalamount.abs()) > 0) {
            NumberFormat currency = NumberFormat.getCurrencyInstance();
            tip = String.format("\u8ba2\u91d1\u4e0d\u80fd\u8d85\u8fc7 %s (\u5b9e\u4ef7\u91d1\u989d-\u624b\u5de5\u4f18\u60e0\u989d)\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", currency.format(mustBalamount));
            return tip;
        }
        if (!isReturnRow) {
            tip = SaleOrderBalancePolicyHelper.finalpaymentScaleAboutFieldChanged(view, dataEntity, entryItem, fieldKey, mustBalamount, finalpaymentScale);
        }
        return tip;
    }

    public static String finalPaymentScaleChanged(IFormView view, DynamicObject dataEntity, DynamicObject entryItem, String fieldKey, BigDecimal fieldValue) {
        String saleOption;
        String tip = "";
        boolean isBook = entryItem.getBoolean("isbook");
        if (isBook) {
            return tip;
        }
        BigDecimal finalpaymentScale = fieldValue;
        BigDecimal receivedfinalpayment = entryItem.getBigDecimal("receivedfinalpayment");
        BigDecimal balamount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryItem, (String)"balamount");
        BigDecimal manualdiscount = entryItem.getBigDecimal("manualdiscount");
        BigDecimal deposit = entryItem.getBigDecimal("deposit");
        BigDecimal mustBalamount = balamount.subtract(manualdiscount);
        BigDecimal finalpayment = mustBalamount.multiply(finalpaymentScale).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
        BigDecimal norecefinalamount = finalpayment.subtract(receivedfinalpayment);
        BigDecimal linereceivableamount = balamount.subtract(manualdiscount).subtract(deposit).subtract(norecefinalamount);
        boolean isReturnRow = SaleAmountHelper.isReturnRowData(dataEntity);
        if (!isReturnRow && linereceivableamount.compareTo(BigDecimal.ZERO) < 0 && !StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)entryItem, (String)"saleoption")), (CharSequence)"0")) {
            tip = "\u5c3e\u6b3e\u6bd4\u4f8b\u4e0d\u80fd\u8d85\u8fc7 100\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002";
            return tip;
        }
        if (!isReturnRow) {
            tip = SaleOrderBalancePolicyHelper.finalpaymentScaleAboutFieldChanged(view, dataEntity, entryItem, fieldKey, mustBalamount, finalpaymentScale);
        }
        return tip;
    }

    public static String manualDiscountChanged(DynamicObject dataEntity, DynamicObject itemEntry, String fieldKey, BigDecimal fieldValue) {
        String tip = "";
        BigDecimal balamount = itemEntry.getBigDecimal("balamount");
        BigDecimal manualdiscount = fieldValue;
        BigDecimal deposit = itemEntry.getBigDecimal("deposit");
        BigDecimal norecefinalamount = itemEntry.getBigDecimal("norecefinalamount");
        BigDecimal linereceivableamount = balamount.subtract(manualdiscount).subtract(deposit).subtract(norecefinalamount);
        boolean isReturnRow = SaleAmountHelper.isReturnRowData(dataEntity);
        if (!isReturnRow && linereceivableamount.compareTo(BigDecimal.ZERO) < 0 || isReturnRow && linereceivableamount.compareTo(BigDecimal.ZERO) > 0) {
            NumberFormat currency = NumberFormat.getCurrencyInstance();
            tip = String.format("\u8f93\u5165\u91d1\u989d\u4e0d\u80fd\u8d85\u8fc7 %s\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u3002", currency.format(linereceivableamount.add(manualdiscount)));
        }
        return tip;
    }

    private static PriceFetchParam buildPriceParam(DynamicObject dataEntity, Date bizDate, long branchId, long saleOrgId, long currencyId, long goodsId) {
        PriceFetchParam params = new PriceFetchParam();
        params.setOwnerId(0L);
        params.setSaleorgId(saleOrgId);
        params.setCustomerId(branchId);
        params.setPolicyPriceId(0L);
        params.setCurrencyId(currencyId);
        params.setOrderDate(bizDate);
        params.setQty(DynamicObjectUtils.getBigDecimal((DynamicObject)dataEntity, (String)"saleqty"));
        params.setItemId(goodsId);
        params.setUnitId(DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"unit"));
        params.setItemSaleAttr(DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"saleattr"));
        params.setItemAssistattrId(0L);
        params.setMaterialAssistattrId(DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"auxattrid"));
        params.setStoreTypeId(DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"channelstocktypeid"));
        params.setBusinessType(1027317068355108864L);
        return params;
    }

    public static BigDecimal getGiftPrice(DynamicObject dataEntity, Date bizDate, long branchId, long saleOrgId, long currencyId, long goodsId) {
        PriceFetchParam params = SaleAmountHelper.buildPriceParam(dataEntity, bizDate, branchId, saleOrgId, currencyId, goodsId);
        LOG.info("\u6e20\u9053\u4ef7\u683c\u653f\u7b56\u4f20\u53c2\uff1a" + JSONObject.toJSONString((Object)params));
        PriceFetchResult result = PriceServiceUtil.getItemPrice((PriceFetchParam)params);
        LOG.info("\u6e20\u9053\u4ef7\u683c\u653f\u7b56\u8fd4\u53c2\uff1a" + JSONObject.toJSONString((Object)result));
        return result.getPolicyPrice();
    }

    public static BigDecimal getGiftPrice(DynamicObject dataEntity, DynamicObject goodsEntry, boolean isPromote) {
        BigDecimal giftPrice;
        String giftPriceSourceMode;
        long barcodeId;
        long goodsId;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        if (isPromote) {
            goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goodsEntry, (String)"goodsid");
            barcodeId = DynamicObjectUtils.getPkValue((DynamicObject)goodsEntry, (String)"barcode");
        } else {
            goodsId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"goodsid");
            barcodeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"barcode");
        }
        switch (giftPriceSourceMode = SystemParamUtil.getGiftPriceSourceMode((long)bizOrgId, (long)branchId)) {
            case "0": {
                long saleOrgId = SaleAmountHelper.getSaleOrgId(branchId);
                if (isPromote) {
                    giftPrice = SaleAmountHelper.getGiftPrice(goodsEntry, bizDate, branchId, saleOrgId, currencyId, goodsId);
                    break;
                }
                giftPrice = SaleAmountHelper.getGiftPrice(dataEntity, bizDate, branchId, saleOrgId, currencyId, goodsId);
                break;
            }
            case "1": {
                giftPrice = SaleAmountHelper.getGiftPrice(barcodeId, branchId, currencyId, goodsId, "retailprice");
                break;
            }
            default: {
                giftPrice = SaleAmountHelper.getGiftPrice(barcodeId, branchId, currencyId, goodsId, "sellingprice");
            }
        }
        return giftPrice;
    }

    private static BigDecimal getGiftPrice(long barcodeId, long branchId, long currencyId, long goodsId, String priceKey) {
        QFilter filter = new QFilter("channelid", "=", (Object)branchId);
        filter.and("currencyid", "=", (Object)currencyId);
        filter.and("itemid", "=", (Object)goodsId);
        filter.and("barcodeid", "=", (Object)barcodeId);
        String selectFields = ORMUtil.appendFieldsToStr((String[])new String[]{"retailprice", "sellingprice"});
        DynamicObject saleContent = QueryServiceHelper.queryOne((String)"ocdbd_itemsalecontent", (String)selectFields, (QFilter[])filter.toArray());
        return DynamicObjectUtils.getBigDecimal((DynamicObject)saleContent, (String)priceKey);
    }

    public static long getSaleOrgId(long branchId) {
        QFilter filter = F7Utils.getEnableFilter();
        filter.and("isdefault", "=", (Object)Boolean.TRUE);
        filter.and("orderchannel", "=", (Object)branchId);
        DynamicObject channelAuthorize = QueryServiceHelper.queryOne((String)"ocdbd_channel_authorize", (String)"saleorg", (QFilter[])filter.toArray());
        return DynamicObjectUtils.getLong((DynamicObject)channelAuthorize, (String)"saleorg");
    }

    public static void updateExchangePayAmount(DynamicObject dataEntity, BigDecimal equalValuePayAmount) {
        BigDecimal exchangePayAmount = BigDecimal.ZERO;
        BigDecimal retExchangePayAmount = BigDecimal.ZERO;
        DynamicObjectCollection goodsEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        for (DynamicObject entryItem : goodsEntity) {
            if (StringUtils.equals((CharSequence)entryItem.getString("saleoption"), (CharSequence)"0")) {
                retExchangePayAmount = entryItem.getBigDecimal("linereceivableamount").add(retExchangePayAmount);
                continue;
            }
            exchangePayAmount = entryItem.getBigDecimal("linereceivableamount").add(exchangePayAmount);
        }
        BigDecimal retRowPayAmountSum = retExchangePayAmount.subtract(equalValuePayAmount);
        BigDecimal retPayAmount = exchangePayAmount.add(retRowPayAmountSum);
        if (retPayAmount.compareTo(BigDecimal.ZERO) > 0) {
            exchangePayAmount = retRowPayAmountSum.negate();
        }
        dataEntity.set("exchangepayamount", (Object)exchangePayAmount);
    }

    public static boolean isReturnRowData(DynamicObject dataEntity) {
        Object billType = DynamicObjectUtils.get((DynamicObject)dataEntity, (String)"basebilltype");
        long billTypeId = 0L;
        if (billType instanceof DynamicObject) {
            billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)((DynamicObject)billType));
        } else if (billType instanceof Long) {
            billTypeId = CommonUtil.formatObejctToLong((Object)billType);
        } else if (billType instanceof String) {
            billTypeId = CommonUtil.formatStringToLong((String)((String)billType));
        }
        String saleOption = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"saleoption");
        return billTypeId == BillTypeEnum.RETURN.getId() || billTypeId == BillTypeEnum.CHANGE.getId() && StringUtils.equals((CharSequence)saleOption, (CharSequence)"0");
    }

    public static BigDecimal calculateSalePayNeedPayAmount(BigDecimal receivableAmount, DynamicObjectCollection payRecords) {
        BigDecimal showAmountSum = BigDecimal.ZERO;
        if (!CollectionUtils.isEmpty((Collection)payRecords)) {
            for (DynamicObject payRecord : payRecords) {
                long payWayId = DynamicObjectUtils.getPkValue((DynamicObject)payRecord, (String)"payway");
                if (payWayId == PaymentModeEnum.deposit.getKey() || payWayId == PaymentModeEnum.CustomerCompensation.getKey() || payWayId == PaymentModeEnum.EqualValuePay.getKey()) continue;
                BigDecimal showAmount = payRecord.getBigDecimal("showamount");
                showAmountSum = showAmountSum.add(showAmount);
            }
        }
        return receivableAmount.subtract(showAmountSum);
    }

    public static BigDecimal getBookPreStoreAmount(long branchId, long vipId, long sourceBillId) {
        BigDecimal diffdepositamount = BigDecimal.ZERO;
        String selectFields = "depositamount,depositpayamount,saleamount";
        QFilter filter = new QFilter("id", "=", (Object)sourceBillId);
        filter.and("salebranchid.id", "=", (Object)branchId);
        filter.and("basebilltype.id", "=", (Object)BillTypeEnum.RESERVE.getId());
        filter.and("member.id", "=", (Object)vipId);
        filter.and("notconfirm", "=", (Object)Boolean.TRUE);
        filter.and("depositamount", ">", (Object)0);
        filter.and("closestatus", "=", (Object)CloseStatusEnum.UNCLOSE.getValue());
        filter.and("salestatus", "=", (Object)SaleStatusEnum.STATUS_S.getValue());
        filter.and("billstatus", "=", (Object)EnumBillStatus.C.toString());
        DynamicObject bookPreStoreDo = QueryServiceHelper.queryOne((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray());
        if (bookPreStoreDo != null) {
            BigDecimal depositamount = DynamicObjectUtils.getBigDecimal((DynamicObject)bookPreStoreDo, (String)"depositamount");
            BigDecimal depositpayamount = DynamicObjectUtils.getBigDecimal((DynamicObject)bookPreStoreDo, (String)"depositpayamount");
            BigDecimal saleamount = DynamicObjectUtils.getBigDecimal((DynamicObject)bookPreStoreDo, (String)"saleamount");
            diffdepositamount = depositamount.subtract(depositpayamount).subtract(saleamount.abs());
        }
        return diffdepositamount;
    }
}

