/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.occ.ocpos.common.util.CommonUtil;

public class SaleConvertAmountHelper {
    public static Map<String, BigDecimal> getLineAmountMapBySaleQty(DynamicObject saleOrder, long srcBillEntryId, BigDecimal newValue) {
        DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
        DynamicObject goodsEntry = goodsEntryEntity.stream().filter(s -> CommonUtil.formatObejctToLong((Object)s.getPkValue()) == srcBillEntryId).findFirst().orElse(null);
        if (ObjectUtils.isEmpty((Object)goodsEntry)) {
            return null;
        }
        int amtPrecision = saleOrder.getInt("currencyid.amtprecision");
        return SaleConvertAmountHelper.getRowAmountMapBySaleQty(goodsEntry, newValue, amtPrecision);
    }

    private static Map<String, BigDecimal> getRowAmountMapBySaleQty(DynamicObject goodsEntry, BigDecimal cvtQty, int amtPrecision) {
        HashMap<String, BigDecimal> amountResult = new HashMap<String, BigDecimal>(16);
        boolean isPresent = goodsEntry.getBoolean("ispresent");
        if (isPresent) {
            return amountResult;
        }
        boolean isBook = goodsEntry.getBoolean("isbook");
        BigDecimal saleQty = goodsEntry.getBigDecimal("saleqty");
        BigDecimal mustRetQty = goodsEntry.getBigDecimal("mustretqty");
        if (!isBook || saleQty.compareTo(BigDecimal.ZERO) == 0 || mustRetQty.compareTo(BigDecimal.ZERO) == 0) {
            return amountResult;
        }
        BigDecimal cvtdepositamount = BigDecimal.ZERO;
        BigDecimal cvtexpectfinalamount = BigDecimal.ZERO;
        BigDecimal cvtreceexpectfinalamount = BigDecimal.ZERO;
        BigDecimal hasPushQty = saleQty.subtract(mustRetQty);
        BigDecimal cvtamount = goodsEntry.getBigDecimal("amount");
        BigDecimal balamount = goodsEntry.getBigDecimal("balamount");
        BigDecimal cvtbalamount = balamount.subtract(hasPushQty.multiply(balamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal realamount = goodsEntry.getBigDecimal("realamount");
        BigDecimal cvtrealamount = realamount.subtract(hasPushQty.multiply(realamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal manualdiscount = goodsEntry.getBigDecimal("manualdiscount");
        BigDecimal cvtmanualdiscount = manualdiscount.subtract(hasPushQty.multiply(manualdiscount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal promotiondiscount = goodsEntry.getBigDecimal("promotiondiscount");
        BigDecimal cvtpromotiondiscount = promotiondiscount.subtract(hasPushQty.multiply(promotiondiscount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal coupondiscount = goodsEntry.getBigDecimal("coupondiscount");
        BigDecimal cvtcoupondiscount = coupondiscount.subtract(hasPushQty.multiply(coupondiscount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal integraldistamount = goodsEntry.getBigDecimal("integraldistamount");
        BigDecimal cvtintegraldistamount = integraldistamount.subtract(hasPushQty.multiply(integraldistamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal giftdiscountamount = goodsEntry.getBigDecimal("giftdiscountamount");
        BigDecimal cvtgiftdiscountamount = giftdiscountamount.subtract(hasPushQty.multiply(giftdiscountamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal stddiscountamount = goodsEntry.getBigDecimal("stddiscountamount");
        BigDecimal cvtstddiscountamount = stddiscountamount.subtract(hasPushQty.multiply(stddiscountamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal notincomedisamount = goodsEntry.getBigDecimal("notincomedisamount");
        BigDecimal cvtnotincomedisamount = notincomedisamount.subtract(hasPushQty.multiply(notincomedisamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal ticketshareamount = goodsEntry.getBigDecimal("ticketshareamount");
        BigDecimal cvtticketshareamount = ticketshareamount.subtract(hasPushQty.multiply(ticketshareamount).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal deposit = goodsEntry.getBigDecimal("deposit");
        cvtdepositamount = deposit.subtract(hasPushQty.multiply(deposit).divide(saleQty, amtPrecision, RoundingMode.HALF_UP));
        BigDecimal finalpayment = goodsEntry.getBigDecimal("finalpayment");
        BigDecimal receivedfinalpayment = goodsEntry.getBigDecimal("receivedfinalpayment");
        BigDecimal norecefinalamount = goodsEntry.getBigDecimal("norecefinalamount");
        BigDecimal expectfinalamount = goodsEntry.getBigDecimal("expectfinalamount");
        BigDecimal adexpectfinalamount = goodsEntry.getBigDecimal("adexpectfinalamount");
        BigDecimal refundexpectfinalamount = goodsEntry.getBigDecimal("refundexpectfinalamount");
        cvtexpectfinalamount = expectfinalamount.subtract(adexpectfinalamount).add(refundexpectfinalamount);
        BigDecimal receexpectfinalamount = goodsEntry.getBigDecimal("receexpectfinalamount");
        adexpectfinalamount = goodsEntry.getBigDecimal("adexpectfinalamount");
        BigDecimal adrefundbookfinalamount = goodsEntry.getBigDecimal("adrefundbookfinalamount");
        cvtreceexpectfinalamount = receexpectfinalamount.subtract(adexpectfinalamount).add(adrefundbookfinalamount);
        if (saleQty.compareTo(cvtQty.negate()) != 0) {
            BigDecimal retQtySrcSaleQtyRatio = cvtQty.divide(saleQty, 8, RoundingMode.HALF_UP);
            cvtamount = retQtySrcSaleQtyRatio.multiply(cvtamount).setScale(amtPrecision, RoundingMode.HALF_UP);
        }
        BigDecimal cvtnoreceexpectfinalamount = goodsEntry.getBigDecimal("expectfinalamount");
        if (mustRetQty.compareTo(cvtQty.negate()) != 0) {
            BigDecimal retQtyMustRetQtyRatio = cvtQty.divide(mustRetQty, 8, RoundingMode.HALF_UP);
            cvtbalamount = retQtyMustRetQtyRatio.multiply(cvtbalamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtrealamount = retQtyMustRetQtyRatio.multiply(cvtrealamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtmanualdiscount = retQtyMustRetQtyRatio.multiply(cvtmanualdiscount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtpromotiondiscount = retQtyMustRetQtyRatio.multiply(cvtpromotiondiscount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtcoupondiscount = retQtyMustRetQtyRatio.multiply(cvtcoupondiscount).setScale(amtPrecision);
            cvtintegraldistamount = retQtyMustRetQtyRatio.multiply(cvtintegraldistamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtgiftdiscountamount = retQtyMustRetQtyRatio.multiply(cvtgiftdiscountamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtstddiscountamount = retQtyMustRetQtyRatio.multiply(cvtstddiscountamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtnotincomedisamount = retQtyMustRetQtyRatio.multiply(cvtnotincomedisamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtticketshareamount = retQtyMustRetQtyRatio.multiply(cvtticketshareamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtdepositamount = retQtyMustRetQtyRatio.multiply(cvtdepositamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtexpectfinalamount = retQtyMustRetQtyRatio.multiply(cvtexpectfinalamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtnoreceexpectfinalamount = retQtyMustRetQtyRatio.multiply(cvtnoreceexpectfinalamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            cvtreceexpectfinalamount = retQtyMustRetQtyRatio.multiply(cvtreceexpectfinalamount).setScale(amtPrecision, RoundingMode.HALF_UP);
            amountResult.put("noreceexpectfinalamount", cvtnoreceexpectfinalamount);
        }
        BigDecimal discountrate = new BigDecimal(100);
        if (cvtamount.compareTo(BigDecimal.ZERO) != 0) {
            discountrate = cvtbalamount.multiply(new BigDecimal(100)).divide(cvtamount, 2, RoundingMode.HALF_UP);
        }
        BigDecimal depositscale = BigDecimal.ZERO;
        BigDecimal mustCvtBalamount = cvtbalamount.subtract(cvtmanualdiscount);
        if (mustCvtBalamount.compareTo(BigDecimal.ZERO) != 0) {
            depositscale = cvtdepositamount.multiply(new BigDecimal(100)).divide(mustCvtBalamount, 2, RoundingMode.HALF_UP);
        }
        BigDecimal cvtsumsharediscount = cvtmanualdiscount.add(cvtpromotiondiscount).add(cvtcoupondiscount).add(cvtintegraldistamount).add(cvtgiftdiscountamount);
        BigDecimal cvtsumdiscountamount = cvtstddiscountamount.add(cvtnotincomedisamount).add(cvtpromotiondiscount);
        BigDecimal cvtlinereceivableamount = cvtbalamount.subtract(cvtmanualdiscount).subtract(cvtdepositamount).subtract(cvtreceexpectfinalamount).subtract(norecefinalamount);
        amountResult.put("amount", cvtamount);
        amountResult.put("balamount", cvtbalamount);
        amountResult.put("realamount", cvtrealamount);
        amountResult.put("manualdiscount", cvtmanualdiscount);
        amountResult.put("promotiondiscount", cvtpromotiondiscount);
        amountResult.put("coupondiscount", cvtcoupondiscount);
        amountResult.put("integraldistamount", cvtintegraldistamount);
        amountResult.put("giftdiscountamount", cvtgiftdiscountamount);
        amountResult.put("stddiscountamount", cvtstddiscountamount);
        amountResult.put("notincomedisamount", cvtnotincomedisamount);
        amountResult.put("ticketshareamount", cvtticketshareamount);
        amountResult.put("deposit", cvtdepositamount);
        amountResult.put("sumsharediscount", cvtsumsharediscount);
        amountResult.put("sumdiscountamount", cvtsumdiscountamount);
        amountResult.put("expectfinalamount", cvtexpectfinalamount);
        amountResult.put("receexpectfinalamount", cvtreceexpectfinalamount);
        amountResult.put("finalpayment", finalpayment);
        amountResult.put("receivedfinalpayment", receivedfinalpayment);
        amountResult.put("norecefinalamount", norecefinalamount);
        amountResult.put("linereceivableamount", cvtlinereceivableamount);
        amountResult.put("discountrate", discountrate);
        amountResult.put("depositscale", depositscale);
        return amountResult;
    }
}

