/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.promotion.SaleorderPromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class SaleOrderAmountHelper {
    public static void recalculateShareAmount(DynamicObject saleOrder) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CHANGE.getId() || billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        SaleOrderAmountHelper.shareAllLinePreAmount(saleOrder);
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"notconfirm");
        if (billTypeId == BillTypeEnum.CVTSALE.getId() && !isNotConfirm) {
            return;
        }
        SaleOrderAmountHelper.shareAllLineUseTicketAmount(saleOrder);
        SaleorderPromotionHelper.executePromotionCalcRule(saleOrder);
        SaleOrderHelper.shareTicketSendAmount(saleOrder);
        SaleOrderHelper.sharePointSendAmount(saleOrder);
        SaleOrderHelper.reCalcGiftShareAmount(saleOrder);
    }

    public static Map<String, BigDecimal> getRecalculateLineAmountMap(DynamicObject goodsEntry, String fieldName, BigDecimal newValue, boolean isClearShareAmount) {
        HashMap<String, BigDecimal> amountResult = new HashMap<String, BigDecimal>(16);
        boolean isPresent = goodsEntry.getBoolean("ispresent");
        if (isPresent) {
            return amountResult;
        }
        BigDecimal oneHundred = new BigDecimal(100);
        if (isClearShareAmount) {
            goodsEntry.set("ticketshareamount", (Object)BigDecimal.ZERO);
            boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntry, (String)"notconfirm");
            if (isNotConfirm) {
                goodsEntry.set("deposit", (Object)BigDecimal.ZERO);
            }
        }
        boolean isBook = goodsEntry.getBoolean("isbook");
        BigDecimal manualdiscount = goodsEntry.getBigDecimal("manualdiscount");
        BigDecimal promotiondiscount = goodsEntry.getBigDecimal("promotiondiscount");
        BigDecimal coupondiscount = goodsEntry.getBigDecimal("coupondiscount");
        BigDecimal integraldistamount = goodsEntry.getBigDecimal("integraldistamount");
        BigDecimal giftdiscountamount = goodsEntry.getBigDecimal("giftdiscountamount");
        BigDecimal stddiscountamount = goodsEntry.getBigDecimal("stddiscountamount");
        BigDecimal notincomedisamount = goodsEntry.getBigDecimal("notincomedisamount");
        BigDecimal ticketshareamount = goodsEntry.getBigDecimal("ticketshareamount");
        BigDecimal retailPrice = goodsEntry.getBigDecimal("retailprice");
        BigDecimal discountprice = goodsEntry.getBigDecimal("discountprice");
        BigDecimal amount = goodsEntry.getBigDecimal("amount");
        BigDecimal balamount = goodsEntry.getBigDecimal("balamount");
        BigDecimal discountrate = goodsEntry.getBigDecimal("discountrate");
        BigDecimal finalpayment = goodsEntry.getBigDecimal("finalpayment");
        BigDecimal receivedfinalpayment = goodsEntry.getBigDecimal("receivedfinalpayment");
        BigDecimal norecefinalamount = goodsEntry.getBigDecimal("norecefinalamount");
        BigDecimal expectfinalamount = goodsEntry.getBigDecimal("expectfinalamount");
        BigDecimal receexpectfinalamount = goodsEntry.getBigDecimal("receexpectfinalamount");
        BigDecimal noreceexpectfinalamount = goodsEntry.getBigDecimal("noreceexpectfinalamount");
        BigDecimal deposit = goodsEntry.getBigDecimal("deposit");
        BigDecimal depositscale = BigDecimal.ZERO;
        BigDecimal finalpaymentscale = BigDecimal.ZERO;
        BigDecimal mustBalamount = BigDecimal.ZERO;
        BigDecimal saleQty = goodsEntry.getBigDecimal("saleqty");
        if (!fieldName.equalsIgnoreCase("amount")) {
            amount = retailPrice.multiply(saleQty).setScale(2, RoundingMode.HALF_UP);
        }
        switch (fieldName) {
            case "saleqty": {
                saleQty = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                amountResult.put("mustretqty", saleQty);
                break;
            }
            case "discountprice": {
                discountprice = newValue;
                balamount = discountprice.multiply(saleQty).setScale(2, RoundingMode.HALF_UP);
                stddiscountamount = amount.subtract(balamount).subtract(notincomedisamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "stddiscountamount": {
                stddiscountamount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "notincomedisamount": {
                notincomedisamount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "discountrate": {
                discountrate = newValue;
                balamount = amount.multiply(discountrate).divide(oneHundred, 2, RoundingMode.HALF_UP);
                stddiscountamount = amount.subtract(balamount).subtract(notincomedisamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "balamount": {
                balamount = newValue;
                stddiscountamount = amount.subtract(balamount).subtract(notincomedisamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "deposit": {
                deposit = newValue;
                break;
            }
            case "depositscale": {
                depositscale = newValue;
                mustBalamount = balamount.subtract(manualdiscount);
                deposit = mustBalamount.multiply(depositscale).divide(oneHundred, 2, RoundingMode.HALF_UP);
                break;
            }
            case "manualdiscount": {
                manualdiscount = newValue;
                break;
            }
            case "ticketshareamount": {
                ticketshareamount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "promotiondiscount": {
                promotiondiscount = newValue;
                balamount = amount.subtract(notincomedisamount).subtract(stddiscountamount).subtract(ticketshareamount).subtract(promotiondiscount);
                break;
            }
            case "coupondiscount": {
                coupondiscount = newValue;
                break;
            }
            case "integraldistamount": {
                integraldistamount = newValue;
                break;
            }
            case "giftdiscountamount": {
                giftdiscountamount = newValue;
                break;
            }
            case "finalpayment": {
                finalpayment = newValue;
                norecefinalamount = finalpayment.subtract(receivedfinalpayment);
                break;
            }
            case "finalpaymentscale": {
                finalpaymentscale = newValue;
                mustBalamount = balamount.subtract(manualdiscount);
                finalpayment = mustBalamount.multiply(finalpaymentscale).divide(oneHundred, 2, RoundingMode.HALF_UP);
                norecefinalamount = finalpayment.subtract(receivedfinalpayment);
                break;
            }
            case "expectfinalamount": {
                expectfinalamount = newValue;
                noreceexpectfinalamount = expectfinalamount.subtract(receexpectfinalamount);
                break;
            }
        }
        BigDecimal sumsharediscount = manualdiscount.add(promotiondiscount).add(coupondiscount).add(integraldistamount).add(giftdiscountamount);
        BigDecimal sumdiscountamount = stddiscountamount.add(notincomedisamount).add(promotiondiscount);
        mustBalamount = balamount.subtract(manualdiscount);
        BigDecimal linereceivableamount = BigDecimal.ZERO;
        if (isBook) {
            expectfinalamount = balamount.subtract(manualdiscount).subtract(deposit).subtract(receexpectfinalamount);
            noreceexpectfinalamount = expectfinalamount.subtract(receexpectfinalamount);
            linereceivableamount = deposit;
        } else {
            if (!fieldName.equalsIgnoreCase("finalpaymentscale")) {
                if (mustBalamount.compareTo(BigDecimal.ZERO) != 0) {
                    finalpaymentscale = finalpayment.multiply(oneHundred).divide(mustBalamount, 2, RoundingMode.HALF_UP);
                } else if (finalpayment.compareTo(BigDecimal.ZERO) != 0) {
                    finalpaymentscale = oneHundred;
                }
            }
            expectfinalamount = BigDecimal.ZERO;
            noreceexpectfinalamount = BigDecimal.ZERO;
            linereceivableamount = balamount.subtract(manualdiscount).subtract(deposit).subtract(norecefinalamount);
        }
        if (!fieldName.equalsIgnoreCase("discountprice")) {
            discountprice = saleQty.compareTo(BigDecimal.ZERO) != 0 ? balamount.divide(saleQty, 2, RoundingMode.HALF_UP) : balamount;
        }
        if (!fieldName.equalsIgnoreCase("depositscale")) {
            if (amount.compareTo(BigDecimal.ZERO) != 0) {
                discountrate = balamount.multiply(oneHundred).divide(amount, 2, RoundingMode.HALF_UP);
            } else if (balamount.compareTo(BigDecimal.ZERO) != 0) {
                discountrate = oneHundred;
            }
        }
        if (!fieldName.equalsIgnoreCase("depositscale")) {
            if (mustBalamount.compareTo(BigDecimal.ZERO) != 0) {
                depositscale = deposit.multiply(oneHundred).divide(mustBalamount, 2, RoundingMode.HALF_UP);
            } else if (deposit.compareTo(BigDecimal.ZERO) != 0) {
                depositscale = oneHundred;
            }
        }
        amountResult.put("balamount", balamount);
        amountResult.put("realamount", balamount);
        amountResult.put("manualdiscount", manualdiscount);
        amountResult.put("coupondiscount", coupondiscount);
        amountResult.put("integraldistamount", integraldistamount);
        amountResult.put("promotiondiscount", promotiondiscount);
        amountResult.put("stddiscountamount", stddiscountamount);
        amountResult.put("notincomedisamount", notincomedisamount);
        amountResult.put("giftdiscountamount", giftdiscountamount);
        amountResult.put("ticketshareamount", ticketshareamount);
        amountResult.put("sumsharediscount", sumsharediscount);
        amountResult.put("sumdiscountamount", sumdiscountamount);
        amountResult.put("deposit", deposit);
        amountResult.put("depositscale", depositscale);
        amountResult.put("norecefinalamount", norecefinalamount);
        amountResult.put("noreceexpectfinalamount", noreceexpectfinalamount);
        amountResult.put("expectfinalamount", expectfinalamount);
        amountResult.put("discountprice", discountprice);
        amountResult.put("realprice", discountprice);
        amountResult.put("discountrate", discountrate);
        amountResult.put("amount", amount);
        amountResult.put("finalpayment", finalpayment);
        amountResult.put("finalpaymentscale", finalpaymentscale);
        amountResult.put("linereceivableamount", linereceivableamount);
        return amountResult;
    }

    private static void shareAllLinePreAmount(DynamicObject saleOrder) {
        BigDecimal billsurpluspreamount = BigDecimal.ZERO;
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"sourcebillid");
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"notconfirm");
        if (isNotConfirm && sourceBillId > 0L) {
            DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject doGoodsEntry : goodsEntryEntity) {
                if (doGoodsEntry.getBigDecimal("deposit").compareTo(BigDecimal.ZERO) == 0) continue;
                Map<String, BigDecimal> result = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "deposit", BigDecimal.ZERO, false);
                SaleAmountHelper.setData(result, doGoodsEntry);
            }
            DynamicObject saleBranch = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"salebranchid");
            long saleBranchId = DynamicObjectUtils.getPkValue((DynamicObject)saleBranch);
            DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"member");
            long memberId = DynamicObjectUtils.getPkValue((DynamicObject)member);
            billsurpluspreamount = SaleAmountHelper.getBookPreStoreAmount(saleBranchId, memberId, sourceBillId);
            BigDecimal deposit = BigDecimal.ZERO;
            for (DynamicObject itemEntry : goodsEntryEntity) {
                deposit = billsurpluspreamount;
                if (billsurpluspreamount.compareTo(BigDecimal.ZERO) > 0) {
                    BigDecimal balamount = itemEntry.getBigDecimal("balamount");
                    BigDecimal manualdiscount = itemEntry.getBigDecimal("manualdiscount");
                    BigDecimal receexpectfinalamount = itemEntry.getBigDecimal("receexpectfinalamount");
                    BigDecimal norecefinalamount = itemEntry.getBigDecimal("norecefinalamount");
                    BigDecimal linereceivableamount = balamount.subtract(manualdiscount).subtract(deposit).subtract(receexpectfinalamount).subtract(norecefinalamount);
                    if (linereceivableamount.compareTo(BigDecimal.ZERO) < 0) {
                        linereceivableamount = BigDecimal.ZERO;
                        deposit = balamount.subtract(manualdiscount).subtract(receexpectfinalamount).subtract(norecefinalamount);
                    }
                    billsurpluspreamount = billsurpluspreamount.subtract(deposit);
                }
                Map<String, BigDecimal> amountResult = SaleOrderAmountHelper.getRecalculateLineAmountMap(itemEntry, "deposit", deposit, false);
                SaleAmountHelper.setData(amountResult, itemEntry);
            }
        }
    }

    public static void shareAllLineUseTicketAmount(DynamicObject saleOrder) {
        DynamicObjectCollection docUseTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"useticketentity");
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (docUseTicketEntry == null || CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            String saleOption = DynamicObjectUtil.getString((DynamicObject)doGoodsEntry, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || doGoodsEntry.getBigDecimal("ticketshareamount").compareTo(BigDecimal.ZERO) == 0) continue;
            Map<String, BigDecimal> result = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "ticketshareamount", BigDecimal.ZERO, false);
            SaleAmountHelper.setData(result, doGoodsEntry);
        }
        for (DynamicObject doUseTicketEntry : docUseTicketEntry) {
            doUseTicketEntry.set("utpayamount", (Object)BigDecimal.ZERO);
            SaleOrderAmountHelper.shareLineUseTicketAmount(saleOrder, doUseTicketEntry);
        }
    }

    public static void shareLineUseTicketAmount(DynamicObject saleOrder, DynamicObject doUseTicketEntry) {
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry) || doUseTicketEntry == null) {
            return;
        }
        DynamicObject doTicketType = DynamicObjectUtil.getDynamicObject((DynamicObject)doUseTicketEntry, (String)"uttickettype");
        if (ObjectUtils.isEmpty((Object)doTicketType)) {
            return;
        }
        String usageMode = doTicketType.getString("usagemode");
        BigDecimal goodsDiscountAmount = BigDecimal.ZERO;
        BigDecimal ticketValue = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"ticketvalue");
        BigDecimal discountRate = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"discountrate");
        String goodsSeq = DynamicObjectUtil.getString((DynamicObject)doUseTicketEntry, (String)"utgoodsseq");
        List<String> lstGoodsSeq = Arrays.asList(goodsSeq.split(","));
        BigDecimal goodsAmount = SaleOrderHelper.getGoodsAmount(lstGoodsSeq, docGoodsEntry);
        if (StringUtils.equals((CharSequence)usageMode, (CharSequence)"0") && ticketValue.compareTo(goodsAmount) > 0) {
            ticketValue = goodsAmount;
        }
        BigDecimal sumShareAmount = BigDecimal.ZERO;
        for (int i = 0; i < lstGoodsSeq.size(); ++i) {
            String seq = lstGoodsSeq.get(i);
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            if (StringUtils.equals((CharSequence)"0", (CharSequence)usageMode) && ticketValue.compareTo(BigDecimal.ZERO) == 0 || StringUtils.equals((CharSequence)"2", (CharSequence)usageMode) && i > 0) break;
            BigDecimal lineReceivableAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"linereceivableamount");
            boolean isBook = doGoodsEntry.getBoolean("isbook");
            if (isBook) {
                lineReceivableAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"noreceexpectfinalamount");
            }
            BigDecimal balPrice = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
            BigDecimal couponDiscount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"ticketshareamount");
            BigDecimal payAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doUseTicketEntry, (String)"utpayamount");
            switch (usageMode) {
                case "0": {
                    BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                    if (i == lstGoodsSeq.size() - 1) {
                        goodsDiscountAmount = ticketValue.subtract(sumShareAmount);
                        break;
                    }
                    goodsDiscountAmount = balAmount.multiply(ticketValue).divide(goodsAmount, 2, RoundingMode.HALF_UP);
                    sumShareAmount = sumShareAmount.add(goodsDiscountAmount);
                    break;
                }
                case "1": {
                    goodsDiscountAmount = lineReceivableAmount.subtract(lineReceivableAmount.multiply(discountRate).divide(new BigDecimal(100), 2, 4));
                    break;
                }
                case "2": {
                    goodsDiscountAmount = balPrice;
                    break;
                }
            }
            doUseTicketEntry.set("utpayamount", (Object)payAmount.add(goodsDiscountAmount));
            Map<String, BigDecimal> amountResult = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "ticketshareamount", couponDiscount.add(goodsDiscountAmount), false);
            SaleAmountHelper.setData(amountResult, doGoodsEntry);
        }
    }

    public static BigDecimal getGoodsAmount(List<String> lstGoodsSeq, List<DynamicObject> lstGoodsEntry) {
        BigDecimal goodsAmount = BigDecimal.ZERO;
        for (String seq : lstGoodsSeq) {
            DynamicObject doGoodsEntry = lstGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            goodsAmount = goodsAmount.add(balAmount);
        }
        return goodsAmount;
    }
}

