/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.util.CommonUtil;

public class SaleOrderApiHelper {
    private static Log log = LogFactory.getLog(SaleOrderApiHelper.class);
    public static final String SELECT = "select";
    public static final String ORDERBY = "orderby";
    public static final String FORMAT = "fmt";
    public static final String FILTER = "filter";
    public static final String UNPAGE = "unpage";
    public static final String PAGE = "page";
    public static final String PAGESIZE = "pagesize";
    public static final String USERPERM = "userperm";
    public static final String ROWS = "rows";
    public static final String COUNT = "count";
    public static final String TOTALPAGE = "totalpage";
    public static final String CURPAGESIZE = "curpagesize";
    private static boolean isUnPage = false;
    private static final Map<String, String> CPMAP = new HashMap<String, String>();

    public static JSONObject queryAsFlatten(Map<String, Object> queryParams, String entityNumber) {
        DynamicObjectCollection businessDatas = SaleOrderApiHelper.queryData(queryParams, entityNumber);
        JSONObject resDatas = null;
        if (businessDatas != null && businessDatas.size() > 0) {
            resDatas = SaleOrderApiHelper.convert2API(businessDatas);
        }
        return resDatas;
    }

    private static DynamicObjectCollection queryData(Map<String, Object> queryParams, String entityNumber) {
        DynamicObjectCollection businessDatas = null;
        String selectstr = queryParams.get(SELECT).toString();
        QFilter qFilter = null;
        Object filterobject = queryParams.get(FILTER);
        if (filterobject != null) {
            String filterparam = filterobject.toString().trim();
            Pattern p = Pattern.compile("\\s+");
            Matcher m = p.matcher(filterparam);
            filterparam = m.replaceAll(" ");
            String splitstr = " and ";
            if (filterparam.toLowerCase().contains(splitstr)) {
                String[] filtersgroup;
                for (String filters : filtersgroup = filterparam.split("(?i)" + splitstr)) {
                    String[] spchars = filters.split(" ", 3);
                    if (qFilter == null) {
                        qFilter = new QFilter(spchars[0], CPMAP.get(spchars[1].toLowerCase()), (Object)spchars[2]);
                        continue;
                    }
                    qFilter.and(spchars[0], CPMAP.get(spchars[1].toLowerCase()), (Object)spchars[2]);
                }
            } else {
                String[] spchars = filterparam.split(" ", 3);
                qFilter = new QFilter(spchars[0], CPMAP.get(spchars[1].toLowerCase()), (Object)spchars[2]);
            }
        }
        String orderbystr = queryParams.get(ORDERBY).toString();
        String pagesizestr = queryParams.get(PAGESIZE).toString();
        int pagesize = CommonUtil.formatObjectToInt((Object)pagesizestr);
        if (pagesize > 0) {
            businessDatas = QueryServiceHelper.query((String)entityNumber, (String)selectstr, (QFilter[])(qFilter == null ? null : qFilter.toArray()), (String)orderbystr, (int)pagesize);
        } else {
            Object[] objects = Arrays.stream(BusinessDataServiceHelper.load((String)entityNumber, (String)selectstr, (QFilter[])(qFilter == null ? null : qFilter.toArray()), (String)orderbystr)).toArray();
            businessDatas = new DynamicObjectCollection();
            CollectionUtils.mergeArrayIntoCollection((Object)objects, (Collection)businessDatas);
        }
        return businessDatas;
    }

    private static JSONObject convert2API(DynamicObjectCollection source) {
        JSONObject result = new JSONObject();
        if (CollectionUtils.isEmpty((Collection)source)) {
            return result;
        }
        int rows = source.size();
        String sourceSerialize = DynamicObjectSerializeUtil.serialize((Object[])source.toArray(), (DynamicObjectType)source.getDynamicObjectType());
        JSONArray sourceArray = JSONArray.parseArray((String)sourceSerialize);
        JSONArray resArray = new JSONArray();
        JSONObject rowData = new JSONObject();
        for (int i = 0; i < sourceArray.size(); ++i) {
            rowData = JSONObject.parseObject((String)sourceArray.getString(i));
            if (rowData.containsKey((Object)"_Type_")) {
                rowData = rowData.fluentRemove((Object)"_Type_");
            }
            resArray.add((Object)rowData);
        }
        result.put(COUNT, (Object)rows);
        result.put(ROWS, (Object)resArray);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String updateSaleOrderDelivery(Map<String, Object> queryParams, String entityNumber) {
        String msg = "";
        long billId = Long.parseLong(queryParams.get("billid").toString());
        long goodsEntryId = Long.parseLong(queryParams.get("goodsentryid").toString());
        long deliveryEntryId = Long.parseLong(queryParams.get("deliverydetailid").toString());
        Object deliverdeliverytime = queryParams.get("deliverdeliverytime");
        Object deliverinstalltime = queryParams.get("deliverinstalltime");
        Object countyid = queryParams.get("countyid");
        Object address = queryParams.get("address");
        Object fulladdress = queryParams.get("fulladdress");
        DynamicObject bill = BusinessDataServiceHelper.loadSingle((Object)billId, (String)entityNumber);
        if (bill == null) return "\u914d\u9001\u660e\u7ec6\u4e0d\u5b58\u5728";
        DynamicObjectCollection billGoodsEntity = bill.getDynamicObjectCollection("goodsentryentity");
        if (billGoodsEntity == null) return "\u5546\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728";
        if (billGoodsEntity.size() == 0) {
            return "\u5546\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728";
        }
        DynamicObject goods = billGoodsEntity.stream().filter(a -> Long.parseLong(a.getPkValue().toString()) == goodsEntryId).findFirst().orElse(null);
        if (goods == null) return "\u5546\u54c1\u660e\u7ec6\u4e0d\u5b58\u5728";
        DynamicObjectCollection deliveryEntity = goods.getDynamicObjectCollection("salesorderdelivery");
        if (deliveryEntity == null) return "\u914d\u9001\u660e\u7ec6\u4e0d\u5b58\u5728";
        if (deliveryEntity.size() == 0) {
            return "\u914d\u9001\u660e\u7ec6\u4e0d\u5b58\u5728";
        }
        DynamicObject delivery = deliveryEntity.stream().filter(a -> Long.parseLong(a.getPkValue().toString()) == deliveryEntryId).findFirst().orElse(null);
        if (delivery == null) return "\u8ba2\u5355\u4e0d\u5b58\u5728";
        if (deliverdeliverytime != null) {
            delivery.set("deliverdeliverytime", (Object)DateUtil.getDateFormat((String)deliverdeliverytime.toString()));
        }
        if (deliverinstalltime != null) {
            delivery.set("deliverinstalltime", (Object)DateUtil.getDateFormat((String)deliverinstalltime.toString()));
        }
        if (countyid != null) {
            delivery.set("districtid", countyid);
        }
        if (address != null) {
            delivery.set("address", address);
        }
        if (fulladdress != null) {
            delivery.set("fulladdress", fulladdress);
        }
        SaveServiceHelper.update((DynamicObject)bill);
        return msg;
    }

    public static String updateSaleOrderRelatedDeliveryStatus(JSONObject paramsJson, String entityNumber) {
        String msg = "";
        String billno = paramsJson.getString("billno");
        String deliveryStatusNumber = paramsJson.getString("deliverystatus");
        String selectProperties = "salesorderdelivery.deliverystatus";
        QFilter filter = new QFilter("billno", "=", (Object)billno);
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)selectProperties, (QFilter[])filter.toArray());
        if (saleOrder == null) {
            msg = "\u96f6\u552e\u5f00\u5355\u5355\u53f7\u4e0d\u5b58\u5728\u3002";
            return msg;
        }
        QFilter filter2 = new QFilter("number", "=", (Object)deliveryStatusNumber);
        DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((String)"ococic_deliverstatus", (String)"", (QFilter[])filter2.toArray());
        if (deliveryStatus == null) {
            msg = "\u53d1\u8d27\u72b6\u6001\u7f16\u7801\u4e0d\u5b58\u5728\u3002";
            return msg;
        }
        try {
            SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus(saleOrder, null, deliveryStatus);
        }
        catch (Exception e) {
            msg = e.getMessage();
        }
        return msg;
    }

    public static String updateDeliveryOrderDeliveryStatus(JSONObject paramsJson, String entityNumber) {
        String msg = "";
        String billno = paramsJson.getString("billno");
        String deliveryStatusNumber = paramsJson.getString("deliverystatus");
        String selectProperties = "deliveryallstatus,entryentity.deliverystatus";
        QFilter filter = new QFilter("billno", "=", (Object)billno);
        DynamicObject deliveryOrder = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)selectProperties, (QFilter[])filter.toArray());
        if (deliveryOrder == null) {
            msg = "\u53d1\u8d27\u5355\u5355\u53f7\u4e0d\u5b58\u5728\u3002";
            return msg;
        }
        QFilter filter2 = new QFilter("number", "=", (Object)deliveryStatusNumber);
        DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((String)"ococic_deliverstatus", (String)"", (QFilter[])filter2.toArray());
        if (deliveryStatus == null) {
            msg = "\u53d1\u8d27\u72b6\u6001\u7f16\u7801\u4e0d\u5b58\u5728\u3002";
            return msg;
        }
        try {
            deliveryOrder.set("deliveryallstatus", (Object)deliveryStatus);
            DynamicObjectCollection entryEntity = deliveryOrder.getDynamicObjectCollection("entryentity");
            for (DynamicObject entry : entryEntity) {
                entry.set("deliverystatus", (Object)deliveryStatus);
            }
            SaveServiceHelper.update((DynamicObject)deliveryOrder);
        }
        catch (Exception e) {
            msg = e.getMessage();
        }
        return msg;
    }

    public static String updateDeliveryOrderAndOtherDeliveryStatus(JSONObject paramsJson, String entityNumber) {
        String msg = "";
        String billno = paramsJson.get((Object)"billno").toString();
        String deliveryStatusNumber = paramsJson.get((Object)"deliverystatus").toString();
        JSONArray deliveryIdsArray = paramsJson.getJSONArray("deliveryids");
        String deliveryIdsStr = JSONObject.toJSONString((Object)deliveryIdsArray);
        List deliveryIds = JSONObject.parseArray((String)deliveryIdsStr, Long.class);
        String selectProperties = "deliveryallstatus,signallstatus,entryentity.deliverystatus,entryentity.signstatus,entryentity.receivedate,entryentity.srcbillentryid,entryentity.srcbilleid,entryentity.srcbillentity";
        QFilter filter = new QFilter("billno", "=", (Object)billno);
        DynamicObject deliveryOrder = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)selectProperties, (QFilter[])filter.toArray());
        if (deliveryOrder == null) {
            msg = "\u53d1\u8d27\u5355\u5355\u53f7\u4e0d\u5b58\u5728\u3002";
            return msg;
        }
        QFilter filter2 = new QFilter("number", "=", (Object)deliveryStatusNumber);
        DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((String)"ococic_deliverstatus", (String)"", (QFilter[])filter2.toArray());
        if (deliveryStatus == null) {
            msg = "\u53d1\u8d27\u72b6\u6001\u7f16\u7801\u4e0d\u5b58\u5728\u3002";
            return msg;
        }
        try {
            SaleOrderWriteBackHelper.updateDeliveryOrderAndOtherDeliveryStatus(deliveryOrder, deliveryIds, deliveryStatus);
        }
        catch (Exception e) {
            msg = e.getMessage();
        }
        return msg;
    }

    public static String addSaleOrderInvoiceEntry(JSONObject paramsJson, String entityNumber) {
        String msg = "";
        String billno = paramsJson.getString("billno");
        String invoicetype = paramsJson.getString("invoicetype");
        Date invoicedatetime = paramsJson.getDate("invoicedatetime");
        String invoicetitle = paramsJson.getString("invoicetitle");
        BigDecimal invoiceamount = paramsJson.getBigDecimal("invoiceamount");
        String invoicenumber = paramsJson.getString("invoicenumber");
        String invoicecode = paramsJson.getString("invoicecode");
        String companytaxno = paramsJson.getString("companytaxno");
        String bankcardno = paramsJson.getString("bankcardno");
        String customeraddr = paramsJson.getString("customeraddr");
        String invoicepdfurl = paramsJson.getString("invoicepdfurl");
        String selectProperties = "invoicestatus,billno,invoiceentity.entryinvoicetype,invoiceentity.entryinvoicedatetime,invoiceentity.entryinvoicetitle,invoiceentity.entryinvoiceamount,invoiceentity.entryinvoicenumber,invoiceentity.entryinvoicecode,invoiceentity.entrycompanytaxno,invoiceentity.entrybankcardno,invoiceentity.entrycustomeraddr,invoiceentity.entryinvoicepdfurl";
        QFilter filter = new QFilter("billno", "=", (Object)billno);
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((String)entityNumber, (String)selectProperties, (QFilter[])filter.toArray());
        if (saleOrder == null) {
            msg = String.format("\u96f6\u552e\u5f00\u5355\u5355\u53f7\uff1a%s \u4e0d\u5b58\u5728\u3002", billno);
            return msg;
        }
        boolean isRepeatInvoice = false;
        DynamicObjectCollection invoiceEntity = saleOrder.getDynamicObjectCollection("invoiceentity");
        for (DynamicObject invoiceEntry : invoiceEntity) {
            String entryInvoiceNumber = invoiceEntry.getString("entryinvoicenumber");
            String entryInvoiceCode = invoiceEntry.getString("entryinvoicecode");
            if (!invoicenumber.equals(entryInvoiceNumber) || !invoicecode.equals(entryInvoiceCode)) continue;
            isRepeatInvoice = true;
            break;
        }
        if (!isRepeatInvoice) {
            DynamicObject newInvoiceEntry = invoiceEntity.addNew();
            newInvoiceEntry.set("entryinvoicetype", (Object)invoicetype);
            newInvoiceEntry.set("entryinvoicedatetime", (Object)invoicedatetime);
            newInvoiceEntry.set("entryinvoicetitle", (Object)invoicetitle);
            newInvoiceEntry.set("entryinvoiceamount", (Object)invoiceamount);
            newInvoiceEntry.set("entryinvoicenumber", (Object)invoicenumber);
            newInvoiceEntry.set("entryinvoicecode", (Object)invoicecode);
            newInvoiceEntry.set("entrycompanytaxno", (Object)companytaxno);
            newInvoiceEntry.set("entrybankcardno", (Object)bankcardno);
            newInvoiceEntry.set("entrycustomeraddr", (Object)customeraddr);
            newInvoiceEntry.set("entryinvoicepdfurl", (Object)invoicepdfurl);
        }
        saleOrder.set("invoicestatus", (Object)"C");
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
        return msg;
    }

    static {
        CPMAP.put("eq", "=");
        CPMAP.put("lt", "<");
        CPMAP.put("lq", "<=");
        CPMAP.put("bt", ">");
        CPMAP.put("bq", ">=");
        CPMAP.put("in", "in");
        CPMAP.put("nq", "<>");
        CPMAP.put("cs", "like");
    }
}

