/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDBizException;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import kd.occ.ocpos.common.vo.PolicyVo;

public class SaleOrderBalancePolicyHelper {
    private static final String BOOK_POLICY_QUERY_FIELD = "id,controlmethod,settingrule,treeentryentity.branch,treeentryentity.isapply,entity.goodsid,entity.goodsbrandid,entity.itemclassid,entity.controlmode,entity.balancescale,entity.balanceamount";
    private static final String KEY_FINALPAYMENT_TIP_CALLBACK = "finalPaymentChange";
    private static final String KEY_FINALPAYMENTSCALE_TIP_CALLBACK = "finalPaymentScaleChange";
    private static final String KEY_CHECKPOLICY_CALLBACK_SAVE = "checkpolicy_callback_save";
    private static final String KEY_CHECKPOLICY_CALLBACK_SUBMIT = "checkpolicy_callback_submit";
    private static final String KEY_CHECKPOLICY_CALLBACK_SETTLE = "checkpolicy_callback_settle";

    public static String finalpaymentScaleAboutFieldChanged(IFormView view, DynamicObject dataEntity, DynamicObject entryItem, String fieldKey, BigDecimal mustBalamount, BigDecimal depositScale) {
        String tip = "";
        boolean isBook = entryItem.getBoolean("isbook");
        if (isBook) {
            return tip;
        }
        String callBackId = "";
        switch (fieldKey) {
            case "finalpayment": {
                callBackId = KEY_FINALPAYMENT_TIP_CALLBACK;
                break;
            }
            case "finalpaymentscale": {
                callBackId = KEY_FINALPAYMENTSCALE_TIP_CALLBACK;
                break;
            }
            case "checkpolicy_callback_save": 
            case "checkpolicy_callback_submit": 
            case "checkpolicy_callback_settle": {
                callBackId = fieldKey;
                fieldKey = "finalpaymentscale";
                break;
            }
            default: {
                return tip;
            }
        }
        PolicyVo banlancePolicyVo = SaleOrderBalancePolicyHelper.checkIsEnableFinalPolicy(dataEntity, entryItem, mustBalamount, depositScale);
        if (banlancePolicyVo != null) {
            String code = banlancePolicyVo.getCode();
            if (StringUtils.equals((CharSequence)code, (CharSequence)"1") || StringUtils.equals((CharSequence)code, (CharSequence)"3")) {
                tip = banlancePolicyVo.getErrMsg();
            } else if (StringUtils.equals((CharSequence)code, (CharSequence)"2")) {
                BigDecimal oldValue = entryItem.getBigDecimal(fieldKey);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(callBackId);
                view.showConfirm(banlancePolicyVo.getErrMsg(), MessageBoxOptions.YesNo, callBackListener);
                view.getPageCache().put("PageCache_" + fieldKey, oldValue.toString());
            }
        }
        return tip;
    }

    private static PolicyVo checkIsEnableFinalPolicy(DynamicObject dataEntity, DynamicObject entryItem, BigDecimal balamount, BigDecimal finalPaymentScale) {
        PolicyVo banlancePolicyVo = null;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("bizorgid"));
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("salebranchid"));
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem.getDynamicObject("goodsid"));
        long goodsBrandId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem.getDynamicObject("brand"));
        List goodsClassIds = ItemClassUtil.queryClassList((Object)goodsId);
        boolean checkIsEnable = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)bizOrgId, (long)branchId, (String)"isenablebalancepolicy"));
        if (checkIsEnable && finalPaymentScale.compareTo(BigDecimal.ZERO) > 0) {
            JSONObject jsonParam = new JSONObject();
            jsonParam.put("branch", (Object)branchId);
            jsonParam.put("goodsid", (Object)goodsId);
            jsonParam.put("goodsbrandid", (Object)goodsBrandId);
            jsonParam.put("itemclassid", (Object)goodsClassIds);
            jsonParam.put("balanceamount", (Object)balamount);
            jsonParam.put("balancescale", (Object)finalPaymentScale);
            banlancePolicyVo = SaleOrderBalancePolicyHelper.matchGoodsBalancePolicy(jsonParam);
        }
        return banlancePolicyVo;
    }

    public static PolicyVo matchGoodsBalancePolicy(JSONObject jsonParam) {
        PolicyVo banlancePolicyVo = new PolicyVo();
        long branchId = jsonParam.getLongValue("branch");
        long goodsId = jsonParam.getLongValue("goodsid");
        long goodsBrandId = jsonParam.getLongValue("goodsbrandid");
        List goodsClassIds = (List)jsonParam.getObject("itemclassid", List.class);
        BigDecimal finalPaymentScale = jsonParam.getBigDecimal("balancescale");
        BigDecimal balamount = jsonParam.getBigDecimal("balanceamount");
        DynamicObject balancePolicy = SaleOrderBalancePolicyHelper.matchBalancePolicy(branchId, goodsId, goodsBrandId, goodsClassIds);
        if (balancePolicy != null) {
            String controlMode = balancePolicy.getString("entity.controlmode");
            BigDecimal policyFinalScale = balancePolicy.getBigDecimal("entity.balancescale");
            if (finalPaymentScale.compareTo(policyFinalScale) > 0) {
                BigDecimal balanceAmount = balamount.multiply(policyFinalScale).divide(new BigDecimal(100), 2, RoundingMode.HALF_UP);
                if (StringUtils.equals((CharSequence)controlMode, (CharSequence)"1")) {
                    banlancePolicyVo.setCode(controlMode);
                    banlancePolicyVo.setErrMsg(String.format("\u5c3e\u6b3e\u5927\u4e8e\u63a7\u5236\u7b56\u7565\uff0c\u6839\u636e\u7b56\u7565\u5c3e\u6b3e\u8ba1\u7b97\u6700\u9ad8\u5c3e\u6b3e\u91d1\u989d\u4e3a%s\u5143\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u5c3e\u6b3e", balanceAmount));
                } else if (StringUtils.equals((CharSequence)controlMode, (CharSequence)"2")) {
                    banlancePolicyVo.setCode(controlMode);
                    banlancePolicyVo.setErrMsg(String.format("\u5c3e\u6b3e\u5927\u4e8e\u63a7\u5236\u7b56\u7565\uff0c\u6839\u636e\u7b56\u7565\u5c3e\u6b3e\u8ba1\u7b97\u6700\u9ad8\u5c3e\u6b3e\u91d1\u989d\u4e3a%s\u5143\uff0c\u662f\u5426\u7ee7\u7eed", balanceAmount));
                }
            }
        } else {
            banlancePolicyVo.setCode("3");
            banlancePolicyVo.setErrMsg("\u672a\u5339\u914d\u5230\u5c3e\u6b3e\u7b56\u7565\u65b9\u6848\uff0c\u8bf7\u914d\u7f6e\u5c3e\u6b3e\u7b56\u7565");
            return banlancePolicyVo;
        }
        return banlancePolicyVo;
    }

    public static DynamicObject matchBalancePolicy(Long branchId, Long goodsId, Long goodsBrandId, List<Object> goodsClassIds) {
        if (goodsId < 0L && goodsBrandId < 0L && CollectionUtils.isEmpty(goodsClassIds)) {
            throw new KDBizException("\u5546\u54c1\u3001\u5546\u54c1\u54c1\u724c\u3001\u5546\u54c1\u5206\u7c7b\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u3002");
        }
        QFilter filter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE);
        filter.and(new QFilter("status", "=", (Object)StatusEnum.AUDIT.getValue()));
        QFilter filter1 = new QFilter("controlmethod", "=", (Object)"0");
        QFilter filter2 = new QFilter("controlmethod", "=", (Object)"1");
        filter2.and(new QFilter("treeentryentity.branch", "=", (Object)branchId));
        filter2.and(new QFilter("treeentryentity.isapply", "=", (Object)"1"));
        filter.and(filter1.or(filter2));
        QFilter f1 = null;
        if (goodsId > 0L) {
            f1 = new QFilter("settingrule", "=", (Object)"1");
            f1.and(new QFilter("entity.goodsid", "=", (Object)goodsId));
        }
        QFilter f2 = null;
        if (goodsBrandId > 0L) {
            f2 = new QFilter("settingrule", "=", (Object)"2");
            f2.and(new QFilter("entity.goodsbrandid", "=", (Object)goodsBrandId));
        }
        QFilter f3 = null;
        if (!CollectionUtils.isEmpty(goodsClassIds)) {
            ArrayList<Long> longGoodsClassIds = new ArrayList<Long>(goodsClassIds.size());
            for (Object obj : goodsClassIds) {
                long classId = Long.parseLong(obj.toString());
                longGoodsClassIds.add(classId);
            }
            f3 = new QFilter("settingrule", "=", (Object)"3");
            f3.and(new QFilter("entity.itemclassid", "in", longGoodsClassIds));
        }
        if (f1 != null) {
            filter.and(f1.or(f2).or(f3));
        } else if (f2 != null) {
            filter.and(f2.or(f3));
        } else {
            filter.and(f3);
        }
        String selectFields = "entity.deliveryctrl,entity.controlmode,entity.balancescale";
        DynamicObject qureyResult = QueryServiceHelper.queryOne((String)"ocdbd_balancepolicy", (String)selectFields, (QFilter[])filter.toArray());
        return qureyResult;
    }
}

