/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import kd.occ.ocpos.common.vo.PolicyVo;

public class SaleOrderBookPolicyHelper {
    private static final String BOOK_POLICY_QUERY_FIELD = "id,controlmethod,settingrule,treeentryentity.branch,treeentryentity.isapply,entity.goodsid,entity.goodsbrandid,entity.itemclassid,entity.controlmode,entity.depositscale";
    private static final String KEY_DEPOSIT_TIP_CALLBACK = "depositChange";
    private static final String KEY_DEPOSITSCALE_TIP_CALLBACK = "depositScaleChange";
    private static final String KEY_CHECKPOLICY_CALLBACK_SAVE = "checkpolicy_callback_save";
    private static final String KEY_CHECKPOLICY_CALLBACK_SUBMIT = "checkpolicy_callback_submit";
    private static final String KEY_CHECKPOLICY_CALLBACK_SETTLE = "checkpolicy_callback_settle";

    public static String depositScaleAboutFieldChanged(IFormView view, DynamicObject dataEntity, DynamicObject entryItem, String fieldKey, BigDecimal mustBalamount, BigDecimal depositScale) {
        String tip = "";
        boolean isBook = entryItem.getBoolean("isbook");
        if (!isBook) {
            return tip;
        }
        String callBackId = "";
        switch (fieldKey) {
            case "deposit": {
                callBackId = KEY_DEPOSIT_TIP_CALLBACK;
                break;
            }
            case "depositscale": {
                callBackId = KEY_DEPOSITSCALE_TIP_CALLBACK;
                break;
            }
            case "checkpolicy_callback_save": 
            case "checkpolicy_callback_submit": 
            case "checkpolicy_callback_settle": {
                callBackId = fieldKey;
                fieldKey = "depositscale";
                break;
            }
            default: {
                return tip;
            }
        }
        PolicyVo policyVo = SaleOrderBookPolicyHelper.checkIsEnableBookPolicy(dataEntity, entryItem, mustBalamount, depositScale);
        if (policyVo != null) {
            String code = policyVo.getCode();
            if (StringUtils.equals((CharSequence)code, (CharSequence)"1") || StringUtils.equals((CharSequence)code, (CharSequence)"3")) {
                tip = policyVo.getErrMsg();
            } else if (StringUtils.equals((CharSequence)code, (CharSequence)"2")) {
                BigDecimal oldValue = entryItem.getBigDecimal(fieldKey);
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener(callBackId);
                view.showConfirm(policyVo.getErrMsg(), MessageBoxOptions.YesNo, callBackListener);
                view.getPageCache().put("PageCache_" + fieldKey, oldValue.toString());
            }
        }
        return tip;
    }

    private static PolicyVo checkIsEnableBookPolicy(DynamicObject dataEntity, DynamicObject entryItem, BigDecimal balAmount, BigDecimal depositScale) {
        PolicyVo policyVo = null;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("bizorgid"));
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity.getDynamicObject("salebranchid"));
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryItem.getDynamicObject("goodsid"));
        long goodsBrand = DynamicObjectUtils.getPkValue((DynamicObject)entryItem.getDynamicObject("brand"));
        List classIds = ItemClassUtil.queryClassList((Object)goodsId);
        boolean checkIsEnableBookPolicy = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)bizOrgId, (long)branchId, (String)"isenablebookpolicy"));
        if (checkIsEnableBookPolicy) {
            JSONObject jsonParam = new JSONObject();
            jsonParam.put("enable", (Object)"1");
            jsonParam.put("status", (Object)"C");
            jsonParam.put("org", (Object)bizOrgId);
            jsonParam.put("branch", (Object)branchId);
            jsonParam.put("goodsid", (Object)goodsId);
            jsonParam.put("goodsbrandid", (Object)goodsBrand);
            jsonParam.put("itemclassid", (Object)classIds);
            jsonParam.put("depositamount", (Object)balAmount);
            jsonParam.put("depositscale", (Object)depositScale);
            policyVo = SaleOrderBookPolicyHelper.matchBookPolicy(jsonParam);
        }
        return policyVo;
    }

    public static PolicyVo matchBookPolicy(JSONObject jsonParam) {
        PolicyVo bookPolicyVo = new PolicyVo();
        QFilter filter = new QFilter("enable", "=", (Object)jsonParam.getString("enable"));
        filter.and(new QFilter("status", "=", (Object)jsonParam.getString("status")));
        DynamicObject[] bookPolicyList = BusinessDataServiceHelper.load((String)"ocdbd_book_policy", (String)BOOK_POLICY_QUERY_FIELD, (QFilter[])new QFilter[]{filter}, (String)"settingrule asc,audittime desc");
        boolean isMatchPolicy = false;
        long branchId = jsonParam.getLongValue("branch");
        long goodsId = jsonParam.getLongValue("goodsid");
        long goodsBrand = jsonParam.getLongValue("goodsbrandid");
        List goodsClass = (List)jsonParam.getObject("itemclassid", List.class);
        BigDecimal scale = jsonParam.getBigDecimal("depositscale");
        BigDecimal amount = jsonParam.getBigDecimal("depositamount");
        for (DynamicObject bookPolicy : bookPolicyList) {
            boolean checkMatch = false;
            boolean checkBranchMatch = false;
            String controlMode = "1";
            BigDecimal depositAmount = BigDecimal.ZERO;
            BigDecimal depositScale = BigDecimal.ZERO;
            DynamicObjectCollection bookPolicyItemList = bookPolicy.getDynamicObjectCollection("entity");
            for (DynamicObject bookPolicyItem : bookPolicyItemList) {
                BigDecimal priceModScale;
                depositScale = bookPolicyItem.getBigDecimal("depositscale");
                DynamicObject goodType = DynamicObjectUtils.getDynamicObject((DynamicObject)bookPolicyItem, (String)"goodsid");
                DynamicObject goodBrandType = DynamicObjectUtils.getDynamicObject((DynamicObject)bookPolicyItem, (String)"goodsbrandid");
                DynamicObject goodClassType = DynamicObjectUtils.getDynamicObject((DynamicObject)bookPolicyItem, (String)"itemclassid");
                depositAmount = priceModScale = amount.multiply(depositScale).divide(new BigDecimal(100), 2, 4);
                switch (bookPolicy.getInt("settingrule")) {
                    case 1: {
                        if (goodType == null || DynamicObjectUtils.getPkValue((DynamicObject)goodType) != goodsId) break;
                        checkMatch = true;
                        break;
                    }
                    case 2: {
                        if (goodBrandType == null || DynamicObjectUtils.getPkValue((DynamicObject)goodBrandType) != goodsBrand) break;
                        checkMatch = true;
                        break;
                    }
                    case 3: {
                        if (goodsClass.size() <= 0 || !goodsClass.contains(DynamicObjectUtils.getPkValue((DynamicObject)goodClassType))) break;
                        checkMatch = true;
                    }
                }
                if (!checkMatch) continue;
                controlMode = bookPolicyItem.getString("controlmode");
                break;
            }
            if (bookPolicy.getInt("controlmethod") == 0) {
                checkBranchMatch = true;
            } else {
                DynamicObjectCollection bookPolicyBranchList = bookPolicy.getDynamicObjectCollection("treeentryentity");
                for (DynamicObject bookPolicyBranch : bookPolicyBranchList) {
                    if (!bookPolicyBranch.getBoolean("isapply") || branchId != bookPolicyBranch.getDynamicObject("branch").getLong("id")) continue;
                    checkBranchMatch = true;
                }
            }
            if (!checkMatch || !checkBranchMatch) continue;
            isMatchPolicy = true;
            if (StringUtils.equals((CharSequence)controlMode, (CharSequence)"1") && scale.compareTo(depositScale) < 0) {
                bookPolicyVo.setCode(controlMode);
                bookPolicyVo.setErrMsg(String.format("\u8ba2\u91d1\u5c11\u4e8e\u9884\u8ba2\u7b56\u7565\uff0c\u63a7\u5236\u7b56\u7565\u6700\u4f4e\u6536\u53d6\u91d1\u989d\u4e3a%s\u5143\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165\u8ba2\u91d1", depositAmount));
                break;
            }
            if (!StringUtils.equals((CharSequence)controlMode, (CharSequence)"2") || scale.compareTo(depositScale) >= 0) break;
            bookPolicyVo.setCode(controlMode);
            bookPolicyVo.setErrMsg(String.format("\u8ba2\u91d1\u5c11\u4e8e\u9884\u8ba2\u7b56\u7565\uff0c\u63a7\u5236\u7b56\u7565\u6700\u4f4e\u6536\u53d6\u91d1\u989d\u4e3a%s\u5143\uff0c\u662f\u5426\u7ee7\u7eed", depositAmount));
            break;
        }
        if (!isMatchPolicy) {
            bookPolicyVo.setCode("3");
            bookPolicyVo.setErrMsg("\u672a\u5339\u914d\u5230\u9884\u8ba2\u7b56\u7565\u65b9\u6848\uff0c\u8bf7\u914d\u7f6e\u9884\u8ba2\u7b56\u7565");
            return bookPolicyVo;
        }
        return bookPolicyVo;
    }
}

