/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderCheckHelper {
    public static boolean checkIsExistTicketPay(DynamicObject saleOrder) {
        DynamicObjectCollection finEntity = saleOrder.getDynamicObjectCollection("finentity");
        if (CollectionUtils.isEmpty((Collection)finEntity)) {
            return false;
        }
        for (DynamicObject finEntry : finEntity) {
            DynamicObject settlement = DynamicObjectUtil.getDynamicObject((DynamicObject)finEntry, (String)"setllementid");
            if (settlement == null || DynamicObjectUtil.getPkValue((DynamicObject)settlement).longValue() != PaymentModeEnum.coupon.getKey()) continue;
            return true;
        }
        return false;
    }

    public static JSONObject checkRelatedBillUnAudit(long sourceBillId, long billId) {
        JSONObject jsonResult = new JSONObject();
        boolean checkSuccess = false;
        String message = "";
        QFilter qFilter = new QFilter("sourcebillid", "=", (Object)sourceBillId);
        if (billId > 0L) {
            qFilter.and("Id", "!=", (Object)billId);
        }
        qFilter.and("orderstatus", "!=", (Object)"Q");
        qFilter.and("salestatus", "!=", (Object)"S");
        String selectFields = "billno,basebilltype";
        DynamicObject relatedBill = BusinessDataServiceHelper.loadSingle((String)"ocpos_saleorder_return", (String)selectFields, (QFilter[])qFilter.toArray());
        if (relatedBill == null && (relatedBill = BusinessDataServiceHelper.loadSingle((String)"ocpos_saleorder", (String)selectFields, (QFilter[])qFilter.toArray())) == null && (relatedBill = BusinessDataServiceHelper.loadSingle((String)"ocpos_salechange", (String)selectFields, (QFilter[])qFilter.toArray())) == null && (relatedBill = BusinessDataServiceHelper.loadSingle((String)"ocpos_saleorder_final", (String)selectFields, (QFilter[])qFilter.toArray())) == null) {
            checkSuccess = true;
        }
        if (!checkSuccess && relatedBill != null) {
            DynamicObject basebilltype = relatedBill.getDynamicObject("basebilltype");
            message = String.format("\u8bf7\u5148\u5904\u7406\u5b8c\u5173\u8054\u5355\u636e\uff1a%s %s", basebilltype.getString("name"), relatedBill.getString("billno"));
        }
        jsonResult.put("success", (Object)checkSuccess);
        jsonResult.put("message", (Object)message);
        return jsonResult;
    }

    public static boolean checkIsAllowZeroSaleNoGift(DynamicObject saleOrder) {
        DynamicObjectCollection docGoodsEntry;
        long branchId;
        boolean isAllowZeroSaleNoGift;
        boolean result = true;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        if (bizOrgId != 0L && !(isAllowZeroSaleNoGift = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)bizOrgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid")), (String)"isallowzerosalenogift"))) && !CollectionUtils.isEmpty((Collection)(docGoodsEntry = saleOrder.getDynamicObjectCollection("goodsentryentity")))) {
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid");
                if (ObjectUtils.isEmpty((Object)goods)) continue;
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)doGoodsEntry, (String)"ispresent");
                BigDecimal balAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                if (isPresent || balAmount.compareTo(BigDecimal.ZERO) != 0) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean checkIsAllowZeroSettleOrder(DynamicObject saleOrder) {
        BigDecimal receivableAmount;
        long branchId;
        boolean isAllowZeroSettleOrder;
        boolean result = true;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        if (bizOrgId != 0L && !(isAllowZeroSettleOrder = SystemParamUtil.getIsAllowZeroSettleOrder((long)bizOrgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid")))) && (receivableAmount = saleOrder.getBigDecimal("receivableamount")).compareTo(BigDecimal.ZERO) == 0) {
            result = false;
        }
        return result;
    }
}

