/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.business.promotion.OlstorePromotionHelper;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderCheckHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInfoHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderInventoryHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderPushHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderReturnRuleHelper;
import kd.occ.ocpos.common.entity.InvoiceInfoEntity;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.CloseStatusEnum;
import kd.occ.ocpos.common.enums.OrderStatusEnum;
import kd.occ.ocpos.common.enums.ReceiveTypeEnum;
import kd.occ.ocpos.common.enums.ReturnOrderStatusEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderDBHelper {
    private static final String KEY_ORDER = "id desc";
    private static final Log log = LogFactory.getLog(SaleOrderDBHelper.class);

    public static Map<String, Object> addSaleOrder(Map<String, Object> dataMap) {
        long start = System.currentTimeMillis();
        HashMap<String, Object> resultMap = new HashMap<String, Object>(10);
        long saleOrgId = CommonUtil.formatObejctToLong((Object)dataMap.get("orgid"));
        long branchId = CommonUtil.formatObejctToLong((Object)dataMap.get("salebranchid"));
        long salerId = CommonUtil.formatObejctToLong((Object)dataMap.get("saler"));
        if (salerId == 0L) {
            salerId = SystemParamUtil.getOnlineStoreDefaultSaler((long)saleOrgId, (long)branchId);
        }
        DynamicObject dataEntity = BusinessDataServiceHelper.newDynamicObject((String)"ocpos_saleorder");
        SaleOrderDBHelper.setBillHeader(dataEntity, dataMap, saleOrgId, branchId, salerId);
        SaleOrderDBHelper.setGoodsEntry(dataEntity, dataMap, saleOrgId, branchId, salerId);
        SaleOrderDBHelper.setPromoteInfo(dataMap, dataEntity);
        SaleOrderDBHelper.setSettleInfo(dataMap, dataEntity);
        OlstorePromotionHelper.fillOlstorePromotion(dataEntity);
        log.info("\u4e0b\u5355\u8017\u65f6\u7edf\u8ba11 " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        start = System.currentTimeMillis();
        Object[] objectIds = SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
        log.info("\u4e0b\u5355\u8017\u65f6\u7edf\u8ba12 " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        start = System.currentTimeMillis();
        if (objectIds != null && objectIds.length > 0) {
            resultMap.put("success", Boolean.TRUE);
            resultMap.put("billId", objectIds[0]);
            resultMap.put("billNo", dataEntity.getString("billno"));
            resultMap.put("billOrder", dataEntity);
            resultMap.put("createTime", TimeServiceHelper.now());
            SaleOrderDeliveryInfoHelper.setDeliveryBillId(dataEntity, "ocpos_saleorder");
            SaveServiceHelper.update((DynamicObject)dataEntity);
            JSONObject overResult = SaleOrderInventoryHelper.overSaleOccupancy(dataEntity);
            log.info("\u4e0b\u5355\u8017\u65f6\u7edf\u8ba13  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
            start = System.currentTimeMillis();
            if (!overResult.getBooleanValue("success")) {
                resultMap.put("success", Boolean.FALSE);
                resultMap.put("error", overResult.getString("errormsg"));
                dataEntity.set("orderstatus", (Object)"Q");
            } else {
                JSONObject releaseResult = SaleOrderInventoryHelper.reserveOccupancy(dataEntity);
                if (!releaseResult.getBooleanValue("success")) {
                    resultMap.put("success", Boolean.FALSE);
                    resultMap.put("error", releaseResult.getString("errormsg"));
                    dataEntity.set("orderstatus", (Object)"Q");
                } else {
                    dataEntity.set("billstatus", (Object)"B");
                }
                log.info("\u4e0b\u5355\u8017\u65f6\u7edf\u8ba14  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
                start = System.currentTimeMillis();
            }
            long sysUserId = SaleOrderDBHelper.getSysUserByOperator(salerId);
            dataEntity.set("creator", (Object)sysUserId);
            dataEntity.set("creator_id", (Object)sysUserId);
            SaveServiceHelper.update((DynamicObject)dataEntity);
        } else {
            resultMap.put("success", Boolean.FALSE);
            resultMap.put("error", "\u6570\u636e\u4fdd\u5b58\u5931\u8d25\u3002");
        }
        log.info("\u4e0b\u5355\u8017\u65f6\u7edf\u8ba15 " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
        return resultMap;
    }

    private static long getSysUserByOperator(long operator) {
        QFilter userFilter = new QFilter("id", "=", (Object)operator);
        DynamicObject channelUserInfo = QueryServiceHelper.queryOne((String)"ocdbd_channeluser", (String)"sysuser", (QFilter[])new QFilter[]{userFilter});
        long sysUser = DynamicObjectUtil.getLong((DynamicObject)channelUserInfo, (String)"sysuser");
        return sysUser;
    }

    private static void setSettleInfo(Map<String, Object> dataMap, DynamicObject dataEntity) {
        BigDecimal sumAmount = CommonUtil.formatObjectToDecimal((Object)dataMap.get("sumamount"));
        dataEntity.set("sumamount", (Object)sumAmount);
        BigDecimal sumDiscount = CommonUtil.formatObjectToDecimal((Object)dataMap.get("sumdiscount"));
        dataEntity.set("sumdiscount", (Object)sumDiscount);
        BigDecimal sumBalAmount = CommonUtil.formatObjectToDecimal((Object)dataMap.get("sumbalamount"));
        dataEntity.set("sumbalamount", (Object)sumBalAmount);
        dataEntity.set("totalrealamount", (Object)BigDecimal.ZERO);
        dataEntity.set("depositamount", (Object)BigDecimal.ZERO);
        BigDecimal receivableAmount = CommonUtil.formatObjectToDecimal((Object)dataMap.get("sumbalamount"));
        dataEntity.set("receivableamount", (Object)receivableAmount);
        dataEntity.set("endpayamount", (Object)BigDecimal.ZERO);
        dataEntity.set("depositpayamount", (Object)BigDecimal.ZERO);
        dataEntity.set("payticketinfo", (Object)CommonUtil.formatObejctToLong((Object)dataMap.get("ticketnumber")));
    }

    private static void setGoodsEntry(DynamicObject dataEntity, Map<String, Object> dataMap, long saleOrgId, long branchId, long salerId) {
        Object deliveryStockType = SystemParamUtil.getSaleOrderDefInvType((long)saleOrgId, (long)branchId);
        if (deliveryStockType == null) {
            throw new KDBizException("\u8bf7\u914d\u7f6e\u9ed8\u8ba4\u5e93\u5b58\u7c7b\u578b");
        }
        DynamicObject warehouse = SaleOrderReturnRuleHelper.getDefaultWarehouse(branchId);
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        List itemList = (List)dataMap.get("itemList");
        long deliveryStatusId = 1026065142993238016L;
        long invStatusId = 691928582720825344L;
        int index = 1;
        for (Map item : itemList) {
            DynamicObject goodsEntry = entryEntity.addNew();
            Object materialId = item.get("materielid");
            DynamicObject goodsInfo = (DynamicObject)item.get("goodsinfo");
            Object invTypeId = item.get("invtypeid");
            if (invTypeId == null) {
                invTypeId = deliveryStockType;
            }
            Object barcode = item.get("barcode");
            Object goodsId = item.get("goodsid");
            Object invOrgId = item.get("stockOrgId");
            Object warehouseId = item.get("warehouseId");
            Object unitId = item.get("unit");
            Object baseUnitId = item.get("baseunit");
            goodsEntry.set("goodsid", goodsId);
            goodsEntry.set("materielid", materialId);
            Object deliverGoodsClassId = item.get("delivergoodsclass");
            goodsEntry.set("operationmodel", item.get("operationmodel"));
            goodsEntry.set("barcode", barcode);
            goodsEntry.set("taxrateid", goodsInfo.get("material.taxrate"));
            goodsEntry.set("auxattrid", item.get("auxattrid"));
            goodsEntry.set("channelstockstatusid", (Object)invStatusId);
            goodsEntry.set("brand", item.get("brand"));
            BigDecimal qty = new BigDecimal(item.get("qty").toString());
            BigDecimal retailPrice = new BigDecimal(item.get("retailprice").toString());
            BigDecimal discountPrice = new BigDecimal(item.get("discountprice").toString());
            goodsEntry.set("seq", (Object)index);
            goodsEntry.set("goodssaler", (Object)salerId);
            goodsEntry.set("baseunit", baseUnitId);
            goodsEntry.set("unit", unitId);
            goodsEntry.set("stockunit", unitId);
            goodsEntry.set("baseunitqty", (Object)qty);
            goodsEntry.set("saleqty", (Object)qty);
            goodsEntry.set("stockunitqty", (Object)qty);
            goodsEntry.set("mustretqty", (Object)qty);
            goodsEntry.set("retailprice", (Object)retailPrice);
            goodsEntry.set("discountprice", (Object)discountPrice);
            BigDecimal balamount = discountPrice.multiply(qty).setScale(2, 4);
            goodsEntry.set("balamount", (Object)balamount);
            goodsEntry.set("realprice", (Object)discountPrice);
            goodsEntry.set("realamount", (Object)balamount);
            goodsEntry.set("linereceivableamount", (Object)balamount);
            goodsEntry.set("goodsclass", deliverGoodsClassId);
            goodsEntry.set("discountrate", item.get("discountrate"));
            Object isNegativeSell = item.get("isnegativesell");
            goodsEntry.set("isnegativesell", isNegativeSell);
            goodsEntry.set("oversalepolicyid", item.get("oversalepolicyid"));
            goodsEntry.set("oversalepolicyentryid", item.get("oversalepolicyentryid"));
            goodsEntry.set("ispresent", item.get("ispresent"));
            goodsEntry.set("channelstocktypeid", invTypeId);
            boolean isSelfPickUp = CommonUtil.formatObjectToBoolean(item.get("isselfpickup"));
            if (goodsInfo.getBoolean("enableserial")) {
                for (int i = 0; i < qty.intValue(); ++i) {
                    Object deliveryTime;
                    Object installTime;
                    DynamicObjectCollection deliveryEntity = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
                    DynamicObject deliveryEntry = deliveryEntity.addNew();
                    deliveryEntry.set("delivergoodsid", goodsId);
                    deliveryEntry.set("deliverymaterial", materialId);
                    deliveryEntry.set("deliverbarcodeid", barcode);
                    deliveryEntry.set("deliverunitid", unitId);
                    deliveryEntry.set("deliversaleqty", (Object)1);
                    deliveryEntry.set("deliverystockunit", unitId);
                    deliveryEntry.set("deliverystockunitqty", (Object)1);
                    deliveryEntry.set("deliverybaseunit", baseUnitId);
                    deliveryEntry.set("deliverybaseunitqty", (Object)1);
                    deliveryEntry.set("brandid", item.get("brand"));
                    deliveryEntry.set("deliveryavareturnqty", (Object)1);
                    deliveryEntry.set("deliverstockid", (Object)warehouse);
                    deliveryEntry.set("districtid", dataMap.get("districtid"));
                    deliveryEntry.set("address", item.get("fulladdress"));
                    deliveryEntry.set("delivergoodsclass", deliverGoodsClassId);
                    deliveryEntry.set("inventoryorgid", invOrgId);
                    deliveryEntry.set("erpstockid", warehouseId);
                    deliveryEntry.set("deliverystockstatus", (Object)invStatusId);
                    deliveryEntry.set("deliverykeepertype", (Object)"bos_org");
                    deliveryEntry.set("deliverykeeper", invOrgId);
                    deliveryEntry.set("deliveryownertype", (Object)"bos_org");
                    deliveryEntry.set("deliveryowner", invOrgId);
                    deliveryEntry.set("consignee", item.get("consignee"));
                    deliveryEntry.set("deliverphonenumber", item.get("deliverphonenumber"));
                    deliveryEntry.set("deliverystatus", (Object)deliveryStatusId);
                    deliveryEntry.set("fulladdress", item.get("fulladdress"));
                    deliveryEntry.set("deliverdeliverybranchid", (Object)branchId);
                    deliveryEntry.set("isselfpickup", (Object)isSelfPickUp);
                    deliveryEntry.set("deliverisdelivery", (Object)(!isSelfPickUp ? 1 : 0));
                    deliveryEntry.set("deliveryisnegativesell", isNegativeSell);
                    if (isSelfPickUp) {
                        deliveryEntry.set("deliverymode", (Object)926601071999218688L);
                    } else {
                        deliveryEntry.set("deliverymode", item.get("distributionModeId"));
                    }
                    Object selfPickTime = item.get("selfpickuptime");
                    if (selfPickTime != null) {
                        deliveryEntry.set("selfpickuptime", selfPickTime);
                    }
                    if ((installTime = item.get("deliverinstalltime")) != null) {
                        deliveryEntry.set("deliverinstalltime", installTime);
                    }
                    if ((deliveryTime = item.get("deliverdeliverytime")) != null) {
                        deliveryEntry.set("deliverdeliverytime", deliveryTime);
                    }
                    deliveryEntry.set("deliverystocktype", invTypeId);
                }
            } else {
                Object deliveryTime;
                Object installTime;
                DynamicObjectCollection deliveryEntity = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
                DynamicObject deliveryEntry = deliveryEntity.addNew();
                deliveryEntry.set("delivergoodsid", goodsId);
                deliveryEntry.set("deliverymaterial", materialId);
                deliveryEntry.set("deliverbarcodeid", barcode);
                deliveryEntry.set("deliverunitid", unitId);
                deliveryEntry.set("deliversaleqty", (Object)qty);
                deliveryEntry.set("deliverystockunit", unitId);
                deliveryEntry.set("deliverystockunitqty", (Object)qty);
                deliveryEntry.set("deliverybaseunit", unitId);
                deliveryEntry.set("deliverybaseunitqty", (Object)qty);
                deliveryEntry.set("brandid", item.get("brand"));
                deliveryEntry.set("deliveryavareturnqty", (Object)qty);
                deliveryEntry.set("deliverstockid", (Object)warehouse);
                deliveryEntry.set("districtid", dataMap.get("districtid"));
                deliveryEntry.set("address", item.get("fulladdress"));
                deliveryEntry.set("delivergoodsclass", deliverGoodsClassId);
                deliveryEntry.set("inventoryorgid", invOrgId);
                deliveryEntry.set("erpstockid", warehouseId);
                deliveryEntry.set("deliverystockstatus", (Object)invStatusId);
                deliveryEntry.set("deliverykeepertype", (Object)"bos_org");
                deliveryEntry.set("deliverykeeper", invOrgId);
                deliveryEntry.set("deliveryownertype", (Object)"bos_org");
                deliveryEntry.set("deliveryowner", invOrgId);
                deliveryEntry.set("consignee", item.get("consignee"));
                deliveryEntry.set("deliverphonenumber", item.get("deliverphonenumber"));
                deliveryEntry.set("deliverystatus", (Object)deliveryStatusId);
                deliveryEntry.set("fulladdress", item.get("fulladdress"));
                deliveryEntry.set("deliverdeliverybranchid", (Object)branchId);
                deliveryEntry.set("isselfpickup", (Object)isSelfPickUp);
                deliveryEntry.set("deliverisdelivery", (Object)(!isSelfPickUp ? 1 : 0));
                deliveryEntry.set("deliveryisnegativesell", isNegativeSell);
                if (isSelfPickUp) {
                    deliveryEntry.set("deliverymode", (Object)926601071999218688L);
                } else {
                    deliveryEntry.set("deliverymode", item.get("distributionModeId"));
                }
                Object selfPickTime = item.get("selfpickuptime");
                if (selfPickTime != null) {
                    deliveryEntry.set("selfpickuptime", selfPickTime);
                }
                if ((installTime = item.get("deliverinstalltime")) != null) {
                    deliveryEntry.set("deliverinstalltime", installTime);
                }
                if ((deliveryTime = item.get("deliverdeliverytime")) != null) {
                    deliveryEntry.set("deliverdeliverytime", deliveryTime);
                }
                deliveryEntry.set("deliverystocktype", invTypeId);
            }
            dataEntity.set("customername", item.get("consignee"));
            dataEntity.set("customerphone", item.get("deliverphonenumber"));
            dataEntity.set("customeraddress", item.get("fulladdress"));
            dataEntity.set("admindivisionid", dataMap.get("districtid"));
            if (item.get("giftList") == null) continue;
            SaleOrderDBHelper.addGiftEntry((List)item.get("giftList"), goodsEntry, index++);
            SaleOrderDBHelper.addGiftToSaleOrder((List)item.get("giftList"), entryEntity, goodsEntry);
        }
    }

    private static void addGiftToSaleOrder(List<? extends Map<String, Object>> giftList, DynamicObjectCollection entryEntity, DynamicObject goodsEntry) {
        for (Map<String, Object> map : giftList) {
            DynamicObject newDyo = entryEntity.addNew();
            Object goodsId = map.get("itemid");
            newDyo.set("goodsid", goodsId);
            long materialId = CommonUtil.formatObejctToLong((Object)map.get("materialid"));
            DynamicObject goodsInfo = (DynamicObject)map.get("goodsinfo");
            newDyo.set("materielid", (Object)materialId);
            Object barcodeId = map.get("barcode");
            newDyo.set("barcode", barcodeId);
            newDyo.set("seq", (Object)(goodsEntry.getInt("seq") + 1));
            newDyo.set("taxrateid", goodsInfo.get("material.taxrate"));
            Object unit = map.get("unitid");
            newDyo.set("unit", unit);
            newDyo.set("ispresent", (Object)Boolean.TRUE);
            BigDecimal qty = CommonUtil.formatObjectToDecimal((Object)map.get("qty"));
            newDyo.set("saleqty", (Object)qty);
            DynamicObjectCollection salesOrderDelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
            for (DynamicObject salesOrderDeliveryRow : salesOrderDelivery) {
                DynamicObjectCollection newDyoDynamicObjectCollection = newDyo.getDynamicObjectCollection("salesorderdelivery");
                DynamicObject newDyoDynamicObject = newDyoDynamicObjectCollection.addNew();
                newDyoDynamicObject.set("delivergoodsid", goodsId);
                newDyoDynamicObject.set("deliverymaterial", (Object)materialId);
                newDyoDynamicObject.set("deliverbarcodeid", barcodeId);
                newDyoDynamicObject.set("deliverunitid", unit);
                newDyoDynamicObject.set("deliversaleqty", (Object)qty);
                newDyoDynamicObject.set("deliverystockunit", unit);
                newDyoDynamicObject.set("deliverystockunitqty", (Object)qty);
                newDyoDynamicObject.set("deliverybaseunit", unit);
                newDyoDynamicObject.set("deliverybaseunitqty", (Object)qty);
                newDyoDynamicObject.set("deliveryavareturnqty", (Object)qty);
                newDyoDynamicObject.set("deliverstockid", salesOrderDeliveryRow.get("deliverstockid"));
                newDyoDynamicObject.set("districtid", salesOrderDeliveryRow.get("districtid"));
                newDyoDynamicObject.set("address", salesOrderDeliveryRow.get("address"));
                newDyoDynamicObject.set("inventoryorgid", salesOrderDeliveryRow.get("inventoryorgid"));
                newDyoDynamicObject.set("erpstockid", salesOrderDeliveryRow.get("erpstockid"));
                newDyoDynamicObject.set("deliverystockstatus", salesOrderDeliveryRow.get("deliverystockstatus"));
                newDyoDynamicObject.set("deliverykeepertype", (Object)"bos_org");
                newDyoDynamicObject.set("deliverykeeper", salesOrderDeliveryRow.get("deliverykeeper"));
                newDyoDynamicObject.set("deliveryownertype", (Object)"bos_org");
                newDyoDynamicObject.set("deliveryowner", salesOrderDeliveryRow.get("deliveryowner"));
                newDyoDynamicObject.set("consignee", salesOrderDeliveryRow.get("consignee"));
                newDyoDynamicObject.set("deliverphonenumber", salesOrderDeliveryRow.get("deliverphonenumber"));
                newDyoDynamicObject.set("deliverystatus", salesOrderDeliveryRow.get("deliverystatus"));
                newDyoDynamicObject.set("fulladdress", salesOrderDeliveryRow.get("fulladdress"));
                newDyoDynamicObject.set("deliverdeliverybranchid", salesOrderDeliveryRow.get("deliverdeliverybranchid"));
                newDyoDynamicObject.set("isselfpickup", salesOrderDeliveryRow.get("isselfpickup"));
                newDyoDynamicObject.set("deliverisdelivery", salesOrderDeliveryRow.get("deliverisdelivery"));
                newDyoDynamicObject.set("deliveryisnegativesell", salesOrderDeliveryRow.get("deliveryisnegativesell"));
                newDyoDynamicObject.set("deliverymode", salesOrderDeliveryRow.get("deliverymode"));
                newDyoDynamicObject.set("selfpickuptime", salesOrderDeliveryRow.get("selfpickuptime"));
                newDyoDynamicObject.set("deliverinstalltime", salesOrderDeliveryRow.get("deliverinstalltime"));
                newDyoDynamicObject.set("deliverdeliverytime", salesOrderDeliveryRow.get("deliverdeliverytime"));
                newDyoDynamicObject.set("deliverystocktype", map.get("inventorytype"));
            }
        }
    }

    private static void setBillHeader(DynamicObject dataEntity, Map<String, Object> dataMap, long saleOrgId, long branchId, long salerId) {
        dataEntity.set("billstatus", (Object)StatusEnum.DRAFT.getValue());
        dataEntity.set("bizdate", (Object)DateUtil.getDateFormat((String)DateUtil.getDateFormat((Date)TimeServiceHelper.now())));
        dataEntity.set("salebranchid", (Object)branchId);
        dataEntity.set("bizorgid", (Object)saleOrgId);
        long memberId = CommonUtil.formatObejctToLong((Object)dataMap.get("member"));
        dataEntity.set("member", (Object)memberId);
        dataEntity.set("basebilltype", (Object)BusinessDataServiceHelper.loadSingle((Object)BillTypeEnum.RETAIL.getId(), (String)"bos_billtype"));
        dataEntity.set("biztype", (Object)BizTypeEnum.SALEBILL.getValue());
        dataEntity.set("receivingtype", (Object)BusinessDataServiceHelper.loadSingle((Object)ReceiveTypeEnum.GENERALCOLLECTION.getValue(), (String)"ocdbd_receivetype"));
        dataEntity.set("salestatus", (Object)SaleStatusEnum.STATUS_A.getValue());
        dataEntity.set("saler", (Object)salerId);
        Object defaultCustomer = SystemParamUtil.getDefaultCustomer((long)saleOrgId, (long)branchId);
        if (defaultCustomer == null) {
            throw new KDBizException("\u8bf7\u914d\u7f6e\u9ed8\u8ba4\u5f00\u5355\u5ba2\u6237");
        }
        dataEntity.set("customerid", defaultCustomer);
        dataEntity.set("currencyid", (Object)1L);
        dataEntity.set("locurrencyid", (Object)1L);
        Map<String, Long> currencyAndExRateMap = CurrencyHelper.getCurrencyAndExRateTable(saleOrgId);
        long exchangeRateTableId = currencyAndExRateMap.get("exchangeRateTableID");
        dataEntity.set("exratetable", (Object)exchangeRateTableId);
        dataEntity.set("financeexchangerate", (Object)BigDecimal.ONE);
        dataEntity.set("orderstatus", (Object)"H");
        dataEntity.set("collectmode", (Object)"01");
        dataEntity.set("creator", (Object)salerId);
        dataEntity.set("modifier", (Object)salerId);
        dataEntity.set("auditor", (Object)salerId);
        dataEntity.set("createtime", (Object)TimeServiceHelper.now());
        dataEntity.set("salestarttime", (Object)TimeServiceHelper.now());
        dataEntity.set("modifytime", (Object)TimeServiceHelper.now());
        dataEntity.set("sumamount", dataMap.get("sumamount"));
        dataEntity.set("sumdiscount", dataMap.get("sumdiscount"));
        dataEntity.set("sumbalamount", dataMap.get("sumbalamount"));
        dataEntity.set("closestatus", (Object)CloseStatusEnum.UNCLOSE.getValue());
        dataEntity.set("ismergebill", (Object)"1");
        dataEntity.set("admindivisionid", (Object)0);
        dataEntity.set("terminaltype", (Object)"L");
        Object orderSource = dataMap.get("ordersource");
        if (ObjectUtils.isEmpty((Object)orderSource)) {
            orderSource = "E";
        }
        dataEntity.set("ordersource", orderSource);
        String billNo = CodeRuleServiceHelper.getNumber((String)"ocpos_saleorder", (DynamicObject)dataEntity, (String)String.valueOf(saleOrgId));
        dataEntity.set("billno", (Object)billNo);
        dataEntity.set("invoicestatus", (Object)"A");
    }

    private static void addGiftEntry(List<? extends Map<String, Object>> giftList, DynamicObject goodsEntry, int exeGoodsSeq) {
        for (Map<String, Object> map : giftList) {
            DynamicObjectCollection salesOrderPromote = goodsEntry.getDynamicObjectCollection("salesorderpromote");
            DynamicObject promoteEntryRow = salesOrderPromote.addNew();
            promoteEntryRow.set("promotegoodsid", map.get("itemid"));
            promoteEntryRow.set("promotsaleqty", map.get("qty"));
            promoteEntryRow.set("promotiontypeid", map.get("typeid"));
            promoteEntryRow.set("promotionactid", map.get("promotionid"));
            promoteEntryRow.set("promotionactnum", map.get("promotionbillno"));
            promoteEntryRow.set("promotionactname", map.get("actname"));
            promoteEntryRow.set("exegoodsseq", (Object)exeGoodsSeq);
            promoteEntryRow.set("exepromotetype", map.get("itemgroup"));
        }
    }

    private static void setPromoteInfo(Map<String, Object> dataMap, DynamicObject dataEntity) {
        if (!dataMap.containsKey("promoteList")) {
            return;
        }
        DynamicObjectCollection promotionEntity = dataEntity.getDynamicObjectCollection("promotionentity");
        List promoteList = (List)dataMap.get("promoteList");
        List itemList = (List)dataMap.get("itemList");
        for (Map promote : promoteList) {
            DynamicObject dyo = promotionEntity.addNew();
            Long promotionId = Long.parseLong(promote.get("promotionid").toString());
            long promoteRuleId = Long.parseLong(promote.get("promoteruleid").toString());
            int priority = Integer.parseInt(promote.get("priority").toString());
            List itemIdList = (List)promote.get("itemidlist");
            DynamicObject promotion = BusinessDataServiceHelper.loadSingle((Object)promotionId, (String)"ocdpm_promote");
            DynamicObject promotionType = promotion.getDynamicObject("promotetypeid");
            if (PromotionEnum.onlineGiftPromotion().contains(promotionType.getString("number")) && !CollectionUtils.isEmpty((Collection)itemList) && ((Map)itemList.get(0)).get("giftList") == null) {
                dyo.set("execute", (Object)Boolean.FALSE);
            } else {
                dyo.set("execute", (Object)Boolean.TRUE);
            }
            dyo.set("priority", (Object)priority);
            dyo.set("promotionid", (Object)promotion.getString("id"));
            dyo.set("promotionnum", (Object)promotion.getString("billno"));
            dyo.set("promotionname", (Object)promotion.getString("billname"));
            dyo.set("promotiontheme", (Object)promotion.getString("promotetheme"));
            dyo.set("promotiontype", (Object)promotion.getDynamicObject("promotetypeid"));
            dyo.set("promotionaction", (Object)promotion.getDynamicObject("promotionsid"));
            dyo.set("effectiondate", (Object)promotion.getDate("startdate"));
            dyo.set("invaliddate", (Object)promotion.getDate("enddate"));
            dyo.set("applymember", (Object)promotion.getString("membergroup"));
            dyo.set("promoteruleid", (Object)Long.toString(promoteRuleId));
            DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
            StringBuilder sb = new StringBuilder();
            int index = 1;
            for (DynamicObject item : entryEntity) {
                String itemId = String.valueOf(DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"goodsid"));
                boolean isPresent = item.getBoolean("ispresent");
                if (!isPresent && itemIdList.contains(itemId)) {
                    sb.append(index).append(',');
                }
                ++index;
            }
            if (sb.length() != 0) {
                dyo.set("promotiongoodseq", (Object)sb.deleteCharAt(sb.length() - 1).toString());
                continue;
            }
            dyo.set("promotiongoodseq", (Object)sb.toString());
        }
    }

    public static JSONObject addSaleReturn(DynamicObject saleOrder, JSONObject customParamJson, boolean isWholeBillPush, List<Map<String, Object>> lstData) {
        JSONObject jsonResult = SaleOrderPushHelper.autoPushAndSubmit(saleOrder, isWholeBillPush, lstData, customParamJson, "ocpos_saleorder_return");
        if (!jsonResult.getBoolean("success").booleanValue()) {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("error", (Object)("\u9000\u6b3e\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + jsonResult.getString("error")));
        }
        return jsonResult;
    }

    public static JSONObject checkReturnRule(DynamicObject saleOrder, boolean isWholeBillPush, List<Long> lstEntryIds) {
        Map<String, Object> ruleResult;
        JSONObject relatedJson;
        JSONObject jsonResult = new JSONObject();
        if (!isWholeBillPush && CollectionUtils.isEmpty(lstEntryIds)) {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("error", (Object)"\u7533\u8bf7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5546\u54c1\u9009\u62e9\u5931\u8d25\u3002");
            return jsonResult;
        }
        String closeStatus = saleOrder.getString("closestatus");
        if ("B".equals(closeStatus)) {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("error", (Object)"\u7533\u8bf7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8ba2\u5355\u5df2\u5173\u95ed\u3002");
            return jsonResult;
        }
        String orderStatus = saleOrder.getString("orderstatus");
        if ("Q".equals(orderStatus)) {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("error", (Object)"\u7533\u8bf7\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8ba2\u5355\u5df2\u53d6\u6d88\u3002");
            return jsonResult;
        }
        long sourceBillId = saleOrder.getLong("sourcebillid");
        if (sourceBillId > 0L && !(relatedJson = SaleOrderCheckHelper.checkRelatedBillUnAudit(sourceBillId, 0L)).getBoolean("success").booleanValue()) {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("error", (Object)("\u7533\u8bf7\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + relatedJson.getString("message")));
            return jsonResult;
        }
        if (isWholeBillPush) {
            ruleResult = SaleOrderReturnRuleHelper.matchRedReturnRuleBySaleOrder(saleOrder, "deliverystatus");
        } else {
            log.info("checkReturnRule_lstEntryIds:" + lstEntryIds);
            DynamicObjectCollection goodsEntryMatch = new DynamicObjectCollection();
            DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                long entryId = CommonUtil.formatObejctToLong((Object)goodsEntry.getPkValue());
                if (!lstEntryIds.contains(entryId)) continue;
                String rowCloseStatus = goodsEntry.getString("rowclosestatus");
                BigDecimal mustRetQty = goodsEntry.getBigDecimal("mustretqty");
                if ("B".equals(rowCloseStatus) || mustRetQty.compareTo(BigDecimal.ZERO) <= 0) {
                    DynamicObject goods = goodsEntry.getDynamicObject("goodsid");
                    jsonResult.put("success", (Object)Boolean.FALSE);
                    jsonResult.put("error", (Object)String.format("\u7533\u8bf7\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s \u5df2\u9000\u5b8c\u3002", goods.getString("name")));
                    return jsonResult;
                }
                goodsEntryMatch.add((Object)goodsEntry);
            }
            ruleResult = SaleOrderReturnRuleHelper.matchReturnRuleByEntry(goodsEntryMatch, "deliverystatus");
        }
        if (CollectionUtils.isEmpty(ruleResult) || CommonUtil.formatObjectToBoolean((Object)ruleResult.get("success"))) {
            jsonResult.put("success", (Object)Boolean.TRUE);
            jsonResult.put("error", (Object)"");
        } else {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("error", (Object)("\u7533\u8bf7\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + ruleResult.get("msg")));
            log.info("checkReturnRule_ruleResult:" + ruleResult);
        }
        return jsonResult;
    }

    public static JSONObject addSaleChange(DynamicObject saleOrder, JSONObject customParamJson, boolean isWholeBillPush, List<Map<String, Object>> lstData) {
        JSONObject jsonResult = SaleOrderPushHelper.autoPushAndSubmit(saleOrder, isWholeBillPush, lstData, customParamJson, "ocpos_salechange");
        if (!jsonResult.getBoolean("success").booleanValue()) {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("error", (Object)("\u6362\u8d27\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + jsonResult.getString("error")));
        }
        return jsonResult;
    }

    public static JSONObject unSubmitSaleChange(long billId) {
        JSONObject jsonResult = new JSONObject();
        boolean issuccess = false;
        String error = "";
        try {
            DynamicObject saleChange = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"ocpos_salechange");
            if (saleChange == null && (saleChange = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_salechange")) == null) {
                error = "\u64a4\u9500\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6362\u8d27\u5355\u53f7\u4e0d\u5b58\u5728\u3002";
            }
            if (saleChange != null) {
                String billStatus;
                boolean isAllowUnSubmit = SaleOrderDBHelper.isAllowSaleChangeUnSubmit(saleChange);
                if (!isAllowUnSubmit) {
                    error = "\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u96f6\u552e\u9000\u8d27\u5355\u4e0d\u6ee1\u8db3\u64a4\u9500\u6761\u4ef6\u3002";
                }
                if ("B".equals(billStatus = saleChange.getString("billstatus"))) {
                    OperationResult operationResult = SaveServiceHelper.saveOperate((String)"unsubmit", (String)"ocpos_salechange", (DynamicObject[])new DynamicObject[]{saleChange}, (OperateOption)OperateOption.create());
                    if (operationResult.isSuccess()) {
                        issuccess = true;
                    } else {
                        issuccess = false;
                        error = "\u64a4\u9500\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + operationResult.getMessage();
                        log.info("unSubmitSaleReturn_operationResult:" + operationResult.getAllErrorOrValidateInfo());
                    }
                } else if ("A".equals(billStatus)) {
                    issuccess = true;
                } else {
                    issuccess = false;
                    error = "\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5355\u636e\u72b6\u6001\u4e0d\u5408\u6cd5\u3002";
                }
            }
            if (issuccess) {
                saleChange.set("closestatus", (Object)"B");
                saleChange.set("orderstatus", (Object)"Q");
                SaveServiceHelper.update((DynamicObject)saleChange);
            }
        }
        catch (Exception e) {
            issuccess = false;
            error = "\u64a4\u9500\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
            log.info("unSubmitSaleReturn_Exception:" + error);
        }
        jsonResult.put("success", (Object)issuccess);
        jsonResult.put("error", (Object)error);
        return jsonResult;
    }

    public static boolean isAllowSaleChangeUnSubmit(DynamicObject saleChange) {
        String billStatus = saleChange.getString("billstatus");
        String saleStatus = saleChange.getString("salestatus");
        return !"C".equals(billStatus) && !"S".equals(saleStatus);
    }

    public static boolean paySaleOrder(Map<String, Object> dataMap) {
        Object billId = dataMap.get("billId");
        if (billId == null) {
            throw new KDBizException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        DynamicObject orderObj = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder");
        if (orderObj == null) {
            throw new KDBizException("\u5355\u53f7\u4e0d\u5b58\u5728\uff01");
        }
        String orderStatus = orderObj.getString("orderstatus");
        if ("Q".equals(orderStatus)) {
            throw new KDBizException("\u8ba2\u5355\u5df2\u53d6\u6d88\uff01");
        }
        DynamicObjectCollection finEntity = orderObj.getDynamicObjectCollection("finentity");
        if (finEntity == null) {
            return false;
        }
        List paymentList = (List)dataMap.get("paymentList");
        if (paymentList == null || paymentList.isEmpty()) {
            throw new KDBizException("\u65e0\u652f\u4ed8\u4fe1\u606f\uff01");
        }
        for (Map payment : paymentList) {
            DynamicObject entry = finEntity.addNew();
            Object amount = payment.get("settleAmount");
            entry.set("seq", (Object)finEntity.size());
            entry.set("setllementid", payment.get("settleId"));
            entry.set("settlecurrid", (Object)1);
            entry.set("exchangerate", (Object)1);
            entry.set("settleamount", amount);
            entry.set("stmamount", amount);
            entry.set("orderno", (Object)(payment.get("orderNo") == null ? "" : payment.get("orderNo")));
            entry.set("cardno", (Object)(payment.get("cardno") == null ? "" : payment.get("cardno")));
            entry.set("paytime", (Object)TimeServiceHelper.now());
        }
        BigDecimal sumSettleAmt = BigDecimal.ZERO;
        if (!finEntity.isEmpty()) {
            sumSettleAmt = finEntity.stream().map(x -> x.getBigDecimal("settleamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        }
        orderObj.set("totalrealamount", (Object)sumSettleAmt);
        BigDecimal sumBalAmount = orderObj.getBigDecimal("sumbalamount");
        if (sumSettleAmt.compareTo(sumBalAmount) >= 0) {
            orderObj.set("salestatus", (Object)"S");
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orderObj});
        return true;
    }

    public static Map<String, Object> querySaleOrderStatus(long billId) {
        HashMap<String, Object> retailMap = new HashMap<String, Object>();
        if (billId <= 0L) {
            throw new KDBizException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        String selectFields = "orderstatus,salestatus";
        QFilter qFilter = new QFilter("id", "=", (Object)billId);
        DynamicObject orderObj = QueryServiceHelper.queryOne((String)"ocpos_saleorder", (String)selectFields, (QFilter[])qFilter.toArray());
        if (orderObj == null) {
            throw new KDBizException("\u96f6\u552e\u5f00\u5355\u4e0d\u5b58\u5728\uff01");
        }
        String orderStatus = orderObj.getString("orderstatus");
        String saleStatus = orderObj.getString("salestatus");
        retailMap.put("orderstatus", orderStatus);
        retailMap.put("salestatus", saleStatus);
        return retailMap;
    }

    public static DynamicObject querySaleOrderInfo(long billId) {
        if (billId <= 0L) {
            throw new KDBizException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        return BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder");
    }

    private static String[] getOrderDetailSelectFields() {
        return new String[]{"Id", "billno", "billcomment", "createtime", "ordersource", "orderstatus", "salestatus", "totalrealamount", "currencyid", "salebranchid", "closestatus", "finentity", "sourcebillid", "finentity.paytime", "goodsentryentity.goodsid", "goodsentryentity.saleqty", "goodsentryentity.unit", "goodsentryentity.discountprice", "goodsentryentity.balamount", "goodsentryentity.linereceivableamount", "goodsentryentity.linerefundamount", "goodsentryentity.mustretqty", "goodsentryentity.rowclosestatus", "goodsentryentity.retqty", "goodsentryentity.ispresent", "goodsentryentity.selfpickuptime", "salesorderdelivery.receivedate", "salesorderdelivery.deliverphonenumber", "salesorderdelivery.consignee", "salesorderdelivery.fulladdress", "salesorderdelivery", "delivergoodsid", "deliverbarcodeid", "deliveryserialnumber", "deliverystockstatus", "isselfpickup", "deliverisdelivery", "deliverymode", "deliverystatus", "signstatus", "receivabledate", "sumbalamount", "receivableamount", "closestatus", "billstatus", "billtype", "basebilltype", "invoicestatus", "id"};
    }

    public static DynamicObject queryReturnSaleOrderInfo(long billId) {
        if (billId <= 0L) {
            throw new KDBizException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        DynamicObject retail = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder_return");
        return retail;
    }

    public static DynamicObject[] querySaleOrderList(Map<String, Object> dataMap) {
        String entityName = "ocpos_saleorder";
        Object pageIndexObj = dataMap.get("pageIndex");
        Object pageSizeObj = dataMap.get("pageSize");
        if (pageIndexObj == null || pageSizeObj == null) {
            throw new KDBizException("\u5206\u9875\u53c2\u6570\u9519\u8bef\uff01");
        }
        int pageIndex = Integer.parseInt(String.valueOf(pageIndexObj));
        int pageSize = Integer.parseInt(String.valueOf(pageSizeObj));
        String orderStatus = (String)dataMap.get("orderStatus");
        QFilter saleOrderFilter = SaleOrderDBHelper.commonQFilter(dataMap);
        saleOrderFilter = SaleOrderDBHelper.buildSaleOrderQFilter(orderStatus, saleOrderFilter);
        String selectFields = StringUtils.join((Object[])SaleOrderDBHelper.getSelectFields(), (char)',');
        if ("D".equals(orderStatus) || "F".equals(orderStatus)) {
            entityName = "ocpos_saleorder_return";
            selectFields = selectFields + "," + "srcbillbiztype";
        } else {
            selectFields = selectFields + ",receivedate";
        }
        QFilter[] filters = saleOrderFilter.toArray();
        DynamicObject[] saleOrders = pageSize > 0 ? BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters, (String)KEY_ORDER, (int)pageIndex, (int)pageSize) : BusinessDataServiceHelper.load((String)entityName, (String)selectFields, (QFilter[])filters, (String)KEY_ORDER);
        return saleOrders;
    }

    private static QFilter buildSaleOrderQFilter(String orderStatus, QFilter qFilter) {
        QFilter filter = new QFilter("basebilltype", "!=", (Object)BillTypeEnum.STORE.getId());
        filter.and("basebilltype", "!=", (Object)BillTypeEnum.RESERVE.getId());
        switch (orderStatus) {
            case "A": {
                filter.and("orderstatus", "=", (Object)OrderStatusEnum.TO_BE_PAID.getValue());
                break;
            }
            case "B": {
                filter.and("orderstatus", "=", (Object)OrderStatusEnum.NOT_DELIVERED.getValue());
                break;
            }
            case "C": {
                QFilter filter1 = new QFilter("orderstatus", "=", (Object)OrderStatusEnum.TO_BE_DELIVERED.getValue());
                filter1.or("orderstatus", "=", (Object)OrderStatusEnum.PARTIAL_DELIVERY.getValue());
                filter.and(filter1);
                break;
            }
            case "D": {
                filter = new QFilter("basebilltype", "=", (Object)BillTypeEnum.RETURN.getId());
                filter.and("orderstatus", "in", (Object)new String[]{ReturnOrderStatusEnum.REFUNDING.getValue(), ReturnOrderStatusEnum.NOT_PICK_UP.getValue()});
                break;
            }
            case "F": {
                filter = new QFilter("basebilltype", "=", (Object)BillTypeEnum.RETURN.getId());
                break;
            }
        }
        return qFilter.and(filter);
    }

    private static QFilter commonQFilter(Map<String, Object> dataMap) {
        Object member = dataMap.get("member");
        if (member == null) {
            throw new KDBizException("\u53c2\u6570\u9519\u8bef\uff01");
        }
        Date startTime = null;
        Date endTime = null;
        Object startTimeObj = dataMap.get("startTime");
        if (startTimeObj != null && (startTime = SaleOrderDBHelper.validDate(String.valueOf(startTimeObj))) == null) {
            throw new KDBizException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff01");
        }
        Object endTimeObj = dataMap.get("endTime");
        if (endTimeObj != null && (endTime = SaleOrderDBHelper.validDate(String.valueOf(endTimeObj))) == null) {
            throw new KDBizException("\u65f6\u95f4\u683c\u5f0f\u9519\u8bef\uff01");
        }
        if (startTime != null && endTime != null && startTime.compareTo(endTime) > 0) {
            throw new KDBizException("\u65f6\u95f4\u8303\u56f4\u9519\u8bef\uff01");
        }
        QFilter qFilter = new QFilter("member", "=", member);
        qFilter.and("bizdate", ">=", (Object)startTime);
        qFilter.and("bizdate", "<=", (Object)endTime);
        Object goodsName = dataMap.get("goodsName");
        if (StringUtils.isNotBlank((Object)goodsName)) {
            qFilter.and("goodsentryentity.goodsid.name", "like", (Object)("%" + goodsName + "%"));
        }
        return qFilter;
    }

    public static JSONObject cancelSaleOrder(long billId) {
        JSONObject jsonResult = new JSONObject();
        boolean isSuccess = false;
        String error = "";
        try {
            String selectFields = "salestatus,orderstatus,billstatus";
            DynamicObject saleOrder = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"ocpos_saleorder", (String)selectFields);
            if (saleOrder == null && (saleOrder = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder", (String)selectFields)) == null) {
                error = "\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5355\u53f7\u4e0d\u5b58\u5728\u3002";
                jsonResult.put("success", (Object)Boolean.FALSE);
                jsonResult.put("error", (Object)error);
                return jsonResult;
            }
            if (saleOrder != null) {
                String billStatus = saleOrder.getString("billstatus");
                if (StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"C")) {
                    error = "\u53d6\u6d88\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5355\u636e\u72b6\u6001\u5df2\u5ba1\u6838\u3002";
                    jsonResult.put("success", (Object)Boolean.FALSE);
                    jsonResult.put("error", (Object)error);
                    return jsonResult;
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)billStatus, (CharSequence)"B")) {
                    JSONObject releaseResult;
                    long start = System.currentTimeMillis();
                    JSONObject overResult = SaleOrderInventoryHelper.overSaleRelease(saleOrder);
                    log.info("\u53d6\u6d88\u4e0b\u5355\u8017\u65f6\u7edf\u8ba13  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
                    start = System.currentTimeMillis();
                    if (!overResult.getBooleanValue("success")) {
                        log.info("\u5c0f\u7a0b\u5e8f\u5355\u53f7%s\u8d1f\u5356\u91ca\u653e\u5931\u8d25\uff0c\u539f\u56e0%s", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno"), (Object)overResult.getString("errormsg"));
                    }
                    if (!(releaseResult = SaleOrderInventoryHelper.reserveRemove(saleOrder)).getBooleanValue("success")) {
                        log.info("\u5c0f\u7a0b\u5e8f\u5355\u53f7%s\u9884\u7559\u91ca\u653e\u5931\u8d25\uff0c\u539f\u56e0%s", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno"), (Object)releaseResult.getString("errormsg"));
                    }
                    log.info("\u53d6\u6d88\u4e0b\u5355\u8017\u65f6\u7edf\u8ba14  " + (System.currentTimeMillis() - start) + " \u6beb\u79d2\u3002");
                }
                String saleStatus = saleOrder.getString("salestatus");
                String orderStatus = saleOrder.getString("orderstatus");
                if ("A".equals(saleStatus) && "H".equals(orderStatus)) {
                    isSuccess = true;
                } else {
                    isSuccess = false;
                    error = "\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u8ba2\u5355\u65e0\u6cd5\u53d6\u6d88\u3002";
                }
            }
            if (isSuccess) {
                saleOrder.set("orderstatus", (Object)"Q");
                SaveServiceHelper.update((DynamicObject)saleOrder);
            }
        }
        catch (Exception e) {
            isSuccess = false;
            error = "\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
            log.info("cancelSaleOrder_Exception:" + error);
        }
        jsonResult.put("success", (Object)isSuccess);
        jsonResult.put("error", (Object)error);
        return jsonResult;
    }

    public static JSONObject unSubmitSaleReturn(long billId) {
        JSONObject jsonResult = new JSONObject();
        boolean issuccess = false;
        String error = "";
        try {
            DynamicObject saleReturn = BusinessDataServiceHelper.loadSingleFromCache((Object)billId, (String)"ocpos_saleorder_return");
            if (saleReturn == null && (saleReturn = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder_return")) == null) {
                error = "\u64a4\u9500\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u9000\u8d27\u5355\u53f7\u4e0d\u5b58\u5728\u3002";
            }
            if (saleReturn != null) {
                String billStatus;
                boolean isAllowUnSubmit = SaleOrderDBHelper.isAllowSaleReturnUnSubmit(saleReturn);
                if (isAllowUnSubmit) {
                    error = "\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u96f6\u552e\u9000\u8d27\u5355\u4e0d\u6ee1\u8db3\u64a4\u9500\u6761\u4ef6\u3002";
                }
                if ("B".equals(billStatus = saleReturn.getString("billstatus"))) {
                    OperationResult operationResult = SaveServiceHelper.saveOperate((String)"unsubmit", (String)"ocpos_saleorder_return", (DynamicObject[])new DynamicObject[]{saleReturn}, (OperateOption)OperateOption.create());
                    if (operationResult.isSuccess()) {
                        issuccess = true;
                    } else {
                        issuccess = false;
                        error = "\u64a4\u9500\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + operationResult.getMessage();
                        log.info("unSubmitSaleReturn_operationResult:" + operationResult.getAllErrorOrValidateInfo());
                    }
                } else if ("A".equals(billStatus)) {
                    issuccess = true;
                } else {
                    issuccess = false;
                    error = "\u53d6\u6d88\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u5355\u636e\u72b6\u6001\u4e0d\u5408\u6cd5\u3002";
                }
            }
            if (issuccess) {
                saleReturn.set("closestatus", (Object)"B");
                saleReturn.set("orderstatus", (Object)"Q");
                SaveServiceHelper.update((DynamicObject)saleReturn);
            }
        }
        catch (Exception e) {
            issuccess = false;
            error = "\u64a4\u9500\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e.getMessage();
            log.info("unSubmitSaleReturn_Exception:" + error);
        }
        jsonResult.put("success", (Object)issuccess);
        jsonResult.put("error", (Object)error);
        return jsonResult;
    }

    public static boolean isAllowSaleReturnUnSubmit(DynamicObject saleReturn) {
        String billStatus = saleReturn.getString("billstatus");
        String saleStatus = saleReturn.getString("salestatus");
        String orderStatus = saleReturn.getString("orderstatus");
        if ("C".equals(billStatus) || "S".equals(saleStatus)) {
            return false;
        }
        if ("E".equals(orderStatus)) {
            return true;
        }
        if (!"G".equals(orderStatus)) {
            return false;
        }
        long sourceBillId = saleReturn.getLong("sourcebillid");
        if (sourceBillId <= 0L) {
            return true;
        }
        String srcBillBizType = saleReturn.getString("srcbillbiztype");
        if (StringUtils.contains((CharSequence)srcBillBizType, (CharSequence)"ACDEF")) {
            return false;
        }
        ArrayList<Long> srcDeliveryPkIds = new ArrayList<Long>();
        DynamicObjectCollection goodsEntryEntity = saleReturn.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
            return true;
        }
        for (DynamicObject goodsEntryRow : goodsEntryEntity) {
            DynamicObjectCollection salesOrderDelivery = goodsEntryRow.getDynamicObjectCollection("salesorderdelivery");
            for (DynamicObject delivery : salesOrderDelivery) {
                long srcDeliveryEntryId = delivery.getLong("srcdeliveryentryid");
                srcDeliveryPkIds.add(srcDeliveryEntryId);
            }
        }
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_saleorder");
        DynamicObjectCollection srcGoodsEntryEntity = sourceBill.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)srcGoodsEntryEntity)) {
            return true;
        }
        for (DynamicObject srcGoodsEntry : srcGoodsEntryEntity) {
            DynamicObjectCollection srcSalesOrderDelivery = srcGoodsEntry.getDynamicObjectCollection("salesorderdelivery");
            for (DynamicObject srcDelivery : srcSalesOrderDelivery) {
                DynamicObject deliveryStatus;
                if (!srcDeliveryPkIds.contains(DynamicObjectUtils.getPkValue((DynamicObject)srcDelivery)) || (deliveryStatus = srcDelivery.getDynamicObject("deliverystatus")) != null && DynamicObjectUtils.getPkValue((DynamicObject)deliveryStatus) != 1078251594119816192L) continue;
                return false;
            }
        }
        return true;
    }

    public static String applyInvoiceInfo(DynamicObject dataEntity, InvoiceInfoEntity invoiceInfo) {
        if (ObjectUtils.isEmpty((Object)invoiceInfo)) {
            return "\u5f00\u7968\u4fe1\u606f\u4e3a\u7a7a\u3002";
        }
        dataEntity.set("openquotype", (Object)invoiceInfo.getOpenquotype());
        dataEntity.set("name", (Object)invoiceInfo.getName());
        dataEntity.set("phonenumber", (Object)invoiceInfo.getPhonenumber());
        dataEntity.set("invoicetype", (Object)invoiceInfo.getInvoicetype());
        dataEntity.set("email", (Object)invoiceInfo.getEmail());
        dataEntity.set("enterprisename", (Object)invoiceInfo.getEnterprisename());
        dataEntity.set("taxnumber", (Object)invoiceInfo.getTaxnumber());
        dataEntity.set("enterpriseaddr", (Object)invoiceInfo.getEnterpriseaddr());
        dataEntity.set("enterprisetel", (Object)invoiceInfo.getEnterprisetel());
        dataEntity.set("bank", (Object)invoiceInfo.getBank());
        dataEntity.set("bankaccount", (Object)invoiceInfo.getBankaccount());
        dataEntity.set("enterprisephone", (Object)invoiceInfo.getEnterprisephone());
        dataEntity.set("enterpriseemail", (Object)invoiceInfo.getEnterpriseemail());
        dataEntity.set("invoiceapplytime", (Object)TimeServiceHelper.now());
        SaveServiceHelper.update((DynamicObject)dataEntity);
        String error = "";
        OperationResult operationResult = AutoPushHelper.autoPushBill(DynamicObjectUtil.getPkValue((DynamicObject)dataEntity), "ocpos_saleorder", "sim_original_bill", "audit");
        if (operationResult != null && !operationResult.isSuccess()) {
            error = "\u5f00\u7968\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + operationResult.getMessage();
            log.info("applyInvoiceInfo_operationResult:" + operationResult.getAllErrorOrValidateInfo());
            return error + operationResult.getAllErrorOrValidateInfo();
        }
        return error;
    }

    public static Map<String, Object> queryInvoiceInfo(DynamicObject dataEntity) {
        DynamicObjectCollection invoiceEntity = dataEntity.getDynamicObjectCollection("invoiceentity");
        if (invoiceEntity == null || invoiceEntity.size() == 0) {
            return null;
        }
        DynamicObject invoiceEntry = (DynamicObject)invoiceEntity.get(0);
        HashMap<String, Object> invoiceInfoMap = new HashMap<String, Object>(10);
        invoiceInfoMap.put("entryinvoicetype", invoiceEntry.getString("entryinvoicetype"));
        invoiceInfoMap.put("entryinvoicedatetime", invoiceEntry.getDate("entryinvoicedatetime"));
        invoiceInfoMap.put("entryinvoicetitle", invoiceEntry.getString("entryinvoicetitle"));
        invoiceInfoMap.put("entryinvoiceamount", invoiceEntry.getBigDecimal("entryinvoiceamount"));
        invoiceInfoMap.put("entryinvoicenumber", invoiceEntry.getString("entryinvoicenumber"));
        invoiceInfoMap.put("entryinvoicecode", invoiceEntry.getString("entryinvoicecode"));
        invoiceInfoMap.put("entrycompanytaxno", invoiceEntry.getString("entrycompanytaxno"));
        invoiceInfoMap.put("entrybankcardno", invoiceEntry.getString("entrybankcardno"));
        invoiceInfoMap.put("entrycustomeraddr", invoiceEntry.getString("entrycustomeraddr"));
        invoiceInfoMap.put("entryinvoicepdfurl", invoiceEntry.getString("entryinvoicepdfurl"));
        return invoiceInfoMap;
    }

    private static String[] getSelectFields() {
        return new String[]{"Id", "billno", "orderstatus", "salestatus", "totalrealamount", "currencyid", "salebranchid", "closestatus", "goodsentryentity.goodsid", "goodsentryentity.saleqty", "goodsentryentity.unit", "goodsentryentity.discountprice", "goodsentryentity.balamount", "goodsentryentity.linereceivableamount", "goodsentryentity.linerefundamount", "goodsentryentity.mustretqty", "goodsentryentity.rowclosestatus", "goodsentryentity.retqty", "salesorderdelivery", "delivergoodsid", "deliverbarcodeid", "deliveryserialnumber", "deliverystockstatus", "isselfpickup", "deliverisdelivery", "deliverymode", "deliverystatus", "signstatus", "PosSalesorderConst.EF_receivabledate", "sumbalamount", "receivableamount", "closestatus", "billstatus", "billtype", "basebilltype", "invoicestatus", "id"};
    }

    private static Date validDate(String str) {
        Date convertDate;
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        try {
            format.setLenient(false);
            convertDate = format.parse(str);
        }
        catch (ParseException e) {
            convertDate = null;
        }
        return convertDate;
    }

    public static DynamicObjectCollection getOrderList(List<Long> orgList, List<Long> branchList) {
        QFilter qFilter = new QFilter("billstatus", "=", (Object)StatusEnum.AUDIT.getValue());
        qFilter.and("bizorgid", "in", orgList);
        qFilter.and("salebranchid", "in", branchList);
        qFilter.and("goodsentryentity.salesorderdelivery.signstatus", "=", (Object)Character.valueOf('B'));
        return QueryServiceHelper.query((String)"ocpos_saleorder", (String)"id,salebranchid", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection getRetailBillList(List<Long> orderIdList) {
        QFilter qFilter = new QFilter("entryentity.sourcebillid", "in", orderIdList);
        return QueryServiceHelper.query((String)"ocococ_retailbill", (String)"id,entryentity.sourcebillid", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection getDeliveryOrderList(List<Long> retailBillIdList) {
        QFilter qFilter = new QFilter("entryentity.srcbilleid", "in", retailBillIdList);
        return QueryServiceHelper.query((String)"ocococ_deliveryorder", (String)"id,entryentity.srcbilleid", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection getsalOutBillList(List<Long> deliveryOrderIdList) {
        QFilter qFilter = new QFilter("billentry.srcbillid", "in", deliveryOrderIdList);
        return QueryServiceHelper.query((String)"im_saloutbill", (String)"id,billentry.srcbillid,auditdate", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObjectCollection getSysParamList() {
        QFilter qFilter = new QFilter("branch", "!=", (Object)0L);
        qFilter.and("org", "!=", (Object)0L);
        return QueryServiceHelper.query((String)"ocpos_store_sysparam", (String)"id,org,branch,isautoreceive,deliveryday", (QFilter[])new QFilter[]{qFilter});
    }

    public static DynamicObject[] LoadBillArray(String entityname, List<Long> billIdList) {
        DynamicObjectType saleOrderType = (DynamicObjectType)ORM.create().getDataEntityType(entityname);
        return BusinessDataServiceHelper.load((Object[])billIdList.toArray(), (DynamicObjectType)saleOrderType);
    }
}

