/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.time.Period;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AmountProp;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.inventory.query.QueryDistributionRulesHelper;
import kd.occ.ocpos.business.inventory.query.QueryInventoryHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.saleorder.InventoryUtils;
import kd.occ.ocpos.common.saleorder.UnitTransferUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderDeliveryInfoHelper {
    private static final Log LOG = LogFactory.getLog(SaleOrderDeliveryInfoHelper.class);

    public static Map<String, Object> getDeliveryInfo(Map<String, Object> params, boolean isPresent) {
        boolean isOverSale;
        List<JSONObject> detailInfo;
        HashMap<String, Object> result = new HashMap<String, Object>(3);
        HashMap<String, Object> deliveryInfo = new HashMap<String, Object>(2);
        BigDecimal totalSaleQty = CommonUtil.formatObjectToDecimal((Object)params.get("unitQty"));
        Date date = (Date)params.get("deliveryDate");
        List<JSONObject> distRulesParams = SaleOrderDeliveryInfoHelper.getDistributionRuleParams(params);
        LOG.info("\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u4f20\u53c2\uff1a" + SerializationUtils.toJsonString(distRulesParams));
        List<Object> distributionRules = SaleOrderDeliveryInfoHelper.getDistributionRules(distRulesParams);
        LOG.info("\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u8fd4\u53c2\uff1a" + SerializationUtils.toJsonString(distributionRules));
        if (params.containsKey("stockOrgId") && params.containsKey("warehouseId")) {
            long stockOrgId = CommonUtil.formatObejctToLong((Object)params.get("stockOrgId"));
            long stockId = CommonUtil.formatObejctToLong((Object)params.get("warehouseId"));
            distributionRules = distributionRules.stream().filter(x -> x.getLongValue("stockOrgId") == stockOrgId && x.getLongValue("warehouseId") == stockId).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty(distributionRules)) {
            result.put("isSuccess", Boolean.FALSE);
            result.put("errorMsg", "\u5546\u54c1\u4e3a\u914d\u9001\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002");
            result.put("deliveryData", null);
            return result;
        }
        List<JSONObject> overSaleData = new ArrayList<JSONObject>();
        if (date != null) {
            boolean isOverSale2;
            List<JSONObject> overSaleParams = SaleOrderDeliveryInfoHelper.getOverSaleParams(distributionRules, params);
            LOG.info("\u8d1f\u5356\u653f\u7b56\u4f20\u53c2\uff1a" + SerializationUtils.toJsonString(overSaleParams));
            overSaleData = SaleOrderDeliveryInfoHelper.getOverSaleData(overSaleParams);
            LOG.info("\u8d1f\u5356\u653f\u7b56\u8fd4\u53c2\uff1a" + SerializationUtils.toJsonString(overSaleData));
            if (!isPresent && (isOverSale2 = SaleOrderDeliveryInfoHelper.matchingOverSalePolicy(overSaleData, deliveryInfo, totalSaleQty, date, "1", result))) {
                return result;
            }
        }
        if (!CollectionUtils.isEmpty(detailInfo = SaleOrderDeliveryInfoHelper.queryInventory(params, distributionRules, totalSaleQty))) {
            deliveryInfo.put("isnegativesell", Boolean.FALSE);
            deliveryInfo.put("oversalepolicyid", 0L);
            deliveryInfo.put("oversalepolicyentryid", 0L);
            deliveryInfo.put("data", detailInfo);
            result = new HashMap(3);
            result.put("isSuccess", Boolean.TRUE);
            result.put("errorMsg", "");
            result.put("deliveryData", deliveryInfo);
            return result;
        }
        if (date != null && !isPresent && (isOverSale = SaleOrderDeliveryInfoHelper.matchingOverSalePolicy(overSaleData, deliveryInfo, totalSaleQty, date, "2", result))) {
            return result;
        }
        result.put("isSuccess", Boolean.FALSE);
        result.put("errorMsg", "\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u6267\u884c\u9884\u8ba2\uff0c\u6216\u91cd\u65b0\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002");
        result.put("deliveryData", null);
        return result;
    }

    public static List<JSONObject> getDistributionRules(List<JSONObject> params) {
        long start = TimeServiceHelper.getTimeStamp();
        List<JSONObject> distributionRules = QueryDistributionRulesHelper.matchDistributionRules(params);
        long end = TimeServiceHelper.getTimeStamp();
        LOG.info("\u96f6\u552e\u5f00\u5355\u5339\u914d\u5e93\u5b58\u3010\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u63a5\u53e3\u3011\u8017\u65f6\uff1a" + (end - start));
        return distributionRules;
    }

    public static List<JSONObject> getOverSaleData(List<JSONObject> params) {
        long start = TimeServiceHelper.getTimeStamp();
        List overSaleData = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"OverSalePolicyService", (String)"matchOverSalePolicy", (Object[])new Object[]{params});
        long end = TimeServiceHelper.getTimeStamp();
        LOG.info("\u96f6\u552e\u5f00\u5355\u5339\u914d\u5e93\u5b58\u3010\u8d1f\u5356\u653f\u7b56\u3011\u63a5\u53e3\u8017\u65f6\uff1a" + (end - start));
        return overSaleData;
    }

    public static List<JSONObject> getInventoryInfo(List<JSONObject> params) {
        long start = TimeServiceHelper.getTimeStamp();
        List<JSONObject> inventoryData = QueryInventoryHelper.matchDistributionWarehouse(params);
        long end = TimeServiceHelper.getTimeStamp();
        LOG.info("\u96f6\u552e\u5f00\u5355\u5339\u914d\u5e93\u5b58\u3010\u4f9b\u5e94\u94fe\u5e93\u5b58\u67e5\u8be2\u3011\u63a5\u53e3\u8017\u65f6\uff1a" + (end - start));
        return inventoryData;
    }

    public static List<JSONObject> getDistributionRuleParams(Map<String, Object> params) {
        ArrayList<JSONObject> lstRuleParam = new ArrayList<JSONObject>(0);
        JSONObject distRulesParam = new JSONObject();
        distRulesParam.put("saleOrgId", params.get("saleOrgId"));
        distRulesParam.put("saleChannelId", params.get("saleChannelID"));
        distRulesParam.put("itemId", params.get("itemId"));
        distRulesParam.put("adminDivisionId", params.get("adminDivisionId"));
        lstRuleParam.add(distRulesParam);
        return lstRuleParam;
    }

    private static List<JSONObject> getOverSaleParams(List<JSONObject> distributionRules, Map<String, Object> params) {
        ArrayList<JSONObject> overSaleParams = new ArrayList<JSONObject>(0);
        Date date = (Date)params.get("deliveryDate");
        ZonedDateTime zonedDateTime = date.toInstant().atZone(ZoneId.systemDefault());
        zonedDateTime = zonedDateTime.plus(Period.of(5000, 3, 8));
        for (JSONObject distributionRule : distributionRules) {
            JSONObject overSaleParam = new JSONObject();
            overSaleParam.put("saleOrgId", params.get("saleOrgId"));
            overSaleParam.put("saleChannelID", params.get("saleChannelID"));
            overSaleParam.put("itemId", params.get("itemId"));
            overSaleParam.put("materialId", params.get("materialId"));
            overSaleParam.put("baseUnitID", params.get("baseUnitID"));
            overSaleParam.put("baseUnitQty", params.get("baseUnitQty"));
            overSaleParam.put("unitId", params.get("unitId"));
            overSaleParam.put("unitQty", params.get("unitQty"));
            overSaleParam.put("distributionModeId", distributionRule.get((Object)"distributionModeId"));
            overSaleParam.put("deliveryDate", (Object)Date.from(zonedDateTime.toInstant()));
            overSaleParam.put("bizdate", params.get("bizdate"));
            overSaleParam.put("stockOrgId", distributionRule.get((Object)"stockOrgId"));
            long stockId = distributionRule.getLongValue("warehouseId");
            long channelStockId = distributionRule.getLongValue("channelwarehouseid");
            if (stockId != 0L) {
                overSaleParam.put("stockId", (Object)stockId);
            } else {
                overSaleParam.put("stockId", (Object)channelStockId);
            }
            overSaleParam.put("invtypeid", params.get("invtypeid"));
            overSaleParam.put("customerKey", params.get("index"));
            overSaleParams.add(overSaleParam);
        }
        return overSaleParams;
    }

    private static List<JSONObject> getInventoryParams(List<JSONObject> distributionRules, Map<String, Object> params) {
        HashSet qty = new HashSet(0);
        ArrayList<JSONObject> inventoryParams = new ArrayList<JSONObject>(0);
        for (JSONObject distributionRule : distributionRules) {
            HashMap<String, Long> dpcheck = new HashMap<String, Long>();
            dpcheck.put("warehouseId", distributionRule.getLong("warehouseId"));
            dpcheck.put("stockOrgId", distributionRule.getLong("stockOrgId"));
            if (qty.contains(dpcheck)) continue;
            JSONObject inventoryParam = new JSONObject();
            inventoryParam.put("saleOrgId", params.get("saleOrgId"));
            inventoryParam.put("saleChannelID", params.get("saleChannelID"));
            inventoryParam.put("itemId", params.get("itemId"));
            inventoryParam.put("materialId", params.get("materialId"));
            inventoryParam.put("auxPtyID", params.get("auxPtyID"));
            inventoryParam.put("unitId", params.get("unitId"));
            inventoryParam.put("unitQty", params.get("unitQty"));
            inventoryParam.put("baseUnitID", params.get("baseUnitID"));
            inventoryParam.put("baseUnitQty", params.get("unitQty"));
            inventoryParam.put("invtypeid", params.get("invtypeid"));
            inventoryParam.put("stockOrgId", distributionRule.get((Object)"stockOrgId"));
            inventoryParam.put("warehouseId", distributionRule.get((Object)"warehouseId"));
            inventoryParam.put("distributionModeId", distributionRule.get((Object)"distributionModeId"));
            inventoryParam.put("adminDivisionId", params.get("adminDivisionId"));
            inventoryParam.put("customerKey", params.get("index"));
            inventoryParams.add(inventoryParam);
            qty.add(dpcheck);
        }
        return inventoryParams;
    }

    public static void fillDeliveryDataAllowOverSale(IFormView view, DynamicObject data, DynamicObject entryItem, Object returnData) {
        long invTypeId;
        long stockId;
        JSONObject result = (JSONObject)returnData;
        DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery");
        if (deliveryEntities == null) {
            return;
        }
        deliveryEntities.clear();
        DynamicObject deliveryEntity = deliveryEntities.addNew();
        SaleOrderDeliveryInfoHelper.fillCommonData(data, deliveryEntity, result);
        BigDecimal qty = result.getBigDecimal("unitqty");
        deliveryEntity.set("deliversaleqty", (Object)qty);
        deliveryEntity.set("deliveryavareturnqty", (Object)qty);
        BigDecimal baseUnitQty = result.getBigDecimal("baseunitqty");
        deliveryEntity.set("deliverybaseunitqty", (Object)baseUnitQty);
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliverybaseunit");
        UnitTransferUtils.updateDeliveryOtherQuantities((IFormView)view, (DynamicObject)deliveryEntity, (BigDecimal)baseUnitQty, (long)DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymaterial"), (long)DynamicObjectUtils.getPkValue((DynamicObject)baseUnit), (String)DynamicObjectUtils.getString((DynamicObject)baseUnit, (String)"name"));
        long distributionModeId = result.getLongValue("distributionModeId");
        if (distributionModeId != 0L) {
            DynamicObject distributionMode = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_distributionmode");
            deliveryEntity.set("deliverymode", (Object)distributionMode);
        }
        DynamicObject shippingStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"shippingstatus");
        deliveryEntity.set("deliverystatus", (Object)shippingStatus);
        long stockOrgId = result.getLongValue("stockorgid");
        if (stockOrgId != 0L) {
            DynamicObject stockOrg = BusinessDataServiceHelper.loadSingle((Object)stockOrgId, (String)"bos_org");
            deliveryEntity.set("inventoryorgid", (Object)stockOrg);
        }
        if ((stockId = result.getLongValue("stockid")) != 0L) {
            DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)stockId, (String)"bd_warehouse");
            deliveryEntity.set("erpstockid", (Object)stock);
        }
        invTypeId = (invTypeId = result.getLongValue("invtypeid")) == 0L ? 688884005529250816L : invTypeId;
        DynamicObject invType = BusinessDataServiceHelper.loadSingle((Object)invTypeId, (String)"bd_invtype");
        deliveryEntity.set("deliverystocktype", (Object)invType);
        SaleOrderDeliveryInfoHelper.fillInventoryData(data, deliveryEntity, result);
        deliveryEntity.set("seq", (Object)1);
    }

    public static void fillDeliveryDataAboutStock(IFormView view, DynamicObject data, DynamicObject entryItem, Object returnData) {
        List result = (List)returnData;
        if (CollectionUtils.isEmpty((Collection)result)) {
            return;
        }
        DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryItem, (String)"salesorderdelivery");
        if (deliveryEntities == null) {
            return;
        }
        deliveryEntities.clear();
        int seq = 1;
        for (JSONObject resultJson : result) {
            long invTypeId;
            long stockId;
            long stockOrgId;
            long channelWarehouseId;
            DynamicObject deliveryEntity = deliveryEntities.addNew();
            SaleOrderDeliveryInfoHelper.fillCommonData(data, deliveryEntity, resultJson);
            BigDecimal qty = resultJson.getBigDecimal("availableqty");
            deliveryEntity.set("deliversaleqty", (Object)qty);
            deliveryEntity.set("deliveryavareturnqty", (Object)qty);
            UnitTransferUtils.updateDeliveryMultiQuantities((IFormView)view, (DynamicObject)deliveryEntity, (BigDecimal)qty);
            long distributionModeId = resultJson.getLongValue("distributionmodeid");
            if (distributionModeId != 0L) {
                DynamicObject distributionMode = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_distributionmode");
                deliveryEntity.set("deliverymode", (Object)distributionMode);
                if (distributionModeId == 926601071999218688L || distributionModeId == 926601157210585088L) {
                    deliveryEntity.set("isselfpickup", (Object)Boolean.TRUE);
                }
            }
            DynamicObject shippingStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"shippingstatus");
            deliveryEntity.set("deliverystatus", (Object)shippingStatus);
            long deliveryChannelId = resultJson.getLongValue("deliverychannelid");
            if (deliveryChannelId != 0L) {
                DynamicObject deliveryChannel = BusinessDataServiceHelper.loadSingle((Object)distributionModeId, (String)"ocdbd_channel");
                deliveryEntity.set("deliverdeliverybranchid", (Object)deliveryChannel);
            }
            if ((channelWarehouseId = resultJson.getLongValue("channelwarehouseid")) != 0L) {
                DynamicObject stock = BusinessDataServiceHelper.loadSingle((Object)channelWarehouseId, (String)"ococic_warehouse");
                deliveryEntity.set("deliverstockid", (Object)stock);
            }
            if ((stockOrgId = resultJson.getLongValue("stockorgid")) != 0L) {
                DynamicObject stockOrg = BusinessDataServiceHelper.loadSingle((Object)stockOrgId, (String)"bos_org");
                deliveryEntity.set("inventoryorgid", (Object)stockOrg);
            }
            if ((stockId = resultJson.getLongValue("warehouseid")) != 0L) {
                DynamicObject erpStock = BusinessDataServiceHelper.loadSingle((Object)stockId, (String)"bd_warehouse");
                deliveryEntity.set("erpstockid", (Object)erpStock);
            }
            invTypeId = (invTypeId = resultJson.getLongValue("invtypeid")) == 0L ? 688884005529250816L : invTypeId;
            DynamicObject invType = BusinessDataServiceHelper.loadSingle((Object)invTypeId, (String)"bd_invtype");
            deliveryEntity.set("deliverystocktype", (Object)invType);
            SaleOrderDeliveryInfoHelper.fillInventoryData(data, deliveryEntity, resultJson);
            deliveryEntity.set("seq", (Object)seq);
            ++seq;
        }
    }

    public static void fillDeliveryData(IFormView view, DynamicObject data, DynamicObject entryEntity) {
        String bizType;
        DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
        if (deliveryEntities == null) {
            return;
        }
        deliveryEntities.clear();
        DynamicObject deliveryEntity = deliveryEntities.addNew();
        SaleOrderDeliveryInfoHelper.fillCommonData(data, deliveryEntity, new JSONObject());
        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"saleqty");
        deliveryEntity.set("deliversaleqty", (Object)qty);
        deliveryEntity.set("deliveryavareturnqty", (Object)qty);
        BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"baseunitqty");
        deliveryEntity.set("deliverybaseunitqty", (Object)baseUnitQty);
        BigDecimal auxUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"auxunitqty");
        deliveryEntity.set("deliveryauxunitqty", (Object)auxUnitQty);
        BigDecimal stockUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)data, (String)"stockunitqty");
        deliveryEntity.set("deliverystockunitqty", (Object)stockUnitQty);
        DynamicObject distributionMode = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"distributionmode");
        deliveryEntity.set("deliverymode", (Object)distributionMode);
        long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)distributionMode);
        if (distributionModeId == 926601071999218688L || distributionModeId == 926601157210585088L) {
            deliveryEntity.set("isselfpickup", (Object)Boolean.TRUE);
        }
        SaleOrderDeliveryInfoHelper.setStock(view, data, deliveryEntity);
        DynamicObject deliveryStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"shippingstatus");
        Object invType = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"channelstocktypeid");
        DynamicObject dataEntity = view.getModel().getDataEntity(true);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.RETURN.getId() && StringUtils.equals((CharSequence)(bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype")), (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            long branchId;
            deliveryStatus = BusinessDataServiceHelper.loadSingleFromCache((Object)DeliveryStatus.RETURN_WAIT_PICK, (String)"ococic_deliverstatus");
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
            Object sysStockType = SystemParamUtil.getChangeDefectDefInvType((long)orgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid")));
            if (sysStockType != null) {
                invType = sysStockType;
            }
        }
        deliveryEntity.set("deliverystatus", (Object)deliveryStatus);
        deliveryEntity.set("deliverystocktype", invType);
        SaleOrderDeliveryInfoHelper.fillInventoryData(data, deliveryEntity, new JSONObject());
        deliveryEntity.set("seq", (Object)1);
    }

    public static void fillCommonData(DynamicObject data, DynamicObject deliveryEntity, JSONObject resultJson) {
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"goodsid");
        deliveryEntity.set("delivergoodsid", (Object)goods);
        DynamicObject material = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"materielid");
        deliveryEntity.set("deliverymaterial", (Object)material);
        DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"barcode");
        deliveryEntity.set("deliverbarcodeid", (Object)barCode);
        DynamicObject brand = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"brand");
        deliveryEntity.set("brandid", (Object)brand);
        DynamicObject goodsClass = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"goodsclass");
        deliveryEntity.set("delivergoodsclass", (Object)goodsClass);
        DynamicObject unit = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"unit");
        deliveryEntity.set("deliverunitid", (Object)unit);
        DynamicObject baseUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"baseunit");
        deliveryEntity.set("deliverybaseunit", (Object)baseUnit);
        DynamicObject auxUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"auxunit");
        deliveryEntity.set("deliveryauxunit", (Object)auxUnit);
        DynamicObject stockUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"stockunit");
        deliveryEntity.set("deliverystockunit", (Object)stockUnit);
        DynamicObject serialUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"fdeliveryserialunit");
        deliveryEntity.set("fdeliveryserialunit", (Object)serialUnit);
        DynamicObject stockStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"channelstockstatusid");
        deliveryEntity.set("deliverystockstatus", (Object)stockStatus);
        String address = DynamicObjectUtils.getString((DynamicObject)data, (String)"customeraddress");
        deliveryEntity.set("address", (Object)address);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)data, (String)"admindivisionid");
        if (StringUtils.isNotBlank((CharSequence)adminDivisionId)) {
            deliveryEntity.set("districtid", (Object)adminDivisionId);
        }
        String consignee = DynamicObjectUtils.getString((DynamicObject)data, (String)"customername");
        deliveryEntity.set("consignee", (Object)consignee);
        String phone = DynamicObjectUtils.getString((DynamicObject)data, (String)"customerphone");
        deliveryEntity.set("deliverphonenumber", (Object)phone);
        if (StringUtils.isNotBlank((CharSequence)adminDivisionId) && !StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"0")) {
            DynamicObject adminDivision = BusinessDataServiceHelper.loadSingle((Object)adminDivisionId, (String)"bd_admindivision");
            String fullName = DynamicObjectUtils.getString((DynamicObject)adminDivision, (String)"fullname");
            String fullAddress = "";
            if (StringUtils.isNotBlank((CharSequence)fullName)) {
                fullAddress = fullName.replaceAll("_", "") + address;
            }
            deliveryEntity.set("fulladdress", (Object)fullAddress);
        }
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"isdelivery");
        deliveryEntity.set("deliverisdelivery", (Object)isDelivery);
        Date deliveryTime = DynamicObjectUtils.getDate((DynamicObject)data, (String)"deliverytime");
        deliveryEntity.set("deliverdeliverytime", (Object)deliveryTime);
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"isinstall");
        deliveryEntity.set("deliverisinstall", (Object)isInstall);
        Date installTime = DynamicObjectUtils.getDate((DynamicObject)data, (String)"installtime");
        deliveryEntity.set("deliverinstalltime", (Object)installTime);
        boolean isSelfPickup = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"isselfpickup");
        deliveryEntity.set("isselfpickup", (Object)isSelfPickup);
        Date selfPickupTime = DynamicObjectUtils.getDate((DynamicObject)data, (String)"selfpickuptime");
        deliveryEntity.set("selfpickuptime", (Object)selfPickupTime);
        DynamicObject shippingStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"shippingstatus");
        deliveryEntity.set("deliverystatus", (Object)shippingStatus);
        boolean isNegativeSell = DynamicObjectUtils.getBoolean((DynamicObject)data, (String)"isnegativesell");
        deliveryEntity.set("deliveryisnegativesell", (Object)isNegativeSell);
        String keeperType = resultJson.getString("keepertype");
        if (StringUtils.isBlank((CharSequence)keeperType)) {
            keeperType = DynamicObjectUtils.getString((DynamicObject)data, (String)"keepertype");
        }
        deliveryEntity.set("deliverykeepertype", (Object)keeperType);
        String ownerType = resultJson.getString("ownertype");
        if (StringUtils.isBlank((CharSequence)ownerType)) {
            ownerType = DynamicObjectUtils.getString((DynamicObject)data, (String)"ownertype");
        }
        deliveryEntity.set("deliveryownertype", (Object)ownerType);
        DynamicObject snMainFile = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"snmainfile");
        deliveryEntity.set("snmainfile", (Object)snMainFile);
        String serialNum = DynamicObjectUtils.getString((DynamicObject)data, (String)"deliveryserialnumber");
        deliveryEntity.set("deliveryserialnumber", (Object)serialNum);
        String locCodeNum = DynamicObjectUtils.getString((DynamicObject)data, (String)"deliverylotnum");
        deliveryEntity.set("deliverylotnum", (Object)locCodeNum);
        long srcDeliveryId = DynamicObjectUtils.getLong((DynamicObject)data, (String)"srcdeliveryentryid");
        deliveryEntity.set("srcdeliveryentryid", (Object)srcDeliveryId);
        boolean isChangeReturnOrReturn = CommonUtils.isChangeReturnOrReturn((DynamicObject)data, (DynamicObject)data);
        if (isChangeReturnOrReturn) {
            DynamicObject wbSrcDeliverStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"wbsrcdeliverstatus");
            deliveryEntity.set("wbsrcdeliverstatus", (Object)wbSrcDeliverStatus);
            DynamicObject srcDeliverStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"srcdeliverystatus");
            deliveryEntity.set("srcdeliverystatus", (Object)srcDeliverStatus);
            DynamicObject reason = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"returnreason");
            deliveryEntity.set("returnreason", (Object)reason);
            String type = DynamicObjectUtils.getString((DynamicObject)data, (String)"returntype");
            deliveryEntity.set("returntype", (Object)type);
        }
    }

    public static void fillInventoryData(DynamicObject data, DynamicObject item, JSONObject resultJson) {
        DynamicObject keeper = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"keeperid");
        DynamicObject owner = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"ownerid");
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"deliverisdelivery");
        if (isDelivery) {
            boolean isNegativeSell = DynamicObjectUtils.getBoolean((DynamicObject)item, (String)"deliveryisnegativesell");
            if (isNegativeSell) {
                keeper = DynamicObjectUtils.getDynamicObject((DynamicObject)item, (String)"inventoryorgid");
                long invOrgId = DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"inventoryorgid");
                owner = InventoryUtils.getDefaultOwner((long)invOrgId);
            } else {
                long keeperId = resultJson.getLongValue("keeperid");
                String keeperType = DynamicObjectUtils.getString((DynamicObject)item, (String)"deliverykeepertype");
                if (keeperId != 0L && StringUtils.equals((CharSequence)keeperType, (CharSequence)"bos_org")) {
                    keeper = BusinessDataServiceHelper.loadSingle((Object)keeperId, (String)"bos_org");
                }
                long ownerId = resultJson.getLongValue("ownerid");
                String ownerType = DynamicObjectUtils.getString((DynamicObject)item, (String)"deliveryownertype");
                if (ownerId != 0L && StringUtils.equals((CharSequence)ownerType, (CharSequence)"bos_org")) {
                    owner = BusinessDataServiceHelper.loadSingle((Object)ownerId, (String)"bos_org");
                }
            }
        }
        item.set("deliverykeeper", (Object)keeper);
        item.set("deliveryowner", (Object)owner);
    }

    public static void setStock(IFormView view, DynamicObject data, DynamicObject item) {
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"deliverdeliverybranchid");
        item.set("deliverdeliverybranchid", (Object)branch);
        DynamicObject stock = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"deliverstockid");
        item.set("deliverstockid", (Object)stock);
        DynamicObject stockOrg = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"inventoryorgid");
        item.set("inventoryorgid", (Object)stockOrg);
        DynamicObject erpStock = DynamicObjectUtils.getDynamicObject((DynamicObject)data, (String)"erpstockid");
        item.set("erpstockid", (Object)erpStock);
    }

    public static void updatePriceAndAmount(IFormView view, DynamicObject dataEntity, DynamicObject entryEntity, int index) {
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        boolean isEnablePricePolicy = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)bizOrgId, (long)branchId, (String)"isenblepricepolicy"));
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"barcode");
        CommonUtils.setRetailPrice((IFormView)view, (DynamicObject)entryEntity, (long)goodsId, (long)barCodeId, (int)index, (boolean)isEnablePricePolicy);
        CommonUtils.updateBalPriceAndAmount((DynamicObject)entryEntity);
        SaleOrderDeliveryInfoHelper.updatePriceAndAmount(view, entryEntity);
    }

    public static void updatePriceAndAmount(IFormView view, DynamicObject dataEntity, DynamicObject entryRow) {
        long billTypeId;
        if (entryRow.getBoolean("isbook")) {
            CommonUtils.updateDepositscale((DynamicObject)entryRow);
        }
        if ((billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype")) == BillTypeEnum.CVTSALE.getId()) {
            SaleAmountHelper.updateCvtAmountFieldsByQty(dataEntity, billTypeId, entryRow);
        } else {
            SaleOrderDeliveryInfoHelper.updatePriceAndAmount(view, entryRow);
        }
    }

    public static void updatePriceAndAmount(IFormView view, DynamicObject entryRow) {
        CommonUtils.updateReceivableAmount((IDataModel)view.getModel(), (DynamicObject)entryRow);
        CommonUtils.updateExpectFinalAmount((DynamicObject)entryRow);
    }

    public static boolean matchingOverSalePolicy(List<JSONObject> overSaleData, Map<String, Object> deliveryInfo, BigDecimal totalSaleQty, Date date, String status, Map<String, Object> result) {
        if (CollectionUtils.isEmpty(overSaleData)) {
            return false;
        }
        boolean isOverSale = false;
        overSaleData = overSaleData.stream().filter(x -> x.get((Object)"exparrdate") != null).sorted(Comparator.comparing(r -> r.getDate("exparrdate"))).collect(Collectors.toList());
        block4 : switch (status) {
            case "1": {
                for (int i = overSaleData.size() - 1; i >= 0; --i) {
                    BigDecimal canOverSaleQty = ((JSONObject)overSaleData.get(i)).getBigDecimal("canoversaleqty");
                    Date expirationDate = ((JSONObject)overSaleData.get(i)).getDate("exparrdate");
                    if (ObjectUtils.isEmpty((Object)canOverSaleQty) || canOverSaleQty.compareTo(totalSaleQty) < 0 || expirationDate.compareTo(date) > 0) continue;
                    deliveryInfo.put("isnegativesell", Boolean.TRUE);
                    deliveryInfo.put("oversalepolicyid", ((JSONObject)overSaleData.get(i)).getLongValue("id"));
                    deliveryInfo.put("oversalepolicyentryid", ((JSONObject)overSaleData.get(i)).getLongValue("entryid"));
                    deliveryInfo.put("data", overSaleData.get(i));
                    result.put("isSuccess", Boolean.TRUE);
                    result.put("errorMsg", "");
                    result.put("deliveryData", deliveryInfo);
                    isOverSale = true;
                    break block4;
                }
                break;
            }
            case "2": {
                overSaleData = overSaleData.stream().filter(x -> x.getBigDecimal("canoversaleqty").compareTo(totalSaleQty) >= 0 && x.getDate("exparrdate").compareTo(date) > 0).collect(Collectors.toList());
                if (overSaleData.isEmpty()) break;
                JSONObject overSaleItem = (JSONObject)overSaleData.get(0);
                DynamicObject item = BusinessDataServiceHelper.loadSingle((Object)((JSONObject)overSaleData.get(0)).getLong("itemid"), (String)"ocdbd_iteminfo", (String)"name");
                String itemName = item.get("name").toString();
                DateFormat df = DateFormat.getDateInstance();
                String str = String.format("\u5546\u54c1 %s \u5b58\u5728\u9884\u8ba1\u5230\u8d27\u65e5\u671f\u4e3a %s \u7684\uff0c\u53ef\u8d1f\u5356\u6570\u91cf\u4e3a %s \u7684\u8d1f\u5356\u653f\u7b56\uff0c\u53ef\u4fee\u6539\u914d\u9001\u65f6\u95f4\uff0c\u6267\u884c\u8d1f\u5356\u3002", itemName, df.format(overSaleItem.getDate("exparrdate")), overSaleItem.getBigDecimal("canoversaleqty").intValue());
                result.put("isSuccess", Boolean.FALSE);
                result.put("errorMsg", str);
                result.put("deliveryData", null);
                isOverSale = true;
                break;
            }
        }
        return isOverSale;
    }

    public static List<Map<String, Object>> exactMatchingDeliveryInfo(List<Map<String, Object>> params) {
        ArrayList<Map<String, Object>> result;
        block8: {
            result = new ArrayList<Map<String, Object>>(0);
            ArrayList<JSONObject> distRulesParams = new ArrayList<JSONObject>(0);
            for (Map<String, Object> param : params) {
                distRulesParams.addAll(SaleOrderDeliveryInfoHelper.getDistributionRuleParams(param));
            }
            List<JSONObject> distributionRules = SaleOrderDeliveryInfoHelper.getDistributionRules(distRulesParams);
            ArrayList<JSONObject> overSaleParams = new ArrayList<JSONObject>(0);
            for (Map<String, Object> param : params) {
                overSaleParams.addAll(SaleOrderDeliveryInfoHelper.getOverSaleParams(distributionRules, param));
            }
            List<JSONObject> overSaleData = SaleOrderDeliveryInfoHelper.getOverSaleData(overSaleParams);
            Iterator<Map<String, Object>> iterator = params.iterator();
            if (!iterator.hasNext()) break block8;
            Map<String, Object> param = iterator.next();
            BigDecimal totalSaleQty = CommonUtil.formatObjectToDecimal((Object)param.get("unitQty"));
            Date date = (Date)param.get("deliveryDate");
            int seq = CommonUtil.formatObjectToInt((Object)param.get("seq"));
            boolean isPresent = CommonUtil.formatObjectToBoolean((Object)param.get("ispresent"));
            long adminDivisionId = CommonUtil.formatObejctToLong((Object)param.get("adminDivisionId"));
            long itemId = CommonUtil.formatObejctToLong((Object)param.get("itemId"));
            long stockOrgId = CommonUtil.formatObejctToLong((Object)param.get("stockOrgId"));
            long stockId = CommonUtil.formatObejctToLong((Object)param.get("warehouseId"));
            long distributionModeId = CommonUtil.formatObejctToLong((Object)param.get("distributionModeId"));
            List<JSONObject> distributionRule = distributionRules.stream().filter(x -> x.getLong("itemId") == itemId && x.getLong("adminDivisionId") == adminDivisionId && x.getLong("warehouseId") == stockId && x.getLong("stockOrgId") == stockOrgId && x.getLong("distributionModeId") == distributionModeId).collect(Collectors.toList());
            if (ObjectUtils.isEmpty(distributionRule)) {
                HashMap<String, Object> map = new HashMap<String, Object>(0);
                map.put("seq", seq);
                map.put("success", Boolean.FALSE);
                map.put("message", "\u5546\u54c1\u4e3a\u914d\u9001\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219\u3002");
                result.add(map);
            } else if (!isPresent && SaleOrderDeliveryInfoHelper.exactMatchOverSalePolicy(totalSaleQty, date, overSaleData)) {
                HashMap<String, Object> map = new HashMap<String, Object>(0);
                map.put("seq", seq);
                map.put("success", Boolean.TRUE);
                map.put("message", "\u5546\u54c1\u4f7f\u7528\u8d1f\u5356\u653f\u7b56\u5339\u914d\u3002");
                result.add(map);
            } else {
                List<JSONObject> detailInfo = SaleOrderDeliveryInfoHelper.queryInventory(param, distributionRule, totalSaleQty);
                if (!CollectionUtils.isEmpty(detailInfo)) {
                    HashMap<String, Object> map = new HashMap<String, Object>(0);
                    map.put("seq", seq);
                    map.put("success", Boolean.TRUE);
                    map.put("message", "\u5546\u54c1\u5e93\u5b58\u6ee1\u8db3\u3002");
                    result.add(map);
                } else {
                    HashMap<String, Object> map = new HashMap<String, Object>(0);
                    map.put("seq", seq);
                    map.put("success", Boolean.FALSE);
                    map.put("message", "\u5546\u54c1\u5e93\u5b58\u4e0d\u8db3\u3002");
                    result.add(map);
                }
            }
        }
        return result;
    }

    public static Map<String, Object> buildCustomParams(DynamicObject dataEntity, int index) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(7);
        customParams.put("index", index);
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
        customParams.put("salebranchid", branchId);
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        customParams.put("bizorgid", bizOrgId);
        Date bizDate = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"bizdate");
        customParams.put("bizdate", bizDate);
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        customParams.put("basebilltype", billTypeId);
        long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"currencyid");
        customParams.put("currencyid", currencyId);
        long srcBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        customParams.put("sourcebillid", srcBillId);
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        customParams.put("biztype", bizType);
        return customParams;
    }

    public static void buildCustomParamsAboutGoods(Map<String, Object> customParams, DynamicObject goods) {
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        customParams.put("goodsid", goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"material");
        customParams.put("materielid", materialId);
        customParams.put("saleqty", BigDecimal.ONE);
    }

    public static void buildCustomParamsAboutBarCode(Map<String, Object> customParams, DynamicObject barCode) {
        DynamicObject goods = DynamicObjectUtils.getDynamicObject((DynamicObject)barCode, (String)"item");
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods);
        customParams.put("goodsid", goodsId);
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)barCode);
        customParams.put("barcode", barCodeId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)barCode, (String)"materiel");
        customParams.put("materielid", materialId);
        customParams.put("saleqty", BigDecimal.ONE);
    }

    public static void buildCustomParamsAboutOther(DynamicObject entryEntity, Map<String, Object> customParams) {
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
        customParams.put("goodsid", goodsId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materielid");
        customParams.put("materielid", materialId);
        long barCodeId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"barcode");
        customParams.put("barcode", barCodeId);
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
        customParams.put("saleqty", saleQty);
    }

    public static void buildCustomParamsAboutSale(DynamicObject entryEntity, Map<String, Object> customParams) {
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"unit");
        customParams.put("unit", unitId);
        BigDecimal retailPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"retailprice");
        customParams.put("retailprice", retailPrice);
        BigDecimal discountPrice = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"discountprice");
        customParams.put("discountprice", discountPrice);
        BigDecimal discountRate = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"discountrate");
        customParams.put("discountrate", discountRate);
        boolean isControlPrice = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"iscontrolprice");
        customParams.put("iscontrolprice", isControlPrice);
        String policyTypeName = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"pricetypename");
        customParams.put("pricetypename", policyTypeName);
        String policyTypeId = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"pricetype");
        customParams.put("priority", policyTypeId);
        boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
        customParams.put("ispresent", isPresent);
        long saleManId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodssaler");
        customParams.put("goodssaler", saleManId);
        long saleDeptId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"saledepartment");
        customParams.put("saledepartment", saleDeptId);
        long supplierId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"supplier");
        customParams.put("supplier", supplierId);
        BigDecimal finalPayment = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"finalpayment");
        customParams.put("finalpayment", finalPayment);
        BigDecimal finalScale = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"finalpaymentscale");
        customParams.put("finalpaymentscale", finalScale);
        long srcEntryId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"srcbillentryid");
        customParams.put("srcbillentryid", srcEntryId);
        long taxRateId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"taxrateid");
        customParams.put("taxrateid", taxRateId);
        BigDecimal taxRate = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"taxrate");
        customParams.put("taxrate", taxRate);
        long saleAttrId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"saleattr");
        customParams.put("saleattr", saleAttrId);
    }

    public static void buildCustomParamsAboutAmt(DynamicObject entryEntity, Map<String, Object> customParams) {
        DataEntityPropertyCollection properties = entryEntity.getDataEntityType().getProperties();
        for (IDataEntityProperty property : properties) {
            if (!(property instanceof AmountProp)) continue;
            String fieldKey = property.getName();
            BigDecimal amt = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)fieldKey);
            customParams.put(fieldKey, amt);
        }
    }

    public static void buildCustomParamsAboutBook(DynamicObject entryEntity, Map<String, Object> customParams) {
        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isbook");
        customParams.put("isbook", isBook);
        BigDecimal deposit = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"deposit");
        customParams.put("deposit", deposit);
        BigDecimal depositScale = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"depositscale");
        customParams.put("depositscale", depositScale);
        Date expectTakeOrderDate = DynamicObjectUtils.getDate((DynamicObject)entryEntity, (String)"expecttakeorderdate");
        customParams.put("expecttakeorderdate", expectTakeOrderDate);
        String bookType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"booktype");
        customParams.put("booktype", bookType);
        String bookPayType = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"bookpaytype");
        customParams.put("bookpaytype", bookPayType);
        boolean isAllowBook = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"isallowbook");
        customParams.put("isallowbook", isAllowBook);
    }

    public static long getBarCodeIdByGoods(long branchId, long currencyId, long goodsId) {
        List lstBarCodeId = F7Util.getBarCodeIdListByGoodsId((long)branchId, (long)currencyId, (long)goodsId);
        long barCodeId = 0L;
        if (!CollectionUtils.isEmpty((Collection)lstBarCodeId)) {
            barCodeId = (Long)lstBarCodeId.get(0);
        }
        return barCodeId;
    }

    private static boolean exactMatchOverSalePolicy(BigDecimal totalSaleQty, Date date, List<JSONObject> overSaleData) {
        boolean isExists = false;
        if (CollectionUtils.isEmpty(overSaleData)) {
            return false;
        }
        overSaleData = overSaleData.stream().filter(x -> x.get((Object)"exparrdate") != null).sorted(Comparator.comparing(r -> r.getDate("exparrdate"))).collect(Collectors.toList());
        for (int i = overSaleData.size() - 1; i >= 0; --i) {
            BigDecimal canOverSaleQty = ((JSONObject)overSaleData.get(i)).getBigDecimal("canoversaleqty");
            Date exparrdate = ((JSONObject)overSaleData.get(i)).getDate("exparrdate");
            if (ObjectUtils.isEmpty((Object)canOverSaleQty) || canOverSaleQty.compareTo(totalSaleQty) < 0 || exparrdate.compareTo(date) > 0) continue;
            isExists = true;
            break;
        }
        return isExists;
    }

    private static List<JSONObject> queryInventory(Map<String, Object> param, List<JSONObject> distributionRules, BigDecimal totalSaleQty) {
        BigDecimal totalInvQty;
        ArrayList<JSONObject> detailInfo = new ArrayList<JSONObject>();
        List<JSONObject> inventoryParams = SaleOrderDeliveryInfoHelper.getInventoryParams(distributionRules, param);
        LOG.info("\u5373\u65f6\u5e93\u5b58\u4f20\u53c2\uff1a" + SerializationUtils.toJsonString(inventoryParams));
        List<Object> inventoryInfo = SaleOrderDeliveryInfoHelper.getInventoryInfo(inventoryParams);
        LOG.info("\u5373\u65f6\u5e93\u5b58\u4f20\u53c2\uff1a" + SerializationUtils.toJsonString(inventoryInfo));
        if (!CollectionUtils.isEmpty(inventoryInfo) && !CollectionUtils.isEmpty(inventoryInfo = inventoryInfo.stream().filter(x -> !StringUtils.equals((CharSequence)x.getString("invstatus"), (CharSequence)"3") && !ObjectUtils.isEmpty((Object)x.get((Object)"invdetailinfolist"))).collect(Collectors.toList())) && (totalInvQty = inventoryInfo.stream().map(x -> x.getBigDecimal("sumAvbBaseQty")).reduce(BigDecimal::add).orElse(BigDecimal.ZERO)).compareTo(totalSaleQty) >= 0) {
            BigDecimal sumInvQty = BigDecimal.ZERO;
            BigDecimal preInvQty = BigDecimal.ZERO;
            for (JSONObject jSONObject : inventoryInfo) {
                List detail = jSONObject.getJSONArray("invdetailinfolist").toJavaList(JSONObject.class);
                if ((sumInvQty = sumInvQty.add(((JSONObject)detail.get(0)).getBigDecimal("availableqty"))).compareTo(totalSaleQty) >= 0) {
                    ((JSONObject)detail.get(0)).put("availableqty", (Object)totalSaleQty.subtract(preInvQty));
                    detailInfo.add((JSONObject)detail.get(0));
                    break;
                }
                ((JSONObject)detail.get(0)).put("availableqty", (Object)sumInvQty.subtract(preInvQty));
                detailInfo.add((JSONObject)detail.get(0));
                preInvQty = sumInvQty;
            }
        }
        return detailInfo;
    }

    public static void setDeliveryBillId(DynamicObject dataEntity, String entityId) {
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
            return;
        }
        boolean isInitBill = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"isinitbill");
        if (isInitBill) {
            return;
        }
        DynamicObjectCollection goodsEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntities)) {
            return;
        }
        for (DynamicObject goodsEntity : goodsEntities) {
            DynamicObjectCollection deliveryEntities;
            String operationMode = DynamicObjectUtils.getString((DynamicObject)goodsEntity, (String)"operationmodel");
            boolean isJoint = StringUtils.equals((CharSequence)operationMode, (CharSequence)"0");
            long goodsClassId = DynamicObjectUtils.getPkValue((DynamicObject)goodsEntity, (String)"goodsclass");
            boolean isService = goodsClassId == 870946434386494464L;
            boolean isAmt = goodsClassId == 870946349007286272L;
            boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntity, (String)"isbook");
            boolean isNegativeSell = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntity, (String)"isnegativesell");
            boolean isChange = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntity, (String)"ischangenewgift");
            if (isJoint || isService || isAmt || isBook || isNegativeSell || isChange || CollectionUtils.isEmpty((Collection)(deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goodsEntity, (String)"salesorderdelivery")))) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                boolean isVenderSell;
                long distributionModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymode");
                boolean bl = isVenderSell = distributionModeId == 1098521642067513344L;
                if (isVenderSell) continue;
                long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
                deliveryEntity.set("billid", (Object)billId);
                long detailId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity);
                deliveryEntity.set("originalentryid", (Object)detailId);
            }
        }
    }
}

