/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.JsonUtil;

public class SaleOrderDeliveryInventoryHelper {
    private static Log logger = LogFactory.getLog(SaleOrderDeliveryInventoryHelper.class, (String)"ocpos");

    public static void saleOrderInventoryAvaiable(IFormView view, DynamicObject goods, int parentIndex, int index) {
        IDataModel model = view.getModel();
        DynamicObject billType = (DynamicObject)model.getValue("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        List<JSONObject> inventoryDetailInfoList = SaleOrderDeliveryInventoryHelper.getInventoryAvaiable(view, model, goods, parentIndex, index);
        SaleOrderDeliveryInventoryHelper.writeBackInventoryData(goods, inventoryDetailInfoList, view, model, parentIndex, index);
    }

    private static List<JSONObject> getInventoryAvaiable(IFormView view, IDataModel model, DynamicObject goods, int parentIndex, int index) {
        List inventoryDetailInfoList = null;
        List<JSONObject> jsonParams = SaleOrderDeliveryInventoryHelper.buildInventoryParam(model, goods, parentIndex, index);
        logger.info("\u5f00\u5355\u5e93\u5b58\u4f20\u53c2\uff1a" + JsonUtil.toJson(jsonParams));
        List inventoryAvaliableList = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"matchDistributionWarehouse", (Object[])new Object[]{jsonParams});
        logger.info("\u5f00\u5355\u5e93\u5b58\u8fd4\u53c2\uff1a" + JsonUtil.toJson((Object)inventoryAvaliableList));
        String tip = SaleOrderDeliveryInventoryHelper.checkInventory(goods, inventoryAvaliableList);
        if (StringUtils.isNotEmpty((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)view);
            model.setValue("deliversaleqty", (Object)1, index);
            return inventoryDetailInfoList;
        }
        for (Map.Entry inventorySet : ((JSONObject)inventoryAvaliableList.get(0)).entrySet()) {
            if (!"invdetailinfolist".equals(inventorySet.getKey())) continue;
            inventoryDetailInfoList = (List)inventorySet.getValue();
            break;
        }
        return inventoryDetailInfoList;
    }

    private static List<JSONObject> buildInventoryParam(IDataModel model, DynamicObject goods, int parentIndex, int index) {
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        DynamicObject org = (DynamicObject)model.getValue("bizorgid");
        long adminDivisionId = CommonUtil.formatObejctToLong((Object)model.getValue("admindivisionid"));
        DynamicObject auxPty = (DynamicObject)model.getValue("auxattrid", parentIndex);
        DynamicObject unit = (DynamicObject)model.getValue("unit", parentIndex);
        BigDecimal deliverysaleQty = (BigDecimal)model.getValue("deliversaleqty", index);
        BigDecimal baseunitQty = (BigDecimal)model.getValue("baseunitqty", parentIndex);
        DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", parentIndex);
        DynamicObject stockOrg = (DynamicObject)model.getValue("inventoryorg", index);
        DynamicObject warehouse = (DynamicObject)model.getValue("erpstock", index);
        DynamicObject distributionmode = (DynamicObject)model.getValue("distributionmode", index);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("saleOrgId", (Object)org.getLong("id"));
        jsonObject.put("saleChannelID", (Object)branch.getLong("id"));
        jsonObject.put("itemId", (Object)goods.getLong("id"));
        jsonObject.put("materialId", (Object)goods.getLong("material.id"));
        if (auxPty != null) {
            jsonObject.put("auxPtyID", (Object)auxPty.getLong("id"));
        }
        if (unit != null) {
            jsonObject.put("unitId", (Object)unit.getLong("id"));
        }
        jsonObject.put("unitQty", (Object)deliverysaleQty);
        if (baseUnit != null) {
            jsonObject.put("baseUnitID", (Object)baseUnit.getLong("id"));
        }
        jsonObject.put("baseUnitQty", (Object)baseunitQty);
        if (stockOrg != null) {
            jsonObject.put("stockOrgId", (Object)stockOrg.getLong("id"));
        }
        if (warehouse != null) {
            jsonObject.put("warehouseId", (Object)warehouse.getLong("id"));
        }
        if (distributionmode != null) {
            jsonObject.put("distributionModeId", (Object)distributionmode.getLong("id"));
        }
        jsonObject.put("adminDivisionId", (Object)adminDivisionId);
        jsonObject.put("customerKey", (Object)index);
        ArrayList<JSONObject> jsonParams = new ArrayList<JSONObject>();
        jsonParams.add(jsonObject);
        return jsonParams;
    }

    private static void writeBackInventoryData(DynamicObject goods, List<JSONObject> inventoryDetailInfoList, IFormView view, IDataModel model, int parentIndex, int index) {
        if (inventoryDetailInfoList != null && inventoryDetailInfoList.size() > 0) {
            DynamicObject goodsEntity = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("goodsentryentity").get(parentIndex);
            DynamicObjectCollection deliveryEntityList = goodsEntity.getDynamicObjectCollection("salesorderdelivery");
            DynamicObject unit = goods.getDynamicObject("saleunit");
            BigDecimal deliversaleqty = (BigDecimal)model.getValue("deliversaleqty", index);
            String warehouseid = null;
            BigDecimal availableQty = null;
            for (int i = 0; i < inventoryDetailInfoList.size(); ++i) {
                DynamicObject delivery;
                JSONObject jsonObject = inventoryDetailInfoList.get(i);
                warehouseid = jsonObject.getString("warehouseid");
                availableQty = jsonObject.getBigDecimal("availablebaseqty");
                if (deliversaleqty.compareTo(BigDecimal.ZERO) <= 0) break;
                if (i > 0) {
                    delivery = deliveryEntityList.addNew();
                    SaleOrderDeliveryInventoryHelper.setDeliveryInfo(delivery, model, goods, parentIndex, index);
                } else {
                    delivery = (DynamicObject)deliveryEntityList.get(index);
                }
                BigDecimal surplusQty = SaleOrderDeliveryInventoryHelper.checkRepeatSaleQty(deliveryEntityList, model, jsonObject, availableQty, index);
                if (surplusQty.signum() == 0) continue;
                deliversaleqty = deliversaleqty.subtract(surplusQty);
                delivery.set("deliversaleqty", (Object)surplusQty);
                view.updateView("deliversaleqty", index);
                DynamicObject warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id,name,entryentity.location.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)warehouseid)});
                if (warehouse == null) continue;
                if (availableQty.subtract(deliversaleqty).compareTo(BigDecimal.ZERO) < 0 && deliversaleqty.subtract(availableQty).compareTo(BigDecimal.ZERO) < 0 || availableQty.signum() < 0) {
                    NotificationUtil.showDefaultTipNotify((String)("\u5f53\u524d" + warehouse.getString("name") + "\u5e93\u5b58\u53ef\u7528\u6570\u91cf" + availableQty + unit.getString("name") + ",\u8bf7\u91cd\u65b0\u8f93\u5165\u9500\u552e\u6570\u91cf"), (IFormView)view);
                    model.setValue("deliversaleqty", (Object)1, index);
                    break;
                }
                if (warehouse.get("entryentity.location.id") != null && warehouse.getLong("entryentity.location.id") > 0L) {
                    DynamicObject deliveryPosition = BusinessDataServiceHelper.loadSingle((Object)warehouse.get("entryentity.location.id"), (String)"bd_location");
                    delivery.set("erpstockpositionid", (Object)deliveryPosition);
                    view.updateView("erpstockpositionid", index);
                }
                if (jsonObject.getLong("channelwarehouseid") != null && jsonObject.getLong("channelwarehouseid") > 0L) {
                    DynamicObject deliveryStock = BusinessDataServiceHelper.loadSingle((Object)jsonObject.getLong("channelwarehouseid"), (String)"ococic_warehouse");
                    delivery.set("deliverstockid", (Object)deliveryStock);
                    view.updateView("deliverstockid", index);
                }
                if (jsonObject.getLong("stockorgid") != null && jsonObject.getLong("stockorgid") > 0L) {
                    DynamicObject inventoryOrg = BusinessDataServiceHelper.loadSingle((Object)jsonObject.getString("stockorgid"), (String)"bos_org");
                    delivery.set("inventoryorgid", (Object)inventoryOrg);
                    view.updateView("inventoryorgid", index);
                }
                DynamicObject mode = BusinessDataServiceHelper.loadSingle((Object)jsonObject.getLong("distributionmodeid"), (String)"dbd_distributionmode");
                delivery.set("deliverymode", (Object)mode);
                view.updateView("deliverymode", index);
                delivery.set("erpstockid", (Object)BusinessDataServiceHelper.loadSingle((Object)warehouseid, (String)"bd_warehouse"));
                view.updateView("erpstockid", index);
                deliversaleqty = deliversaleqty.subtract(availableQty);
            }
        }
    }

    private static String checkInventory(DynamicObject goods, List<JSONObject> inventoryAvaliableList) {
        String goodName = goods.getString("name");
        String tip = null;
        if (inventoryAvaliableList == null || inventoryAvaliableList.size() == 0 || StringUtils.isNotEmpty((CharSequence)inventoryAvaliableList.get(0).getString("invstatus")) && "2".equals(inventoryAvaliableList.get(0).getString("invstatus"))) {
            tip = "\u8be5\u5546\u54c1" + goodName + "\u95e8\u5e97\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u9009\u62e9\u9884\u8ba2\u3001\u6216\u67e5\u8be2\u4e2d\u5fc3\u4ed3\u662f\u5426\u6709\u5e93\u5b58";
        } else if (StringUtils.isNotEmpty((CharSequence)inventoryAvaliableList.get(0).getString("invstatus")) && "3".equals(inventoryAvaliableList.get(0).getString("invstatus"))) {
            tip = "\u8be5\u5546\u54c1" + goodName + "\u4e3a\u914d\u9001\uff0c\u666e\u901a\u5546\u54c1\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219";
        }
        return tip;
    }

    public static void setDeliveryInfo(DynamicObject deliveryItem, IDataModel model, DynamicObject goods, int index, int delieveryIndex) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"barcode");
        DynamicObject distributionMode = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"distributionmode");
        DynamicObject erpStockPosition = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"erpstockposition");
        DynamicObject goodClass = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"goodsclass");
        DynamicObject brand = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"brand");
        deliveryItem.set("seq", (Object)(delieveryIndex + 1));
        if (goods != null) {
            DynamicObject unit = goods.getDynamicObject("saleunit");
            if (unit != null) {
                deliveryItem.set("deliverunitid", (Object)unit);
            }
            deliveryItem.set("delivergoodsid", (Object)goods);
            deliveryItem.set("deliversaleqty", (Object)1);
            deliveryItem.set("brandid", (Object)brand);
            deliveryItem.set("delivergoodsclass", (Object)goodClass);
            deliveryItem.set("deliverisdelivery", (Object)goods.getBoolean("isdelivery"));
            deliveryItem.set("deliverymode", (Object)distributionMode);
            deliveryItem.set("deliverisinstall", (Object)goods.getBoolean("isinstall"));
            deliveryItem.set("deliverdeliverybranchid", (Object)branch);
            DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_WAIT_DELIVERY, (String)"ococic_deliverstatus");
            deliveryItem.set("deliverystatus", (Object)deliveryStatus);
            QFilter filter = F7Util.getStockIdFilter((DynamicObject)branch);
            filter.and("isdelivery", "=", (Object)Boolean.TRUE);
            DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)"ococic_warehouse", (String)"id", (QFilter[])filter.toArray());
            deliveryItem.set("deliverstockid", (Object)stock);
            if (stock != null) {
                QFilter stockPositionFilter = new QFilter("warehouseid", "=", (Object)stock.getLong("id"));
                DynamicObject stockPosition = BusinessDataServiceHelper.loadSingle((String)"ococic_location", (String)"Id,warehouseid", (QFilter[])stockPositionFilter.toArray());
                deliveryItem.set("stockpositionid", (Object)stockPosition);
            }
            if (erpStockPosition != null) {
                deliveryItem.set("erpstockpositionid", (Object)erpStockPosition);
            }
        }
        if (barCode != null) {
            deliveryItem.set("deliverbarcodeid", (Object)barCode);
        }
        if (member != null) {
            deliveryItem.set("consignee", (Object)member.getString("name"));
            String memberPhone = member.getString("mobile");
            if (memberPhone.contains("-")) {
                memberPhone = memberPhone.substring(memberPhone.indexOf(45) + 1);
            }
            deliveryItem.set("deliverphonenumber", (Object)memberPhone);
            String address = CommonUtil.formatStringToEmpty((Object)model.getValue("customeraddress"));
            String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
            SaleOrderDeliveryInventoryHelper.upadateDeliveryAddress(deliveryItem, adminDivisionId, address);
        }
    }

    public static void upadateDeliveryAddress(DynamicObject deliveryItem, String adminDivisionId, String address) {
        deliveryItem.set("districtid", (Object)adminDivisionId);
        deliveryItem.set("address", (Object)address);
        if (StringUtils.isNotBlank((CharSequence)adminDivisionId) && !StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"0")) {
            DynamicObject adminDivision = BusinessDataServiceHelper.loadSingle((Object)adminDivisionId, (String)"bd_admindivision");
            String fullName = DynamicObjectUtils.getString((DynamicObject)adminDivision, (String)"fullname");
            String fullAddress = "";
            if (StringUtils.isNotBlank((CharSequence)fullName)) {
                fullAddress = fullName.replaceAll("_", "") + address;
            }
            if (fullAddress.length() > 0) {
                deliveryItem.set("fulladdress", (Object)fullAddress);
            } else {
                deliveryItem.set("fulladdress", null);
            }
        }
    }

    public static void setDefaultDeliveryInfoByGoods(IDataModel model, DynamicObject entryItem, DynamicObject goods) {
        String operationModel = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
        if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            DynamicObject supplier = DynamicObjectUtils.getDynamicObject((DynamicObject)goods, (String)"supplerid");
            entryItem.set("supplier", (Object)supplier);
        }
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isinstall");
        entryItem.set("isinstall", (Object)isInstall);
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isdelivery");
        entryItem.set("isdelivery", (Object)isDelivery);
        SaleOrderDeliveryInventoryHelper.setDefaultOperationmodel(model, entryItem, goods, isDelivery);
    }

    private static void setDefaultOperationmodel(IDataModel model, DynamicObject entryItem, DynamicObject goods, boolean isdelivery) {
        if (goods == null) {
            return;
        }
        String operationmodel = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        DynamicObject stockId = CommonUtils.getDefaultDeliveryStock((DynamicObject)branch);
        if (isdelivery && StringUtils.equals((CharSequence)operationmodel, (CharSequence)"0")) {
            entryItem.set("distributionmode", (Object)926600963786061824L);
        } else if (isdelivery && StringUtils.equals((CharSequence)operationmodel, (CharSequence)"1")) {
            entryItem.set("distributionmode", (Object)926596489101228032L);
            entryItem.set("stockid", (Object)stockId);
        } else if (!isdelivery && StringUtils.equals((CharSequence)operationmodel, (CharSequence)"0")) {
            entryItem.set("distributionmode", (Object)926601157210585088L);
        } else if (!isdelivery && StringUtils.equals((CharSequence)operationmodel, (CharSequence)"1")) {
            entryItem.set("distributionmode", (Object)926601071999218688L);
        }
    }

    public static void setDefaultDeliveryInfo(IFormView view, DynamicObject entryItem, DynamicObject goods, int index) {
        DynamicObjectCollection deliveryEntry = entryItem.getDynamicObjectCollection("salesorderdelivery");
        deliveryEntry.clear();
        DynamicObject deliveryItem = deliveryEntry.addNew();
        SaleOrderDeliveryInventoryHelper.setDeliveryInfo(deliveryItem, view.getModel(), goods, index, 0);
        view.updateView("salesorderdelivery");
    }

    private static BigDecimal checkRepeatSaleQty(DynamicObjectCollection deliveryEntityList, IDataModel model, JSONObject jsonObject, BigDecimal availableQty, int index) {
        BigDecimal surplusQty = availableQty;
        String repeatKey = String.format("%s_%s_%s", jsonObject.getString("distributionmodeid"), jsonObject.getString("stockorgid"), jsonObject.getString("warehouseid"));
        for (int i = 0; i < deliveryEntityList.size(); ++i) {
            String deliveryKey;
            DynamicObject delivery = (DynamicObject)deliveryEntityList.get(i);
            if (i == index || !repeatKey.equals(deliveryKey = String.format("%s_%s_%s", delivery.getString("deliverymode.id"), delivery.getString("inventoryorgid.id"), delivery.getString("erpstockid.id")))) continue;
            surplusQty = delivery.getBigDecimal("deliversaleqty").compareTo(surplusQty) > 0 ? BigDecimal.ZERO : surplusQty.subtract(delivery.getBigDecimal("deliversaleqty"));
        }
        return surplusQty;
    }
}

