/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;

public class SaleOrderDrawHelper {
    public static ListSelectedRowCollection getAllListSelectedRow(DynamicObject dataEntity, boolean wholeBillPush, List<Map<String, Object>> lstData, String sourceEntryKey, String srcSubEntryKey) {
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        if (wholeBillPush) {
            SaleOrderDrawHelper.getWholeBillSelectedRow(listSelectedRows, dataEntity);
            return listSelectedRows;
        }
        if (lstData == null || lstData.isEmpty()) {
            return listSelectedRows;
        }
        SaleOrderDrawHelper.getNoWholeBillSelectedRow(listSelectedRows, dataEntity, lstData, sourceEntryKey, srcSubEntryKey);
        return listSelectedRows;
    }

    public static Map<DynamicObject, ListSelectedRowCollection> getRelateSendEntitySelectedRow(DynamicObject dataEntity, List<Map<String, Object>> lstData, String sourceEntryKey, String srcSubEntryKey) {
        DynamicObject[] cvtBills;
        HashMap<DynamicObject, ListSelectedRowCollection> billListSelectedRowsMap = new HashMap<DynamicObject, ListSelectedRowCollection>(0);
        ArrayList<Integer> pushIniSeqLst = new ArrayList<Integer>(0);
        ArrayList<Long> pushGoodsEntryIdLst = new ArrayList<Long>(0);
        ArrayList<DynamicObject> pushGoodsEntryLst = new ArrayList<DynamicObject>(0);
        DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        for (Map<String, Object> map : lstData) {
            String changeItemType = map.get("changeitemtype").toString();
            if (changeItemType.equals("1") || changeItemType.equals("3")) {
                return billListSelectedRowsMap;
            }
            boolean isRedRush = CommonUtil.formatObjectToBoolean((Object)map.get("wholebillpush"));
            if (isRedRush) {
                for (DynamicObject goodsEntry : goodsEntryEntity) {
                    pushGoodsEntryIdLst.add(DynamicObjectUtil.getPkValue((DynamicObject)goodsEntry));
                }
            }
            long entryPkValue = CommonUtil.formatObejctToLong((Object)map.get("entryid"));
            pushGoodsEntryIdLst.add(entryPkValue);
        }
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            long entryId = DynamicObjectUtil.getPkValue((DynamicObject)goodsEntry);
            if (!pushGoodsEntryIdLst.contains(entryId)) continue;
            int iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"inisrcseq");
            if (iniSrcSeq == 0 && (iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"srcseq")) == 0) {
                iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"seq");
            }
            pushIniSeqLst.add(iniSrcSeq);
            pushGoodsEntryLst.add(goodsEntry);
        }
        DynamicObject initialBill = null;
        long initialBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"initialbillid");
        if (initialBillId > 0L) {
            String selectFields = "basebilltype,billno,billstatus,initialbillid,biztype,goodsendentity,goodsendentity.seq,goodsendentity.giftrettype,goodsendentity.inisendgoodsseq,goodsendentity.sendgoodsseq,goodsentryentity,goodsentryentity.seq,goodsentryentity.srcseq,goodsentryentity.inisrcseq,goodsentryentity.ispresent,goodsentryentity.mustretqty,goodsentryentity.gifttype,goodsentryentity.promoteseq,goodsentryentity.drawqty,goodsentryentity.salesorderpromote,salesorderpromote.srcpromotegoodsseq,salesorderpromote.promotegoodsseq,salesorderpromote.promoterettype,salesorderpromote.iniexegoodsseq,salesorderpromote.exegoodsseq,goodsentryentity.salesorderdelivery,salesorderdelivery.deliveryavareturnqty,salesorderdelivery.deliverydrawqty";
            initialBill = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder", (String)selectFields);
            SaleOrderDrawHelper.getPushGoodsEntryLst(initialBill, pushIniSeqLst, pushGoodsEntryLst);
        }
        SaleOrderDrawHelper.getDataEntitySelectedRow(dataEntity, pushIniSeqLst, pushGoodsEntryLst, sourceEntryKey, srcSubEntryKey, billListSelectedRowsMap);
        if (initialBill != null) {
            SaleOrderDrawHelper.getDataEntitySelectedRow(initialBill, pushIniSeqLst, pushGoodsEntryLst, sourceEntryKey, srcSubEntryKey, billListSelectedRowsMap);
        }
        long billId = DynamicObjectUtil.getPkValue((DynamicObject)dataEntity);
        if (initialBillId == 0L) {
            initialBillId = billId;
        }
        if ((cvtBills = SaleOrderWriteBackHelper.getLinkDownCvtBills(initialBillId, billId, true)) != null && cvtBills.length > 0) {
            for (DynamicObject cvtBill : cvtBills) {
                SaleOrderDrawHelper.getDataEntitySelectedRow(cvtBill, pushIniSeqLst, pushGoodsEntryLst, sourceEntryKey, srcSubEntryKey, billListSelectedRowsMap);
            }
        }
        return billListSelectedRowsMap;
    }

    private static void getDataEntitySelectedRow(DynamicObject dataEntity, List<Integer> pushIniSeqLst, List<DynamicObject> pushGoodsEntryLst, String sourceEntryKey, String srcSubEntryKey, Map<DynamicObject, ListSelectedRowCollection> billListSelectedRowsMap) {
        ListSelectedRowCollection listSelectedRows = new ListSelectedRowCollection();
        DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            DynamicObjectCollection salesOrderDelivery;
            List<String> lstStrSendGoodsSeq;
            String promoteRetType;
            boolean isPresent = goodsEntry.getBoolean("ispresent");
            BigDecimal mustRetQty = goodsEntry.getBigDecimal("mustretqty");
            if (!isPresent || mustRetQty.compareTo(BigDecimal.ZERO) <= 0) continue;
            int iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"inisrcseq");
            if (iniSrcSeq == 0 && (iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"srcseq")) == 0) {
                iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"seq");
            }
            if (!StringUtils.isEmpty((CharSequence)(promoteRetType = SaleOrderDrawHelper.getIniSendGiftRetType(dataEntity, goodsEntry, iniSrcSeq, pushIniSeqLst, pushGoodsEntryLst))) || (lstStrSendGoodsSeq = SaleOrderDrawHelper.getSendGoodsEntryFieldValue(dataEntity, goodsEntry, iniSrcSeq, pushGoodsEntryLst)) == null || lstStrSendGoodsSeq.size() == 0) continue;
            List lstSendGoodsSeq = lstStrSendGoodsSeq.stream().map(Integer::parseInt).collect(Collectors.toList());
            lstSendGoodsSeq.retainAll(pushIniSeqLst);
            if (lstSendGoodsSeq.size() <= 0 || CollectionUtils.isEmpty((Collection)(salesOrderDelivery = goodsEntry.getDynamicObjectCollection("salesorderdelivery")))) continue;
            ArrayList<Map<String, Object>> lstData = new ArrayList<Map<String, Object>>(0);
            for (DynamicObject delivery : salesOrderDelivery) {
                BigDecimal deliveryAvaReturnQty = delivery.getBigDecimal("deliveryavareturnqty");
                if (deliveryAvaReturnQty.compareTo(BigDecimal.ZERO) <= 0) continue;
                HashMap<String, Number> sendMap = new HashMap<String, Number>(4);
                sendMap.put("entryid", DynamicObjectUtil.getPkValue((DynamicObject)goodsEntry));
                sendMap.put("subentryid", DynamicObjectUtil.getPkValue((DynamicObject)delivery));
                sendMap.put("basebilltypeid", DynamicObjectUtil.getPkValue((DynamicObject)dataEntity, (String)"basebilltype"));
                sendMap.put("changeqty", deliveryAvaReturnQty.negate());
                lstData.add(sendMap);
            }
            if (CollectionUtils.isEmpty(lstData)) continue;
            SaleOrderDrawHelper.getNoWholeBillSelectedRow(listSelectedRows, dataEntity, lstData, sourceEntryKey, srcSubEntryKey);
            billListSelectedRowsMap.put(dataEntity, listSelectedRows);
        }
    }

    public static void getPushGoodsEntryLst(DynamicObject dataEntity, List<Integer> pushIniSeqLst, List<DynamicObject> pushGoodsEntryLst) {
        pushGoodsEntryLst.clear();
        DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            int iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"inisrcseq");
            if (iniSrcSeq == 0 && (iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"srcseq")) == 0) {
                iniSrcSeq = DynamicObjectUtil.getInt((DynamicObject)goodsEntry, (String)"seq");
            }
            if (!pushIniSeqLst.contains(iniSrcSeq)) continue;
            pushGoodsEntryLst.add(goodsEntry);
        }
    }

    public static List<String> getSendGoodsEntryFieldValue(DynamicObject dataEntity, DynamicObject sendGoodsEntry, int iniSrcSeq, List<DynamicObject> pushGoodsEntryLst) {
        ArrayList<String> lstSendGoodsSeq = new ArrayList<String>(0);
        String exeGoodsSeq = "";
        String giftType = sendGoodsEntry.getString("gifttype");
        if (StringUtils.equals((CharSequence)giftType, (CharSequence)"3")) {
            for (DynamicObject pushGoodsEntry : pushGoodsEntryLst) {
                DynamicObjectCollection salesOrderPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)pushGoodsEntry, (String)"salesorderpromote");
                if (CollectionUtils.isEmpty((Collection)salesOrderPromote)) continue;
                DynamicObject promoteEntry = salesOrderPromote.stream().filter(x -> x.getInt("srcpromotegoodsseq") == iniSrcSeq).findFirst().orElse(null);
                if (promoteEntry == null) {
                    promoteEntry = salesOrderPromote.stream().filter(x -> x.getInt("promotegoodsseq") == iniSrcSeq).findFirst().orElse(null);
                }
                if (promoteEntry == null) continue;
                exeGoodsSeq = promoteEntry.getString("iniexegoodsseq");
                if (StringUtils.isEmpty((CharSequence)exeGoodsSeq)) {
                    exeGoodsSeq = promoteEntry.getString("exegoodsseq");
                }
                break;
            }
        } else {
            DynamicObjectCollection sendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
            int promoteSeq = sendGoodsEntry.getInt("promoteseq");
            DynamicObject sendEntry = sendEntity.stream().filter(x -> x.getInt("seq") == promoteSeq).findFirst().orElse(null);
            if (sendEntry != null && StringUtils.isEmpty((CharSequence)(exeGoodsSeq = sendEntry.getString("inisendgoodsseq")))) {
                exeGoodsSeq = sendEntry.getString("sendgoodsseq");
            }
        }
        if (!StringUtils.isEmpty((CharSequence)exeGoodsSeq)) {
            lstSendGoodsSeq = new ArrayList<String>(Arrays.asList(exeGoodsSeq.split(",")));
        }
        return lstSendGoodsSeq;
    }

    public static String getIniSendGiftRetType(DynamicObject dataEntity, DynamicObject sendGoodsEntry, int iniSrcSeq, List<Integer> pushIniSeqLst, List<DynamicObject> pushGoodsEntryLst) {
        String giftType;
        String giftRetType = "";
        DynamicObject initialBill = null;
        DynamicObject initialSendGoodsEntry = null;
        List<Object> initialPushGoodsEntryLst = new ArrayList(pushGoodsEntryLst.size());
        long initialBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"initialbillid");
        String srcBizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcbiztype");
        if (initialBillId > 0L && initialBillId != DynamicObjectUtils.getPkValue((DynamicObject)dataEntity) && !StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)"H")) {
            String selectFields = "goodsentryentity.seq,goodsentryentity.gifttype,goodsentryentity.promoteseq,goodsendentity.seq,goodsendentity.giftrettype,goodsentryentity.salesorderpromote.srcpromotegoodsseq,goodsentryentity.salesorderpromote.promotegoodsseq,goodsentryentity.salesorderpromote.promoterettype";
            initialBill = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder", (String)selectFields);
            DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initialBill, (String)"goodsentryentity");
            for (DynamicObject goodsEntry : goodsEntryEntity) {
                int seq = goodsEntry.getInt("seq");
                if (seq == iniSrcSeq) {
                    initialSendGoodsEntry = goodsEntry;
                }
                if (!pushIniSeqLst.contains(seq)) continue;
                initialPushGoodsEntryLst.add(goodsEntry);
            }
            if (!CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
                initialSendGoodsEntry = goodsEntryEntity.stream().filter(x -> x.getInt("seq") == iniSrcSeq).findFirst().orElse(null);
            }
            if (initialSendGoodsEntry == null) {
                return giftRetType;
            }
        } else {
            initialBill = dataEntity;
            initialSendGoodsEntry = sendGoodsEntry;
            initialPushGoodsEntryLst = pushGoodsEntryLst;
        }
        if (StringUtils.equals((CharSequence)(giftType = initialSendGoodsEntry.getString("gifttype")), (CharSequence)"3")) {
            for (DynamicObject dynamicObject : initialPushGoodsEntryLst) {
                DynamicObjectCollection salesOrderPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dynamicObject, (String)"salesorderpromote");
                if (CollectionUtils.isEmpty((Collection)salesOrderPromote)) continue;
                DynamicObject promoteEntry = salesOrderPromote.stream().filter(x -> x.getInt("srcpromotegoodsseq") == iniSrcSeq).findFirst().orElse(null);
                if (promoteEntry == null) {
                    promoteEntry = salesOrderPromote.stream().filter(x -> x.getInt("promotegoodsseq") == iniSrcSeq).findFirst().orElse(null);
                }
                if (promoteEntry == null) continue;
                giftRetType = promoteEntry.getString("promoterettype");
                break;
            }
        } else {
            DynamicObjectCollection sendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initialBill, (String)"goodsendentity");
            int n = initialSendGoodsEntry.getInt("promoteseq");
            DynamicObject sendEntry = sendEntity.stream().filter(x -> x.getInt("seq") == promoteSeq).findFirst().orElse(null);
            if (sendEntry != null) {
                giftRetType = sendEntry.getString("giftrettype");
            }
        }
        return giftRetType;
    }

    public static void getWholeBillSelectedRow(ListSelectedRowCollection listSelectedRows, DynamicObject saleOrder) {
        DynamicObject billType = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"basebilltype");
        long billTypeId = CommonUtil.formatObejctToLong((Object)billType.getPkValue());
        String srcBillNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
        String srcBillStatus = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billstatus");
        ListSelectedRow listSelectedRow = new ListSelectedRow();
        listSelectedRow.setPrimaryKeyValue(saleOrder.getPkValue());
        listSelectedRow.setBillNo(srcBillNo);
        listSelectedRow.setBillStatus(srcBillStatus);
        listSelectedRow.setBillTypeID(Long.valueOf(billTypeId));
        listSelectedRow.setMainOrgId(1L);
        listSelectedRows.add((Object)listSelectedRow);
    }

    public static void getNoWholeBillSelectedRow(ListSelectedRowCollection listSelectedRows, DynamicObject dataEntity, List<Map<String, Object>> lstData, String sourceEntryKey, String srcSubEntryKey) {
        int rowIndex = 0;
        BigDecimal drawQty = BigDecimal.ZERO;
        BigDecimal deliveryDrawQty = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> entityQtyMap = new HashMap<Long, BigDecimal>(lstData.size());
        for (Map<String, Object> map : lstData) {
            long entryPkValue = CommonUtil.formatObejctToLong((Object)map.get("entryid"));
            long subEntityPkValue = CommonUtil.formatObejctToLong((Object)map.get("subentryid"));
            ListSelectedRow listSelectedRow = new ListSelectedRow();
            SaleOrderDrawHelper.getBillSelectedRow(map, listSelectedRow, dataEntity, sourceEntryKey, rowIndex);
            BigDecimal changeQty = CommonUtil.formatObjectToDecimal((Object)map.get("changeqty"));
            if (subEntityPkValue > 0L) {
                deliveryDrawQty = changeQty;
                BigDecimal qty = (BigDecimal)entityQtyMap.get(entryPkValue);
                if (qty == null) {
                    qty = BigDecimal.ZERO;
                }
                drawQty = deliveryDrawQty.add(qty);
                entityQtyMap.put(entryPkValue, drawQty);
                listSelectedRow.setSubEntryPrimaryKeyValue((Object)subEntityPkValue);
                listSelectedRow.setSubEntryEntityKey(srcSubEntryKey);
            } else {
                drawQty = changeQty;
            }
            SaleOrderDrawHelper.updateUpBillDrawQty(dataEntity, entryPkValue, subEntityPkValue, drawQty, deliveryDrawQty);
            listSelectedRows.add((Object)listSelectedRow);
        }
        SaveServiceHelper.update((DynamicObject)dataEntity);
    }

    private static void getBillSelectedRow(Map<String, Object> map, ListSelectedRow listSelectedRow, DynamicObject saleOrder, String entryKey, int rowIndex) {
        DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection(entryKey);
        if (CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
            return;
        }
        long entryPkValue = CommonUtil.formatObejctToLong((Object)map.get("entryid"));
        long billTypeId = CommonUtil.formatObejctToLong((Object)map.get("basebilltypeid"));
        String srcBillNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
        String srcBillStatus = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billstatus");
        listSelectedRow.setPrimaryKeyValue(saleOrder.getPkValue());
        listSelectedRow.setEntryPrimaryKeyValue((Object)entryPkValue);
        listSelectedRow.setEntryEntityKey(entryKey);
        listSelectedRow.setBillNo(srcBillNo);
        listSelectedRow.setBillStatus(srcBillStatus);
        listSelectedRow.setBillTypeID(Long.valueOf(billTypeId));
        listSelectedRow.setMainOrgId(1L);
        listSelectedRow.setRowKey(rowIndex++);
    }

    private static void updateUpBillDrawQty(DynamicObject dataEntity, long entryPkValue, long subEntryPkValue, BigDecimal drawQty, BigDecimal deliveryDrawQty) {
        DynamicObjectCollection goodsEntryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntryEntity) || entryPkValue <= 0L || drawQty.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObject goodsEntry = goodsEntryEntity.stream().filter(a -> a.getLong("id") == entryPkValue).findFirst().orElse(null);
        if (goodsEntry != null) {
            DynamicObjectCollection deliveryEntryEntity;
            goodsEntry.set("drawqty", (Object)drawQty);
            if (subEntryPkValue > 0L && !CollectionUtils.isEmpty((Collection)(deliveryEntryEntity = goodsEntry.getDynamicObjectCollection("salesorderdelivery")))) {
                deliveryEntryEntity.stream().filter(a -> a.getLong("id") == subEntryPkValue).findFirst().ifPresent(deliveryEntry -> deliveryEntry.set("deliverydrawqty", (Object)deliveryDrawQty));
            }
        }
    }

    public static void setDrawQtyZero(DynamicObject saleOrder) {
        DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
            return;
        }
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            goodsEntry.set("drawqty", (Object)BigDecimal.ZERO);
            DynamicObjectCollection deliveryEntryEntity = goodsEntry.getDynamicObjectCollection("salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntryEntity)) continue;
            for (DynamicObject deliveryEntry : deliveryEntryEntity) {
                deliveryEntry.set("deliverydrawqty", (Object)BigDecimal.ZERO);
            }
        }
        SaveServiceHelper.update((DynamicObject)saleOrder);
    }
}

