/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.payhelper.FinPayTradeHelper;
import kd.occ.ocbase.business.payhelper.PayTradeHelper;
import kd.occ.ocbase.business.payhelper.PaymentFlowHelper;
import kd.occ.ocbase.common.enums.CreditFlowTypeEnum;
import kd.occ.ocbase.common.enums.OptionDirectEnum;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.enums.PromotionEnum;
import kd.occ.ocbase.common.enums.TicketFlowOperTypeEnum;
import kd.occ.ocbase.common.enums.TicketStatusEnum;
import kd.occ.ocbase.common.pay.config.CheckOutCounterInfo;
import kd.occ.ocbase.common.pay.config.PayResult;
import kd.occ.ocbase.common.pay.config.RefundInfo;
import kd.occ.ocbase.common.pay.config.RefundResult;
import kd.occ.ocbase.common.pay.config.TradeStatus;
import kd.occ.ocbase.common.pay.finpay.BarCodePayGoodsDetail;
import kd.occ.ocbase.common.pay.finpay.util.ResponseEnum;
import kd.occ.ocbase.common.pay.payment.vo.PaymentRecord;
import kd.occ.ocbase.common.util.DateUtil;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.MultiBaseDataUtil;
import kd.occ.ocbase.common.util.ORMUtil;
import kd.occ.ocbase.common.util.pos.ItemClassNodeUtil;
import kd.occ.ocdbd.business.helper.CreditMangageHelper;
import kd.occ.ocdbd.business.helper.ticket.TicketsInfoHelper;
import kd.occ.ocdbd.common.enums.VipTypeEnum;
import kd.occ.ocepfp.common.util.StringUtil;
import kd.occ.ocpos.business.commonhelper.CurrencyHelper;
import kd.occ.ocpos.business.invoice.InvoiceHelper;
import kd.occ.ocpos.business.olstore.OlstoreMemberHelper;
import kd.occ.ocpos.business.olstore.OlstoreTicketHelper;
import kd.occ.ocpos.business.promotion.OlstorePromotionHelper;
import kd.occ.ocpos.business.saleorder.SaleAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderAmountHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.business.saleorder.TicketAmountHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.GiftTypeEnum;
import kd.occ.ocpos.common.enums.ReturnModelEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.OlstoreUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderHelper {
    public static final String PAYSTATUS = "payStatus";
    public static final String PAYTIME = "payTime";
    public static final String TRADENO = "tradeNo";
    public static final String THIRDNO = "thirdNo";
    public static final String TRANSNO = "transNo";
    public static final String OUTTRADENO = "outTradeNo";
    public static final String PAYRESPONSE = "payResponse";
    public static final String REFUNDAMOUNT = "refundAmount";
    public static final String SETTLEAMOUNT = "settleamount";
    public static final String ERRORMSG = "errorMsg";
    public static final String REFUNDSTATUS = "refundstatus";
    private static Log logger = LogFactory.getLog(SaleOrderHelper.class);

    public static String createSaleOrderInvoice(DynamicObject saleOrder, Object retailOrderId) {
        String invoiceCloudType = "0";
        if (saleOrder.getString("biztype").equalsIgnoreCase(BizTypeEnum.SALERETURN.getValue())) {
            invoiceCloudType = "1";
        }
        DynamicObject retailOrder = BusinessDataServiceHelper.loadSingle((Object)retailOrderId, (String)"ocococ_retailbill");
        return InvoiceHelper.createInvoice(saleOrder, retailOrder, invoiceCloudType);
    }

    public static void savePayRecordAfterSettleOp(DynamicObject saleOrder, DynamicObjectCollection payRecordList, Map<String, String> discountHandleMap) {
        if (payRecordList == null) {
            return;
        }
        boolean isDoSendHandle = false;
        String orderStatus = "A";
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        String entityId = saleOrder.getDataEntityType().getName();
        try (TXHandle handle = TX.requiresNew();){
            try {
                JSONObject jsonResult;
                List<String> lstTicketNo;
                DynamicObjectCollection useTicketEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"useticketentity");
                if (!(CollectionUtils.isEmpty((Collection)useTicketEntity) || CollectionUtils.isEmpty(lstTicketNo = useTicketEntity.stream().filter(x -> !ObjectUtils.isEmpty((Object)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"utticket"))).map(x -> DynamicObjectUtils.getString((DynamicObject)DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"utticket"), (String)"number")).collect(Collectors.toList())) || (jsonResult = SaleOrderHelper.ticketPay(saleOrder, lstTicketNo.toArray(new String[0]), entityId)).getBoolean("success").booleanValue())) {
                    logger.info(String.format("\u793c\u5238\u6838\u9500\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", jsonResult.getString("message")));
                    throw new KDBizException(jsonResult.getString("message"));
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)entityId, (CharSequence)BillTypeEnum.RETAIL.getEntityId())) {
                    isDoSendHandle = true;
                    if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
                        SaleOrderWriteBackHelper.updateSrcBillPushOrderFinal(saleOrder);
                    }
                } else if (billTypeId == BillTypeEnum.CREDIT.getId()) {
                    JSONObject jsonResult2;
                    DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"salebranchid");
                    if (branch == null) {
                        throw new KDBizException("\u9500\u552e\u95e8\u5e97\u4e3a\u7a7a\u3002");
                    }
                    boolean isEnableCredit = DynamicObjectUtils.getBoolean((DynamicObject)branch, (String)"isenablecredit");
                    if (isEnableCredit && !(jsonResult2 = SaleOrderHelper.doCreditReceipt(saleOrder)).getBoolean("success").booleanValue()) {
                        logger.info(String.format("\u8d4a\u9500\u6536\u6b3e\u4fe1\u7528\u66f4\u65b0\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", jsonResult2.getString("message")));
                        throw new KDBizException(jsonResult2.getString("message"));
                    }
                } else if (billTypeId == BillTypeEnum.FINAL.getId() || billTypeId == BillTypeEnum.RESERVEFINAL.getId()) {
                    SaleOrderWriteBackHelper.updateSrcBillPushOrderFinal(saleOrder);
                } else if (billTypeId == BillTypeEnum.CHANGE.getId()) {
                    orderStatus = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"orderstatus");
                    isDoSendHandle = true;
                    String changeItemType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"changeitemtype");
                    if (StringUtils.equals((CharSequence)changeItemType, (CharSequence)"2")) {
                        SaleOrderHelper.refundPointTicket(saleOrder, discountHandleMap);
                    }
                }
                BigDecimal equalValuePayAmount = BigDecimal.ZERO;
                BigDecimal sumWipeAmount = BigDecimal.ZERO;
                DynamicObjectCollection finEntryEntity = saleOrder.getDynamicObjectCollection("finentity");
                for (DynamicObject payRecord : payRecordList) {
                    DynamicObject payWay = payRecord.getDynamicObject("payway");
                    if (payWay.getBoolean("iselectronicpay") || payRecord.getLong("stageid") > 0L) continue;
                    PaymentRecord paymentRecord = new PaymentRecord();
                    paymentRecord.setPayWay(payWay);
                    SaleOrderHelper.setEachPaymentRecord(saleOrder, paymentRecord, payRecord);
                    paymentRecord.setPayStatus("A");
                    DynamicObject newFinEntity = finEntryEntity.addNew();
                    SaleOrderHelper.updateSaleOrderAfterPayment(saleOrder, newFinEntity, paymentRecord, null);
                    BigDecimal wipeAmount = paymentRecord.getWipeAmount();
                    if (wipeAmount != null && wipeAmount.compareTo(BigDecimal.ZERO) != 0) {
                        sumWipeAmount = sumWipeAmount.add(wipeAmount);
                    }
                    if (PaymentModeEnum.EqualValuePay.getKey() != DynamicObjectUtils.getPkValue((DynamicObject)payWay)) continue;
                    equalValuePayAmount = equalValuePayAmount.add(paymentRecord.getAmount());
                }
                if (billTypeId == BillTypeEnum.CHANGE.getId()) {
                    SaleAmountHelper.updateExchangePayAmount(saleOrder, equalValuePayAmount);
                }
                SaleOrderHelper.wipeAmountShare(sumWipeAmount, saleOrder);
                saleOrder.set("saleendtime", (Object)TimeServiceHelper.now());
                saleOrder.set("orderstatus", (Object)orderStatus);
                saleOrder.set("salestatus", (Object)"S");
                if (billTypeId == BillTypeEnum.RETAIL.getId() || billTypeId == BillTypeEnum.CVTSALE.getId() || billTypeId == BillTypeEnum.GROUP.getId() || billTypeId == BillTypeEnum.GUIDE.getId()) {
                    SaleOrderHelper.activateTicket(saleOrder);
                }
                saleOrder.set("returnopr", (Object)user);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            }
            catch (Throwable ex) {
                logger.info(String.format("\u5355\u53f7%s\u4fdd\u5b58\u652f\u4ed8\u8bb0\u5f55\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno"), ex.getMessage()));
                handle.markRollback();
                throw ex;
            }
        }
        if (isDoSendHandle) {
            SaleOrderHelper.doSendHandle(entityId, saleOrder);
            SaveServiceHelper.update((DynamicObject)saleOrder);
        }
    }

    public static void saveRefundRecordAfterSettleOp(DynamicObject saleReturn, List<PaymentRecord> paymentRecords, Map<String, String> discountHandleMap) {
        if (saleReturn == null) {
            throw new KDBizException("\u8ba2\u5355\u4e3b\u952e\u4e0d\u5b58\u5728\uff01");
        }
        boolean notConfirm = saleReturn.getBoolean("notconfirm");
        String bizType = saleReturn.getString("biztype");
        String billNo = DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"billno");
        DynamicObjectCollection finentity = saleReturn.getDynamicObjectCollection("finentity");
        for (PaymentRecord paymentRecord : paymentRecords) {
            DynamicObject payWay = paymentRecord.getPayWay();
            DynamicObject payWayType = paymentRecord.getPayWayType();
            if (payWayType == null) {
                paymentRecord.setPayWayType(SaleOrderHelper.getPayWayType(payWay));
            }
            if (!payWay.getBoolean("iselectronicpay") || !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"R")) continue;
            logger.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7535\u5b50\u652f\u4ed8\u9000\u6b3e\u53c2\u6570\uff1a%s", billNo, paymentRecord.toString()));
            JSONObject payResult = SaleOrderHelper.callUnifyElecSettle(saleReturn, paymentRecord, "0");
            if (!payResult.getBoolean("success").booleanValue()) {
                String msg = String.format("\u96f6\u552e\u5355\u53f7%s\u5916\u90e8\u8ba2\u5355\u53f7:%s\u652f\u4ed8\u65b9\u5f0f%s\u9000\u6b3e\u5931\u8d25", billNo, paymentRecord.getPayWay().getString("name"), paymentRecord.getOrderNo());
                logger.info(String.format("\u7535\u5b50\u652f\u4ed8\u9000\u6b3e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", msg));
                throw new KDBizException(msg);
            }
            DynamicObject newFinentity = finentity.addNew();
            SaleOrderHelper.updateSaleOrderAfterRefund(saleReturn, newFinentity, paymentRecord, null);
        }
        DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
        boolean isRefundPointTicket = false;
        boolean isCancelOlstorePromotion = false;
        try (TXHandle handle = TX.requiresNew();){
            try {
                JSONObject jsonResult;
                if (!StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N")) {
                    if (!notConfirm) {
                        SaleOrderWriteBackHelper.updateSrcBillPushOrderRefundFinal(saleReturn);
                    }
                    isRefundPointTicket = true;
                    String orderSource = saleReturn.getString("ordersource");
                    if (StringUtils.isNotEmpty((CharSequence)orderSource) && (orderSource.equals("D") || orderSource.equals("E"))) {
                        isCancelOlstorePromotion = true;
                    }
                }
                BigDecimal equalValuePayAmount = BigDecimal.ZERO;
                ArrayList<String> lstTicketNo = new ArrayList<String>(paymentRecords.size());
                for (PaymentRecord paymentRecord : paymentRecords) {
                    BigDecimal settleAmount = paymentRecord.getAmount();
                    long sourceBillId = paymentRecord.getSourcebillId();
                    long creditAccountId = paymentRecord.getCreditAccountId();
                    DynamicObject payWay = paymentRecord.getPayWay();
                    DynamicObject payWayType = paymentRecord.getPayWayType();
                    if (payWayType == null) {
                        paymentRecord.setPayWayType(SaleOrderHelper.getPayWayType(payWay));
                    }
                    long payWayId = DynamicObjectUtils.getPkValue((DynamicObject)payWay);
                    if (payWay.getBoolean("iselectronicpay")) continue;
                    String payWayName = DynamicObjectUtils.getString((DynamicObject)payWay, (String)"name");
                    logger.info(String.format("\u96f6\u552e\u5355\u53f7%s\u7ed3\u7b97\u652f\u4ed8\u5217\u8868%s\u91d1\u989d%.2f\u5143", billNo, payWayName, settleAmount));
                    if (payWayId == PaymentModeEnum.creditpay.getKey()) {
                        saleReturn.set("debitopr", (Object)user);
                        long billId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn);
                        boolean rlt = SaleOrderHelper.doCreditReturnPay(billId, creditAccountId, settleAmount.negate());
                        if (!rlt) {
                            logger.info(String.format("\u4fe1\u7528\u8d26\u6237\u66f4\u65b0\u5931\u8d25\uff0c\u5355\u636eID\uff1a%d\uff0c \u4fe1\u7528\u8d26\u6237ID\uff1a%d \u66f4\u65b0\u5931\u8d25", billId, creditAccountId));
                            throw new KDBizException("\u4fe1\u7528\u8d26\u6237\u66f4\u65b0\u5931\u8d25\u3002");
                        }
                        if (sourceBillId > 0L) {
                            SaleOrderWriteBackHelper.updateSaleOrderFinCreditPay(sourceBillId, creditAccountId, settleAmount);
                        }
                    } else if (PaymentModeEnum.coupon.getKey() == DynamicObjectUtils.getPkValue((DynamicObject)payWay)) {
                        String cardno = paymentRecord.getCardNo();
                        QFilter qFilter = new QFilter("number", "=", (Object)cardno);
                        DynamicObject ticketInfo = BusinessDataServiceHelper.loadSingle((String)"ocdbd_ticketinfo", (String)"id,number,tickettypeid", (QFilter[])qFilter.toArray());
                        paymentRecord.setTicketInfo(ticketInfo);
                        if (ticketInfo != null) {
                            paymentRecord.setTicketType(DynamicObjectUtils.getDynamicObject((DynamicObject)ticketInfo, (String)"tickettypeid"));
                        }
                        qFilter = new QFilter("id", "=", (Object)paymentRecord.getPayFlowId());
                        qFilter = qFilter.and("cardno", "=", (Object)cardno);
                        qFilter = qFilter.and("paystatus", "=", (Object)"A");
                        DynamicObject ticketFlow = QueryServiceHelper.queryOne((String)"ocdbd_paymentflow", (String)"settleamount,refundamount,isallrefund", (QFilter[])(qFilter = qFilter.and("payoption", "=", (Object)"1")).toArray());
                        if (ticketFlow != null) {
                            boolean isallrefund = ticketFlow.getBoolean("isallrefund");
                            BigDecimal ticketsettleamount = ticketFlow.getBigDecimal(SETTLEAMOUNT);
                            BigDecimal ticketrefundamount = ticketFlow.getBigDecimal("refundamount");
                            BigDecimal surplusamount = ticketsettleamount.add(ticketrefundamount);
                            if (settleAmount.negate().compareTo(surplusamount) == 0) {
                                lstTicketNo.add(paymentRecord.getCardNo());
                            } else if (settleAmount.negate().compareTo(surplusamount) > 0 || isallrefund) {
                                logger.info(String.format("\u9000\u8d27\u5355\u53f7:%s\uff0c\u5238\u53f7:%s\u53ef\u9000\u4f59\u989d\u4e0d\u8db3\u3002", billNo, cardno));
                                throw new KDBizException(String.format("\u5238\u53f7[%s]\u9000\u6b3e\u4f59\u989d\u4e0d\u8db3\u3002", cardno));
                            }
                        }
                    } else if (PaymentModeEnum.cashpay.getKey() == payWayId) {
                        saleReturn.set("cashreceiver", (Object)user);
                    }
                    DynamicObject newFinentity = finentity.addNew();
                    SaleOrderHelper.updateSaleOrderAfterRefund(saleReturn, newFinentity, paymentRecord, null);
                    if (PaymentModeEnum.EqualValuePay.getKey() != payWayId) continue;
                    equalValuePayAmount = equalValuePayAmount.add(paymentRecord.getAmount());
                }
                if (StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"H")) {
                    SaleAmountHelper.updateExchangePayAmount(saleReturn, equalValuePayAmount);
                }
                if (lstTicketNo.size() > 0 && !(jsonResult = SaleOrderHelper.ticketRefund(saleReturn, lstTicketNo)).getBoolean("success").booleanValue()) {
                    logger.info(String.format("\u793c\u5238\u7ea2\u51b2\u9000\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", jsonResult.getString("message")));
                    throw new KDBizException(jsonResult.getString("message"));
                }
                saleReturn.set("saleendtime", (Object)TimeServiceHelper.now());
                saleReturn.set("salestatus", (Object)"S");
                saleReturn.set("orderstatus", (Object)"I");
                saleReturn.set("returnopr", (Object)user);
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleReturn});
            }
            catch (Throwable ex) {
                handle.markRollback();
                throw ex;
            }
        }
        if (isRefundPointTicket && discountHandleMap != null && discountHandleMap.size() > 0) {
            SaleOrderHelper.refundPointTicket(saleReturn, discountHandleMap);
            SaveServiceHelper.update((DynamicObject)saleReturn);
        }
        if (isCancelOlstorePromotion) {
            OlstorePromotionHelper.cancelOlstorePromotion(saleReturn);
            SaveServiceHelper.update((DynamicObject)saleReturn);
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"N") && StringUtils.equals((CharSequence)saleReturn.getDataEntityType().getName(), (CharSequence)"ocpos_saleorder_return")) {
            SaleOrderHelper.unActivateTicket(saleReturn);
        }
    }

    private static void refundPointTicket(DynamicObject saleReturn, Map<String, String> discountHandleMap) {
        String ticketDiscountType;
        DynamicObject[] cvtBills = null;
        DynamicObject initSaleOrder = null;
        ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(0);
        long initialBillId = DynamicObjectUtils.getLong((DynamicObject)saleReturn, (String)"initialbillid");
        if (initialBillId > 0L) {
            initSaleOrder = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder");
            updateBills.add(initSaleOrder);
            cvtBills = SaleOrderWriteBackHelper.getLinkDownCvtBills(initialBillId, 0L, false);
            if (cvtBills != null && cvtBills.length > 0) {
                updateBills.addAll(Arrays.asList(cvtBills));
            }
        }
        String entityId = saleReturn.getDataEntityType().getName();
        ArrayList<DynamicObject> lstSendPoint = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> lstPromotionPoint = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> lstSendTicket = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> lstPromotionTicket = new ArrayList<DynamicObject>(0);
        String integralDiscountType = discountHandleMap.get("integraldiscounttype");
        if (StringUtils.isEmpty((CharSequence)integralDiscountType)) {
            SaleOrderHelper.deductPoint(entityId, saleReturn, initSaleOrder, updateBills, lstSendPoint, lstPromotionPoint);
        }
        if (StringUtils.isEmpty((CharSequence)(ticketDiscountType = discountHandleMap.get("ticketdiscounttype")))) {
            SaleOrderHelper.updateSendTicketStatus(entityId, saleReturn, initSaleOrder, updateBills, lstSendTicket, lstPromotionTicket);
        }
        SaleOrderHelper.updateLinkDownCvtBillDiscAmt(initSaleOrder, updateBills, lstSendPoint, lstPromotionPoint, lstSendTicket, lstPromotionTicket);
        SaleOrderHelper.writeBackGiftRetType(saleReturn, initSaleOrder);
        SaleOrderHelper.discountAmountHandle(saleReturn, initSaleOrder, updateBills, discountHandleMap);
        if (!CollectionUtils.isEmpty(updateBills)) {
            SaveServiceHelper.update((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
        }
    }

    private static void discountAmountHandle(DynamicObject saleOrder, DynamicObject initSaleOrder, List<DynamicObject> updateBills, Map<String, String> discountHandleMap) {
        String changeItemType;
        if (initSaleOrder == null || CollectionUtils.isEmpty(updateBills)) {
            return;
        }
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        if (billTypeId != BillTypeEnum.RETURN.getId() && billTypeId != BillTypeEnum.CHANGE.getId()) {
            return;
        }
        if (billTypeId == BillTypeEnum.CHANGE.getId() && !(changeItemType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"changeitemtype")).equals("2")) {
            return;
        }
        DynamicObjectCollection goodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        DynamicObjectCollection initGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntry) || CollectionUtils.isEmpty((Collection)initGoodsEntry)) {
            return;
        }
        for (DynamicObject doGoodsEntry : goodsEntry) {
            DynamicObjectCollection docSrcGoodsEntry;
            String saleOption;
            if (billTypeId == BillTypeEnum.CHANGE.getId() && !StringUtils.equals((CharSequence)"0", (CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"saleoption")))) continue;
            BigDecimal discountValueEde = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountvalueded");
            BigDecimal discountCustCpst = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountcustcpst");
            long entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"entrysrcbillid");
            DynamicObject srcSaleOrderBill = updateBills.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == entrySrcBillId).findFirst().orElse(null);
            if (srcSaleOrderBill == null || CollectionUtils.isEmpty((Collection)(docSrcGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)srcSaleOrderBill, (String)"goodsentryentity")))) continue;
            long srcBillEntryId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"srcbillentryid");
            DynamicObject srcGoodsEntry = docSrcGoodsEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == srcBillEntryId).findFirst().orElse(null);
            if (srcGoodsEntry == null) continue;
            BigDecimal couponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"coupondiscount");
            BigDecimal adRetCouponDiscAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)srcGoodsEntry, (String)"adretcoupondiscamount");
            BigDecimal sumShareDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)srcGoodsEntry, (String)"sumsharediscount");
            String ticketDiscountType = discountHandleMap.get("ticketdiscounttype");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)ticketDiscountType)) {
                doGoodsEntry.set("discountvalueded", (Object)discountValueEde.add(couponDiscount));
                srcGoodsEntry.set("adretcoupondiscamount", (Object)adRetCouponDiscAmount.add(couponDiscount));
                sumShareDiscount = sumShareDiscount.subtract(couponDiscount.abs());
                srcGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount);
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)ticketDiscountType)) {
                doGoodsEntry.set("discountcustcpst", (Object)discountCustCpst.add(couponDiscount));
                srcGoodsEntry.set("adretcoupondiscamount", (Object)adRetCouponDiscAmount.add(couponDiscount));
                sumShareDiscount = sumShareDiscount.subtract(couponDiscount.abs());
                srcGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount);
            }
            if (!StringUtils.isEmpty((CharSequence)ticketDiscountType)) {
                if (initGoodsEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == DynamicObjectUtils.getPkValue((DynamicObject)srcGoodsEntry))) {
                    Map<Integer, Object> seqSyncValue = SaleOrderHelper.getWriteBillSeqValueMap(doGoodsEntry, couponDiscount);
                    SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncValue, "goodsentryentity", "adretcoupondiscamount", false, doGoodsEntry, false);
                }
                Map<Integer, Object> seqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, doGoodsEntry, "ticketsendentity", "goodsseq", ticketDiscountType, "ticketrettype", false, "1");
                Map<Integer, Object> seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, doGoodsEntry, "salesorderpromote", "goodsseq", ticketDiscountType, "promoterettype", true, "1");
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncRetTypeValue, "ticketsendentity", "ticketrettype", true, doGoodsEntry, false);
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqPromoteSyncRetTypeValue, "salesorderpromote", "promoterettype", true, doGoodsEntry, true);
            }
            discountValueEde = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountvalueded");
            discountCustCpst = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountcustcpst");
            BigDecimal integralDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"integraldistamount");
            BigDecimal adRetIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)srcGoodsEntry, (String)"adretintegraldistamount");
            sumShareDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)srcGoodsEntry, (String)"sumsharediscount");
            String integralDiscountType = discountHandleMap.get("integraldiscounttype");
            if (StringUtils.equals((CharSequence)"1", (CharSequence)integralDiscountType)) {
                doGoodsEntry.set("discountvalueded", (Object)discountValueEde.add(integralDiscount));
                srcGoodsEntry.set("adretintegraldistamount", (Object)adRetIntegralDistAmount.add(integralDiscount));
                sumShareDiscount = sumShareDiscount.subtract(integralDiscount.abs());
                srcGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount);
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)integralDiscountType)) {
                doGoodsEntry.set("discountcustcpst", (Object)discountCustCpst.add(integralDiscount));
                srcGoodsEntry.set("adretintegraldistamount", (Object)adRetIntegralDistAmount.add(integralDiscount));
                sumShareDiscount = sumShareDiscount.subtract(integralDiscount.abs());
                srcGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount);
            }
            if (StringUtils.isEmpty((CharSequence)integralDiscountType)) continue;
            if (initGoodsEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == DynamicObjectUtils.getPkValue((DynamicObject)srcGoodsEntry))) {
                Map<Integer, Object> seqSyncValue = SaleOrderHelper.getWriteBillSeqValueMap(doGoodsEntry, integralDiscount);
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncValue, "goodsentryentity", "adretintegraldistamount", false, doGoodsEntry, false);
            }
            Map<Integer, Object> seqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, doGoodsEntry, "sendintegralentity", "insgoodsseq", integralDiscountType, "pointrettype", false, "2");
            Map<Integer, Object> seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, doGoodsEntry, "salesorderpromote", "insgoodsseq", integralDiscountType, "promoterettype", true, "2");
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncRetTypeValue, "sendintegralentity", "pointrettype", true, doGoodsEntry, false);
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqPromoteSyncRetTypeValue, "salesorderpromote", "promoterettype", true, doGoodsEntry, true);
        }
        String giftDiscountType = discountHandleMap.get("giftdiscounttype");
        String giftValue = discountHandleMap.get("giftvalue");
        SaleOrderHelper.setGiftDiscountAmount(saleOrder, goodsEntry, giftDiscountType, giftValue, updateBills, initSaleOrder);
        if (updateBills.size() > 0) {
            SaveServiceHelper.update((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
        }
    }

    private static void writeBackGiftRetType(DynamicObject saleOrder, DynamicObject initSaleOrder) {
        String changeItemType;
        if (initSaleOrder == null) {
            return;
        }
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        if (billTypeId != BillTypeEnum.RETURN.getId() && billTypeId != BillTypeEnum.CHANGE.getId()) {
            return;
        }
        if (billTypeId == BillTypeEnum.CHANGE.getId() && !StringUtils.equals((CharSequence)(changeItemType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"changeitemtype")), (CharSequence)"2")) {
            return;
        }
        DynamicObjectCollection goodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntry)) {
            return;
        }
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"sourcebillid");
        if (sourceBillId == 0L) {
            return;
        }
        HashMap<Integer, Object> seqSyncRetTypeValue = new HashMap<Integer, Object>(0);
        for (DynamicObject goodsItem : goodsEntry) {
            String saleOption;
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)goodsItem, (String)"ispresent");
            if (isPresent || billTypeId == BillTypeEnum.CHANGE.getId() && !StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)goodsItem, (String)"saleoption")), (CharSequence)"0")) continue;
            Map<Integer, Object> tmpSeqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, goodsItem, "goodsendentity", "sendgoodsseq", "0", "giftrettype", false, "0");
            seqSyncRetTypeValue.putAll(tmpSeqSyncRetTypeValue);
            Map<Integer, Object> tmpSeqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, goodsItem, "salesorderpromote", "exegoodsseq", "0", "promoterettype", true, "0");
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, tmpSeqPromoteSyncRetTypeValue, "salesorderpromote", "promoterettype", true, goodsItem, true);
        }
        if (seqSyncRetTypeValue.size() == 0) {
            return;
        }
        SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncRetTypeValue, "goodsendentity", "giftrettype", true, null, false);
    }

    private static boolean setGiftDiscountAmount(DynamicObject saleOrder, DynamicObjectCollection goodsEntryData, String giftDiscountType, String giftValueData, List<DynamicObject> lstSrcSaleOrderBill, DynamicObject initSaleOrder) {
        if (StringUtils.isEmpty((CharSequence)giftValueData)) {
            return false;
        }
        Map mapGiftValue = (Map)JSONObject.parse((String)giftValueData);
        if (mapGiftValue == null) {
            return false;
        }
        HashMap<Integer, Object> seqSyncValue = new HashMap<Integer, Object>(0);
        HashMap<Integer, Object> seqSyncRetTypeValue = new HashMap<Integer, Object>(0);
        HashMap<Integer, Object> seqPromoteSyncRetTypeValue = new HashMap(0);
        for (Map.Entry entry : mapGiftValue.entrySet()) {
            String seq = (String)entry.getKey();
            DynamicObject doGoodsEntry = goodsEntryData.stream().filter(x -> seq.equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"))).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            long entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"entrysrcbillid");
            DynamicObject srcSaleOrderBill = lstSrcSaleOrderBill.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == entrySrcBillId).findFirst().orElse(null);
            if (srcSaleOrderBill == null) continue;
            DynamicObjectCollection initGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"goodsentryentity");
            DynamicObjectCollection docSrcGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)srcSaleOrderBill, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)docSrcGoodsEntry) || CollectionUtils.isEmpty((Collection)initGoodsEntry)) continue;
            long srcBillEntryId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"srcbillentryid");
            DynamicObject srcGoodsEntry = docSrcGoodsEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == srcBillEntryId).findFirst().orElse(null);
            if (srcGoodsEntry == null) continue;
            BigDecimal giftValue = (BigDecimal)entry.getValue();
            BigDecimal discountValueDed = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountvalueded");
            BigDecimal discountCustCpst = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountcustcpst");
            BigDecimal adRetGiftDiscountAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)srcGoodsEntry, (String)"adretgiftdiscamount");
            srcGoodsEntry.set("adretgiftdiscamount", (Object)adRetGiftDiscountAmount.add(giftValue));
            if (StringUtils.equals((CharSequence)"1", (CharSequence)giftDiscountType)) {
                doGoodsEntry.set("discountvalueded", (Object)discountValueDed.add(giftValue));
            } else if (StringUtils.equals((CharSequence)"2", (CharSequence)giftDiscountType)) {
                doGoodsEntry.set("discountcustcpst", (Object)discountCustCpst.add(giftValue));
            }
            if (initGoodsEntry.stream().noneMatch(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == DynamicObjectUtils.getPkValue((DynamicObject)srcGoodsEntry))) {
                Map<Integer, Object> tmpSeqSyncValue = SaleOrderHelper.getWriteBillSeqValueMap(doGoodsEntry, giftValue);
                seqSyncValue.putAll(tmpSeqSyncValue);
            }
            Map<Integer, Object> tmpSeqSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, doGoodsEntry, "goodsendentity", "sendgoodsseq", giftDiscountType, "giftrettype", false, "0");
            seqSyncRetTypeValue.putAll(tmpSeqSyncRetTypeValue);
            seqPromoteSyncRetTypeValue = SaleOrderHelper.getWriteBillSeqReturnTypeMap(saleOrder, initSaleOrder, doGoodsEntry, "salesorderpromote", "sendgoodsseq", giftDiscountType, "promoterettype", true, "0");
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqPromoteSyncRetTypeValue, "salesorderpromote", "promoterettype", true, doGoodsEntry, true);
        }
        if (seqSyncValue.size() == 0 && seqSyncRetTypeValue.size() == 0 && seqPromoteSyncRetTypeValue.size() == 0) {
            return false;
        }
        SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncValue, "goodsentryentity", "adretgiftdiscamount", false, null, false);
        SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncRetTypeValue, "goodsendentity", "giftrettype", true, null, false);
        return true;
    }

    public static Map<Integer, Object> getWriteBillSeqReturnTypeMap(DynamicObject saleOrder, DynamicObject iniSaleOrder, DynamicObject doGoodsEntry, String sendEntryKey, String exeSeqKey, String discountType, String retTypeKey, boolean isPromote, String sendType) {
        HashMap<Integer, Object> seqSyncRetTypeValue = new HashMap<Integer, Object>(0);
        if (iniSaleOrder == null) {
            return seqSyncRetTypeValue;
        }
        String seq = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq");
        String returnType = StringUtils.equals((CharSequence)discountType, (CharSequence)"1") ? "V" : (StringUtils.equals((CharSequence)discountType, (CharSequence)"2") ? "C" : (StringUtils.equals((CharSequence)discountType, (CharSequence)"0") ? "R" : "T"));
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        DynamicObjectCollection iniDocGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSaleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry) || CollectionUtils.isEmpty((Collection)iniDocGoodsEntry)) {
            return seqSyncRetTypeValue;
        }
        if (!isPromote) {
            DynamicObjectCollection docSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)sendEntryKey);
            DynamicObjectCollection docIniSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSaleOrder, (String)sendEntryKey);
            if (CollectionUtils.isEmpty((Collection)docSendEntry) || CollectionUtils.isEmpty((Collection)docIniSendEntry)) {
                return seqSyncRetTypeValue;
            }
            List lstSendEntry = docSendEntry.stream().filter(x -> Arrays.asList(StringUtils.split((String)DynamicObjectUtils.getString((DynamicObject)x, (String)exeSeqKey), (String)",")).contains(seq)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(lstSendEntry)) {
                return seqSyncRetTypeValue;
            }
            for (DynamicObject sendEntry : lstSendEntry) {
                boolean bIsBook = false;
                int sendSeq = DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"seq");
                String retType = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)retTypeKey);
                if (StringUtils.equals((CharSequence)retType, (CharSequence)"R") || StringUtils.equals((CharSequence)retType, (CharSequence)"T")) continue;
                if (StringUtils.equals((CharSequence)sendEntryKey, (CharSequence)"goodsendentity")) {
                    BigDecimal toSaleQty;
                    boolean isBook;
                    DynamicObject iniGoodsEntry;
                    if (!StringUtils.equals((CharSequence)returnType, (CharSequence)"R") && docGoodsEntry.stream().anyMatch(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.MANUALNEW.getValue()) && sendSeq == DynamicObjectUtils.getInt((DynamicObject)x, (String)"promoteseq"))) continue;
                    if (StringUtils.equals((CharSequence)returnType, (CharSequence)"T")) {
                        iniGoodsEntry = iniDocGoodsEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"promoteseq") == sendSeq && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.MANUALNEW.getValue())).findFirst().orElse(null);
                        if (iniGoodsEntry == null) continue;
                        isBook = DynamicObjectUtils.getBoolean((DynamicObject)iniGoodsEntry, (String)"isbook");
                        toSaleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"tosalesqty");
                        if (!isBook || toSaleQty.compareTo(BigDecimal.ZERO) > 0) continue;
                    }
                    if (StringUtils.equals((CharSequence)returnType, (CharSequence)"R")) {
                        if (docGoodsEntry.stream().noneMatch(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.MANUALNEW.getValue()) && sendSeq == DynamicObjectUtils.getInt((DynamicObject)x, (String)"promoteseq")) || (iniGoodsEntry = (DynamicObject)iniDocGoodsEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"promoteseq") == sendSeq && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.MANUALNEW.getValue())).findFirst().orElse(null)) == null) continue;
                        isBook = DynamicObjectUtils.getBoolean((DynamicObject)iniGoodsEntry, (String)"isbook");
                        toSaleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"tosalesqty");
                        if (isBook && toSaleQty.compareTo(BigDecimal.ZERO) == 0) {
                            bIsBook = true;
                        }
                    }
                } else if (StringUtils.equals((CharSequence)returnType, (CharSequence)"T")) {
                    boolean isExecute;
                    DynamicObject doIniSendEntry = docIniSendEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == sendSeq).findFirst().orElse(null);
                    if (doIniSendEntry == null) continue;
                    String executeKey = "";
                    if (StringUtils.equals((CharSequence)sendEntryKey, (CharSequence)"sendintegralentity")) {
                        executeKey = "insisexecute";
                    } else if (StringUtils.equals((CharSequence)sendEntryKey, (CharSequence)"ticketsendentity")) {
                        executeKey = "tisexecute";
                    }
                    if (!StringUtils.isEmpty((CharSequence)executeKey) && (isExecute = DynamicObjectUtils.getBoolean((DynamicObject)doIniSendEntry, (String)executeKey))) continue;
                }
                String typeValue = bIsBook ? "T" : returnType;
                sendEntry.set(retTypeKey, (Object)typeValue);
                seqSyncRetTypeValue.put(sendSeq, typeValue);
            }
        } else {
            DynamicObjectCollection docSubSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)sendEntryKey);
            List<Object> lstSubSendEntry = new ArrayList(0);
            if (!CollectionUtils.isEmpty((Collection)docSubSendEntry)) {
                if (StringUtils.equals((CharSequence)"0", (CharSequence)sendType)) {
                    lstSubSendEntry = docSubSendEntry.stream().filter(x -> DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"promotegoodsid") != null).collect(Collectors.toList());
                } else if (StringUtils.equals((CharSequence)"1", (CharSequence)sendType)) {
                    lstSubSendEntry = docSubSendEntry.stream().filter(x -> DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"coupontype") != null).collect(Collectors.toList());
                } else if (StringUtils.equals((CharSequence)"2", (CharSequence)sendType)) {
                    lstSubSendEntry = docSubSendEntry.stream().filter(x -> DynamicObjectUtils.getDynamicObject((DynamicObject)x, (String)"pointtype") != null).collect(Collectors.toList());
                }
            }
            if (CollectionUtils.isEmpty(lstSubSendEntry)) {
                return seqSyncRetTypeValue;
            }
            for (DynamicObject sendEntry : lstSubSendEntry) {
                boolean bIsBook = false;
                int sendSeq = DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"seq") + CommonUtil.formatObjectToInt((Object)seq);
                int goodsSeq = DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"promotegoodsseq");
                String retType = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)retTypeKey);
                if (StringUtils.equals((CharSequence)retType, (CharSequence)"R") || StringUtils.equals((CharSequence)retType, (CharSequence)"T")) continue;
                if (StringUtils.equals((CharSequence)"0", (CharSequence)sendType)) {
                    if (!StringUtils.equals((CharSequence)returnType, (CharSequence)"R") && docGoodsEntry.stream().anyMatch(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue()) && goodsSeq == DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq"))) continue;
                    if (StringUtils.equals((CharSequence)returnType, (CharSequence)"T")) {
                        DynamicObject iniGoodsEntry = iniDocGoodsEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == goodsSeq && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue())).findFirst().orElse(null);
                        if (iniGoodsEntry == null) continue;
                        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)iniGoodsEntry, (String)"isbook");
                        BigDecimal toSaleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"tosalesqty");
                        if (!isBook || toSaleQty.compareTo(BigDecimal.ZERO) > 0) continue;
                    }
                    if (StringUtils.equals((CharSequence)returnType, (CharSequence)"R")) {
                        DynamicObject promoteGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue()) && goodsSeq == DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq")).findFirst().orElse(null);
                        if (promoteGoodsEntry == null) continue;
                        int iniSeq = DynamicObjectUtils.getInt((DynamicObject)promoteGoodsEntry, (String)"inisrcseq");
                        DynamicObject iniGoodsEntry = iniDocGoodsEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == iniSeq && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue())).findFirst().orElse(null);
                        if (iniGoodsEntry == null) continue;
                        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)iniGoodsEntry, (String)"isbook");
                        BigDecimal toSaleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"tosalesqty");
                        if (isBook && toSaleQty.compareTo(BigDecimal.ZERO) == 0) {
                            bIsBook = true;
                        }
                    }
                } else if (StringUtils.equals((CharSequence)returnType, (CharSequence)"T")) {
                    boolean isPromoteExecute;
                    DynamicObject iniPromote;
                    DynamicObjectCollection iniPromoteCollection;
                    int srcSeq = DynamicObjectUtils.getInt((DynamicObject)doGoodsEntry, (String)"inisrcseq");
                    long couponTypeId = DynamicObjectUtils.getPkValue((DynamicObject)sendEntry, (String)"coupontype");
                    long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)sendEntry, (String)"pointtype");
                    String iniExeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"iniexegoodsseq");
                    DynamicObject iniGoodsEntry = iniDocGoodsEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == srcSeq).findFirst().orElse(null);
                    if (iniGoodsEntry == null || CollectionUtils.isEmpty((Collection)(iniPromoteCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniGoodsEntry, (String)"salesorderpromote"))) || (iniPromote = (DynamicObject)iniPromoteCollection.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"coupontype") == couponTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"exegoodsseq"), (CharSequence)iniExeGoodsSeq)).findFirst().orElse(null)) == null || (isPromoteExecute = DynamicObjectUtils.getBoolean((DynamicObject)iniPromote, (String)"isgift"))) continue;
                }
                String typeValue = bIsBook ? "T" : returnType;
                sendEntry.set(retTypeKey, (Object)typeValue);
                seqSyncRetTypeValue.put(sendSeq, sendEntry);
            }
        }
        return seqSyncRetTypeValue;
    }

    private static Map<Integer, Object> getWriteBillSeqValueMap(DynamicObject doGoodsEntry, BigDecimal value) {
        HashMap<Integer, Object> seqSyncValue = new HashMap<Integer, Object>(0);
        Integer initSeq = DynamicObjectUtils.getInt((DynamicObject)doGoodsEntry, (String)"inisrcseq");
        seqSyncValue.put(initSeq, value);
        return seqSyncValue;
    }

    public static void saveNoWindowRefund(DynamicObject saleReturn) {
        long sourcebillId = saleReturn.getLong("sourcebillid");
        if (sourcebillId == 0L) {
            throw new KDBizException("\u65e0\u6e90\u5355ID\uff01");
        }
        DynamicObject[] paymentFlows = PaymentFlowHelper.getRedRefundFlow((Object)sourcebillId);
        if (paymentFlows == null || paymentFlows.length == 0) {
            throw new KDBizException("\u65e0\u6e90\u5355\u652f\u4ed8\u6d41\u6c34\uff01");
        }
        long payFlowId = 0L;
        BigDecimal refundAmount = saleReturn.getBigDecimal("receivableamount");
        ArrayList<String> lstTicketNo = new ArrayList<String>(paymentFlows.length);
        for (DynamicObject paymentFlow : paymentFlows) {
            if (refundAmount.compareTo(BigDecimal.ZERO) >= 0) break;
            payFlowId = Long.parseLong(paymentFlow.getPkValue().toString());
            DynamicObject payWay = paymentFlow.getDynamicObject("settlement");
            if (PaymentModeEnum.clearprice.getKey() == payWay.getLong("id")) continue;
            DynamicObject payWayType = paymentFlow.getDynamicObject("paywaytype");
            DynamicObject currency = paymentFlow.getDynamicObject("currency");
            BigDecimal flowSettleAmount = paymentFlow.getBigDecimal(SETTLEAMOUNT);
            BigDecimal flowRefundAmount = flowSettleAmount.subtract(paymentFlow.getBigDecimal("refundamount")).negate();
            if (flowRefundAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
            if (flowRefundAmount.compareTo(refundAmount) < 0) {
                flowRefundAmount = refundAmount;
            }
            String cardNo = paymentFlow.getString("cardno");
            lstTicketNo.add(cardNo);
            long creditAccountId = paymentFlow.getLong("creditaccountid");
            PaymentRecord paymentRecord = new PaymentRecord();
            paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleReturn).longValue());
            paymentRecord.setBillNo(saleReturn.getString("billno"));
            paymentRecord.setPayFlowId(payFlowId);
            paymentRecord.setSourcebillId(sourcebillId);
            paymentRecord.setPayCurrency(currency);
            paymentRecord.setPayWay(payWay);
            paymentRecord.setPayWayType(payWayType);
            paymentRecord.setAmount(flowRefundAmount);
            paymentRecord.setCardNo(cardNo);
            paymentRecord.setPaytime(TimeServiceHelper.now());
            paymentRecord.setCreditAccountId(creditAccountId);
            paymentRecord.setOrderNo(paymentFlow.getString("orderno"));
            SaleOrderHelper.refundPaymentRecord(saleReturn, paymentRecord);
            refundAmount = refundAmount.subtract(flowRefundAmount);
        }
        if (lstTicketNo.size() > 0) {
            logger.info("\u793c\u5238\u7ea2\u51b2\u9000begin");
            JSONObject jsonResult = SaleOrderHelper.ticketRefund(saleReturn, lstTicketNo);
            if (!jsonResult.getBoolean("success").booleanValue()) {
                logger.info("saveNoWindowRefund:" + jsonResult.getString("message"));
                return;
            }
            logger.info("\u793c\u5238\u7ea2\u51b2\u9000end");
        }
        saleReturn.set("salestatus", (Object)"S");
        OlstorePromotionHelper.cancelOlstorePromotion(saleReturn);
        SaveServiceHelper.update((DynamicObject)saleReturn);
    }

    private static void refundPaymentRecord(DynamicObject saleReturn, PaymentRecord paymentRecord) {
        String biztype = saleReturn.getString("biztype");
        DynamicObjectCollection finentity = saleReturn.getDynamicObjectCollection("finentity");
        if (!paymentRecord.getPayWay().getBoolean("iselectronicpay")) {
            logger.info("refundPaymentRecord\u975e\u7535\u5b50\u652f\u4ed8begin");
            DynamicObject newFinentity = finentity.addNew();
            SaleOrderHelper.updateSaleOrderAfterRefund(saleReturn, newFinentity, paymentRecord, null);
            logger.info("refundPaymentRecord\u975e\u7535\u5b50\u652f\u4ed8end");
        } else if (StringUtils.equals((CharSequence)biztype, (CharSequence)"R")) {
            logger.info("refundPaymentRecord\u7535\u5b50\u652f\u4ed8begin");
            logger.info("paymentRecord:" + paymentRecord);
            JSONObject payResult = SaleOrderHelper.callUnifyElecSettle(saleReturn, paymentRecord, "0");
            boolean isSuccess = payResult.getBoolean("success");
            logger.info("refundPaymentRecord\u7535\u5b50\u652f\u4ed8end");
            if (isSuccess && PaymentModeEnum.ccbpos.getKey() != DynamicObjectUtils.getPkValue((DynamicObject)paymentRecord.getPayWay())) {
                DynamicObject newFinentity = finentity.addNew();
                SaleOrderHelper.updateSaleOrderAfterRefund(saleReturn, newFinentity, paymentRecord, null);
            } else if (!isSuccess) {
                throw new KDBizException(String.format("%s \u9000\u6b3e\u5931\u8d25\u3002\u5916\u90e8\u8ba2\u5355\u53f7\uff1a%s", paymentRecord.getPayWay().getString("name"), paymentRecord.getOrderNo()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void setEachPaymentRecord(DynamicObject saleOrder, PaymentRecord paymentRecord, DynamicObject payRecord) {
        DynamicObject payWay = paymentRecord.getPayWay();
        paymentRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleOrder).longValue());
        paymentRecord.setBillNo(saleOrder.getString("billno"));
        DynamicObject payWayType = payRecord.getDynamicObject("paywaytype");
        if (payWayType == null) {
            payWayType = SaleOrderHelper.getPayWayType(payWay);
        }
        paymentRecord.setPayWayType(payWayType);
        paymentRecord.setPayCurrency(payRecord.getDynamicObject("paycurrency"));
        paymentRecord.setPaytime(TimeServiceHelper.now());
        paymentRecord.setAmount(payRecord.getBigDecimal("showamount"));
        long payWayId = CommonUtil.formatObejctToLong((Object)payWay.getPkValue());
        if (PaymentModeEnum.creditpay.getKey() == payWayId) {
            boolean isEnableCredit;
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
            saleOrder.set("debitopr", (Object)user);
            DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"salebranchid");
            if (branch == null || !(isEnableCredit = DynamicObjectUtils.getBoolean((DynamicObject)branch, (String)"isenablecredit"))) return;
            long creditAccountId = DynamicObjectUtils.getLong((DynamicObject)payRecord, (String)"creditaccountid");
            paymentRecord.setCreditAccountId(creditAccountId);
            JSONObject jsonResult = SaleOrderHelper.doCreditPay(saleOrder.getLong("id"), payRecord);
            if (!jsonResult.getBoolean("success").booleanValue()) throw new KDBizException(jsonResult.getString("message"));
            long creditActionFlowId = jsonResult.getLongValue("creditactionflowid");
            paymentRecord.setCreditFlowId(creditActionFlowId);
            return;
        } else if (PaymentModeEnum.cashpay.getKey() == payWayId) {
            DynamicObject user = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getCurrUserId(), (String)"bos_user");
            saleOrder.set("cashreceiver", (Object)user);
            return;
        } else if (PaymentModeEnum.clearprice.getKey() == payWayId) {
            BigDecimal wipeAmount = payRecord.getBigDecimal("showamount");
            saleOrder.set("ignoredecimalamt", (Object)wipeAmount);
            paymentRecord.setWipeAmount(wipeAmount);
            return;
        } else {
            long ticketId;
            if (PaymentModeEnum.coupon.getKey() != payWayId) return;
            paymentRecord.setCardNo(payRecord.getString("cardno"));
            long ticketTypeId = DynamicObjectUtil.getLong((DynamicObject)payRecord, (String)"paytickettypeid");
            paymentRecord.setTicketTypeId(ticketTypeId);
            if (ticketTypeId > 0L) {
                DynamicObject ticketType = BusinessDataServiceHelper.loadSingle((Object)payRecord.get("paytickettypeid"), (String)"ocdbd_ticketstype");
                paymentRecord.setTicketType(ticketType);
            }
            if ((ticketId = DynamicObjectUtil.getLong((DynamicObject)payRecord, (String)"payticketinfoid")) <= 0L) return;
            String entityId = saleOrder.getDataEntityType().getName();
            DynamicObject ticketInfo = BusinessDataServiceHelper.loadSingle((Object)payRecord.get("payticketinfoid"), (String)"ocdbd_ticketinfo");
            paymentRecord.setTicketInfo(ticketInfo);
            JSONObject jsonResult = SaleOrderHelper.ticketPay(saleOrder, new String[]{payRecord.getString("cardno")}, entityId);
            if (jsonResult.getBoolean("success").booleanValue()) return;
            throw new KDBizException(jsonResult.getString("message"));
        }
    }

    public static DynamicObject getPayWayType(DynamicObject payWay) {
        DynamicObjectCollection payWayTypeList = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)payWay, (String)"paywaytype");
        if (CollectionUtils.isEmpty((Collection)payWayTypeList)) {
            return null;
        }
        DynamicObject payWayTypeObj = null;
        long payWayId = payWay.getLong("id");
        if (PaymentModeEnum.getKey((String)"kingdeefinancepay") == payWayId) {
            return BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
        }
        payWayTypeObj = (DynamicObject)payWayTypeList.get(0);
        return DynamicObjectUtil.getDynamicObject((DynamicObject)payWayTypeObj, (String)"fbasedataid");
    }

    public static DynamicObject getPayWayType(DynamicObject payWay, String authCode) {
        logger.info("\u6388\u6743\u7801\uff1a" + authCode);
        DynamicObjectCollection payWayTypeList = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)payWay, (String)"paywaytype");
        if (CollectionUtils.isEmpty((Collection)payWayTypeList)) {
            return null;
        }
        DynamicObject payWayTypeObj = null;
        if (payWayTypeList.size() > 1) {
            String orgCode = FinPayTradeHelper.parsePaymentCode((String)authCode);
            logger.info("\u6536\u6b3e\u65b9\u5f0f\u4ee3\u7801\uff1a" + orgCode);
            switch (orgCode) {
                case "WEIXIN": {
                    payWayTypeObj = BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
                    break;
                }
                case "ALIPAY": {
                    payWayTypeObj = BusinessDataServiceHelper.loadSingle((Object)960797923925358592L, (String)"ocdbd_paywaytype");
                    break;
                }
                case "UNIONPAY": {
                    payWayTypeObj = BusinessDataServiceHelper.loadSingle((Object)1117388809705865216L, (String)"ocdbd_paywaytype");
                    break;
                }
                case "DCEP": {
                    payWayTypeObj = BusinessDataServiceHelper.loadSingle((Object)960800111724760064L, (String)"ocdbd_paywaytype");
                    break;
                }
                default: {
                    payWayTypeObj = (DynamicObject)payWayTypeList.get(0);
                    return DynamicObjectUtil.getDynamicObject((DynamicObject)payWayTypeObj, (String)"fbasedataid");
                }
            }
            return payWayTypeObj;
        }
        payWayTypeObj = (DynamicObject)payWayTypeList.get(0);
        logger.info("\u6536\u6b3e\u65b9\u5f0f\u7c7b\u578b\u6570\u91cf\uff1a" + payWayTypeList.size());
        return DynamicObjectUtil.getDynamicObject((DynamicObject)payWayTypeObj, (String)"fbasedataid");
    }

    private static void wipeAmountShare(BigDecimal wipeAmount, DynamicObject saleOrder) {
        if (wipeAmount == null || wipeAmount.compareTo(BigDecimal.ZERO) == 0) {
            return;
        }
        DynamicObjectCollection entryData = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (entryData == null || entryData.size() <= 0) {
            return;
        }
        DynamicObject currency = DynamicObjectUtil.getDynamicObject((DynamicObject)saleOrder, (String)"currencyid");
        if (currency == null) {
            return;
        }
        List entryRows = entryData.stream().filter(p -> !DynamicObjectUtil.getBoolean((DynamicObject)p, (String)"isbook")).collect(Collectors.toList());
        if (entryRows.size() == 0) {
            return;
        }
        int row = 0;
        BigDecimal sumRowIgnoreAmt = BigDecimal.ZERO;
        BigDecimal sumReceAmount = entryData.stream().filter(p -> !DynamicObjectUtil.getBoolean((DynamicObject)p, (String)"isbook")).map(q -> DynamicObjectUtil.getBigDecimal((DynamicObject)q, (String)"balamount")).reduce(BigDecimal.ZERO, BigDecimal::add);
        for (DynamicObject entryRow : entryRows) {
            BigDecimal realAmount;
            int amountPrecision;
            BigDecimal qty = DynamicObjectUtil.getBigDecimal((DynamicObject)entryRow, (String)"saleqty");
            BigDecimal rowBalAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)entryRow, (String)"balamount");
            int pricePrecision = DynamicObjectUtil.getInt((DynamicObject)currency, (String)"priceprecision") > 0 ? DynamicObjectUtil.getInt((DynamicObject)currency, (String)"priceprecision") : 2;
            int n = amountPrecision = DynamicObjectUtil.getInt((DynamicObject)currency, (String)"amtprecision") > 0 ? DynamicObjectUtil.getInt((DynamicObject)currency, (String)"amtprecision") : 2;
            if (++row < entryData.size()) {
                BigDecimal rowAmtRate = BigDecimal.ZERO;
                if (sumReceAmount.compareTo(BigDecimal.ZERO) > 0) {
                    rowAmtRate = rowBalAmount.divide(sumReceAmount, 10, 6);
                }
                BigDecimal rowIgnoreAmt = wipeAmount.multiply(rowAmtRate);
                sumRowIgnoreAmt = sumRowIgnoreAmt.add(rowIgnoreAmt);
                realAmount = rowBalAmount.subtract(rowIgnoreAmt);
                entryRow.set("realamount", (Object)realAmount.setScale(amountPrecision, 6));
            } else {
                realAmount = rowBalAmount.subtract(wipeAmount.subtract(sumRowIgnoreAmt));
                entryRow.set("realamount", (Object)realAmount.setScale(amountPrecision, 6));
            }
            BigDecimal realPrice = BigDecimal.ZERO;
            if (qty.compareTo(BigDecimal.ZERO) > 0) {
                realPrice = realAmount.divide(qty, pricePrecision, 6);
            }
            entryRow.set("realprice", (Object)realPrice);
        }
    }

    public static void updateSaleOrderAfterPayment(DynamicObject saleOrder, DynamicObject newFinEntity, PaymentRecord paymentRecord, Map<String, Object> data) {
        paymentRecord.setSaleorg(DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"bizorgid"));
        paymentRecord.setBranch(DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"salebranchid"));
        if (paymentRecord.getPayFlowId() != 101L) {
            PaymentFlowHelper.saveAllPaymentFlow((PaymentRecord)paymentRecord, (String)"1", data);
        }
        newFinEntity.set("setllementid", (Object)paymentRecord.getPayWay());
        newFinEntity.set("paywaytypeid", (Object)paymentRecord.getPayWayType());
        long payWayId = DynamicObjectUtils.getPkValue((DynamicObject)paymentRecord.getPayWay());
        String billName = saleOrder.getDataEntityType().getName();
        if (StringUtils.equals((CharSequence)billName, (CharSequence)"ocpos_saleorder") || StringUtils.equals((CharSequence)billName, (CharSequence)"ocpos_salechange") || StringUtils.equals((CharSequence)billName, (CharSequence)"ocpos_saleorder_final")) {
            SaleOrderHelper.handleIsSalesIncome(newFinEntity, paymentRecord, true);
        }
        newFinEntity.set("settlecurrid", (Object)paymentRecord.getPayCurrency());
        DynamicObject loCurrency = saleOrder.getDynamicObject("locurrencyid");
        long taxTableId = DynamicObjectUtil.getPkValue((DynamicObject)saleOrder, (String)"exratetable");
        BigDecimal rate = CurrencyHelper.getExChangeRate(paymentRecord.getPayCurrency().getLong("Id"), loCurrency.getLong("Id"), taxTableId, new Date());
        if (rate == null || rate.compareTo(BigDecimal.ZERO) == 0) {
            rate = BigDecimal.ONE;
        }
        newFinEntity.set("exchangerate", (Object)rate);
        newFinEntity.set(SETTLEAMOUNT, (Object)paymentRecord.getAmount());
        long creditAccountId = paymentRecord.getCreditAccountId();
        if (PaymentModeEnum.creditpay.getKey() == payWayId) {
            DynamicObject doVipInfo;
            newFinEntity.set("creditaccountid", (Object)creditAccountId);
            newFinEntity.set("creditflowid", (Object)paymentRecord.getCreditFlowId());
            newFinEntity.set("notsettleamount", (Object)paymentRecord.getAmount());
            if (creditAccountId > 0L && !ObjectUtils.isEmpty((Object)(doVipInfo = DynamicObjectUtils.getDynamicObject((DynamicObject)saleOrder, (String)"member")))) {
                DynamicObject doCreditAccount = BusinessDataServiceHelper.loadSingle((Object)creditAccountId, (String)"ocdbd_credit_accountinfo");
                DynamicObject vipType = DynamicObjectUtils.getDynamicObject((DynamicObject)doVipInfo, (String)"viptypeid");
                int days = StringUtils.equals((CharSequence)VipTypeEnum.INDIVIDUAL.getNumber(), (CharSequence)DynamicObjectUtils.getString((DynamicObject)vipType, (String)"number")) ? DynamicObjectUtils.getInt((DynamicObject)doCreditAccount, (String)"pclimitdays") : (StringUtils.equals((CharSequence)VipTypeEnum.ENTERPRISE.getNumber(), (CharSequence)DynamicObjectUtils.getString((DynamicObject)vipType, (String)"number")) ? DynamicObjectUtils.getInt((DynamicObject)doCreditAccount, (String)"eclimitdays") : DynamicObjectUtils.getInt((DynamicObject)doCreditAccount, (String)"pclimitdays"));
                if (days > 0) {
                    Date today = TimeServiceHelper.today();
                    newFinEntity.set("receivabledate", (Object)DateUtil.dayAdd((Date)DateUtil.formatDate((Date)today), (int)days));
                }
            }
        }
        newFinEntity.set("paytime", (Object)paymentRecord.getPaytime());
        newFinEntity.set("integralconsum", (Object)paymentRecord.getRewardPoint());
        newFinEntity.set("cardno", (Object)paymentRecord.getCardNo());
        newFinEntity.set("tickettypeid", (Object)paymentRecord.getTicketType());
        newFinEntity.set("ticketinfoid", (Object)paymentRecord.getTicketInfo());
        newFinEntity.set("cardtypeid", (Object)paymentRecord.getBankType());
        newFinEntity.set("tradereference", (Object)paymentRecord.getBankExchangeNo());
        newFinEntity.set("bankaccountid", (Object)paymentRecord.getBankNo());
        newFinEntity.set("orderno", (Object)paymentRecord.getOrderNo());
        newFinEntity.set("stmamount", (Object)paymentRecord.getAmount());
        newFinEntity.set("settlementrate", (Object)rate);
        DynamicObject currency = saleOrder.getDynamicObject("currencyid");
        BigDecimal finRate = saleOrder.getBigDecimal("financeexchangerate");
        if (finRate == null || finRate.compareTo(BigDecimal.ZERO) == 0) {
            finRate = BigDecimal.ONE;
        }
        BigDecimal actualPayAmount = paymentRecord.getAmount().multiply(rate).divide(finRate, currency.getInt("amtprecision"), 6);
        if (PaymentModeEnum.CustomerCompensation.getKey() == payWayId) {
            actualPayAmount = BigDecimal.ZERO;
        }
        BigDecimal totalPayAmount = saleOrder.getBigDecimal("totalrealamount").add(actualPayAmount);
        saleOrder.set("stillneedtopay", (Object)saleOrder.getBigDecimal("stillneedtopay").subtract(actualPayAmount));
        saleOrder.set("totalrealamount", (Object)totalPayAmount);
        if (paymentRecord.getBankStageActId() > 0L) {
            newFinEntity.set("bankstageactid", (Object)paymentRecord.getBankStageActId());
            newFinEntity.set("stagenums", (Object)paymentRecord.getStageNums());
            newFinEntity.set("stagefee", (Object)paymentRecord.getStageFee());
        }
        saleOrder.set("saleendtime", (Object)TimeServiceHelper.now());
    }

    public static void updateSaleOrderAfterRefund(DynamicObject saleReturn, DynamicObject newFinentity, PaymentRecord paymentRecord, Map<String, Object> data) {
        paymentRecord.setSaleorg(DynamicObjectUtils.getDynamicObject((DynamicObject)saleReturn, (String)"bizorgid"));
        paymentRecord.setBranch(DynamicObjectUtils.getDynamicObject((DynamicObject)saleReturn, (String)"salebranchid"));
        PaymentFlowHelper.saveAllPaymentFlow((PaymentRecord)paymentRecord, (String)"0", data);
        newFinentity.set("setllementid", (Object)paymentRecord.getPayWay());
        SaleOrderHelper.handleIsSalesIncome(newFinentity, paymentRecord, false);
        newFinentity.set("paywaytypeid", (Object)paymentRecord.getPayWayType());
        newFinentity.set("settlecurrid", (Object)paymentRecord.getPayCurrency());
        newFinentity.set("exchangerate", (Object)1);
        newFinentity.set(SETTLEAMOUNT, (Object)paymentRecord.getAmount());
        newFinentity.set("paytime", (Object)paymentRecord.getPaytime());
        newFinentity.set("integralconsum", (Object)paymentRecord.getRewardPoint());
        newFinentity.set("cardno", (Object)paymentRecord.getCardNo());
        newFinentity.set("tickettypeid", (Object)paymentRecord.getTicketType());
        newFinentity.set("ticketinfoid", (Object)paymentRecord.getTicketInfo());
        newFinentity.set("cardtypeid", (Object)paymentRecord.getBankType());
        newFinentity.set("tradereference", (Object)paymentRecord.getBankExchangeNo());
        newFinentity.set("bankaccountid", (Object)paymentRecord.getBankNo());
        newFinentity.set("orderno", (Object)paymentRecord.getOrderNo());
        newFinentity.set("stmamount", (Object)paymentRecord.getAmount());
        newFinentity.set("settlementrate", (Object)1);
        BigDecimal actualPayAmount = paymentRecord.getAmount();
        long payWayId = DynamicObjectUtils.getPkValue((DynamicObject)paymentRecord.getPayWay());
        if (PaymentModeEnum.CustomerCompensation.getKey() == payWayId) {
            actualPayAmount = BigDecimal.ZERO;
        }
        BigDecimal totalPayAmount = saleReturn.getBigDecimal("totalrealamount").add(actualPayAmount);
        saleReturn.set("totalrealamount", (Object)totalPayAmount);
        saleReturn.set("stillneedtopay", (Object)saleReturn.getBigDecimal("receivableamount").subtract(totalPayAmount));
        saleReturn.set("saleendtime", (Object)TimeServiceHelper.now());
    }

    private static void handleIsSalesIncome(DynamicObject newFinEntity, PaymentRecord paymentRecord, boolean isPayment) {
        long payWayId = DynamicObjectUtils.getPkValue((DynamicObject)paymentRecord.getPayWay());
        if (PaymentModeEnum.coupon.getKey() == payWayId) {
            if (paymentRecord.getTicketType() != null) {
                newFinEntity.set("isinsalesincome", (Object)DynamicObjectUtils.getBoolean((DynamicObject)paymentRecord.getTicketType(), (String)"isinsalesincome"));
                DynamicObject doTicketType = paymentRecord.getTicketType();
                if (doTicketType != null && isPayment) {
                    BigDecimal amount = paymentRecord.getAmount();
                    BigDecimal ticketValue = DynamicObjectUtils.getBigDecimal((DynamicObject)doTicketType, (String)"ticketvalue");
                    newFinEntity.set("noreturnamt", (Object)ticketValue.subtract(amount));
                }
            }
        } else if (paymentRecord.getPayWay() != null) {
            newFinEntity.set("isinsalesincome", (Object)DynamicObjectUtils.getBoolean((DynamicObject)paymentRecord.getPayWay(), (String)"isinsalesincome"));
        }
    }

    public static JSONObject callUnifyElecSettle(DynamicObject saleReturn, PaymentRecord paymentRecord, String saleoption) {
        JSONObject result = new JSONObject();
        result.put("success", (Object)true);
        String thirdNo = "";
        String transNo = "";
        JSONObject payResponse = null;
        BigDecimal settleAmount = paymentRecord.getAmount();
        DynamicObject payWay = paymentRecord.getPayWay();
        String outTradeNo = paymentRecord.getOrderNo();
        Date payTime = paymentRecord.getPaytime();
        long payFlowId = paymentRecord.getPayFlowId();
        long payWayId = payWay.getLong("id");
        JSONObject resultMsg = new JSONObject();
        resultMsg = saleoption.equalsIgnoreCase("1") ? JSONObject.parseObject((String)SaleOrderHelper.callElecPay(saleReturn, payWayId, settleAmount, outTradeNo)) : JSONObject.parseObject((String)SaleOrderHelper.callElecRefund(saleReturn, payWayId, settleAmount, outTradeNo, payTime, payFlowId));
        String payStatus = resultMsg.getString(PAYSTATUS);
        if (StringUtils.equalsIgnoreCase((CharSequence)payStatus, (CharSequence)"A")) {
            paymentRecord.setPayStatus(payStatus);
            outTradeNo = resultMsg.getString(OUTTRADENO);
            thirdNo = resultMsg.getString(THIRDNO);
            transNo = resultMsg.getString(TRANSNO);
            payResponse = resultMsg.getJSONObject(PAYRESPONSE);
            paymentRecord.setOrderNo(outTradeNo);
            paymentRecord.setPaytime(resultMsg.getDate(PAYTIME));
            String tradeNo = resultMsg.getString(TRADENO);
            paymentRecord.setBankExchangeNo(tradeNo);
            result.put(OUTTRADENO, (Object)outTradeNo);
            result.put(THIRDNO, (Object)thirdNo);
            result.put(TRANSNO, (Object)transNo);
            result.put(PAYRESPONSE, (Object)payResponse);
            return result;
        }
        if (StringUtils.equalsIgnoreCase((CharSequence)payStatus, (CharSequence)"S")) {
            return result;
        }
        PaymentRecord failureRecord = new PaymentRecord();
        failureRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleReturn).longValue());
        failureRecord.setBillNo(saleReturn.getString("billno"));
        failureRecord.setPayStatus(payStatus);
        failureRecord.setOrderNo(outTradeNo);
        failureRecord.setPayWay(payWay);
        failureRecord.setAmount(settleAmount);
        failureRecord.setPaytime(TimeServiceHelper.now());
        failureRecord.setPayCurrency(paymentRecord.getPayCurrency());
        String errorMsg = resultMsg.getString(ERRORMSG);
        failureRecord.setErrorMsg(errorMsg);
        logger.info("callUnifyElecSettle_failureRecord" + failureRecord);
        PaymentFlowHelper.saveAllPaymentFlow((PaymentRecord)failureRecord, (String)saleoption, null);
        result.put("success", (Object)false);
        result.put(ERRORMSG, (Object)errorMsg);
        return result;
    }

    private static String callElecPay(DynamicObject saleOrder, long payWayId, BigDecimal totalAmount, String authCode) {
        JSONObject tradeQuery;
        JSONObject payResponse;
        TradeStatus KDStatus;
        JSONObject payInfo = new JSONObject();
        String tradeNo = "";
        String thirdNo = "";
        String transNo = "";
        String outTradeNo = "";
        Date payTime = TimeServiceHelper.now();
        JSONObject response = null;
        String payStatus = "FAIL";
        BigDecimal refundAmount = BigDecimal.ZERO;
        String billNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
        long operatorId = 0L;
        DynamicObject creatorInfo = saleOrder.getDynamicObject("creator");
        if (creatorInfo != null) {
            operatorId = creatorInfo.getLong("Id");
        }
        Date operaTime = TimeServiceHelper.now();
        long storeId = 0L;
        DynamicObject saleBranchInfo = saleOrder.getDynamicObject("salebranchid");
        if (saleBranchInfo != null) {
            storeId = saleBranchInfo.getLong("Id");
        }
        ArrayList<BarCodePayGoodsDetail> goodsDetails = new ArrayList<BarCodePayGoodsDetail>();
        String goodsNumber = "";
        DynamicObjectCollection goodsEntryList = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (goodsEntryList != null && goodsEntryList.size() > 0) {
            String bizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype");
            for (DynamicObject goodsEntry : goodsEntryList) {
                DynamicObject goods;
                String saleOption;
                if (StringUtils.equals((CharSequence)bizType, (CharSequence)"H") && StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"saleoption")), (CharSequence)"0") || (goods = goodsEntry.getDynamicObject("goodsid")) == null) continue;
                if (StringUtils.isEmpty((CharSequence)goodsNumber)) {
                    goodsNumber = goods.getString("number");
                }
                BarCodePayGoodsDetail goodsDetail = new BarCodePayGoodsDetail();
                goodsDetail.setGoodsId(goods.getString("number"));
                goodsDetail.setGoodsName(goods.getString("name"));
                BigDecimal saleQty = goodsEntry.getBigDecimal("saleqty");
                int saleIntQty = saleQty.intValue();
                if (saleIntQty == 0) {
                    saleIntQty = 1;
                }
                goodsDetail.setQuantity(Integer.valueOf(saleIntQty));
                goodsDetail.setPrice(goodsEntry.getBigDecimal("realprice"));
                goodsDetails.add(goodsDetail);
            }
        }
        if (CollectionUtils.isEmpty(goodsDetails)) {
            BarCodePayGoodsDetail goodsDetail = new BarCodePayGoodsDetail();
            goodsDetail.setGoodsId("sxsp001");
            goodsDetail.setGoodsName("sxsp001");
            goodsDetail.setQuantity(Integer.valueOf(1));
            goodsDetail.setPrice(totalAmount);
            goodsDetails.add(goodsDetail);
        }
        if (StringUtils.isEmpty((CharSequence)goodsNumber)) {
            goodsNumber = "sxsp001";
        }
        CheckOutCounterInfo payDate = new CheckOutCounterInfo();
        payDate.setBillNo(billNo);
        payDate.setOperatorId(operatorId);
        payDate.setOperaTime(operaTime);
        payDate.setStoreId(storeId);
        payDate.setSubject(goodsNumber);
        if (PaymentModeEnum.getKey((String)"wechatpayment") == payWayId) {
            payDate.setBody(goodsNumber);
            payDate.setSpbillCreateIp("127.0.0.1");
        }
        StringBuilder errorMessage = new StringBuilder();
        if (PaymentModeEnum.getKey((String)"kingdeefinancepay") == payWayId) {
            PayResult kingDeeQrCodePay = FinPayTradeHelper.kingDeeQrCodePay((CheckOutCounterInfo)payDate, goodsDetails, (String)authCode, (BigDecimal)totalAmount);
            logger.info(String.format("\u96f6\u552e\u5355\u53f7%s\u91d1\u8776\u91d1\u878d\u6761\u7801\u652f\u4ed8kingDeeQrCodePay:%s", billNo, JSON.toJSONString((Object)kingDeeQrCodePay)));
            KDStatus = kingDeeQrCodePay.getTradeStatus();
            if (TradeStatus.SUCCESS.equals((Object)KDStatus)) {
                payResponse = kingDeeQrCodePay.getPayResponse();
                tradeNo = payResponse.getString("orgTransNo");
                outTradeNo = payResponse.getString("bizNo");
                if (ResponseEnum.TRADE_PROCESSING.getCode().equals(payResponse.getString("bizCode"))) {
                    tradeQuery = FinPayTradeHelper.loopQueryResult((String)outTradeNo, (String)"1", (long)payDate.getStoreId());
                    logger.info(String.format("\u96f6\u552e\u5355\u53f7%s\u91d1\u8776\u91d1\u878d\u6761\u7801\u652f\u4ed8\u67e5\u8be2tradeQuery:%s", billNo, JSON.toJSONString((Object)tradeQuery)));
                    if (ResponseEnum.TRADE_SUCCESS.getCode().equals(tradeQuery.getString("bizCode"))) {
                        tradeNo = tradeQuery.getString("orgTransNo");
                        payStatus = "A";
                        refundAmount = new BigDecimal(payResponse.getString("amount"));
                    } else {
                        errorMessage.append(tradeQuery.getString("bizMsg"));
                        payStatus = "B";
                    }
                } else if (ResponseEnum.TRADE_SUCCESS.getCode().equals(payResponse.getString("bizCode"))) {
                    payStatus = "A";
                    refundAmount = new BigDecimal(payResponse.getString("amount"));
                } else {
                    errorMessage.append(payResponse.getString("bizMsg"));
                    payStatus = "B";
                }
            } else if (TradeStatus.FAILED.equals((Object)KDStatus)) {
                errorMessage.append(":").append(kingDeeQrCodePay.getErrorMessage());
                payStatus = "B";
            } else {
                errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
                payStatus = "D";
            }
        } else if (PaymentModeEnum.getKey((String)"umsscan") == payWayId) {
            PayResult umsQrCodePay = FinPayTradeHelper.umsQrCodePay((CheckOutCounterInfo)payDate, goodsDetails, (String)authCode, (BigDecimal)totalAmount);
            logger.info("\u94f6\u8054\u626b\u7801\u6761\u7801\u652f\u4ed8umsQrCodePay :" + JSON.toJSONString((Object)umsQrCodePay));
            KDStatus = umsQrCodePay.getTradeStatus();
            if (TradeStatus.SUCCESS.equals((Object)KDStatus)) {
                payResponse = umsQrCodePay.getPayResponse();
                tradeNo = payResponse.getString("orgTransNo");
                thirdNo = payResponse.getString(THIRDNO);
                transNo = payResponse.getString(TRANSNO);
                response = payResponse;
                outTradeNo = payResponse.getString("bizNo");
                if (ResponseEnum.TRADE_PROCESSING.getCode().equals(payResponse.getString("bizCode"))) {
                    tradeQuery = FinPayTradeHelper.umsLoopQueryResult((String)outTradeNo, (String)"1", (long)payDate.getStoreId());
                    logger.info(String.format("\u96f6\u552e\u5355\u53f7%s\u94f6\u8054\u626b\u7801\u6761\u7801\u652f\u4ed8\u67e5\u8be2tradeQuery:%s", billNo, JSON.toJSONString((Object)tradeQuery)));
                    if (ResponseEnum.TRADE_SUCCESS.getCode().equals(tradeQuery.getString("bizCode"))) {
                        tradeNo = tradeQuery.getString("orgTransNo");
                        thirdNo = tradeQuery.getString(THIRDNO);
                        transNo = tradeQuery.getString(TRANSNO);
                        payTime = tradeQuery.getDate("arrivalTime");
                        payStatus = "A";
                        refundAmount = new BigDecimal(payResponse.getString("amount"));
                    } else {
                        errorMessage.append(tradeQuery.getString("bizMsg"));
                        payStatus = "B";
                    }
                } else if (ResponseEnum.TRADE_SUCCESS.getCode().equals(payResponse.getString("bizCode"))) {
                    payStatus = "A";
                    payTime = payResponse.getDate("arrivalTime");
                    refundAmount = new BigDecimal(payResponse.getString("amount"));
                } else {
                    errorMessage.append(payResponse.getString("bizMsg"));
                    payStatus = "B";
                }
            } else if (TradeStatus.FAILED.equals((Object)KDStatus)) {
                errorMessage.append(":").append(umsQrCodePay.getErrorMessage());
                payStatus = "B";
            } else {
                errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
                payStatus = "D";
            }
        } else {
            PayResult payResult = PayTradeHelper.getPayData((CheckOutCounterInfo)payDate, (long)payWayId, (String)authCode, (BigDecimal)totalAmount);
            TradeStatus tradestatus = payResult.getTradeStatus();
            if (TradeStatus.SUCCESS.equals((Object)tradestatus)) {
                outTradeNo = payResult.getPayResponse().getString("out_trade_no");
                tradeNo = payResult.getPayResponse().getString("trade_no");
                payStatus = "A";
            } else if (TradeStatus.FAILED.equals((Object)tradestatus)) {
                errorMessage.append(":\u652f\u4ed8\u5931\u8d25");
                payStatus = "B";
            } else if (TradeStatus.UNKNOWN.equals((Object)tradestatus)) {
                errorMessage.append(":\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5");
                payStatus = "C";
            } else {
                errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
                payStatus = "D";
            }
        }
        payInfo.put(PAYSTATUS, (Object)payStatus);
        payInfo.put(PAYTIME, (Object)payTime);
        payInfo.put(TRADENO, (Object)tradeNo);
        payInfo.put(THIRDNO, (Object)thirdNo);
        payInfo.put(TRANSNO, (Object)transNo);
        payInfo.put(PAYRESPONSE, (Object)response);
        payInfo.put(OUTTRADENO, (Object)outTradeNo);
        payInfo.put(REFUNDAMOUNT, (Object)refundAmount);
        payInfo.put(ERRORMSG, (Object)errorMessage.toString());
        logger.info(String.format("\u96f6\u552e\u5355\u53f7%s\u91d1\u8776\u91d1\u878d\u6761\u7801\u652f\u4ed8payInfo:%s", billNo, JSON.toJSONString((Object)payInfo)));
        return SerializationUtils.toJsonString((Object)payInfo);
    }

    private static String callElecRefund(DynamicObject saleOrder, long payWayId, BigDecimal stmamount, String outTradeNo, Date payTime, long payFlowId) {
        String result = "";
        String billNo = saleOrder.getString("billno");
        long operatorId = 0L;
        DynamicObject creatorInfo = saleOrder.getDynamicObject("creator");
        if (creatorInfo != null) {
            operatorId = creatorInfo.getLong("Id");
        }
        Date operaTime = TimeServiceHelper.now();
        long storeId = 0L;
        DynamicObject saleBranchInfo = saleOrder.getDynamicObject("salebranchid");
        if (saleBranchInfo != null) {
            storeId = saleBranchInfo.getLong("Id");
        }
        RefundInfo refundData = new RefundInfo();
        refundData.setBillNo(billNo);
        refundData.setOperatorId(operatorId);
        refundData.setOperaTime(operaTime);
        refundData.setStoreId(storeId);
        JSONObject refundResult = null;
        logger.info("callElecRefund_refundData:" + JSON.toJSONString((Object)refundData));
        logger.info("callElecRefund_stmamount:" + stmamount);
        logger.info("callElecRefund_outTradeNo:" + outTradeNo);
        logger.info("callElecRefund_payWayId:" + payWayId);
        if (PaymentModeEnum.getKey((String)"alipay") == payWayId) {
            refundResult = SaleOrderHelper.callAliRefund(stmamount, outTradeNo, refundData);
        } else if (PaymentModeEnum.getKey((String)"wechatpayment") == payWayId) {
            refundResult = SaleOrderHelper.callWxRefund(stmamount, outTradeNo, refundData);
        } else if (PaymentModeEnum.getKey((String)"kingdeefinancepay") == payWayId) {
            refundResult = SaleOrderHelper.callKingDeeFinRefund(stmamount, outTradeNo, refundData);
        } else if (PaymentModeEnum.getKey((String)"umsscan") == payWayId) {
            boolean isSecondDay = DateUtil.comparePayDate((String)DateUtil.getDateFormat((Date)payTime));
            boolean isEqualPayAmount = CommonUtils.checkReturnEqualPayAmount((BigDecimal)stmamount, (String)String.valueOf(payFlowId));
            if (!isSecondDay && isEqualPayAmount) {
                refundResult = SaleOrderHelper.callUmsFinCancel(stmamount, outTradeNo, refundData);
            } else {
                ArrayList<JSONObject> goodsIdLst = new ArrayList<JSONObject>();
                DynamicObjectCollection goodsEntryList = saleOrder.getDynamicObjectCollection("goodsentryentity");
                if (goodsEntryList != null && goodsEntryList.size() > 0) {
                    String bizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype");
                    for (DynamicObject goodsEntry : goodsEntryList) {
                        String saleOption;
                        if (StringUtils.equals((CharSequence)bizType, (CharSequence)"H") && StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"saleoption")), (CharSequence)"1")) continue;
                        JSONObject goodsIdJson = new JSONObject();
                        DynamicObject goods = goodsEntry.getDynamicObject("goodsid");
                        if (goods == null) continue;
                        goodsIdJson.put("goodsId", (Object)goods.getString("number"));
                        goodsIdLst.add(goodsIdJson);
                    }
                }
                if (CollectionUtils.isEmpty(goodsIdLst)) {
                    JSONObject goodsIdJson = new JSONObject();
                    goodsIdJson.put("goodsId", (Object)"sxsp001");
                    goodsIdLst.add(goodsIdJson);
                }
                refundResult = SaleOrderHelper.callUmsFinRefund(stmamount, goodsIdLst, outTradeNo, refundData);
            }
        } else {
            refundResult = new JSONObject();
            refundResult.put(PAYSTATUS, (Object)"A");
        }
        result = SerializationUtils.toJsonString((Object)refundResult);
        logger.info("callElecRefund_result:" + result);
        return result;
    }

    protected static JSONObject callKingDeeFinRefund(BigDecimal stmamount, String outTradeNo, RefundInfo refundData) {
        JSONObject refundInfo = new JSONObject();
        String tradeNo = "";
        String payStatus = "FAIL";
        BigDecimal refundAmount = BigDecimal.ZERO;
        Date refundTime = TimeServiceHelper.now();
        refundData.setOutTradeNo(outTradeNo);
        logger.info("\u91d1\u8776\u91d1\u878d\u9000\u6b3estmamount :" + stmamount.toString() + "\u91d1\u8776\u91d1\u878d\u9000\u6b3eoutTradeNo :" + outTradeNo);
        logger.info("\u91d1\u8776\u91d1\u878d\u9000\u6b3erefundData :" + JSON.toJSONString((Object)refundData));
        RefundResult refundResult = FinPayTradeHelper.kingDeeRefund((RefundInfo)refundData, (BigDecimal)stmamount.abs());
        logger.info("\u91d1\u8776\u91d1\u878d\u9000\u6b3erefundResult :" + JSON.toJSONString((Object)refundResult));
        TradeStatus tradestatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = new StringBuilder();
        if (TradeStatus.SUCCESS.equals((Object)tradestatus)) {
            JSONObject refundResponse = refundResult.getRefundResponse();
            logger.info("\u91d1\u8776\u91d1\u878d\u9000\u6b3erefundResponse :" + JSON.toJSONString((Object)refundResponse));
            String refundNo = refundResponse.getString("bizNo");
            tradeNo = refundResponse.getString("oriPayOrgTransNo");
            if (StringUtils.isEmpty((CharSequence)tradeNo)) {
                tradeNo = refundResponse.getString(THIRDNO);
            }
            if (ResponseEnum.TRADE_PROCESSING.getCode().equals(refundResponse.getString("bizCode"))) {
                JSONObject tradeQuery = FinPayTradeHelper.loopQueryResult((String)refundNo, (String)"12", (long)refundData.getStoreId());
                logger.info("\u91d1\u8776\u91d1\u878d\u9000\u6b3e\u67e5\u8be2tradeQuery :" + JSON.toJSONString((Object)tradeQuery) + tradeNo);
                if (ResponseEnum.TRADE_SUCCESS.getCode().equals(tradeQuery.getString("bizCode"))) {
                    if (StringUtils.isEmpty((CharSequence)tradeNo)) {
                        tradeNo = refundResponse.getString("outNo");
                    }
                    payStatus = "A";
                    refundAmount = new BigDecimal(refundResponse.getString(REFUNDAMOUNT));
                } else {
                    errorMessage.append(tradeQuery.getString("bizMsg"));
                    payStatus = "B";
                }
            } else if (ResponseEnum.TRADE_SUCCESS.getCode().equals(refundResponse.getString("bizCode"))) {
                payStatus = "A";
                refundAmount = new BigDecimal(refundResponse.getString(REFUNDAMOUNT));
            } else {
                errorMessage.append(refundResponse.getString("bizMsg"));
                payStatus = "B";
            }
        } else if (TradeStatus.FAILED.equals((Object)tradestatus)) {
            errorMessage.append(refundResult.getErrorMessage());
            payStatus = "C";
        } else {
            errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
            payStatus = "D";
        }
        refundInfo.put(PAYSTATUS, (Object)payStatus);
        refundInfo.put(PAYTIME, (Object)refundTime);
        refundInfo.put(TRADENO, (Object)tradeNo);
        refundInfo.put(OUTTRADENO, (Object)outTradeNo);
        refundInfo.put(REFUNDAMOUNT, (Object)refundAmount);
        refundInfo.put(ERRORMSG, (Object)errorMessage.toString());
        logger.info("\u91d1\u8776\u91d1\u878d\u9000\u6b3erefundInfo :" + JSON.toJSONString((Object)refundInfo));
        return refundInfo;
    }

    protected static JSONObject callUmsFinRefund(BigDecimal stmamount, List<JSONObject> goodsIdLst, String outTradeNo, RefundInfo refundData) {
        String payStatus;
        JSONObject refundInfo = new JSONObject();
        String tradeNo = "";
        BigDecimal refundAmount = BigDecimal.ZERO;
        JSONObject refundResponse = null;
        Date refundTime = TimeServiceHelper.now();
        refundData.setOutTradeNo(outTradeNo);
        RefundResult refundResult = FinPayTradeHelper.umsRefund((RefundInfo)refundData, goodsIdLst, (BigDecimal)stmamount.abs());
        logger.info("\u94f6\u8054\u626b\u7801\u9000\u6b3erefundResult :" + JSON.toJSONString((Object)refundResult));
        TradeStatus tradestatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = new StringBuilder();
        if (TradeStatus.SUCCESS.equals((Object)tradestatus)) {
            refundResponse = refundResult.getRefundResponse();
            logger.info("\u94f6\u8054\u626b\u7801\u9000\u6b3erefundResponse :" + JSON.toJSONString((Object)refundResponse));
            String refundNo = refundResponse.getString("bizNo");
            tradeNo = refundResponse.getString("orgTransNo");
            if (ResponseEnum.TRADE_PROCESSING.getCode().equals(refundResponse.getString("bizCode"))) {
                JSONObject tradeQuery = FinPayTradeHelper.umsLoopQueryResult((String)refundNo, (String)"12", (long)refundData.getStoreId());
                logger.info("\u94f6\u8054\u626b\u7801\u9000\u6b3e\u67e5\u8be2tradeQuery :" + JSON.toJSONString((Object)tradeQuery) + tradeNo);
                if (ResponseEnum.TRADE_SUCCESS.getCode().equals(tradeQuery.getString("bizCode"))) {
                    tradeNo = tradeQuery.getString("orgTransNo");
                    payStatus = "A";
                    refundAmount = new BigDecimal(refundResponse.getString(REFUNDAMOUNT));
                } else {
                    errorMessage.append(tradeQuery.getString("bizMsg"));
                    payStatus = "B";
                }
            } else if (ResponseEnum.TRADE_SUCCESS.getCode().equals(refundResponse.getString("bizCode"))) {
                payStatus = "A";
                refundAmount = new BigDecimal(refundResponse.getString(REFUNDAMOUNT));
            } else {
                errorMessage.append(refundResponse.getString("bizMsg"));
                payStatus = "B";
            }
        } else if (TradeStatus.FAILED.equals((Object)tradestatus)) {
            errorMessage.append(refundResult.getErrorMessage());
            payStatus = "C";
        } else {
            errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
            payStatus = "D";
        }
        refundInfo.put(PAYSTATUS, (Object)payStatus);
        refundInfo.put(PAYTIME, (Object)refundTime);
        refundInfo.put(TRADENO, (Object)tradeNo);
        refundInfo.put(OUTTRADENO, (Object)outTradeNo);
        refundInfo.put(REFUNDAMOUNT, (Object)refundAmount);
        refundInfo.put(PAYRESPONSE, (Object)refundResponse);
        refundInfo.put(ERRORMSG, (Object)errorMessage.toString());
        logger.info("\u94f6\u8054\u626b\u7801\u9000\u6b3erefundInfo :" + JSON.toJSONString((Object)refundInfo));
        return refundInfo;
    }

    protected static JSONObject callUmsFinCancel(BigDecimal stmamount, String outTradeNo, RefundInfo refundData) {
        String payStatus;
        JSONObject refundInfo = new JSONObject();
        Date refundTime = TimeServiceHelper.now();
        refundData.setOutTradeNo(outTradeNo);
        RefundResult refundResult = FinPayTradeHelper.umsCancel((RefundInfo)refundData, (BigDecimal)stmamount.abs());
        logger.info("\u94f6\u8054\u626b\u7801\u64a4\u9500refundResult :" + JSON.toJSONString((Object)refundResult));
        TradeStatus tradestatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = new StringBuilder();
        if (TradeStatus.SUCCESS.equals((Object)tradestatus)) {
            JSONObject refundResponse = refundResult.getRefundResponse();
            logger.info("\u94f6\u8054\u626b\u7801\u64a4\u9500refundResponse :" + JSON.toJSONString((Object)refundResponse));
            if (ResponseEnum.TRADE_SUCCESS.getCode().equals(refundResponse.getString("bizCode"))) {
                payStatus = "A";
            } else {
                errorMessage.append(refundResponse.getString("bizMsg"));
                payStatus = "B";
            }
        } else if (TradeStatus.FAILED.equals((Object)tradestatus)) {
            errorMessage.append(refundResult.getErrorMessage());
            payStatus = "C";
        } else {
            errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
            payStatus = "D";
        }
        refundInfo.put(PAYSTATUS, (Object)payStatus);
        refundInfo.put(PAYTIME, (Object)refundTime);
        refundInfo.put(OUTTRADENO, (Object)outTradeNo);
        refundInfo.put(REFUNDAMOUNT, (Object)stmamount.abs());
        refundInfo.put(ERRORMSG, (Object)errorMessage.toString());
        logger.info("\u94f6\u8054\u626b\u7801\u64a4\u9500refundInfo :" + JSON.toJSONString((Object)refundInfo));
        return refundInfo;
    }

    protected static JSONObject callAliRefund(BigDecimal stmamount, String outTradeNo, RefundInfo refundData) {
        String subMsg;
        JSONObject refundInfo = new JSONObject();
        String tradeNo = "";
        String payStatus = "FAIL";
        BigDecimal refundAmount = BigDecimal.ZERO;
        RefundResult refundResult = PayTradeHelper.getRefundData((RefundInfo)refundData, (long)2L, (String)"", (String)outTradeNo, (BigDecimal)stmamount.abs());
        TradeStatus tradestatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)refundResult.getErrorMessage())) {
            errorMessage.append(refundResult.getErrorMessage());
        }
        if (refundResult.getRefundResponse() != null && StringUtils.isNotEmpty((CharSequence)(subMsg = refundResult.getRefundResponse().getString("sub_msg")))) {
            String subCode = refundResult.getRefundResponse().getString("sub_code");
            if ("ACQ.REASON_TRADE_REFUND_FEE_ERR".equals(subCode) || "ACQ.REFUND_AMT_NOT_EQUAL_TOTAL".equals(subCode)) {
                subMsg = "\u53ef\u9000\u91d1\u989d\u4e0d\u8db3";
            }
            errorMessage.append(subMsg);
        }
        if (TradeStatus.SUCCESS.equals((Object)tradestatus)) {
            tradeNo = refundResult.getRefundResponse().getString("trade_no");
            String refundFee = refundResult.getRefundResponse().getString("refund_fee");
            payStatus = "A";
            refundAmount = new BigDecimal(refundFee);
        } else if (TradeStatus.FAILED.equals((Object)tradestatus)) {
            errorMessage.append(":\u652f\u4ed8\u5b9d\u9000\u6b3e\u5931\u8d25");
            payStatus = "B";
        } else if (TradeStatus.UNKNOWN.equals((Object)tradestatus)) {
            errorMessage.append(":\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5");
            payStatus = "C";
        } else {
            errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
            payStatus = "D";
        }
        refundInfo.put(PAYSTATUS, (Object)payStatus);
        refundInfo.put(PAYTIME, (Object)TimeServiceHelper.now());
        refundInfo.put(TRADENO, (Object)tradeNo);
        refundInfo.put(OUTTRADENO, (Object)outTradeNo);
        refundInfo.put(REFUNDAMOUNT, (Object)refundAmount);
        refundInfo.put(ERRORMSG, (Object)errorMessage.toString());
        return refundInfo;
    }

    protected static JSONObject callWxRefund(BigDecimal stmamount, String outTradeNo, RefundInfo refundData) {
        JSONObject refundInfo = new JSONObject();
        String tradeNo = "";
        String payStatus = "FAIL";
        BigDecimal refundAmount = BigDecimal.ZERO;
        Date refundTime = TimeServiceHelper.now();
        RefundResult refundResult = PayTradeHelper.getRefundData((RefundInfo)refundData, (long)1L, (String)"", (String)outTradeNo, (BigDecimal)stmamount.abs());
        logger.info("callWxRefund_refundResult:" + refundResult);
        TradeStatus paystatus = refundResult.getTradeStatus();
        StringBuilder errorMessage = new StringBuilder();
        if (StringUtils.isNotEmpty((CharSequence)refundResult.getErrorMessage())) {
            errorMessage.append(refundResult.getErrorMessage());
        }
        if (refundResult.getRefundResponse() != null) {
            String returnMsg = refundResult.getRefundResponse().getString("return_msg");
            if (!"OK".equals(returnMsg)) {
                if ("invalid refund_fee".equals(returnMsg)) {
                    returnMsg = "\u53ef\u9000\u91d1\u989d\u4e0d\u8db3";
                }
                errorMessage.append(returnMsg);
            }
            if (StringUtils.isNotEmpty((CharSequence)refundResult.getRefundResponse().getString("err_code_des"))) {
                errorMessage.append(refundResult.getRefundResponse().getString("err_code_des"));
            }
        }
        logger.info("callWxRefund_TradeStatus:" + paystatus);
        if (TradeStatus.SUCCESS.equals((Object)paystatus)) {
            tradeNo = refundResult.getRefundResponse().getString("transaction_id");
            String refundFee = refundResult.getRefundResponse().getString("refund_fee");
            payStatus = "A";
            refundAmount = new BigDecimal(refundFee);
        } else if (TradeStatus.FAILED.equals((Object)paystatus)) {
            errorMessage.append(":\u5fae\u4fe1\u9000\u6b3e\u5931\u8d25");
            payStatus = "B";
        } else if (TradeStatus.UNKNOWN.equals((Object)paystatus)) {
            errorMessage.append(":\u7cfb\u7edf\u5f02\u5e38\uff0c\u8ba2\u5355\u72b6\u6001\u672a\u77e5");
            payStatus = "C";
        } else {
            errorMessage.append(":\u4e0d\u652f\u6301\u7684\u4ea4\u6613\u72b6\u6001\uff0c\u4ea4\u6613\u8fd4\u56de\u5f02\u5e38");
            payStatus = "D";
        }
        logger.info("callWxRefund_paystatus:" + payStatus);
        refundInfo.put(PAYSTATUS, (Object)payStatus);
        refundInfo.put(PAYTIME, (Object)refundTime);
        refundInfo.put(TRADENO, (Object)tradeNo);
        refundInfo.put(OUTTRADENO, (Object)outTradeNo);
        refundInfo.put(REFUNDAMOUNT, (Object)refundAmount);
        refundInfo.put(ERRORMSG, (Object)errorMessage.toString());
        return refundInfo;
    }

    public static void afterPaySuccess(DynamicObject saleOrder, List<JSONObject> paramsList, String payoption) {
        Date paytime = TimeServiceHelper.now();
        String entityNumber = "ocpos_saleorder";
        if (!CollectionUtils.isEmpty(paramsList)) {
            ArrayList<String> cardNoList = new ArrayList<String>();
            DynamicObjectCollection finEntryEntity = saleOrder.getDynamicObjectCollection("finentity");
            if (finEntryEntity != null && finEntryEntity.size() > 0) {
                for (DynamicObject finEntry : finEntryEntity) {
                    String cardNo = DynamicObjectUtils.getString((DynamicObject)finEntry, (String)"cardno");
                    if (!StringUtils.isNotEmpty((CharSequence)cardNo)) continue;
                    cardNoList.add(cardNo);
                }
            }
            for (JSONObject params : paramsList) {
                PaymentRecord payRecord = new PaymentRecord();
                payRecord.setBillId(DynamicObjectUtil.getPkValue((DynamicObject)saleOrder).longValue());
                payRecord.setBillNo(saleOrder.getString("billno"));
                if (params.containsKey((Object)"orderNo")) {
                    payRecord.setOrderNo(params.getString("orderNo"));
                }
                if (params.containsKey((Object)"bankExchangeNo")) {
                    payRecord.setBankExchangeNo(params.getString("bankExchangeNo"));
                }
                if (params.containsKey((Object)"payWay")) {
                    DynamicObject payWay = (DynamicObject)params.getObject("payWay", DynamicObject.class);
                    payRecord.setPayWay(payWay);
                    DynamicObject payWayType = (DynamicObject)params.getObject("payWayType", DynamicObject.class);
                    payRecord.setPayWayType(payWayType);
                }
                if (params.containsKey((Object)"amount")) {
                    BigDecimal payAmount = params.getBigDecimal("amount");
                    payRecord.setAmount(payAmount);
                    saleOrder.set("sumbalamount", (Object)payAmount);
                }
                if (params.containsKey((Object)"cardNo")) {
                    String paramCardNo = params.getString("cardNo");
                    if (cardNoList.size() > 0 && cardNoList.contains(paramCardNo)) continue;
                    cardNoList.add(paramCardNo);
                    payRecord.setCardNo(paramCardNo);
                }
                if (params.containsKey((Object)"ticketInfoId")) {
                    payRecord.setTicketInfoId(params.getLong("ticketInfoId").longValue());
                }
                if (params.containsKey((Object)"ticketInfo")) {
                    DynamicObject ticketInfo = (DynamicObject)params.getObject("ticketInfo", DynamicObject.class);
                    payRecord.setTicketInfo(ticketInfo);
                }
                if (params.containsKey((Object)"ticketTypeId")) {
                    payRecord.setTicketTypeId(params.getLong("ticketTypeId").longValue());
                }
                if (params.containsKey((Object)"ticketType")) {
                    DynamicObject ticketType = (DynamicObject)params.getObject("ticketType", DynamicObject.class);
                    payRecord.setTicketType(ticketType);
                }
                DynamicObject payCurrency = saleOrder.getDynamicObject("currencyid");
                payRecord.setPayCurrency(payCurrency);
                payRecord.setPaytime(paytime);
                payRecord.setPayStatus("A");
                payRecord.setPayFlowId(101L);
                DynamicObject newFinEntity = finEntryEntity.addNew();
                if (payoption.equalsIgnoreCase("1")) {
                    OlstorePromotionHelper.executeOlstorePromotion(saleOrder);
                    SaleOrderHelper.updateSaleOrderAfterPayment(saleOrder, newFinEntity, payRecord, null);
                } else {
                    entityNumber = "ocpos_saleorder_return";
                    SaleOrderHelper.updateSaleOrderAfterRefund(saleOrder, newFinEntity, payRecord, null);
                }
                SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{saleOrder});
            }
        }
        if (payoption.equalsIgnoreCase("1")) {
            saleOrder.set("orderstatus", (Object)"A");
        } else {
            saleOrder.set("orderstatus", (Object)"I");
        }
        saleOrder.set("salestatus", (Object)"S");
        OperationResult result = SaveServiceHelper.saveOperate((String)"audit", (String)entityNumber, (DynamicObject[])new DynamicObject[]{saleOrder}, (OperateOption)OperateOption.create());
        if (!result.isSuccess()) {
            logger.info("\u652f\u4ed8\u66f4\u65b0\u5b8c\u8c03\u7528\u5ba1\u6838\u64cd\u4f5c\u5931\u8d25\uff01result=" + result.getAllErrorOrValidateInfo());
        }
        long sysUserId = OlstoreUtil.getOperatorSysUserByCustomerId((long)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid"), (long)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid"));
        logger.info("\u7ebf\u4e0a\u95e8\u5e97\u7ed3\u7b97\u9500\u552e\u5458" + sysUserId);
        saleOrder.set("modifier", (Object)sysUserId);
        saleOrder.set("modifier_id", (Object)sysUserId);
        saleOrder.set("auditor", (Object)sysUserId);
        saleOrder.set("auditor_id", (Object)sysUserId);
        SaveServiceHelper.update((DynamicObject)saleOrder);
    }

    public static void getOriginPayType(DynamicObject sourceSaleOrder, DynamicObject sourceFin, DynamicObjectCollection noElectricPayRecords, List<Map<String, Object>> electricPayMapList, DynamicObjectCollection returnPayList) {
        BigDecimal orderAmount;
        DynamicObject iniSourceBill = sourceSaleOrder.getDynamicObject("sourcebillid");
        Object iniBillId = iniSourceBill.getPkValue();
        BigDecimal mustRefundAmt = orderAmount = sourceFin.getBigDecimal("stmamount");
        BigDecimal refundAmt = BigDecimal.ZERO;
        if (iniBillId != null) {
            DynamicObject iniSaleOrder = BusinessDataServiceHelper.loadSingle((Object)iniBillId, (String)"ocpos_saleorder");
            if (iniSaleOrder == null) {
                return;
            }
            DynamicObjectCollection saleOrderFinEntry = iniSaleOrder.getDynamicObjectCollection("finentity");
            for (DynamicObject finEntry : saleOrderFinEntry) {
                BigDecimal refundamount;
                DynamicObject payway = finEntry.getDynamicObject("setllementid");
                BigDecimal stmamount = finEntry.getBigDecimal("stmamount");
                BigDecimal stillAmount = stmamount.subtract(refundamount = finEntry.getBigDecimal("refundamount"));
                if (stillAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                refundAmt = stillAmount.compareTo(mustRefundAmt) >= 0 ? mustRefundAmt : stillAmount;
                if (PaymentModeEnum.getNoElectricPayList().contains(CommonUtil.formatObejctToLong((Object)payway.getPkValue()))) {
                    DynamicObject noteleObject = returnPayList.addNew();
                    noteleObject.set("returnpayway", (Object)payway);
                    noteleObject.set("returntime", finEntry.get("paytime"));
                    noteleObject.set("returncurrency", (Object)finEntry.getDynamicObject("settlecurrid"));
                    noteleObject.set("hasreturnamount", (Object)refundAmt.multiply(new BigDecimal("-1")));
                    noteleObject.set("isdeposit", (Object)Boolean.TRUE);
                    noElectricPayRecords.add((Object)noteleObject);
                } else {
                    HashMap<String, Object> electricPayMap = new HashMap<String, Object>();
                    electricPayMap.put("setllementid", payway);
                    electricPayMap.put(SETTLEAMOUNT, refundAmt);
                    electricPayMap.put("stmamount", refundAmt);
                    electricPayMap.put("orderno", finEntry.getString("orderno"));
                    electricPayMap.put("paytime", finEntry.getDate("paytime"));
                    electricPayMap.put("settlecurrid", finEntry.getDynamicObject("settlecurrid"));
                    electricPayMap.put("isdeposit", Boolean.TRUE);
                    electricPayMapList.add(electricPayMap);
                }
                if ((mustRefundAmt = mustRefundAmt.subtract(refundAmt)).compareTo(BigDecimal.ZERO) > 0) continue;
                break;
            }
        }
    }

    public static void initData(IDataModel model) {
        long userId = RequestContext.get().getCurrUserId();
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)branch);
        long orgId = DynamicObjectUtil.getPkValue((DynamicObject)branch, (String)"saleorg");
        model.setItemValueByID("bizorgid", (Object)orgId);
        model.setValue("terminaltype", (Object)"R");
        Object customer = SystemParamUtil.getDefaultCustomer((long)orgId, (long)branchId);
        model.setValue("customerid", customer);
        model.setItemValueByID("saler", (Object)0L);
        model.setItemValueByID("creator", (Object)userId);
        model.setItemValueByID("cashier", (Object)userId);
        CurrencyHelper.getCurrency(orgId);
        Map<String, Object> currencyMap = CurrencyHelper.initCurrency(branch, orgId);
        model.setItemValueByID("currencyid", currencyMap.get("currencyid"));
        model.setItemValueByID("locurrencyid", currencyMap.get("locurrencyid"));
        model.setItemValueByID("exratetable", currencyMap.get("exratetable"));
        model.setValue("financeexchangerate", currencyMap.get("financeexchangerate"));
        model.setItemValueByID("member", (Object)0L);
        model.setValue("customername", (Object)"");
        model.setValue("customerphone", (Object)"");
        model.setValue("customeraddress", (Object)"");
        model.setValue("sourcebillno", (Object)"");
        model.setValue("initialbillno", (Object)"");
        model.deleteEntryData("goodsentryentity");
        model.createNewEntryRow("goodsentryentity");
    }

    public static List<DynamicObject> getTicketInfosByBranch(DynamicObject[] ticketInfos, long branchId) {
        ArrayList<DynamicObject> list = new ArrayList(ticketInfos.length);
        if (branchId > 0L) {
            for (DynamicObject ticketInfo : ticketInfos) {
                boolean applyStore;
                DynamicObject ticketType = DynamicObjectUtil.getDynamicObject((DynamicObject)ticketInfo, (String)"tickettypeid");
                String ctrlMethod = DynamicObjectUtil.getString((DynamicObject)ticketType, (String)"controlmethod");
                long saleBranchId = DynamicObjectUtil.getPkValue((DynamicObject)ticketInfo, (String)"publishbranchid");
                DynamicObjectCollection branchs = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)ticketType, (String)"treeentryentity");
                boolean applyAll = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"0");
                boolean isOutLineStore = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isoutlinestore");
                if (!isOutLineStore) continue;
                boolean applyPublishStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"1") && saleBranchId == branchId;
                boolean bl = applyStore = StringUtils.equals((CharSequence)ctrlMethod, (CharSequence)"2") && branchs.stream().anyMatch(x -> DynamicObjectUtil.getPkValue((DynamicObject)x, (String)"branch") == branchId);
                if (!applyAll && !applyPublishStore && !applyStore) continue;
                list.add(ticketInfo);
            }
        } else {
            list = Arrays.stream(ticketInfos).collect(Collectors.toList());
        }
        return list;
    }

    public static List<DynamicObject> getTicketInfoByGoods(List<DynamicObject> lstTicketInfos, List<Long> lstGoods) {
        ArrayList<DynamicObject> list = new ArrayList(lstTicketInfos.size());
        if (!CollectionUtils.isEmpty(lstGoods)) {
            for (DynamicObject ticketInfo : lstTicketInfos) {
                DynamicObject ticketType = DynamicObjectUtil.getDynamicObject((DynamicObject)ticketInfo, (String)"tickettypeid");
                boolean isAllGoods = DynamicObjectUtil.getBoolean((DynamicObject)ticketType, (String)"isallgoods");
                DynamicObjectCollection goods = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)ticketType, (String)"tictgoodsentry");
                if (!isAllGoods && !goods.stream().anyMatch(x -> lstGoods.contains(DynamicObjectUtil.getPkValue((DynamicObject)x, (String)"goods")))) continue;
                list.add(ticketInfo);
            }
        } else {
            list = lstTicketInfos;
        }
        return list;
    }

    public static BigDecimal calcGoodsAmount(DynamicObject saleOrder, DynamicObject doTicketType, String usageMode) {
        BigDecimal sumAmount = BigDecimal.ZERO;
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        DynamicObjectCollection docTictGoods = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        if (!ObjectUtils.isEmpty((Object)docGoodsEntry) && !ObjectUtils.isEmpty((Object)docTictGoods)) {
            ArrayList lstGoodsClassifyId = new ArrayList();
            docTictGoods.stream().filter(p -> DynamicObjectUtil.getPkValue((DynamicObject)p.getDynamicObject("goodsclassify")) > 0L).forEach(p -> lstGoodsClassifyId.add(DynamicObjectUtil.getPkValue((DynamicObject)p.getDynamicObject("goodsclassify"))));
            ArrayList lstBrandId = new ArrayList();
            docTictGoods.stream().filter(p -> DynamicObjectUtil.getPkValue((DynamicObject)p.getDynamicObject("brand")) > 0L).forEach(p -> lstBrandId.add(DynamicObjectUtil.getPkValue((DynamicObject)p.getDynamicObject("brand"))));
            ArrayList lstGoodsId = new ArrayList();
            docTictGoods.stream().filter(p -> DynamicObjectUtil.getPkValue((DynamicObject)p.getDynamicObject("goods")) > 0L).forEach(p -> lstGoodsId.add(DynamicObjectUtil.getPkValue((DynamicObject)p.getDynamicObject("goods"))));
            QFilter filter = F7Utils.getEnableStatus();
            if (!ObjectUtils.isEmpty(lstGoodsId)) {
                filter.and("id", "in", lstGoodsId);
            }
            if (!ObjectUtils.isEmpty(lstGoodsClassifyId)) {
                filter.or("itemclassentity.goodsclasssid", "in", (Object)0);
            }
            if (!ObjectUtils.isEmpty(lstBrandId)) {
                filter.or("itembrands", "in", (Object)0);
            }
            filter.and("enable", "=", (Object)"1");
            filter.and("status", "=", (Object)"C");
            String selectFields = ORMUtil.appendFieldsToStr((String[])new String[]{"id"});
            DynamicObjectCollection itemData = QueryServiceHelper.query((String)"ocdbd_iteminfo", (String)selectFields, (QFilter[])filter.toArray());
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                DynamicObject doGoods = DynamicObjectUtil.getDynamicObject((DynamicObject)doGoodsEntry, (String)"goodsid");
                if (doGoods == null || !itemData.stream().anyMatch(p -> p.getLong("id") == DynamicObjectUtil.getPkValue((DynamicObject)doGoods).longValue())) continue;
                if (StringUtils.equals((CharSequence)"1", (CharSequence)usageMode)) {
                    BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                    sumAmount = sumAmount.add(balAmount);
                    continue;
                }
                if (!StringUtils.equals((CharSequence)"2", (CharSequence)usageMode)) continue;
                BigDecimal balPrice = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
                sumAmount = sumAmount.add(balPrice);
                return sumAmount;
            }
        }
        return sumAmount;
    }

    private static JSONObject ticketPay(DynamicObject saleOrder, String[] lstTicketNo, String billFormId) {
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("billsource", (Object)"ocgcm_ticketpay");
        jsonObject.put("numbers", (Object)lstTicketNo);
        jsonObject.put("consumeoperatorid", (Object)RequestContext.get().getCurrUserId());
        jsonObject.put("consumetime", (Object)TimeServiceHelper.now());
        jsonObject.put("consumeorgid", (Object)DynamicObjectUtil.getPkValue((DynamicObject)DynamicObjectUtil.getDynamicObject((DynamicObject)saleOrder, (String)"bizorgid")));
        jsonObject.put("consumebranchid", (Object)DynamicObjectUtil.getPkValue((DynamicObject)DynamicObjectUtil.getDynamicObject((DynamicObject)saleOrder, (String)"salebranchid")));
        jsonObject.put("consumebillno", (Object)DynamicObjectUtil.getString((DynamicObject)saleOrder, (String)"billno"));
        jsonObject.put("consumebillid", (Object)DynamicObjectUtil.getPkValue((DynamicObject)saleOrder));
        jsonObject.put("entityname", (Object)billFormId);
        jsonObject.put("option", (Object)"1");
        jsonObject.put("opertype", (Object)"2");
        JSONObject jsonResult = CommonUtils.doService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"ticketInfoPay", (Object)jsonObject);
        return jsonResult;
    }

    private static JSONObject ticketRefund(DynamicObject saleOrder, List<String> lstTicketNo) {
        JSONObject jsonResult = new JSONObject();
        if (!CollectionUtils.isEmpty(lstTicketNo)) {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("billsource", (Object)"ocgcm_ticketrefund");
            jsonObject.put("numbers", (Object)lstTicketNo.toArray());
            jsonObject.put("sourcebillid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder));
            jsonObject.put("sourcebillno", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno"));
            jsonObject.put("branchid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid"));
            jsonObject.put("orgid", (Object)DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid"));
            jsonObject.put("operatorid", (Object)RequestContext.get().getCurrUserId());
            jsonResult = CommonUtils.doService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"ticketInfoRefund", (Object)jsonObject);
        } else {
            jsonResult.put("success", (Object)Boolean.TRUE);
            jsonResult.put("message", (Object)"");
        }
        return jsonResult;
    }

    private static JSONObject doCreditPay(Long saleOrderId, DynamicObject pay) {
        JSONObject jsonResult = new JSONObject();
        boolean isSuccess = true;
        String message = "";
        BigDecimal showAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)pay, (String)"showamount");
        long creditAccountId = DynamicObjectUtils.getLong((DynamicObject)pay, (String)"creditaccountid");
        Map mResult = CreditMangageHelper.updateCreditActByCreditPay((long)creditAccountId, (BigDecimal)showAmount, (Long)saleOrderId);
        if (!CommonUtil.formatObjectToBoolean(mResult.get("success"))) {
            isSuccess = false;
            message = "\u4fe1\u7528\u8d26\u6237\u66f4\u65b0\u5931\u8d25\u3002";
        } else {
            jsonResult.put("creditactionflowid", mResult.get("creditActionFlowid"));
        }
        jsonResult.put("success", (Object)isSuccess);
        jsonResult.put("message", (Object)message);
        return jsonResult;
    }

    private static JSONObject doCreditReceipt(DynamicObject saleOrder) {
        JSONObject jsonObject = new JSONObject();
        boolean isSuccess = true;
        String message = "";
        DynamicObjectCollection docArEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"arentryentity");
        if (!ObjectUtils.isEmpty((Object)docArEntry)) {
            long billId = 0L;
            long creditAccountId = 0L;
            BigDecimal thisArSettleAmount = BigDecimal.ZERO;
            billId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder);
            for (DynamicObject doItem : docArEntry) {
                creditAccountId = DynamicObjectUtils.getLong((DynamicObject)doItem, (String)"creditaccountid");
                if (creditAccountId == 0L) {
                    isSuccess = false;
                    message = String.format("\u5e94\u6536\u660e\u7ec6\u7b2c%s\u884c,\u4fe1\u7528\u8d26\u6237\u4e3a\u7a7a\u3002", DynamicObjectUtils.getString((DynamicObject)doItem, (String)"seq"));
                    break;
                }
                long arSrcBillId = DynamicObjectUtils.getLong((DynamicObject)doItem, (String)"arsrcbillid");
                thisArSettleAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doItem, (String)"thisarsettleamount");
                Map mResult = CreditMangageHelper.updateCreditActByReCreditPay((long)creditAccountId, (BigDecimal)thisArSettleAmount.negate(), (Long)arSrcBillId, (String)CreditFlowTypeEnum.CREDIT_RETAIL_COLLECTION.getValue());
                if (CommonUtil.formatObjectToBoolean(mResult.get("success"))) {
                    PaymentFlowHelper.updateRecCreditAmount((Long)creditAccountId, (Long)arSrcBillId, (BigDecimal)thisArSettleAmount);
                    continue;
                }
                isSuccess = false;
                message = String.format("\u5e94\u6536\u660e\u7ec6\u7b2c%s\u884c,\u4fe1\u7528\u8d26\u6237\u66f4\u65b0\u5931\u8d25\u3002", DynamicObjectUtils.getString((DynamicObject)doItem, (String)"seq"));
                break;
            }
        }
        jsonObject.put("success", (Object)isSuccess);
        jsonObject.put("message", (Object)message);
        return jsonObject;
    }

    private static boolean doCreditReturnPay(long billId, long creditAccountId, BigDecimal settleAmount) {
        Map mResult;
        if (creditAccountId > 0L && !CommonUtil.formatObjectToBoolean((mResult = CreditMangageHelper.updateCreditActByReCreditPay((long)creditAccountId, (BigDecimal)settleAmount, (Long)billId, (String)CreditFlowTypeEnum.CREDIT_RETAIL_REJECT.getValue())).get("success"))) {
            throw new KDBizException("\u4fe1\u7528\u8d26\u6237\u66f4\u65b0\u5931\u8d25\u3002");
        }
        return true;
    }

    private static boolean sendTicket(String entityId, DynamicObject saleOrder, List<DynamicObject> sendList, DynamicObject initSaleOrder) {
        boolean result;
        boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"notconfirm");
        if (sendList != null && sendList.size() > 0) {
            int index = 0;
            String billNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
            long modifierId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"modifier");
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
            long posSaleOrderId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder);
            DynamicObjectCollection docTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"ticketsendentity");
            if (CollectionUtils.isEmpty((Collection)docTicketEntry)) {
                return false;
            }
            HashMap tickets = new HashMap(0);
            for (DynamicObject dynamicObject : sendList) {
                boolean bIsExecute = DynamicObjectUtils.getBoolean((DynamicObject)dynamicObject, (String)"tisexecute");
                if (bIsExecute) continue;
                ++index;
                long memberId = DynamicObjectUtils.getPkValue((DynamicObject)dynamicObject, (String)"emember");
                HashMap<String, Object> ticketInfo = new HashMap<String, Object>(0);
                ticketInfo.put("tickettypeid", DynamicObjectUtils.getPkValue((DynamicObject)dynamicObject, (String)"tickettype"));
                ticketInfo.put("bizorgid", orgId);
                ticketInfo.put("qty", DynamicObjectUtils.getInt((DynamicObject)dynamicObject, (String)"qty"));
                ticketInfo.put("vipid", memberId);
                ticketInfo.put("realsaleamount", BigDecimal.ZERO);
                ticketInfo.put("gifterid", modifierId);
                ticketInfo.put("giftorgid", orgId);
                ticketInfo.put("giftbranchid", channelId);
                ticketInfo.put("giftbillno", billNo);
                ticketInfo.put("giftbillid", posSaleOrderId);
                ticketInfo.put("ticketstatus", TicketStatusEnum.SEND.getName());
                ticketInfo.put("comment", "\u96f6\u552e\u5f00\u5355\u624b\u5de5\u8d60\u9001\u793c\u5238");
                tickets.put("tickets" + index, ticketInfo);
            }
            JSONObject jsonResult = CommonUtils.doService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"gift", tickets);
            result = CommonUtil.formatObjectToBoolean((Object)jsonResult.get((Object)"success"));
            if (result) {
                for (DynamicObject doSendData : sendList) {
                    String seqKey = "seq";
                    int seq = DynamicObjectUtils.getInt((DynamicObject)doSendData, (String)"seq");
                    if (billTypeId == BillTypeEnum.CVTSALE.getId() && !notConfirm) {
                        seqKey = "initicketseq";
                    }
                    String finalSeqKey = seqKey;
                    DynamicObject doTicketEntry = docTicketEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)finalSeqKey) == seq).findFirst().orElse(null);
                    if (doTicketEntry == null || !StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) continue;
                    doTicketEntry.set("tisexecute", (Object)Boolean.TRUE);
                    doTicketEntry.set("ticketexebillid", (Object)posSaleOrderId);
                    HashMap<String, Object> mapValue = new HashMap<String, Object>(0);
                    mapValue.put("tisexecute", Boolean.TRUE);
                    mapValue.put("ticketexebillid", posSaleOrderId);
                    SaleOrderHelper.writeBackExeBillId(initSaleOrder, doTicketEntry, "ticketsendentity", mapValue, false);
                }
            } else {
                String string = jsonResult.get((Object)"message").toString();
                if (!StringUtils.isEmpty((CharSequence)string)) {
                    logger.info("\u96f6\u552e\u5f00\u5355\u8d60\u9001\u793c\u5238,\u5355\u53f7\uff1a" + billNo + "\u8d60\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + string);
                }
            }
        } else {
            result = false;
        }
        return result;
    }

    private static boolean sendPoint(String entityId, DynamicObject saleOrder, List<DynamicObject> sendList, DynamicObject initSaleOrder) {
        boolean result;
        boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"notconfirm");
        if (sendList != null && sendList.size() > 0) {
            JSONObject jsonObject = new JSONObject();
            long saleOrderId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder);
            String billNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
            long lOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
            BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"receivableamount");
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
            int errCnt = 0;
            DynamicObjectCollection docIntegralEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"sendintegralentity");
            if (CollectionUtils.isEmpty((Collection)docIntegralEntry)) {
                return false;
            }
            for (DynamicObject doSendIntegralEntry : sendList) {
                boolean bIsExecute = DynamicObjectUtils.getBoolean((DynamicObject)doSendIntegralEntry, (String)"insisexecute");
                if (bIsExecute) continue;
                jsonObject.put("requestUuid", (Object)UUID.randomUUID().toString());
                jsonObject.put("memberId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)doSendIntegralEntry, (String)"insmember"));
                jsonObject.put("transactionTime", (Object)DateUtil.getDateFormat((Date)TimeServiceHelper.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                jsonObject.put("pointBizTypeId", (Object)1052237644077201408L);
                HashMap<Long, Integer> pointMap = new HashMap<Long, Integer>(2);
                pointMap.put(DynamicObjectUtils.getPkValue((DynamicObject)doSendIntegralEntry, (String)"insmempointtype"), DynamicObjectUtils.getInt((DynamicObject)doSendIntegralEntry, (String)"insintegral"));
                jsonObject.put("pointMap", pointMap);
                jsonObject.put("orgId", (Object)lOrgId);
                jsonObject.put("channelId", (Object)channelId);
                jsonObject.put("srcBillId", (Object)saleOrderId);
                jsonObject.put("srcNo", (Object)billNo);
                jsonObject.put("srcBillEntityId", (Object)"ocpos_saleorder");
                jsonObject.put("transactionAmount", (Object)receivableAmount);
                jsonObject.put("transCurrencyId", (Object)currencyId);
                jsonObject.put("comment", (Object)"\u96f6\u552e\u5f00\u5355\u8d60\u9001\u79ef\u5206");
                JSONObject jsonResult = CommonUtils.doService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"increaseAvailablePoint", (Object)jsonObject);
                result = CommonUtil.formatObjectToBoolean((Object)jsonResult.get((Object)"success"));
                if (!result) {
                    String message = jsonResult.get((Object)"message").toString();
                    if (!StringUtils.isEmpty((CharSequence)message)) {
                        logger.info("\u96f6\u552e\u5f00\u5355\u8d60\u9001\u79ef\u5206,\u5355\u53f7\uff1a" + billNo + "\u8d60\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + message);
                    }
                    ++errCnt;
                    continue;
                }
                String seqKey = "seq";
                int seq = DynamicObjectUtils.getInt((DynamicObject)doSendIntegralEntry, (String)"seq");
                if (billTypeId == BillTypeEnum.CVTSALE.getId() && !notConfirm) {
                    seqKey = "inipointseq";
                }
                String finalSeqKey = seqKey;
                DynamicObject doIntegralEntry = docIntegralEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)finalSeqKey) == seq).findFirst().orElse(null);
                if (doIntegralEntry == null || !StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) continue;
                doIntegralEntry.set("insisexecute", (Object)Boolean.TRUE);
                doIntegralEntry.set("pointexebillid", (Object)saleOrderId);
                HashMap<String, Object> mapValue = new HashMap<String, Object>(0);
                mapValue.put("insisexecute", Boolean.TRUE);
                mapValue.put("pointexebillid", saleOrderId);
                SaleOrderHelper.writeBackExeBillId(initSaleOrder, doIntegralEntry, "sendintegralentity", mapValue, false);
            }
            result = errCnt == 0;
        } else {
            result = false;
        }
        return result;
    }

    private static void writeBackDiscountAmount(DynamicObject iniSaleOrder, boolean isReturn) {
        if (iniSaleOrder == null) {
            return;
        }
        if (!isReturn) {
            SaleOrderHelper.shareTicketSendAmount(iniSaleOrder);
            SaleOrderHelper.sharePointSendAmount(iniSaleOrder);
        }
        long iniSaleOrderId = DynamicObjectUtils.getPkValue((DynamicObject)iniSaleOrder);
        DynamicObjectType saleOrderType = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder");
        QFilter qFilter = new QFilter("initialbillid", "=", (Object)iniSaleOrderId);
        DynamicObjectCollection docBill = QueryServiceHelper.query((String)"ocpos_saleorder", (String)"Id", (QFilter[])qFilter.toArray());
        if (CollectionUtils.isEmpty((Collection)docBill)) {
            return;
        }
        List lstIds = docBill.stream().map(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"Id")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(lstIds)) {
            return;
        }
        DynamicObject[] saleOrderArray = BusinessDataServiceHelper.load((Object[])lstIds.toArray(), (DynamicObjectType)saleOrderType);
        if (saleOrderArray == null || saleOrderArray.length == 0) {
            return;
        }
        DynamicObjectCollection iniGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSaleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)iniGoodsEntryCollection)) {
            return;
        }
        for (DynamicObject saleOrder : saleOrderArray) {
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
            if (billTypeId != BillTypeEnum.CVTSALE.getId()) continue;
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                int iniSrcSeq = DynamicObjectUtils.getInt((DynamicObject)doGoodsEntry, (String)"inisrcseq");
                if (iniSrcSeq == 0) {
                    iniSrcSeq = DynamicObjectUtils.getInt((DynamicObject)doGoodsEntry, (String)"srcseq");
                }
                int finalSeq = iniSrcSeq;
                DynamicObject iniGoodsEntry = iniGoodsEntryCollection.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == finalSeq).findFirst().orElse(null);
                if (iniGoodsEntry == null) continue;
                BigDecimal iniSaleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"saleqty");
                BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
                BigDecimal iniCouponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"coupondiscount");
                BigDecimal iniIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"integraldistamount");
                if (isReturn) {
                    iniCouponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"adretcoupondiscamount");
                    iniIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)iniGoodsEntry, (String)"adretintegraldistamount");
                }
                BigDecimal singSumShareDiscount = BigDecimal.ZERO;
                if (iniSaleQty.compareTo(saleQty) == 0) {
                    if (!isReturn) {
                        doGoodsEntry.set("coupondiscount", (Object)iniCouponDiscount);
                        doGoodsEntry.set("integraldistamount", (Object)iniIntegralDistAmount);
                    } else {
                        doGoodsEntry.set("adretcoupondiscamount", (Object)iniCouponDiscount);
                        doGoodsEntry.set("adretintegraldistamount", (Object)iniIntegralDistAmount);
                    }
                    singSumShareDiscount = iniCouponDiscount.add(iniIntegralDistAmount);
                } else {
                    BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"srcmustretqty");
                    if (iniCouponDiscount.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal singleCouponDiscount = iniCouponDiscount.divide(iniSaleQty, 2, RoundingMode.HALF_UP);
                        BigDecimal couponDiscount = saleQty.compareTo(mustRetQty) == 0 ? iniCouponDiscount.subtract(iniSaleQty.subtract(saleQty).multiply(singleCouponDiscount)) : singleCouponDiscount.multiply(saleQty);
                        if (!isReturn) {
                            BigDecimal bCouponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"coupondiscount");
                            doGoodsEntry.set("coupondiscount", (Object)bCouponDiscount.add(couponDiscount));
                        } else {
                            BigDecimal bAdRetCouponDiscAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretcoupondiscamount");
                            doGoodsEntry.set("adretcoupondiscamount", (Object)bAdRetCouponDiscAmount.add(couponDiscount));
                        }
                        singSumShareDiscount = singSumShareDiscount.add(couponDiscount);
                    }
                    if (iniIntegralDistAmount.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal singleIntegralDistAmount = iniIntegralDistAmount.divide(iniSaleQty, 2, RoundingMode.HALF_UP);
                        BigDecimal integralDistAmount = saleQty.compareTo(mustRetQty) == 0 ? iniIntegralDistAmount.subtract(iniSaleQty.subtract(saleQty).multiply(singleIntegralDistAmount)) : singleIntegralDistAmount.multiply(saleQty);
                        if (!isReturn) {
                            BigDecimal bIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"integraldistamount");
                            doGoodsEntry.set("integraldistamount", (Object)bIntegralDistAmount.add(integralDistAmount));
                        } else {
                            BigDecimal bAdRetIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretintegraldistamount");
                            doGoodsEntry.set("adretintegraldistamount", (Object)bAdRetIntegralDistAmount.add(integralDistAmount));
                        }
                        singSumShareDiscount = singSumShareDiscount.add(integralDistAmount);
                    }
                }
                BigDecimal sumShareDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"sumsharediscount");
                doGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount.add(singSumShareDiscount));
            }
        }
        DynamicObjectCollection querySaleChange = SaleOrderHelper.querySaleChangeBill(iniSaleOrderId);
        if (CollectionUtils.isEmpty((Collection)querySaleChange)) {
            SaveServiceHelper.update((DynamicObject[])saleOrderArray);
            return;
        }
        ArrayList<DynamicObject> lstSaleOrder = new ArrayList<DynamicObject>(0);
        lstSaleOrder.addAll(Arrays.asList(saleOrderArray));
        lstSaleOrder.add(iniSaleOrder);
        for (DynamicObject saleOrder : lstSaleOrder) {
            long id = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder);
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
            if (billTypeId != BillTypeEnum.CVTSALE.getId() && id != iniSaleOrderId) continue;
            SaleOrderHelper.queryRelationBill(saleOrder, lstSaleOrder, querySaleChange, isReturn);
        }
        SaveServiceHelper.update((DynamicObject[])lstSaleOrder.toArray(new DynamicObject[0]));
    }

    private static DynamicObjectCollection querySaleChangeBill(long iniSaleOrderId) {
        QFilter qFilter = new QFilter("changeitemtype", "<>", (Object)"2");
        qFilter.and("initialbillid", "=", (Object)iniSaleOrderId);
        qFilter.and("goodsentryentity.saleoption", "=", (Object)"1");
        String selectField = "goodsentryentity.Id,goodsentryentity.entrysrcbillid,goodsentryentity.srcbillentryid,goodsentryentity.mustretqty";
        return QueryServiceHelper.query((String)"ocpos_salechange", (String)selectField, (QFilter[])qFilter.toArray());
    }

    private static void queryRelationBill(DynamicObject saleOrder, List<DynamicObject> lstSaleOrder, DynamicObjectCollection querySaleChange, boolean isReturn) {
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            long entryId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry);
            List lstSaleChange = querySaleChange.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"goodsentryentity.srcbillentryid") == entryId).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(lstSaleChange)) {
                return;
            }
            for (DynamicObject saleChange : lstSaleChange) {
                long changeEntryID = DynamicObjectUtils.getLong((DynamicObject)saleChange, (String)"goodsentryentity.Id");
                BigDecimal changeMustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)saleChange, (String)"goodsentryentity.mustretqty");
                BigDecimal srcSaleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"saleqty");
                BigDecimal srcCouponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"coupondiscount");
                BigDecimal srcIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"integraldistamount");
                if (!isReturn) {
                    srcCouponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretcoupondiscamount");
                    srcIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretintegraldistamount");
                }
                BigDecimal singleCouponDiscount = srcCouponDiscount.divide(srcSaleQty, 2, RoundingMode.HALF_UP);
                BigDecimal singleIntegralDistAmount = srcIntegralDistAmount.divide(srcSaleQty, 2, RoundingMode.HALF_UP);
                for (DynamicObject saleOrderChange : lstSaleOrder) {
                    BigDecimal sumShareDiscount;
                    BigDecimal scSumShareDiscount;
                    BigDecimal singleSumShareDiscount;
                    DynamicObject singleChangeGoodsEntry;
                    DynamicObjectCollection changeGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrderChange, (String)"goodsentryentity");
                    if (CollectionUtils.isEmpty((Collection)changeGoodsEntry) || (singleChangeGoodsEntry = (DynamicObject)changeGoodsEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"srcbillentryid") == changeEntryID).findFirst().orElse(null)) == null) continue;
                    BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)singleChangeGoodsEntry, (String)"saleqty");
                    if (srcCouponDiscount.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal adRetCouponDiscAmount;
                        if (saleQty.compareTo(srcSaleQty) == 0) {
                            adRetCouponDiscAmount = BigDecimal.ZERO.subtract(srcCouponDiscount);
                            if (!isReturn) {
                                singleChangeGoodsEntry.set("coupondiscount", (Object)srcCouponDiscount);
                                doGoodsEntry.set("adretcoupondiscamount", (Object)adRetCouponDiscAmount);
                            } else {
                                singleChangeGoodsEntry.set("adretcoupondiscamount", (Object)adRetCouponDiscAmount);
                            }
                            singleSumShareDiscount = srcCouponDiscount;
                        } else {
                            BigDecimal couponDiscount = changeMustRetQty.compareTo(srcSaleQty) == 0 ? srcCouponDiscount.subtract(srcSaleQty.subtract(saleQty).multiply(singleCouponDiscount)) : singleCouponDiscount.multiply(saleQty);
                            if (!isReturn) {
                                BigDecimal bCouponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)singleChangeGoodsEntry, (String)"coupondiscount");
                                singleChangeGoodsEntry.set("coupondiscount", (Object)bCouponDiscount.add(couponDiscount));
                                BigDecimal adRetCouponDiscAmount2 = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretcoupondiscamount");
                                doGoodsEntry.set("adretcoupondiscamount", (Object)adRetCouponDiscAmount2.add(BigDecimal.ZERO.subtract(couponDiscount)));
                            } else {
                                adRetCouponDiscAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretcoupondiscamount");
                                singleChangeGoodsEntry.set("adretcoupondiscamount", (Object)adRetCouponDiscAmount.add(BigDecimal.ZERO.subtract(couponDiscount)));
                            }
                            singleSumShareDiscount = couponDiscount;
                        }
                        scSumShareDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)singleChangeGoodsEntry, (String)"sumsharediscount");
                        singleChangeGoodsEntry.set("sumsharediscount", (Object)scSumShareDiscount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)singleChangeGoodsEntry, (String)"adretcoupondiscamount")));
                        if (!isReturn) {
                            sumShareDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"sumsharediscount");
                            doGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount.subtract(singleSumShareDiscount));
                        }
                    }
                    if (srcIntegralDistAmount.compareTo(BigDecimal.ZERO) > 0) {
                        BigDecimal adRetIntegralDistAmount;
                        if (saleQty.compareTo(srcSaleQty) == 0) {
                            adRetIntegralDistAmount = BigDecimal.ZERO.subtract(srcIntegralDistAmount);
                            if (!isReturn) {
                                singleChangeGoodsEntry.set("integraldistamount", (Object)srcIntegralDistAmount);
                                doGoodsEntry.set("adretintegraldistamount", (Object)adRetIntegralDistAmount);
                            } else {
                                srcIntegralDistAmount = BigDecimal.ZERO.subtract(srcIntegralDistAmount);
                                singleChangeGoodsEntry.set("adretintegraldistamount", (Object)adRetIntegralDistAmount);
                            }
                            singleSumShareDiscount = srcIntegralDistAmount;
                        } else {
                            BigDecimal integralDistAmount = changeMustRetQty.compareTo(srcSaleQty) == 0 ? srcIntegralDistAmount.subtract(srcSaleQty.subtract(saleQty).multiply(singleIntegralDistAmount)) : singleIntegralDistAmount.multiply(saleQty);
                            if (!isReturn) {
                                BigDecimal bIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)singleChangeGoodsEntry, (String)"integraldistamount");
                                singleChangeGoodsEntry.set("integraldistamount", (Object)bIntegralDistAmount.add(integralDistAmount));
                                BigDecimal adRetIntegralDistAmount2 = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretintegraldistamount");
                                doGoodsEntry.set("adretintegraldistamount", (Object)adRetIntegralDistAmount2.add(BigDecimal.ZERO.subtract(integralDistAmount)));
                            } else {
                                adRetIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretintegraldistamount");
                                singleChangeGoodsEntry.set("adretintegraldistamount", (Object)adRetIntegralDistAmount.add(BigDecimal.ZERO.subtract(integralDistAmount)));
                            }
                            singleSumShareDiscount = integralDistAmount;
                        }
                        scSumShareDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)singleChangeGoodsEntry, (String)"sumsharediscount");
                        singleChangeGoodsEntry.set("sumsharediscount", (Object)scSumShareDiscount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)singleChangeGoodsEntry, (String)"adretintegraldistamount")));
                        if (!isReturn) {
                            sumShareDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"sumsharediscount");
                            doGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount.subtract(singleSumShareDiscount));
                        }
                    }
                    SaleOrderHelper.queryRelationBill(saleOrderChange, lstSaleOrder, querySaleChange, isReturn);
                }
            }
        }
    }

    private static void writeBackExeBillId(DynamicObject initSaleOrder, DynamicObject sendEntry, String entityKey, Map<String, Object> mapValue, boolean isPromote) {
        if (initSaleOrder == null || sendEntry == null || mapValue == null) {
            return;
        }
        int seq = DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"seq");
        if (!isPromote) {
            DynamicObjectCollection docSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)entityKey);
            if (CollectionUtils.isEmpty((Collection)docSendEntry)) {
                return;
            }
            DynamicObject doSendEntry = docSendEntry.stream().filter(x -> x.getInt("seq") == seq).findFirst().orElse(null);
            if (doSendEntry == null) {
                return;
            }
            for (Map.Entry<String, Object> entry : mapValue.entrySet()) {
                doSendEntry.set(entry.getKey(), entry.getValue());
            }
        } else {
            DynamicObjectCollection initGoodsCollection;
            long promotionId = DynamicObjectUtils.getLong((DynamicObject)sendEntry, (String)"promotionactid");
            long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)sendEntry, (String)"pointtype");
            long couponTypeId = DynamicObjectUtils.getPkValue((DynamicObject)sendEntry, (String)"coupontype");
            String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"exegoodsseq");
            String iniExeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"iniexegoodsseq");
            if (!StringUtils.isEmpty((CharSequence)iniExeGoodsSeq)) {
                exeGoodsSeq = iniExeGoodsSeq;
            }
            if (CollectionUtils.isEmpty((Collection)(initGoodsCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"goodsentryentity")))) {
                return;
            }
            for (DynamicObject initGoodsEntry : initGoodsCollection) {
                DynamicObjectCollection iniPromoteCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initGoodsEntry, (String)entityKey);
                if (CollectionUtils.isEmpty((Collection)iniPromoteCollection)) {
                    return;
                }
                String finalExeGoodsSeq = exeGoodsSeq;
                DynamicObject iniPromoteEntry = iniPromoteCollection.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"coupontype") == couponTypeId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"exegoodsseq"), (CharSequence)finalExeGoodsSeq)).findFirst().orElse(null);
                if (iniPromoteEntry == null) {
                    return;
                }
                for (Map.Entry<String, Object> entry : mapValue.entrySet()) {
                    iniPromoteEntry.set(entry.getKey(), entry.getValue());
                }
            }
        }
    }

    public static void doSendHandle(String entityId, DynamicObject saleOrder) {
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
            return;
        }
        try {
            long initSaleOrderId;
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
            long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
            long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
            String bookExeDiscTiming = SystemParamUtil.getBookExeDiscTiming((long)orgId, (long)branchId);
            boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"notconfirm");
            ArrayList<DynamicObject> lstSendTicket = new ArrayList<DynamicObject>(0);
            ArrayList<DynamicObject> lstSendPoint = new ArrayList<DynamicObject>(0);
            ArrayList<DynamicObject> lstPromotionTicket = new ArrayList<DynamicObject>(0);
            ArrayList<DynamicObject> lstPromotionPoint = new ArrayList<DynamicObject>(0);
            if (StringUtils.equals((CharSequence)"0", (CharSequence)bookExeDiscTiming) && BillTypeEnum.CVTSALE.getId() == billTypeId) {
                DynamicObjectCollection docGoodsEntry = saleOrder.getDynamicObjectCollection("goodsentryentity");
                List lstId = docGoodsEntry.stream().map(x -> x.getLong("entrysrcbillid")).collect(Collectors.toList());
                DynamicObjectType billDt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder");
                Object[] srcSaleOrderBills = BusinessDataServiceHelper.load((Object[])lstId.toArray(), (DynamicObjectType)billDt);
                if (!ObjectUtils.isEmpty((Object[])srcSaleOrderBills) && srcSaleOrderBills.length > 0) {
                    for (Object doSrcBill : srcSaleOrderBills) {
                        DynamicObjectCollection docPromoteEntry;
                        DynamicObjectCollection docSendPointEntry;
                        DynamicObjectCollection docSrcGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doSrcBill, (String)"goodsentryentity");
                        DynamicObjectCollection docSrcSendTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doSrcBill, (String)"ticketsendentity");
                        if (!CollectionUtils.isEmpty((Collection)docSrcSendTicketEntry) && !CollectionUtils.isEmpty((Collection)docSrcGoodsEntry)) {
                            for (Object doSrcSendTicketEntry : docSrcSendTicketEntry) {
                                String goodsSeq = DynamicObjectUtils.getString((DynamicObject)doSrcSendTicketEntry, (String)"goodsseq");
                                String ticketRetType = DynamicObjectUtils.getString((DynamicObject)doSrcSendTicketEntry, (String)"ticketrettype");
                                if (!StringUtils.isEmpty((CharSequence)ticketRetType) || !SaleOrderHelper.isSendCheck(goodsSeq, docSrcGoodsEntry, docGoodsEntry)) continue;
                                lstSendTicket.add((DynamicObject)doSrcSendTicketEntry);
                            }
                        }
                        if (!CollectionUtils.isEmpty((Collection)(docSendPointEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doSrcBill, (String)"sendintegralentity"))) && !CollectionUtils.isEmpty((Collection)docSrcGoodsEntry)) {
                            Object doSrcSendTicketEntry;
                            doSrcSendTicketEntry = docSendPointEntry.iterator();
                            while (doSrcSendTicketEntry.hasNext()) {
                                DynamicObject doSendPointEntry = (DynamicObject)doSrcSendTicketEntry.next();
                                String goodsSeq = DynamicObjectUtils.getString((DynamicObject)doSendPointEntry, (String)"insgoodsseq");
                                String pointRetType = DynamicObjectUtils.getString((DynamicObject)doSendPointEntry, (String)"pointrettype");
                                if (!StringUtils.isEmpty((CharSequence)pointRetType) || !SaleOrderHelper.isSendCheck(goodsSeq, docSrcGoodsEntry, docGoodsEntry)) continue;
                                lstSendPoint.add(doSendPointEntry);
                            }
                        }
                        if (CollectionUtils.isEmpty((Collection)(docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doSrcBill, (String)"promotionentity"))) || CollectionUtils.isEmpty((Collection)docSrcGoodsEntry)) continue;
                        for (DynamicObject doPromoteEntry : docPromoteEntry) {
                            List<DynamicObject> ticketSendEntity;
                            String goodsSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
                            String promoteId = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotionid");
                            long promoteRuleId = DynamicObjectUtils.getLong((DynamicObject)doPromoteEntry, (String)"promoteruleid");
                            if (!DynamicObjectUtils.getBoolean((DynamicObject)doPromoteEntry, (String)"execute") || !SaleOrderHelper.isSendCheck(goodsSeq, docSrcGoodsEntry, docGoodsEntry)) continue;
                            Map<String, List<DynamicObject>> lstMap = SaleOrderHelper.getPromoteSendList(goodsSeq, bookExeDiscTiming, promoteId, promoteRuleId, docSrcGoodsEntry, docPromoteEntry);
                            List<DynamicObject> SendIntegralEntity = lstMap.get("sendintegralentity");
                            if (!CollectionUtils.isEmpty(SendIntegralEntity)) {
                                lstPromotionPoint.addAll(SendIntegralEntity);
                            }
                            if (CollectionUtils.isEmpty(ticketSendEntity = lstMap.get("ticketsendentity"))) continue;
                            lstPromotionTicket.addAll(ticketSendEntity);
                        }
                    }
                }
            } else if (StringUtils.equals((CharSequence)"1", (CharSequence)bookExeDiscTiming) && (BillTypeEnum.RETAIL.getId() == billTypeId || BillTypeEnum.RESERVE.getId() == billTypeId || BillTypeEnum.GUIDE.getId() == billTypeId || BillTypeEnum.GROUP.getId() == billTypeId)) {
                lstSendTicket = new ArrayList(saleOrder.getDynamicObjectCollection("ticketsendentity"));
                lstSendPoint = new ArrayList(saleOrder.getDynamicObjectCollection("sendintegralentity"));
                SaleOrderHelper.doSendHandle(saleOrder, bookExeDiscTiming, lstPromotionPoint, lstPromotionTicket);
            } else if (BillTypeEnum.RETAIL.getId() == billTypeId || BillTypeEnum.GUIDE.getId() == billTypeId || BillTypeEnum.GROUP.getId() == billTypeId || BillTypeEnum.CHANGE.getId() == billTypeId || notConfirm && BillTypeEnum.CVTSALE.getId() == billTypeId) {
                DynamicObjectCollection ticketSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"ticketsendentity");
                DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
                SaleOrderHelper.getNotContainsBookSendList((List<DynamicObject>)ticketSendEntity, docGoodsEntry, lstSendTicket, "goodsseq");
                DynamicObjectCollection pointSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"sendintegralentity");
                SaleOrderHelper.getNotContainsBookSendList((List<DynamicObject>)pointSendEntity, docGoodsEntry, lstSendPoint, "insgoodsseq");
                ArrayList<DynamicObject> lstPromotionSendPoint = new ArrayList<DynamicObject>(0);
                ArrayList<DynamicObject> lstPromotionSendTicket = new ArrayList<DynamicObject>(0);
                SaleOrderHelper.doSendHandle(saleOrder, bookExeDiscTiming, lstPromotionSendPoint, lstPromotionSendTicket);
                SaleOrderHelper.getNotContainsBookSendList(lstPromotionSendPoint, docGoodsEntry, lstPromotionPoint, "exegoodsseq");
                SaleOrderHelper.getNotContainsBookSendList(lstPromotionSendTicket, docGoodsEntry, lstPromotionTicket, "exegoodsseq");
            }
            DynamicObject initSaleOrder = null;
            String srcChangeItemType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"srcchangeitemtype");
            if (StringUtils.isEmpty((CharSequence)srcChangeItemType) && (initSaleOrderId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"initialbillid")) > 0L) {
                initSaleOrder = BusinessDataServiceHelper.loadSingleFromCache((Object)initSaleOrderId, (String)"ocpos_saleorder");
            }
            if (notConfirm && BillTypeEnum.CVTSALE.getId() == billTypeId) {
                initSaleOrder = saleOrder;
            }
            boolean isSendPont = SaleOrderHelper.sendPoint(entityId, saleOrder, lstSendPoint, initSaleOrder);
            boolean isSendTicket = SaleOrderHelper.sendTicket(entityId, saleOrder, lstSendTicket, initSaleOrder);
            boolean isSendPromote = SaleOrderHelper.doPromotionTicketAndPointSend(entityId, saleOrder, lstPromotionTicket, lstPromotionPoint, initSaleOrder);
            if (initSaleOrder != null) {
                if (isSendPont || isSendTicket || isSendPromote) {
                    SaleOrderHelper.writeBackDiscountAmount(initSaleOrder, false);
                }
                SaveServiceHelper.update((DynamicObject)initSaleOrder);
            } else {
                SaleOrderHelper.shareTicketSendAmount(saleOrder);
                SaleOrderHelper.sharePointSendAmount(saleOrder);
                if (StringUtils.isNotEmpty((CharSequence)srcChangeItemType)) {
                    SaveServiceHelper.update((DynamicObject)saleOrder);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u96f6\u552e\u5f00\u5355\u5355\u53f7\uff1a" + DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno") + "\u8d60\u5238\u589e\u79ef\u5206\u5f02\u5e38" + e.getStackTrace());
        }
    }

    private static void getNotContainsBookSendList(List<DynamicObject> sendEntity, DynamicObjectCollection docGoodsEntry, List<DynamicObject> lstEntity, String goodsSeqKey) {
        if (!CollectionUtils.isEmpty(sendEntity) && !CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            for (DynamicObject sendItem : sendEntity) {
                String[] goodsSeqArray;
                String goodsSeq = DynamicObjectUtils.getString((DynamicObject)sendItem, (String)goodsSeqKey);
                if (StringUtils.isEmpty((CharSequence)goodsSeq)) continue;
                boolean isContainsBook = false;
                for (String seq : goodsSeqArray = goodsSeq.split(",")) {
                    DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
                    if (doGoodsEntry == null || !DynamicObjectUtils.getBoolean((DynamicObject)doGoodsEntry, (String)"isbook")) continue;
                    isContainsBook = true;
                    break;
                }
                if (isContainsBook) continue;
                lstEntity.add(sendItem);
            }
        }
    }

    private static void doSendHandle(DynamicObject saleOrder, String bookExeDiscTiming, List<DynamicObject> lstPromotionPoint, List<DynamicObject> lstPromotionTicket) {
        List<DynamicObject> ticketSendEntity;
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"promotionentity");
        Map<String, List<DynamicObject>> lstMap = SaleOrderHelper.getPromoteSendList("", bookExeDiscTiming, "", 0L, docGoodsEntry, docPromoteEntry);
        List<DynamicObject> sendIntegralEntity = lstMap.get("sendintegralentity");
        if (!CollectionUtils.isEmpty(sendIntegralEntity)) {
            lstPromotionPoint.addAll(sendIntegralEntity);
        }
        if (!CollectionUtils.isEmpty(ticketSendEntity = lstMap.get("ticketsendentity"))) {
            lstPromotionTicket.addAll(ticketSendEntity);
        }
    }

    private static boolean isSendCheck(String goodsSeq, DynamicObjectCollection docSrcGoodsEntry, DynamicObjectCollection docGoodsEntry) {
        String[] arrayGoodsSeq = goodsSeq.split(",");
        if (arrayGoodsSeq.length == 0) {
            return false;
        }
        int cnt = 0;
        int matchCnt = 0;
        for (String seq : arrayGoodsSeq) {
            BigDecimal mustRetQty;
            DynamicObject doSrcGoodsEntry = docSrcGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doSrcGoodsEntry == null || !DynamicObjectUtils.getBoolean((DynamicObject)doSrcGoodsEntry, (String)"isbook")) continue;
            long srcEntryId = DynamicObjectUtils.getPkValue((DynamicObject)doSrcGoodsEntry);
            if (docGoodsEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"srcbillentryid") == srcEntryId).count() > 0L) {
                ++matchCnt;
            }
            if ((mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)doSrcGoodsEntry, (String)"mustretqty")).compareTo(BigDecimal.ZERO) <= 0) continue;
            ++cnt;
        }
        if (matchCnt == 0) {
            return false;
        }
        return cnt == 0;
    }

    private static Map<String, List<DynamicObject>> getPromoteSendList(String goodsSeq, String bookExeDiscTiming, String promoteId, Long proRuleId, DynamicObjectCollection docGoodsEntry, DynamicObjectCollection docPromoteEntry) {
        ArrayList<DynamicObject> lstPointData = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> lstTicketData = new ArrayList<DynamicObject>(0);
        HashMap<String, List<DynamicObject>> mapData = new HashMap<String, List<DynamicObject>>(0);
        if (StringUtils.equals((CharSequence)"1", (CharSequence)bookExeDiscTiming) || StringUtils.equals((CharSequence)"0", (CharSequence)bookExeDiscTiming) && StringUtils.isEmpty((CharSequence)goodsSeq)) {
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                DynamicObjectCollection docPromotionEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
                if (CollectionUtils.isEmpty((Collection)docPromotionEntry)) continue;
                ArrayList<DynamicObject> lstPromoteData = new ArrayList<DynamicObject>((Collection<DynamicObject>)docPromotionEntry);
                Map<String, List<DynamicObject>> mapDataPromote = SaleOrderHelper.getPromoteTicketOrPointList(lstPromoteData);
                SaleOrderHelper.checkPromoteList(mapDataPromote, lstPointData, lstTicketData, docPromoteEntry);
            }
        } else {
            String[] arraysGoodsSeq = goodsSeq.split(",");
            if (arraysGoodsSeq.length == 0) {
                return mapData;
            }
            String itemGroup = "";
            if (proRuleId > 0L) {
                DynamicObject doPromoteRule = BusinessDataServiceHelper.loadSingle((Object)proRuleId, (String)"ocdpm_promote_rule");
                itemGroup = DynamicObjectUtils.getString((DynamicObject)doPromoteRule, (String)"itemgroup");
            }
            if (!StringUtils.equals((CharSequence)"1", (CharSequence)itemGroup)) {
                DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)arraysGoodsSeq[0])).findFirst().orElse(null);
                if (doGoodsEntry == null) {
                    return mapData;
                }
                DynamicObjectCollection docPromotionEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
                if (CollectionUtils.isEmpty((Collection)docPromotionEntry)) {
                    return mapData;
                }
                List<DynamicObject> lstPromoteData = docPromotionEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("promotionactid"), (CharSequence)promoteId)).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(lstPromoteData)) {
                    return mapData;
                }
                Map<String, List<DynamicObject>> mapDataPromote = SaleOrderHelper.getPromoteTicketOrPointList(lstPromoteData);
                SaleOrderHelper.checkPromoteList(mapDataPromote, lstPointData, lstTicketData, docPromoteEntry);
            } else {
                for (String seq : arraysGoodsSeq) {
                    List<DynamicObject> lstPromoteData;
                    DynamicObjectCollection docPromotionEntry;
                    DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("seq"), (CharSequence)seq)).findFirst().orElse(null);
                    if (doGoodsEntry == null || CollectionUtils.isEmpty((Collection)(docPromotionEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote"))) || CollectionUtils.isEmpty(lstPromoteData = docPromotionEntry.stream().filter(x -> StringUtils.equals((CharSequence)x.getString("promotionactid"), (CharSequence)promoteId)).collect(Collectors.toList()))) continue;
                    Map<String, List<DynamicObject>> mapDataPromote = SaleOrderHelper.getPromoteTicketOrPointList(lstPromoteData);
                    SaleOrderHelper.checkPromoteList(mapDataPromote, lstPointData, lstTicketData, docPromoteEntry);
                }
            }
        }
        mapData.put("sendintegralentity", lstPointData);
        mapData.put("ticketsendentity", lstTicketData);
        return mapData;
    }

    private static void checkPromoteList(Map<String, List<DynamicObject>> mapDataPromote, List<DynamicObject> lstPointData, List<DynamicObject> lstTicketData, DynamicObjectCollection docPromoteEntry) {
        List<DynamicObject> lstTicketPromote;
        if (CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
            return;
        }
        List<DynamicObject> lstPointPromote = mapDataPromote.get("sendintegralentity");
        if (!CollectionUtils.isEmpty(lstPointPromote)) {
            for (DynamicObject pointPromote : lstPointPromote) {
                DynamicObject doPromoteEntry;
                long promotionId = DynamicObjectUtils.getLong((DynamicObject)pointPromote, (String)"promotionactid");
                String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)pointPromote, (String)"exegoodsseq");
                long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)pointPromote, (String)"pointtype");
                String promoteRetType = DynamicObjectUtils.getString((DynamicObject)pointPromote, (String)"promoterettype");
                if (!StringUtils.isEmpty((CharSequence)promoteRetType) || (doPromoteEntry = (DynamicObject)docPromoteEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionid") == promotionId).findFirst().orElse(null)) == null || !lstPointData.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"exegoodsseq"), (CharSequence)exeGoodsSeq) && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId)) continue;
                lstPointData.add(pointPromote);
            }
        }
        if (!CollectionUtils.isEmpty(lstTicketPromote = mapDataPromote.get("ticketsendentity"))) {
            for (DynamicObject ticketPromote : lstTicketPromote) {
                DynamicObject doPromoteEntry;
                long promotionId = DynamicObjectUtils.getLong((DynamicObject)ticketPromote, (String)"promotionactid");
                String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)ticketPromote, (String)"exegoodsseq");
                long couponTypeId = DynamicObjectUtils.getPkValue((DynamicObject)ticketPromote, (String)"coupontype");
                String promoteRetType = DynamicObjectUtils.getString((DynamicObject)ticketPromote, (String)"promoterettype");
                if (!StringUtils.isEmpty((CharSequence)promoteRetType) || (doPromoteEntry = (DynamicObject)docPromoteEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionid") == promotionId).findFirst().orElse(null)) == null || !lstTicketData.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"exegoodsseq"), (CharSequence)exeGoodsSeq) && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"coupontype") == couponTypeId)) continue;
                lstTicketData.add(ticketPromote);
            }
        }
    }

    private static Map<String, List<DynamicObject>> getPromoteTicketOrPointList(List<DynamicObject> docPromotionEntry) {
        HashMap<String, List<DynamicObject>> mapData = new HashMap<String, List<DynamicObject>>(0);
        ArrayList<DynamicObject> lstPromotionTicket = new ArrayList<DynamicObject>(0);
        ArrayList<DynamicObject> lstPromotionPoint = new ArrayList<DynamicObject>(0);
        for (DynamicObject doPromotionEntry : docPromotionEntry) {
            String promoteType;
            DynamicObject doPromoteType = DynamicObjectUtils.getDynamicObject((DynamicObject)doPromotionEntry, (String)"promotiontypeid");
            if (ObjectUtils.isEmpty((Object)doPromoteType)) continue;
            switch (promoteType = DynamicObjectUtils.getString((DynamicObject)doPromoteType, (String)"number")) {
                case "PM-023": 
                case "PM-034": 
                case "PM-039": {
                    if (lstPromotionPoint.contains(doPromotionEntry)) break;
                    lstPromotionPoint.add(doPromotionEntry);
                    break;
                }
                case "PM-025": 
                case "PM-035": 
                case "PM-037": {
                    if (lstPromotionTicket.contains(doPromotionEntry)) break;
                    lstPromotionTicket.add(doPromotionEntry);
                    break;
                }
            }
        }
        mapData.put("sendintegralentity", lstPromotionPoint);
        mapData.put("ticketsendentity", lstPromotionTicket);
        return mapData;
    }

    public static boolean doPromotionTicketAndPointSend(String entityId, DynamicObject saleOrder, List<DynamicObject> lstPromotionTicket, List<DynamicObject> lstPromotionPoint, DynamicObject initSaleOrder) {
        boolean result = false;
        String billNo = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"billno");
        try {
            long billId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder);
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
            long memberId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"member");
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"currencyid");
            long modifierId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"modifier");
            BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"receivableamount");
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
                return false;
            }
            if (lstPromotionTicket.size() > 0) {
                HashMap tickets = new HashMap(0);
                int index = 0;
                for (DynamicObject doPromotionTicket : lstPromotionTicket) {
                    boolean bIsExecute = DynamicObjectUtils.getBoolean((DynamicObject)doPromotionTicket, (String)"isgift");
                    if (bIsExecute) continue;
                    ++index;
                    HashMap<String, Object> ticketInfo = new HashMap<String, Object>(0);
                    ticketInfo.put("tickettypeid", DynamicObjectUtils.getPkValue((DynamicObject)doPromotionTicket, (String)"coupontype"));
                    ticketInfo.put("bizorgid", orgId);
                    ticketInfo.put("qty", DynamicObjectUtils.getInt((DynamicObject)doPromotionTicket, (String)"promotsaleqty"));
                    ticketInfo.put("vipid", memberId);
                    ticketInfo.put("realsaleamount", BigDecimal.ZERO);
                    ticketInfo.put("gifterid", modifierId);
                    ticketInfo.put("giftorgid", orgId);
                    ticketInfo.put("giftbranchid", channelId);
                    ticketInfo.put("giftbillid", billId);
                    ticketInfo.put("giftbillno", billNo);
                    ticketInfo.put("ticketstatus", TicketStatusEnum.SEND.getName());
                    ticketInfo.put("comment", "\u96f6\u552e\u5f00\u5355\u4fc3\u9500\u8d60\u9001\u793c\u5238");
                    tickets.put("tickets" + index, ticketInfo);
                }
                JSONObject jsonResult = CommonUtils.doService((String)"occ", (String)"ocgcm", (String)"TicketInfoService", (String)"gift", tickets);
                result = CommonUtil.formatObjectToBoolean((Object)jsonResult.get((Object)"success"));
                if (result) {
                    SaleOrderHelper.updatePromoteSendStatus(entityId, billId, docGoodsEntry, lstPromotionTicket, initSaleOrder);
                } else {
                    String message = jsonResult.get((Object)"message").toString();
                    if (!StringUtils.isEmpty((CharSequence)message)) {
                        logger.info("\u96f6\u552e\u5f00\u5355\u8d60\u9001\u793c\u5238,\u5355\u53f7\uff1a" + billNo + "\u8d60\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + message);
                    }
                }
            }
            if (lstPromotionPoint.size() > 0) {
                for (DynamicObject doPromotionPoint : lstPromotionPoint) {
                    boolean bIsExecute = DynamicObjectUtils.getBoolean((DynamicObject)doPromotionPoint, (String)"isgift");
                    if (bIsExecute) continue;
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("requestUuid", (Object)UUID.randomUUID().toString());
                    jsonObject.put("memberId", (Object)memberId);
                    jsonObject.put("transactionTime", (Object)DateUtil.getDateFormat((Date)TimeServiceHelper.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                    jsonObject.put("pointBizTypeId", (Object)1052237644077201408L);
                    HashMap<Long, Integer> pointMap = new HashMap<Long, Integer>(2);
                    pointMap.put(DynamicObjectUtils.getPkValue((DynamicObject)doPromotionPoint, (String)"pointtype"), DynamicObjectUtils.getInt((DynamicObject)doPromotionPoint, (String)"promotsaleqty"));
                    jsonObject.put("pointMap", pointMap);
                    jsonObject.put("orgId", (Object)orgId);
                    jsonObject.put("channelId", (Object)channelId);
                    jsonObject.put("srcBillId", (Object)billId);
                    jsonObject.put("srcNo", (Object)billNo);
                    jsonObject.put("srcBillEntityId", (Object)entityId);
                    jsonObject.put("transactionAmount", (Object)receivableAmount);
                    jsonObject.put("transCurrencyId", (Object)currencyId);
                    jsonObject.put("comment", (Object)"\u96f6\u552e\u5f00\u5355\u4fc3\u9500\u8d60\u9001\u79ef\u5206");
                    JSONObject jsonResult = CommonUtils.doService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"increaseAvailablePoint", (Object)jsonObject);
                    result = CommonUtil.formatObjectToBoolean((Object)jsonResult.get((Object)"success"));
                    if (result) {
                        SaleOrderHelper.updatePromoteSendStatus(entityId, billId, docGoodsEntry, Collections.singletonList(doPromotionPoint), initSaleOrder);
                        continue;
                    }
                    String message = jsonResult.get((Object)"message").toString();
                    if (StringUtils.isEmpty((CharSequence)message)) continue;
                    logger.info("\u96f6\u552e\u5f00\u5355\u8d60\u9001\u79ef\u5206,\u5355\u53f7\uff1a" + billNo + "\u8d60\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + message);
                }
            }
        }
        catch (Exception e) {
            logger.error("\u96f6\u552e\u5f00\u5355\u4fc3\u9500\u8d60\u9001\u79ef\u5206\u793c\u5238,\u5355\u53f7\uff1a" + billNo + "\u8d60\u9001\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0\uff1a" + e.getStackTrace());
            result = false;
        }
        return result;
    }

    private static void updatePromoteSendStatus(String entityId, long billId, DynamicObjectCollection docGoodsEntry, List<DynamicObject> lstPromotion, DynamicObject initSaleOrder) {
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            DynamicObjectCollection docPromotionEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
            if (CollectionUtils.isEmpty((Collection)docPromotionEntry)) continue;
            for (DynamicObject doPromotionEntry : docPromotionEntry) {
                long promotionId = DynamicObjectUtils.getLong((DynamicObject)doPromotionEntry, (String)"promotionactid");
                long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromotionEntry, (String)"pointtype");
                long couponTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromotionEntry, (String)"coupontype");
                String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)doPromotionEntry, (String)"exegoodsseq");
                String iniExeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)doPromotionEntry, (String)"iniexegoodsseq");
                if (!StringUtils.isEmpty((CharSequence)iniExeGoodsSeq)) {
                    exeGoodsSeq = iniExeGoodsSeq;
                }
                String finalExeGoodsSeq = exeGoodsSeq;
                boolean isExist = lstPromotion.stream().anyMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"coupontype") == couponTypeId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"exegoodsseq"), (CharSequence)finalExeGoodsSeq) || StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"iniexegoodsseq"), (CharSequence)finalExeGoodsSeq));
                if (!isExist || !StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) continue;
                doPromotionEntry.set("isgift", (Object)Boolean.TRUE);
                doPromotionEntry.set("promoteexebillid", (Object)billId);
                HashMap<String, Object> mapValue = new HashMap<String, Object>(0);
                mapValue.put("isgift", Boolean.TRUE);
                mapValue.put("promoteexebillid", billId);
                SaleOrderHelper.writeBackExeBillId(initSaleOrder, doPromotionEntry, "salesorderpromote", mapValue, true);
            }
        }
    }

    public static void deductPoint(String entityId, DynamicObject saleReturn, DynamicObject initSaleOrder, List<DynamicObject> updateBills, List<DynamicObject> lstSendPoint, List<DynamicObject> lstPromotionPoint) {
        try {
            HashMap<Long, Integer> pointMap;
            JSONObject jsonObject;
            if (!StringUtils.equals((CharSequence)entityId, (CharSequence)BillTypeEnum.RETURN.getEntityId()) && !StringUtils.equals((CharSequence)entityId, (CharSequence)BillTypeEnum.CHANGE.getEntityId())) {
                return;
            }
            if (initSaleOrder == null || CollectionUtils.isEmpty(updateBills)) {
                return;
            }
            long billId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn);
            String billNo = DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"billno");
            long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"bizorgid");
            long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"salebranchid");
            long channelId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"salebranchid");
            long memberId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"member");
            long currencyId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"currencyid");
            BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleReturn, (String)"receivableamount").abs();
            String pointReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)branchId, (String)"pointreturnmode");
            if (!StringUtils.equals((CharSequence)pointReturnMode, (CharSequence)ReturnModelEnum.FixedRules.getValue()) && !StringUtils.equals((CharSequence)pointReturnMode, (CharSequence)"1")) {
                return;
            }
            DynamicObjectCollection docGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleReturn, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)docGoodsEntryCollection)) {
                return;
            }
            DynamicObjectCollection iniGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)iniGoodsEntryCollection)) {
                return;
            }
            ArrayList<Long> lstPointTypeId = new ArrayList<Long>(0);
            ArrayList<Long> lstGiftBillId = new ArrayList<Long>(0);
            HashMap<Integer, Object> seqSyncRetTypeValue = new HashMap<Integer, Object>(0);
            HashMap<Integer, Object> seqPromoteSyncRetTypeValue = new HashMap<Integer, Object>(0);
            SaleOrderHelper.checkSendEntry(initSaleOrder, saleReturn, "sendintegralentity", "pointexebillid", "insmempointtype", "pointtype", "insintegral", "insgoodsseq", "pointrettype", lstGiftBillId, seqSyncRetTypeValue, seqPromoteSyncRetTypeValue, lstPointTypeId, lstSendPoint, lstPromotionPoint);
            if (CollectionUtils.isEmpty(lstPointTypeId) || CollectionUtils.isEmpty(lstGiftBillId)) {
                return;
            }
            for (DynamicObject doRetGoodsEntry : docGoodsEntryCollection) {
                DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doRetGoodsEntry, (String)"salesorderpromote");
                if (CollectionUtils.isEmpty((Collection)docPromoteEntry) || seqPromoteSyncRetTypeValue.size() <= 0) continue;
                SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqPromoteSyncRetTypeValue, "salesorderpromote", "promoterettype", true, doRetGoodsEntry, true);
            }
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncRetTypeValue, "sendintegralentity", "pointrettype", true, null, false);
            if (lstPromotionPoint.size() > 0) {
                for (DynamicObject doPromotionPoint : lstPromotionPoint) {
                    jsonObject = new JSONObject();
                    jsonObject.put("requestUuid", (Object)UUID.randomUUID().toString());
                    jsonObject.put("memberId", (Object)memberId);
                    jsonObject.put("transactionTime", (Object)DateUtil.getDateFormat((Date)TimeServiceHelper.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                    jsonObject.put("pointBizTypeId", (Object)1052237644077201408L);
                    pointMap = new HashMap<Long, Integer>(2);
                    pointMap.put(DynamicObjectUtils.getPkValue((DynamicObject)doPromotionPoint, (String)"pointtype"), DynamicObjectUtils.getInt((DynamicObject)doPromotionPoint, (String)"promotsaleqty"));
                    jsonObject.put("pointMap", pointMap);
                    jsonObject.put("orgId", (Object)orgId);
                    jsonObject.put("channelId", (Object)channelId);
                    jsonObject.put("srcBillId", (Object)billId);
                    jsonObject.put("srcNo", (Object)billNo);
                    jsonObject.put("srcBillEntityId", (Object)entityId);
                    jsonObject.put("transactionAmount", (Object)receivableAmount);
                    jsonObject.put("transCurrencyId", (Object)currencyId);
                    jsonObject.put("comment", (Object)"\u96f6\u552e\u9000\u8d27\u9000\u56de\u8d60\u9001\u79ef\u5206");
                    CommonUtils.doService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"decreaseAvailablePoint", (Object)jsonObject);
                }
            }
            if (lstSendPoint.size() > 0) {
                for (DynamicObject doSendIntegralEntry : lstSendPoint) {
                    jsonObject = new JSONObject();
                    jsonObject.put("requestUuid", (Object)UUID.randomUUID().toString());
                    jsonObject.put("memberId", (Object)DynamicObjectUtils.getPkValue((DynamicObject)doSendIntegralEntry, (String)"insmember"));
                    jsonObject.put("transactionTime", (Object)DateUtil.getDateFormat((Date)TimeServiceHelper.now(), (String)"yyyy-MM-dd HH:mm:ss"));
                    jsonObject.put("pointBizTypeId", (Object)1052237644077201408L);
                    pointMap = new HashMap(2);
                    pointMap.put(DynamicObjectUtils.getPkValue((DynamicObject)doSendIntegralEntry, (String)"insmempointtype"), DynamicObjectUtils.getInt((DynamicObject)doSendIntegralEntry, (String)"insintegral"));
                    jsonObject.put("pointMap", pointMap);
                    jsonObject.put("orgId", (Object)orgId);
                    jsonObject.put("channelId", (Object)channelId);
                    jsonObject.put("srcBillId", (Object)billId);
                    jsonObject.put("srcNo", (Object)billNo);
                    jsonObject.put("srcBillEntityId", (Object)entityId);
                    jsonObject.put("transactionAmount", (Object)receivableAmount);
                    jsonObject.put("transCurrencyId", (Object)currencyId);
                    jsonObject.put("comment", (Object)"\u96f6\u552e\u9000\u8d27\u9000\u56de\u8d60\u9001\u79ef\u5206");
                    CommonUtils.doService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"decreaseAvailablePoint", (Object)jsonObject);
                }
            }
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    private static void updateLinkDownCvtBillDiscAmt(DynamicObject iniSaleOrder, List<DynamicObject> updateBills, List<DynamicObject> lstSendPoint, List<DynamicObject> lstPromotionPoint, List<DynamicObject> lstSendTicket, List<DynamicObject> lstPromotionTicket) {
        String usageMode;
        DynamicObject doTicketType;
        String goodsSeq;
        long targetCurrencyId;
        long payCurrencyId;
        BigDecimal integralValue;
        DynamicObject doPointType;
        if (iniSaleOrder == null || CollectionUtils.isEmpty(updateBills)) {
            return;
        }
        DynamicObjectCollection iniGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSaleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)iniGoodsEntry)) {
            return;
        }
        if (!CollectionUtils.isEmpty(lstSendPoint)) {
            for (DynamicObject doPointSendEntry : lstSendPoint) {
                doPointType = DynamicObjectUtil.getDynamicObject((DynamicObject)doPointSendEntry, (String)"insmempointtype");
                if (doPointType == null) continue;
                integralValue = DynamicObjectUtil.getBigDecimal((DynamicObject)doPointSendEntry, (String)"integralvalue");
                payCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                targetCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)doPointSendEntry, (String)"insgoodsseq");
                SaleOrderHelper.updateRetIntegralDiscountAmount(iniSaleOrder, payCurrencyId, targetCurrencyId, integralValue, goodsSeq);
            }
        }
        if (!CollectionUtils.isEmpty(lstPromotionPoint)) {
            for (DynamicObject subPromoteEntry : lstPromotionPoint) {
                doPointType = DynamicObjectUtil.getDynamicObject((DynamicObject)subPromoteEntry, (String)"pointtype");
                if (doPointType == null) continue;
                integralValue = DynamicObjectUtil.getBigDecimal((DynamicObject)subPromoteEntry, (String)"promoteintegralvalue");
                payCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                targetCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
                SaleOrderHelper.updateRetIntegralDiscountAmount(iniSaleOrder, payCurrencyId, targetCurrencyId, integralValue, goodsSeq);
            }
        }
        if (!CollectionUtils.isEmpty(lstSendTicket)) {
            for (DynamicObject doTicketSendEntry : lstSendTicket) {
                doTicketType = DynamicObjectUtil.getDynamicObject((DynamicObject)doTicketSendEntry, (String)"tickettype");
                if (ObjectUtils.isEmpty((Object)doTicketType) || !StringUtils.equals((CharSequence)(usageMode = doTicketType.getString("usagemode")), (CharSequence)"0")) continue;
                BigDecimal qty = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketSendEntry, (String)"qty");
                BigDecimal ticketAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"ticketvalue");
                ticketAmount = ticketAmount.multiply(qty);
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)doTicketSendEntry, (String)"goodsseq");
                SaleOrderHelper.updateRetTicketDiscountAmount(iniSaleOrder, ticketAmount, goodsSeq);
            }
        }
        if (!CollectionUtils.isEmpty(lstPromotionTicket)) {
            for (DynamicObject subPromoteEntry : lstPromotionTicket) {
                doTicketType = DynamicObjectUtil.getDynamicObject((DynamicObject)subPromoteEntry, (String)"coupontype");
                usageMode = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"usagemode");
                if (!StringUtils.equals((CharSequence)usageMode, (CharSequence)"0")) continue;
                BigDecimal ticketValue = DynamicObjectUtil.getBigDecimal((DynamicObject)subPromoteEntry, (String)"promoteticketvalue");
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
                SaleOrderHelper.updateRetTicketDiscountAmount(iniSaleOrder, ticketValue, goodsSeq);
            }
        }
        SaleOrderHelper.writeBackDiscountAmount(iniSaleOrder, true);
    }

    public static void updateRetIntegralDiscountAmount(DynamicObject iniSaleOrder, long payCurrencyId, long targetCurrencyId, BigDecimal integralValue, String goodsSeq) {
        DynamicObjectCollection iniGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSaleOrder, (String)"goodsentryentity");
        BigDecimal sumShareAmount = BigDecimal.ZERO;
        BigDecimal exchangeRate = CommonUtils.getCurrencyRate((long)payCurrencyId, (long)targetCurrencyId);
        if (exchangeRate.compareTo(BigDecimal.ZERO) <= 0) {
            exchangeRate = BigDecimal.ONE;
        }
        BigDecimal costAmount = integralValue.multiply(exchangeRate);
        List<String> lstGoodsSeq = Arrays.asList(goodsSeq.split(","));
        BigDecimal goodsAmount = SaleOrderHelper.getGoodsAmount(lstGoodsSeq, iniGoodsEntry);
        for (int i = 0; i < lstGoodsSeq.size(); ++i) {
            BigDecimal newRetIntegralDistAmount;
            int finalIndex = i;
            DynamicObject doGoodsEntry = iniGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)((CharSequence)lstGoodsSeq.get(finalIndex)))).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            if (i == lstGoodsSeq.size() - 1) {
                newRetIntegralDistAmount = BigDecimal.ZERO.subtract(costAmount.add(sumShareAmount));
            } else {
                newRetIntegralDistAmount = BigDecimal.ZERO.subtract(balAmount.multiply(costAmount).divide(goodsAmount, 2, RoundingMode.HALF_UP));
                sumShareAmount = sumShareAmount.add(newRetIntegralDistAmount);
            }
            BigDecimal integralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"integraldistamount");
            BigDecimal retIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretintegraldistamount");
            BigDecimal iniRetIntegralDistAmount = retIntegralDistAmount.add(newRetIntegralDistAmount);
            if (integralDistAmount.compareTo(iniRetIntegralDistAmount.abs()) < 0) continue;
            doGoodsEntry.set("adretintegraldistamount", (Object)iniRetIntegralDistAmount);
            BigDecimal sumShareDisCount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"sumsharediscount");
            doGoodsEntry.set("sumsharediscount", (Object)sumShareDisCount.add(newRetIntegralDistAmount));
        }
    }

    private static void updateRetTicketDiscountAmount(DynamicObject iniSaleOrder, BigDecimal ticketAmount, String goodsSeq) {
        DynamicObjectCollection iniGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSaleOrder, (String)"goodsentryentity");
        BigDecimal sumShareAmount = BigDecimal.ZERO;
        List<String> lstGoodsSeq = Arrays.asList(goodsSeq.split(","));
        BigDecimal goodsAmount = SaleOrderHelper.getGoodsAmount(lstGoodsSeq, iniGoodsEntry);
        for (int i = 0; i < lstGoodsSeq.size(); ++i) {
            BigDecimal newRetCouponDiscount;
            int finalIndex = i;
            DynamicObject doGoodsEntry = iniGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)((CharSequence)lstGoodsSeq.get(finalIndex)))).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            if (i == lstGoodsSeq.size() - 1) {
                newRetCouponDiscount = BigDecimal.ZERO.subtract(ticketAmount.add(sumShareAmount));
            } else {
                newRetCouponDiscount = BigDecimal.ZERO.subtract(balAmount.multiply(ticketAmount).divide(goodsAmount, 2, RoundingMode.HALF_UP));
                sumShareAmount = sumShareAmount.add(newRetCouponDiscount);
            }
            BigDecimal couponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"coupondiscount");
            BigDecimal retRetCouponDiscAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"adretcoupondiscamount");
            BigDecimal iniRetCouponDiscAmount = retRetCouponDiscAmount.add(newRetCouponDiscount);
            if (couponDiscount.compareTo(iniRetCouponDiscAmount.abs()) < 0) continue;
            doGoodsEntry.set("adretcoupondiscamount", (Object)iniRetCouponDiscAmount);
            BigDecimal sumShareDisCount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"sumsharediscount");
            doGoodsEntry.set("sumsharediscount", (Object)sumShareDisCount.add(newRetCouponDiscount));
        }
    }

    public static void updateSendTicketStatus(String entityId, DynamicObject saleReturn, DynamicObject initSaleOrder, List<DynamicObject> updateBills, List<DynamicObject> lstSendTicket, List<DynamicObject> lstPromotionTicket) {
        long branchId;
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)BillTypeEnum.RETURN.getEntityId()) && !StringUtils.equals((CharSequence)entityId, (CharSequence)BillTypeEnum.CHANGE.getEntityId())) {
            return;
        }
        if (initSaleOrder == null || CollectionUtils.isEmpty(updateBills)) {
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"bizorgid");
        String cashCoupOnReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"salebranchid")), (String)"cashcouponreturnmode");
        if (!StringUtils.equals((CharSequence)cashCoupOnReturnMode, (CharSequence)ReturnModelEnum.RecycleTicket.getValue()) && !StringUtils.equals((CharSequence)cashCoupOnReturnMode, (CharSequence)ReturnModelEnum.FixedRules.getValue())) {
            return;
        }
        DynamicObjectCollection iniGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)iniGoodsEntryCollection)) {
            return;
        }
        DynamicObjectCollection docGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleReturn, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntryCollection)) {
            return;
        }
        ArrayList<Long> lstGiftBillId = new ArrayList<Long>(0);
        ArrayList<Long> lstTicketTypeId = new ArrayList<Long>(0);
        HashMap<Integer, Object> seqSyncRetTypeValue = new HashMap<Integer, Object>(0);
        HashMap<Integer, Object> seqPromoteSyncRetTypeValue = new HashMap<Integer, Object>(0);
        BigDecimal ticketQty = SaleOrderHelper.checkSendEntry(initSaleOrder, saleReturn, "ticketsendentity", "ticketexebillid", "tickettype", "coupontype", "qty", "goodsseq", "ticketrettype", lstGiftBillId, seqSyncRetTypeValue, seqPromoteSyncRetTypeValue, lstTicketTypeId, lstSendTicket, lstPromotionTicket);
        if (CollectionUtils.isEmpty(lstGiftBillId) || CollectionUtils.isEmpty(lstTicketTypeId)) {
            return;
        }
        for (DynamicObject doRetGoodsEntry : docGoodsEntryCollection) {
            DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doRetGoodsEntry, (String)"salesorderpromote");
            if (CollectionUtils.isEmpty((Collection)docPromoteEntry) || seqPromoteSyncRetTypeValue.size() <= 0) continue;
            SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqPromoteSyncRetTypeValue, "salesorderpromote", "promoterettype", true, doRetGoodsEntry, true);
        }
        SaleOrderWriteBackHelper.updateIniSouceBillSendValue(initSaleOrder, seqSyncRetTypeValue, "ticketsendentity", "ticketrettype", true, null, false);
        QFilter qFilter = new QFilter("giftbillid", "in", (Object)lstGiftBillId.toArray());
        qFilter.and("tickettypeid", "in", (Object)lstTicketTypeId.toArray());
        qFilter.and("ticketstatus", "=", (Object)TicketStatusEnum.SEND.getName());
        DynamicObjectType type = (DynamicObjectType)ORM.create().getDataEntityType("ocdbd_ticketinfo");
        DynamicObjectCollection docTicket = QueryServiceHelper.query((String)"ocdbd_ticketinfo", (String)"id", (QFilter[])qFilter.toArray());
        if (docTicket == null || docTicket.size() == 0) {
            return;
        }
        ArrayList<Object> lstIds = new ArrayList<Object>(0);
        for (DynamicObject dynamicObject : docTicket) {
            Object o = DynamicObjectUtils.get((DynamicObject)dynamicObject, (String)"id");
            lstIds.add(o);
        }
        if (lstIds.size() > 0) {
            DynamicObject ticket;
            DynamicObject[] tickets = BusinessDataServiceHelper.load((Object[])lstIds.toArray(), (DynamicObjectType)type);
            if (tickets == null || tickets.length == 0) {
                return;
            }
            List<DynamicObject> lstTicket = Arrays.asList(tickets);
            ArrayList<DynamicObject> lstUpdateTicket = new ArrayList<DynamicObject>(0);
            if (!CollectionUtils.isEmpty(lstSendTicket)) {
                for (DynamicObject sendTicket : lstSendTicket) {
                    if (ticketQty.compareTo(BigDecimal.ZERO) == 0) break;
                    long ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)sendTicket, (String)"tickettype");
                    int qty = DynamicObjectUtils.getInt((DynamicObject)sendTicket, (String)"qty");
                    if (qty == 0) break;
                    for (int i = 0; i < qty; ++i) {
                        ticket = lstTicket.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"tickettypeid") == ticketTypeId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"ticketstatus"), (CharSequence)TicketStatusEnum.SEND.getName())).findFirst().orElse(null);
                        if (ticket == null) continue;
                        ticket.set("ticketstatus", (Object)TicketStatusEnum.NO_MAKE.getName());
                        ticket.set("vipid", null);
                        ticketQty = ticketQty.subtract(BigDecimal.ONE);
                        lstUpdateTicket.add(ticket);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(lstPromotionTicket)) {
                for (DynamicObject sendTicket : lstPromotionTicket) {
                    if (ticketQty.compareTo(BigDecimal.ZERO) == 0) break;
                    int qty = DynamicObjectUtils.getInt((DynamicObject)sendTicket, (String)"promotsaleqty");
                    for (int i = 0; i < qty; ++i) {
                        long ticketTypeId = DynamicObjectUtils.getPkValue((DynamicObject)sendTicket, (String)"coupontype");
                        ticket = lstTicket.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"tickettypeid") == ticketTypeId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"ticketstatus"), (CharSequence)TicketStatusEnum.SEND.getName())).findFirst().orElse(null);
                        if (ticket == null) continue;
                        ticket.set("ticketstatus", (Object)TicketStatusEnum.NO_MAKE.getName());
                        ticket.set("vipid", null);
                        ticketQty = ticketQty.subtract(BigDecimal.ONE);
                        lstUpdateTicket.add(ticket);
                    }
                }
            }
            if (!CollectionUtils.isEmpty(lstUpdateTicket)) {
                SaveServiceHelper.update((DynamicObject[])lstUpdateTicket.toArray(new DynamicObject[0]));
            }
        }
    }

    public static void shareTicketSendAmount(DynamicObject saleOrder) {
        String goodsSeq;
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CHANGE.getId()) {
            return;
        }
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (ObjectUtils.isEmpty((Object)docGoodsEntry)) {
            return;
        }
        for (DynamicObject goodsEntry : docGoodsEntry) {
            String saleOption = DynamicObjectUtil.getString((DynamicObject)goodsEntry, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || goodsEntry.getBigDecimal("coupondiscount").compareTo(BigDecimal.ZERO) == 0) continue;
            Map<String, BigDecimal> result = SaleOrderAmountHelper.getRecalculateLineAmountMap(goodsEntry, "coupondiscount", BigDecimal.ZERO, false);
            SaleAmountHelper.setData(result, goodsEntry);
        }
        DynamicObjectCollection docTicketSendEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"ticketsendentity");
        if (!CollectionUtils.isEmpty((Collection)docTicketSendEntry)) {
            for (DynamicObject doTicketSendEntry : docTicketSendEntry) {
                String usageMode;
                DynamicObject doTicketType;
                boolean bIsExecute;
                if (StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)doTicketSendEntry, (String)"ticketsaleoption"), (CharSequence)"0") && billTypeId == BillTypeEnum.CHANGE.getId() || !(bIsExecute = DynamicObjectUtil.getBoolean((DynamicObject)doTicketSendEntry, (String)"tisexecute")) || ObjectUtils.isEmpty((Object)(doTicketType = DynamicObjectUtil.getDynamicObject((DynamicObject)doTicketSendEntry, (String)"tickettype"))) || !StringUtils.equals((CharSequence)(usageMode = doTicketType.getString("usagemode")), (CharSequence)"0")) continue;
                BigDecimal qty = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketSendEntry, (String)"qty");
                BigDecimal ticketAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doTicketType, (String)"ticketvalue");
                ticketAmount = ticketAmount.multiply(qty);
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)doTicketSendEntry, (String)"goodsseq");
                SaleOrderHelper.updateTicketDiscountAmount(docGoodsEntry, ticketAmount, goodsSeq);
            }
        }
        ArrayList<DynamicObject> lstSubPromoteEntry = new ArrayList<DynamicObject>(0);
        for (DynamicObject entry : docGoodsEntry) {
            DynamicObjectCollection docSubPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entry, (String)"salesorderpromote");
            if (CollectionUtils.isEmpty((Collection)docSubPromoteEntry)) continue;
            for (DynamicObject subPromoteEntry : docSubPromoteEntry) {
                String usageMode;
                DynamicObject doTicketType = DynamicObjectUtil.getDynamicObject((DynamicObject)subPromoteEntry, (String)"coupontype");
                boolean bIsExecute = DynamicObjectUtil.getBoolean((DynamicObject)subPromoteEntry, (String)"isgift");
                if (!bIsExecute || ObjectUtils.isEmpty((Object)doTicketType) || !StringUtils.equals((CharSequence)(usageMode = DynamicObjectUtils.getString((DynamicObject)doTicketType, (String)"usagemode")), (CharSequence)"0")) continue;
                long promoteId = DynamicObjectUtils.getLong((DynamicObject)subPromoteEntry, (String)"promotionactid");
                String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
                long couponTypeId = DynamicObjectUtils.getPkValue((DynamicObject)subPromoteEntry, (String)"coupontype");
                if (!lstSubPromoteEntry.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promoteId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"exegoodsseq"), (CharSequence)exeGoodsSeq) && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"coupontype") == couponTypeId)) continue;
                lstSubPromoteEntry.add(subPromoteEntry);
                BigDecimal ticketValue = DynamicObjectUtil.getBigDecimal((DynamicObject)subPromoteEntry, (String)"promoteticketvalue");
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
                SaleOrderHelper.updateTicketDiscountAmount(docGoodsEntry, ticketValue, goodsSeq);
            }
        }
    }

    private static void updateTicketDiscountAmount(DynamicObjectCollection docGoodsEntry, BigDecimal ticketAmount, String goodsSeq) {
        BigDecimal sumShareAmount = BigDecimal.ZERO;
        List<String> lstGoodsSeq = Arrays.asList(goodsSeq.split(","));
        BigDecimal goodsAmount = SaleOrderHelper.getGoodsAmount(lstGoodsSeq, docGoodsEntry);
        for (int i = 0; i < lstGoodsSeq.size(); ++i) {
            BigDecimal newCouponDiscount;
            int finalIndex = i;
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)((CharSequence)lstGoodsSeq.get(finalIndex)))).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            if (i == lstGoodsSeq.size() - 1) {
                newCouponDiscount = ticketAmount.subtract(sumShareAmount);
            } else {
                newCouponDiscount = balAmount.multiply(ticketAmount).divide(goodsAmount, 2, RoundingMode.HALF_UP);
                sumShareAmount = sumShareAmount.add(newCouponDiscount);
            }
            BigDecimal adCouponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"coupondiscount");
            doGoodsEntry.set("coupondiscount", (Object)adCouponDiscount.add(newCouponDiscount));
            BigDecimal sumShareDisCount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"sumsharediscount");
            doGoodsEntry.set("sumsharediscount", (Object)sumShareDisCount.add(newCouponDiscount));
        }
    }

    public static void sharePointSendAmount(DynamicObject saleOrder) {
        String goodsSeq;
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CHANGE.getId() || billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (ObjectUtils.isEmpty((Object)docGoodsEntry)) {
            return;
        }
        for (DynamicObject goodsEntry : docGoodsEntry) {
            String saleOption = DynamicObjectUtil.getString((DynamicObject)goodsEntry, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || goodsEntry.getBigDecimal("integraldistamount").compareTo(BigDecimal.ZERO) == 0) continue;
            Map<String, BigDecimal> result = SaleOrderAmountHelper.getRecalculateLineAmountMap(goodsEntry, "integraldistamount", BigDecimal.ZERO, false);
            SaleAmountHelper.setData(result, goodsEntry);
        }
        DynamicObjectCollection docPointSendEntry = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"sendintegralentity");
        if (!CollectionUtils.isEmpty((Collection)docPointSendEntry)) {
            for (DynamicObject doPointSendEntry : docPointSendEntry) {
                DynamicObject doPointType;
                boolean bIsExecute = DynamicObjectUtil.getBoolean((DynamicObject)doPointSendEntry, (String)"insisexecute");
                if (!bIsExecute || StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)doPointSendEntry, (String)"pointsaleoption"), (CharSequence)"0") && billTypeId == BillTypeEnum.CHANGE.getId() || (doPointType = DynamicObjectUtil.getDynamicObject((DynamicObject)doPointSendEntry, (String)"insmempointtype")) == null) continue;
                BigDecimal integralValue = DynamicObjectUtil.getBigDecimal((DynamicObject)doPointSendEntry, (String)"integralvalue");
                long payCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                long targetCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)doPointSendEntry, (String)"insgoodsseq");
                SaleOrderHelper.updateIntegralDiscountAmount(docGoodsEntry, payCurrencyId, targetCurrencyId, integralValue, goodsSeq);
            }
        }
        ArrayList<DynamicObject> lstSubPromoteEntry = new ArrayList<DynamicObject>(0);
        for (DynamicObject entry : docGoodsEntry) {
            DynamicObjectCollection docSubPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entry, (String)"salesorderpromote");
            if (CollectionUtils.isEmpty((Collection)docSubPromoteEntry)) continue;
            for (DynamicObject subPromoteEntry : docSubPromoteEntry) {
                DynamicObject doPointType = DynamicObjectUtil.getDynamicObject((DynamicObject)subPromoteEntry, (String)"pointtype");
                boolean bIsExecute = DynamicObjectUtil.getBoolean((DynamicObject)subPromoteEntry, (String)"isgift");
                if (!bIsExecute || doPointType == null) continue;
                long promoteId = DynamicObjectUtils.getLong((DynamicObject)subPromoteEntry, (String)"promotionactid");
                String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
                long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)subPromoteEntry, (String)"pointtype");
                if (!lstSubPromoteEntry.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promoteId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"exegoodsseq"), (CharSequence)exeGoodsSeq) && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId)) continue;
                lstSubPromoteEntry.add(subPromoteEntry);
                BigDecimal integralValue = DynamicObjectUtil.getBigDecimal((DynamicObject)subPromoteEntry, (String)"promoteintegralvalue");
                long payCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                long targetCurrencyId = DynamicObjectUtils.getPkValue((DynamicObject)doPointType, (String)"currencyid");
                goodsSeq = DynamicObjectUtil.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
                SaleOrderHelper.updateIntegralDiscountAmount(docGoodsEntry, payCurrencyId, targetCurrencyId, integralValue, goodsSeq);
            }
        }
    }

    public static void updateIntegralDiscountAmount(DynamicObjectCollection docGoodsEntry, long payCurrencyId, long targetCurrencyId, BigDecimal integralValue, String goodsSeq) {
        BigDecimal sumShareAmount = BigDecimal.ZERO;
        BigDecimal exchangeRate = CommonUtils.getCurrencyRate((long)payCurrencyId, (long)targetCurrencyId);
        if (exchangeRate.compareTo(BigDecimal.ZERO) <= 0) {
            exchangeRate = BigDecimal.ONE;
        }
        BigDecimal costAmount = integralValue.multiply(exchangeRate);
        List<String> lstGoodsSeq = Arrays.asList(goodsSeq.split(","));
        BigDecimal goodsAmount = SaleOrderHelper.getGoodsAmount(lstGoodsSeq, docGoodsEntry);
        for (int i = 0; i < lstGoodsSeq.size(); ++i) {
            BigDecimal newIntegralDistAmount;
            int finalIndex = i;
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)((CharSequence)lstGoodsSeq.get(finalIndex)))).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            if (i == lstGoodsSeq.size() - 1) {
                newIntegralDistAmount = costAmount.subtract(sumShareAmount);
            } else {
                newIntegralDistAmount = balAmount.multiply(costAmount).divide(goodsAmount, 2, RoundingMode.HALF_UP);
                sumShareAmount = sumShareAmount.add(newIntegralDistAmount);
            }
            BigDecimal integralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"integraldistamount");
            doGoodsEntry.set("integraldistamount", (Object)integralDistAmount.add(newIntegralDistAmount));
            BigDecimal sumShareDisCount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"sumsharediscount");
            doGoodsEntry.set("sumsharediscount", (Object)sumShareDisCount.add(newIntegralDistAmount));
        }
    }

    public static void reCalcGiftShareAmount(DynamicObject dataEntity) {
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CHANGE.getId() || billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        DynamicObjectCollection docGoodSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int seq = 0;
        ArrayList<Integer> giftGoodsSeqList = new ArrayList<Integer>(entryEntity.size());
        for (DynamicObject entry : entryEntity) {
            ++seq;
            String saleOption = DynamicObjectUtil.getString((DynamicObject)entry, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) continue;
            if (DynamicObjectUtil.getBoolean((DynamicObject)entry, (String)"ispresent") && StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)entry, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue()) && !DynamicObjectUtil.getBoolean((DynamicObject)entry, (String)"isbook")) {
                giftGoodsSeqList.add(seq);
            }
            if (entry.getBigDecimal("giftdiscountamount").compareTo(BigDecimal.ZERO) == 0) continue;
            Map<String, BigDecimal> result = SaleOrderAmountHelper.getRecalculateLineAmountMap(entry, "giftdiscountamount", BigDecimal.ZERO, false);
            SaleAmountHelper.setData(result, entry);
        }
        if (!CollectionUtils.isEmpty((Collection)docGoodSendEntry)) {
            for (DynamicObject doGoodSendEntry : docGoodSendEntry) {
                if (StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)doGoodSendEntry, (String)"giftsaleoption"), (CharSequence)"0") && billTypeId == BillTypeEnum.CHANGE.getId()) continue;
                SaleOrderHelper.shareSendGoodsAmount(entryEntity, doGoodSendEntry);
            }
        }
        if (giftGoodsSeqList.size() == 0) {
            return;
        }
        block2: for (Integer giftGoodsSeq : giftGoodsSeqList) {
            for (DynamicObject entry : entryEntity) {
                boolean isEntryBreak = false;
                DynamicObjectCollection docSubPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entry, (String)"salesorderpromote");
                if (CollectionUtils.isEmpty((Collection)docSubPromoteEntry)) continue;
                for (DynamicObject subPromoteEntry : docSubPromoteEntry) {
                    int promotegoodsseq = DynamicObjectUtil.getInt((DynamicObject)subPromoteEntry, (String)"promotegoodsseq");
                    if (giftGoodsSeq != promotegoodsseq) continue;
                    isEntryBreak = true;
                    String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
                    if (!StringUtils.isNotEmpty((CharSequence)exeGoodsSeq)) break;
                    SaleOrderHelper.sharePromoteGiftAmount(entryEntity, subPromoteEntry);
                    break;
                }
                if (!isEntryBreak) continue;
                continue block2;
            }
        }
    }

    public static void shareSendGoodsAmount(DynamicObjectCollection docGoodsEntry, DynamicObject doSendGoodsEntry) {
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry) || doSendGoodsEntry == null) {
            return;
        }
        BigDecimal sendQty = DynamicObjectUtil.getBigDecimal((DynamicObject)doSendGoodsEntry, (String)"sendqty");
        BigDecimal giftPrice = DynamicObjectUtil.getBigDecimal((DynamicObject)doSendGoodsEntry, (String)"giftprice");
        if (sendQty.compareTo(BigDecimal.ZERO) <= 0 || giftPrice.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        int promoteSeq = DynamicObjectUtil.getInt((DynamicObject)doSendGoodsEntry, (String)"seq");
        DynamicObject promoteSeqEntry = docGoodsEntry.stream().filter(x -> DynamicObjectUtil.getInt((DynamicObject)x, (String)"promoteseq") == promoteSeq && !DynamicObjectUtil.getBoolean((DynamicObject)x, (String)"isbook")).findFirst().orElse(null);
        if (promoteSeqEntry == null) {
            return;
        }
        BigDecimal giftAmount = giftPrice.multiply(sendQty);
        String goodsSeq = DynamicObjectUtil.getString((DynamicObject)doSendGoodsEntry, (String)"sendgoodsseq");
        SaleOrderHelper.updateGiftDiscountAmount(docGoodsEntry, goodsSeq, giftAmount);
    }

    public static void sharePromoteGiftAmount(DynamicObjectCollection docGoodsEntry, DynamicObject subPromoteEntry) {
        BigDecimal giftAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)subPromoteEntry, (String)"promotegiftvalue");
        String goodsSeq = DynamicObjectUtil.getString((DynamicObject)subPromoteEntry, (String)"exegoodsseq");
        if (giftAmount.compareTo(BigDecimal.ZERO) == 0 || StringUtils.isEmpty((CharSequence)goodsSeq)) {
            return;
        }
        SaleOrderHelper.updateGiftDiscountAmount(docGoodsEntry, goodsSeq, giftAmount);
    }

    public static void sharePromoteGiftAmount(DynamicObjectCollection docGoodsEntry, DynamicObjectCollection docPromoteEntry, DynamicObject doSubPromoteEntry) {
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry) || doSubPromoteEntry == null) {
            return;
        }
        BigDecimal giftAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doSubPromoteEntry, (String)"promotegiftvalue");
        if (giftAmount.compareTo(BigDecimal.ZERO) <= 0) {
            return;
        }
        long promoteId = DynamicObjectUtil.getLong((DynamicObject)doSubPromoteEntry, (String)"promotionactid");
        DynamicObject promoteEntry = docPromoteEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionid") == promoteId).findFirst().orElse(null);
        if (promoteEntry == null) {
            return;
        }
        int promoteSeq = DynamicObjectUtils.getInt((DynamicObject)promoteEntry, (String)"seq");
        DynamicObject promoteSeqEntry = docGoodsEntry.stream().filter(x -> DynamicObjectUtil.getInt((DynamicObject)x, (String)"promoteseq") == promoteSeq && StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue()) && !DynamicObjectUtil.getBoolean((DynamicObject)x, (String)"isbook")).findFirst().orElse(null);
        if (promoteSeqEntry == null) {
            return;
        }
        String goodsSeq = DynamicObjectUtil.getString((DynamicObject)doSubPromoteEntry, (String)"exegoodsseq");
        SaleOrderHelper.updateGiftDiscountAmount(docGoodsEntry, goodsSeq, giftAmount);
    }

    private static void updateGiftDiscountAmount(DynamicObjectCollection docGoodsEntry, String goodsSeq, BigDecimal giftAmount) {
        BigDecimal sumShareAmount = BigDecimal.ZERO;
        List<String> lstGoodsSeq = Arrays.asList(goodsSeq.split(","));
        BigDecimal goodsAmount = SaleOrderHelper.getGoodsAmount(lstGoodsSeq, docGoodsEntry);
        for (int i = 0; i < lstGoodsSeq.size(); ++i) {
            BigDecimal giftDiscountAmount;
            BigDecimal lineGoodsDiscount;
            int finalIndex = i;
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)((CharSequence)lstGoodsSeq.get(finalIndex)))).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            if (i == lstGoodsSeq.size() - 1) {
                lineGoodsDiscount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"giftdiscountamount");
                giftDiscountAmount = lineGoodsDiscount.add(giftAmount.subtract(sumShareAmount));
            } else {
                BigDecimal goodsShareAmount = balAmount.multiply(giftAmount).divide(goodsAmount, 2, RoundingMode.HALF_UP);
                lineGoodsDiscount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"giftdiscountamount");
                giftDiscountAmount = lineGoodsDiscount.add(goodsShareAmount);
                sumShareAmount = sumShareAmount.add(goodsShareAmount);
            }
            Map<String, BigDecimal> amountResult = SaleOrderAmountHelper.getRecalculateLineAmountMap(doGoodsEntry, "giftdiscountamount", giftDiscountAmount, false);
            SaleAmountHelper.setData(amountResult, doGoodsEntry);
        }
    }

    public static BigDecimal getGoodsAmount(List<String> lstGoodsSeq, DynamicObjectCollection docGoodsEntry) {
        BigDecimal goodsAmount = BigDecimal.ZERO;
        for (String seq : lstGoodsSeq) {
            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)x, (String)"seq"), (CharSequence)seq)).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
            goodsAmount = goodsAmount.add(balAmount);
        }
        return goodsAmount;
    }

    public static Map<String, BigDecimal> calcGoodsAmount(List<DynamicObject> docGoodsEntry, DynamicObject doTicketType, String usageMode) {
        String goodsSeq = "";
        BigDecimal sumAmount = BigDecimal.ZERO;
        HashMap<String, BigDecimal> mapResult = new HashMap<String, BigDecimal>(0);
        DynamicObjectCollection docTictGoods = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)doTicketType, (String)"tictgoodsentry");
        if (CollectionUtils.isEmpty(docGoodsEntry) || CollectionUtils.isEmpty((Collection)docTictGoods)) {
            return mapResult;
        }
        block12: for (DynamicObject doGoodsEntry : docGoodsEntry) {
            String seq = DynamicObjectUtil.getString((DynamicObject)doGoodsEntry, (String)"seq");
            block13: for (DynamicObject goods : docTictGoods) {
                DynamicObjectCollection docInvType;
                String goodsType = DynamicObjectUtils.getString((DynamicObject)goods, (String)"type");
                long goodsClassifyId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goodsclassify");
                Set classIds = ItemClassNodeUtil.queryChildItemClass(new HashSet<Long>(Collections.singleton(goodsClassifyId)));
                long brandId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"brand");
                ArrayList<Long> saleAttrIds = new ArrayList(0);
                ArrayList<Long> invTypeIds = new ArrayList(0);
                DynamicObjectCollection docSaleAttr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goods, (String)"saleattr");
                if (!CollectionUtils.isEmpty((Collection)docSaleAttr)) {
                    saleAttrIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docSaleAttr);
                }
                if (!CollectionUtils.isEmpty((Collection)(docInvType = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goods, (String)"invttype")))) {
                    invTypeIds = MultiBaseDataUtil.getMultiF7PKValueList((DynamicObjectCollection)docInvType);
                }
                switch (goodsType) {
                    case "1": {
                        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goods, (String)"goods");
                        if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid") == goodsId) break;
                        continue block13;
                    }
                    case "2": {
                        if (TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry))) break;
                        continue block13;
                    }
                    case "3": {
                        if (DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                        continue block13;
                    }
                    case "5": {
                        if (TicketAmountHelper.isMatchGoodsClass(classIds, Collections.singletonList(doGoodsEntry)) && DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"brand") == brandId) break;
                        continue block13;
                    }
                }
                if (!TicketAmountHelper.isMatchSaleAttrOrInvType(saleAttrIds, invTypeIds, Collections.singletonList(doGoodsEntry))) continue;
                if (StringUtils.equals((CharSequence)"0", (CharSequence)usageMode) || StringUtils.equals((CharSequence)"1", (CharSequence)usageMode)) {
                    BigDecimal balAmount = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"balamount");
                    sumAmount = sumAmount.add(balAmount);
                    if (StringUtils.isEmpty((CharSequence)goodsSeq)) {
                        goodsSeq = seq;
                        continue block12;
                    }
                    goodsSeq = goodsSeq + "," + seq;
                    continue block12;
                }
                if (!StringUtils.equals((CharSequence)"2", (CharSequence)usageMode)) continue;
                BigDecimal balPrice = DynamicObjectUtil.getBigDecimal((DynamicObject)doGoodsEntry, (String)"discountprice");
                sumAmount = sumAmount.add(balPrice);
                mapResult.put(seq, sumAmount);
                return mapResult;
            }
        }
        if (StringUtils.isNotEmpty((CharSequence)goodsSeq)) {
            mapResult.put(goodsSeq, sumAmount);
        }
        return mapResult;
    }

    protected static StringBuilder getPayErrorMsg(PayResult payResult) {
        return new StringBuilder();
    }

    public static void activateTicket(DynamicObject saleOrder) {
        DynamicObject[] ticketInfoDynArr;
        String srcBizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"srcbiztype");
        if (DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"isactivateticket") && StringUtils.equals((CharSequence)srcBizType, (CharSequence)"H")) {
            return;
        }
        long vipId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"member");
        Date saleEndTime = DynamicObjectUtils.getDate((DynamicObject)saleOrder, (String)"saleendtime");
        QFilter ticketFilter = new QFilter("olinvitateid", ">", (Object)0L);
        ticketFilter.and("activateposorderid", "=", (Object)0L);
        ticketFilter.and("vipid", "=", (Object)vipId);
        ticketFilter.and("auditdate", "<", (Object)saleEndTime);
        ticketFilter.and("ticketstatus", "=", (Object)TicketStatusEnum.WAIT_ACTIVATE.getName());
        for (DynamicObject ticketInfoDyn : ticketInfoDynArr = BusinessDataServiceHelper.load((String)"ocdbd_ticketinfo", (String)"id,number,name,vipid,auditdate,ticketstatus,tickettypeid,olinvitateid,activateposorderid,activateposorderno", (QFilter[])ticketFilter.toArray())) {
            DynamicObject olInvitationDyn = ticketInfoDyn.getDynamicObject("olinvitateid");
            if (olInvitationDyn == null) continue;
            boolean isApplyAllItem = olInvitationDyn.getBoolean("isallgoods");
            BigDecimal activateAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)olInvitationDyn, (String)"activateamount");
            BigDecimal totalRealAmount = BigDecimal.ZERO;
            DynamicObjectCollection posItemDynArr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            for (DynamicObject posItemDynRow : posItemDynArr) {
                if (DynamicObjectUtils.getBoolean((DynamicObject)posItemDynRow, (String)"isbook")) continue;
                BigDecimal lineReceivableAmount = posItemDynRow.getBigDecimal("linereceivableamount");
                totalRealAmount = totalRealAmount.add(lineReceivableAmount);
            }
            if (isApplyAllItem) {
                if (totalRealAmount.compareTo(activateAmount) < 0) {
                    continue;
                }
            } else {
                long ticketTypeID = DynamicObjectUtils.getPkValue((DynamicObject)ticketInfoDyn, (String)"tickettypeid");
                DynamicObjectCollection ticketTypeDynArr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)olInvitationDyn, (String)"tickettypeentry");
                DynamicObject ticketTypeRowDyn = ticketTypeDynArr.stream().filter(item -> DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"tickettypeid") == ticketTypeID).findFirst().orElse(null);
                if (ticketTypeRowDyn == null) continue;
                DynamicObjectCollection itemDynArr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)ticketTypeRowDyn, (String)"usecondentryentity");
                posItemDynArr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
                HashMap<Long, BigDecimal> itemAmountMap = new HashMap<Long, BigDecimal>(0);
                for (DynamicObject posItemDynRow : posItemDynArr) {
                    if (DynamicObjectUtils.getBoolean((DynamicObject)posItemDynRow, (String)"isbook")) continue;
                    long itemID = DynamicObjectUtils.getPkValue((DynamicObject)posItemDynRow, (String)"goodsid");
                    BigDecimal lineReceivableAmount = posItemDynRow.getBigDecimal("linereceivableamount");
                    itemAmountMap.put(itemID, lineReceivableAmount);
                }
                BigDecimal totalAmount = BigDecimal.ZERO;
                for (DynamicObject itemDyn : itemDynArr) {
                    BigDecimal itemAmount = (BigDecimal)itemAmountMap.get(DynamicObjectUtils.getPkValue((DynamicObject)itemDyn, (String)"goods"));
                    totalAmount = itemAmount == null ? totalAmount : totalAmount.add(itemAmount);
                }
                if (totalAmount.compareTo(activateAmount) < 0) continue;
            }
            SaleOrderHelper.updatePosSaleOrder(ticketInfoDyn, saleOrder);
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{ticketInfoDyn});
            TicketsInfoHelper.saveActivateTicketActionFlow((DynamicObject)ticketInfoDyn, (DynamicObject)saleOrder, (OptionDirectEnum)OptionDirectEnum.OPTIONDIRECT_RIGHT, (TicketFlowOperTypeEnum)TicketFlowOperTypeEnum.TICKET_ACTIVATE, (String)"gcm_ticketactivate");
            break;
        }
    }

    public static void unActivateTicket(DynamicObject saleReturn) {
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleReturn, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return;
        }
        try {
            HashSet<Long> lstSrcBillId = new HashSet<Long>(0);
            for (DynamicObject doGoodsEntry : docGoodsEntry) {
                if (DynamicObjectUtils.getBoolean((DynamicObject)doGoodsEntry, (String)"ispresent")) continue;
                long entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"entrysrcbillid");
                lstSrcBillId.add(entrySrcBillId);
            }
            QFilter filter = new QFilter("Id", "in", (Object)lstSrcBillId.toArray());
            filter.and("isactivateticket", "=", (Object)Boolean.TRUE);
            filter.and("goodsentryentity.ispresent", "=", (Object)Boolean.FALSE);
            filter.and("goodsentryentity.isbook", "=", (Object)Boolean.FALSE);
            DynamicObjectCollection docSrcBill = QueryServiceHelper.query((String)"ocpos_saleorder", (String)"Id,isactivateticket,goodsentryentity.goodsid as goodsid,goodsentryentity.Id as srcbillentryid,goodsentryentity.linereceivableamount as linereceivableamount,goodsentryentity.linerefundamount as linerefundamount", (QFilter[])filter.toArray());
            if (docSrcBill == null || docSrcBill.size() == 0) {
                return;
            }
            lstSrcBillId.clear();
            ArrayList<DynamicObject> lstUpdateTicket = new ArrayList<DynamicObject>(0);
            docSrcBill.forEach(x -> lstSrcBillId.add(DynamicObjectUtils.getLong((DynamicObject)x, (String)"Id")));
            QFilter ticketFilter = new QFilter("olinvitateid", ">", (Object)0L);
            ticketFilter.and("ticketstatus", "=", (Object)TicketStatusEnum.SEND.getName());
            ticketFilter.and("activateposorderid", "in", (Object)lstSrcBillId.toArray());
            DynamicObject[] ticketInfoDynArr = BusinessDataServiceHelper.load((String)"ocdbd_ticketinfo", (String)"id,number,name,vipid,auditdate,ticketstatus,tickettypeid,olinvitateid,activateposorderid,activateposorderno", (QFilter[])ticketFilter.toArray());
            Map<Long, List<DynamicObject>> mapSrcBill = docSrcBill.stream().collect(Collectors.groupingBy(g -> DynamicObjectUtils.getLong((DynamicObject)g, (String)"Id")));
            for (Map.Entry<Long, List<DynamicObject>> entry : mapSrcBill.entrySet()) {
                long id = entry.getKey();
                List<DynamicObject> posItemDynArr = entry.getValue();
                List lstTicket = Arrays.stream(ticketInfoDynArr).filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"activateposorderid") == id).collect(Collectors.toList());
                if (lstTicket.size() == 0 || posItemDynArr.size() == 0) continue;
                for (DynamicObject ticketInfoDyn : lstTicket) {
                    DynamicObject olInvitationDyn = ticketInfoDyn.getDynamicObject("olinvitateid");
                    if (olInvitationDyn == null) continue;
                    boolean isApplyAllItem = olInvitationDyn.getBoolean("isallgoods");
                    BigDecimal activateAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)olInvitationDyn, (String)"activateamount");
                    if (isApplyAllItem) {
                        BigDecimal totalRealAmount = BigDecimal.ZERO;
                        for (DynamicObject posItemDynRow : posItemDynArr) {
                            if (DynamicObjectUtils.getBoolean((DynamicObject)posItemDynRow, (String)"isbook")) continue;
                            BigDecimal lineReceivableAmount = posItemDynRow.getBigDecimal("linereceivableamount");
                            long entryId = DynamicObjectUtils.getLong((DynamicObject)posItemDynRow, (String)"srcbillentryid");
                            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"srcbillentryid") == entryId).findFirst().orElse(null);
                            if (doGoodsEntry != null) {
                                BigDecimal retLineReceivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"linereceivableamount").abs();
                                lineReceivableAmount = lineReceivableAmount.subtract(retLineReceivableAmount);
                            } else {
                                BigDecimal lineRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)posItemDynRow, (String)"linerefundamount").abs();
                                lineReceivableAmount = lineReceivableAmount.subtract(lineRefundAmount);
                            }
                            totalRealAmount = totalRealAmount.add(lineReceivableAmount);
                        }
                        if (totalRealAmount.compareTo(activateAmount) >= 0) {
                            continue;
                        }
                    } else {
                        long ticketTypeID = DynamicObjectUtils.getPkValue((DynamicObject)ticketInfoDyn, (String)"tickettypeid");
                        DynamicObjectCollection ticketTypeDynArr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)olInvitationDyn, (String)"tickettypeentry");
                        DynamicObject ticketTypeRowDyn = ticketTypeDynArr.stream().filter(item -> DynamicObjectUtils.getPkValue((DynamicObject)item, (String)"tickettypeid") == ticketTypeID).findFirst().orElse(null);
                        if (ticketTypeRowDyn == null) continue;
                        DynamicObjectCollection itemDynArr = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)ticketTypeRowDyn, (String)"usecondentryentity");
                        HashMap<Long, BigDecimal> itemAmountMap = new HashMap<Long, BigDecimal>(0);
                        for (DynamicObject posItemDynRow : posItemDynArr) {
                            if (DynamicObjectUtils.getBoolean((DynamicObject)posItemDynRow, (String)"isbook")) continue;
                            long itemID = DynamicObjectUtils.getPkValue((DynamicObject)posItemDynRow, (String)"goodsid");
                            BigDecimal lineReceivableAmount = posItemDynRow.getBigDecimal("linereceivableamount");
                            long entryId = DynamicObjectUtils.getLong((DynamicObject)posItemDynRow, (String)"srcbillentryid");
                            DynamicObject doGoodsEntry = docGoodsEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"srcbillentryid") == entryId).findFirst().orElse(null);
                            if (doGoodsEntry != null) {
                                BigDecimal retLineReceivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"linereceivableamount").abs();
                                lineReceivableAmount = lineReceivableAmount.subtract(retLineReceivableAmount);
                            } else {
                                BigDecimal lineRefundAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)posItemDynRow, (String)"linerefundamount").abs();
                                lineReceivableAmount = lineReceivableAmount.subtract(lineRefundAmount);
                            }
                            itemAmountMap.put(itemID, lineReceivableAmount);
                        }
                        BigDecimal totalAmount = BigDecimal.ZERO;
                        for (DynamicObject itemDyn : itemDynArr) {
                            BigDecimal itemAmount = (BigDecimal)itemAmountMap.get(DynamicObjectUtils.getPkValue((DynamicObject)itemDyn, (String)"goods"));
                            totalAmount = itemAmount == null ? totalAmount : totalAmount.add(itemAmount);
                        }
                        if (totalAmount.compareTo(activateAmount) >= 0) continue;
                    }
                    ticketInfoDyn.set("ticketstatus", (Object)TicketStatusEnum.WAIT_ACTIVATE.getName());
                    ticketInfoDyn.set("activateposorderid", (Object)0L);
                    ticketInfoDyn.set("activateposorderno", (Object)"");
                    lstUpdateTicket.add(ticketInfoDyn);
                }
            }
            if (lstUpdateTicket.size() > 0) {
                for (DynamicObject ticketInfoDyn : lstUpdateTicket) {
                    ticketInfoDyn.set("activateposorderno", (Object)DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"billno"));
                    TicketsInfoHelper.saveActivateTicketActionFlow((DynamicObject)ticketInfoDyn, (DynamicObject)saleReturn, (OptionDirectEnum)OptionDirectEnum.OPTIONDIRECT_NEG, (TicketFlowOperTypeEnum)TicketFlowOperTypeEnum.TICKET_ACTIVATE, (String)"gcm_ticketactivate");
                    ticketInfoDyn.set("activateposorderno", (Object)"");
                }
                SaveServiceHelper.save((DynamicObject[])lstUpdateTicket.toArray(new DynamicObject[0]));
            }
        }
        catch (Exception e) {
            logger.error("\u96f6\u552e\u9000\u8d27\u5355\u5355\u53f7\uff1a" + DynamicObjectUtils.getString((DynamicObject)saleReturn, (String)"billno") + "\u793c\u5238\u53cd\u6fc0\u6d3b\u5931\u8d25" + e.getStackTrace());
        }
    }

    private static void updatePosSaleOrder(DynamicObject ticketInfoDyn, DynamicObject posSaleOrderDyn) {
        ticketInfoDyn.set("ticketstatus", (Object)TicketStatusEnum.SEND.getName());
        ticketInfoDyn.set("activateposorderid", posSaleOrderDyn.getPkValue());
        ticketInfoDyn.set("activateposorderno", (Object)posSaleOrderDyn.getString("billno"));
        posSaleOrderDyn.set("isactivateticket", (Object)Boolean.TRUE);
    }

    public static Map<String, Object> getReturnRuleDiscountAmount(DynamicObject saleOrder, boolean isChange) {
        boolean checkStatus = true;
        boolean checkPoint = true;
        boolean isPointEqualsValueDed = false;
        boolean isPointCustCstp = false;
        boolean isTicketEqualsValueDed = false;
        boolean isTicketCustCstp = false;
        BigDecimal ticketDiscountAmt = BigDecimal.ZERO;
        BigDecimal integralDiscountAmt = BigDecimal.ZERO;
        StringBuilder msgTicket = new StringBuilder();
        StringBuilder msgPoint = new StringBuilder();
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"notconfirm");
        String changeItemType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"changeitemtype");
        if (isNotConfirm) {
            return null;
        }
        if (isChange && !StringUtils.equals((CharSequence)"2", (CharSequence)changeItemType)) {
            return null;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        String pointReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)branchId, (String)"pointreturnmode");
        String ticketReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)branchId, (String)"cashcouponreturnmode");
        if (ticketReturnMode.equals(ReturnModelEnum.CustomerCompensation.getValue()) || ticketReturnMode.equals(ReturnModelEnum.DeductionByValue.getValue())) {
            ticketDiscountAmt = SaleOrderHelper.getDiscountAmount(saleOrder, "coupondiscount", isChange);
            if (ticketReturnMode.equals(ReturnModelEnum.CustomerCompensation.getValue())) {
                isTicketCustCstp = true;
            } else if (ticketReturnMode.equals(ReturnModelEnum.DeductionByValue.getValue())) {
                isTicketEqualsValueDed = true;
            }
        }
        if (pointReturnMode.equals(ReturnModelEnum.CustomerCompensation.getValue()) || pointReturnMode.equals(ReturnModelEnum.DeductionByValue.getValue())) {
            integralDiscountAmt = SaleOrderHelper.getDiscountAmount(saleOrder, "integraldistamount", isChange);
            if (pointReturnMode.equals(ReturnModelEnum.CustomerCompensation.getValue())) {
                isPointCustCstp = true;
            } else if (pointReturnMode.equals(ReturnModelEnum.DeductionByValue.getValue())) {
                isPointEqualsValueDed = true;
            }
        }
        String bizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype");
        long initialBillId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"initialbillid");
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"sourcebillid");
        if (initialBillId == 0L) {
            return null;
        }
        if (sourceBillId == 0L) {
            return null;
        }
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return null;
        }
        ArrayList<Long> lstSourceBillId = new ArrayList<Long>(0);
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            long entrySrcBillId;
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)doGoodsEntry, (String)"ispresent");
            if (isPresent || lstSourceBillId.contains(entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"entrysrcbillid"))) continue;
            lstSourceBillId.add(entrySrcBillId);
        }
        if (CollectionUtils.isEmpty(lstSourceBillId)) {
            return null;
        }
        DynamicObjectType billDt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder");
        DynamicObject[] srcSaleOrderBills = BusinessDataServiceHelper.load((Object[])lstSourceBillId.toArray(), (DynamicObjectType)billDt);
        if (srcSaleOrderBills == null || srcSaleOrderBills.length == 0) {
            return null;
        }
        List<DynamicObject> lstSrcSaleOrderBills = Arrays.asList(srcSaleOrderBills);
        if (ticketDiscountAmt.compareTo(BigDecimal.ZERO) == 0) {
            checkStatus = SaleOrderHelper.checkTicketStatus(saleOrder, msgTicket);
        }
        if (integralDiscountAmt.compareTo(BigDecimal.ZERO) == 0) {
            checkPoint = SaleOrderHelper.checkPointBalance(saleOrder, msgPoint);
        }
        HashMap<String, BigDecimal> mapGiftValue = new HashMap<String, BigDecimal>(0);
        BigDecimal giftDiscountAmount = SaleOrderHelper.getGiftDiscountAmount(saleOrder, lstSrcSaleOrderBills, mapGiftValue, isChange);
        if (checkPoint && checkStatus && giftDiscountAmount.compareTo(BigDecimal.ZERO) == 0 && ticketDiscountAmt.compareTo(BigDecimal.ZERO) == 0 && integralDiscountAmt.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            DynamicObject doSrcGoodsEntry;
            long srcBillEntryId;
            long entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"entrysrcbillid");
            DynamicObject srcSaleOrder = lstSrcSaleOrderBills.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == entrySrcBillId).findFirst().orElse(null);
            if (srcSaleOrder == null) continue;
            boolean isContinue = false;
            DynamicObjectCollection docSrcGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)srcSaleOrder, (String)"goodsentryentity");
            DynamicObjectCollection docSrcTicketEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)srcSaleOrder, (String)"ticketsendentity");
            DynamicObjectCollection docSrcIntegralEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)srcSaleOrder, (String)"sendintegralentity");
            String seq = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"seq");
            if (!(isTicketCustCstp || isTicketEqualsValueDed || checkStatus)) {
                if (isChange) {
                    String saleOption = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"saleoption");
                    if (!StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                        isContinue = true;
                    }
                } else if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CANCELORDER.getValue()) && docSrcTicketEntry.stream().anyMatch(x -> Arrays.stream(DynamicObjectUtils.getString((DynamicObject)x, (String)"goodsseq").split(",")).collect(Collectors.toList()).contains(seq) && !DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"tisexecute"))) {
                    isContinue = true;
                }
                srcBillEntryId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"srcbillentryid");
                doSrcGoodsEntry = docSrcGoodsEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == srcBillEntryId).findFirst().orElse(null);
                if (doSrcGoodsEntry != null && DynamicObjectUtils.getBigDecimal((DynamicObject)doSrcGoodsEntry, (String)"coupondiscount").compareTo(DynamicObjectUtils.getBigDecimal((DynamicObject)doSrcGoodsEntry, (String)"adretcoupondiscamount").abs()) == 0) {
                    isContinue = true;
                }
                if (!isContinue) {
                    BigDecimal couponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"coupondiscount");
                    ticketDiscountAmt = ticketDiscountAmt.add(couponDiscount);
                }
            }
            isContinue = false;
            if (isPointCustCstp || isPointEqualsValueDed || checkPoint) continue;
            if (isChange) {
                String saleOption = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"saleoption");
                if (!StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                    isContinue = true;
                } else if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.CANCELORDER.getValue()) && docSrcIntegralEntry.stream().anyMatch(x -> Arrays.stream(DynamicObjectUtils.getString((DynamicObject)x, (String)"insgoodsseq").split(",")).collect(Collectors.toList()).contains(seq) && !DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"insisexecute"))) {
                    isContinue = true;
                }
            }
            srcBillEntryId = DynamicObjectUtils.getLong((DynamicObject)doGoodsEntry, (String)"srcbillentryid");
            doSrcGoodsEntry = docSrcGoodsEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == srcBillEntryId).findFirst().orElse(null);
            if (doSrcGoodsEntry != null && DynamicObjectUtils.getBigDecimal((DynamicObject)doSrcGoodsEntry, (String)"integraldistamount").compareTo(DynamicObjectUtils.getBigDecimal((DynamicObject)doSrcGoodsEntry, (String)"adretintegraldistamount").abs()) == 0) {
                isContinue = true;
            }
            if (isContinue) continue;
            BigDecimal integralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)"integraldistamount");
            integralDiscountAmt = integralDiscountAmt.add(integralDistAmount);
        }
        if (ticketDiscountAmt.compareTo(BigDecimal.ZERO) == 0 && integralDiscountAmt.compareTo(BigDecimal.ZERO) == 0 && giftDiscountAmount.compareTo(BigDecimal.ZERO) == 0) {
            return null;
        }
        BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)saleOrder, (String)"sumbalamount");
        HashMap<String, Object> mapResult = new HashMap<String, Object>(0);
        mapResult.put("giftdiscountamount", giftDiscountAmount);
        mapResult.put("coupondiscount", ticketDiscountAmt);
        mapResult.put("integraldistamount", integralDiscountAmt);
        mapResult.put("receivableamount", receivableAmount);
        mapResult.put("pointreturnmode", pointReturnMode);
        mapResult.put("cashcouponreturnmode", ticketReturnMode);
        mapResult.put("giftvalue", mapGiftValue);
        return mapResult;
    }

    public static BigDecimal getGiftDiscountAmount(DynamicObject saleOrder, List<DynamicObject> lstSrcSaleOrderBills, Map<String, BigDecimal> mapGiftValue, boolean isChange) {
        DynamicObjectCollection goodsEntryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntryData)) {
            return BigDecimal.ZERO;
        }
        DynamicObjectCollection giftEntryData = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsendentity");
        BigDecimal giftDiscountAmount = BigDecimal.ZERO;
        for (DynamicObject goodsEntry : goodsEntryData) {
            BigDecimal srcGiftDiscAmount;
            DynamicObjectCollection docSrcGoodsEntry;
            if (isChange) {
                String saleOption = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"saleoption");
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntry, (String)"ispresent");
                if (!StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || isPresent) continue;
            }
            long entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)goodsEntry, (String)"entrysrcbillid");
            DynamicObject srcSaleOrder = lstSrcSaleOrderBills.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == entrySrcBillId).findFirst().orElse(null);
            if (srcSaleOrder == null || CollectionUtils.isEmpty((Collection)(docSrcGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)srcSaleOrder, (String)"goodsentryentity")))) continue;
            long srcBillEntryId = DynamicObjectUtils.getLong((DynamicObject)goodsEntry, (String)"srcbillentryid");
            DynamicObject srcGoodsEntry = docSrcGoodsEntry.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == srcBillEntryId).findFirst().orElse(null);
            if (srcGoodsEntry == null) continue;
            BigDecimal srcGiftQty = BigDecimal.ZERO;
            BigDecimal giftQty = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)giftEntryData)) {
                String seq = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"seq");
                for (DynamicObject giftData : giftEntryData) {
                    String goodsSeq = DynamicObjectUtils.getString((DynamicObject)giftData, (String)"sendgoodsseq");
                    if (StringUtils.isEmpty((CharSequence)goodsSeq) || !Arrays.asList(goodsSeq.split(",")).contains(seq)) continue;
                    srcGiftQty = srcGiftQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)giftData, (String)"sendqty"));
                    int goodsSendSeq = DynamicObjectUtils.getInt((DynamicObject)giftData, (String)"seq");
                    DynamicObject goodsSendEntry = goodsEntryData.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"promoteseq") == goodsSendSeq && DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype").equals(GiftTypeEnum.MANUALNEW.getValue())).findFirst().orElse(null);
                    if (goodsSendEntry == null) continue;
                    giftQty = giftQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)goodsSendEntry, (String)"saleqty"));
                }
            }
            DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)srcGoodsEntry, (String)"salesorderpromote");
            BigDecimal promoteQty = BigDecimal.ZERO;
            BigDecimal goodsQty = BigDecimal.ZERO;
            if (!CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
                for (DynamicObject doPromoteEntry : docPromoteEntry) {
                    DynamicObject goodsData;
                    if (DynamicObjectUtils.getDynamicObject((DynamicObject)doPromoteEntry, (String)"promotegoodsid") == null) continue;
                    int promoteGoodsSeq = DynamicObjectUtils.getInt((DynamicObject)doPromoteEntry, (String)"promotegoodsseq");
                    if (promoteGoodsSeq > 0 && (goodsData = (DynamicObject)goodsEntryData.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == promoteGoodsSeq && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue())).findFirst().orElse(null)) != null) {
                        goodsQty = goodsQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)goodsData, (String)"saleqty"));
                    }
                    promoteQty = promoteQty.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doPromoteEntry, (String)"promotsaleqty"));
                }
            }
            if ((srcGiftDiscAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)srcGoodsEntry, (String)"giftdiscountamount").negate()).compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal srcAdRetGiftDiscAmt = DynamicObjectUtils.getBigDecimal((DynamicObject)srcGoodsEntry, (String)"adretgiftdiscamount");
            BigDecimal mustRetQty = DynamicObjectUtils.getBigDecimal((DynamicObject)goodsEntry, (String)"mustretqty");
            BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)goodsEntry, (String)"saleqty");
            if (srcGiftDiscAmount.compareTo(srcAdRetGiftDiscAmt) == 0 || mustRetQty.compareTo(BigDecimal.ZERO) == 0) continue;
            boolean isPromoteQty = false;
            if (promoteQty.abs().compareTo(goodsQty.abs()) == 0) {
                isPromoteQty = true;
            }
            boolean isGiftQty = false;
            if (srcGiftQty.abs().compareTo(giftQty.abs()) == 0) {
                isGiftQty = true;
            }
            if (isGiftQty && isPromoteQty) continue;
            String goodsSeq = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"seq");
            BigDecimal giftAmount = srcGiftDiscAmount.subtract(srcAdRetGiftDiscAmt);
            if (giftAmount.compareTo(BigDecimal.ZERO) >= 0) continue;
            BigDecimal lineDiscountAmount = mustRetQty.compareTo(saleQty) == 0 ? giftAmount : giftAmount.divide(mustRetQty, 2, RoundingMode.HALF_UP).multiply(saleQty);
            mapGiftValue.put(goodsSeq, lineDiscountAmount);
            giftDiscountAmount = giftDiscountAmount.add(lineDiscountAmount);
        }
        return giftDiscountAmount;
    }

    public static BigDecimal getSumAmount(String[] goodsSeqArray, DynamicObjectCollection goodsEntry, String key) {
        if (CollectionUtils.isEmpty((Collection)goodsEntry)) {
            return BigDecimal.ZERO;
        }
        BigDecimal sumAmount = BigDecimal.ZERO;
        for (String goodsSeq : goodsSeqArray) {
            DynamicObject doGoodsEntry = goodsEntry.stream().filter(x -> goodsSeq.equals(DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"))).findFirst().orElse(null);
            if (doGoodsEntry == null) continue;
            sumAmount = sumAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)key));
        }
        return sumAmount;
    }

    public static boolean checkTicketStatus(DynamicObject saleOrder, StringBuilder msg) {
        boolean isNotConfirm = DynamicObjectUtils.getBoolean((DynamicObject)saleOrder, (String)"notconfirm");
        if (isNotConfirm) {
            return true;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        String bizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype");
        if (StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            return true;
        }
        long initialBillId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"initialbillid");
        if (initialBillId == 0L) {
            return false;
        }
        DynamicObject initSaleOrder = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder");
        String cashCoupOnReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)branchId, (String)"cashcouponreturnmode");
        if (StringUtils.equals((CharSequence)cashCoupOnReturnMode, (CharSequence)ReturnModelEnum.FixedRules.getValue())) {
            DynamicObjectType billDt;
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                logger.error("\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a");
                return false;
            }
            Object[] lstId = entryEntities.stream().map(x -> x.getLong("entrysrcbillid")).toArray();
            DynamicObject[] srcSaleOrderBills = BusinessDataServiceHelper.load((Object[])lstId, (DynamicObjectType)(billDt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder")));
            if (srcSaleOrderBills.length == 0) {
                logger.error("\u672a\u83b7\u53d6\u5230\u6e90\u5355\u4fe1\u606f");
                return false;
            }
            ArrayList<Long> lstExeBillId = new ArrayList<Long>(0);
            ArrayList<Long> lstTicketTypeId = new ArrayList<Long>(0);
            BigDecimal ticketQty = SaleOrderHelper.checkSendEntry(initSaleOrder, saleOrder, "ticketsendentity", "ticketexebillid", "tickettype", "coupontype", "qty", "goodsseq", "ticketrettype", lstExeBillId, null, null, lstTicketTypeId, null, null);
            if (CollectionUtils.isEmpty(lstExeBillId) || CollectionUtils.isEmpty(lstTicketTypeId) || ticketQty.compareTo(BigDecimal.ZERO) == 0) {
                return false;
            }
            QFilter qFilter = new QFilter("giftbillid", "in", (Object)lstExeBillId.toArray());
            qFilter.and("ticketstatus", "=", (Object)TicketStatusEnum.SEND.getName());
            qFilter.and("tickettypeid", "in", (Object)lstTicketTypeId.toArray());
            DynamicObjectCollection tickets = QueryServiceHelper.query((String)"ocdbd_ticketinfo", (String)"id", (QFilter[])qFilter.toArray());
            if (CollectionUtils.isEmpty((Collection)tickets) || CommonUtil.formatObjectToDecimal((Object)tickets.size()).compareTo(ticketQty) < 0) {
                msg.append("\u8d60\u9001\u7684\u4f18\u60e0\u5238\u5df2\u88ab\u6838\u9500\u4f7f\u7528\uff0c\u8bf7\u9009\u62e9\u4f18\u60e0\u5904\u7406\uff01");
            }
            return msg.length() <= 0;
        }
        return true;
    }

    private static BigDecimal checkSendEntry(DynamicObject initSaleOrder, DynamicObject saleReturn, String sendEntityKey, String exeBillIdKey, String sendTypeKey, String promoteSendTypeKey, String sendQtyKey, String exeSeqKey, String retTypeKey, List<Long> lstExeBillId, Map<Integer, Object> seqSyncRetTypeValue, Map<Integer, Object> seqPromoteSyncRetTypeValue, List<Long> lstSendTypeId, List<DynamicObject> lstSend, List<DynamicObject> lstPromote) {
        BigDecimal sendQty = BigDecimal.ZERO;
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleReturn, (String)"goodsentryentity");
        DynamicObjectCollection iniGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"goodsentryentity");
        DynamicObjectCollection docSendEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleReturn, (String)sendEntityKey);
        DynamicObjectCollection iniSendEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)sendEntityKey);
        if (CollectionUtils.isEmpty((Collection)iniGoodsEntryCollection) || CollectionUtils.isEmpty((Collection)entryEntities)) {
            return sendQty;
        }
        ArrayList<Integer> lstSendSeq = new ArrayList<Integer>(0);
        ArrayList<String> lstPromoteData = new ArrayList<String>(0);
        for (DynamicObject doGoodsEntry : entryEntities) {
            List lstPromoteEntry;
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)doGoodsEntry, (String)"ispresent");
            if (isPresent) continue;
            String iniSrcSeqStr = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"inisrcseq");
            List lstSendEntry = iniSendEntryCollection.stream().filter(x -> Arrays.asList(StringUtils.split((String)DynamicObjectUtils.getString((DynamicObject)x, (String)exeSeqKey), (String)",")).contains(iniSrcSeqStr)).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty(lstSendEntry)) {
                for (DynamicObject sendEntry : lstSendEntry) {
                    DynamicObject doSendEntry;
                    long exeBillId = DynamicObjectUtils.getLong((DynamicObject)sendEntry, (String)exeBillIdKey);
                    int seq = DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"seq");
                    long sendTypeId = DynamicObjectUtils.getPkValue((DynamicObject)sendEntry, (String)sendTypeKey);
                    if (exeBillId <= 0L) continue;
                    String retType = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)retTypeKey);
                    if (!lstSendSeq.contains(seq) && StringUtils.isEmpty((CharSequence)retType)) {
                        BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)sendEntry, (String)sendQtyKey);
                        sendQty = sendQty.add(qty);
                        lstSendSeq.add(seq);
                        if (!lstSendTypeId.contains(sendTypeId) && sendTypeId > 0L) {
                            lstSendTypeId.add(sendTypeId);
                        }
                        if (!lstExeBillId.contains(exeBillId)) {
                            lstExeBillId.add(exeBillId);
                        }
                        if (seqSyncRetTypeValue != null) {
                            seqSyncRetTypeValue.put(DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"seq"), "R");
                            DynamicObject doSendEntry2 = docSendEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == seq).findFirst().orElse(null);
                            if (doSendEntry2 != null) {
                                doSendEntry2.set(retTypeKey, (Object)"R");
                            }
                            if (lstSend != null) {
                                lstSend.add(sendEntry);
                            }
                        }
                    }
                    if (!StringUtils.equals((CharSequence)retType, (CharSequence)"R") || seqSyncRetTypeValue == null || (doSendEntry = (DynamicObject)docSendEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == seq).findFirst().orElse(null)) == null) continue;
                    doSendEntry.set(retTypeKey, (Object)"R");
                }
            }
            int iniSrcSeq = DynamicObjectUtils.getInt((DynamicObject)doGoodsEntry, (String)"inisrcseq");
            DynamicObject iniGoodsEntry = iniGoodsEntryCollection.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == iniSrcSeq).findFirst().orElse(null);
            if (iniGoodsEntry == null) continue;
            DynamicObjectCollection iniPromoteEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniGoodsEntry, (String)"salesorderpromote");
            DynamicObjectCollection docPromoteEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
            if (CollectionUtils.isEmpty((Collection)iniPromoteEntryCollection) || CollectionUtils.isEmpty((Collection)docPromoteEntryCollection) || CollectionUtils.isEmpty(lstPromoteEntry = iniPromoteEntryCollection.stream().filter(x -> DynamicObjectUtils.get((DynamicObject)x, (String)promoteSendTypeKey) != null).collect(Collectors.toList()))) continue;
            int subSeq = 0;
            for (DynamicObject promoteEntry : lstPromoteEntry) {
                DynamicObject doPromoteEntry;
                ++subSeq;
                long exeBillId = DynamicObjectUtils.getLong((DynamicObject)promoteEntry, (String)"promoteexebillid");
                long sendTypeId = DynamicObjectUtils.getPkValue((DynamicObject)promoteEntry, (String)promoteSendTypeKey);
                long promotionId = DynamicObjectUtils.getLong((DynamicObject)promoteEntry, (String)"promotionactid");
                String exeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)promoteEntry, (String)"exegoodsseq");
                String strPromoteData = promotionId + promotionId + exeGoodsSeq;
                if (exeBillId <= 0L) continue;
                String promoteRetType = DynamicObjectUtils.getString((DynamicObject)promoteEntry, (String)"promoterettype");
                if (!lstPromoteData.contains(strPromoteData) && StringUtils.isEmpty((CharSequence)promoteRetType)) {
                    BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)promoteEntry, (String)"promotsaleqty");
                    sendQty = sendQty.add(qty);
                    lstPromoteData.add(strPromoteData);
                    if (!lstSendTypeId.contains(sendTypeId) && sendTypeId > 0L) {
                        lstSendTypeId.add(sendTypeId);
                    }
                    if (!lstExeBillId.contains(exeBillId)) {
                        lstExeBillId.add(exeBillId);
                    }
                    if (seqPromoteSyncRetTypeValue != null) {
                        promoteEntry.set("promoterettype", (Object)"R");
                        if (StringUtils.isEmpty((CharSequence)promoteRetType)) {
                            seqPromoteSyncRetTypeValue.put(iniSrcSeq + subSeq, promoteEntry);
                            DynamicObject doPromoteEntry2 = docPromoteEntryCollection.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"iniexegoodsseq"), (CharSequence)exeGoodsSeq) && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)promoteSendTypeKey) == sendTypeId).findFirst().orElse(null);
                            if (doPromoteEntry2 != null) {
                                doPromoteEntry2.set("promoterettype", (Object)"R");
                            }
                            if (lstPromote != null) {
                                lstPromote.add(promoteEntry);
                            }
                        }
                    }
                }
                if (!StringUtils.equals((CharSequence)promoteRetType, (CharSequence)"R") || seqPromoteSyncRetTypeValue == null || (doPromoteEntry = (DynamicObject)docPromoteEntryCollection.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"iniexegoodsseq"), (CharSequence)exeGoodsSeq) && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)promoteSendTypeKey) == sendTypeId).findFirst().orElse(null)) == null) continue;
                doPromoteEntry.set("promoterettype", (Object)"R");
            }
        }
        return sendQty;
    }

    public static boolean checkPointBalance(DynamicObject saleOrder, StringBuilder msg) {
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid");
        String bizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"biztype");
        String pointReturnMode = SystemParamUtil.getReturnMode((long)orgId, (long)branchId, (String)"pointreturnmode");
        if (StringUtils.equals((CharSequence)pointReturnMode, (CharSequence)ReturnModelEnum.FixedRules.getValue()) && !StringUtils.equals((CharSequence)bizType, (CharSequence)BizTypeEnum.NOSRCRETURN.getValue())) {
            long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"sourcebillid");
            long initialBillId = DynamicObjectUtils.getLong((DynamicObject)saleOrder, (String)"initialbillid");
            if (sourceBillId == 0L || initialBillId == 0L) {
                logger.error("\u672a\u83b7\u53d6\u5230\u6e90\u5355id");
                return false;
            }
            DynamicObject initSaleOrder = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder");
            ArrayList<DynamicObject> lstPromote = new ArrayList<DynamicObject>(0);
            HashMap<Long, Map<Long, BigDecimal>> mapVipPoint = new HashMap<Long, Map<Long, BigDecimal>>(0);
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
            DynamicObjectCollection docSendPoint = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"sendintegralentity");
            DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
                return true;
            }
            HashMap<Long, BigDecimal> pointTypeValue = new HashMap<Long, BigDecimal>(0);
            ArrayList<DynamicObject> lstVip = new ArrayList<DynamicObject>(0);
            DynamicObject doMember = DynamicObjectUtils.getDynamicObject((DynamicObject)initSaleOrder, (String)"member");
            long memberId = DynamicObjectUtils.getPkValue((DynamicObject)doMember);
            lstVip.add(doMember);
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection docPromoteEntry;
                DynamicObject doGoodsEntry;
                boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
                if (isPresent) continue;
                String iniSrcSeq = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"inisrcseq");
                List lstSendPoint = docSendPoint.stream().filter(x -> Arrays.asList(StringUtils.split((String)DynamicObjectUtils.getString((DynamicObject)x, (String)"insgoodsseq"), (String)",")).contains(iniSrcSeq)).collect(Collectors.toList());
                if (!CollectionUtils.isEmpty(lstSendPoint)) {
                    for (DynamicObject doPointEntry : lstSendPoint) {
                        DynamicObject doSendMember = DynamicObjectUtils.getDynamicObject((DynamicObject)doPointEntry, (String)"insmember");
                        long sendVipId = DynamicObjectUtils.getPkValue((DynamicObject)doSendMember);
                        long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPointEntry, (String)"insmempointtype");
                        BigDecimal sendPoint = DynamicObjectUtils.getBigDecimal((DynamicObject)doPointEntry, (String)"insintegral");
                        String pointRetType = DynamicObjectUtils.getString((DynamicObject)doPointEntry, (String)"pointrettype");
                        if (!StringUtils.isEmpty((CharSequence)pointRetType)) continue;
                        if (sendVipId == memberId && pointTypeValue.size() > 0) {
                            pointTypeValue.merge(pointTypeId, sendPoint, BigDecimal::add);
                        } else {
                            Map mapPointType = (Map)mapVipPoint.get(sendVipId);
                            SaleOrderHelper.mapSendPoint(mapPointType, pointTypeValue, mapVipPoint, pointTypeId, sendPoint, sendVipId);
                        }
                        if (lstVip.contains(doSendMember)) continue;
                        lstVip.add(doSendMember);
                    }
                }
                if ((doGoodsEntry = (DynamicObject)docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)iniSrcSeq)).findFirst().orElse(null)) == null || CollectionUtils.isEmpty((Collection)(docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote")))) continue;
                for (DynamicObject doPromoteEntry : docPromoteEntry) {
                    String promoteRetType;
                    long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromoteEntry, (String)"pointtype");
                    long promoteId = DynamicObjectUtils.getLong((DynamicObject)doPromoteEntry, (String)"promotionactid");
                    if (pointTypeId == 0L || !StringUtils.isEmpty((CharSequence)(promoteRetType = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promoterettype"))) || !lstPromote.stream().noneMatch(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promoteId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId)) continue;
                    lstPromote.add(doPromoteEntry);
                }
            }
            if (CollectionUtils.isEmpty((Collection)docSendPoint) && CollectionUtils.isEmpty(lstPromote)) {
                return false;
            }
            for (DynamicObject doPromote : lstPromote) {
                long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"pointtype");
                BigDecimal sendPoint = DynamicObjectUtils.getBigDecimal((DynamicObject)doPromote, (String)"promotsaleqty");
                if (pointTypeValue.size() > 0) {
                    pointTypeValue.merge(pointTypeId, sendPoint, BigDecimal::add);
                    continue;
                }
                Map mapPointType = (Map)mapVipPoint.get(memberId);
                SaleOrderHelper.mapSendPoint(mapPointType, pointTypeValue, mapVipPoint, pointTypeId, sendPoint, memberId);
            }
            if (pointTypeValue.size() <= 0) {
                return false;
            }
            mapVipPoint.put(memberId, pointTypeValue);
            if (mapVipPoint.size() == 0) {
                return false;
            }
            Map<Long, String> vipMsg = SaleOrderHelper.checkVipPointBalance(mapVipPoint);
            if (vipMsg.size() > 0) {
                for (Map.Entry<Long, String> entry : vipMsg.entrySet()) {
                    DynamicObject doVip = lstVip.stream().filter(x -> DynamicObjectUtils.getPkValue((DynamicObject)x) == (Long)entry.getKey()).findFirst().orElse(null);
                    if (ObjectUtils.isEmpty((Object)doVip)) continue;
                    String vipName = DynamicObjectUtils.getString((DynamicObject)doVip, (String)"name");
                    msg.append(String.format("\u4f1a\u5458\uff1a\u3010%s\u3011,", vipName));
                    msg.append(vipMsg.get(entry.getKey()));
                }
            }
            return msg.length() <= 0;
        }
        return true;
    }

    private static void mapSendPoint(Map<Long, BigDecimal> mapPointType, Map<Long, BigDecimal> pointTypeValue, Map<Long, Map<Long, BigDecimal>> mapVipPoint, long pointTypeId, BigDecimal sendPoint, long vipId) {
        if (mapPointType != null) {
            pointTypeValue.merge(pointTypeId, sendPoint, BigDecimal::add);
        } else {
            mapPointType = new HashMap<Long, BigDecimal>(0);
            mapPointType.put(pointTypeId, sendPoint);
            mapVipPoint.put(vipId, mapPointType);
            pointTypeValue.put(pointTypeId, sendPoint);
        }
    }

    public static BigDecimal getDiscountAmount(DynamicObject saleOrder, String discountAmountKey, boolean isChange) {
        BigDecimal discountAmount = BigDecimal.ZERO;
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)saleOrder, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry)) {
            return BigDecimal.ZERO;
        }
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            String saleOption;
            if (isChange && !StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)doGoodsEntry, (String)"saleoption")), (CharSequence)"0")) continue;
            discountAmount = discountAmount.add(DynamicObjectUtils.getBigDecimal((DynamicObject)doGoodsEntry, (String)discountAmountKey));
        }
        return discountAmount;
    }

    public static Map<Long, String> checkVipPointBalance(Map<Long, Map<Long, BigDecimal>> mapVipPoint) {
        HashMap<Long, String> vipMsg = new HashMap<Long, String>(0);
        ArrayList vipIds = new ArrayList(0);
        mapVipPoint.forEach((key, value) -> vipIds.add(key));
        if (vipIds.size() > 0) {
            JSONObject jResult;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("memberIdList", vipIds);
            jsonObject.put("pointTypeIdList", (Object)new Long[0]);
            Object result = DispatchServiceHelper.invokeBizService((String)"occ", (String)"ocric", (String)"PointRightsService", (String)"queryPointSavingByMemberIdList", (Object[])new Object[]{jsonObject});
            if (result instanceof JSONObject && StringUtils.equals((CharSequence)((String)(jResult = (JSONObject)result).get((Object)"code")), (CharSequence)"0")) {
                JSONObject data = jResult.getJSONObject("data");
                for (Map.Entry<Long, Map<Long, BigDecimal>> entry : mapVipPoint.entrySet()) {
                    JSONArray pointTypeArray;
                    StringBuilder msg = new StringBuilder();
                    String memberId = entry.getKey().toString();
                    Map<Long, BigDecimal> mapPoint = entry.getValue();
                    ArrayList pointTypeIdList = new ArrayList(0);
                    mapPoint.forEach((key, value) -> pointTypeIdList.add(key));
                    if (!data.containsKey((Object)memberId) || (pointTypeArray = data.getJSONArray(memberId)) == null || pointTypeArray.size() == 0) continue;
                    for (Object dataItem : pointTypeArray) {
                        JSONObject pointTypeItem = (JSONObject)dataItem;
                        long pointTypeId = CommonUtil.formatObejctToLong((Object)pointTypeItem.get((Object)"pointTypeId"));
                        if (!pointTypeIdList.contains(pointTypeId)) continue;
                        String pointTypeName = (String)pointTypeItem.get((Object)"pointTypeName");
                        int pointValue = CommonUtil.formatObjectToInt((Object)pointTypeItem.get((Object)"availableQty"));
                        BigDecimal dPoint = mapPoint.get(pointTypeId);
                        if (dPoint != null) {
                            int point = CommonUtil.formatObjectToInt((Object)dPoint);
                            if (pointValue >= point) continue;
                            msg.append(String.format("\u79ef\u5206\u7c7b\u578b:\u3010%s\u3011,\u79ef\u5206\u4f59\u989d\u4e0d\u8db3\u3002", pointTypeName));
                            continue;
                        }
                        msg.append(String.format("\u79ef\u5206\u7c7b\u578b:\u3010%s\u3011,\u79ef\u5206\u4f59\u989d\u4e0d\u8db3\u3002", pointTypeName));
                    }
                    if (msg.length() <= 0) continue;
                    vipMsg.put(entry.getKey(), msg.toString());
                }
            }
        }
        return vipMsg;
    }

    public static void refreshGoodsSeq(DynamicObject dataEntity, String entityId) {
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder")) {
            return;
        }
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        DynamicObjectCollection docPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"promotionentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry) || CollectionUtils.isEmpty((Collection)docPromoteEntry)) {
            return;
        }
        List lstPromoteEntry = docPromoteEntry.stream().filter(x -> DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"execute")).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(lstPromoteEntry)) {
            return;
        }
        for (DynamicObject doPromoteEntry : lstPromoteEntry) {
            DynamicObject doPromoteType = DynamicObjectUtils.getDynamicObject((DynamicObject)doPromoteEntry, (String)"promotiontype");
            String promoteType = DynamicObjectUtils.getString((DynamicObject)doPromoteType, (String)"number");
            long promotionId = DynamicObjectUtils.getLong((DynamicObject)doPromoteEntry, (String)"promotionid");
            String promoteGoodsSeq = DynamicObjectUtils.getString((DynamicObject)doPromoteEntry, (String)"promotiongoodseq");
            if (!StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-031") && !StringUtils.equals((CharSequence)promoteType, (CharSequence)"PM-006") && !StringUtils.equals((CharSequence)promoteType, (CharSequence)PromotionEnum.AMT_ITEM.getPromoteType())) continue;
            int promoteSeq = DynamicObjectUtils.getInt((DynamicObject)doPromoteEntry, (String)"seq");
            List lstGoodsEntry = docGoodsEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"promoteseq") == promoteSeq && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue()) && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"ispresent")).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(lstGoodsEntry)) continue;
            for (DynamicObject doGoodsEntry : lstGoodsEntry) {
                int seq = DynamicObjectUtils.getInt((DynamicObject)doGoodsEntry, (String)"seq");
                long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)doGoodsEntry, (String)"goodsid");
                String[] goodsSeqArray = promoteGoodsSeq.split(",");
                if (goodsSeqArray.length == 0) continue;
                for (String goodsSeq : goodsSeqArray) {
                    DynamicObjectCollection docPromote;
                    DynamicObject singleGoodsEntry = docGoodsEntry.stream().filter(x -> StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"seq"), (CharSequence)goodsSeq)).findFirst().orElse(null);
                    if (singleGoodsEntry == null || CollectionUtils.isEmpty((Collection)(docPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)singleGoodsEntry, (String)"salesorderpromote")))) continue;
                    for (DynamicObject doPromote : docPromote) {
                        long promoteId = DynamicObjectUtils.getLong((DynamicObject)doPromote, (String)"promotionactid");
                        long promoteGoodsId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"promotegoodsid");
                        if (promoteId != promotionId || promoteGoodsId != goodsId) continue;
                        doPromote.set("promotegoodsseq", (Object)seq);
                    }
                }
            }
        }
    }

    public static void refreshRetGoodsSeq(DynamicObject dataEntity, String entityId) {
        if (!StringUtils.equals((CharSequence)entityId, (CharSequence)"ocpos_saleorder_return")) {
            return;
        }
        long initSaleOrderId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"initialbillid");
        if (initSaleOrderId == 0L) {
            return;
        }
        DynamicObject initSaleOrder = BusinessDataServiceHelper.loadSingle((Object)initSaleOrderId, (String)"ocpos_saleorder");
        DynamicObjectCollection docGoodsEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        DynamicObjectCollection docInitPromoteEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initSaleOrder, (String)"promotionentity");
        if (CollectionUtils.isEmpty((Collection)docGoodsEntry) && CollectionUtils.isEmpty((Collection)docInitPromoteEntry)) {
            return;
        }
        for (DynamicObject doGoodsEntry : docGoodsEntry) {
            DynamicObjectCollection docPromote = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)doGoodsEntry, (String)"salesorderpromote");
            if (CollectionUtils.isEmpty((Collection)docPromote)) continue;
            for (DynamicObject doPromote : docPromote) {
                long promoteGoodsId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"promotegoodsid");
                if (promoteGoodsId == 0L) continue;
                long promoteId = DynamicObjectUtils.getLong((DynamicObject)doPromote, (String)"promotionactid");
                DynamicObject doInitPromoteEntry = docInitPromoteEntry.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionid") == promoteId).findFirst().orElse(null);
                if (doInitPromoteEntry == null) continue;
                int promoteSeq = DynamicObjectUtils.getInt((DynamicObject)doInitPromoteEntry, (String)"seq");
                List lstGoodsEntry = docGoodsEntry.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"promoteseq") == promoteSeq && StringUtils.equals((CharSequence)DynamicObjectUtils.getString((DynamicObject)x, (String)"gifttype"), (CharSequence)GiftTypeEnum.PROMOTENEW.getValue()) && DynamicObjectUtils.getBoolean((DynamicObject)x, (String)"ispresent")).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(lstGoodsEntry)) {
                    doPromote.set("promotegoodsseq", (Object)0);
                    continue;
                }
                for (DynamicObject goodsEntryItem : lstGoodsEntry) {
                    long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)goodsEntryItem, (String)"goodsid");
                    if (goodsId != promoteGoodsId) continue;
                    int seq = DynamicObjectUtils.getInt((DynamicObject)goodsEntryItem, (String)"seq");
                    doPromote.set("promotegoodsseq", (Object)seq);
                }
            }
        }
    }

    public static DynamicObjectCollection queryDelivery(List<Object> lstDetailId) {
        QFilter filter = new QFilter("goodsentryentity.salesorderdelivery.Id", "in", (Object)lstDetailId.toArray());
        String selectFields = "Id,billno,goodsentryentity.mustretqty,goodsentryentity.salesorderdelivery.deliverisdelivery,goodsentryentity.salesorderdelivery.signstatus";
        return QueryServiceHelper.query((String)"ocpos_saleorder", (String)selectFields, (QFilter[])filter.toArray());
    }

    public static DynamicObjectCollection queryReturnDelivery(List<Object> lstDetailId) {
        QFilter filter = new QFilter("goodsentryentity.salesorderdelivery.Id", "in", (Object)lstDetailId.toArray());
        String selectFields = "Id,billno,goodsentryentity.mustretqty,goodsentryentity.salesorderdelivery.deliverisdelivery";
        return QueryServiceHelper.query((String)"ocpos_saleorder_return", (String)selectFields, (QFilter[])filter.toArray());
    }

    public static List<JSONObject> buildKDPaySuccessParam(DynamicObject orderInfo, BigDecimal totalrealamount, String outTradeNo, String TradeNo) {
        DynamicObject ticketInfo;
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        if (StringUtil.isNotNull((String)outTradeNo)) {
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"kingdeefinancepay"), (String)"ocdbd_paymode");
            DynamicObject payWayType = BusinessDataServiceHelper.loadSingle((Object)960797054941170688L, (String)"ocdbd_paywaytype");
            JSONObject params = new JSONObject();
            params.put("amount", (Object)totalrealamount);
            params.put("payWay", (Object)payWay);
            params.put("payWayType", (Object)payWayType);
            params.put("orderNo", (Object)outTradeNo);
            params.put("bankExchangeNo", (Object)TradeNo);
            params.put("salebranchid", (Object)orderInfo.getLong("salebranchid.id"));
            result.add(params);
        }
        if ((ticketInfo = orderInfo.getDynamicObject("payticketinfo")) != null) {
            Long ticketTypeId = ticketInfo.getLong("tickettypeid.id");
            DynamicObject ticketType = BusinessDataServiceHelper.loadSingle((Object)ticketTypeId, (String)"ocdbd_ticketstype");
            DynamicObject payWay = BusinessDataServiceHelper.loadSingle((Object)PaymentModeEnum.getKey((String)"giftvoucherpay"), (String)"ocdbd_paymode");
            DynamicObject payWayType = BusinessDataServiceHelper.loadSingle((Object)960799969067988992L, (String)"ocdbd_paywaytype");
            JSONObject params = new JSONObject();
            BigDecimal receivableamount = orderInfo.getBigDecimal("receivableamount").subtract(totalrealamount);
            params.put("amount", (Object)receivableamount);
            params.put("payWay", (Object)payWay);
            params.put("payWayType", (Object)payWayType);
            params.put("cardNo", (Object)ticketInfo.getString("number"));
            params.put("ticketInfoId", (Object)ticketInfo.getString("id"));
            params.put("ticketInfo", (Object)ticketInfo);
            params.put("ticketTypeId", (Object)ticketInfo.getString("tickettypeid.id"));
            params.put("ticketType", (Object)ticketType);
            result.add(params);
        }
        return result;
    }

    public static void afterPaySuccessOperate(DynamicObject orderInfo, BigDecimal totalrealamount) {
        long storeId = orderInfo.getLong("salebranchid.id");
        long orgId = orderInfo.getLong("bizorgid.id");
        long memberId = orderInfo.getLong("member.id");
        JSONObject jsonObject1 = SaleOrderHelper.ticketInfoPay(orderInfo, memberId);
        logger.info("\u6838\u9500\u793c\u5238 \u7ed3\u679c\uff1a" + JSON.toJSONString((Object)jsonObject1));
        JSONObject jsonObject = OlstoreMemberHelper.pointReward(orgId, storeId, memberId, totalrealamount, orderInfo.getString("billno"));
        logger.info("\u8d60\u9001\u79ef\u5206 \u7ed3\u679c\uff1a" + JSON.toJSONString((Object)jsonObject));
        JSONObject activateResult = OlstoreTicketHelper.activateByPosSaleOrder(orderInfo.getLong("id"));
        logger.info("\u6fc0\u6d3b\u793c\u5238 \u7ed3\u679c\uff1a" + JSON.toJSONString((Object)activateResult));
    }

    public static JSONObject ticketInfoPay(DynamicObject orderInfo, long memberId) {
        DynamicObject ticketInfo = orderInfo.getDynamicObject("payticketinfo");
        if (ticketInfo != null) {
            logger.info(" ticketInfoPay\u652f\u4ed8\u540e, \u793c\u5238\u6b63\u5411\u652f\u4ed8\uff08\u6838\u9500\uff09\u53c2\u6570 ticketNumber\uff1a" + ticketInfo.getString("number"));
            JSONObject ticketParam = new JSONObject();
            ArrayList<String> numbers = new ArrayList<String>();
            numbers.add(ticketInfo.getString("number"));
            ticketParam.put("billsource", (Object)"ocgcm_ticketpay");
            ticketParam.put("numbers", numbers);
            ticketParam.put("consumeoperatorid", (Object)memberId);
            ticketParam.put("consumetime", orderInfo.get("createTime"));
            ticketParam.put("consumeorgid", orderInfo.get("bizorgid.id"));
            ticketParam.put("consumebranchid", orderInfo.get("salebranchid.id"));
            ticketParam.put("consumebillno", orderInfo.get("billno"));
            ticketParam.put("consumebillid", orderInfo.get("id"));
            ticketParam.put("entityname", (Object)"ocpos_saleorder");
            ticketParam.put("option", (Object)1);
            ticketParam.put("opertype", (Object)2);
            logger.info(" ticketInfoPay\u652f\u4ed8\u540e, \u793c\u5238\u6b63\u5411\u652f\u4ed8\uff08\u6838\u9500\uff09\u53c2\u6570\uff1a" + JSONObject.toJSONString((Object)ticketParam));
            return OlstoreTicketHelper.ticketInfoPay(ticketParam);
        }
        return null;
    }
}

