/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocpos.business.commonhelper.UnitConvertHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDeliveryInventoryHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.JsonUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SaleOrderInventoryHelper {
    private static Log logger = LogFactory.getLog(SaleOrderInventoryHelper.class);

    public static void saleOrderInventoryAvaiable(IFormView view, DynamicObject goods, int index) {
        IDataModel model = view.getModel();
        DynamicObject billType = (DynamicObject)model.getValue("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        if (StringUtils.equals((CharSequence)DynamicObjectUtil.getString((DynamicObject)goods, (String)"operationmodel"), (CharSequence)"0")) {
            return;
        }
        List<JSONObject> inventoryDetailInfoList = SaleOrderInventoryHelper.getInventoryAvaiable(view, model, goods, index);
        SaleOrderInventoryHelper.writeBackInventoryData(goods, inventoryDetailInfoList, view, model, index);
    }

    private static List<JSONObject> getInventoryAvaiable(IFormView view, IDataModel model, DynamicObject goods, int index) {
        List inventoryDetailInfoList = null;
        List<JSONObject> jsonParams = SaleOrderInventoryHelper.buildInventoryParam(model, goods, index);
        logger.info("\u5f00\u5355\u5e93\u5b58\u4f20\u53c2\uff1a" + JsonUtil.toJson(jsonParams));
        List inventoryAvaliableList = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"SharedInventoryService", (String)"matchDistributionWarehouse", (Object[])new Object[]{jsonParams});
        logger.info("\u5f00\u5355\u5e93\u5b58\u8fd4\u53c2\uff1a" + JsonUtil.toJson((Object)inventoryAvaliableList));
        String tip = SaleOrderInventoryHelper.checkInventory(model, goods, inventoryAvaliableList, index);
        if (StringUtils.isNotEmpty((CharSequence)tip)) {
            NotificationUtil.showDefaultTipNotify((String)tip, (IFormView)view);
            model.setValue("saleqty", (Object)1, index);
            return inventoryDetailInfoList;
        }
        for (Map.Entry inventorySet : ((JSONObject)inventoryAvaliableList.get(0)).entrySet()) {
            if (!"invdetailinfolist".equals(inventorySet.getKey())) continue;
            inventoryDetailInfoList = (List)inventorySet.getValue();
            break;
        }
        return inventoryDetailInfoList;
    }

    private static List<JSONObject> buildInventoryParam(IDataModel model, DynamicObject goods, int index) {
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        DynamicObject org = (DynamicObject)model.getValue("bizorgid");
        long adminDivisionId = CommonUtil.formatObejctToLong((Object)model.getValue("admindivisionid"));
        DynamicObject auxPty = (DynamicObject)model.getValue("auxattrid", index);
        DynamicObject unit = (DynamicObject)model.getValue("unit", index);
        BigDecimal saleQty = (BigDecimal)model.getValue("saleqty", index);
        BigDecimal baseunitQty = (BigDecimal)model.getValue("baseunitqty", index);
        DynamicObject baseUnit = (DynamicObject)model.getValue("baseunit", index);
        DynamicObject stockOrg = (DynamicObject)model.getValue("inventoryorg", index);
        DynamicObject warehouse = (DynamicObject)model.getValue("erpstock", index);
        DynamicObject distributionmode = (DynamicObject)model.getValue("distributionmode", index);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("saleOrgId", (Object)org.getLong("id"));
        jsonObject.put("saleChannelID", (Object)branch.getLong("id"));
        jsonObject.put("itemId", (Object)goods.getLong("id"));
        jsonObject.put("materialId", (Object)goods.getLong("material.id"));
        if (auxPty != null) {
            jsonObject.put("auxPtyID", (Object)auxPty.getLong("id"));
        }
        if (unit != null) {
            jsonObject.put("unitId", (Object)unit.getLong("id"));
        }
        jsonObject.put("unitQty", (Object)saleQty);
        if (baseUnit != null) {
            jsonObject.put("baseUnitID", (Object)baseUnit.getLong("id"));
        }
        jsonObject.put("baseUnitQty", (Object)baseunitQty);
        if (stockOrg != null) {
            jsonObject.put("stockOrgId", (Object)stockOrg.getLong("id"));
        }
        if (warehouse != null) {
            jsonObject.put("warehouseId", (Object)warehouse.getLong("id"));
        }
        if (distributionmode != null) {
            jsonObject.put("distributionModeId", (Object)distributionmode.getLong("id"));
        }
        jsonObject.put("adminDivisionId", (Object)adminDivisionId);
        jsonObject.put("customerKey", (Object)index);
        ArrayList<JSONObject> jsonParams = new ArrayList<JSONObject>();
        jsonParams.add(jsonObject);
        return jsonParams;
    }

    private static void writeBackInventoryData(DynamicObject goods, List<JSONObject> inventoryDetailInfoList, IFormView view, IDataModel model, int index) {
        if (inventoryDetailInfoList != null && inventoryDetailInfoList.size() > 0) {
            DynamicObjectCollection entryData = model.getDataEntity(true).getDynamicObjectCollection("goodsentryentity");
            DynamicObject goodEntry = (DynamicObject)entryData.get(index);
            DynamicObjectCollection deliverys = DynamicObjectUtil.getDynamicObjectCollection((DynamicObject)goodEntry, (String)"salesorderdelivery");
            if (deliverys.size() <= 0) {
                return;
            }
            deliverys.removeIf(x -> DynamicObjectUtil.getInt((DynamicObject)x, (String)"seq") > 1);
            DynamicObject goodsEntity = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("goodsentryentity").get(index);
            DynamicObjectCollection deliveryEntityList = goodsEntity.getDynamicObjectCollection("salesorderdelivery");
            DynamicObject unit = goods.getDynamicObject("saleunit");
            BigDecimal saleQty = (BigDecimal)model.getValue("saleqty", index);
            int delieveryIndex = 0;
            String warehouseid = null;
            BigDecimal availableQty = null;
            for (JSONObject jsonObject : inventoryDetailInfoList) {
                DynamicObject warehouse;
                DynamicObject delivery;
                warehouseid = jsonObject.getString("warehouseid");
                availableQty = jsonObject.getBigDecimal("availableqty");
                if (delieveryIndex > 0 && deliveryEntityList.size() < inventoryDetailInfoList.size()) {
                    delivery = deliveryEntityList.addNew();
                    delivery.set("seq", (Object)(delieveryIndex + 1));
                    SaleOrderInventoryHelper.setDeliveryInfo(delivery, model, goods, index);
                } else {
                    delivery = (DynamicObject)deliveryEntityList.get(delieveryIndex);
                }
                if ((warehouse = QueryServiceHelper.queryOne((String)"bd_warehouse", (String)"id,name,entryentity.location.id", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)warehouseid)})) == null) continue;
                if (availableQty.subtract(saleQty).compareTo(BigDecimal.ZERO) < 0 && saleQty.subtract(availableQty).compareTo(BigDecimal.ZERO) < 0) {
                    NotificationUtil.showDefaultTipNotify((String)("\u5f53\u524d" + warehouse.getString("name") + "\u5e93\u5b58\u53ef\u7528\u6570\u91cf" + availableQty + unit.getString("name") + ",\u8bf7\u91cd\u65b0\u8f93\u5165\u9500\u552e\u6570\u91cf"), (IFormView)view);
                    deliveryEntityList.removeIf(x -> DynamicObjectUtil.getInt((DynamicObject)x, (String)"seq") > 1);
                    model.setValue("saleqty", (Object)1, index);
                    break;
                }
                if (availableQty.signum() < 0) {
                    NotificationUtil.showDefaultTipNotify((String)("\u5f53\u524d" + warehouse.getString("name") + "\u5e93\u5b58\u53ef\u7528\u6570\u91cf" + availableQty + unit.getString("name") + ",\u8bf7\u91cd\u65b0\u8f93\u5165\u9500\u552e\u6570\u91cf"), (IFormView)view);
                    deliveryEntityList.removeIf(x -> DynamicObjectUtil.getInt((DynamicObject)x, (String)"seq") > 1);
                    model.setValue("saleqty", (Object)1, index);
                    break;
                }
                if (warehouse.get("entryentity.location.id") != null && warehouse.getLong("entryentity.location.id") > 0L) {
                    DynamicObject deliveryPosition = BusinessDataServiceHelper.loadSingle((Object)warehouse.get("entryentity.location.id"), (String)"bd_location");
                    delivery.set("erpstockpositionid", (Object)deliveryPosition);
                }
                if (jsonObject.getLong("channelwarehouseid") != null && jsonObject.getLong("channelwarehouseid") > 0L) {
                    DynamicObject deliveryStock = BusinessDataServiceHelper.loadSingle((Object)jsonObject.getLong("channelwarehouseid"), (String)"ococic_warehouse");
                    delivery.set("deliverstockid", (Object)deliveryStock);
                }
                if (jsonObject.getLong("stockorgid") != null && jsonObject.getLong("stockorgid") > 0L) {
                    DynamicObject inventoryOrg = BusinessDataServiceHelper.loadSingle((Object)jsonObject.getString("stockorgid"), (String)"bos_org");
                    delivery.set("inventoryorgid", (Object)inventoryOrg);
                }
                delivery.set("erpstockid", (Object)BusinessDataServiceHelper.loadSingle((Object)warehouseid, (String)"bd_warehouse"));
                delivery.set("deliversaleqty", (Object)jsonObject.getBigDecimal("availablebaseqty"));
                delivery.set("deliveryavareturnqty", (Object)jsonObject.getBigDecimal("availablebaseqty"));
                DynamicObject mode = BusinessDataServiceHelper.loadSingle((Object)jsonObject.getLong("distributionmodeid"), (String)"dbd_distributionmode");
                delivery.set("deliverymode", (Object)mode);
                saleQty = saleQty.subtract(availableQty);
                ++delieveryIndex;
            }
            view.updateView("salesorderdelivery");
        }
    }

    private static String checkInventory(IDataModel model, DynamicObject goods, List<JSONObject> inventoryAvaliableList, int index) {
        DynamicObject goodsEntity = (DynamicObject)model.getDataEntity(true).getDynamicObjectCollection("goodsentryentity").get(index);
        DynamicObjectCollection deliveryEntityList = goodsEntity.getDynamicObjectCollection("salesorderdelivery");
        String goodName = goods.getString("name");
        String tip = null;
        if (inventoryAvaliableList == null || inventoryAvaliableList.size() == 0 || StringUtils.isNotEmpty((CharSequence)inventoryAvaliableList.get(0).getString("invstatus")) && "2".equals(inventoryAvaliableList.get(0).getString("invstatus"))) {
            tip = "\u8be5\u5546\u54c1" + goodName + "\u95e8\u5e97\u5e93\u5b58\u4e0d\u8db3\uff0c\u8bf7\u9009\u62e9\u9884\u8ba2\u3001\u6216\u67e5\u8be2\u4e2d\u5fc3\u4ed3\u662f\u5426\u6709\u5e93\u5b58";
            if (deliveryEntityList.size() > 0) {
                SaleOrderInventoryHelper.resetDelivery((DynamicObject)deliveryEntityList.get(0));
                deliveryEntityList.removeIf(x -> DynamicObjectUtil.getInt((DynamicObject)x, (String)"seq") > 1);
            }
        } else if (StringUtils.isNotEmpty((CharSequence)inventoryAvaliableList.get(0).getString("invstatus")) && "3".equals(inventoryAvaliableList.get(0).getString("invstatus"))) {
            tip = "\u8be5\u5546\u54c1" + goodName + "\u4e3a\u914d\u9001\uff0c\u666e\u901a\u5546\u54c1\uff0c\u8bf7\u5148\u7ef4\u62a4\u5e93\u5b58\u5171\u4eab\u89c4\u5219";
        }
        return tip;
    }

    private static void resetDelivery(DynamicObject delivery) {
        delivery.set("deliversaleqty", (Object)1);
        delivery.set("deliverstockid", null);
        delivery.set("stockpositionid", null);
        delivery.set("erpstockid", null);
        delivery.set("erpstockpositionid", null);
    }

    public static void setDeliveryInfo(DynamicObject deliveryItem, IDataModel model, DynamicObject goods, int index) {
        DynamicObject dataEntity = model.getDataEntity(true);
        DynamicObject branch = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid");
        DynamicObject member = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"member");
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        DynamicObject barCode = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"barcode");
        DynamicObject distributionMode = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"distributionmode");
        DynamicObject erpStockPosition = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"erpstockposition");
        DynamicObject goodClass = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"goodsclass");
        DynamicObject brand = DynamicObjectUtils.getDynamicObject((DynamicObject)((DynamicObject)entryEntity.get(index)), (String)"brand");
        if (goods != null) {
            DynamicObject unit = goods.getDynamicObject("saleunit");
            if (unit != null) {
                deliveryItem.set("deliverunitid", (Object)unit);
            }
            deliveryItem.set("delivergoodsid", (Object)goods);
            deliveryItem.set("deliversaleqty", (Object)1);
            deliveryItem.set("brandid", (Object)brand);
            deliveryItem.set("delivergoodsclass", (Object)goodClass);
            deliveryItem.set("deliveryreturnqty", (Object)0);
            deliveryItem.set("deliveryavareturnqty", (Object)1);
            deliveryItem.set("deliverisdelivery", (Object)goods.getBoolean("isdelivery"));
            deliveryItem.set("deliverymode", (Object)distributionMode);
            deliveryItem.set("deliverisinstall", (Object)goods.getBoolean("isinstall"));
            deliveryItem.set("deliverdeliverybranchid", (Object)branch);
            DynamicObject deliveryStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_WAIT_DELIVERY, (String)"ococic_deliverstatus");
            deliveryItem.set("deliverystatus", (Object)deliveryStatus);
            QFilter filter = F7Util.getStockIdFilter((DynamicObject)branch);
            filter.and("isdelivery", "=", (Object)Boolean.TRUE);
            DynamicObject stock = BusinessDataServiceHelper.loadSingle((String)"ococic_warehouse", (String)"id", (QFilter[])filter.toArray());
            deliveryItem.set("deliverstockid", (Object)stock);
            if (stock != null) {
                QFilter stockPositionFilter = new QFilter("warehouseid", "=", (Object)stock.getLong("id"));
                DynamicObject stockPosition = BusinessDataServiceHelper.loadSingle((String)"ococic_location", (String)"Id,warehouseid", (QFilter[])stockPositionFilter.toArray());
                deliveryItem.set("stockpositionid", (Object)stockPosition);
            }
            if (erpStockPosition != null) {
                deliveryItem.set("erpstockpositionid", (Object)erpStockPosition);
            }
        }
        if (barCode != null) {
            deliveryItem.set("deliverbarcodeid", (Object)barCode);
        }
        if (member != null) {
            deliveryItem.set("consignee", (Object)member.getString("name"));
            String memberPhone = member.getString("telephone");
            if (memberPhone.contains("-")) {
                memberPhone = memberPhone.substring(memberPhone.indexOf(45) + 1);
            }
            deliveryItem.set("deliverphonenumber", (Object)memberPhone);
            String address = CommonUtil.formatStringToEmpty((Object)model.getValue("customeraddress"));
            String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"admindivisionid");
            SaleOrderInventoryHelper.upadateDeliveryAddress(deliveryItem, adminDivisionId, address);
        }
    }

    public static void upadateDeliveryAddress(DynamicObject deliveryItem, String adminDivisionId, String address) {
        deliveryItem.set("districtid", (Object)adminDivisionId);
        deliveryItem.set("address", (Object)address);
        if (StringUtils.isNotBlank((CharSequence)adminDivisionId) && !StringUtils.equals((CharSequence)adminDivisionId, (CharSequence)"0")) {
            DynamicObject adminDivision = BusinessDataServiceHelper.loadSingle((Object)adminDivisionId, (String)"bd_admindivision");
            String fullName = DynamicObjectUtils.getString((DynamicObject)adminDivision, (String)"fullname");
            String fullAddress = "";
            if (StringUtils.isNotBlank((CharSequence)fullName)) {
                fullAddress = fullName.replaceAll("_", "") + address;
            }
            if (fullAddress.length() > 0) {
                deliveryItem.set("fulladdress", (Object)fullAddress);
            } else {
                deliveryItem.set("fulladdress", null);
            }
        }
    }

    public static void setDefaultDeliveryInfoByGoods(IDataModel model, DynamicObject entryItem, DynamicObject goods) {
        String operationModel = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
        if (StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            DynamicObject supplier = DynamicObjectUtils.getDynamicObject((DynamicObject)goods, (String)"supplerid");
            entryItem.set("supplier", (Object)supplier);
        }
        boolean isInstall = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isinstall");
        entryItem.set("isinstall", (Object)isInstall);
        boolean isDelivery = DynamicObjectUtils.getBoolean((DynamicObject)goods, (String)"isdelivery");
        entryItem.set("isdelivery", (Object)isDelivery);
        SaleOrderInventoryHelper.setDefaultOperationmodel(model, entryItem, goods, isDelivery);
    }

    private static void setDefaultOperationmodel(IDataModel model, DynamicObject entryItem, DynamicObject goods, boolean isdelivery) {
        String operationModel = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
        if (StringUtils.isEmpty((CharSequence)operationModel)) {
            operationModel = "1";
            goods.set("operationmodel", (Object)"1");
        }
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        long modeId = 0L;
        if (isdelivery && StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            modeId = 926600963786061824L;
        } else if (isdelivery && StringUtils.equals((CharSequence)operationModel, (CharSequence)"1")) {
            modeId = 926596971228197888L;
            entryItem.set("stockid", (Object)CommonUtils.getDefaultDeliveryStock((DynamicObject)branch));
        } else if (!isdelivery && StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            modeId = 926601157210585088L;
        } else if (!isdelivery && StringUtils.equals((CharSequence)operationModel, (CharSequence)"1")) {
            modeId = 926601071999218688L;
        }
        DynamicObject mode = BusinessDataServiceHelper.loadSingle((Object)modeId, (String)"ocdbd_distributionmode");
        entryItem.set("distributionmode", (Object)mode);
    }

    public static void setDefaultDeliveryInfo(IFormView view, DynamicObject entryItem, DynamicObject goods, int index) {
        DynamicObject billType = (DynamicObject)view.getModel().getValue("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        if (billTypeId == BillTypeEnum.RETURN.getId()) {
            return;
        }
        SaleOrderInventoryHelper.setDefaultDeliveryInfoByGoods(view.getModel(), entryItem, goods);
        DynamicObject mode = (DynamicObject)view.getModel().getValue("distributionmode", index);
        Long modeId = DynamicObjectUtils.getPkValue((DynamicObject)mode);
        if (mode != null && 926596971228197888L != modeId && 926600838443594752L != modeId && 926600138543594753L != modeId) {
            String errorMsg = null;
            errorMsg = SaleOrderInventoryHelper.matchBranchDefaultStock(view, index);
            if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
                NotificationUtil.showDefaultTipNotify((String)errorMsg, (IFormView)view);
                view.getModel().setValue("saleqty", (Object)1, index);
                return;
            }
        }
        DynamicObjectCollection deliveryEntry = entryItem.getDynamicObjectCollection("salesorderdelivery");
        deliveryEntry.clear();
        DynamicObject deliveryItem = deliveryEntry.addNew();
        deliveryItem.set("seq", (Object)1);
        SaleOrderInventoryHelper.setDeliveryInfo(deliveryItem, view.getModel(), goods, index);
        view.updateView("salesorderdelivery");
    }

    public static String matchBranchDefaultStock(IFormView view, int index) {
        DynamicObject deliveryPosition;
        IDataModel model = view.getModel();
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        DynamicObject stock = (DynamicObject)model.getValue("stockid", index);
        QFilter filter = F7Util.getStockIdFilter((DynamicObject)branch);
        if (stock == null) {
            filter.and("isdelivery", "=", (Object)Boolean.TRUE);
        } else {
            filter.and("id", "=", (Object)DynamicObjectUtil.getPkValue((DynamicObject)stock));
        }
        DynamicObject branchStock = QueryServiceHelper.queryOne((String)"ococic_warehouse", (String)"id,erpstockorgid,erpwarehouseid", (QFilter[])filter.toArray());
        if (branchStock == null) {
            return "\u6e20\u9053" + branch.getString("name") + "\u9ed8\u8ba4\u53d1\u8d27\u4ed3\u5e93\u4e0d\u5b58\u5728,\u8bf7\u5148\u7ef4\u62a4\u6e20\u9053\u9ed8\u8ba4\u53d1\u8d27\u4ed3\u5e93";
        }
        if (StringUtils.isEmpty((CharSequence)branchStock.getString("erpstockorgid"))) {
            return "\u6e20\u9053" + branch.getString("name") + "\u9ed8\u8ba4erp\u5e93\u5b58\u7ec4\u7ec7\u4e0d\u5b58\u5728,\u8bf7\u5148\u7ef4\u62a4\u6e20\u9053erp\u5e93\u5b58\u7ec4\u7ec7";
        }
        if (StringUtils.isEmpty((CharSequence)branchStock.getString("erpwarehouseid"))) {
            return "\u6e20\u9053" + branch.getString("name") + "\u9ed8\u8ba4erp\u4ed3\u5e93\u4e0d\u5b58\u5728,\u8bf7\u5148\u7ef4\u62a4\u6e20\u9053erp\u4ed3\u5e93";
        }
        DynamicObject stockPosition = CommonUtils.getStockPositionByStockId((DynamicObject)branchStock);
        model.setValue("stockid", (Object)branchStock.getString("id"), index);
        model.setValue("stockposition", (Object)(stockPosition != null ? stockPosition.getString("id") : stockPosition), index);
        model.setValue("inventoryorg", (Object)branchStock.getString("erpstockorgid"), index);
        model.setValue("erpstock", (Object)branchStock.getString("erpwarehouseid"), index);
        view.updateView("stockid", index);
        view.updateView("stockposition", index);
        view.updateView("inventoryorg", index);
        view.updateView("erpstock", index);
        DynamicObject warehouse = BusinessDataServiceHelper.loadSingle((Object)branchStock.getString("erpwarehouseid"), (String)"bd_warehouse");
        if (warehouse.get("entryentity") != null && warehouse.getDynamicObjectCollection("entryentity").size() > 0 && (deliveryPosition = BusinessDataServiceHelper.loadSingle((Object)((DynamicObject)warehouse.getDynamicObjectCollection("entryentity").get(0)).get("location.id"), (String)"bd_location")) != null) {
            model.setValue("erpstockposition", (Object)deliveryPosition, index);
            view.updateView("erpstockposition", index);
        }
        return null;
    }

    public static void deliveryInventory(IFormView view, int rowIndex, int parentRowIndex) {
        DynamicObject goods = (DynamicObject)view.getModel().getValue("delivergoodsid", rowIndex);
        boolean checkSuccess = SaleOrderInventoryHelper.inventoryCheck(view.getModel(), parentRowIndex);
        if (checkSuccess) {
            return;
        }
        SaleOrderInventoryHelper.mergeWholeAddress(view, rowIndex, parentRowIndex);
        SaleOrderDeliveryInventoryHelper.saleOrderInventoryAvaiable(view, goods, parentRowIndex, rowIndex);
    }

    private static boolean inventoryCheck(IDataModel model, int index) {
        DynamicObject branch = (DynamicObject)model.getValue("salebranchid");
        boolean isBook = (Boolean)model.getValue("isbook", index);
        DynamicObject goods = (DynamicObject)model.getValue("goodsid", index);
        String operationModel = DynamicObjectUtils.getString((DynamicObject)goods, (String)"operationmodel");
        if (branch == null || isBook || StringUtils.equals((CharSequence)operationModel, (CharSequence)"0")) {
            return true;
        }
        return CommonUtils.checkOrderType((IDataModel)model);
    }

    public static void mergeWholeAddress(IFormView view, int rowIndex, int parentRowIndex) {
        DynamicObject goodsEntity = (DynamicObject)view.getModel().getDataEntity(true).getDynamicObjectCollection("goodsentryentity").get(parentRowIndex);
        DynamicObjectCollection deliveryEntityList = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)goodsEntity, (String)"salesorderdelivery");
        DynamicObject deliveryItem = (DynamicObject)deliveryEntityList.get(rowIndex);
        String adminDivisionId = DynamicObjectUtils.getString((DynamicObject)deliveryItem, (String)"districtid");
        String address = deliveryItem.getString("address");
        SaleOrderInventoryHelper.upadateDeliveryAddress(deliveryItem, adminDivisionId, address);
        view.updateView("fulladdress", rowIndex);
    }

    public static JSONObject overSaleOccupancy(DynamicObject dataEntity) {
        JSONObject overResult = new JSONObject();
        ArrayList<JSONObject> params = new ArrayList<JSONObject>();
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.STORE.getId()) {
            overResult.put("success", (Object)Boolean.TRUE);
            overResult.put("errormsg", (Object)"");
            return overResult;
        }
        String srcChangeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcchangeitemtype");
        if (StringUtils.equals((CharSequence)srcChangeType, (CharSequence)"3")) {
            overResult.put("success", (Object)Boolean.TRUE);
            overResult.put("errormsg", (Object)"");
            return overResult;
        }
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
        boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        DynamicObjectCollection entryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity) && !notConfirm) {
            overResult.put("success", (Object)Boolean.FALSE);
            overResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u3002", billNo));
            return overResult;
        }
        for (DynamicObject entryRow : entryEntity) {
            long overSalePolicyId = DynamicObjectUtils.getLong((DynamicObject)entryRow, (String)"oversalepolicyid");
            if (overSalePolicyId <= 0L) continue;
            JSONObject param = SaleOrderInventoryHelper.getOccupanyParam(billId, billNo, entryRow);
            params.add(param);
        }
        if (!CollectionUtils.isEmpty(params)) {
            List results = (List)DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"OverSalePolicyService", (String)"occupancyOverSalePolicy", (Object[])new Object[]{params});
            logger.info("\u8d1f\u5356\u8fd4\u53c2\uff1a" + JSONObject.toJSONString((Object)results));
            if (!CollectionUtils.isEmpty((Collection)results)) {
                overResult.put("success", (Object)Boolean.FALSE);
                StringBuilder sbMsg = new StringBuilder();
                for (JSONObject result : results) {
                    sbMsg.append(result.getString("errormsg"));
                }
                sbMsg.insert(0, String.format("\u5355\u53f7%s\u8d1f\u5356\u5360\u7528\u5931\u8d25\uff0c\u539f\u56e0\uff1a", billNo));
                overResult.put("errormsg", (Object)sbMsg.toString());
                return overResult;
            }
        }
        overResult.put("success", (Object)Boolean.TRUE);
        overResult.put("errormsg", (Object)"");
        return overResult;
    }

    public static JSONObject getOccupanyParam(long billId, String billNo, DynamicObject entryEntity) {
        JSONObject param = new JSONObject();
        param.put("billid", (Object)billId);
        param.put("billno", (Object)billNo);
        param.put("billentityid", (Object)"ocpos_saleorder");
        long entryId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity);
        param.put("billentryid", (Object)entryId);
        long overSalePolicyId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"oversalepolicyid");
        param.put("policyid", (Object)overSalePolicyId);
        long overSalePolicyEntryId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"oversalepolicyentryid");
        param.put("policyentryid", (Object)overSalePolicyEntryId);
        long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
        param.put("itemid", (Object)goodsId);
        long itemClassId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsclass");
        param.put("itemclass", (Object)itemClassId);
        long brandId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"brand");
        param.put("brand", (Object)brandId);
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"materielid");
        param.put("materialid", (Object)materialId);
        long auxPtyId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"auxattrid");
        param.put("auxptyid", (Object)auxPtyId);
        BigDecimal saleQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
        param.put("qty", (Object)saleQty);
        long unitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"unit");
        param.put("unitid", (Object)unitId);
        BigDecimal baseUnitQty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"baseunitqty");
        param.put("baseqty", (Object)baseUnitQty);
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"baseunit");
        param.put("baseunitid", (Object)baseUnitId);
        param.put("actualqty", (Object)saleQty);
        param.put("actualbaseqty", (Object)baseUnitQty);
        int seq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"seq");
        param.put("customerKey", (Object)seq);
        return param;
    }

    public static JSONObject overSaleRelease(DynamicObject dataEntity) {
        JSONObject overResult = new JSONObject();
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.STORE.getId()) {
            overResult.put("success", (Object)Boolean.TRUE);
            overResult.put("errormsg", (Object)"");
            return overResult;
        }
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
        boolean notConfirm = DynamicObjectUtils.getBoolean((DynamicObject)dataEntity, (String)"notconfirm");
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities) && !notConfirm) {
            overResult.put("success", (Object)Boolean.FALSE);
            overResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u5546\u54c1\u660e\u7ec6\u4e3a\u7a7a\uff0c\u8bf7\u7ef4\u62a4\u5546\u54c1\u660e\u7ec6\u3002", billNo));
            return overResult;
        }
        HashMap map = new HashMap(1);
        List billEntryIds = entryEntities.stream().filter(p -> DynamicObjectUtils.getLong((DynamicObject)p, (String)"oversalepolicyid") > 0L).map(DynamicObjectUtils::getPkValue).distinct().collect(Collectors.toList());
        map.put(billId, billEntryIds);
        if (!CollectionUtils.isEmpty(map)) {
            try {
                DispatchServiceHelper.invokeBizService((String)"occ", (String)"ococic", (String)"OverSalePolicyService", (String)"releaseOverSalePolicy", (Object[])new Object[]{"ocpos_saleorder", map});
            }
            catch (Exception ex) {
                overResult.put("success", (Object)Boolean.FALSE);
                overResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u8d1f\u5356\u91ca\u653e\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", billNo, ExceptionUtils.getStackTrace((Throwable)ex)));
                return overResult;
            }
        }
        overResult.put("success", (Object)Boolean.TRUE);
        overResult.put("errormsg", (Object)"");
        return overResult;
    }

    public static JSONObject reserveOccupancy(DynamicObject dataEntity) {
        JSONObject releaseResult = new JSONObject();
        if (!SaleOrderInventoryHelper.isCallReleaseOccupancy(dataEntity)) {
            releaseResult.put("success", (Object)Boolean.TRUE);
            releaseResult.put("errormsg", (Object)"");
            return releaseResult;
        }
        String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        try {
            DynamicObject reservedEntity = BusinessDataServiceHelper.loadSingle((Object)billId, (String)"ocpos_saleorder_reserved");
            DynamicObjectCollection deliveryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)reservedEntity, (String)"salesorderdelivery");
            if (!CollectionUtils.isEmpty((Collection)deliveryEntity)) {
                String returnData = (String)DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveByBills", (Object[])new Object[]{Collections.singletonList(reservedEntity)});
                logger.info(String.format("\u5355\u53f7%s\u9884\u7559\u5360\u7528\u8fd4\u53c2\uff1a%s", billNo, returnData));
                JSONArray results = JSON.parseArray((String)returnData);
                if (CollectionUtils.isEmpty((Collection)results)) {
                    releaseResult.put("success", (Object)Boolean.FALSE);
                    releaseResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u9884\u7559\u5f02\u5e38, \u539f\u56e0\uff1aresults\u4e3a\u7a7a", billNo));
                    return releaseResult;
                }
                JSONObject result = (JSONObject)results.get(0);
                if (ObjectUtils.isEmpty((Object)result)) {
                    releaseResult.put("success", (Object)Boolean.FALSE);
                    releaseResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u9884\u7559\u5f02\u5e38, \u539f\u56e0\uff1aresults(0)\u4e3a\u7a7a", billNo));
                    return releaseResult;
                }
                String resultMsg = SaleOrderInventoryHelper.handleServiceResult(dataEntity, result);
                if (StringUtils.isNotEmpty((CharSequence)resultMsg)) {
                    releaseResult.put("success", (Object)Boolean.FALSE);
                    releaseResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u9884\u7559\u5f02\u5e38, \u539f\u56e0\uff1a%s", billNo, resultMsg));
                    return releaseResult;
                }
                releaseResult.put("success", (Object)Boolean.TRUE);
                releaseResult.put("errormsg", (Object)"");
                return releaseResult;
            }
            releaseResult.put("success", (Object)Boolean.FALSE);
            releaseResult.put("errormsg", (Object)"\u914d\u9001\u660e\u7ec6\u4e3a\u7a7a");
            return releaseResult;
        }
        catch (Exception ex) {
            releaseResult.put("success", (Object)Boolean.FALSE);
            releaseResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u9884\u7559\u5931\u8d25, \u539f\u56e0\uff1a%s\u3002", billNo, ex.getMessage()));
            return releaseResult;
        }
    }

    public static boolean isCallReleaseOccupancy(DynamicObject dataEntity) {
        long branchId;
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.STORE.getId()) {
            return false;
        }
        String srcChangeType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcchangeitemtype");
        if (StringUtils.equals((CharSequence)srcChangeType, (CharSequence)"3")) {
            return false;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        if (!SystemParamUtil.getIsReserved((long)orgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid")))) {
            return false;
        }
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)entryEntities)) {
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
                for (DynamicObject deliveryEntity : deliveryEntities) {
                    long billId = DynamicObjectUtils.getLong((DynamicObject)deliveryEntity, (String)"billid");
                    boolean isReserve = DynamicObjectUtils.getBoolean((DynamicObject)deliveryEntity, (String)"deliveryisreserve");
                    if (billId == 0L || isReserve) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String handleServiceResult(DynamicObject dataEntity, JSONObject result) {
        String resultType;
        String resultMsg = null;
        switch (resultType = result.getString("reserveResultType")) {
            case "Failed": {
                String errorMsg = result.getString("errorMsg");
                logger.info(String.format("\u5355\u53f7%s\u9884\u7559\u7ed3\u679c\u5931\u8d25\uff1a%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), errorMsg));
                String tip = "\u9884\u7559\u5931\u8d25";
                if (errorMsg.contains(tip)) {
                    resultMsg = errorMsg;
                    break;
                }
                resultMsg = "\u8bf7\u68c0\u67e5\u9884\u7559\u8bbe\u7f6e\u6216\u5373\u65f6\u5e93\u5b58\u3002";
                break;
            }
            case "PartSuccess": {
                resultMsg = "\u4e0d\u8db3\u4e0d\u9884\u7559\u3002";
                break;
            }
            case "FullSuccess": {
                resultMsg = SaleOrderInventoryHelper.updateReserveInfo(dataEntity, result);
                break;
            }
            default: {
                resultMsg = String.format("reserveResultType\u672a\u77e5\u7ed3\u679c\uff1a%s", resultType);
            }
        }
        return resultMsg;
    }

    private static String updateReserveInfo(DynamicObject dataEntity, JSONObject result) {
        JSONArray entryResults = result.getJSONArray("entryResultList");
        if (CollectionUtils.isEmpty((Collection)entryResults)) {
            return "\u8fd4\u56de\u53c2\u6570entryResultList\u4e3a\u7a7a\u3002";
        }
        boolean isSuccess = true;
        ArrayList<Object[]> recordParams = new ArrayList<Object[]>();
        ArrayList<Object[]> recordsParams = new ArrayList<Object[]>();
        for (Object item : entryResults) {
            ArrayList<Object> values;
            JSONObject entryResult = (JSONObject)item;
            String resultType = entryResult.getString("reserveResultType");
            if (!StringUtils.equals((CharSequence)resultType, (CharSequence)"FullSuccess")) {
                isSuccess = false;
                break;
            }
            JSONArray invResults = entryResult.getJSONArray("stdInvResultList");
            if (CollectionUtils.isEmpty((Collection)invResults)) {
                return "\u8fd4\u56de\u53c2\u6570stdInvResultList\u4e3a\u7a7a\u3002";
            }
            long entryId = entryResult.getLongValue("entryId");
            int size = invResults.size();
            if (size == 1) {
                JSONObject invResult = (JSONObject)invResults.get(0);
                JSONObject invInfo = invResult.getJSONObject("invInfo");
                if (ObjectUtils.isEmpty((Object)invInfo)) {
                    return "\u8fd4\u56de\u53c2\u6570invInfo\u4e3a\u7a7a\u3002";
                }
                values = new ArrayList<Object>(6);
                values.add(Boolean.TRUE);
                values.add(invInfo.getString("lotnum"));
                values.add(invInfo.getLongValue("id"));
                values.add(invResult.getBigDecimal("baseQty"));
                values.add(invResult.getBigDecimal("qty"));
                values.add(entryId);
                recordParams.add(values.toArray());
                continue;
            }
            for (Object subItem : invResults) {
                JSONObject invResult = (JSONObject)subItem;
                JSONObject invInfo = invResult.getJSONObject("invInfo");
                if (ObjectUtils.isEmpty((Object)invInfo)) {
                    return "\u8fd4\u56de\u53c2\u6570invInfo\u4e3a\u7a7a\u3002";
                }
                values = new ArrayList(5);
                values.add(invInfo.getString("lotnum"));
                values.add(invInfo.getLongValue("id"));
                values.add(invResult.getBigDecimal("baseQty"));
                values.add(invResult.getBigDecimal("qty"));
                values.add(entryId);
                recordsParams.add(values.toArray());
            }
        }
        if (!isSuccess) {
            return "reserveResultType\u4e0d\u7b49\u4e8eFullSuccess";
        }
        StringBuilder sbMsg = new StringBuilder();
        if (!CollectionUtils.isEmpty(recordParams)) {
            sbMsg.append(SaleOrderInventoryHelper.updateDataByRecord(recordParams));
        }
        if (!CollectionUtils.isEmpty(recordsParams)) {
            sbMsg.append(SaleOrderInventoryHelper.updateDataByRecords(dataEntity, recordsParams));
        }
        return sbMsg.length() == 0 ? null : sbMsg.toString();
    }

    private static String updateDataByRecord(List<Object[]> params) {
        String updateSql = "";
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            updateSql = "update t_ocpos_saleorderdr set fisreserve = ?, flotnum = ?, finvid = ?, freservebaseqty = ?, freserveqty = ? where FDetailId = ?";
            DB.executeBatch((DBRoute)new DBRoute("drp"), (String)updateSql, params);
            String string = "";
            return string;
        }
        catch (Exception ex) {
            handle.markRollback();
            logger.info("\u9884\u7559\u5360\u7528\uff0c\u66f4\u65b0\u5931\u8d25\uff1a" + ex.getMessage());
            logger.info("\u9884\u7559\u5360\u7528\uff0c\u66f4\u65b0sql\uff1a" + updateSql + ",\u53c2\u6570\u96c6\uff1a" + JSON.toJSONString(params));
            String string = "\u66f4\u65b0\u5931\u8d25\uff1a" + ex.getMessage();
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private static String updateDataByRecords(DynamicObject dateEntity, List<Object[]> params) {
        Throwable throwable = null;
        try (TXHandle handle = TX.requiresNew();){
            DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dateEntity, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)entryEntities)) {
                String string = "";
                return string;
            }
            Map<Long, List<Object[]>> data = params.stream().collect(Collectors.groupingBy(x -> CommonUtil.formatObejctToLong((Object)x[4])));
            if (CollectionUtils.isEmpty(data)) {
                String string = "";
                return string;
            }
            for (DynamicObject entryEntity : entryEntities) {
                DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
                DynamicObjectType deliveryType = deliveryEntities.getDynamicObjectType();
                ArrayList<DynamicObject> deliveryData = new ArrayList<DynamicObject>();
                for (DynamicObject deliveryEntity : deliveryEntities) {
                    long detailId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity);
                    List<Object[]> values = data.get(detailId);
                    if (CollectionUtils.isEmpty(values)) continue;
                    Object[] value = values.get(0);
                    deliveryEntity.set("deliveryisreserve", (Object)Boolean.TRUE);
                    SaleOrderInventoryHelper.updateDeliveryData(deliveryEntity, value);
                    int size = values.size();
                    if (size == 1) continue;
                    for (int i = 1; i < size; ++i) {
                        value = values.get(i);
                        DynamicObject deliveryItem = (DynamicObject)new CloneUtils(false, true).clone((IDataEntityType)deliveryType, (Object)deliveryEntity);
                        SaleOrderInventoryHelper.updateDeliveryData(deliveryItem, value);
                        deliveryData.add(deliveryItem);
                    }
                }
                if (CollectionUtils.isEmpty(deliveryData)) continue;
                deliveryEntities.addAll(deliveryData);
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dateEntity});
            String string = "";
            return string;
        }
        catch (Exception ex) {
            handle.markRollback();
            logger.info("\u9884\u7559\u5360\u7528\uff0c\u66f4\u65b0\uff08\u62c6\u5206\uff09\u5931\u8d25\uff1a" + ex.getMessage());
            String string = "\u9884\u7559\u5360\u7528\uff0c\u66f4\u65b0\uff08\u62c6\u5206\uff09\u5931\u8d25\uff1a" + ex.getMessage();
            return string;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
    }

    private static void updateDeliveryData(DynamicObject deliveryEntity, Object[] value) {
        deliveryEntity.set("deliverylotnum", value[0]);
        deliveryEntity.set("invid", value[1]);
        deliveryEntity.set("deliveryreservebaseqty", value[2]);
        deliveryEntity.set("deliverybaseunitqty", value[2]);
        deliveryEntity.set("deliveryreserveqty", value[3]);
        deliveryEntity.set("deliversaleqty", value[3]);
        deliveryEntity.set("deliveryavareturnqty", value[3]);
        SaleOrderInventoryHelper.updateDeliveryOtherQuantities(deliveryEntity, CommonUtil.formatObjectToDecimal((Object)value[2]));
    }

    private static void updateDeliveryOtherQuantities(DynamicObject deliveryEntity, BigDecimal baseUnitQty) {
        DynamicObject stockUnit;
        long stockUnitId;
        long materialId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverymaterial");
        long baseUnitId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"deliverybaseunit");
        DynamicObject auxUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliveryauxunit");
        long auxUnitId = DynamicObjectUtils.getPkValue((DynamicObject)auxUnit);
        if (auxUnitId != 0L) {
            BigDecimal auxUnitQty = UnitConvertHelper.calculateDestQty(baseUnitQty, materialId, baseUnitId, auxUnitId);
            deliveryEntity.set("deliveryauxunitqty", (Object)auxUnitQty);
        }
        if ((stockUnitId = DynamicObjectUtils.getPkValue((DynamicObject)(stockUnit = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntity, (String)"deliverystockunit")))) != 0L) {
            BigDecimal stockUnitQty = UnitConvertHelper.calculateDestQty(baseUnitQty, materialId, baseUnitId, stockUnitId);
            if (stockUnitQty.compareTo(BigDecimal.ZERO) == 0) {
                stockUnitQty = baseUnitQty;
            }
            deliveryEntity.set("deliverystockunitqty", (Object)stockUnitQty);
        }
    }

    public static JSONObject reserveRemove(DynamicObject dataEntity) {
        JSONObject releaseResult = new JSONObject();
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        SaleOrderInventoryHelper.getReleaseParams(dataEntity, params);
        if (CollectionUtils.isEmpty(params)) {
            releaseResult.put("success", (Object)Boolean.TRUE);
            releaseResult.put("errormsg", (Object)"");
            return releaseResult;
        }
        try {
            Object billId = dataEntity.getPkValue();
            DispatchServiceHelper.invokeBizService((String)"mpscmm", (String)"mscommon", (String)"ReserveService", (String)"reserveRemove", (Object[])new Object[]{billId, null});
            SaleOrderInventoryHelper.updateReserveInfo(params);
            releaseResult.put("success", (Object)Boolean.TRUE);
            releaseResult.put("errormsg", (Object)"");
            return releaseResult;
        }
        catch (Exception ex) {
            String billNo = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno");
            logger.info(String.format("\u5355\u53f7%s\u9884\u7559\u91ca\u653e\u5931\u8d25, \u539f\u56e0\uff1a%s\u3002", billNo, ex.getMessage()));
            releaseResult.put("success", (Object)Boolean.FALSE);
            releaseResult.put("errormsg", (Object)String.format("\u5355\u53f7%s\u9884\u7559\u91ca\u653e\u5931\u8d25, \u539f\u56e0\uff1a%s\u3002", billNo, ex.getMessage()));
            return releaseResult;
        }
    }

    private static void getReleaseParams(DynamicObject dataEntity, List<Object[]> params) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObject materialInv = DynamicObjectUtils.getDynamicObject((DynamicObject)entryEntity, (String)"materialinv");
            boolean isSerial = DynamicObjectUtils.getBoolean((DynamicObject)materialInv, (String)"enableserial");
            DynamicObjectCollection deliveryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                boolean isReserve = DynamicObjectUtils.getBoolean((DynamicObject)deliveryEntity, (String)"deliveryisreserve");
                if (!isReserve) continue;
                ArrayList<Object> values = new ArrayList<Object>(0);
                values.add(Boolean.FALSE);
                values.add(BigDecimal.ZERO);
                values.add(BigDecimal.ZERO);
                if (isSerial) {
                    values.add(DynamicObjectUtils.getString((DynamicObject)deliveryEntity, (String)"deliverylotnum"));
                } else {
                    values.add("");
                }
                values.add(deliveryEntity.getPkValue());
                params.add(values.toArray());
            }
        }
    }

    private static void updateReserveInfo(List<Object[]> params) {
        try (TXHandle handle = TX.requiresNew();){
            try {
                String updateSql = "update t_ocpos_saleorderdr set fisreserve = ?, freservebaseqty = ?, freserveqty = ?, flotnum = ? where FDetailId = ?";
                DB.executeBatch((DBRoute)new DBRoute("drp"), (String)updateSql, params);
            }
            catch (Throwable ex) {
                handle.markRollback();
                throw ex;
            }
        }
    }
}

