/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.IFormView;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocbase.common.util.PosItemUtil;
import kd.occ.ocbase.common.util.pos.NotificationUtil;
import kd.occ.ocbase.common.util.pos.PosUnit;
import kd.occ.ocpos.common.util.F7Util;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderItemF7Filter {
    public static void beforeItemF7Filter(BeforeF7SelectEvent e, IFormView view, long orgId, long branchId, long currencyId, String key, boolean isEnableUserScopes, long saleDeptId, long saleManId, long goodsId) {
        String sourceMethod = e.getSourceMethod();
        if (StringUtils.equalsIgnoreCase((CharSequence)sourceMethod, (CharSequence)"getLookUpList")) {
            switch (key) {
                case "goodsid": {
                    JSONObject checkResult = SaleOrderItemF7Filter.checkGetSearchValue(e, orgId, branchId);
                    if (checkResult.getBoolean("success").booleanValue()) {
                        String searchValue = checkResult.getString("searchvalue");
                        SaleOrderItemF7Filter.beforeItemF7GetLookUpList(e, view, orgId, branchId, currencyId, searchValue);
                        break;
                    }
                    e.setCancel(true);
                    return;
                }
                case "barcode": {
                    SaleOrderItemF7Filter.beforeBarCodeF7GetLookUpList(e, branchId, currencyId, goodsId);
                    break;
                }
                case "itemids": {
                    JSONObject checkResult = SaleOrderItemF7Filter.checkGetSearchValue(e, orgId, branchId);
                    if (checkResult.getBoolean("success").booleanValue()) {
                        String searchValue = checkResult.getString("searchvalue");
                        SaleOrderItemF7Filter.beforeInvQueryItemF7GetLookUpList(e, view, orgId, branchId, currencyId, searchValue);
                        break;
                    }
                    e.setCancel(true);
                    return;
                }
            }
        } else if (StringUtils.equalsIgnoreCase((CharSequence)sourceMethod, (CharSequence)"click")) {
            QFilter filter = F7Util.getF7SaleContentFilter((long)branchId, (long)currencyId, (String)"ocdbd_itemsalecontent.itemid");
            filter.and(SaleOrderItemF7Filter.getItemDataScopeFilter(orgId));
            ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
            showParameter.getListFilterParameter().getQFilters().add(filter);
            showParameter.setCustomParam("channel", (Object)branchId);
            showParameter.setCustomParam("itemck", (Object)isEnableUserScopes);
            showParameter.setCustomParam("organization", (Object)saleDeptId);
            showParameter.setCustomParam("userid", (Object)saleManId);
            if (StringUtils.equalsIgnoreCase((CharSequence)key, (CharSequence)"itemids")) {
                showParameter.setBillFormId("ocdbd_iteminfo_pos");
                showParameter.setFormId("ocpos_listf7_items");
                showParameter.setMultiSelect(true);
            } else {
                showParameter.setMultiSelect(false);
            }
        }
    }

    private static JSONObject checkGetSearchValue(BeforeF7SelectEvent e, long orgId, long branchId) {
        int digit;
        int inputLen;
        BasedataEdit basedataEdit;
        QFilter searchFilter;
        JSONObject checkResult = new JSONObject();
        boolean isCheck = true;
        String searchValue = "";
        Object source = e.getSource();
        if (!ObjectUtils.isEmpty((Object)source) && source instanceof BasedataEdit && (searchFilter = (basedataEdit = (BasedataEdit)source).getSearchFilter()) != null) {
            searchValue = String.valueOf(searchFilter.getValue());
            searchValue = searchValue.substring(searchValue.indexOf("#") + 1);
        }
        if (StringUtils.isEmpty((CharSequence)searchValue)) {
            isCheck = false;
        }
        if ((inputLen = PosUnit.countLength((String)searchValue)) < (digit = SystemParamUtil.getOpenQueryInputNumDigit((long)orgId, (long)branchId))) {
            isCheck = false;
        }
        checkResult.put("success", (Object)isCheck);
        checkResult.put("searchvalue", (Object)searchValue);
        return checkResult;
    }

    private static void beforeItemF7GetLookUpList(BeforeF7SelectEvent e, IFormView view, long orgId, long branchId, long currencyId, String searchValue) {
        JSONObject data = PosItemUtil.getSaleContents((long)branchId, (long)currencyId, (String)searchValue);
        if (CollectionUtils.isEmpty((Map)data)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        SaleOrderItemF7Filter.itemF7GetLookUpList(e, orgId, data);
    }

    private static void beforeInvQueryItemF7GetLookUpList(BeforeF7SelectEvent e, IFormView view, long orgId, long branchId, long currencyId, String searchValue) {
        JSONObject data = PosItemUtil.getSaleContents((long)branchId, (long)currencyId, (String)searchValue);
        if (CollectionUtils.isEmpty((Map)data)) {
            NotificationUtil.showDefaultTipNotify((String)"\u8bf7\u5148\u7ef4\u62a4\u5546\u54c1\u7ecf\u8425\u76ee\u5f55\u3002", (IFormView)view);
            e.setCancel(true);
            return;
        }
        SaleOrderItemF7Filter.invQueryItemGetLookUpList(e, orgId, branchId, data);
    }

    private static void itemF7GetLookUpList(BeforeF7SelectEvent e, long orgId, JSONObject data) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Set itemIds = (Set)data.getObject("itemid", Set.class);
        QFilter filter = new QFilter("id", "in", (Object)itemIds);
        filter.and(SaleOrderItemF7Filter.getItemDataScopeFilter(orgId));
        showParameter.getListFilterParameter().getQFilters().add(filter);
        showParameter.setMultiSelect(false);
        Set saleContents = (Set)data.getObject("ocdbd_itemsalecontent", Set.class);
        showParameter.setCustomParam("ocdbd_itemsalecontent", (Object)saleContents);
    }

    private static void invQueryItemGetLookUpList(BeforeF7SelectEvent e, long orgId, long branchId, JSONObject data) {
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        Set itemIds = (Set)data.getObject("itemid", Set.class);
        QFilter filter = new QFilter("id", "in", (Object)itemIds);
        filter.and(SaleOrderItemF7Filter.getItemDataScopeFilter(orgId));
        showParameter.getListFilterParameter().getQFilters().add(filter);
        showParameter.setMultiSelect(false);
        Set saleContents = (Set)data.getObject("ocdbd_itemsalecontent", Set.class);
        showParameter.setCustomParam("ocdbd_itemsalecontent", (Object)saleContents);
        showParameter.setBillFormId("ocdbd_iteminfo_pos");
        showParameter.setFormId("ocpos_listf7_items");
        showParameter.getListFilterParameter().setFilter(filter);
        showParameter.setCustomParam("itemck", (Object)false);
        showParameter.setCustomParam("channel", (Object)branchId);
        showParameter.setCustomParam("organization", (Object)0L);
        showParameter.setCustomParam("userid", (Object)0L);
    }

    private static void beforeBarCodeF7GetLookUpList(BeforeF7SelectEvent e, long branchId, long currencyId, long goodsId) {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(3);
        QFilter f1 = F7Utils.getDataStatus();
        filters.add(f1);
        QFilter f2 = F7Util.getSaleContentFilter((long)branchId, (long)currencyId, (String)"fbarcodeid");
        filters.add(f2);
        if (goodsId > 0L) {
            QFilter f3 = new QFilter("item", "=", (Object)goodsId);
            filters.add(f3);
        }
        ListShowParameter showParameter = (ListShowParameter)e.getFormShowParameter();
        showParameter.getListFilterParameter().getQFilters().addAll(filters);
        showParameter.setMultiSelect(false);
    }

    private static QFilter getItemDataScopeFilter(long orgId) {
        return F7Utils.getDataScopeFilter((String)"ocdbd", (String)"ocdbd_iteminfo", (long)orgId);
    }
}

