/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.occ.ocbase.common.enums.delivery.DeliveryStatus;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocpos.business.push.AutoPushHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderDrawHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderReturnRuleHelper;
import kd.occ.ocpos.business.saleorder.SaleOrderWriteBackHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.saleorder.CommonUtils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderPushHelper {
    private static final Log log = LogFactory.getLog(SaleOrderPushHelper.class);

    public static JSONObject billAutoPushSaleOrderAudit(DynamicObject dataEntity, String sourceEntityNumber) {
        JSONObject jsonObject = new JSONObject();
        switch (sourceEntityNumber) {
            case "ocpos_salechange": {
                jsonObject = SaleOrderPushHelper.billAutoPushSaleOrderChangeAudit(dataEntity, sourceEntityNumber);
                break;
            }
            case "ocpos_saleorder": 
            case "ocpos_saleorder_return": {
                jsonObject = SaleOrderPushHelper.billAutoPushRetailOrderAudit(dataEntity, sourceEntityNumber);
                break;
            }
            default: {
                jsonObject.put("status", (Object)"false");
                jsonObject.put("msg", (Object)String.format("\u5355\u636e\u6807\u8bc6\uff1a%s\u81ea\u52a8\u4e0b\u63a8\u5e76\u5ba1\u6838\u529f\u80fd\u672a\u5b9e\u73b0\u3002", sourceEntityNumber));
            }
        }
        return jsonObject;
    }

    public static JSONObject billAutoPushSaleOrderChangeAudit(DynamicObject dataEntity, String sourceEntityNumber) {
        JSONObject jsonResult = new JSONObject();
        Long pkId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        boolean isSuccessSale = false;
        boolean isSuccessSaleReturn = false;
        StringBuilder pushMsgBuilder = new StringBuilder();
        if (StringUtils.equalsIgnoreCase((CharSequence)sourceEntityNumber, (CharSequence)"ocpos_salechange")) {
            String errmsg;
            OperationResult pushResult;
            try {
                pushResult = AutoPushHelper.autoPushBill(pkId, sourceEntityNumber, "ocpos_saleorder", "audit");
                if (pushResult == null) {
                    pushMsgBuilder.append(String.format("\u6362\u8d27\u5355%s\u4e0b\u63a8\u96f6\u552e\u5f00\u5355\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
                } else if (!pushResult.isSuccess()) {
                    pushResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                    pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                    if (pushMsgBuilder.length() == 0) {
                        pushMsgBuilder.append(pushResult.getMessage());
                    }
                } else {
                    isSuccessSale = true;
                }
            }
            catch (Exception e) {
                errmsg = String.format("\u6362\u8d27\u5355%s\u4e0b\u63a8\u96f6\u552e\u5f00\u5355\u5931\u8d25:%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), e.getMessage());
                log.info(errmsg);
                pushMsgBuilder.append(errmsg);
            }
            try {
                pushResult = AutoPushHelper.autoPushBill(pkId, sourceEntityNumber, "ocpos_saleorder_return", "audit");
                if (pushResult == null) {
                    pushMsgBuilder.append(String.format("\u6362\u8d27\u5355%s\u4e0b\u63a8\u9000\u8d27\u5355\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
                } else if (!pushResult.isSuccess()) {
                    pushResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                    pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                    if (pushMsgBuilder.length() == 0) {
                        pushMsgBuilder.append(pushResult.getMessage());
                    }
                } else {
                    isSuccessSaleReturn = true;
                }
            }
            catch (Exception e) {
                errmsg = String.format("\u6362\u8d27\u5355%s\u4e0b\u63a8\u9000\u8d27\u5355\u5931\u8d25:%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), e.getMessage());
                log.info(errmsg);
                pushMsgBuilder.append(errmsg);
            }
        }
        if (isSuccessSale && isSuccessSaleReturn) {
            jsonResult.put("status", (Object)"true");
        } else {
            jsonResult.put("status", (Object)"false");
        }
        jsonResult.put("msg", (Object)pushMsgBuilder.toString());
        return jsonResult;
    }

    public static JSONObject billAutoPushRetailOrderAudit(DynamicObject dataEntity, String sourceEntityNumber) {
        StringBuilder pushMsgBuilder;
        boolean isSuccessOrder;
        boolean isSuccessRetail;
        JSONObject jsonResult;
        block30: {
            jsonResult = new JSONObject();
            Long pkId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
            isSuccessRetail = false;
            isSuccessOrder = false;
            pushMsgBuilder = new StringBuilder();
            String isMergeBill = SaleOrderPushHelper.getMergeBillType(dataEntity);
            if (StringUtils.equalsIgnoreCase((CharSequence)isMergeBill, (CharSequence)"1")) {
                try {
                    OperationResult pushResult = AutoPushHelper.autoPushBill(pkId, sourceEntityNumber, "ocococ_retailbill", "audit");
                    if (pushResult == null) {
                        pushMsgBuilder.append(String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u96f6\u552e\u5355\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
                        break block30;
                    }
                    if (!pushResult.isSuccess()) {
                        pushResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                        pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                        if (pushMsgBuilder.length() == 0) {
                            pushMsgBuilder.append(pushResult.getMessage());
                        }
                        break block30;
                    }
                    isSuccessRetail = true;
                    isSuccessOrder = true;
                }
                catch (Exception e) {
                    String errmsg = String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u96f6\u552e\u5355\u5931\u8d25:%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), e.getMessage());
                    log.info(errmsg);
                    pushMsgBuilder.append(errmsg);
                }
            } else if (StringUtils.equalsIgnoreCase((CharSequence)isMergeBill, (CharSequence)"0")) {
                try {
                    OperationResult pushResult = AutoPushHelper.autoPushBill(pkId, sourceEntityNumber, "ocococ_orderbill", "audit");
                    if (pushResult == null) {
                        pushMsgBuilder.append(String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u9884\u8ba2\u5355\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
                        break block30;
                    }
                    if (!pushResult.isSuccess()) {
                        pushResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                        pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                        if (pushMsgBuilder.length() == 0) {
                            pushMsgBuilder.append(pushResult.getMessage());
                        }
                        break block30;
                    }
                    isSuccessOrder = true;
                    isSuccessRetail = true;
                }
                catch (Exception e) {
                    String errmsg = String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u9884\u8ba2\u5355\u5931\u8d25:%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), e.getMessage());
                    log.info(errmsg);
                    pushMsgBuilder.append(errmsg);
                }
            } else {
                String errmsg;
                OperationResult pushResult;
                try {
                    pushResult = AutoPushHelper.autoPushBill(pkId, sourceEntityNumber, "ocococ_retailbill", "audit");
                    if (pushResult == null) {
                        pushMsgBuilder.append(String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u96f6\u552e\u5355\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
                    } else if (!pushResult.isSuccess()) {
                        pushResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                        pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                        if (pushMsgBuilder.length() == 0) {
                            pushMsgBuilder.append(pushResult.getMessage());
                        }
                    } else {
                        isSuccessRetail = true;
                    }
                }
                catch (Exception e) {
                    errmsg = String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u96f6\u552e\u5355\u5931\u8d25:%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), e.getMessage());
                    log.info(errmsg);
                    pushMsgBuilder.append(errmsg);
                }
                try {
                    pushResult = AutoPushHelper.autoPushBill(pkId, sourceEntityNumber, "ocococ_orderbill", "audit");
                    if (pushResult == null) {
                        pushMsgBuilder.append(String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u9884\u8ba2\u5355\u5931\u8d25:null", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno")));
                    } else if (!pushResult.isSuccess()) {
                        pushMsgBuilder.append(pushResult.getMessage());
                        pushResult.getAllErrorOrValidateInfo().forEach(info -> pushMsgBuilder.append(info.getTitle()).append(info.getMessage()).append(','));
                        pushMsgBuilder.deleteCharAt(pushMsgBuilder.lastIndexOf(","));
                        if (pushMsgBuilder.length() == 0) {
                            pushMsgBuilder.append(pushResult.getMessage());
                        }
                    } else {
                        isSuccessOrder = true;
                    }
                }
                catch (Exception e) {
                    errmsg = String.format("\u96f6\u552e\u5f00\u5355%s\u4e0b\u63a8\u9884\u8ba2\u5355\u5931\u8d25:%s", DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"billno"), e.getMessage());
                    log.info(errmsg);
                    pushMsgBuilder.append(errmsg);
                }
            }
        }
        if (isSuccessRetail && isSuccessOrder) {
            jsonResult.put("status", (Object)"true");
        } else {
            jsonResult.put("status", (Object)"false");
        }
        jsonResult.put("msg", (Object)pushMsgBuilder.toString());
        return jsonResult;
    }

    public static String getMergeBillType(DynamicObject dataEntity) {
        String isMergeBillType = "1";
        boolean isSale = false;
        boolean isBook = false;
        DynamicObjectCollection goodsEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        for (DynamicObject entryItem : goodsEntity) {
            if (DynamicObjectUtil.getBoolean((DynamicObject)entryItem, (String)"isbook")) {
                isBook = true;
                continue;
            }
            isSale = true;
        }
        if (isBook && isSale) {
            isMergeBillType = "2";
        } else if (isBook) {
            isMergeBillType = "0";
        } else if (isSale) {
            isMergeBillType = "1";
        }
        return isMergeBillType;
    }

    public static JSONObject autoPushAndSubmit(DynamicObject saleOrder, boolean isWholeBillPush, List<Map<String, Object>> lstData, JSONObject customParamJson, String targetEntityId) {
        ListSelectedRowCollection selectedRows;
        JSONObject jsonResult = new JSONObject();
        long starttime = System.currentTimeMillis();
        String sourceEntityId = "ocpos_saleorder";
        String sourceEntryKey = "goodsentryentity";
        String srcSubEntryKey = "salesorderdelivery";
        PushArgs pushArgs = new PushArgs();
        pushArgs.setSourceEntityNumber(sourceEntityId);
        pushArgs.setTargetEntityNumber(targetEntityId);
        pushArgs.setBuildConvReport(true);
        if (customParamJson != null) {
            pushArgs.addCustomParam("customparam", customParamJson.toJSONString());
        }
        if (ObjectUtils.isEmpty((Object)(selectedRows = SaleOrderDrawHelper.getAllListSelectedRow(saleOrder, isWholeBillPush, lstData, sourceEntryKey, srcSubEntryKey)))) {
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("billId", (Object)0L);
            jsonResult.put("error", (Object)"\u672a\u9009\u62e9\u5546\u54c1\u3002");
            return jsonResult;
        }
        pushArgs.getSelectedRows().addAll(selectedRows);
        log.info("\u7533\u8bf7\u96f6\u552e\u6362\u8d27\u5355\u8017\u65f6\u7edf\u8ba14\uff1a" + (System.currentTimeMillis() - starttime) + " \u6beb\u79d2");
        starttime = System.currentTimeMillis();
        ConvertOperationResult convertResult = ConvertServiceHelper.push((PushArgs)pushArgs);
        log.info("\u7533\u8bf7\u96f6\u552e\u6362\u8d27\u5355\u8017\u65f6\u7edf\u8ba15\uff1a" + (System.currentTimeMillis() - starttime) + " \u6beb\u79d2");
        SaleOrderDrawHelper.setDrawQtyZero(saleOrder);
        starttime = System.currentTimeMillis();
        if (!convertResult.isSuccess()) {
            String errMessage = convertResult.getMessage();
            if (StringUtils.isEmpty((CharSequence)errMessage)) {
                StringBuilder errorMsg = new StringBuilder();
                for (SourceBillReport billReport : convertResult.getBillReports()) {
                    errorMsg.append(billReport.getFailMessage());
                }
                errMessage = errorMsg.toString();
            }
            jsonResult.put("success", (Object)Boolean.FALSE);
            jsonResult.put("billId", (Object)0L);
            jsonResult.put("error", (Object)("\u4fdd\u5b58\u5931\u8d25:" + errMessage));
            return jsonResult;
        }
        Object[] targetBillIds = convertResult.getTargetBillIds().toArray();
        jsonResult.put("success", (Object)Boolean.TRUE);
        jsonResult.put("billId", targetBillIds[0]);
        String errMessage = "";
        OperationResult submitResult = OperationServiceHelper.executeOperate((String)"submit", (String)targetEntityId, (Object[])targetBillIds, (OperateOption)OperateOption.create());
        log.info("\u7533\u8bf7\u96f6\u552e\u6362\u8d27\u5355\u8017\u65f6\u7edf\u8ba16\uff1a" + (System.currentTimeMillis() - starttime) + " \u6beb\u79d2");
        boolean isSubmit = submitResult.isSuccess();
        jsonResult.put("isSubmit", (Object)isSubmit);
        if (!isSubmit) {
            errMessage = "\u63d0\u4ea4\u5931\u8d25\uff1a" + submitResult.getMessage();
        }
        jsonResult.put("error", (Object)errMessage);
        return jsonResult;
    }

    public static void afterPushUpdateSendTicketPointEntitys(DynamicObject dataEntity, DynamicObjectCollection entryEntity) {
        DynamicObject baseBillType = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"basebilltype");
        long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)baseBillType);
        String srcBizTypeFieldKey = "srcbillbiztype";
        String targetBillName = dataEntity.getDynamicObjectType().getName();
        if (targetBillName.equalsIgnoreCase("ocpos_saleorder")) {
            srcBizTypeFieldKey = "srcbiztype";
        }
        String srcBizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)srcBizTypeFieldKey);
        int entitySize = entryEntity.size();
        HashMap<String, String> srcSeqRetSeqMap = new HashMap<String, String>(entitySize);
        HashMap<String, DynamicObject> promoteSendSrcSeqGoodsEntryMap = new HashMap<String, DynamicObject>(entitySize);
        HashMap<Integer, DynamicObject> manualSendSrcSeqGoodsEntryMap = new HashMap<Integer, DynamicObject>(entitySize);
        SaleOrderPushHelper.getMapData(entryEntity, srcSeqRetSeqMap, promoteSendSrcSeqGoodsEntryMap, manualSendSrcSeqGoodsEntryMap);
        if (baseBillTypeId != BillTypeEnum.GUIDE.getId() && baseBillTypeId != BillTypeEnum.GROUP.getId()) {
            SaleOrderPushHelper.updateSendTicketPointEntitys(dataEntity, entryEntity, srcSeqRetSeqMap, promoteSendSrcSeqGoodsEntryMap, manualSendSrcSeqGoodsEntryMap, srcBizType);
        }
    }

    public static void getMapData(DynamicObjectCollection entryEntity, Map<String, String> srcSeqRetSeqMap, Map<String, DynamicObject> promoteSendSrcSeqGoodsEntryMap, Map<Integer, DynamicObject> manualSendSrcSeqGoodsEntryMap) {
        for (DynamicObject entryItem : entryEntity) {
            boolean isPresent;
            int srcSeq = DynamicObjectUtils.getInt((DynamicObject)entryItem, (String)"inisrcseq");
            if (srcSeq == 0) {
                srcSeq = entryItem.getInt("srcseq");
            }
            if (isPresent = entryItem.getBoolean("ispresent")) {
                String giftType = entryItem.getString("gifttype");
                if (StringUtils.equals((CharSequence)giftType, (CharSequence)"3")) {
                    promoteSendSrcSeqGoodsEntryMap.put(String.valueOf(srcSeq), entryItem);
                    continue;
                }
                int srcPromoteSeq = entryItem.getInt("promoteseq");
                manualSendSrcSeqGoodsEntryMap.put(srcPromoteSeq, entryItem);
                continue;
            }
            String seq = entryItem.getString("seq");
            srcSeqRetSeqMap.put(String.valueOf(srcSeq), seq);
        }
    }

    public static void updateSendTicketPointEntitys(DynamicObject dataEntity, DynamicObjectCollection entryEntity, Map<String, String> srcSeqRetSeqMap, Map<String, DynamicObject> promoteSendSrcSeqGoodsEntryMap, Map<Integer, DynamicObject> manualSendSrcSeqGoodsEntryMap, String srcBizType) {
        DynamicObjectCollection pointSendEntity;
        DynamicObjectCollection ticketSendEntity;
        DynamicObjectCollection sendEntity;
        boolean isReturn = false;
        String targetBillName = dataEntity.getDynamicObjectType().getName();
        if (targetBillName.equalsIgnoreCase("ocpos_saleorder_return")) {
            isReturn = true;
        }
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        String srcChangeItemType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcchangeitemtype");
        boolean isSetEmptyByChangeItemType = false;
        long updateSourceBillId = 0L;
        if (!isReturn && StringUtils.equals((CharSequence)srcChangeItemType, (CharSequence)"2")) {
            isSetEmptyByChangeItemType = true;
        }
        for (DynamicObject entryItem : entryEntity) {
            long entrySrcBillId;
            boolean isPresent;
            if (isSetEmptyByChangeItemType) {
                entryItem.set("srcseq", (Object)0);
            }
            if (isPresent = entryItem.getBoolean("ispresent")) continue;
            DynamicObjectCollection salesOrderPromote = entryItem.getDynamicObjectCollection("salesorderpromote");
            if (!CollectionUtils.isEmpty((Collection)salesOrderPromote)) {
                for (Object promoteEntry : salesOrderPromote) {
                    String srcPromoteGoodsSeq = DynamicObjectUtils.getString((DynamicObject)promoteEntry, (String)"srcpromotegoodsseq");
                    DynamicObject goodsEntry = promoteSendSrcSeqGoodsEntryMap.get(srcPromoteGoodsSeq);
                    SaleOrderPushHelper.updatePromoteSendExeGoodsSeq((DynamicObject)promoteEntry, srcSeqRetSeqMap, goodsEntry);
                }
            }
            if ((entrySrcBillId = DynamicObjectUtils.getLong((DynamicObject)entryItem, (String)"entrysrcbillid")) <= 0L || entrySrcBillId == sourceBillId) continue;
            updateSourceBillId = entrySrcBillId;
        }
        if (updateSourceBillId > 0L) {
            dataEntity.set("sourcebillid", (Object)updateSourceBillId);
        }
        if (!CollectionUtils.isEmpty((Collection)(sendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity")))) {
            int rowSeq = 1;
            int deleteRow = 0;
            ArrayList<Integer> iniSendSeqLst = new ArrayList<Integer>(sendEntity.size());
            ArrayList<DynamicObject> deleteEntity = new ArrayList<DynamicObject>(sendEntity.size());
            for (DynamicObject sendEntry : sendEntity) {
                String giftSaleOption = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"giftsaleoption");
                if (StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)BizTypeEnum.CHANGE.getValue()) && StringUtils.equals((CharSequence)srcChangeItemType, (CharSequence)"2") && (!isReturn && "0".equals(giftSaleOption) || isReturn && "1".equals(giftSaleOption))) {
                    ++deleteRow;
                    deleteEntity.add(sendEntry);
                    continue;
                }
                int inisendseq = sendEntry.getInt("inisendseq");
                if (inisendseq > 0 && iniSendSeqLst.contains(inisendseq)) {
                    deleteEntity.add(sendEntry);
                    continue;
                }
                iniSendSeqLst.add(inisendseq);
                SaleOrderPushHelper.updateManualSendExeGoodsSeq(sendEntry, srcSeqRetSeqMap);
                int seq = sendEntry.getInt("seq");
                DynamicObject goodsEntry = manualSendSrcSeqGoodsEntryMap.get(seq);
                if (goodsEntry != null && deleteRow > 0) {
                    int promoteSeq = DynamicObjectUtils.getInt((DynamicObject)goodsEntry, (String)"promoteseq");
                    goodsEntry.set("promoteseq", (Object)(promoteSeq - deleteRow));
                }
                if (!isSetEmptyByChangeItemType) continue;
                sendEntry.set("inisendseq", (Object)0);
                sendEntry.set("inisendgoodsseq", (Object)"");
                sendEntry.set("seq", (Object)rowSeq++);
            }
            if (!CollectionUtils.isEmpty(deleteEntity)) {
                sendEntity.removeAll(deleteEntity);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(ticketSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity")))) {
            int rowSeq = 1;
            ArrayList<Integer> iniTicketSeqLst = new ArrayList<Integer>(ticketSendEntity.size());
            ArrayList<DynamicObject> deleteTicketEntity = new ArrayList<DynamicObject>(ticketSendEntity.size());
            for (DynamicObject sendEntry : ticketSendEntity) {
                String[] lstSendGoodsSeq;
                String ticketSaleOption = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"ticketsaleoption");
                if (StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)BizTypeEnum.CHANGE.getValue()) && StringUtils.equals((CharSequence)srcChangeItemType, (CharSequence)"2") && (!isReturn && ticketSaleOption.equals("0") || isReturn && ticketSaleOption.equals("1"))) {
                    deleteTicketEntity.add(sendEntry);
                    continue;
                }
                int initicketseq = sendEntry.getInt("initicketseq");
                if (initicketseq > 0 && iniTicketSeqLst.contains(initicketseq)) {
                    deleteTicketEntity.add(sendEntry);
                    continue;
                }
                iniTicketSeqLst.add(initicketseq);
                StringBuilder seqSb = new StringBuilder();
                String iniTicketGoodsSeq = sendEntry.getString("initicketgoodsseq");
                if (StringUtils.isEmpty((CharSequence)iniTicketGoodsSeq)) {
                    iniTicketGoodsSeq = sendEntry.getString("goodsseq");
                }
                for (String goodsSeq : lstSendGoodsSeq = iniTicketGoodsSeq.split(",")) {
                    String newSeq = srcSeqRetSeqMap.get(goodsSeq);
                    if (newSeq == null) continue;
                    seqSb.append(newSeq).append(',');
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("goodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                } else {
                    sendEntry.set("goodsseq", (Object)"");
                }
                if (!isSetEmptyByChangeItemType) continue;
                sendEntry.set("initicketseq", (Object)0);
                sendEntry.set("initicketgoodsseq", (Object)"");
                sendEntry.set("seq", (Object)rowSeq++);
            }
            if (!CollectionUtils.isEmpty(deleteTicketEntity)) {
                ticketSendEntity.removeAll(deleteTicketEntity);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(pointSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity")))) {
            int rowSeq = 1;
            ArrayList<Integer> iniPointSeqLst = new ArrayList<Integer>(pointSendEntity.size());
            ArrayList<DynamicObject> deletePointEntity = new ArrayList<DynamicObject>(pointSendEntity.size());
            for (DynamicObject sendEntry : pointSendEntity) {
                String[] lstSendGoodsSeq;
                String pointSaleOption = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"pointsaleoption");
                if (StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)BizTypeEnum.CHANGE.getValue()) && StringUtils.equals((CharSequence)srcChangeItemType, (CharSequence)"2") && (!isReturn && pointSaleOption.equals("0") || isReturn && pointSaleOption.equals("1"))) {
                    deletePointEntity.add(sendEntry);
                    continue;
                }
                int inipointseq = sendEntry.getInt("inipointseq");
                if (inipointseq > 0 && iniPointSeqLst.contains(inipointseq)) {
                    deletePointEntity.add(sendEntry);
                    continue;
                }
                iniPointSeqLst.add(inipointseq);
                StringBuilder seqSb = new StringBuilder();
                String iniPointGoodsSeq = sendEntry.getString("inipointgoodsseq");
                if (StringUtils.isEmpty((CharSequence)iniPointGoodsSeq)) {
                    iniPointGoodsSeq = sendEntry.getString("insgoodsseq");
                }
                for (String goodsSeq : lstSendGoodsSeq = iniPointGoodsSeq.split(",")) {
                    String newSeq = srcSeqRetSeqMap.get(goodsSeq);
                    if (newSeq == null) continue;
                    seqSb.append(newSeq).append(',');
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("insgoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                } else {
                    sendEntry.set("insgoodsseq", (Object)"");
                }
                if (!isSetEmptyByChangeItemType) continue;
                sendEntry.set("inipointseq", (Object)0);
                sendEntry.set("inipointgoodsseq", (Object)"");
                sendEntry.set("seq", (Object)rowSeq++);
            }
            if (!CollectionUtils.isEmpty(deletePointEntity)) {
                pointSendEntity.removeAll(deletePointEntity);
            }
        }
    }

    private static void updatePromoteSendExeGoodsSeq(DynamicObject promoteEntry, Map<String, String> srcSeqRetSeqMap, DynamicObject goodsEntry) {
        String[] lstExeGoodsSeq;
        StringBuilder seqSb = new StringBuilder();
        String iniExeGoodsSeq = DynamicObjectUtils.getString((DynamicObject)promoteEntry, (String)"iniexegoodsseq");
        for (String goodsSeq : lstExeGoodsSeq = iniExeGoodsSeq.split(",")) {
            String newSeq = srcSeqRetSeqMap.get(goodsSeq);
            if (newSeq == null) continue;
            seqSb.append(newSeq).append(',');
        }
        if (seqSb.length() > 0) {
            promoteEntry.set("exegoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
            promoteEntry.set("promotegoodsseq", (Object)DynamicObjectUtils.getInt((DynamicObject)goodsEntry, (String)"seq"));
        } else {
            promoteEntry.set("exegoodsseq", (Object)"");
            promoteEntry.set("promotegoodsseq", (Object)0);
        }
    }

    private static void updateManualSendExeGoodsSeq(DynamicObject sendEntry, Map<String, String> srcSeqRetSeqMap) {
        String[] lstSendGoodsSeq;
        StringBuilder seqSb = new StringBuilder();
        String iniSendGoodsSeq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"inisendgoodsseq");
        if (StringUtils.isEmpty((CharSequence)iniSendGoodsSeq)) {
            iniSendGoodsSeq = sendEntry.getString("sendgoodsseq");
        }
        for (String goodsSeq : lstSendGoodsSeq = iniSendGoodsSeq.split(",")) {
            String newSeq = srcSeqRetSeqMap.get(goodsSeq);
            if (newSeq == null) continue;
            seqSb.append(newSeq).append(',');
        }
        if (seqSb.length() > 0) {
            sendEntry.set("sendgoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
        } else {
            sendEntry.set("sendgoodsseq", (Object)"");
        }
    }

    public static void updateChangeBillTargartFinEntity(DynamicObject dataEntity) {
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        Map tgtBillMap = BFTrackerServiceHelper.findTargetBills((String)"ocpos_salechange", (Long[])new Long[]{billId});
        if (tgtBillMap != null && tgtBillMap.size() > 0) {
            HashSet saleReturnIds;
            DynamicObject[] saleOrderBills = null;
            DynamicObject[] saleReturnBills = null;
            HashSet saleOrderIds = (HashSet)tgtBillMap.get("ocpos_saleorder");
            if (saleOrderIds != null && saleOrderIds.size() > 0) {
                DynamicObjectType billDt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder");
                saleOrderBills = BusinessDataServiceHelper.load((Object[])saleOrderIds.toArray(), (DynamicObjectType)billDt);
            }
            if ((saleReturnIds = (HashSet)tgtBillMap.get("ocpos_saleorder_return")) != null && saleReturnIds.size() > 0) {
                DynamicObjectType billDt = (DynamicObjectType)ORM.create().getDataEntityType("ocpos_saleorder_return");
                saleReturnBills = BusinessDataServiceHelper.load((Object[])saleReturnIds.toArray(), (DynamicObjectType)billDt);
            }
            DynamicObject returnopr = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"returnopr");
            DynamicObject cashreceiver = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"cashreceiver");
            DynamicObject debitopr = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"debitopr");
            DynamicObject giftopr = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"giftopr");
            DynamicObject changepriceopr = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"changepriceopr");
            DynamicObject discountopr = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"discountopr");
            Date saleStartTime = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"salestarttime");
            Date saleEndTime = DynamicObjectUtils.getDate((DynamicObject)dataEntity, (String)"saleendtime");
            String changeItemType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
            BigDecimal receivableAmount = dataEntity.getBigDecimal("receivableamount");
            BigDecimal exchangePayAmount = dataEntity.getBigDecimal("exchangepayamount");
            if (saleOrderBills != null && saleOrderBills.length > 0) {
                for (DynamicObject saleOrderBill : saleOrderBills) {
                    saleOrderBill.set("returnopr", (Object)returnopr);
                    saleOrderBill.set("cashreceiver", (Object)cashreceiver);
                    saleOrderBill.set("debitopr", (Object)debitopr);
                    saleOrderBill.set("giftopr", (Object)giftopr);
                    saleOrderBill.set("changepriceopr", (Object)changepriceopr);
                    saleOrderBill.set("discountopr", (Object)discountopr);
                    saleOrderBill.set("salestarttime", (Object)saleStartTime);
                    saleOrderBill.set("saleendtime", (Object)saleEndTime);
                    String orderStatus = DynamicObjectUtils.getString((DynamicObject)saleOrderBill, (String)"orderstatus");
                    SaleOrderWriteBackHelper.addSaleChangeFinEntityAndPaymentFlow(saleOrderBill, "ocpos_saleorder", exchangePayAmount, orderStatus);
                    if (StringUtils.equals((CharSequence)changeItemType, (CharSequence)"2")) {
                        SaleOrderHelper.doSendHandle(saleOrderBill.getDataEntityType().getName(), saleOrderBill);
                    }
                    if (receivableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    SaleOrderPushHelper.billAutoPushSaleOrderAudit(saleOrderBill, "ocpos_saleorder");
                }
            }
            if (saleReturnBills != null && saleReturnBills.length > 0) {
                HashMap<Integer, String> sendSeqRetTypeMap = new HashMap<Integer, String>(0);
                DynamicObjectCollection goodsendentity = dataEntity.getDynamicObjectCollection("goodsendentity");
                if (!CollectionUtils.isEmpty((Collection)goodsendentity)) {
                    for (DynamicObject sendEntry : goodsendentity) {
                        String giftsaleoption = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"giftsaleoption");
                        if (!StringUtils.equals((CharSequence)giftsaleoption, (CharSequence)"0")) continue;
                        int sendSeq = DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"seq");
                        String giftRetType = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"giftrettype");
                        if (sendSeq <= 0 || !StringUtils.isNotEmpty((CharSequence)giftRetType)) continue;
                        sendSeqRetTypeMap.put(sendSeq, giftRetType);
                    }
                }
                for (DynamicObject saleReturnBill : saleReturnBills) {
                    DynamicObjectCollection rtgoodsendentity;
                    saleReturnBill.set("returnopr", (Object)returnopr);
                    saleReturnBill.set("cashreceiver", (Object)cashreceiver);
                    saleReturnBill.set("debitopr", (Object)debitopr);
                    saleReturnBill.set("giftopr", (Object)giftopr);
                    saleReturnBill.set("changepriceopr", (Object)changepriceopr);
                    saleReturnBill.set("discountopr", (Object)discountopr);
                    saleReturnBill.set("salestarttime", (Object)saleStartTime);
                    saleReturnBill.set("saleendtime", (Object)saleEndTime);
                    if (sendSeqRetTypeMap.size() > 0 && !CollectionUtils.isEmpty((Collection)(rtgoodsendentity = saleReturnBill.getDynamicObjectCollection("goodsendentity")))) {
                        for (DynamicObject rtSendEntry : rtgoodsendentity) {
                            int rtSendSeq = DynamicObjectUtils.getInt((DynamicObject)rtSendEntry, (String)"seq");
                            String giftRetType = (String)sendSeqRetTypeMap.get(rtSendSeq);
                            if (!StringUtils.isNotEmpty((CharSequence)giftRetType)) continue;
                            rtSendEntry.set("giftrettype", (Object)giftRetType);
                        }
                    }
                    String orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus(saleReturnBill);
                    SaleOrderWriteBackHelper.addSaleChangeFinEntityAndPaymentFlow(saleReturnBill, "ocpos_saleorder_return", exchangePayAmount, orderStatus);
                    if (receivableAmount.compareTo(BigDecimal.ZERO) <= 0) continue;
                    SaleOrderPushHelper.billAutoPushSaleOrderAudit(saleReturnBill, "ocpos_saleorder_return");
                }
            }
        }
    }

    public static void mergeSendTicketPointEntitys(DynamicObject dataEntity) {
        DynamicObjectCollection pointSendEntity;
        DynamicObjectCollection ticketSendEntity;
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int goodsSeq = 1;
        int promoteSeq = 1;
        int groupSeq = 1;
        HashMap<Integer, Integer> srcGoodsSeqNewSeqMap = new HashMap<Integer, Integer>(0);
        HashMap<Integer, Integer> promoteSeqGroupSeqMap = new HashMap<Integer, Integer>(0);
        HashMap<Integer, HashMap<Integer, Integer>> groupSrcGoodsSeqNewSeqMap = new HashMap<Integer, HashMap<Integer, Integer>>(0);
        String sourceBillNo = "";
        for (DynamicObject goodsEntry : entryEntity) {
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)goodsEntry, (String)"ispresent");
            String entrySrcBillNo = DynamicObjectUtils.getString((DynamicObject)goodsEntry, (String)"entrysrcbillno");
            if (StringUtils.isEmpty((CharSequence)sourceBillNo)) {
                sourceBillNo = entrySrcBillNo;
            }
            if (!StringUtils.equals((CharSequence)sourceBillNo, (CharSequence)entrySrcBillNo)) {
                sourceBillNo = entrySrcBillNo;
                srcGoodsSeqNewSeqMap = new HashMap(0);
                ++groupSeq;
            }
            if (isPresent) {
                promoteSeqGroupSeqMap.put(promoteSeq, groupSeq);
                goodsEntry.set("promoteseq", (Object)promoteSeq++);
            } else {
                int srcSeq = DynamicObjectUtils.getInt((DynamicObject)goodsEntry, (String)"srcseq");
                srcGoodsSeqNewSeqMap.put(srcSeq, goodsSeq);
            }
            if (srcGoodsSeqNewSeqMap.size() > 0) {
                groupSrcGoodsSeqNewSeqMap.put(groupSeq, srcGoodsSeqNewSeqMap);
            }
            ++goodsSeq;
        }
        if (groupSrcGoodsSeqNewSeqMap.size() == 0) {
            return;
        }
        DynamicObjectCollection sendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity");
        if (!CollectionUtils.isEmpty((Collection)sendEntity)) {
            int sendSeq = 1;
            for (Object sendEntry : sendEntity) {
                String[] lstSendGoodsSeq;
                Integer sendGroupSeq;
                Map sendGoodsSeqSrcSeqMap;
                StringBuilder seqSb = new StringBuilder();
                if ((sendGoodsSeqSrcSeqMap = (Map)groupSrcGoodsSeqNewSeqMap.get(sendGroupSeq = (Integer)promoteSeqGroupSeqMap.get(sendSeq++))) == null || sendGoodsSeqSrcSeqMap.size() <= 0) continue;
                String iniSendGoodsSeq = sendEntry.getString("inisendgoodsseq");
                for (String sendGoodsSeq : lstSendGoodsSeq = iniSendGoodsSeq.split(",")) {
                    Integer newSeq = (Integer)sendGoodsSeqSrcSeqMap.get(CommonUtil.formatStringToInt((String)sendGoodsSeq));
                    if (newSeq == null || newSeq <= 0) continue;
                    seqSb.append(newSeq).append(',');
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("sendgoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                    continue;
                }
                sendEntry.set("sendgoodsseq", (Object)"");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(ticketSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity")))) {
            int ticketSeq = 1;
            for (DynamicObject sendEntry : ticketSendEntity) {
                String[] lstSendGoodsSeq;
                Integer sendGroupSeq;
                Map sendGoodsSeqSrcSeqMap;
                StringBuilder seqSb = new StringBuilder();
                if ((sendGoodsSeqSrcSeqMap = (Map)groupSrcGoodsSeqNewSeqMap.get(sendGroupSeq = (Integer)promoteSeqGroupSeqMap.get(ticketSeq++))) == null || sendGoodsSeqSrcSeqMap.size() <= 0) continue;
                String iniTicketGoodsSeq = sendEntry.getString("initicketgoodsseq");
                for (String ticketGoodsSeq : lstSendGoodsSeq = iniTicketGoodsSeq.split(",")) {
                    Integer newSeq = (Integer)sendGoodsSeqSrcSeqMap.get(CommonUtil.formatStringToInt((String)ticketGoodsSeq));
                    if (newSeq == null) continue;
                    seqSb.append(newSeq).append(',');
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("goodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                    continue;
                }
                sendEntry.set("goodsseq", (Object)"");
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(pointSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity")))) {
            int pointSeq = 1;
            for (DynamicObject sendEntry : pointSendEntity) {
                String[] lstSendGoodsSeq;
                Integer sendGroupSeq;
                Map sendGoodsSeqSrcSeqMap;
                StringBuilder seqSb = new StringBuilder();
                if ((sendGoodsSeqSrcSeqMap = (Map)groupSrcGoodsSeqNewSeqMap.get(sendGroupSeq = (Integer)promoteSeqGroupSeqMap.get(pointSeq++))) == null || sendGoodsSeqSrcSeqMap.size() <= 0) continue;
                String iniPointGoodsSeq = sendEntry.getString("inipointgoodsseq");
                for (String pointGoodsSeq : lstSendGoodsSeq = iniPointGoodsSeq.split(",")) {
                    Integer newSeq = (Integer)sendGoodsSeqSrcSeqMap.get(CommonUtil.formatStringToInt((String)pointGoodsSeq));
                    if (newSeq == null) continue;
                    seqSb.append(newSeq).append(',');
                }
                if (seqSb.length() > 0) {
                    sendEntry.set("insgoodsseq", (Object)seqSb.substring(0, seqSb.length() - 1));
                    continue;
                }
                sendEntry.set("insgoodsseq", (Object)"");
            }
        }
        SaleOrderPushHelper.clearSourceInfo(dataEntity);
    }

    public static void clearSourceInfo(DynamicObject dataEntity) {
        DynamicObject baseBillType = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"basebilltype");
        long baseBillTypeId = DynamicObjectUtils.getPkValue((DynamicObject)baseBillType);
        if (baseBillTypeId == BillTypeEnum.GUIDE.getId() || baseBillTypeId == BillTypeEnum.GROUP.getId()) {
            DynamicObjectCollection pointSendEntity;
            DynamicObjectCollection ticketSendEntity;
            DynamicObjectCollection sendEntity;
            dataEntity.set("initialbillid", (Object)0L);
            dataEntity.set("sourcebillid", (Object)0L);
            DynamicObjectCollection goodsEntryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
            if (!CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
                for (Object goodsEntry : goodsEntryEntity) {
                    goodsEntry.set("entrysrcbillid", (Object)0L);
                    goodsEntry.set("srcseq", (Object)0);
                    DynamicObjectCollection salesOrderPromote = goodsEntry.getDynamicObjectCollection("salesorderpromote");
                    for (DynamicObject promoteEntry : salesOrderPromote) {
                        promoteEntry.set("iniexegoodsseq", (Object)"");
                        promoteEntry.set("srcpromotegoodsseq", (Object)0);
                    }
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(sendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsendentity")))) {
                for (Object sendEntry : sendEntity) {
                    sendEntry.set("inisendseq", (Object)0);
                    sendEntry.set("inisendgoodsseq", (Object)"");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(ticketSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"ticketsendentity")))) {
                for (DynamicObject ticketSendEntry : ticketSendEntity) {
                    ticketSendEntry.set("initicketseq", (Object)0);
                    ticketSendEntry.set("initicketgoodsseq", (Object)"");
                }
            }
            if (!CollectionUtils.isEmpty((Collection)(pointSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"sendintegralentity")))) {
                for (DynamicObject pointSendEntry : pointSendEntity) {
                    pointSendEntry.set("inipointseq", (Object)0);
                    pointSendEntry.set("inipointgoodsseq", (Object)"");
                }
            }
        }
    }

    public static void pushChangeBillCreateNewGoodsEntity(DynamicObject dataEntity, JSONObject paramJson) {
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        long orgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
        String changeItemType = paramJson.getString("changeitemtype");
        String makeUpBalanceMode = paramJson.getString("makeupbalancemode");
        dataEntity.set("changeitemtype", (Object)changeItemType);
        dataEntity.set("makeupbalancemode", (Object)makeUpBalanceMode);
        ArrayList<DynamicObject> newGoodsEntity = new ArrayList<DynamicObject>(entryEntities.size());
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObject newGoodsEntry = new DynamicObject(entryEntity.getDynamicObjectType());
            newGoodsEntry.set("saleoption", (Object)"1");
            newGoodsEntry.set("goodssaler", dataEntity.get("saler"));
            if (StringUtils.equals((CharSequence)changeItemType, (CharSequence)"1") || StringUtils.equals((CharSequence)changeItemType, (CharSequence)"3")) {
                SaleOrderPushHelper.copySaleRowEntity(newGoodsEntry, entryEntity, changeItemType);
                newGoodsEntity.add(newGoodsEntry);
                continue;
            }
            newGoodsEntry.set("channelstocktypeid", entryEntity.get("channelstocktypeid"));
            newGoodsEntry.set("srcbillentryid", entryEntity.get("srcbillentryid"));
            DynamicObject saler = DynamicObjectUtils.getDynamicObject((DynamicObject)dataEntity, (String)"saler");
            Object dpt = CommonUtils.getDeptObj((DynamicObject)saler);
            newGoodsEntry.set("saledepartment", dpt);
            newGoodsEntity.add(newGoodsEntry);
            break;
        }
        if (newGoodsEntity.size() > 0) {
            entryEntities.addAll(newGoodsEntity);
        }
        SaleOrderPushHelper.setCustomerParam(dataEntity, entryEntities, paramJson);
        SaleOrderPushHelper.setChangeBillDeliveryStatusStockType(dataEntity, orgId, changeItemType, makeUpBalanceMode);
    }

    private static void copySaleRowEntity(DynamicObject newGoodsEntry, DynamicObject entryEntity, String changeType) {
        newGoodsEntry.set("goodsid", entryEntity.get("goodsid"));
        newGoodsEntry.set("materielid", entryEntity.get("materielid"));
        newGoodsEntry.set("materialinv", entryEntity.get("materialinv"));
        newGoodsEntry.set("barcode", entryEntity.get("barcode"));
        newGoodsEntry.set("goodsclass", entryEntity.get("goodsclass"));
        newGoodsEntry.set("brand", entryEntity.get("brand"));
        newGoodsEntry.set("auxattrid", entryEntity.get("auxattrid"));
        newGoodsEntry.set("unit", entryEntity.get("unit"));
        newGoodsEntry.set("baseunit", entryEntity.get("baseunit"));
        newGoodsEntry.set("auxunit", entryEntity.get("auxunit"));
        newGoodsEntry.set("stockunit", entryEntity.get("stockunit"));
        newGoodsEntry.set("retailprice", entryEntity.get("retailprice"));
        newGoodsEntry.set("realprice", entryEntity.get("realprice"));
        newGoodsEntry.set("discountprice", entryEntity.get("discountprice"));
        newGoodsEntry.set("discountrate", entryEntity.get("discountrate"));
        newGoodsEntry.set("discountreasonid", entryEntity.get("discountreasonid"));
        newGoodsEntry.set("taxrateid", entryEntity.get("taxrateid"));
        newGoodsEntry.set("taxrate", entryEntity.get("taxrate"));
        newGoodsEntry.set("iscontrolprice", entryEntity.get("iscontrolprice"));
        newGoodsEntry.set("pricetypename", entryEntity.get("pricetypename"));
        newGoodsEntry.set("goodssaler", entryEntity.get("goodssaler"));
        if (StringUtils.equals((CharSequence)changeType, (CharSequence)"3")) {
            newGoodsEntry.set("supplier", entryEntity.get("supplier"));
        }
        newGoodsEntry.set("saledepartment", entryEntity.get("saledepartment"));
        newGoodsEntry.set("saleattr", entryEntity.get("saleattr"));
        newGoodsEntry.set("gifttype", entryEntity.get("gifttype"));
        newGoodsEntry.set("promoteseq", entryEntity.get("promoteseq"));
        newGoodsEntry.set("srcseq", entryEntity.get("srcseq"));
        newGoodsEntry.set("inisrcseq", entryEntity.get("inisrcseq"));
        BigDecimal saleQty = entryEntity.getBigDecimal("saleqty");
        BigDecimal auxUnitQty = entryEntity.getBigDecimal("auxunitqty");
        BigDecimal baseUnitQty = entryEntity.getBigDecimal("baseunitqty");
        BigDecimal stockUnitQty = entryEntity.getBigDecimal("stockunitqty");
        BigDecimal amount = entryEntity.getBigDecimal("amount");
        BigDecimal balAmount = entryEntity.getBigDecimal("balamount");
        BigDecimal realAmount = entryEntity.getBigDecimal("realamount");
        BigDecimal lineReceivableAmount = entryEntity.getBigDecimal("linereceivableamount");
        BigDecimal manualDiscount = entryEntity.getBigDecimal("manualdiscount");
        BigDecimal integralDistAmount = entryEntity.getBigDecimal("integraldistamount");
        BigDecimal promotionDiscount = entryEntity.getBigDecimal("promotiondiscount");
        BigDecimal couponDiscount = entryEntity.getBigDecimal("coupondiscount");
        BigDecimal giftDiscountAmount = entryEntity.getBigDecimal("giftdiscountamount");
        BigDecimal stdDiscountAmount = entryEntity.getBigDecimal("stddiscountamount");
        BigDecimal noTinComeDisAmount = entryEntity.getBigDecimal("notincomedisamount");
        BigDecimal ticketShareAmount = entryEntity.getBigDecimal("ticketshareamount");
        BigDecimal sumDiscountAmount = entryEntity.getBigDecimal("sumdiscountamount");
        BigDecimal sumShareDiscount = entryEntity.getBigDecimal("sumsharediscount");
        newGoodsEntry.set("saleqty", (Object)saleQty.negate());
        newGoodsEntry.set("auxunitqty", (Object)auxUnitQty.negate());
        newGoodsEntry.set("baseunitqty", (Object)baseUnitQty.negate());
        newGoodsEntry.set("stockunitqty", (Object)stockUnitQty.negate());
        newGoodsEntry.set("amount", (Object)amount.negate());
        newGoodsEntry.set("balamount", (Object)balAmount.negate());
        newGoodsEntry.set("realamount", (Object)realAmount.negate());
        newGoodsEntry.set("linereceivableamount", (Object)lineReceivableAmount.negate());
        newGoodsEntry.set("manualdiscount", (Object)manualDiscount.negate());
        newGoodsEntry.set("integraldistamount", (Object)integralDistAmount.negate());
        newGoodsEntry.set("promotiondiscount", (Object)promotionDiscount.negate());
        newGoodsEntry.set("coupondiscount", (Object)couponDiscount.negate());
        newGoodsEntry.set("giftdiscountamount", (Object)giftDiscountAmount.negate());
        newGoodsEntry.set("stddiscountamount", (Object)stdDiscountAmount.negate());
        newGoodsEntry.set("notincomedisamount", (Object)noTinComeDisAmount.negate());
        newGoodsEntry.set("ticketshareamount", (Object)ticketShareAmount.negate());
        newGoodsEntry.set("sumdiscountamount", (Object)sumDiscountAmount.negate());
        newGoodsEntry.set("sumsharediscount", (Object)sumShareDiscount.negate());
        newGoodsEntry.set("operationmodel", entryEntity.get("operationmodel"));
        newGoodsEntry.set("srcbillentryid", entryEntity.get("srcbillentryid"));
        boolean isPresent = entryEntity.getBoolean("ispresent");
        newGoodsEntry.set("ispresent", (Object)isPresent);
        if (isPresent) {
            newGoodsEntry.set("ischangenewgift", (Object)Boolean.TRUE);
        }
        ArrayList<DynamicObject> addDeliveryRows = new ArrayList<DynamicObject>();
        DynamicObjectCollection changeDeliveryEntry = newGoodsEntry.getDynamicObjectCollection("salesorderdelivery");
        DynamicObjectType deliveryEntryType = changeDeliveryEntry.getDynamicObjectType();
        DynamicObjectCollection deliveryEntity = entryEntity.getDynamicObjectCollection("salesorderdelivery");
        for (DynamicObject deliveryItem : deliveryEntity) {
            DynamicObject newDeliveryEntry = new DynamicObject(deliveryEntryType);
            BigDecimal deliverySaleQty = deliveryItem.getBigDecimal("deliversaleqty");
            BigDecimal deliveryStockUnitQty = deliveryItem.getBigDecimal("deliverystockunitqty");
            BigDecimal deliveryAuxUnitQty = deliveryItem.getBigDecimal("deliveryauxunitqty");
            BigDecimal deliveryBaseUnitQty = deliveryItem.getBigDecimal("deliverybaseunitqty");
            newDeliveryEntry.set("deliversaleqty", (Object)deliverySaleQty.negate());
            newDeliveryEntry.set("deliverystockunitqty", (Object)deliveryStockUnitQty.negate());
            newDeliveryEntry.set("deliveryauxunitqty", (Object)deliveryAuxUnitQty.negate());
            newDeliveryEntry.set("deliverybaseunitqty", (Object)deliveryBaseUnitQty.negate());
            newDeliveryEntry.set("deliveryavareturnqty", (Object)deliverySaleQty.negate());
            newDeliveryEntry.set("delivergoodsid", deliveryItem.get("delivergoodsid"));
            newDeliveryEntry.set("billid", deliveryItem.get("billid"));
            newDeliveryEntry.set("deliverymaterial", deliveryItem.get("deliverymaterial"));
            newDeliveryEntry.set("deliverbarcodeid", deliveryItem.get("deliverbarcodeid"));
            newDeliveryEntry.set("delivergoodsclass", deliveryItem.get("delivergoodsclass"));
            newDeliveryEntry.set("brandid", deliveryItem.get("brandid"));
            newDeliveryEntry.set("deliverunitid", deliveryItem.get("deliverunitid"));
            newDeliveryEntry.set("deliverystockunit", deliveryItem.get("deliverystockunit"));
            newDeliveryEntry.set("deliveryauxunit", deliveryItem.get("deliveryauxunit"));
            newDeliveryEntry.set("deliverybaseunit", deliveryItem.get("deliverybaseunit"));
            newDeliveryEntry.set("consignee", deliveryItem.get("consignee"));
            newDeliveryEntry.set("deliverphonenumber", deliveryItem.get("deliverphonenumber"));
            newDeliveryEntry.set("districtid", deliveryItem.get("districtid"));
            newDeliveryEntry.set("address", deliveryItem.get("address"));
            newDeliveryEntry.set("fulladdress", deliveryItem.get("fulladdress"));
            newDeliveryEntry.set("comment", deliveryItem.get("comment"));
            newDeliveryEntry.set("deliverisdelivery", deliveryItem.get("deliverisdelivery"));
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)"3") || isPresent) {
                newDeliveryEntry.set("isselfpickup", deliveryItem.get("isselfpickup"));
                newDeliveryEntry.set("selfpickuptime", deliveryItem.get("selfpickuptime"));
                newDeliveryEntry.set("deliverymode", deliveryItem.get("deliverymode"));
                newDeliveryEntry.set("deliverdeliverytime", deliveryItem.get("deliverdeliverytime"));
                newDeliveryEntry.set("deliverisinstall", deliveryItem.get("deliverisinstall"));
                newDeliveryEntry.set("deliverinstalltime", deliveryItem.get("deliverinstalltime"));
                newDeliveryEntry.set("deliverdeliverybranchid", deliveryItem.get("deliverdeliverybranchid"));
                newDeliveryEntry.set("deliverstockid", deliveryItem.get("deliverstockid"));
                newDeliveryEntry.set("stockpositionid", deliveryItem.get("stockpositionid"));
                newDeliveryEntry.set("inventoryorgid", deliveryItem.get("inventoryorgid"));
                newDeliveryEntry.set("erpstockid", deliveryItem.get("erpstockid"));
                newDeliveryEntry.set("erpstockpositionid", deliveryItem.get("erpstockpositionid"));
                newDeliveryEntry.set("deliverykeepertype", deliveryItem.get("deliverykeepertype"));
                newDeliveryEntry.set("deliverykeeper", deliveryItem.get("deliverykeeper"));
                newDeliveryEntry.set("deliveryownertype", deliveryItem.get("deliveryownertype"));
                newDeliveryEntry.set("deliveryowner", deliveryItem.get("deliveryowner"));
                newDeliveryEntry.set("deliverystockstatus", deliveryItem.get("deliverystockstatus"));
                newDeliveryEntry.set("deliveryinventoryupdate", deliveryItem.get("deliveryinventoryupdate"));
                newDeliveryEntry.set("deliveryisreserve", deliveryItem.get("deliveryisreserve"));
                newDeliveryEntry.set("deliveryisnegativesell", deliveryItem.get("deliveryisnegativesell"));
            }
            if (StringUtils.equals((CharSequence)changeType, (CharSequence)"3")) {
                newDeliveryEntry.set("deliverystatus", deliveryItem.get("srcdeliverystatus"));
            }
            newDeliveryEntry.set("deliverystocktype", deliveryItem.get("deliverystocktype"));
            newDeliveryEntry.set("srcdeliveryentryid", deliveryItem.get("srcdeliveryentryid"));
            addDeliveryRows.add(newDeliveryEntry);
        }
        if (!CollectionUtils.isEmpty(addDeliveryRows)) {
            changeDeliveryEntry.addAll(addDeliveryRows);
        }
        SaleOrderPushHelper.changeTypeAddPromoteEntity(entryEntity, newGoodsEntry);
    }

    public static void setCustomerParam(DynamicObject dataEntity, DynamicObjectCollection entryEntities, JSONObject paramJson) {
        String orderSource = paramJson.getString("ordersource");
        if (StringUtils.equalsIgnoreCase((CharSequence)orderSource, (CharSequence)"D") || StringUtils.equalsIgnoreCase((CharSequence)orderSource, (CharSequence)"E")) {
            dataEntity.set("ordersource", (Object)orderSource);
            for (DynamicObject entryEntity : entryEntities) {
                String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
                if (!StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) continue;
                boolean isSelfPickUp = paramJson.getBoolean("isselfpickup");
                DynamicObjectCollection deliveryEntryEntity = entryEntity.getDynamicObjectCollection("salesorderdelivery");
                for (DynamicObject deliveryEntry : deliveryEntryEntity) {
                    deliveryEntry.set("isselfpickup", (Object)isSelfPickUp);
                    deliveryEntry.set("deliverisdelivery", (Object)(!isSelfPickUp ? 1 : 0));
                    deliveryEntry.set("expressno", (Object)paramJson.getString("expressno"));
                    deliveryEntry.set("expresscomp", (Object)paramJson.getLong("expresscomp"));
                    deliveryEntry.set("deliverphonenumber", (Object)paramJson.getString("deliverphonenumber"));
                    deliveryEntry.set("districtid", (Object)paramJson.getLong("districtid"));
                    deliveryEntry.set("address", (Object)paramJson.getString("address"));
                    deliveryEntry.set("selfpickuptime", (Object)paramJson.getDate("selfpickuptime"));
                    deliveryEntry.set("returnreason", (Object)paramJson.getLong("returnreason"));
                    deliveryEntry.set("returntype", (Object)paramJson.getString("returntype"));
                    String comment = deliveryEntry.getString("comment");
                    deliveryEntry.set("comment", (Object)(comment + paramJson.getString("comment")));
                }
            }
        }
    }

    private static void setChangeBillDeliveryStatusStockType(DynamicObject changeBill, long orgId, String changeItemType, String makeUpBalanceMode) {
        Map<String, Object> resultRuleMap;
        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)changeBill, (String)"salebranchid");
        boolean isCtrlWithReturnRule = SystemParamUtil.getIsCtrlWithReturnRule((long)orgId, (long)branchId);
        Object sysChangeDefInvType = SystemParamUtil.getChangeDefectDefInvType((long)orgId, (long)branchId);
        Object sysSaleOrderDefInvType = SystemParamUtil.getSaleOrderDefInvType((long)orgId, (long)branchId);
        DynamicObject returnDeliveryStatus = null;
        DynamicObject retRowDeliveryStatus = null;
        DynamicObject saleRowDeliverStatus = null;
        if (StringUtils.equals((CharSequence)changeItemType, (CharSequence)"3")) {
            returnDeliveryStatus = BusinessDataServiceHelper.loadSingle((Object)1026080809389766656L, (String)"ococic_deliverstatus");
        } else {
            if (!isCtrlWithReturnRule) {
                retRowDeliveryStatus = BusinessDataServiceHelper.loadSingle((Object)1026080127278495744L, (String)"ococic_deliverstatus");
            }
            saleRowDeliverStatus = BusinessDataServiceHelper.loadSingle((Object)DeliveryStatus.SALE_WAIT_DELIVERY, (String)"ococic_deliverstatus");
        }
        if (isCtrlWithReturnRule && !StringUtils.equals((CharSequence)changeItemType, (CharSequence)"3") && isCtrlWithReturnRule && !CollectionUtils.isEmpty(resultRuleMap = SaleOrderReturnRuleHelper.matchRedReturnRuleBySaleOrder(changeBill, "srcdeliverystatus")) && CommonUtil.formatObjectToBoolean((Object)resultRuleMap.get("success"))) {
            Map returnRuleMap = (Map)resultRuleMap.get("returnrulemap");
            SaleOrderReturnRuleHelper.fillSaleReturnEntryByReturnRule(changeBill, returnRuleMap);
        }
        DynamicObjectCollection entryEntity = changeBill.getDynamicObjectCollection("goodsentryentity");
        for (DynamicObject entryEntry : entryEntity) {
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntry, (String)"ispresent");
            if (isPresent) continue;
            String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntry, (String)"saleoption");
            DynamicObjectCollection deliveryEntity = entryEntry.getDynamicObjectCollection("salesorderdelivery");
            for (DynamicObject deliveryEntry : deliveryEntity) {
                if (StringUtils.equals((CharSequence)changeItemType, (CharSequence)"3")) {
                    if (StringUtils.equals((CharSequence)makeUpBalanceMode, (CharSequence)"0")) {
                        deliveryEntry.set("deliverystocktype", sysChangeDefInvType);
                    }
                    if (!StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) continue;
                    deliveryEntry.set("deliverystatus", (Object)returnDeliveryStatus);
                    continue;
                }
                if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                    if (isCtrlWithReturnRule) continue;
                    deliveryEntry.set("deliverystocktype", sysChangeDefInvType);
                    deliveryEntry.set("deliverystatus", (Object)retRowDeliveryStatus);
                    continue;
                }
                deliveryEntry.set("deliverystocktype", sysSaleOrderDefInvType);
                deliveryEntry.set("deliverystatus", (Object)saleRowDeliverStatus);
            }
        }
    }

    private static void changeTypeAddPromoteEntity(DynamicObject entryEntity, DynamicObject changeItem) {
        DynamicObjectCollection srcPromoteEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)entryEntity, (String)"salesorderpromote");
        if (CollectionUtils.isEmpty((Collection)srcPromoteEntities)) {
            return;
        }
        DynamicObjectCollection promoteEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)changeItem, (String)"salesorderpromote");
        if (promoteEntities == null) {
            return;
        }
        promoteEntities.clear();
        DataEntityPropertyCollection properties = promoteEntities.getDynamicObjectType().getProperties();
        for (DynamicObject srcPromoteEntity : srcPromoteEntities) {
            DynamicObject promoteEntity = promoteEntities.addNew();
            block9: for (IDataEntityProperty property : properties) {
                String key;
                switch (key = property.getName()) {
                    case "id": {
                        promoteEntity.set(key, (Object)0L);
                        continue block9;
                    }
                    case "seq": {
                        promoteEntity.set(key, (Object)promoteEntities.getRowCount());
                        continue block9;
                    }
                }
                promoteEntity.set(key, DynamicObjectUtils.get((DynamicObject)srcPromoteEntity, (String)key));
            }
        }
    }

    public static String checkSaleOrderAllowPushOcocBill(DynamicObject dataEntity) {
        String srcBizType = "";
        String billName = dataEntity.getDynamicObjectType().getName();
        srcBizType = billName.equals("ocpos_saleorder_return") ? DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcbillbiztype") : DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcbiztype");
        DynamicObject billType = dataEntity.getDynamicObject("basebilltype");
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)billType);
        long sourceBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        String msg = SaleOrderPushHelper.checkSaleOrderAllowPushOcocBill(billTypeId, srcBizType, sourceBillId);
        return msg;
    }

    public static String checkSaleOrderAllowPushOcocBill(long billTypeId, String srcBizType, long sourceBillId) {
        String msg = "";
        if (billTypeId == BillTypeEnum.STORE.getId()) {
            msg = "\u95e8\u5e97\u5bfc\u8d2d\u5355\u4e0d\u7528\u4e0b\u63a8";
        } else if (StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)"H") && sourceBillId > 0L) {
            String selectFields = "billno,salestatus,receivableamount";
            DynamicObject changeBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_salechange", (String)selectFields);
            String saleStatus = DynamicObjectUtils.getString((DynamicObject)changeBill, (String)"salestatus");
            BigDecimal receivableAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)changeBill, (String)"receivableamount");
            if (!StringUtils.equalsIgnoreCase((CharSequence)saleStatus, (CharSequence)"S") && receivableAmount.compareTo(BigDecimal.ZERO) > 0) {
                msg = String.format("\u96f6\u552e\u6362\u8d27 %s\uff1a\u5e94\u6536\u91d1\u989d > 0\u3001\u672a\u7ed3\u7b97\uff0c\u4e0d\u751f\u6210\u96f6\u552e\u5355\u3001\u9884\u8ba2\u5355", DynamicObjectUtils.getString((DynamicObject)changeBill, (String)"billno"));
            }
        }
        return msg;
    }
}

