/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.occ.ocbase.common.enums.EnableStatusEnum;
import kd.occ.ocbase.common.enums.StatusEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.F7Utils;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderReturnRuleHelper {
    public static List<Map<String, Object>> matchReturnRule(List<Map<String, Object>> params) {
        if (CollectionUtils.isEmpty(params)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<QFilter> filters = new ArrayList<QFilter>(0);
        for (Map<String, Object> param : params) {
            QFilter filter = new QFilter("ruleentry.distributionmode.id", "=", param.get("deliverymodeid"));
            filter.or("ruleentry.deliverstates.id", "=", param.get("deliverystatusid"));
            filters.add(filter);
        }
        filters.add(F7Utils.getCommonStatusFilter());
        String selectFields = "id, ruleentry.id, ruleentry.distributionmode.id, ruleentry.deliverstates.id, ruleentry.isreturn, ruleentry.isrefund, ruleentry.istodeliveryorg, ruleentry.istosaleorg,ruleentry.ischangeappoint,ruleentry.ischangeaddr";
        DynamicObjectCollection returnRules = QueryServiceHelper.query((String)"ococic_returnrule", (String)selectFields, (QFilter[])filters.toArray(new QFilter[filters.size()]));
        if (CollectionUtils.isEmpty((Collection)returnRules)) {
            return new ArrayList<Map<String, Object>>();
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (DynamicObject returnRule : returnRules) {
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            map.put("distributionmode", returnRule.get("ruleentry.distributionmode.id"));
            map.put("deliverstates", returnRule.get("ruleentry.deliverstates.id"));
            map.put("isreturn", returnRule.get("ruleentry.isreturn"));
            map.put("isrefund", returnRule.get("ruleentry.isrefund"));
            map.put("istodeliveryorg", returnRule.get("ruleentry.istodeliveryorg"));
            map.put("istosaleorg", returnRule.get("ruleentry.istosaleorg"));
            map.put("ischangeappoint", returnRule.get("ruleentry.ischangeappoint"));
            map.put("ischangeaddr", returnRule.get("ruleentry.ischangeaddr"));
            list.add(map);
        }
        return list;
    }

    public static boolean isMatchReturnRule(Object distModeId, String deliverstatus) {
        QFilter qFilter = new QFilter("ruleentry.distributionmode", "=", distModeId);
        qFilter.and("ruleentry.deliverstates", "=", (Object)deliverstatus);
        qFilter.and("ruleentry.isreturn", "=", (Object)"1");
        DynamicObject rule = QueryServiceHelper.queryOne((String)"ococic_returnrule", (String)"id", (QFilter[])qFilter.toArray());
        return rule != null;
    }

    public static Map<String, Object> matchRedReturnRuleBySaleOrder(DynamicObject saleOrder, String deliveryStatusKey) {
        long branchId;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"bizorgid");
        boolean isCtrlWithReturnRule = SystemParamUtil.getIsCtrlWithReturnRule((long)bizOrgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"salebranchid")));
        if (!isCtrlWithReturnRule) {
            return null;
        }
        DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
        List<DynamicObject> lstDeliveryEntry = SaleOrderReturnRuleHelper.matchRuleByEntry(goodsEntryEntity);
        if (CollectionUtils.isEmpty(lstDeliveryEntry)) {
            return null;
        }
        return SaleOrderReturnRuleHelper.matchReturnRuleBySubEntry(lstDeliveryEntry, deliveryStatusKey);
    }

    public static Map<String, Object> matchRedRefundRuleBySaleOrder(DynamicObject saleReturn) {
        long branchId;
        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"bizorgid");
        boolean isCtrlWithReturnRule = SystemParamUtil.getIsCtrlWithReturnRule((long)bizOrgId, (long)(branchId = DynamicObjectUtils.getPkValue((DynamicObject)saleReturn, (String)"salebranchid")));
        if (!isCtrlWithReturnRule) {
            return null;
        }
        DynamicObjectCollection goodsEntryEntity = saleReturn.getDynamicObjectCollection("goodsentryentity");
        List<DynamicObject> lstDeliveryEntry = SaleOrderReturnRuleHelper.matchRuleByEntry(goodsEntryEntity);
        if (CollectionUtils.isEmpty(lstDeliveryEntry)) {
            return null;
        }
        return SaleOrderReturnRuleHelper.matchRefundRuleBySubEntry(lstDeliveryEntry, "deliverystatus");
    }

    public static Map<String, Object> matchReturnRuleByEntry(DynamicObjectCollection goodsEntryEntity, String deliveryStatusKey) {
        List<DynamicObject> lstDeliveryEntry = SaleOrderReturnRuleHelper.matchRuleByEntry(goodsEntryEntity);
        if (CollectionUtils.isEmpty(lstDeliveryEntry)) {
            return null;
        }
        return SaleOrderReturnRuleHelper.matchReturnRuleBySubEntry(lstDeliveryEntry, deliveryStatusKey);
    }

    public static Map<String, Object> matchRefundRuleByEntry(DynamicObjectCollection goodsEntryEntity) {
        List<DynamicObject> lstDeliveryEntry = SaleOrderReturnRuleHelper.matchRuleByEntry(goodsEntryEntity);
        if (CollectionUtils.isEmpty(lstDeliveryEntry)) {
            return null;
        }
        return SaleOrderReturnRuleHelper.matchRefundRuleBySubEntry(lstDeliveryEntry, "deliverystatus");
    }

    public static Map<String, Object> matchReturnRuleBySubEntry(List<DynamicObject> subDeliveryEntry, String deliveryStatusKey) {
        Map<String, Object> resultRuleMap = SaleOrderReturnRuleHelper.assembleDeliveryModeBySubEntry(subDeliveryEntry, deliveryStatusKey);
        if (!CommonUtil.formatObjectToBoolean((Object)resultRuleMap.get("success"))) {
            return resultRuleMap;
        }
        Map deliveryModeAndStatusMap = (Map)resultRuleMap.get("keymap");
        return SaleOrderReturnRuleHelper.matchReturnRuleByModeAndStatus(deliveryModeAndStatusMap, deliveryStatusKey, false);
    }

    public static Map<String, Object> matchRefundRuleBySubEntry(List<DynamicObject> subDeliveryEntry, String deliveryStatusKey) {
        Map<String, Object> resultRuleMap = SaleOrderReturnRuleHelper.assembleDeliveryModeBySubEntry(subDeliveryEntry, deliveryStatusKey);
        if (!CommonUtil.formatObjectToBoolean((Object)resultRuleMap.get("success"))) {
            return resultRuleMap;
        }
        Map deliveryModeAndStatusMap = (Map)resultRuleMap.get("keymap");
        return SaleOrderReturnRuleHelper.matchReturnRuleByModeAndStatus(deliveryModeAndStatusMap, deliveryStatusKey, true);
    }

    private static List<DynamicObject> matchRuleByEntry(DynamicObjectCollection goodsEntryEntity) {
        ArrayList<DynamicObject> lstDeliveryEntry = new ArrayList<DynamicObject>();
        for (DynamicObject goods : goodsEntryEntity) {
            DynamicObjectCollection deliveryEntry;
            String saleoption;
            boolean isBook = goods.getBoolean("isbook");
            if (isBook || StringUtils.equals((CharSequence)(saleoption = DynamicObjectUtils.getString((DynamicObject)goods, (String)"saleoption")), (CharSequence)"1") || CollectionUtils.isEmpty((Collection)(deliveryEntry = goods.getDynamicObjectCollection("salesorderdelivery")))) continue;
            lstDeliveryEntry.addAll((Collection<DynamicObject>)deliveryEntry);
        }
        return lstDeliveryEntry;
    }

    private static Map<String, Object> assembleDeliveryModeBySubEntry(List<DynamicObject> lstDeliveryEntry, String deliveryStatusKey) {
        HashMap<String, Object> resultRuleMap = new HashMap<String, Object>();
        HashMap deliveryModeAndStatusMap = new HashMap();
        if (!CollectionUtils.isEmpty(lstDeliveryEntry)) {
            for (DynamicObject deliveryEntry : lstDeliveryEntry) {
                DynamicObject deliveryMode = deliveryEntry.getDynamicObject("deliverymode");
                DynamicObject srcdeliverystatus = deliveryEntry.getDynamicObject(deliveryStatusKey);
                if (deliveryMode == null || srcdeliverystatus == null) {
                    resultRuleMap.put("success", Boolean.FALSE);
                    resultRuleMap.put("msg", "\u914d\u9001\u660e\u7ec6\u7684\u914d\u9001\u65b9\u5f0f\u3001\u53d1\u8d27\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                    return resultRuleMap;
                }
                HashMap<String, DynamicObject> modeAndStatusMap = new HashMap<String, DynamicObject>(2);
                modeAndStatusMap.put("deliverymode", deliveryMode);
                modeAndStatusMap.put(deliveryStatusKey, srcdeliverystatus);
                String modeAndStatusKey = deliveryMode.getPkValue() + "_" + srcdeliverystatus.getPkValue();
                if (deliveryModeAndStatusMap.containsKey(modeAndStatusKey)) continue;
                deliveryModeAndStatusMap.put(modeAndStatusKey, modeAndStatusMap);
            }
        }
        resultRuleMap.put("success", Boolean.TRUE);
        resultRuleMap.put("keymap", deliveryModeAndStatusMap);
        return resultRuleMap;
    }

    public static Map<String, Object> matchReturnRuleByModeAndStatus(Map<String, Map<String, DynamicObject>> deliveryModeAndStatusMap, String deliveryStatusKey, boolean isMatchRefund) {
        HashMap<String, Object> returnRuleResult = new HashMap<String, Object>();
        if (CollectionUtils.isEmpty(deliveryModeAndStatusMap)) {
            returnRuleResult.put("success", Boolean.FALSE);
            returnRuleResult.put("returnrulelist", null);
            returnRuleResult.put("msg", "\u914d\u9001\u660e\u7ec6\u7684\u914d\u9001\u65b9\u5f0f\u3001\u53d1\u8d27\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002");
            return returnRuleResult;
        }
        String tipReturnType = "\u9000\u8d27";
        if (isMatchRefund) {
            tipReturnType = "\u9000\u6b3e";
        }
        StringBuilder rltMsg = new StringBuilder();
        Set<String> lstDeliveryRuleStatus = deliveryModeAndStatusMap.keySet();
        HashMap<String, DynamicObject> returnRuleMap = null;
        DynamicObjectCollection returnRules = SaleOrderReturnRuleHelper.getReturnRuleResult(lstDeliveryRuleStatus);
        if (!CollectionUtils.isEmpty((Collection)returnRules)) {
            returnRuleMap = new HashMap<String, DynamicObject>(returnRules.size());
            for (DynamicObject dynamicObject : returnRules) {
                long distributionModeId = dynamicObject.getLong("ruleentry.distributionmode");
                long deliverstatusId = dynamicObject.getLong("ruleentry.deliverstates");
                String modeAndStatus = distributionModeId + "_" + deliverstatusId;
                Map<String, DynamicObject> deliveryModeStatus = deliveryModeAndStatusMap.get(modeAndStatus);
                DynamicObject distributionMode = deliveryModeStatus.get("deliverymode");
                DynamicObject srcdeliverstatus = deliveryModeStatus.get(deliveryStatusKey);
                returnRuleMap.put(modeAndStatus, dynamicObject);
                if (!isMatchRefund) {
                    boolean isReturn = dynamicObject.getBoolean("ruleentry.isreturn");
                    if (isReturn) continue;
                    rltMsg.append(String.format("\u914d\u9001\u6a21\u5f0f\u4e3a\uff1a%s\uff0c\u53d1\u8d27\u72b6\u6001\u4e3a\uff1a%s\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c%s\u64cd\u4f5c\uff0c\u8bf7\u5148\u66f4\u65b0\u53d1\u8d27\u72b6\u6001\uff0c\u518d\u8fdb\u884c%s\u64cd\u4f5c\u3002", distributionMode.getString("name"), srcdeliverstatus.getString("name"), tipReturnType, tipReturnType));
                    continue;
                }
                boolean isRefund = dynamicObject.getBoolean("ruleentry.isrefund");
                if (isRefund) continue;
                rltMsg.append(String.format("\u914d\u9001\u6a21\u5f0f\u4e3a\uff1a%s\uff0c\u53d1\u8d27\u72b6\u6001\u4e3a\uff1a%s\uff0c\u4e0d\u5141\u8bb8\u8fdb\u884c%s\u64cd\u4f5c\uff0c\u8bf7\u5148\u66f4\u65b0\u53d1\u8d27\u72b6\u6001\uff0c\u518d\u8fdb\u884c%s\u64cd\u4f5c\u3002", distributionMode.getString("name"), srcdeliverstatus.getString("name"), tipReturnType, tipReturnType));
            }
        }
        for (Map.Entry entry : deliveryModeAndStatusMap.entrySet()) {
            String modeAndStatus = (String)entry.getKey();
            if (returnRuleMap != null && returnRuleMap.containsKey(modeAndStatus)) continue;
            Map modeAndStatusMap = (Map)entry.getValue();
            DynamicObject deliverMode = (DynamicObject)modeAndStatusMap.get("deliverymode");
            DynamicObject srcdeliverystatus = (DynamicObject)modeAndStatusMap.get(deliveryStatusKey);
            rltMsg.append(String.format("\u914d\u9001\u6a21\u5f0f\u4e3a\uff1a%s\uff0c\u53d1\u8d27\u72b6\u6001\u4e3a\uff1a%s\uff0c\u672a\u5339\u914d\u9000\u8d27\u89c4\u5219\uff0c\u8bf7\u5148\u7ef4\u62a4\u9000\u8d27\u89c4\u5219\u3002", deliverMode.getString("name"), srcdeliverystatus.getString("name")));
        }
        if (rltMsg != null && rltMsg.length() > 0) {
            returnRuleResult.put("success", Boolean.FALSE);
            returnRuleResult.put("msg", rltMsg.toString());
        } else {
            returnRuleResult.put("success", Boolean.TRUE);
            returnRuleResult.put("returnrulemap", returnRuleMap);
            returnRuleResult.put("msg", "");
        }
        return returnRuleResult;
    }

    public static DynamicObjectCollection getReturnRuleResult(Set<String> lstDeliveryRuleStatus) {
        QFilter qFilter = null;
        for (String deliveryRuleStatus : lstDeliveryRuleStatus) {
            String[] deliveryModeAndStatus = deliveryRuleStatus.split("_");
            long deliverModeId = CommonUtil.formatObejctToLong((Object)deliveryModeAndStatus[0]);
            long deliveryStatusId = CommonUtil.formatObejctToLong((Object)deliveryModeAndStatus[1]);
            QFilter newFilter = new QFilter("ruleentry.distributionmode", "=", (Object)deliverModeId);
            newFilter.and("ruleentry.deliverstates", "=", (Object)deliveryStatusId);
            if (qFilter == null) {
                qFilter = newFilter;
                continue;
            }
            qFilter.or(newFilter);
        }
        QFilter mergeFilter = new QFilter("enable", "=", (Object)EnableStatusEnum.ENABLE.getValue());
        mergeFilter.and("status", "=", (Object)StatusEnum.AUDIT.getValue());
        mergeFilter.and(qFilter);
        return QueryServiceHelper.query((String)"ococic_returnrule", (String)"ruleentry.distributionmode,ruleentry.deliverstates,ruleentry.isreturn,ruleentry.isrefund,ruleentry.istodeliveryorg,ruleentry.istosaleorg,ruleentry.returndefdeliverstatus,ruleentry.isreturnsrcinvtype,ruleentry.isreturnsetinvtype,ruleentry.returninvtype,ruleentry.wbsrcdeliverstatus,ruleentry.isretsrcdeliverymode,ruleentry.isretsetdeliverymode,ruleentry.retdeliverymode,ruleentry.isretdelivery", (QFilter[])mergeFilter.toArray());
    }

    public static void fillSaleReturnEntryByReturnRule(DynamicObject dataEntity, Map<String, DynamicObject> returnRuleMap) {
        DynamicObjectCollection entryEntity = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        int ruleSize = returnRuleMap.size();
        HashMap<Long, DynamicObject> invtypeMap = new HashMap<Long, DynamicObject>(ruleSize);
        HashMap<Long, DynamicObject> deliveryStatusMap = new HashMap<Long, DynamicObject>(ruleSize);
        HashMap<Long, DynamicObject> retDeliveryModeMap = new HashMap<Long, DynamicObject>(ruleSize);
        for (DynamicObject returnRule : returnRuleMap.values()) {
            long retDeliveryModeId;
            long wbsrcdeliverStatusId;
            long deliveryStatusId;
            long invtypeId = returnRule.getLong("ruleentry.returninvtype");
            if (invtypeId > 0L && invtypeMap.get(invtypeId) == null) {
                DynamicObject returnInvType = BusinessDataServiceHelper.loadSingle((Object)invtypeId, (String)"bd_invtype");
                invtypeMap.put(invtypeId, returnInvType);
            }
            if ((deliveryStatusId = returnRule.getLong("ruleentry.returndefdeliverstatus")) > 0L && deliveryStatusMap.get(deliveryStatusId) == null) {
                DynamicObject returnDeliveryStatus = BusinessDataServiceHelper.loadSingle((Object)deliveryStatusId, (String)"ococic_deliverstatus");
                deliveryStatusMap.put(deliveryStatusId, returnDeliveryStatus);
            }
            if ((wbsrcdeliverStatusId = returnRule.getLong("ruleentry.wbsrcdeliverstatus")) > 0L && deliveryStatusMap.get(wbsrcdeliverStatusId) == null) {
                DynamicObject returnDeliveryStatus = BusinessDataServiceHelper.loadSingle((Object)wbsrcdeliverStatusId, (String)"ococic_deliverstatus");
                deliveryStatusMap.put(wbsrcdeliverStatusId, returnDeliveryStatus);
            }
            if ((retDeliveryModeId = returnRule.getLong("ruleentry.retdeliverymode")) <= 0L || retDeliveryModeMap.get(retDeliveryModeId) != null) continue;
            DynamicObject retDeliveryMode = BusinessDataServiceHelper.loadSingle((Object)retDeliveryModeId, (String)"ocdbd_distributionmode");
            retDeliveryModeMap.put(retDeliveryModeId, retDeliveryMode);
        }
        for (DynamicObject entryItem : entryEntity) {
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryItem, (String)"ispresent");
            DynamicObjectCollection deliveryEntity = entryItem.getDynamicObjectCollection("salesorderdelivery");
            for (DynamicObject deliveryItem : deliveryEntity) {
                boolean isretsetdeliverymode;
                String modeAndStatus;
                DynamicObject returnRule;
                DynamicObject deliveryMode = deliveryItem.getDynamicObject("deliverymode");
                DynamicObject srcdeliverystatus = deliveryItem.getDynamicObject("srcdeliverystatus");
                if (deliveryMode == null || srcdeliverystatus == null || (returnRule = returnRuleMap.get(modeAndStatus = deliveryMode.getPkValue() + "_" + srcdeliverystatus.getPkValue())) == null) continue;
                long wbsrcdeliverStatusId = returnRule.getLong("ruleentry.wbsrcdeliverstatus");
                long returnDeliveryStatusId = returnRule.getLong("ruleentry.returndefdeliverstatus");
                boolean isToSaleOrg = returnRule.getBoolean("ruleentry.istosaleorg");
                if (wbsrcdeliverStatusId > 0L) {
                    deliveryItem.set("wbsrcdeliverstatus", deliveryStatusMap.get(wbsrcdeliverStatusId));
                }
                if (returnDeliveryStatusId > 0L) {
                    deliveryItem.set("deliverystatus", deliveryStatusMap.get(returnDeliveryStatusId));
                }
                boolean isreturnsetinvtype = returnRule.getBoolean("ruleentry.isreturnsetinvtype");
                if (!isPresent && isreturnsetinvtype) {
                    DynamicObject returninvtype = null;
                    long returninvtypeId = returnRule.getLong("ruleentry.returninvtype");
                    if (returninvtypeId > 0L) {
                        returninvtype = (DynamicObject)invtypeMap.get(returninvtypeId);
                    }
                    deliveryItem.set("deliverystocktype", returninvtype);
                }
                if (isretsetdeliverymode = returnRule.getBoolean("ruleentry.isretsetdeliverymode")) {
                    DynamicObject retdeliverymode = null;
                    long retdeliverymodeId = returnRule.getLong("ruleentry.retdeliverymode");
                    if (retdeliverymodeId > 0L) {
                        retdeliverymode = (DynamicObject)retDeliveryModeMap.get(retdeliverymodeId);
                    }
                    deliveryItem.set("deliverymode", retdeliverymode);
                    boolean isretdelivery = returnRule.getBoolean("ruleentry.isretdelivery");
                    deliveryItem.set("deliverisdelivery", (Object)isretdelivery);
                    deliveryItem.set("isselfpickup", (Object)(!isretdelivery ? 1 : 0));
                }
                if (!isToSaleOrg) continue;
                DynamicObject bizOrg = dataEntity.getDynamicObject("bizorgid");
                deliveryItem.set("inventoryorgid", (Object)bizOrg);
                deliveryItem.set("deliverykeeper", (Object)bizOrg);
                deliveryItem.set("deliveryowner", (Object)bizOrg);
                DynamicObject saleBranch = dataEntity.getDynamicObject("salebranchid");
                if (saleBranch == null) continue;
                deliveryItem.set("deliverdeliverybranchid", (Object)saleBranch);
                DynamicObject warehouse = SaleOrderReturnRuleHelper.getDefaultWarehouse(saleBranch.getPkValue());
                if (warehouse != null) {
                    deliveryItem.set("deliverstockid", (Object)warehouse);
                    deliveryItem.set("erpstockid", warehouse.get("erpwarehouseid"));
                    continue;
                }
                deliveryItem.set("deliverstockid", null);
                deliveryItem.set("erpstockid", null);
            }
        }
    }

    public static DynamicObject getDefaultWarehouse(Object branchId) {
        QFilter filter = new QFilter("ownerchannelid", "=", branchId);
        filter.and("enable", "=", (Object)"1");
        filter.and("status", "=", (Object)"C");
        QFilter filter1 = new QFilter("isreturn", "=", (Object)"1");
        filter1.or("isdefault", "=", (Object)"1");
        filter1.or("isdelivery", "=", (Object)"1");
        DynamicObject returnHouse = null;
        DynamicObject deliveryHouse = null;
        DynamicObject defaultHouse = null;
        DynamicObject[] wareHouses = BusinessDataServiceHelper.load((String)"ococic_warehouse", (String)"id,number,name,erpwarehouseid,isreturn,isdelivery,isdefault", (QFilter[])filter.toArray());
        if (wareHouses != null && wareHouses.length > 0) {
            for (DynamicObject wareHouse : wareHouses) {
                boolean isdelivery;
                boolean isdefault;
                boolean isreturn = wareHouse.getBoolean("isreturn");
                if (isreturn) {
                    returnHouse = wareHouse;
                }
                if (isdefault = wareHouse.getBoolean("isdefault")) {
                    defaultHouse = wareHouse;
                }
                if (!(isdelivery = wareHouse.getBoolean("isdelivery"))) continue;
                deliveryHouse = wareHouse;
            }
        }
        if (returnHouse != null) {
            return returnHouse;
        }
        if (defaultHouse != null) {
            return defaultHouse;
        }
        if (deliveryHouse != null) {
            return deliveryHouse;
        }
        return null;
    }
}

