/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DateUtil;

public class SaleOrderStageHelper {
    public static List<JSONObject> getStagePayList(BigDecimal hasPayAmount, JSONArray goodsList, long branchId) {
        DynamicObject[] stageList;
        ArrayList<JSONObject> stagePayList = new ArrayList<JSONObject>();
        QFilter filter = new QFilter("status", "=", (Object)"C");
        filter.and(new QFilter("enable", "=", (Object)"1"));
        String date = CommonUtil.format((Date)TimeServiceHelper.now(), (String)TimeServiceHelper.getDateTimeFormatString());
        filter.and(new QFilter("startdate", "<=", (Object)DateUtil.stringToDateformat((String)date)));
        filter.and(new QFilter("enddate", ">=", (Object)DateUtil.stringToDateformat((String)date)));
        MainEntityType type = MetadataServiceHelper.getDataEntityType((String)"ocdbd_bankstage");
        Object[] fieldKeys = type.getAllFields().values().stream().map(IMetadata::getName).toArray();
        block0: for (DynamicObject stage : stageList = BusinessDataServiceHelper.load((String)"ocdbd_bankstage", (String)StringUtils.join((Object[])fieldKeys, (char)','), (QFilter[])filter.toArray())) {
            DynamicObject[] ocdbdStageList;
            boolean checkBranch;
            boolean checkScope = SaleOrderStageHelper.checkMaterialScope(stage, goodsList);
            if (!checkScope || !(checkBranch = SaleOrderStageHelper.checkBranchScope(stage, branchId))) continue;
            JSONObject stageJson = new JSONObject();
            stageJson.put("bankstageid", (Object)stage);
            stageJson.put("cooperbank", (Object)stage.getDynamicObject("cooperbankid"));
            QFilter qFilter = new QFilter("stageid", "=", (Object)stage.getLong("id"));
            MainEntityType stageType = MetadataServiceHelper.getDataEntityType((String)"ocdbd_stages");
            Object[] stageFieldKeys = stageType.getAllFields().values().stream().map(IMetadata::getName).toArray();
            for (DynamicObject ocdbdStages : ocdbdStageList = BusinessDataServiceHelper.load((String)"ocdbd_stages", (String)StringUtils.join((Object[])stageFieldKeys, (char)','), (QFilter[])qFilter.toArray())) {
                if (hasPayAmount.compareTo(ocdbdStages.getBigDecimal("minimumamount")) != 0 && hasPayAmount.compareTo(ocdbdStages.getBigDecimal("minimumamount")) <= 0) continue;
                stageJson.put("stagesid", (Object)ocdbdStages);
                stageJson.put("stageamount", (Object)hasPayAmount);
                stagePayList.add(stageJson);
                continue block0;
            }
        }
        return stagePayList;
    }

    private static boolean checkMaterialScope(DynamicObject stage, JSONArray goodsList) {
        DynamicObjectCollection goodsEntityList = stage.getDynamicObjectCollection("goodsentity");
        ArrayList<String> goodsIdList = new ArrayList<String>();
        ArrayList<String> goodsBrandList = new ArrayList<String>();
        ArrayList<Long> goodsClassList = new ArrayList<Long>();
        for (DynamicObject goodsEntity : goodsEntityList) {
            String type;
            switch (type = goodsEntity.getString("type")) {
                case "1": {
                    DynamicObject goods = goodsEntity.getDynamicObject("goodsid");
                    goodsIdList.add(goods != null ? goods.getString("id") : null);
                    break;
                }
                case "2": {
                    DynamicObject goosClass = goodsEntity.getDynamicObject("itemclassid");
                    goodsClassList.add(goosClass != null ? Long.valueOf(goosClass.getLong("id")) : null);
                    break;
                }
                case "3": {
                    DynamicObject goodsBrand = goodsEntity.getDynamicObject("brandid");
                    goodsBrandList.add(goodsBrand != null ? goodsBrand.getString("id") : null);
                }
            }
        }
        int itemSelect = stage.getInt("itemselected");
        if (itemSelect == 1) {
            return true;
        }
        block15: for (int i = 0; i < goodsList.size(); ++i) {
            String goods = goodsList.getJSONObject(i).getString("goodsid");
            String goodsBrand = goodsList.getJSONObject(i).getString("brand");
            String goodsId = goods != null ? JSONObject.parseObject((String)goods).getString("id") : goods;
            String brand = goodsBrand != null ? JSONObject.parseObject((String)goodsBrand).getString("id") : goodsBrand;
            List classIds = ItemClassUtil.queryClassList((Object)goodsId);
            switch (itemSelect) {
                case 2: {
                    if (!goodsBrandList.contains(brand) || !goodsIdList.contains(goodsId)) continue block15;
                    for (Long goodClass : goodsClassList) {
                        if (classIds.contains(goodClass)) continue;
                        return true;
                    }
                    return false;
                }
                case 3: {
                    if (goodsBrandList.contains(brand) || goodsIdList.contains(goodsId)) continue block15;
                    for (Long goodClass : goodsClassList) {
                        if (!classIds.contains(goodClass)) continue;
                        return true;
                    }
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean checkBranchScope(DynamicObject stage, long branchId) {
        String controlMethod = stage.getString("controlmethod");
        if (StringUtils.equals((CharSequence)"A", (CharSequence)controlMethod)) {
            return true;
        }
        if (StringUtils.equals((CharSequence)"B", (CharSequence)controlMethod)) {
            DynamicObjectCollection branchList = stage.getDynamicObjectCollection("branchreeentryentity");
            for (DynamicObject branchTree : branchList) {
                DynamicObject branch = branchTree.getDynamicObject("branchid");
                boolean isExecute = branchTree.getBoolean("isexecute");
                if (branch.getLong("id") != branchId || !isExecute) continue;
                return true;
            }
        }
        return false;
    }
}

