/*
 * Decompiled with CFR 0.152.
 */
package kd.occ.ocpos.business.saleorder;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.occ.ocbase.business.payhelper.PaymentFlowHelper;
import kd.occ.ocbase.common.enums.PaymentModeEnum;
import kd.occ.ocbase.common.util.DynamicObjectUtils;
import kd.occ.ocbase.common.util.ItemClassUtil;
import kd.occ.ocpos.business.saleorder.SaleOrderBalancePolicyHelper;
import kd.occ.ocpos.business.saleorder.SnServiceHelper;
import kd.occ.ocpos.common.enums.BillTypeEnum;
import kd.occ.ocpos.common.enums.BizTypeEnum;
import kd.occ.ocpos.common.enums.SaleStatusEnum;
import kd.occ.ocpos.common.util.CommonUtil;
import kd.occ.ocpos.common.util.DynamicObjectUtil;
import kd.occ.ocpos.common.util.SystemParamUtil;

public class SaleOrderWriteBackHelper {
    private static final Log LOG = LogFactory.getLog(SaleOrderWriteBackHelper.class);

    public static void updateSaleOrderAndOtherDeliveryStatus(DynamicObject dataEntity) {
        SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus(dataEntity, null, null);
    }

    public static void updateSaleOrderAndOtherDeliveryStatus(DynamicObject dataEntity, Map<Long, DynamicObject> deliveryIdWbStatusMap, DynamicObject allDeliveryStatus) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        long retailBillId = 0L;
        long orderBillId = 0L;
        HashMap<Long, DynamicObject> deliveryIdStatusMap = new HashMap<Long, DynamicObject>();
        HashMap<Long, DynamicObject> srcDeliveryIdStatusMap = new HashMap<Long, DynamicObject>();
        String changeItemType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"changeitemtype");
        String srcChangeItemType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"srcchangeitemtype");
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities;
            String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || CollectionUtils.isEmpty((Collection)(deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery")))) continue;
            boolean isBook = entryEntity.getBoolean("isbook");
            if (isBook) {
                orderBillId = entryEntity.getLong("lastbillid");
            } else {
                retailBillId = entryEntity.getLong("lastbillid");
            }
            BigDecimal noReFinalAmount = entryEntity.getBigDecimal("norecefinalamount");
            for (DynamicObject deliveryEntry : deliveryEntities) {
                DynamicObject toDeliveryStatus;
                long deliveryPkId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntry);
                long toDeliveryStatusId = 0L;
                if (deliveryIdWbStatusMap != null) {
                    if (!deliveryIdWbStatusMap.containsKey(deliveryPkId)) continue;
                    toDeliveryStatus = deliveryIdWbStatusMap.get(deliveryPkId);
                } else {
                    toDeliveryStatus = allDeliveryStatus;
                }
                if (StringUtils.equals((CharSequence)changeItemType, (CharSequence)"3") || StringUtils.equals((CharSequence)srcChangeItemType, (CharSequence)"3")) {
                    toDeliveryStatus = DynamicObjectUtils.getDynamicObject((DynamicObject)deliveryEntry, (String)"deliverystatus");
                }
                if (toDeliveryStatus == null) {
                    if (!isBook && noReFinalAmount.compareTo(BigDecimal.ZERO) > 0) {
                        long branchId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"salebranchid");
                        long bizOrgId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity, (String)"bizorgid");
                        boolean checkIsEnable = CommonUtil.formatObjectToBoolean((Object)SystemParamUtil.getSystemParamValue((long)bizOrgId, (long)branchId, (String)"isenablebalancepolicy"));
                        if (checkIsEnable) {
                            String deliveryCtrl;
                            long goodsId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"goodsid");
                            long goodsBrandId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"brand");
                            List goodsClassIds = ItemClassUtil.queryClassList((Object)goodsId);
                            DynamicObject balancePolicy = SaleOrderBalancePolicyHelper.matchBalancePolicy(branchId, goodsId, goodsBrandId, goodsClassIds);
                            if (balancePolicy != null && StringUtils.equals((CharSequence)(deliveryCtrl = balancePolicy.getString("entity.deliveryctrl")), (CharSequence)"A")) {
                                toDeliveryStatusId = 1112809419290298368L;
                            }
                        }
                    } else if (isBook) {
                        toDeliveryStatusId = 1112809419290298368L;
                    }
                    if (toDeliveryStatusId == 0L) {
                        String orderSource = dataEntity.getString("ordersource");
                        boolean isSelfPickup = deliveryEntry.getBoolean("isselfpickup");
                        long deliverModeId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntry, (String)"deliverymode");
                        toDeliveryStatusId = (StringUtils.equals((CharSequence)orderSource, (CharSequence)"D") || StringUtils.equals((CharSequence)orderSource, (CharSequence)"E")) && isSelfPickup ? 1026065142993238016L : ((deliverModeId == 926601071999218688L || deliverModeId == 926601157210585088L) && isSelfPickup ? 1026079657449208832L : 1026065142993238016L);
                    }
                } else {
                    toDeliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus);
                }
                DynamicObject newDeliveryStatus = toDeliveryStatus;
                if (toDeliveryStatusId > 0L && (toDeliveryStatus == null || DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) != toDeliveryStatusId)) {
                    newDeliveryStatus = BusinessDataServiceHelper.loadSingle((Object)toDeliveryStatusId, (String)"ococic_deliverstatus");
                }
                deliveryEntry.set("deliverystatus", (Object)newDeliveryStatus);
                if (toDeliveryStatusId == 1026079657449208832L && dataEntity.getDataEntityType().getName().equalsIgnoreCase("ocpos_saleorder")) {
                    deliveryEntry.set("signstatus", (Object)"D");
                    deliveryEntry.set("receivedate", (Object)TimeServiceHelper.now());
                }
                deliveryIdStatusMap.put(deliveryPkId, newDeliveryStatus);
                long srcDeliveryId = deliveryEntry.getLong("srcdeliveryentryid");
                srcDeliveryIdStatusMap.put(srcDeliveryId, newDeliveryStatus);
            }
        }
        String orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus(dataEntity);
        dataEntity.set("orderstatus", (Object)orderStatus);
        SaleOrderWriteBackHelper.updateSaleCvtDeliveryStatus(dataEntity, srcDeliveryIdStatusMap);
        SaveServiceHelper.update((DynamicObject)dataEntity);
        SaleOrderWriteBackHelper.updateOrderBillDeliveryStatus(orderBillId, deliveryIdStatusMap);
        ArrayList<Long> deliveryBillIds = new ArrayList<Long>();
        HashMap<Long, DynamicObject> orderBillDeliveryStatusIdMap = new HashMap<Long, DynamicObject>();
        SaleOrderWriteBackHelper.updateRetailBillDeliveryStatus(retailBillId, deliveryIdStatusMap, orderStatus, deliveryBillIds, orderBillDeliveryStatusIdMap);
        SaleOrderWriteBackHelper.updateDeliveryOrderDeliveryStatus(deliveryBillIds, orderBillDeliveryStatusIdMap);
    }

    public static String getSaleOrderOrderStatus(DynamicObject dataEntity) {
        String orderStatus = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"orderstatus");
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return orderStatus;
        }
        HashSet<Long> deliveryStatusIdSet = new HashSet<Long>();
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities;
            String saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0") || CollectionUtils.isEmpty((Collection)(deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery")))) continue;
            for (DynamicObject deliveryEntry : deliveryEntities) {
                DynamicObject deliveryStatus = deliveryEntry.getDynamicObject("deliverystatus");
                long deliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryStatus);
                deliveryStatusIdSet.add(deliveryStatusId);
            }
        }
        if (deliveryStatusIdSet.contains(1026065142993238016L) || deliveryStatusIdSet.contains(1112809419290298368L)) {
            orderStatus = deliveryStatusIdSet.size() > 1 ? "C" : "A";
        } else if (deliveryStatusIdSet.contains(1026078976696892416L) || deliveryStatusIdSet.contains(1026079259451832320L)) {
            orderStatus = "B";
        } else if (deliveryStatusIdSet.contains(1026080474264747008L) || deliveryStatusIdSet.contains(1052882173696474112L)) {
            orderStatus = "E";
        } else if (deliveryStatusIdSet.contains(1026079657449208832L) || deliveryStatusIdSet.contains(1026080809389766656L)) {
            orderStatus = deliveryStatusIdSet.size() > 1 ? "B" : "D";
        } else if (deliveryStatusIdSet.contains(1078251594119816192L)) {
            orderStatus = "D";
        }
        return orderStatus;
    }

    public static void updateSaleChangeDeliveryStatus(DynamicObject dataEntity, List<Long> saleChangeDeliveryIds, DynamicObject toDeliveryStatus) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        boolean isUpdate = false;
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            for (DynamicObject deliveryEntry : deliveryEntities) {
                long deliveryPkId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntry);
                if (!saleChangeDeliveryIds.contains(deliveryPkId) || toDeliveryStatus == null) continue;
                deliveryEntry.set("deliverystatus", (Object)toDeliveryStatus);
                isUpdate = true;
            }
        }
        String orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus(dataEntity);
        dataEntity.set("orderstatus", (Object)orderStatus);
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject)dataEntity);
        }
    }

    private static void reSell(Map<Long, DynamicObject> deliveryIdStatusMap, DynamicObject partResell, DynamicObject wholeResell, DynamicObject deliveryEntry) {
        long deliveryPkId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntry);
        BigDecimal deliverSaleQty = deliveryEntry.getBigDecimal("deliversaleqty");
        BigDecimal deliveryToSaleQty = deliveryEntry.getBigDecimal("deliverytosalesqty");
        if (deliveryToSaleQty.compareTo(BigDecimal.ZERO) > 0) {
            if (deliverSaleQty.compareTo(deliveryToSaleQty) == 0) {
                deliveryIdStatusMap.put(deliveryPkId, wholeResell);
            } else {
                deliveryIdStatusMap.put(deliveryPkId, partResell);
            }
        }
    }

    public static void updateSaleCvtDeliveryStatus(DynamicObject dataEntity, Map<Long, DynamicObject> srcDeliveryIdStatusMap) {
        String bizType = dataEntity.getString("biztype");
        long sourceBillid = dataEntity.getLong("sourcebillid");
        if (sourceBillid <= 0L || !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)BizTypeEnum.ORDERCONVERTSALE.getValue())) {
            return;
        }
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillid, (String)"ocpos_saleorder");
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        DynamicObject partResell = BusinessDataServiceHelper.loadSingle((Object)1255632844445726720L, (String)"ococic_deliverstatus");
        DynamicObject wholeResell = BusinessDataServiceHelper.loadSingle((Object)1255632633941997568L, (String)"ococic_deliverstatus");
        for (DynamicObject entryEntity : entryEntities) {
            BigDecimal noreceexpectfinalamount = entryEntity.getBigDecimal("noreceexpectfinalamount");
            BigDecimal receexpectfinalamount = entryEntity.getBigDecimal("receexpectfinalamount");
            entryEntity.set("noreceexpectfinalamount", (Object)BigDecimal.ZERO);
            entryEntity.set("receexpectfinalamount", (Object)receexpectfinalamount.add(noreceexpectfinalamount));
        }
        DynamicObjectCollection sourceEntry = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)sourceBill, (String)"goodsentryentity");
        for (DynamicObject entry : sourceEntry) {
            DynamicObjectCollection deliveryEntities = entry.getDynamicObjectCollection("salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            for (DynamicObject deliveryEntity : deliveryEntities) {
                SaleOrderWriteBackHelper.reSell(srcDeliveryIdStatusMap, partResell, wholeResell, deliveryEntity);
            }
        }
        if (!CollectionUtils.isEmpty(srcDeliveryIdStatusMap)) {
            SaleOrderWriteBackHelper.updateSaleOrderAndOtherDeliveryStatus(sourceBill, srcDeliveryIdStatusMap, null);
        }
    }

    public static void updateOrderBillDeliveryStatus(Long orderBillId, Map<Long, DynamicObject> deliveryStatusIdMap) {
        if (orderBillId <= 0L) {
            return;
        }
        boolean isUpdate = false;
        DynamicObject orderBill = BusinessDataServiceHelper.loadSingle((Object)orderBillId, (String)"ocococ_orderbill");
        DynamicObjectCollection orderItemEntrys = orderBill.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)orderItemEntrys)) {
            for (DynamicObject orderItemEntry : orderItemEntrys) {
                DynamicObjectCollection depositDeliverys = orderItemEntry.getDynamicObjectCollection("depositdelivery");
                if (CollectionUtils.isEmpty((Collection)depositDeliverys)) continue;
                for (DynamicObject depositDelivery : depositDeliverys) {
                    DynamicObject deliveryStatus;
                    long srcDeliveryEntryId = depositDelivery.getLong("srcdeliveryentryid");
                    DynamicObject toDeliveryStatus = deliveryStatusIdMap.get(srcDeliveryEntryId);
                    if (toDeliveryStatus == null || (deliveryStatus = depositDelivery.getDynamicObject("deliverystatus")) != null && DynamicObjectUtils.getPkValue((DynamicObject)deliveryStatus) == DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus)) continue;
                    depositDelivery.set("deliverystatus", (Object)toDeliveryStatus);
                    isUpdate = true;
                }
            }
            if (isUpdate) {
                SaveServiceHelper.update((DynamicObject)orderBill);
            }
        }
    }

    public static void updateRetailBillDeliveryStatus(Long retailBillId, Map<Long, DynamicObject> deliveryStatusIdMap, String orderStatus, List<Long> deliveryBillIds, Map<Long, DynamicObject> orderBillDeliveryStatusIdMap) {
        if (retailBillId <= 0L) {
            return;
        }
        boolean isUpdate = false;
        DynamicObject retailBill = BusinessDataServiceHelper.loadSingle((Object)retailBillId, (String)"ocococ_retailbill");
        DynamicObjectCollection rtItemEntities = retailBill.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)rtItemEntities)) {
            for (DynamicObject rtItemEntry : rtItemEntities) {
                DynamicObjectCollection rtDeliveryEntities = rtItemEntry.getDynamicObjectCollection("ribilldelivery");
                if (CollectionUtils.isEmpty((Collection)rtDeliveryEntities)) continue;
                for (DynamicObject deliveryEntry : rtDeliveryEntities) {
                    long srcDeliveryEntryId = deliveryEntry.getLong("srcdeliveryentryid");
                    DynamicObject toDeliveryStatus = deliveryStatusIdMap.get(srcDeliveryEntryId);
                    if (toDeliveryStatus == null) continue;
                    long deliveryBillId = deliveryEntry.getLong("lastbillid");
                    if (deliveryBillId > 0L && !deliveryBillIds.contains(deliveryBillId)) {
                        deliveryBillIds.add(deliveryBillId);
                    }
                    orderBillDeliveryStatusIdMap.put(DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntry), toDeliveryStatus);
                    DynamicObject deliveryStatus = deliveryEntry.getDynamicObject("deliverystatus");
                    if (deliveryStatus != null && DynamicObjectUtils.getPkValue((DynamicObject)deliveryStatus) == DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus)) continue;
                    deliveryEntry.set("deliverystatus", (Object)toDeliveryStatus);
                    if (DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) == 1026079657449208832L) {
                        deliveryEntry.set("signstatus", (Object)"D");
                    }
                    isUpdate = true;
                }
            }
            String retailOrderStatus = retailBill.getString("orderstatus");
            if (!StringUtils.equals((CharSequence)retailOrderStatus, (CharSequence)orderStatus)) {
                retailBill.set("orderstatus", (Object)orderStatus);
                isUpdate = true;
            }
            if (isUpdate) {
                SaveServiceHelper.update((DynamicObject)retailBill);
            }
        }
    }

    public static void updateDeliveryOrderDeliveryStatus(List<Long> deliveryBillIds, Map<Long, DynamicObject> deliveryStatusIdMap) {
        DynamicObject[] deliveryOrders;
        if (CollectionUtils.isEmpty(deliveryBillIds)) {
            return;
        }
        DynamicObjectCollection updateDeliveryOrders = new DynamicObjectCollection();
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((Object[])deliveryBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocococ_deliveryorder"))) {
            boolean isUpdate = false;
            long toDeliveryStatusId = 0L;
            DynamicObject toDeliveryAllStatus = null;
            HashSet<Long> deliveryStatusIdSet = new HashSet<Long>(16);
            DynamicObjectCollection deliveryOrderEntrys = deliveryOrder.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)deliveryOrderEntrys)) {
                for (DynamicObject deliveryOrderEntry : deliveryOrderEntrys) {
                    DynamicObject deliveryStatus = deliveryOrderEntry.getDynamicObject("deliverystatus");
                    long deliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryStatus);
                    long srcbillentryid = deliveryOrderEntry.getLong("srcbillentryid");
                    DynamicObject toDeliveryStatus = deliveryStatusIdMap.get(srcbillentryid);
                    if (toDeliveryStatus != null) {
                        toDeliveryAllStatus = toDeliveryStatus;
                        toDeliveryStatusId = DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus);
                        deliveryStatusIdSet.add(toDeliveryStatusId);
                        if (deliveryStatus != null && deliveryStatusId == toDeliveryStatusId) continue;
                        deliveryOrderEntry.set("deliverystatus", (Object)toDeliveryStatus);
                        if (toDeliveryStatusId == 1026079657449208832L) {
                            deliveryOrderEntry.set("signstatus", (Object)"D");
                            deliveryOrderEntry.set("receivedate", (Object)TimeServiceHelper.now());
                        }
                        isUpdate = true;
                        continue;
                    }
                    deliveryStatusIdSet.add(deliveryStatusId);
                }
            }
            if (!isUpdate) continue;
            DynamicObject deliveryAllstatus = deliveryOrder.getDynamicObject("deliveryallstatus");
            if (deliveryStatusIdSet.size() > 1) {
                if (deliveryStatusIdSet.contains(1026065142993238016L)) {
                    toDeliveryStatusId = 1050030195890734080L;
                } else if (deliveryStatusIdSet.contains(1078251594119816192L)) {
                    toDeliveryStatusId = 1078251594119816192L;
                } else if (deliveryStatusIdSet.contains(1112809419290298368L)) {
                    toDeliveryStatusId = 1112809419290298368L;
                }
            }
            if (toDeliveryStatusId > 0L && (deliveryAllstatus == null || DynamicObjectUtils.getPkValue((DynamicObject)deliveryAllstatus) != toDeliveryStatusId)) {
                if (DynamicObjectUtils.getPkValue(toDeliveryAllStatus) != toDeliveryStatusId) {
                    toDeliveryAllStatus = BusinessDataServiceHelper.loadSingle((Object)toDeliveryStatusId, (String)"ococic_deliverstatus");
                }
                deliveryOrder.set("deliveryallstatus", toDeliveryAllStatus);
                if (toDeliveryStatusId == 1026079657449208832L) {
                    deliveryOrder.set("signallstatus", (Object)"D");
                }
            }
            updateDeliveryOrders.add((Object)deliveryOrder);
        }
        if (!CollectionUtils.isEmpty((Collection)updateDeliveryOrders)) {
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])updateDeliveryOrders.toArray((Object[])new DynamicObject[0])));
        }
    }

    public static void updateSnMainFile(DynamicObject dataEntity, String snStatus) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        ArrayList<JSONObject> params = new ArrayList<JSONObject>();
        ArrayList<Long> snMainFileIds = new ArrayList<Long>();
        for (DynamicObject entryEntity : entryEntities) {
            DynamicObjectCollection deliveryEntities = entryEntity.getDynamicObjectCollection("salesorderdelivery");
            if (CollectionUtils.isEmpty((Collection)deliveryEntities)) continue;
            long supplierId = DynamicObjectUtils.getPkValue((DynamicObject)entryEntity, (String)"supplier");
            for (DynamicObject deliveryEntity : deliveryEntities) {
                long snMainFileId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntity, (String)"snmainfile");
                if (snMainFileId <= 0L) continue;
                snMainFileIds.add(snMainFileId);
                JSONObject param = SnServiceHelper.buildParam(dataEntity, supplierId, deliveryEntity);
                params.add(param);
            }
        }
        if (!CollectionUtils.isEmpty(snMainFileIds)) {
            SaleOrderWriteBackHelper.updateSnMainFile(snMainFileIds, params, snStatus);
        }
    }

    public static void updateSnMainFile(List<Long> snMainFileIds, List<JSONObject> params, String snStatus) {
        if (StringUtils.equals((CharSequence)snStatus, (CharSequence)"A")) {
            LOG.info("\u9000\u8d27\u66f4\u65b0\u5e8f\u5217\u53f7\u72b6\u6001");
        }
        try (TXHandle handle = TX.requiresNew();){
            try {
                SnServiceHelper.updateSnStatus(snMainFileIds, snStatus);
            }
            catch (Exception ex) {
                handle.markRollback();
                throw ex;
            }
        }
    }

    public static void updateSrcBillPushOrderFinal(DynamicObject saleOrder) {
        DynamicObjectCollection goodsentryentity;
        String srcLastEntityId = "ocococ_retailbill";
        String backWriteAmountField = "linereceivableamount";
        long billTypeId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrder, (String)"basebilltype");
        if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            srcLastEntityId = "ocococ_orderbill";
            backWriteAmountField = "noreceexpectfinalamount";
        }
        if ((goodsentryentity = saleOrder.getDynamicObjectCollection("goodsentryentity")) == null || goodsentryentity.size() == 0) {
            throw new KDBizException("\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (DynamicObject goodsentry : goodsentryentity) {
            DynamicObject ocGoodsentry;
            BigDecimal linereceivableamount = goodsentry.getBigDecimal(backWriteAmountField);
            long ocococId = goodsentry.getLong("srclastbillid");
            long ocococEntryId = goodsentry.getLong("srclastentryid");
            if (ocococId == 0L || ocococEntryId == 0L) continue;
            boolean isBook = goodsentry.getBoolean("isbook");
            if (isBook) {
                srcLastEntityId = "ocococ_orderbill";
            }
            String selectFields = "entryentity.recfinalamount";
            DynamicObject ocococBill = BusinessDataServiceHelper.loadSingle((Object)ocococId, (String)srcLastEntityId, (String)selectFields);
            if (ocococBill == null) {
                return;
            }
            DynamicObjectCollection ocococGoodsEntity = ocococBill.getDynamicObjectCollection("entryentity");
            if (ocococGoodsEntity != null && ocococGoodsEntity.size() > 0 && (ocGoodsentry = (DynamicObject)ocococGoodsEntity.stream().filter(a -> (Long)a.getPkValue() == ocococEntryId).findFirst().orElse(null)) != null) {
                BigDecimal finalAmount = ocGoodsentry.getBigDecimal("recfinalamount");
                ocGoodsentry.set("recfinalamount", (Object)finalAmount.add(linereceivableamount));
            }
            SaveServiceHelper.update((DynamicObject)ocococBill);
        }
    }

    public static void updateSrcBillPushOrderRefundFinal(DynamicObject saleReturn) {
        DynamicObjectCollection goodsentryentity = saleReturn.getDynamicObjectCollection("goodsentryentity");
        if (goodsentryentity == null || goodsentryentity.size() == 0) {
            throw new KDBizException("\u5546\u54c1\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        for (DynamicObject goodsentry : goodsentryentity) {
            DynamicObject ocGoodsentry;
            String srcLastEntityId = "ocococ_retailbill";
            String srcLastRefundField = "refundfinalamount";
            BigDecimal linereceivableamount = goodsentry.getBigDecimal("linereceivableamount");
            if (linereceivableamount.compareTo(BigDecimal.ZERO) == 0) continue;
            long ocococId = goodsentry.getLong("srclastbillid");
            long ocococEntryId = goodsentry.getLong("srclastentryid");
            if (ocococId == 0L || ocococEntryId == 0L) continue;
            boolean isBook = goodsentry.getBoolean("isbook");
            if (isBook) {
                srcLastEntityId = "ocococ_orderbill";
                srcLastRefundField = "refundexpectfinalamount";
            }
            String selectFields = "entryentity." + srcLastRefundField;
            DynamicObject ocococBill = BusinessDataServiceHelper.loadSingle((Object)ocococId, (String)srcLastEntityId, (String)selectFields);
            if (ocococBill == null) {
                return;
            }
            DynamicObjectCollection ocococGoodsEntity = ocococBill.getDynamicObjectCollection("entryentity");
            if (ocococGoodsEntity != null && ocococGoodsEntity.size() > 0 && (ocGoodsentry = (DynamicObject)ocococGoodsEntity.stream().filter(a -> (Long)a.getPkValue() == ocococEntryId).findFirst().orElse(null)) != null) {
                BigDecimal refundfinalamount = ocGoodsentry.getBigDecimal(srcLastRefundField);
                ocGoodsentry.set(srcLastRefundField, (Object)refundfinalamount.add(linereceivableamount.abs()));
            }
            SaveServiceHelper.update((DynamicObject)ocococBill);
        }
    }

    public static void updateSaleOrderAndOtherOrderStatus(DynamicObject saleOrder, List<Long> deliveryIds, String orderStatus) {
        long retailBillId = 0L;
        DynamicObjectCollection itemEntrys = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)itemEntrys)) {
            for (DynamicObject itemEntry : itemEntrys) {
                boolean isBook = itemEntry.getBoolean("isbook");
                if (isBook) continue;
                retailBillId = itemEntry.getLong("lastbillid");
            }
            saleOrder.set("orderstatus", (Object)orderStatus);
            SaveServiceHelper.update((DynamicObject)saleOrder);
        }
        if (retailBillId > 0L) {
            DynamicObject retailBill = BusinessDataServiceHelper.loadSingle((Object)retailBillId, (String)"ocococ_retailbill");
            retailBill.set("orderstatus", (Object)orderStatus);
            SaveServiceHelper.update((DynamicObject)retailBill);
        }
    }

    public static void updateSaleOrderAndOtherSignStatus(DynamicObject saleOrder, List<Long> deliveryIds, String toSignStatus) {
        DynamicObject[] deliveryOrders;
        boolean isUpdate = false;
        long retailBillId = 0L;
        DynamicObjectCollection itemEntrys = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)itemEntrys)) {
            for (DynamicObject itemEntry : itemEntrys) {
                DynamicObjectCollection saleOrderDeliverys = itemEntry.getDynamicObjectCollection("salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)saleOrderDeliverys)) continue;
                boolean isBook = itemEntry.getBoolean("isbook");
                if (!isBook) {
                    retailBillId = itemEntry.getLong("lastbillid");
                }
                Iterator iterator = saleOrderDeliverys.iterator();
                while (iterator.hasNext()) {
                    DynamicObject saleOrderDelivery = (DynamicObject)iterator.next();
                    long deliveryPkId = DynamicObjectUtils.getPkValue((DynamicObject)saleOrderDelivery);
                    if (!CollectionUtils.isEmpty(deliveryIds) && !deliveryIds.contains(deliveryPkId)) continue;
                    saleOrderDelivery.set("signstatus", (Object)toSignStatus);
                    saleOrderDelivery.set("receivedate", (Object)TimeServiceHelper.now());
                    isUpdate = true;
                }
            }
            if (isUpdate) {
                SaveServiceHelper.update((DynamicObject)saleOrder);
            }
        }
        if (retailBillId <= 0L) {
            return;
        }
        DynamicObject retailBill = BusinessDataServiceHelper.loadSingle((Object)retailBillId, (String)"ocococ_retailbill");
        isUpdate = false;
        ArrayList<Long> deliveryBillIds = new ArrayList<Long>(0);
        DynamicObjectCollection rtItemEntrys = retailBill.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)rtItemEntrys)) {
            for (DynamicObject rtItemEntry : rtItemEntrys) {
                DynamicObjectCollection rtDeliveryEntrys = rtItemEntry.getDynamicObjectCollection("ribilldelivery");
                if (CollectionUtils.isEmpty((Collection)rtDeliveryEntrys)) continue;
                for (DynamicObject deliveryEntry : rtDeliveryEntrys) {
                    isUpdate = true;
                    deliveryEntry.set("signstatus", (Object)toSignStatus);
                    long deliveryBillId = deliveryEntry.getLong("lastbillid");
                    if (deliveryBillId <= 0L || deliveryBillIds.contains(deliveryBillId)) continue;
                    deliveryBillIds.add(deliveryBillId);
                }
            }
        }
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject)retailBill);
        }
        if (CollectionUtils.isEmpty(deliveryBillIds)) {
            return;
        }
        DynamicObjectCollection updateDeliveryOrders = new DynamicObjectCollection();
        for (DynamicObject deliveryOrder : deliveryOrders = BusinessDataServiceHelper.load((Object[])deliveryBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocococ_deliveryorder"))) {
            DynamicObjectCollection deliveryOrderEntrys = deliveryOrder.getDynamicObjectCollection("entryentity");
            if (!CollectionUtils.isEmpty((Collection)deliveryOrderEntrys)) {
                for (DynamicObject deliveryOrderEntry : deliveryOrderEntrys) {
                    deliveryOrderEntry.set("signstatus", (Object)toSignStatus);
                }
            }
            deliveryOrder.set("signallstatus", (Object)toSignStatus);
            updateDeliveryOrders.add((Object)deliveryOrder);
        }
        if (!CollectionUtils.isEmpty((Collection)updateDeliveryOrders)) {
            SaveServiceHelper.update((DynamicObject[])((DynamicObject[])updateDeliveryOrders.toArray((Object[])new DynamicObject[0])));
        }
    }

    public static void updateDeliveryOrderAndOtherDeliveryStatus(DynamicObject deliveryOrder, List<Long> deliveryIds, DynamicObject toDeliveryStatus) {
        long srcdeliveryentryid;
        DynamicObject[] retailBills;
        boolean isUpdate = false;
        boolean isUpdateHeadStatus = true;
        ArrayList<Long> retailBillIds = new ArrayList<Long>(0);
        ArrayList<Long> retailDeliveryIds = new ArrayList<Long>(0);
        DynamicObjectCollection deliveryEntrys = deliveryOrder.getDynamicObjectCollection("entryentity");
        if (!CollectionUtils.isEmpty((Collection)deliveryEntrys)) {
            for (DynamicObject deliveryEntry : deliveryEntrys) {
                long deliveryPkId = CommonUtil.formatObejctToLong((Object)deliveryEntry.getPkValue());
                if (CollectionUtils.isEmpty(deliveryIds) || deliveryIds.contains(deliveryPkId)) {
                    isUpdate = true;
                    deliveryEntry.set("deliverystatus", (Object)toDeliveryStatus);
                    String srcbillentity = deliveryEntry.getString("srcbillentity");
                    long srcbillentryid = deliveryEntry.getLong("srcbillentryid");
                    if (StringUtils.equals((CharSequence)srcbillentity, (CharSequence)"ocococ_retailbill") && srcbillentryid > 0L) {
                        retailDeliveryIds.add(srcbillentryid);
                        long srcbilleid = deliveryEntry.getLong("srcbilleid");
                        if (!retailBillIds.contains(srcbilleid)) {
                            retailBillIds.add(srcbilleid);
                        }
                    }
                    if (DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) != 1026079657449208832L) continue;
                    deliveryEntry.set("signstatus", (Object)"D");
                    deliveryEntry.set("receivedate", (Object)TimeServiceHelper.now());
                    continue;
                }
                DynamicObject deliveryStatus = deliveryEntry.getDynamicObject("deliverystatus");
                if (deliveryStatus != null && DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) == DynamicObjectUtils.getPkValue((DynamicObject)deliveryStatus)) continue;
                isUpdateHeadStatus = false;
            }
            if (isUpdateHeadStatus) {
                isUpdate = true;
                deliveryOrder.set("deliveryallstatus", (Object)toDeliveryStatus);
                if (DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) == 1026079657449208832L) {
                    deliveryOrder.set("signallstatus", (Object)"D");
                }
            }
        }
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject)deliveryOrder);
        }
        if (CollectionUtils.isEmpty(retailBillIds)) {
            return;
        }
        isUpdate = false;
        long saleOrderId = 0L;
        String saleOrderEntityName = "ocpos_saleorder";
        String saleChangeSrcBizTypeField = "srcbiztype";
        ArrayList<Long> saleOrderDeliveryIds = new ArrayList<Long>(0);
        for (DynamicObject retailBill : retailBills = BusinessDataServiceHelper.load((Object[])retailBillIds.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocococ_retailbill"))) {
            DynamicObjectCollection rtItemEntrys;
            String saleOption = retailBill.getString("saleoption");
            if (StringUtils.equals((CharSequence)saleOption, (CharSequence)"0")) {
                saleOrderEntityName = "ocpos_saleorder_return";
                saleChangeSrcBizTypeField = "srcbillbiztype";
            }
            if (CollectionUtils.isEmpty((Collection)(rtItemEntrys = retailBill.getDynamicObjectCollection("entryentity")))) continue;
            for (DynamicObject rtItemEntry : rtItemEntrys) {
                DynamicObjectCollection rtDeliveryEntrys = rtItemEntry.getDynamicObjectCollection("ribilldelivery");
                if (CollectionUtils.isEmpty((Collection)rtDeliveryEntrys)) continue;
                for (DynamicObject deliveryEntry : rtDeliveryEntrys) {
                    long deliveryEntryId = DynamicObjectUtils.getPkValue((DynamicObject)deliveryEntry);
                    if (!retailDeliveryIds.contains(deliveryEntryId)) continue;
                    isUpdate = true;
                    deliveryEntry.set("deliverystatus", (Object)toDeliveryStatus);
                    if (DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) == 1026079657449208832L) {
                        deliveryEntry.set("signstatus", (Object)"D");
                    }
                    srcdeliveryentryid = deliveryEntry.getLong("srcdeliveryentryid");
                    saleOrderDeliveryIds.add(srcdeliveryentryid);
                    saleOrderId = rtItemEntry.getLong("sourcebillid");
                }
            }
        }
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject[])retailBills);
        }
        if (saleOrderId <= 0L) {
            return;
        }
        long saleChangeId = 0L;
        ArrayList<Long> saleChangeDeliveryIds = new ArrayList<Long>(0);
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)saleOrderId, (String)saleOrderEntityName);
        DynamicObjectCollection itemEntrys = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)itemEntrys)) {
            String srcBizType = DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)saleChangeSrcBizTypeField);
            for (DynamicObject itemEntry : itemEntrys) {
                DynamicObjectCollection saleOrderDeliverys = itemEntry.getDynamicObjectCollection("salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)saleOrderDeliverys)) continue;
                for (DynamicObject saleOrderDelivery : saleOrderDeliverys) {
                    long deliveryPkId = CommonUtil.formatObejctToLong((Object)saleOrderDelivery.getPkValue());
                    if (!saleOrderDeliveryIds.contains(deliveryPkId)) continue;
                    saleOrderDelivery.set("deliverystatus", (Object)toDeliveryStatus);
                    if (DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) == 1026079657449208832L && saleOrder.getDataEntityType().getName().equalsIgnoreCase("ocpos_saleorder")) {
                        saleOrderDelivery.set("signstatus", (Object)"D");
                        saleOrderDelivery.set("receivedate", (Object)TimeServiceHelper.now());
                    }
                    if (!StringUtils.equalsIgnoreCase((CharSequence)srcBizType, (CharSequence)"H")) continue;
                    srcdeliveryentryid = saleOrderDelivery.getLong("srcdeliveryentryid");
                    saleChangeDeliveryIds.add(srcdeliveryentryid);
                    saleChangeId = itemEntry.getLong("entrysrcbillid");
                }
            }
            String orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus(saleOrder);
            saleOrder.set("orderstatus", (Object)orderStatus);
            SaveServiceHelper.update((DynamicObject)saleOrder);
            if (!StringUtils.isEmpty((CharSequence)orderStatus)) {
                for (DynamicObject retailBill : retailBills) {
                    retailBill.set("orderstatus", (Object)orderStatus);
                }
                SaveServiceHelper.update((DynamicObject[])retailBills);
            }
        }
        if (saleChangeId > 0L) {
            DynamicObject saleChange = BusinessDataServiceHelper.loadSingle((Object)saleChangeId, (String)"ocpos_salechange");
            SaleOrderWriteBackHelper.updateSaleChangeDeliveryStatus(saleChange, saleChangeDeliveryIds, toDeliveryStatus);
        }
        if (saleOrderId > 0L && saleOrderDeliveryIds.size() > 0) {
            SaleOrderWriteBackHelper.updateSaleOrderTargetBillDeliveryStatus(saleOrderEntityName, saleOrderId, saleOrderDeliveryIds, toDeliveryStatus);
        }
    }

    private static void updateSaleOrderTargetBillDeliveryStatus(String saleOrderEntityName, long saleOrderId, List<Long> saleOrderDeliveryIds, DynamicObject toDeliveryStatus) {
        if (!StringUtils.equals((CharSequence)saleOrderEntityName, (CharSequence)"ocpos_saleorder")) {
            return;
        }
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_saleorder", (Long[])new Long[]{saleOrderId});
        if (targetBills != null && targetBills.size() > 0) {
            HashSet targetBillIdSet = (HashSet)targetBills.get("ocpos_salechange");
            Iterator iterator = targetBillIdSet.iterator();
            while (iterator.hasNext()) {
                Map targetSaleBills;
                long changeId = (Long)iterator.next();
                String selectProperties = "orderstatus,changeitemtype,goodsentryentity.saleoption,salesorderdelivery.srcdeliveryentryid,salesorderdelivery.deliverystatus";
                DynamicObject changeBill = BusinessDataServiceHelper.loadSingle((Object)changeId, (String)"ocpos_salechange", (String)selectProperties);
                String changeItemType = DynamicObjectUtils.getString((DynamicObject)changeBill, (String)"changeitemtype");
                if (!StringUtils.equals((CharSequence)changeItemType, (CharSequence)"3")) continue;
                boolean isUpdateChange = false;
                ArrayList<Long> changeDeliveryIds = new ArrayList<Long>(0);
                int saleRow = 0;
                int returnRow = 0;
                ArrayList<Integer> saleRows = new ArrayList<Integer>(0);
                DynamicObjectCollection changeEntryEntity = changeBill.getDynamicObjectCollection("goodsentryentity");
                for (DynamicObject changeEntry : changeEntryEntity) {
                    long srcdeliveryentryid;
                    DynamicObjectCollection changeDeliveryEntity;
                    String saleoption = DynamicObjectUtils.getString((DynamicObject)changeEntry, (String)"saleoption");
                    if (StringUtils.equals((CharSequence)saleoption, (CharSequence)"0")) {
                        ++saleRow;
                        changeDeliveryEntity = changeEntry.getDynamicObjectCollection("salesorderdelivery");
                        for (DynamicObject changeDelivery : changeDeliveryEntity) {
                            srcdeliveryentryid = DynamicObjectUtils.getLong((DynamicObject)changeDelivery, (String)"srcdeliveryentryid");
                            if (!saleOrderDeliveryIds.contains(srcdeliveryentryid)) continue;
                            saleRows.add(saleRow);
                        }
                        continue;
                    }
                    if (!saleRows.contains(++returnRow)) continue;
                    changeDeliveryEntity = changeEntry.getDynamicObjectCollection("salesorderdelivery");
                    for (DynamicObject changeDelivery : changeDeliveryEntity) {
                        srcdeliveryentryid = DynamicObjectUtils.getLong((DynamicObject)changeDelivery, (String)"srcdeliveryentryid");
                        if (!saleOrderDeliveryIds.contains(srcdeliveryentryid)) continue;
                        isUpdateChange = true;
                        changeDelivery.set("deliverystatus", (Object)toDeliveryStatus);
                        long changeDeliveryId = CommonUtil.formatObejctToLong((Object)changeDelivery.getPkValue());
                        changeDeliveryIds.add(changeDeliveryId);
                    }
                }
                if (isUpdateChange) {
                    String orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus(changeBill);
                    changeBill.set("orderstatus", (Object)orderStatus);
                    SaveServiceHelper.update((DynamicObject)changeBill);
                }
                if ((targetSaleBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_saleorder", (Long[])new Long[]{saleOrderId})) == null || targetSaleBills.size() <= 0) continue;
                HashSet targetSaleBillIdSet = (HashSet)targetSaleBills.get("ocpos_saleorder");
                Iterator iterator2 = targetSaleBillIdSet.iterator();
                while (iterator2.hasNext()) {
                    long saleId = (Long)iterator2.next();
                    boolean isUpdateSale = false;
                    long retailId = 0L;
                    ArrayList<Long> retailEntryIds = new ArrayList<Long>(0);
                    String selectFields = "orderstatus,goodsentryentity.isbook,goodsentryentity.lastbillid,goodsentryentity.lastbillentryid,salesorderdelivery.srcdeliveryentryid,salesorderdelivery.deliverystatus,salesorderdelivery.signstatus,salesorderdelivery.receivedate";
                    DynamicObject saleBill = BusinessDataServiceHelper.loadSingle((Object)saleId, (String)"ocpos_saleorder", (String)selectFields);
                    DynamicObjectCollection entryEntity = saleBill.getDynamicObjectCollection("goodsentryentity");
                    for (DynamicObject entry : entryEntity) {
                        boolean isBook = DynamicObjectUtils.getBoolean((DynamicObject)entry, (String)"isbook");
                        if (isBook) continue;
                        DynamicObjectCollection deliveryEntity = entry.getDynamicObjectCollection("salesorderdelivery");
                        for (DynamicObject delivery : deliveryEntity) {
                            long retailEntryId;
                            long srcdeliveryentryid = DynamicObjectUtils.getLong((DynamicObject)delivery, (String)"srcdeliveryentryid");
                            if (!changeDeliveryIds.contains(srcdeliveryentryid)) continue;
                            isUpdateSale = true;
                            delivery.set("deliverystatus", (Object)toDeliveryStatus);
                            if (DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) == 1026079657449208832L) {
                                delivery.set("signstatus", (Object)"D");
                                delivery.set("receivedate", (Object)TimeServiceHelper.now());
                            } else {
                                delivery.set("signstatus", (Object)"B");
                                delivery.set("receivedate", null);
                            }
                            if (retailId == 0L) {
                                retailId = DynamicObjectUtils.getLong((DynamicObject)entry, (String)"lastbillid");
                            }
                            if ((retailEntryId = DynamicObjectUtils.getLong((DynamicObject)entry, (String)"lastbillentryid")) <= 0L) continue;
                            retailEntryIds.add(retailEntryId);
                        }
                    }
                    String orderStatus = DynamicObjectUtils.getString((DynamicObject)saleBill, (String)"orderstatus");
                    if (isUpdateSale) {
                        orderStatus = SaleOrderWriteBackHelper.getSaleOrderOrderStatus(saleBill);
                        saleBill.set("orderstatus", (Object)orderStatus);
                        SaveServiceHelper.update((DynamicObject)saleBill);
                    }
                    if (retailId <= 0L) continue;
                    boolean isUpdateRt = false;
                    String retailFields = "orderstatus,entryentity,ribilldelivery.deliverystatus,ribilldelivery.signstatus";
                    DynamicObject retailBill = BusinessDataServiceHelper.loadSingle((Object)retailId, (String)"ocococ_retailbill", (String)retailFields);
                    DynamicObjectCollection rtItemEntrys = retailBill.getDynamicObjectCollection("entryentity");
                    if (!CollectionUtils.isEmpty((Collection)rtItemEntrys)) {
                        for (DynamicObject rtItemEntry : rtItemEntrys) {
                            long rtEntryId;
                            DynamicObjectCollection rtDeliveryEntrys = rtItemEntry.getDynamicObjectCollection("ribilldelivery");
                            if (CollectionUtils.isEmpty((Collection)rtDeliveryEntrys) || !retailEntryIds.contains(rtEntryId = DynamicObjectUtils.getPkValue((DynamicObject)rtItemEntry))) continue;
                            for (DynamicObject deliveryEntry : rtDeliveryEntrys) {
                                isUpdateRt = true;
                                deliveryEntry.set("deliverystatus", (Object)toDeliveryStatus);
                                if (DynamicObjectUtils.getPkValue((DynamicObject)toDeliveryStatus) == 1026079657449208832L) {
                                    deliveryEntry.set("signstatus", (Object)"D");
                                    continue;
                                }
                                deliveryEntry.set("signstatus", (Object)"B");
                            }
                        }
                    }
                    if (!isUpdateRt) continue;
                    retailBill.set("orderstatus", (Object)orderStatus);
                    SaveServiceHelper.update((DynamicObject)retailBill);
                }
            }
        }
    }

    public static void updateSaleOrderReturnQty(DynamicObject saleOrder, Map<Long, BigDecimal> deliveryQtyMap) {
        DynamicObjectCollection itemEntrys = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)itemEntrys)) {
            boolean isUpdate = false;
            for (DynamicObject itemEntry : itemEntrys) {
                DynamicObjectCollection deliveryEntrys = itemEntry.getDynamicObjectCollection("salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntrys)) continue;
                for (DynamicObject deliveryEntry : deliveryEntrys) {
                    long deliveryPkId = CommonUtil.formatObejctToLong((Object)deliveryEntry.getPkValue());
                    BigDecimal deliverRetureSaleQty = deliveryQtyMap.get(deliveryPkId);
                    if (deliverRetureSaleQty == null || deliverRetureSaleQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal srcdeliversaleqty = deliveryEntry.getBigDecimal("deliversaleqty");
                    BigDecimal srcdeliveryreturnqty = deliveryEntry.getBigDecimal("deliveryreturnqty");
                    srcdeliveryreturnqty = srcdeliveryreturnqty.add(deliverRetureSaleQty);
                    BigDecimal srcdeliverytosalesqty = deliveryEntry.getBigDecimal("deliverytosalesqty");
                    BigDecimal srcdeliveryavareturnqty = srcdeliversaleqty.subtract(srcdeliverytosalesqty).add(srcdeliveryreturnqty);
                    deliveryEntry.set("deliveryreturnqty", (Object)srcdeliveryreturnqty);
                    deliveryEntry.set("deliveryavareturnqty", (Object)srcdeliveryavareturnqty);
                    isUpdate = true;
                }
            }
            if (isUpdate) {
                SaveServiceHelper.update((DynamicObject)saleOrder);
            }
        }
    }

    public static void updateSaleOrderToSaleQty(DynamicObject saleOrder, Map<Long, BigDecimal> deliveryQtyMap) {
        DynamicObjectCollection itemEntrys = saleOrder.getDynamicObjectCollection("goodsentryentity");
        if (!CollectionUtils.isEmpty((Collection)itemEntrys)) {
            boolean isUpdate = false;
            for (DynamicObject itemEntry : itemEntrys) {
                DynamicObjectCollection deliveryEntrys = itemEntry.getDynamicObjectCollection("salesorderdelivery");
                if (CollectionUtils.isEmpty((Collection)deliveryEntrys)) continue;
                for (DynamicObject deliveryEntry : deliveryEntrys) {
                    long deliveryPkId = CommonUtil.formatObejctToLong((Object)deliveryEntry.getPkValue());
                    BigDecimal deliverToSaleQty = deliveryQtyMap.get(deliveryPkId);
                    if (deliverToSaleQty == null || deliverToSaleQty.compareTo(BigDecimal.ZERO) == 0) continue;
                    BigDecimal srcdeliversaleqty = deliveryEntry.getBigDecimal("deliversaleqty");
                    BigDecimal srcdeliveryreturnqty = deliveryEntry.getBigDecimal("deliveryreturnqty");
                    BigDecimal srcdeliverytosalesqty = deliveryEntry.getBigDecimal("deliverytosalesqty");
                    srcdeliverytosalesqty = srcdeliverytosalesqty.add(deliverToSaleQty);
                    BigDecimal srcdeliveryavareturnqty = srcdeliversaleqty.subtract(srcdeliverytosalesqty).add(srcdeliveryreturnqty);
                    deliveryEntry.set("deliverytosalesqty", (Object)srcdeliverytosalesqty);
                    deliveryEntry.set("deliveryavareturnqty", (Object)srcdeliveryavareturnqty);
                    isUpdate = true;
                }
            }
            if (isUpdate) {
                SaveServiceHelper.update((DynamicObject)saleOrder);
            }
        }
    }

    public static void addOrderBillFinEntry(DynamicObject saleOrder) {
        DynamicObjectCollection goodsEntryEntity = saleOrder.getDynamicObjectCollection("goodsentryentity");
        DynamicObjectCollection finEntity = saleOrder.getDynamicObjectCollection("finentity");
        if (CollectionUtils.isEmpty((Collection)goodsEntryEntity)) {
            return;
        }
        DynamicObject retailBill = null;
        DynamicObject orderBill = null;
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            long lastBillId = goodsEntry.getLong("lastbillid");
            if (lastBillId == 0L) continue;
            boolean isBook = goodsEntry.getBoolean("isbook");
            if (!isBook && retailBill == null) {
                retailBill = BusinessDataServiceHelper.loadSingle((Object)lastBillId, (String)"ocococ_retailbill");
                retailBill.set("salestatus", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"salestatus"));
                retailBill.set("orderstatus", (Object)DynamicObjectUtils.getString((DynamicObject)saleOrder, (String)"orderstatus"));
                continue;
            }
            if (!isBook || orderBill != null) continue;
            orderBill = BusinessDataServiceHelper.loadSingle((Object)lastBillId, (String)"ocococ_orderbill");
        }
        if (retailBill != null) {
            DynamicObjectCollection retailFinEntry = retailBill.getDynamicObjectCollection("ffinentity");
            if (!CollectionUtils.isEmpty((Collection)finEntity)) {
                for (DynamicObject finEntry : finEntity) {
                    DynamicObject retailFin = retailFinEntry.addNew();
                    BigDecimal settleAmount = finEntry.getBigDecimal("settleamount");
                    retailFin.set("settleid", (Object)finEntry.getDynamicObject("setllementid"));
                    retailFin.set("paywaytype", (Object)finEntry.getDynamicObject("paywaytypeid"));
                    retailFin.set("settlecurrid", (Object)finEntry.getDynamicObject("settlecurrid"));
                    retailFin.set("rate", (Object)finEntry.getBigDecimal("exchangerate"));
                    retailFin.set("settleamount", (Object)settleAmount);
                    retailFin.set("integralconsum", (Object)finEntry.getBigDecimal("integralconsum"));
                    retailFin.set("cardno", (Object)finEntry.getString("cardno"));
                    retailFin.set("ticketinfoid", (Object)finEntry.getDynamicObject("ticketinfoid"));
                    retailFin.set("tickettypeid", (Object)finEntry.getDynamicObject("tickettypeid"));
                    retailFin.set("referenceno", (Object)finEntry.getString("tradereference"));
                    retailFin.set("bankaccountno", (Object)finEntry.getString("bankaccountid"));
                    retailFin.set("orderno", (Object)finEntry.getString("orderno"));
                    retailFin.set("locsettleamount", (Object)settleAmount);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{retailBill});
        }
        if (orderBill != null) {
            DynamicObjectCollection orderFinEntry = orderBill.getDynamicObjectCollection("ffinentity");
            if (!CollectionUtils.isEmpty((Collection)finEntity)) {
                for (DynamicObject finEntry : finEntity) {
                    DynamicObject orderFin = orderFinEntry.addNew();
                    BigDecimal settleAmount = finEntry.getBigDecimal("settleamount");
                    orderFin.set("settleid", (Object)finEntry.getDynamicObject("setllementid"));
                    orderFin.set("paywaytype", (Object)finEntry.getDynamicObject("paywaytypeid"));
                    orderFin.set("settlecurrid", (Object)finEntry.getDynamicObject("settlecurrid"));
                    orderFin.set("rate", (Object)finEntry.getBigDecimal("exchangerate"));
                    orderFin.set("settleamount", (Object)settleAmount);
                    orderFin.set("integralconsum", (Object)finEntry.getBigDecimal("integralconsum"));
                    orderFin.set("cardno", (Object)finEntry.getString("cardno"));
                    orderFin.set("ticketinfoid", (Object)finEntry.getDynamicObject("ticketinfoid"));
                    orderFin.set("tickettypeid", (Object)finEntry.getDynamicObject("tickettypeid"));
                    orderFin.set("referenceno", (Object)finEntry.getString("tradereference"));
                    orderFin.set("bankaccountno", (Object)finEntry.getString("bankaccountid"));
                    orderFin.set("orderno", (Object)finEntry.getString("orderno"));
                    orderFin.set("locsettleamount", (Object)settleAmount);
                }
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{orderBill});
        }
    }

    public static void updateSaleOrderFinCreditPay(long sourcebillId, long creditAccountId, BigDecimal returnAmount) {
        DynamicObject saleOrder = BusinessDataServiceHelper.loadSingle((Object)sourcebillId, (String)"ocpos_saleorder");
        DynamicObjectCollection finEntity = saleOrder.getDynamicObjectCollection("finentity");
        if (!CollectionUtils.isEmpty((Collection)finEntity)) {
            boolean isUpdate = false;
            for (DynamicObject finEntry : finEntity) {
                DynamicObject payWay = finEntry.getDynamicObject("setllementid");
                if (PaymentModeEnum.creditpay.getKey() != DynamicObjectUtils.getPkValue((DynamicObject)payWay)) continue;
                BigDecimal settleamount = finEntry.getBigDecimal("settleamount");
                BigDecimal alrsettleamount = finEntry.getBigDecimal("alrsettleamount");
                BigDecimal retsettleamount = finEntry.getBigDecimal("retsettleamount");
                retsettleamount = retsettleamount.add(returnAmount);
                BigDecimal notsettleamount = settleamount.subtract(alrsettleamount).add(retsettleamount);
                finEntry.set("retsettleamount", (Object)retsettleamount);
                finEntry.set("notsettleamount", (Object)notsettleamount);
                isUpdate = true;
                break;
            }
            if (isUpdate) {
                SaveServiceHelper.update((DynamicObject)saleOrder);
            }
        }
    }

    public static void updateSrcGiftQty(DynamicObject dataEntity, long billTypeId, Boolean isSubmit) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (DynamicObject entryEntity : entryEntities) {
            long srcEntryId;
            boolean isPresent;
            String saleOption;
            if (billTypeId == BillTypeEnum.CHANGE.getId() && StringUtils.equals((CharSequence)(saleOption = DynamicObjectUtils.getString((DynamicObject)entryEntity, (String)"saleoption")), (CharSequence)"1") || !(isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent")) || (srcEntryId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"srcbillentryid")) <= 0L) continue;
            BigDecimal qty = DynamicObjectUtils.getBigDecimal((DynamicObject)entryEntity, (String)"saleqty");
            Object[] param = new Object[]{qty.abs(), qty, srcEntryId};
            params.add(param);
        }
        if (!CollectionUtils.isEmpty(params)) {
            if (isSubmit.booleanValue()) {
                SaleOrderWriteBackHelper.updateSrcGiftEntryQtyBySubmit(billTypeId, params);
            } else {
                SaleOrderWriteBackHelper.updateSrcGiftEntryQtyByUnSubmit(billTypeId, params);
            }
        }
    }

    public static void updateGuideSrcGiftQty(DynamicObject dataEntity, Boolean isSubmit) {
        DynamicObjectCollection entryEntities = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)dataEntity, (String)"goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (DynamicObject entryEntity : entryEntities) {
            long srcEntryId;
            boolean isPresent = DynamicObjectUtils.getBoolean((DynamicObject)entryEntity, (String)"ispresent");
            if (!isPresent || (srcEntryId = DynamicObjectUtils.getLong((DynamicObject)entryEntity, (String)"srcbillentryid")) <= 0L) continue;
            Object[] param = new Object[]{isSubmit, srcEntryId};
            params.add(param);
        }
        if (!CollectionUtils.isEmpty(params)) {
            String sql = "update t_ocpos_saleorderitem_r set fispushdown = ? where fentryid = ?";
            DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql, params);
        }
    }

    public static void updateSrcGiftEntryQtyBySubmit(long billTypeId, List<Object[]> params) {
        StringBuilder sql = new StringBuilder();
        sql.append("update t_ocpos_saleorderitem_s set fmustretqty = fmustretqty - ?, ");
        if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            sql.append("ftosalesqty = ftosalesqty + ? ");
        } else {
            sql.append("fretqty = fretqty + ? ");
        }
        sql.append("where fentryid = ?");
        DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql.toString(), params);
    }

    public static void updateSrcGiftEntryQtyByUnSubmit(long billTypeId, List<Object[]> params) {
        StringBuilder sql = new StringBuilder();
        sql.append("update t_ocpos_saleorderitem_s set fmustretqty = fmustretqty + ?, ");
        if (billTypeId == BillTypeEnum.CVTSALE.getId()) {
            sql.append("ftosalesqty = ftosalesqty - ? ");
        } else {
            sql.append("fretqty = fretqty - ? ");
        }
        sql.append("where fentryid = ?");
        DB.executeBatch((DBRoute)DBRoute.of((String)"drp"), (String)sql.toString(), params);
    }

    public static void updateSaleOrderRetSendEntry(DynamicObject dataEntity, Map<Integer, DynamicObject> iniSrcSeqRetGoodsEntity, BigDecimal coefficientValue, String wbFieldKey) {
        if (iniSrcSeqRetGoodsEntity == null || iniSrcSeqRetGoodsEntity.size() == 0) {
            return;
        }
        long initialBillId = DynamicObjectUtils.getLong((DynamicObject)dataEntity, (String)"initialbillid");
        if (initialBillId == 0L) {
            return;
        }
        int mapSize = iniSrcSeqRetGoodsEntity.size();
        HashMap<Integer, BigDecimal> promSrcSeqRetQtyMap = new HashMap<Integer, BigDecimal>(mapSize);
        HashMap<Integer, BigDecimal> manualSrcSeqRetQtyMap = new HashMap<Integer, BigDecimal>(mapSize);
        for (Map.Entry<Integer, DynamicObject> seqRetGoodsEntity : iniSrcSeqRetGoodsEntity.entrySet()) {
            int iniSrcSeq = seqRetGoodsEntity.getKey();
            DynamicObject retGoodsEntry = seqRetGoodsEntity.getValue();
            boolean ispresent = retGoodsEntry.getBoolean("ispresent");
            if (!ispresent) continue;
            BigDecimal saleqty = retGoodsEntry.getBigDecimal("saleqty").multiply(coefficientValue);
            String gifttype = retGoodsEntry.getString("gifttype");
            if (StringUtils.equals((CharSequence)gifttype, (CharSequence)"3")) {
                promSrcSeqRetQtyMap.put(iniSrcSeq, saleqty);
                continue;
            }
            manualSrcSeqRetQtyMap.put(iniSrcSeq, saleqty);
        }
        DynamicObject initialBill = BusinessDataServiceHelper.loadSingle((Object)initialBillId, (String)"ocpos_saleorder");
        boolean isUpdate = false;
        HashMap<Integer, BigDecimal> iniSeqSyncAmount = new HashMap<Integer, BigDecimal>(0);
        if (promSrcSeqRetQtyMap.size() > 0) {
            SaleOrderWriteBackHelper.updateSaleOrderRetPromSendEntry(initialBill, promSrcSeqRetQtyMap, iniSeqSyncAmount, wbFieldKey);
            isUpdate = true;
        }
        if (manualSrcSeqRetQtyMap.size() > 0) {
            SaleOrderWriteBackHelper.updateSaleOrderRetManualSendEntry(initialBill, manualSrcSeqRetQtyMap, iniSeqSyncAmount, wbFieldKey);
            isUpdate = true;
        }
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject)initialBill);
            if (iniSeqSyncAmount.size() > 0) {
                SaleOrderWriteBackHelper.updateLinkDownCvtBillSendAmount(initialBillId, dataEntity, iniSeqSyncAmount, wbFieldKey);
            }
        }
    }

    public static void updateSaleOrderRetManualSendEntry(DynamicObject initialBill, Map<Integer, BigDecimal> manualSrcSeqRetQtyMap, Map<Integer, BigDecimal> iniSeqSyncAmount, String wbFieldKey) {
        int mapSize = manualSrcSeqRetQtyMap.size();
        HashMap<Integer, BigDecimal> sendSeqQtyMap = new HashMap<Integer, BigDecimal>(mapSize);
        HashMap<Integer, DynamicObject> seqGoodsEntryMap = new HashMap<Integer, DynamicObject>(mapSize);
        DynamicObjectCollection iniGoodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initialBill, (String)"goodsentryentity");
        for (DynamicObject goodsEntry : iniGoodsEntryEntity) {
            int seq = goodsEntry.getInt("seq");
            BigDecimal retSendQty = manualSrcSeqRetQtyMap.get(seq);
            if (retSendQty != null) {
                int promoteseq = goodsEntry.getInt("promoteseq");
                sendSeqQtyMap.put(promoteseq, retSendQty);
                continue;
            }
            boolean ispresent = goodsEntry.getBoolean("ispresent");
            if (ispresent) continue;
            seqGoodsEntryMap.put(seq, goodsEntry);
        }
        if (sendSeqQtyMap.size() == 0 || seqGoodsEntryMap.size() == 0) {
            return;
        }
        DynamicObjectCollection iniGoodSendEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initialBill, (String)"goodsendentity");
        if (CollectionUtils.isEmpty((Collection)iniGoodSendEntity)) {
            return;
        }
        for (DynamicObject goodSendEntry : iniGoodSendEntity) {
            String[] lstGoodsSeq;
            BigDecimal retSendAmount;
            int sendSeq = goodSendEntry.getInt("seq");
            BigDecimal giftprice = goodSendEntry.getBigDecimal("giftprice");
            BigDecimal retSendQty = (BigDecimal)sendSeqQtyMap.get(sendSeq);
            if (retSendQty == null || (retSendAmount = retSendQty.multiply(giftprice).setScale(2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) == 0) continue;
            BigDecimal balamountSum = BigDecimal.ZERO;
            ArrayList<DynamicObject> sendGoodsSeqEntryLst = new ArrayList<DynamicObject>(iniGoodSendEntity.size());
            String sendGoodSeq = goodSendEntry.getString("sendgoodsseq");
            for (String strGoodsSeq : lstGoodsSeq = sendGoodSeq.split(",")) {
                int goodsSeq = CommonUtil.formatStringToInt((String)strGoodsSeq);
                DynamicObject goodsEntry = (DynamicObject)seqGoodsEntryMap.get(goodsSeq);
                if (goodsEntry == null) continue;
                sendGoodsSeqEntryLst.add(goodsEntry);
                BigDecimal balamount = goodsEntry.getBigDecimal("balamount");
                balamountSum = balamountSum.add(balamount);
            }
            SaleOrderWriteBackHelper.updateShareRetBalamount(sendGoodsSeqEntryLst, iniSeqSyncAmount, balamountSum, retSendAmount, wbFieldKey);
        }
    }

    public static void updateSaleOrderRetPromSendEntry(DynamicObject initialBill, Map<Integer, BigDecimal> promSrcSeqRetQtyMap, Map<Integer, BigDecimal> iniSeqSyncAmount, String wbFieldKey) {
        BigDecimal retSendQty;
        int mapSize = promSrcSeqRetQtyMap.size();
        HashMap<Integer, BigDecimal> sendSeqQtyMap = new HashMap<Integer, BigDecimal>(mapSize);
        HashMap<Integer, DynamicObject> seqGoodsEntryMap = new HashMap<Integer, DynamicObject>(mapSize);
        DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)initialBill, (String)"goodsentryentity");
        for (DynamicObject goodsEntry : goodsEntryEntity) {
            int seq = goodsEntry.getInt("seq");
            retSendQty = promSrcSeqRetQtyMap.get(seq);
            if (retSendQty != null) {
                sendSeqQtyMap.put(seq, retSendQty);
                continue;
            }
            boolean ispresent = goodsEntry.getBoolean("ispresent");
            if (ispresent) continue;
            seqGoodsEntryMap.put(seq, goodsEntry);
        }
        if (sendSeqQtyMap.size() == 0 || seqGoodsEntryMap.size() == 0) {
            return;
        }
        block1: for (Map.Entry entry : sendSeqQtyMap.entrySet()) {
            int sendGoodsSeq = (Integer)entry.getKey();
            retSendQty = (BigDecimal)entry.getValue();
            boolean isMatch = false;
            for (DynamicObject goodsEntry : seqGoodsEntryMap.values()) {
                DynamicObjectCollection salesOrderPromoteEntity = goodsEntry.getDynamicObjectCollection("salesorderpromote");
                if (!CollectionUtils.isEmpty((Collection)salesOrderPromoteEntity)) {
                    BigDecimal retSendAmount;
                    BigDecimal promotegiftprice = BigDecimal.ZERO;
                    BigDecimal balamountSum = BigDecimal.ZERO;
                    ArrayList<DynamicObject> goodsEntryLst = new ArrayList<DynamicObject>(salesOrderPromoteEntity.size());
                    for (DynamicObject promoteSubEntry : salesOrderPromoteEntity) {
                        String[] lstExeGoodsSeq;
                        int promoteGoodsSeq = promoteSubEntry.getInt("promotegoodsseq");
                        if (sendGoodsSeq != promoteGoodsSeq) continue;
                        promotegiftprice = promoteSubEntry.getBigDecimal("promotegiftprice");
                        String exeGoodsSeq = promoteSubEntry.getString("exegoodsseq");
                        for (String strExeGoodsSeq : lstExeGoodsSeq = exeGoodsSeq.split(",")) {
                            int goodsSeq = CommonUtil.formatStringToInt((String)strExeGoodsSeq);
                            DynamicObject proGoodsEntry = (DynamicObject)seqGoodsEntryMap.get(goodsSeq);
                            if (proGoodsEntry == null) continue;
                            goodsEntryLst.add(proGoodsEntry);
                            BigDecimal balamount = proGoodsEntry.getBigDecimal("balamount");
                            balamountSum = balamountSum.add(balamount);
                        }
                        isMatch = true;
                        break;
                    }
                    if ((retSendAmount = retSendQty.multiply(promotegiftprice).setScale(2, RoundingMode.HALF_UP)).compareTo(BigDecimal.ZERO) == 0) continue;
                    SaleOrderWriteBackHelper.updateShareRetBalamount(goodsEntryLst, iniSeqSyncAmount, balamountSum, retSendAmount, wbFieldKey);
                }
                if (!isMatch) continue;
                continue block1;
            }
        }
    }

    public static void updateShareRetBalamount(List<DynamicObject> goodsEntryLst, Map<Integer, BigDecimal> iniSeqSyncAmount, BigDecimal balamountSum, BigDecimal retSendAmount, String wbFieldKey) {
        if (balamountSum.compareTo(BigDecimal.ZERO) != 0 && !CollectionUtils.isEmpty(goodsEntryLst)) {
            BigDecimal surplusAmount = retSendAmount;
            int rowSize = goodsEntryLst.size();
            for (DynamicObject goodsEntry : goodsEntryLst) {
                BigDecimal shareRetBalamount;
                int seq = goodsEntry.getInt("seq");
                BigDecimal adretgiftdiscamount = goodsEntry.getBigDecimal(wbFieldKey);
                BigDecimal balamount = goodsEntry.getBigDecimal("balamount");
                if (rowSize == 1) {
                    shareRetBalamount = surplusAmount;
                } else {
                    shareRetBalamount = balamount.multiply(retSendAmount).divide(balamountSum, 2, RoundingMode.HALF_UP);
                    surplusAmount = surplusAmount.subtract(shareRetBalamount);
                }
                BigDecimal seqSyncAmount = iniSeqSyncAmount.get(seq);
                seqSyncAmount = seqSyncAmount == null ? shareRetBalamount : seqSyncAmount.add(shareRetBalamount);
                iniSeqSyncAmount.put(seq, seqSyncAmount);
                adretgiftdiscamount = adretgiftdiscamount.add(shareRetBalamount);
                goodsEntry.set(wbFieldKey, (Object)adretgiftdiscamount);
                BigDecimal sumsharediscount = goodsEntry.getBigDecimal("sumsharediscount");
                goodsEntry.set("sumsharediscount", (Object)sumsharediscount.add(shareRetBalamount));
                --rowSize;
            }
        }
    }

    public static void updateLinkDownCvtBillSendAmount(long initialBillId, DynamicObject dataEntity, Map<Integer, BigDecimal> iniSeqSyncAmount, String syncFieldKey) {
        DynamicObject[] cvtBills;
        HashSet targetBillIdSet;
        if (initialBillId == 0L || iniSeqSyncAmount == null || iniSeqSyncAmount.size() == 0) {
            return;
        }
        long billId = DynamicObjectUtils.getPkValue((DynamicObject)dataEntity);
        String bizType = DynamicObjectUtils.getString((DynamicObject)dataEntity, (String)"biztype");
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_saleorder", (Long[])new Long[]{initialBillId});
        if (targetBills != null && targetBills.size() > 0 && (targetBillIdSet = (HashSet)targetBills.get("ocpos_saleorder")) != null && targetBillIdSet.size() > 0 && (cvtBills = BusinessDataServiceHelper.load((Object[])targetBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocpos_saleorder"))) != null && cvtBills.length > 0) {
            ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(cvtBills.length);
            for (DynamicObject cvtBill : cvtBills) {
                boolean isUpdateBill = false;
                DynamicObjectCollection goodsEntryEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)cvtBill, (String)"goodsentryentity");
                for (DynamicObject goodsEntry : goodsEntryEntity) {
                    BigDecimal adretgiftdiscamount;
                    BigDecimal syncAmount;
                    int iniSrcSeq = DynamicObjectUtils.getInt((DynamicObject)goodsEntry, (String)"inisrcseq");
                    if (iniSrcSeq == 0) {
                        iniSrcSeq = goodsEntry.getInt("srcseq");
                    }
                    if ((syncAmount = iniSeqSyncAmount.get(iniSrcSeq)) == null) continue;
                    boolean isPresent = goodsEntry.getBoolean("ispresent");
                    if (!isPresent) {
                        adretgiftdiscamount = goodsEntry.getBigDecimal(syncFieldKey);
                        BigDecimal srcSaleQty = goodsEntry.getBigDecimal("srcsaleqty");
                        BigDecimal saleQty = goodsEntry.getBigDecimal("saleqty");
                        BigDecimal linkCvtSyncAmount = syncAmount.multiply(saleQty).divide(srcSaleQty, 2, RoundingMode.HALF_UP);
                        goodsEntry.set(syncFieldKey, (Object)adretgiftdiscamount.add(linkCvtSyncAmount));
                        BigDecimal sumsharediscount = goodsEntry.getBigDecimal("sumsharediscount");
                        goodsEntry.set("sumsharediscount", (Object)sumsharediscount.add(linkCvtSyncAmount));
                        isUpdateBill = true;
                        continue;
                    }
                    if ((!StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"C") || billId != DynamicObjectUtils.getPkValue((DynamicObject)cvtBill)) && !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"B") && !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"R") && !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"Q") && !StringUtils.equalsIgnoreCase((CharSequence)bizType, (CharSequence)"H")) continue;
                    adretgiftdiscamount = goodsEntry.getBigDecimal(syncFieldKey);
                    goodsEntry.set(syncFieldKey, (Object)adretgiftdiscamount.add(syncAmount));
                    BigDecimal sumsharediscount = goodsEntry.getBigDecimal("sumsharediscount");
                    goodsEntry.set("sumsharediscount", (Object)sumsharediscount.add(syncAmount));
                    isUpdateBill = true;
                }
                if (!isUpdateBill) continue;
                updateBills.add(cvtBill);
            }
            if (updateBills.size() > 0) {
                SaveServiceHelper.update((DynamicObject[])updateBills.toArray(new DynamicObject[0]));
            }
        }
    }

    public static void updateIniSouceBillSendValue(DynamicObject iniSourceBill, Map<Integer, Object> iniSeqSyncValue, String entryKey, String syncFieldKey, boolean isCoverValue, DynamicObject doGoodsEntry, boolean isSubEntry) {
        if (iniSourceBill == null || iniSeqSyncValue == null || iniSeqSyncValue.size() == 0) {
            return;
        }
        if (!isSubEntry) {
            DynamicObjectCollection iniKeyEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSourceBill, (String)entryKey);
            for (DynamicObject entry : iniKeyEntity) {
                int seq = entry.getInt("seq");
                Object syncValue = iniSeqSyncValue.get(seq);
                if (syncValue == null) continue;
                if (isCoverValue) {
                    boolean bIsExe;
                    if (StringUtils.equals((CharSequence)syncFieldKey, (CharSequence)"ticketrettype") && (bIsExe = DynamicObjectUtils.getBoolean((DynamicObject)entry, (String)"tisexecute")) && StringUtils.equals((CharSequence)syncValue.toString(), (CharSequence)"T") || StringUtils.equals((CharSequence)syncFieldKey, (CharSequence)"pointrettype") && (bIsExe = DynamicObjectUtils.getBoolean((DynamicObject)entry, (String)"insisexecute")) && StringUtils.equals((CharSequence)syncValue.toString(), (CharSequence)"T")) continue;
                    entry.set(syncFieldKey, syncValue);
                    continue;
                }
                BigDecimal oldValue = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)syncFieldKey);
                entry.set(syncFieldKey, (Object)oldValue.add(CommonUtil.formatObjectToDecimal((Object)syncValue)));
                BigDecimal manualDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"manualdiscount");
                BigDecimal promotionDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"promotiondiscount");
                BigDecimal couponDiscount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"coupondiscount");
                BigDecimal integralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"integraldistamount");
                BigDecimal giftDiscountAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"giftdiscountamount");
                BigDecimal sumShareDiscount = manualDiscount.add(promotionDiscount).add(couponDiscount).add(integralDistAmount).add(giftDiscountAmount);
                BigDecimal adRetGiftDiscAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"adretgiftdiscamount");
                BigDecimal adRetCouponDiscAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"adretcoupondiscamount");
                BigDecimal adRetIntegralDistAmount = DynamicObjectUtils.getBigDecimal((DynamicObject)entry, (String)"adretintegraldistamount");
                sumShareDiscount = sumShareDiscount.subtract(adRetGiftDiscAmount.abs()).subtract(adRetCouponDiscAmount.abs()).subtract(adRetIntegralDistAmount.abs());
                entry.set("sumsharediscount", (Object)sumShareDiscount);
            }
        } else {
            if (doGoodsEntry == null) {
                return;
            }
            DynamicObjectCollection iniGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniSourceBill, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)iniGoodsEntryCollection)) {
                return;
            }
            for (DynamicObject iniGoodsEntry : iniGoodsEntryCollection) {
                DynamicObjectCollection iniSubEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniGoodsEntry, (String)entryKey);
                if (CollectionUtils.isEmpty((Collection)iniSubEntryCollection)) {
                    return;
                }
                for (Map.Entry<Integer, Object> subItem : iniSeqSyncValue.entrySet()) {
                    DynamicObject doPromote = (DynamicObject)subItem.getValue();
                    if (doPromote == null) continue;
                    long promotionId = DynamicObjectUtils.getLong((DynamicObject)doPromote, (String)"promotionactid");
                    long promoteGoodsId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"promotegoodsid");
                    long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"pointtype");
                    long couponTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"coupontype");
                    Object syncValue = DynamicObjectUtils.get((DynamicObject)doPromote, (String)syncFieldKey);
                    DynamicObject subEntry = iniSubEntryCollection.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"promotegoodsid") == promoteGoodsId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"coupontype") == couponTypeId).findFirst().orElse(null);
                    if (subEntry == null) continue;
                    if (isCoverValue) {
                        boolean bIsExe;
                        if ((pointTypeId > 0L || couponTypeId > 0L) && (bIsExe = DynamicObjectUtils.getBoolean((DynamicObject)subEntry, (String)"isgift")) && StringUtils.equals((CharSequence)syncValue.toString(), (CharSequence)"T")) continue;
                        subEntry.set(syncFieldKey, syncValue);
                        continue;
                    }
                    BigDecimal oldValue = DynamicObjectUtils.getBigDecimal((DynamicObject)subEntry, (String)syncFieldKey);
                    subEntry.set(syncFieldKey, (Object)oldValue.add(CommonUtil.formatObjectToDecimal((Object)syncValue)));
                }
            }
        }
    }

    public static DynamicObject[] getLinkDownCvtBills(long iniSourceBillId, long billId, boolean isRemoveBillId) {
        HashSet targetBillIdSet;
        if (iniSourceBillId <= 0L) {
            return null;
        }
        DynamicObject[] cvtBills = null;
        Map targetBills = BFTrackerServiceHelper.findTargetBills((String)"ocpos_saleorder", (Long[])new Long[]{iniSourceBillId});
        if (targetBills != null && targetBills.size() > 0 && (targetBillIdSet = (HashSet)targetBills.get("ocpos_saleorder")) != null && targetBillIdSet.size() > 0) {
            if (isRemoveBillId) {
                targetBillIdSet.remove(billId);
            }
            if (targetBillIdSet.size() > 0) {
                cvtBills = BusinessDataServiceHelper.load((Object[])targetBillIdSet.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)"ocpos_saleorder"));
            }
        }
        return cvtBills;
    }

    public static void updateLinkDownCvtBillSendValue(DynamicObject[] cvtBills, Map<Integer, Object> iniSeqSyncValue, String entryKey, String syncFieldKey, boolean isCoverValue, DynamicObject doGoodsEntry, boolean isSubEntry) {
        if (cvtBills == null || cvtBills.length == 0 || iniSeqSyncValue == null || iniSeqSyncValue.size() == 0) {
            return;
        }
        for (DynamicObject cvtBill : cvtBills) {
            if (!isSubEntry) {
                DynamicObjectCollection cvtKeyEntity = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)cvtBill, (String)entryKey);
                for (DynamicObject cvtEntry : cvtKeyEntity) {
                    int seq = cvtEntry.getInt("seq");
                    Object syncValue = iniSeqSyncValue.get(seq);
                    if (syncValue == null) continue;
                    if (isCoverValue) {
                        cvtEntry.set(syncFieldKey, syncValue);
                        continue;
                    }
                    BigDecimal oldValue = cvtEntry.getBigDecimal(syncFieldKey);
                    cvtEntry.set(syncFieldKey, (Object)oldValue.add(CommonUtil.formatObjectToDecimal((Object)syncValue)));
                }
            }
            if (doGoodsEntry == null) {
                return;
            }
            int srcSeq = DynamicObjectUtils.getInt((DynamicObject)doGoodsEntry, (String)"srcseq");
            DynamicObjectCollection iniGoodsEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)cvtBill, (String)"goodsentryentity");
            if (CollectionUtils.isEmpty((Collection)iniGoodsEntryCollection)) {
                return;
            }
            DynamicObject iniGoodsEntry = iniGoodsEntryCollection.stream().filter(x -> DynamicObjectUtils.getInt((DynamicObject)x, (String)"seq") == srcSeq).findFirst().orElse(null);
            if (iniGoodsEntry == null) {
                return;
            }
            DynamicObjectCollection iniSubEntryCollection = DynamicObjectUtils.getDynamicObjectCollection((DynamicObject)iniGoodsEntry, (String)entryKey);
            if (CollectionUtils.isEmpty((Collection)iniSubEntryCollection)) {
                return;
            }
            for (Map.Entry<Integer, Object> subItem : iniSeqSyncValue.entrySet()) {
                DynamicObject doPromote = (DynamicObject)subItem.getValue();
                if (doPromote == null) continue;
                long promotionId = DynamicObjectUtils.getLong((DynamicObject)doPromote, (String)"promotionactid");
                long pointTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"pointtype");
                long couponTypeId = DynamicObjectUtils.getPkValue((DynamicObject)doPromote, (String)"coupontype");
                Object syncValue = DynamicObjectUtils.get((DynamicObject)doPromote, (String)syncFieldKey);
                DynamicObject subEntry = iniSubEntryCollection.stream().filter(x -> DynamicObjectUtils.getLong((DynamicObject)x, (String)"promotionactid") == promotionId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"pointtype") == pointTypeId && DynamicObjectUtils.getPkValue((DynamicObject)x, (String)"coupontype") == couponTypeId).findFirst().orElse(null);
                if (subEntry == null) continue;
                if (isCoverValue) {
                    subEntry.set(syncFieldKey, syncValue);
                    continue;
                }
                BigDecimal oldValue = DynamicObjectUtils.getBigDecimal((DynamicObject)subEntry, (String)syncFieldKey);
                subEntry.set(syncFieldKey, (Object)oldValue.add(CommonUtil.formatObjectToDecimal((Object)syncValue)));
            }
        }
    }

    public static void updateSourceBillGiftCloseStatus(DynamicObject dataEntity, List<Integer> goodsEntrySrcSeqs, String rowCloseStatus) {
        DynamicObjectCollection entryEntities = dataEntity.getDynamicObjectCollection("goodsentryentity");
        if (CollectionUtils.isEmpty((Collection)entryEntities)) {
            return;
        }
        DynamicObjectCollection goodsendentity = dataEntity.getDynamicObjectCollection("goodsendentity");
        if (CollectionUtils.isEmpty((Collection)goodsendentity)) {
            return;
        }
        ArrayList<Integer> closeGoodsEntrySendSeqs = new ArrayList<Integer>();
        block0: for (DynamicObject sendEntry : goodsendentity) {
            String[] lstGoodsSeq;
            String sendgoodsseq = DynamicObjectUtils.getString((DynamicObject)sendEntry, (String)"sendgoodsseq");
            for (String strGoodsSeq : lstGoodsSeq = sendgoodsseq.split(",")) {
                int goodsSeq = CommonUtil.formatStringToInt((String)strGoodsSeq);
                if (goodsSeq <= 0 || !goodsEntrySrcSeqs.contains(goodsSeq)) continue;
                int sendSeq = DynamicObjectUtils.getInt((DynamicObject)sendEntry, (String)"seq");
                closeGoodsEntrySendSeqs.add(sendSeq);
                continue block0;
            }
        }
        boolean isUpdate = false;
        for (DynamicObject entryEntity : entryEntities) {
            int promoteseq = DynamicObjectUtils.getInt((DynamicObject)entryEntity, (String)"promoteseq");
            boolean ispresent = entryEntity.getBoolean("ispresent");
            if (!ispresent || closeGoodsEntrySendSeqs.size() <= 0 || promoteseq <= 0 || !closeGoodsEntrySendSeqs.contains(promoteseq)) continue;
            entryEntity.set("rowclosestatus", (Object)rowCloseStatus);
            isUpdate = true;
        }
        if (isUpdate) {
            SaveServiceHelper.update((DynamicObject)dataEntity);
        }
    }

    public static void addSaleChangeFinEntityAndPaymentFlow(DynamicObject dataEntity, String tgtBillName, BigDecimal exchangePayAmount, String saleOrderStatus) {
        String saleOption = "1";
        dataEntity.set("orderstatus", (Object)saleOrderStatus);
        dataEntity.set("salestatus", (Object)SaleStatusEnum.STATUS_S.getValue());
        if (StringUtils.equalsIgnoreCase((CharSequence)tgtBillName, (CharSequence)"ocpos_saleorder_return")) {
            exchangePayAmount = exchangePayAmount.negate();
            saleOption = "0";
        }
        DynamicObjectCollection finEntities = dataEntity.getDynamicObjectCollection("finentity");
        finEntities.removeIf(c -> c.getDynamicObject("setllementid") == null && c.getBigDecimal("settleamount").compareTo(BigDecimal.ZERO) == 0);
        Date payTime = TimeServiceHelper.now();
        DynamicObject currency = dataEntity.getDynamicObject("currencyid");
        DynamicObject settlement = BusinessDataServiceHelper.loadSingle((Object)27L, (String)"ocdbd_paymode");
        DynamicObject payWayType = DynamicObjectUtils.getDynamicObjectById((Object)1073191011683124224L, (String)"ocdbd_paywaytype");
        HashMap<String, Object> paymentMap = new HashMap<String, Object>();
        paymentMap.put("saleorg", DynamicObjectUtil.getDynamicObject((DynamicObject)dataEntity, (String)"bizorgid"));
        paymentMap.put("branch", DynamicObjectUtil.getDynamicObject((DynamicObject)dataEntity, (String)"salebranchid"));
        paymentMap.put("billid", dataEntity.getPkValue());
        paymentMap.put("billno", dataEntity.getString("billno"));
        paymentMap.put("sourcebillid", dataEntity.getLong("sourcebillid"));
        paymentMap.put("settlement", settlement);
        paymentMap.put("paywaytype", payWayType);
        paymentMap.put("settleamount", exchangePayAmount);
        paymentMap.put("currency", currency);
        paymentMap.put("paytime", payTime);
        paymentMap.put("payoption", saleOption);
        paymentMap.put("paystatus", "A");
        PaymentFlowHelper.insertPaymentFlow(paymentMap);
        DynamicObject finEntity = finEntities.addNew();
        finEntity.set("setllementid", (Object)settlement);
        finEntity.set("settlecurrid", (Object)currency);
        finEntity.set("paywaytypeid", (Object)payWayType);
        finEntity.set("exchangerate", (Object)1);
        finEntity.set("settleamount", (Object)exchangePayAmount);
        finEntity.set("paytime", (Object)payTime);
        finEntity.set("settlementrate", (Object)1);
        finEntity.set("stmamount", (Object)exchangePayAmount);
        finEntity.set("isinsalesincome", (Object)DynamicObjectUtils.getBoolean((DynamicObject)settlement, (String)"isinsalesincome"));
        long sourceBillId = DynamicObjectUtil.getLong((DynamicObject)dataEntity, (String)"sourcebillid");
        if (sourceBillId > 0L) {
            SaleOrderWriteBackHelper.addSaleOrderAndReturnFinEntity(dataEntity, tgtBillName, finEntities, sourceBillId, exchangePayAmount);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{dataEntity});
    }

    private static void addSaleOrderAndReturnFinEntity(DynamicObject dataEntity, String tgtBillName, DynamicObjectCollection finEntities, long sourceBillId, BigDecimal exchangePayAmount) {
        BigDecimal totalrealamount = exchangePayAmount;
        String selectFields = "finentity.settleamount,finentity.setllementid,finentity.paywaytypeid,finentity.settlecurrid,finentity.exchangerate,finentity.creditaccountid,finentity.creditflowid,finentity.notsettleamount,finentity.receivabledate,finentity.paytime,finentity.integralconsum,finentity.cardno,finentity.tickettypeid,finentity.ticketinfoid,finentity.cardtypeid,finentity.tradereference,finentity.bankaccountid,finentity.orderno,finentity.stmamount,finentity.settlementrate,finentity.isinsalesincome,finentity.setllementid";
        DynamicObject sourceBill = BusinessDataServiceHelper.loadSingle((Object)sourceBillId, (String)"ocpos_salechange", (String)selectFields);
        DynamicObjectCollection srcFinEntities = sourceBill.getDynamicObjectCollection("finentity");
        if (CollectionUtils.isEmpty((Collection)srcFinEntities)) {
            dataEntity.set("totalrealamount", (Object)totalrealamount);
            return;
        }
        for (DynamicObject srcFinEntry : srcFinEntities) {
            DynamicObject finentity;
            BigDecimal settleAmount = srcFinEntry.getBigDecimal("settleamount");
            if (settleAmount.compareTo(BigDecimal.ZERO) > 0 && StringUtils.equalsIgnoreCase((CharSequence)tgtBillName, (CharSequence)"ocpos_saleorder")) {
                finentity = finEntities.addNew();
                finentity.set("setllementid", srcFinEntry.get("setllementid"));
                finentity.set("paywaytypeid", srcFinEntry.get("paywaytypeid"));
                finentity.set("settlecurrid", srcFinEntry.get("settlecurrid"));
                finentity.set("exchangerate", srcFinEntry.get("exchangerate"));
                finentity.set("settleamount", (Object)settleAmount);
                finentity.set("creditaccountid", srcFinEntry.get("creditaccountid"));
                finentity.set("creditflowid", srcFinEntry.get("creditflowid"));
                finentity.set("notsettleamount", srcFinEntry.get("notsettleamount"));
                finentity.set("receivabledate", srcFinEntry.get("receivabledate"));
                finentity.set("paytime", srcFinEntry.get("paytime"));
                finentity.set("integralconsum", srcFinEntry.get("integralconsum"));
                finentity.set("cardno", srcFinEntry.get("cardno"));
                finentity.set("tickettypeid", srcFinEntry.get("tickettypeid"));
                finentity.set("ticketinfoid", srcFinEntry.get("ticketinfoid"));
                finentity.set("cardtypeid", srcFinEntry.get("cardtypeid"));
                finentity.set("tradereference", srcFinEntry.get("tradereference"));
                finentity.set("bankaccountid", srcFinEntry.get("bankaccountid"));
                finentity.set("orderno", srcFinEntry.get("orderno"));
                finentity.set("stmamount", srcFinEntry.get("stmamount"));
                finentity.set("settlementrate", srcFinEntry.get("settlementrate"));
                finentity.set("isinsalesincome", srcFinEntry.get("isinsalesincome"));
                totalrealamount = totalrealamount.add(settleAmount);
                continue;
            }
            if (settleAmount.compareTo(BigDecimal.ZERO) >= 0 || !StringUtils.equalsIgnoreCase((CharSequence)tgtBillName, (CharSequence)"ocpos_saleorder_return")) continue;
            finentity = finEntities.addNew();
            finentity.set("setllementid", srcFinEntry.get("setllementid"));
            finentity.set("paywaytypeid", srcFinEntry.get("paywaytypeid"));
            finentity.set("settlecurrid", srcFinEntry.get("settlecurrid"));
            finentity.set("exchangerate", srcFinEntry.get("exchangerate"));
            finentity.set("settleamount", (Object)settleAmount);
            finentity.set("notsettleamount", srcFinEntry.get("notsettleamount"));
            finentity.set("paytime", srcFinEntry.get("paytime"));
            finentity.set("integralconsum", srcFinEntry.get("integralconsum"));
            finentity.set("cardno", srcFinEntry.get("cardno"));
            finentity.set("tickettypeid", srcFinEntry.get("tickettypeid"));
            finentity.set("ticketinfoid", srcFinEntry.get("ticketinfoid"));
            finentity.set("cardtypeid", srcFinEntry.get("cardtypeid"));
            finentity.set("tradereference", srcFinEntry.get("tradereference"));
            finentity.set("bankaccountid", srcFinEntry.get("bankaccountid"));
            finentity.set("orderno", srcFinEntry.get("orderno"));
            finentity.set("stmamount", srcFinEntry.get("stmamount"));
            finentity.set("settlementrate", srcFinEntry.get("settlementrate"));
            finentity.set("isinsalesincome", srcFinEntry.get("isinsalesincome"));
            totalrealamount = totalrealamount.add(settleAmount);
        }
        dataEntity.set("totalrealamount", (Object)totalrealamount);
    }
}

